"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulkIdResponseDto = exports.BulkIdsDto = exports.BulkIdErrorReason = exports.AssetIdsResponseDto = exports.AssetIdErrorReason = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const validation_1 = require("../validation");
var AssetIdErrorReason;
(function (AssetIdErrorReason) {
    AssetIdErrorReason["DUPLICATE"] = "duplicate";
    AssetIdErrorReason["NO_PERMISSION"] = "no_permission";
    AssetIdErrorReason["NOT_FOUND"] = "not_found";
})(AssetIdErrorReason || (exports.AssetIdErrorReason = AssetIdErrorReason = {}));
class AssetIdsResponseDto {
    assetId;
    success;
    error;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, success: { required: true, type: () => Boolean }, error: { required: false, enum: require("./asset-ids.response.dto").AssetIdErrorReason } };
    }
}
exports.AssetIdsResponseDto = AssetIdsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Asset ID' }),
    __metadata("design:type", String)
], AssetIdsResponseDto.prototype, "assetId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether operation succeeded' }),
    __metadata("design:type", Boolean)
], AssetIdsResponseDto.prototype, "success", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Error reason if failed', enum: AssetIdErrorReason }),
    __metadata("design:type", String)
], AssetIdsResponseDto.prototype, "error", void 0);
var BulkIdErrorReason;
(function (BulkIdErrorReason) {
    BulkIdErrorReason["DUPLICATE"] = "duplicate";
    BulkIdErrorReason["NO_PERMISSION"] = "no_permission";
    BulkIdErrorReason["NOT_FOUND"] = "not_found";
    BulkIdErrorReason["UNKNOWN"] = "unknown";
})(BulkIdErrorReason || (exports.BulkIdErrorReason = BulkIdErrorReason = {}));
class BulkIdsDto {
    ids;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] } };
    }
}
exports.BulkIdsDto = BulkIdsDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'IDs to process' }),
    __metadata("design:type", Array)
], BulkIdsDto.prototype, "ids", void 0);
class BulkIdResponseDto {
    id;
    success;
    error;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, success: { required: true, type: () => Boolean }, error: { required: false, enum: require("./asset-ids.response.dto").BulkIdErrorReason } };
    }
}
exports.BulkIdResponseDto = BulkIdResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'ID' }),
    __metadata("design:type", String)
], BulkIdResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Whether operation succeeded' }),
    __metadata("design:type", Boolean)
], BulkIdResponseDto.prototype, "success", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Error reason if failed', enum: BulkIdErrorReason }),
    __metadata("design:type", String)
], BulkIdResponseDto.prototype, "error", void 0);
//# sourceMappingURL=asset-ids.response.dto.js.map