import { Library } from 'src/database';
export declare class CreateLibraryDto {
    ownerId: string;
    name?: string;
    importPaths?: string[];
    exclusionPatterns?: string[];
}
export declare class UpdateLibraryDto {
    name?: string;
    importPaths?: string[];
    exclusionPatterns?: string[];
}
export interface CrawlOptionsDto {
    pathsToCrawl: string[];
    includeHidden?: boolean;
    exclusionPatterns?: string[];
}
export interface WalkOptionsDto extends CrawlOptionsDto {
    take: number;
}
export declare class ValidateLibraryDto {
    importPaths?: string[];
    exclusionPatterns?: string[];
}
export declare class ValidateLibraryResponseDto {
    importPaths?: ValidateLibraryImportPathResponseDto[];
}
export declare class ValidateLibraryImportPathResponseDto {
    importPath: string;
    isValid: boolean;
    message?: string;
}
export declare class LibrarySearchDto {
    userId?: string;
}
export declare class LibraryResponseDto {
    id: string;
    ownerId: string;
    name: string;
    assetCount: number;
    importPaths: string[];
    exclusionPatterns: string[];
    createdAt: Date;
    updatedAt: Date;
    refreshedAt: Date | null;
}
export declare class LibraryStatsResponseDto {
    photos: number;
    videos: number;
    total: number;
    usage: number;
}
export declare function mapLibrary(entity: Library): LibraryResponseDto;
