import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AlbumUserRole, AssetOrder, AssetType, AssetVisibility, MemoryType, SyncEntityType, SyncRequestType, UserAvatarColor, UserMetadataKey } from 'src/enum';
import { UserMetadata } from 'src/types';
export declare class AssetFullSyncDto {
    lastId?: string;
    updatedUntil: Date;
    limit: number;
    userId?: string;
}
export declare class AssetDeltaSyncDto {
    updatedAfter: Date;
    userIds: string[];
}
export declare class AssetDeltaSyncResponseDto {
    needsFullSync: boolean;
    upserted: AssetResponseDto[];
    deleted: string[];
}
export declare const extraSyncModels: Function[];
export declare const ExtraModel: () => ClassDecorator;
export declare class SyncUserV1 {
    id: string;
    name: string;
    email: string;
    avatarColor: UserAvatarColor | null;
    deletedAt: Date | null;
    hasProfileImage: boolean;
    profileChangedAt: Date;
}
export declare class SyncAuthUserV1 extends SyncUserV1 {
    isAdmin: boolean;
    pinCode: string | null;
    oauthId: string;
    storageLabel: string | null;
    quotaSizeInBytes: number | null;
    quotaUsageInBytes: number;
}
export declare class SyncUserDeleteV1 {
    userId: string;
}
export declare class SyncPartnerV1 {
    sharedById: string;
    sharedWithId: string;
    inTimeline: boolean;
}
export declare class SyncPartnerDeleteV1 {
    sharedById: string;
    sharedWithId: string;
}
export declare class SyncAssetV1 {
    id: string;
    ownerId: string;
    originalFileName: string;
    thumbhash: string | null;
    checksum: string;
    fileCreatedAt: Date | null;
    fileModifiedAt: Date | null;
    localDateTime: Date | null;
    duration: string | null;
    type: AssetType;
    deletedAt: Date | null;
    isFavorite: boolean;
    visibility: AssetVisibility;
    livePhotoVideoId: string | null;
    stackId: string | null;
    libraryId: string | null;
    width: number | null;
    height: number | null;
    isEdited: boolean;
}
export declare class SyncAssetDeleteV1 {
    assetId: string;
}
export declare class SyncAssetExifV1 {
    assetId: string;
    description: string | null;
    exifImageWidth: number | null;
    exifImageHeight: number | null;
    fileSizeInByte: number | null;
    orientation: string | null;
    dateTimeOriginal: Date | null;
    modifyDate: Date | null;
    timeZone: string | null;
    latitude: number | null;
    longitude: number | null;
    projectionType: string | null;
    city: string | null;
    state: string | null;
    country: string | null;
    make: string | null;
    model: string | null;
    lensModel: string | null;
    fNumber: number | null;
    focalLength: number | null;
    iso: number | null;
    exposureTime: string | null;
    profileDescription: string | null;
    rating: number | null;
    fps: number | null;
}
export declare class SyncAssetMetadataV1 {
    assetId: string;
    key: string;
    value: object;
}
export declare class SyncAssetMetadataDeleteV1 {
    assetId: string;
    key: string;
}
export declare class SyncAlbumDeleteV1 {
    albumId: string;
}
export declare class SyncAlbumUserDeleteV1 {
    albumId: string;
    userId: string;
}
export declare class SyncAlbumUserV1 {
    albumId: string;
    userId: string;
    role: AlbumUserRole;
}
export declare class SyncAlbumV1 {
    id: string;
    ownerId: string;
    name: string;
    description: string;
    createdAt: Date;
    updatedAt: Date;
    thumbnailAssetId: string | null;
    isActivityEnabled: boolean;
    order: AssetOrder;
}
export declare class SyncAlbumToAssetV1 {
    albumId: string;
    assetId: string;
}
export declare class SyncAlbumToAssetDeleteV1 {
    albumId: string;
    assetId: string;
}
export declare class SyncMemoryV1 {
    id: string;
    createdAt: Date;
    updatedAt: Date;
    deletedAt: Date | null;
    ownerId: string;
    type: MemoryType;
    data: object;
    isSaved: boolean;
    memoryAt: Date;
    seenAt: Date | null;
    showAt: Date | null;
    hideAt: Date | null;
}
export declare class SyncMemoryDeleteV1 {
    memoryId: string;
}
export declare class SyncMemoryAssetV1 {
    memoryId: string;
    assetId: string;
}
export declare class SyncMemoryAssetDeleteV1 {
    memoryId: string;
    assetId: string;
}
export declare class SyncStackV1 {
    id: string;
    createdAt: Date;
    updatedAt: Date;
    primaryAssetId: string;
    ownerId: string;
}
export declare class SyncStackDeleteV1 {
    stackId: string;
}
export declare class SyncPersonV1 {
    id: string;
    createdAt: Date;
    updatedAt: Date;
    ownerId: string;
    name: string;
    birthDate: Date | null;
    isHidden: boolean;
    isFavorite: boolean;
    color: string | null;
    faceAssetId: string | null;
}
export declare class SyncPersonDeleteV1 {
    personId: string;
}
export declare class SyncAssetFaceV1 {
    id: string;
    assetId: string;
    personId: string | null;
    imageWidth: number;
    imageHeight: number;
    boundingBoxX1: number;
    boundingBoxY1: number;
    boundingBoxX2: number;
    boundingBoxY2: number;
    sourceType: string;
}
export declare class SyncAssetFaceDeleteV1 {
    assetFaceId: string;
}
export declare class SyncUserMetadataV1 {
    userId: string;
    key: UserMetadataKey;
    value: UserMetadata[UserMetadataKey];
}
export declare class SyncUserMetadataDeleteV1 {
    userId: string;
    key: UserMetadataKey;
}
export declare class SyncAckV1 {
}
export declare class SyncResetV1 {
}
export declare class SyncCompleteV1 {
}
export type SyncItem = {
    [SyncEntityType.AuthUserV1]: SyncAuthUserV1;
    [SyncEntityType.UserV1]: SyncUserV1;
    [SyncEntityType.UserDeleteV1]: SyncUserDeleteV1;
    [SyncEntityType.PartnerV1]: SyncPartnerV1;
    [SyncEntityType.PartnerDeleteV1]: SyncPartnerDeleteV1;
    [SyncEntityType.AssetV1]: SyncAssetV1;
    [SyncEntityType.AssetDeleteV1]: SyncAssetDeleteV1;
    [SyncEntityType.AssetMetadataV1]: SyncAssetMetadataV1;
    [SyncEntityType.AssetMetadataDeleteV1]: SyncAssetMetadataDeleteV1;
    [SyncEntityType.AssetExifV1]: SyncAssetExifV1;
    [SyncEntityType.PartnerAssetV1]: SyncAssetV1;
    [SyncEntityType.PartnerAssetBackfillV1]: SyncAssetV1;
    [SyncEntityType.PartnerAssetDeleteV1]: SyncAssetDeleteV1;
    [SyncEntityType.PartnerAssetExifV1]: SyncAssetExifV1;
    [SyncEntityType.PartnerAssetExifBackfillV1]: SyncAssetExifV1;
    [SyncEntityType.AlbumV1]: SyncAlbumV1;
    [SyncEntityType.AlbumDeleteV1]: SyncAlbumDeleteV1;
    [SyncEntityType.AlbumUserV1]: SyncAlbumUserV1;
    [SyncEntityType.AlbumUserBackfillV1]: SyncAlbumUserV1;
    [SyncEntityType.AlbumUserDeleteV1]: SyncAlbumUserDeleteV1;
    [SyncEntityType.AlbumAssetCreateV1]: SyncAssetV1;
    [SyncEntityType.AlbumAssetUpdateV1]: SyncAssetV1;
    [SyncEntityType.AlbumAssetBackfillV1]: SyncAssetV1;
    [SyncEntityType.AlbumAssetExifCreateV1]: SyncAssetExifV1;
    [SyncEntityType.AlbumAssetExifUpdateV1]: SyncAssetExifV1;
    [SyncEntityType.AlbumAssetExifBackfillV1]: SyncAssetExifV1;
    [SyncEntityType.AlbumToAssetV1]: SyncAlbumToAssetV1;
    [SyncEntityType.AlbumToAssetBackfillV1]: SyncAlbumToAssetV1;
    [SyncEntityType.AlbumToAssetDeleteV1]: SyncAlbumToAssetDeleteV1;
    [SyncEntityType.MemoryV1]: SyncMemoryV1;
    [SyncEntityType.MemoryDeleteV1]: SyncMemoryDeleteV1;
    [SyncEntityType.MemoryToAssetV1]: SyncMemoryAssetV1;
    [SyncEntityType.MemoryToAssetDeleteV1]: SyncMemoryAssetDeleteV1;
    [SyncEntityType.StackV1]: SyncStackV1;
    [SyncEntityType.StackDeleteV1]: SyncStackDeleteV1;
    [SyncEntityType.PartnerStackBackfillV1]: SyncStackV1;
    [SyncEntityType.PartnerStackDeleteV1]: SyncStackDeleteV1;
    [SyncEntityType.PartnerStackV1]: SyncStackV1;
    [SyncEntityType.PersonV1]: SyncPersonV1;
    [SyncEntityType.PersonDeleteV1]: SyncPersonDeleteV1;
    [SyncEntityType.AssetFaceV1]: SyncAssetFaceV1;
    [SyncEntityType.AssetFaceDeleteV1]: SyncAssetFaceDeleteV1;
    [SyncEntityType.UserMetadataV1]: SyncUserMetadataV1;
    [SyncEntityType.UserMetadataDeleteV1]: SyncUserMetadataDeleteV1;
    [SyncEntityType.SyncAckV1]: SyncAckV1;
    [SyncEntityType.SyncCompleteV1]: SyncCompleteV1;
    [SyncEntityType.SyncResetV1]: SyncResetV1;
};
export declare class SyncStreamDto {
    types: SyncRequestType[];
    reset?: boolean;
}
export declare class SyncAckDto {
    type: SyncEntityType;
    ack: string;
}
export declare class SyncAckSetDto {
    acks: string[];
}
export declare class SyncAckDeleteDto {
    types?: SyncEntityType[];
}
