import { SystemConfig } from 'src/config';
import { CLIPConfig, DuplicateDetectionConfig, FacialRecognitionConfig, OcrConfig } from 'src/dtos/model-config.dto';
import { AudioCodec, CQMode, Colorspace, ImageFormat, LogLevel, OAuthTokenEndpointAuthMethod, QueueName, ToneMapping, TranscodeHardwareAcceleration, TranscodePolicy, VideoCodec, VideoContainer } from 'src/enum';
import { ConcurrentQueueName } from 'src/types';
export declare class DatabaseBackupConfig {
    enabled: boolean;
    cronExpression: string;
    keepLastAmount: number;
}
export declare class SystemConfigBackupsDto {
    database: DatabaseBackupConfig;
}
export declare class SystemConfigFFmpegDto {
    crf: number;
    threads: number;
    preset: string;
    targetVideoCodec: VideoCodec;
    acceptedVideoCodecs: VideoCodec[];
    targetAudioCodec: AudioCodec;
    acceptedAudioCodecs: AudioCodec[];
    acceptedContainers: VideoContainer[];
    targetResolution: string;
    maxBitrate: string;
    bframes: number;
    refs: number;
    gopSize: number;
    temporalAQ: boolean;
    cqMode: CQMode;
    twoPass: boolean;
    preferredHwDevice: string;
    transcode: TranscodePolicy;
    accel: TranscodeHardwareAcceleration;
    accelDecode: boolean;
    tonemap: ToneMapping;
}
declare class JobSettingsDto {
    concurrency: number;
}
declare class SystemConfigJobDto implements Record<ConcurrentQueueName, JobSettingsDto> {
    [QueueName.ThumbnailGeneration]: JobSettingsDto;
    [QueueName.MetadataExtraction]: JobSettingsDto;
    [QueueName.VideoConversion]: JobSettingsDto;
    [QueueName.SmartSearch]: JobSettingsDto;
    [QueueName.Migration]: JobSettingsDto;
    [QueueName.BackgroundTask]: JobSettingsDto;
    [QueueName.Search]: JobSettingsDto;
    [QueueName.FaceDetection]: JobSettingsDto;
    [QueueName.Ocr]: JobSettingsDto;
    [QueueName.Sidecar]: JobSettingsDto;
    [QueueName.Library]: JobSettingsDto;
    [QueueName.Notification]: JobSettingsDto;
    [QueueName.Workflow]: JobSettingsDto;
    [QueueName.Editor]: JobSettingsDto;
}
declare class SystemConfigLibraryScanDto {
    enabled: boolean;
    cronExpression: string;
}
declare class SystemConfigLibraryWatchDto {
    enabled: boolean;
}
declare class SystemConfigLibraryDto {
    scan: SystemConfigLibraryScanDto;
    watch: SystemConfigLibraryWatchDto;
}
declare class SystemConfigLoggingDto {
    enabled: boolean;
    level: LogLevel;
}
declare class MachineLearningAvailabilityChecksDto {
    enabled: boolean;
    timeout: number;
    interval: number;
}
declare class SystemConfigMachineLearningDto {
    enabled: boolean;
    urls: string[];
    availabilityChecks: MachineLearningAvailabilityChecksDto;
    clip: CLIPConfig;
    duplicateDetection: DuplicateDetectionConfig;
    facialRecognition: FacialRecognitionConfig;
    ocr: OcrConfig;
}
declare enum MapTheme {
    LIGHT = "light",
    DARK = "dark"
}
export declare class MapThemeDto {
    theme: MapTheme;
}
declare class SystemConfigMapDto {
    enabled: boolean;
    lightStyle: string;
    darkStyle: string;
}
declare class SystemConfigNewVersionCheckDto {
    enabled: boolean;
}
declare class SystemConfigNightlyTasksDto {
    startTime: string;
    databaseCleanup: boolean;
    missingThumbnails: boolean;
    clusterNewFaces: boolean;
    generateMemories: boolean;
    syncQuotaUsage: boolean;
}
declare class SystemConfigOAuthDto {
    autoLaunch: boolean;
    autoRegister: boolean;
    buttonText: string;
    clientId: string;
    clientSecret: string;
    tokenEndpointAuthMethod: OAuthTokenEndpointAuthMethod;
    timeout: number;
    defaultStorageQuota: number | null;
    enabled: boolean;
    issuerUrl: string;
    mobileOverrideEnabled: boolean;
    mobileRedirectUri: string;
    scope: string;
    signingAlgorithm: string;
    profileSigningAlgorithm: string;
    storageLabelClaim: string;
    storageQuotaClaim: string;
    roleClaim: string;
}
declare class SystemConfigPasswordLoginDto {
    enabled: boolean;
}
declare class SystemConfigReverseGeocodingDto {
    enabled: boolean;
}
declare class SystemConfigFacesDto {
    import: boolean;
}
declare class SystemConfigMetadataDto {
    faces: SystemConfigFacesDto;
}
declare class SystemConfigServerDto {
    externalDomain: string;
    loginPageMessage: string;
    publicUsers: boolean;
}
declare class SystemConfigSmtpTransportDto {
    ignoreCert: boolean;
    host: string;
    port: number;
    secure: boolean;
    username: string;
    password: string;
}
export declare class SystemConfigSmtpDto {
    enabled: boolean;
    from: string;
    replyTo: string;
    transport: SystemConfigSmtpTransportDto;
}
declare class SystemConfigNotificationsDto {
    smtp: SystemConfigSmtpDto;
}
declare class SystemConfigTemplateEmailsDto {
    albumInviteTemplate: string;
    welcomeTemplate: string;
    albumUpdateTemplate: string;
}
declare class SystemConfigTemplatesDto {
    email: SystemConfigTemplateEmailsDto;
}
declare class SystemConfigStorageTemplateDto {
    enabled: boolean;
    hashVerificationEnabled: boolean;
    template: string;
}
export declare class SystemConfigTemplateStorageOptionDto {
    yearOptions: string[];
    monthOptions: string[];
    weekOptions: string[];
    dayOptions: string[];
    hourOptions: string[];
    minuteOptions: string[];
    secondOptions: string[];
    presetOptions: string[];
}
export declare class SystemConfigThemeDto {
    customCss: string;
}
declare class SystemConfigGeneratedImageDto {
    format: ImageFormat;
    quality: number;
    size: number;
    progressive?: boolean;
}
declare class SystemConfigGeneratedFullsizeImageDto {
    enabled: boolean;
    format: ImageFormat;
    quality: number;
    progressive?: boolean;
}
export declare class SystemConfigImageDto {
    thumbnail: SystemConfigGeneratedImageDto;
    preview: SystemConfigGeneratedImageDto;
    fullsize: SystemConfigGeneratedFullsizeImageDto;
    colorspace: Colorspace;
    extractEmbedded: boolean;
}
declare class SystemConfigTrashDto {
    enabled: boolean;
    days: number;
}
declare class SystemConfigUserDto {
    deleteDelay: number;
}
export declare class SystemConfigDto implements SystemConfig {
    backup: SystemConfigBackupsDto;
    ffmpeg: SystemConfigFFmpegDto;
    logging: SystemConfigLoggingDto;
    machineLearning: SystemConfigMachineLearningDto;
    map: SystemConfigMapDto;
    newVersionCheck: SystemConfigNewVersionCheckDto;
    nightlyTasks: SystemConfigNightlyTasksDto;
    oauth: SystemConfigOAuthDto;
    passwordLogin: SystemConfigPasswordLoginDto;
    reverseGeocoding: SystemConfigReverseGeocodingDto;
    metadata: SystemConfigMetadataDto;
    storageTemplate: SystemConfigStorageTemplateDto;
    job: SystemConfigJobDto;
    image: SystemConfigImageDto;
    trash: SystemConfigTrashDto;
    theme: SystemConfigThemeDto;
    library: SystemConfigLibraryDto;
    notifications: SystemConfigNotificationsDto;
    templates: SystemConfigTemplatesDto;
    server: SystemConfigServerDto;
    user: SystemConfigUserDto;
}
export declare function mapConfig(config: SystemConfig): SystemConfigDto;
export {};
