"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeBucketsResponseDto = exports.TimeBucketAssetResponseDto = exports.TimeBucketAssetDto = exports.TimeBucketDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class TimeBucketDto {
    userId;
    albumId;
    personId;
    tagId;
    isFavorite;
    isTrashed;
    withStacked;
    withPartners;
    order;
    visibility;
    withCoordinates;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: false, type: () => String }, albumId: { required: false, type: () => String }, personId: { required: false, type: () => String }, tagId: { required: false, type: () => String }, isFavorite: { required: false, type: () => Boolean }, isTrashed: { required: false, type: () => Boolean }, withStacked: { required: false, type: () => Boolean }, withPartners: { required: false, type: () => Boolean }, order: { required: false, enum: require("../enum").AssetOrder }, visibility: { required: false, enum: require("../enum").AssetVisibility }, withCoordinates: { required: false, type: () => Boolean } };
    }
}
exports.TimeBucketDto = TimeBucketDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter assets by specific user ID' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "userId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter assets belonging to a specific album' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "albumId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter assets containing a specific person (face recognition)' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "personId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter assets with a specific tag' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "tagId", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Filter by favorite status (true for favorites only, false for non-favorites only)',
    }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Filter by trash status (true for trashed assets only, false for non-trashed only)',
    }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "isTrashed", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Include stacked assets in the response. When true, only primary assets from stacks are returned.',
    }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "withStacked", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Include assets shared by partners' }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "withPartners", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.AssetOrder,
        name: 'AssetOrder',
        description: 'Sort order for assets within time buckets (ASC for oldest first, DESC for newest first)',
        optional: true,
    }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "order", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.AssetVisibility,
        name: 'AssetVisibility',
        optional: true,
        description: 'Filter by asset visibility status (ARCHIVE, TIMELINE, HIDDEN, LOCKED)',
    }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "visibility", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Include location data in the response',
    }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "withCoordinates", void 0);
class TimeBucketAssetDto extends TimeBucketDto {
    timeBucket;
    static _OPENAPI_METADATA_FACTORY() {
        return { timeBucket: { required: true, type: () => String } };
    }
}
exports.TimeBucketAssetDto = TimeBucketAssetDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'string',
        description: 'Time bucket identifier in YYYY-MM-DD format (e.g., "2024-01-01" for January 2024)',
        example: '2024-01-01',
    }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], TimeBucketAssetDto.prototype, "timeBucket", void 0);
class TimeBucketAssetResponseDto {
    id;
    ownerId;
    ratio;
    isFavorite;
    visibility;
    isTrashed;
    isImage;
    thumbhash;
    fileCreatedAt;
    localOffsetHours;
    duration;
    stack;
    projectionType;
    livePhotoVideoId;
    city;
    country;
    latitude;
    longitude;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => [String] }, ownerId: { required: true, type: () => [String] }, ratio: { required: true, type: () => [Number] }, isFavorite: { required: true, type: () => [Boolean] }, visibility: { required: true, enum: require("../enum").AssetVisibility, isArray: true }, isTrashed: { required: true, type: () => [Boolean] }, isImage: { required: true, type: () => [Boolean] }, thumbhash: { required: true, type: () => [Object] }, fileCreatedAt: { required: true, type: () => [String] }, localOffsetHours: { required: true, type: () => [Number] }, duration: { required: true, type: () => [Object] }, stack: { required: false, type: () => [Object] }, projectionType: { required: true, type: () => [Object] }, livePhotoVideoId: { required: true, type: () => [Object] }, city: { required: true, type: () => [Object] }, country: { required: true, type: () => [Object] }, latitude: { required: true, type: () => [Number] }, longitude: { required: true, type: () => [Number] } };
    }
}
exports.TimeBucketAssetResponseDto = TimeBucketAssetResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string' },
        description: 'Array of asset IDs in the time bucket',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string' },
        description: 'Array of owner IDs for each asset',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "ownerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'number' },
        description: 'Array of aspect ratios (width/height) for each asset',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "ratio", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'boolean' },
        description: 'Array indicating whether each asset is favorited',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.AssetVisibility,
        name: 'AssetVisibility',
        each: true,
        description: 'Array of visibility statuses for each asset (e.g., ARCHIVE, TIMELINE, HIDDEN, LOCKED)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "visibility", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'boolean' },
        description: 'Array indicating whether each asset is in the trash',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "isTrashed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'boolean' },
        description: 'Array indicating whether each asset is an image (false for videos)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "isImage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of BlurHash strings for generating asset previews (base64 encoded)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "thumbhash", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string' },
        description: 'Array of file creation timestamps in UTC',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "fileCreatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'number' },
        description: "Array of UTC offset hours at the time each photo was taken. Positive values are east of UTC, negative values are west of UTC. Values may be fractional (e.g., 5.5 for +05:30, -9.75 for -09:45). Applying this offset to 'fileCreatedAt' will give you the time the photo was taken from the photographer's perspective.",
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "localOffsetHours", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of video durations in HH:MM:SS format (null for images)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "duration", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: {
            type: 'array',
            items: { type: 'string' },
            minItems: 2,
            maxItems: 2,
            nullable: true,
        },
        description: 'Array of stack information as [stackId, assetCount] tuples (null for non-stacked assets)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "stack", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of projection types for 360° content (e.g., "EQUIRECTANGULAR", "CUBEFACE", "CYLINDRICAL")',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "projectionType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of live photo video asset IDs (null for non-live photos)',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "livePhotoVideoId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of city names extracted from EXIF GPS data',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "city", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        items: { type: 'string', nullable: true },
        description: 'Array of country names extracted from EXIF GPS data',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "country", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        required: false,
        items: { type: 'number', nullable: true },
        description: 'Array of latitude coordinates extracted from EXIF GPS data',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "latitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'array',
        required: false,
        items: { type: 'number', nullable: true },
        description: 'Array of longitude coordinates extracted from EXIF GPS data',
    }),
    __metadata("design:type", Array)
], TimeBucketAssetResponseDto.prototype, "longitude", void 0);
class TimeBucketsResponseDto {
    timeBucket;
    count;
    static _OPENAPI_METADATA_FACTORY() {
        return { timeBucket: { required: true, type: () => String }, count: { required: true, type: () => Number } };
    }
}
exports.TimeBucketsResponseDto = TimeBucketsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'string',
        description: 'Time bucket identifier in YYYY-MM-DD format representing the start of the time period',
        example: '2024-01-01',
    }),
    __metadata("design:type", String)
], TimeBucketsResponseDto.prototype, "timeBucket", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: 'integer',
        description: 'Number of assets in this time bucket',
        example: 42,
    }),
    __metadata("design:type", Number)
], TimeBucketsResponseDto.prototype, "count", void 0);
//# sourceMappingURL=time-bucket.dto.js.map