"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumUpdateEmail = void 0;
const components_1 = require("@react-email/components");
const React = __importStar(require("react"));
const button_component_1 = require("./components/button.component");
const immich_layout_1 = __importDefault(require("./components/immich.layout"));
const replace_template_tags_1 = require("../utils/replace-template-tags");
const AlbumUpdateEmail = ({ baseUrl, albumName, recipientName, albumId, cid, customTemplate, }) => {
    const usableTemplateVariables = {
        albumName,
        recipientName,
        albumId,
        baseUrl,
    };
    const emailContent = customTemplate ? ((0, replace_template_tags_1.replaceTemplateTags)(customTemplate, usableTemplateVariables)) : (React.createElement(React.Fragment, null,
        React.createElement(components_1.Text, { className: "m-0" },
            "Hey ",
            React.createElement("strong", null, recipientName),
            "!"),
        React.createElement(components_1.Text, null,
            "New media has been added to ",
            React.createElement("strong", null, albumName),
            ".",
            React.createElement("br", null),
            " Check it out!")));
    return (React.createElement(immich_layout_1.default, { preview: customTemplate ? emailContent.toString() : 'New media has been added to a shared album.' },
        customTemplate && (React.createElement(components_1.Text, { className: "m-0" },
            React.createElement("div", { dangerouslySetInnerHTML: { __html: emailContent } }))),
        !customTemplate && emailContent,
        cid && (React.createElement(components_1.Section, { className: "flex justify-center my-0" },
            React.createElement(components_1.Img, { className: "max-w-[300px] w-full rounded-lg", src: `cid:${cid}`, style: {
                    boxShadow: 'rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px',
                } }))),
        React.createElement(components_1.Section, { className: "flex justify-center my-6" },
            React.createElement(button_component_1.ImmichButton, { href: `${baseUrl}/albums/${albumId}` }, "View Album")),
        React.createElement(components_1.Text, { className: "text-xs" },
            "If you cannot click the button use the link below to view the album.",
            React.createElement("br", null),
            React.createElement(components_1.Link, { href: `${baseUrl}/albums/${albumId}` }, `${baseUrl}/albums/${albumId}`))));
};
exports.AlbumUpdateEmail = AlbumUpdateEmail;
exports.AlbumUpdateEmail.PreviewProps = {
    baseUrl: 'https://demo.immich.app',
    albumName: 'Trip to Europe',
    albumId: 'b63f6dae-e1c9-401b-9a85-9dbbf5612539',
    recipientName: 'Alan Turing',
    cid: '',
    customTemplate: '',
};
exports.default = exports.AlbumUpdateEmail;
//# sourceMappingURL=album-update.email.js.map