"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WelcomeEmail = void 0;
const components_1 = require("@react-email/components");
const React = __importStar(require("react"));
const button_component_1 = require("./components/button.component");
const immich_layout_1 = __importDefault(require("./components/immich.layout"));
const replace_template_tags_1 = require("../utils/replace-template-tags");
const WelcomeEmail = ({ baseUrl, displayName, username, password, customTemplate }) => {
    const usableTemplateVariables = {
        displayName,
        username,
        password,
        baseUrl,
    };
    const emailContent = customTemplate ? ((0, replace_template_tags_1.replaceTemplateTags)(customTemplate, usableTemplateVariables)) : (React.createElement(React.Fragment, null,
        React.createElement(components_1.Text, { className: "m-0" },
            "Hey ",
            React.createElement("strong", null, displayName),
            "!"),
        React.createElement(components_1.Text, null, "A new account has been created for you."),
        React.createElement(components_1.Text, null,
            React.createElement("strong", null, "Username"),
            ": ",
            username,
            password && (React.createElement(React.Fragment, null,
                React.createElement("br", null),
                React.createElement("strong", null, "Password"),
                ": ",
                password)))));
    return (React.createElement(immich_layout_1.default, { preview: customTemplate ? emailContent.toString() : 'You have been invited to a new Immich instance.' },
        customTemplate && (React.createElement(components_1.Text, { className: "m-0" },
            React.createElement("div", { dangerouslySetInnerHTML: { __html: emailContent } }))),
        !customTemplate && emailContent,
        React.createElement(components_1.Section, { className: "flex justify-center my-6" },
            React.createElement(button_component_1.ImmichButton, { href: `${baseUrl}/auth/login` }, "Login")),
        React.createElement(components_1.Text, { className: "text-xs" },
            "If you cannot click the button use the link below to proceed with first login.",
            React.createElement("br", null),
            React.createElement(components_1.Link, { href: baseUrl }, baseUrl))));
};
exports.WelcomeEmail = WelcomeEmail;
exports.WelcomeEmail.PreviewProps = {
    baseUrl: 'https://demo.immich.app/auth/login',
    displayName: 'Alan Turing',
    username: 'alanturing@immich.app',
    password: 'mysuperpassword',
};
exports.default = exports.WelcomeEmail;
//# sourceMappingURL=welcome.email.js.map