"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var GlobalExceptionFilter_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalExceptionFilter = void 0;
const common_1 = require("@nestjs/common");
const nestjs_cls_1 = require("nestjs-cls");
const logging_repository_1 = require("../repositories/logging.repository");
const logger_1 = require("../utils/logger");
let GlobalExceptionFilter = GlobalExceptionFilter_1 = class GlobalExceptionFilter {
    logger;
    cls;
    constructor(logger, cls) {
        this.logger = logger;
        this.cls = cls;
        this.logger.setContext(GlobalExceptionFilter_1.name);
    }
    catch(error, host) {
        const ctx = host.switchToHttp();
        const response = ctx.getResponse();
        const { status, body } = this.fromError(error);
        if (!response.headersSent) {
            response.status(status).json({ ...body, statusCode: status, correlationId: this.cls.getId() });
        }
    }
    handleError(res, error) {
        const { status, body } = this.fromError(error);
        if (!res.headersSent) {
            res.status(status).json({ ...body, statusCode: status, correlationId: this.cls.getId() });
        }
    }
    fromError(error) {
        (0, logger_1.logGlobalError)(this.logger, error);
        if (error instanceof common_1.HttpException) {
            const status = error.getStatus();
            let body = error.getResponse();
            if (typeof body === 'string') {
                body = { message: body };
            }
            return { status, body };
        }
        return {
            status: 500,
            body: {
                message: 'Internal server error',
            },
        };
    }
};
exports.GlobalExceptionFilter = GlobalExceptionFilter;
exports.GlobalExceptionFilter = GlobalExceptionFilter = GlobalExceptionFilter_1 = __decorate([
    (0, common_1.Catch)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        nestjs_cls_1.ClsService])
], GlobalExceptionFilter);
//# sourceMappingURL=global-exception.filter.js.map