"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const luxon_1 = require("luxon");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const memory_dto_1 = require("../dtos/memory.dto");
const enum_1 = require("../enum");
let MemoryRepository = class MemoryRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async cleanup() {
        await this.db
            .deleteFrom('memory_asset')
            .using('asset')
            .whereRef('memory_asset.assetId', '=', 'asset.id')
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Timeline)
            .execute();
        return this.db
            .deleteFrom('memory')
            .where('createdAt', '<', luxon_1.DateTime.now().minus({ days: 30 }).toJSDate())
            .where('isSaved', '=', false)
            .execute();
    }
    searchBuilder(ownerId, dto) {
        return this.db
            .selectFrom('memory')
            .$if(dto.isSaved !== undefined, (qb) => qb.where('isSaved', '=', dto.isSaved))
            .$if(dto.type !== undefined, (qb) => qb.where('type', '=', dto.type))
            .$if(dto.for !== undefined, (qb) => qb
            .where((where) => where.or([where('showAt', 'is', null), where('showAt', '<=', dto.for)]))
            .where((where) => where.or([where('hideAt', 'is', null), where('hideAt', '>=', dto.for)])))
            .where('deletedAt', dto.isTrashed ? 'is not' : 'is', null)
            .where('ownerId', '=', ownerId);
    }
    statistics(ownerId, dto) {
        return this.searchBuilder(ownerId, dto)
            .select((qb) => qb.fn.countAll().as('total'))
            .executeTakeFirstOrThrow();
    }
    search(ownerId, dto) {
        return this.searchBuilder(ownerId, dto)
            .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
            .selectFrom('asset')
            .selectAll('asset')
            .innerJoin('memory_asset', 'asset.id', 'memory_asset.assetId')
            .whereRef('memory_asset.memoriesId', '=', 'memory.id')
            .orderBy('asset.fileCreatedAt', 'asc')
            .where('asset.visibility', '=', kysely_1.sql.lit(enum_1.AssetVisibility.Timeline))
            .where('asset.deletedAt', 'is', null)).as('assets'))
            .selectAll('memory')
            .$call((qb) => dto.order === enum_1.AssetOrderWithRandom.Random
            ? qb.orderBy((0, kysely_1.sql) `RANDOM()`)
            : qb.orderBy('memoryAt', (dto.order?.toLowerCase() || 'desc')))
            .$if(dto.size !== undefined, (qb) => qb.limit(dto.size))
            .execute();
    }
    get(id) {
        return this.getByIdBuilder(id).executeTakeFirst();
    }
    async create(memory, assetIds) {
        const id = await this.db.transaction().execute(async (tx) => {
            const { id } = await tx.insertInto('memory').values(memory).returning('id').executeTakeFirstOrThrow();
            if (assetIds.size > 0) {
                const values = [...assetIds].map((assetId) => ({ memoriesId: id, assetId }));
                await tx.insertInto('memory_asset').values(values).execute();
            }
            return id;
        });
        return this.getByIdBuilder(id).executeTakeFirstOrThrow();
    }
    async update(id, memory) {
        await this.db.updateTable('memory').set(memory).where('id', '=', id).execute();
        return this.getByIdBuilder(id).executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('memory').where('id', '=', id).execute();
    }
    async getAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return new Set();
        }
        const results = await this.db
            .selectFrom('memory_asset')
            .select(['assetId'])
            .where('memoriesId', '=', id)
            .where('assetId', 'in', assetIds)
            .execute();
        return new Set(results.map(({ assetId }) => assetId));
    }
    async addAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .insertInto('memory_asset')
            .values(assetIds.map((assetId) => ({ memoriesId: id, assetId })))
            .execute();
    }
    async removeAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db.deleteFrom('memory_asset').where('memoriesId', '=', id).where('assetId', 'in', assetIds).execute();
    }
    getByIdBuilder(id) {
        return this.db
            .selectFrom('memory')
            .selectAll('memory')
            .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
            .selectFrom('asset')
            .selectAll('asset')
            .innerJoin('memory_asset', 'asset.id', 'memory_asset.assetId')
            .whereRef('memory_asset.memoriesId', '=', 'memory.id')
            .orderBy('asset.fileCreatedAt', 'asc')
            .where('asset.visibility', '=', kysely_1.sql.lit(enum_1.AssetVisibility.Timeline))
            .where('asset.deletedAt', 'is', null)).as('assets'))
            .where('id', '=', id)
            .where('deletedAt', 'is', null);
    }
};
exports.MemoryRepository = MemoryRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, {}] }, { name: 'date filter', params: [decorators_1.DummyValue.UUID, { for: decorators_1.DummyValue.DATE }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, memory_dto_1.MemorySearchDto]),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "statistics", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, {}] }, { name: 'date filter', params: [decorators_1.DummyValue.UUID, { for: decorators_1.DummyValue.DATE }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, memory_dto_1.MemorySearchDto]),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { ownerId: decorators_1.DummyValue.UUID, isSaved: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "update", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "getAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "addAssetIds", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "removeAssetIds", null);
exports.MemoryRepository = MemoryRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], MemoryRepository);
//# sourceMappingURL=memory.repository.js.map