import { Kysely } from 'kysely';
import { PluginManifestDto } from 'src/dtos/plugin-manifest.dto';
import { DB } from 'src/schema';
export declare class PluginRepository {
    private db;
    constructor(db: Kysely<DB>);
    loadPlugin(manifest: PluginManifestDto, basePath: string): Promise<{
        plugin: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
        };
        filters: {
            id: string;
            description: string;
            title: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            id: string;
            description: string;
            title: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    }>;
    readDirectory(path: string): Promise<import("fs").Dirent<string>[]>;
    getPlugin(id: string): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    } | undefined>;
    getPluginByName(name: string): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    } | undefined>;
    getAllPlugins(): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            name: string;
            id: string;
            description: string;
            title: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            pluginId: string;
            methodName: string;
            supportedContexts: import("../enum").PluginContext[];
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    }[]>;
    getFilter(id: string): Promise<{
        id: string;
        description: string;
        title: string;
        pluginId: string;
        methodName: string;
        supportedContexts: import("../enum").PluginContext[];
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    } | undefined>;
    getFiltersByPlugin(pluginId: string): Promise<{
        id: string;
        description: string;
        title: string;
        pluginId: string;
        methodName: string;
        supportedContexts: import("../enum").PluginContext[];
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    }[]>;
    getAction(id: string): Promise<{
        id: string;
        description: string;
        title: string;
        pluginId: string;
        methodName: string;
        supportedContexts: import("../enum").PluginContext[];
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    } | undefined>;
    getActionsByPlugin(pluginId: string): Promise<{
        id: string;
        description: string;
        title: string;
        pluginId: string;
        methodName: string;
        supportedContexts: import("../enum").PluginContext[];
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    }[]>;
}
