import { Kysely } from 'kysely';
import { DB } from 'src/schema';
import { SyncAck } from 'src/types';
export type SyncBackfillOptions = {
    nowId: string;
    afterUpdateId?: string;
    beforeUpdateId: string;
};
export type SyncCreatedAfterOptions = {
    nowId: string;
    userId: string;
    afterCreateId?: string;
};
export type SyncQueryOptions = {
    nowId: string;
    userId: string;
    ack?: SyncAck;
};
export declare class SyncRepository {
    private db;
    album: AlbumSync;
    albumAsset: AlbumAssetSync;
    albumAssetExif: AlbumAssetExifSync;
    albumToAsset: AlbumToAssetSync;
    albumUser: AlbumUserSync;
    asset: AssetSync;
    assetExif: AssetExifSync;
    assetFace: AssetFaceSync;
    assetMetadata: AssetMetadataSync;
    authUser: AuthUserSync;
    memory: MemorySync;
    memoryToAsset: MemoryToAssetSync;
    partner: PartnerSync;
    partnerAsset: PartnerAssetsSync;
    partnerAssetExif: PartnerAssetExifsSync;
    partnerStack: PartnerStackSync;
    person: PersonSync;
    stack: StackSync;
    user: UserSync;
    userMetadata: UserMetadataSync;
    constructor(db: Kysely<DB>);
}
declare class BaseSync {
    protected db: Kysely<DB>;
    constructor(db: Kysely<DB>);
    protected backfillQuery<T extends keyof DB>(t: T, { nowId, beforeUpdateId, afterUpdateId }: SyncBackfillOptions): import("kysely").SelectQueryBuilder<import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<{ [C in keyof DB | T]: C extends T ? import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> extends infer T_1 ? T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> ? T_1 extends C ? T_1 extends keyof DB ? DB[T_1] : never : T_1 extends import("kysely").AliasedExpression<infer O, infer QA extends string> ? QA extends C ? O : never : T_1 extends (qb: any) => import("kysely").AliasedExpression<infer O_1, infer QA_1> ? QA_1 extends C ? O_1 : never : T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<infer T_2 extends string, infer DA extends string> ? DA extends C ? T_2 extends keyof DB ? DB[T_2] : never : never : never : never : never : C extends keyof DB ? DB[C] : never; }>, import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<T>, Partial<Omit<unknown, never>>>;
    protected auditQuery<T extends keyof DB>(t: T, { nowId, ack }: SyncQueryOptions): import("kysely").SelectQueryBuilder<import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<{ [C in keyof DB | T]: C extends T ? import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> extends infer T_1 ? T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> ? T_1 extends C ? T_1 extends keyof DB ? DB[T_1] : never : T_1 extends import("kysely").AliasedExpression<infer O, infer QA extends string> ? QA extends C ? O : never : T_1 extends (qb: any) => import("kysely").AliasedExpression<infer O_1, infer QA_1> ? QA_1 extends C ? O_1 : never : T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<infer T_2 extends string, infer DA extends string> ? DA extends C ? T_2 extends keyof DB ? DB[T_2] : never : never : never : never : never : C extends keyof DB ? DB[C] : never; }>, import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<T>, Partial<Omit<unknown, never>>>;
    protected auditCleanup<T extends keyof DB>(t: T, days: number): Promise<import("kysely").DeleteResult[]>;
    protected upsertQuery<T extends keyof DB>(t: T, { nowId, ack }: SyncQueryOptions): import("kysely").SelectQueryBuilder<import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<{ [C in keyof DB | T]: C extends T ? import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> extends infer T_1 ? T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<T, T> ? T_1 extends C ? T_1 extends keyof DB ? DB[T_1] : never : T_1 extends import("kysely").AliasedExpression<infer O, infer QA extends string> ? QA extends C ? O : never : T_1 extends (qb: any) => import("kysely").AliasedExpression<infer O_1, infer QA_1> ? QA_1 extends C ? O_1 : never : T_1 extends import("node_modules/kysely/dist/cjs/dynamic/dynamic-table-builder").AliasedDynamicTableBuilder<infer T_2 extends string, infer DA extends string> ? DA extends C ? T_2 extends keyof DB ? DB[T_2] : never : never : never : never : never : C extends keyof DB ? DB[C] : never; }>, import("node_modules/kysely/dist/cjs/util/type-utils").DrainOuterGeneric<T>, Partial<Omit<unknown, never>>>;
}
declare class AlbumSync extends BaseSync {
    getCreatedAfter({ nowId, userId, afterCreateId }: SyncCreatedAfterOptions): Promise<{
        createId: string;
        id: string;
    }[]>;
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        albumId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        name: string;
        thumbnailAssetId: string | null;
    }>;
}
declare class AlbumAssetSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, albumId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    } & {
        updateId: string;
    }>;
    getUpdates(options: SyncQueryOptions, albumToAssetAck: SyncAck): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    } & {
        updateId: string;
    }>;
    getCreates(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        updateId: string;
    } & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    }>;
}
declare class AlbumAssetExifSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, albumId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    } & {
        updateId: string;
    }>;
    getUpdates(options: SyncQueryOptions, albumToAssetAck: SyncAck): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    } & {
        updateId: string;
    }>;
    getCreates(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        updateId: string;
    } & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    }>;
}
declare class AlbumToAssetSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, albumId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        updateId: string;
        albumId: string;
        assetId: string;
    }>;
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        assetId: string;
        albumId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        updateId: string;
        albumId: string;
        assetId: string;
    }>;
}
declare class AlbumUserSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, albumId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        albumId: string;
        userId: string;
        role: import("../enum").AlbumUserRole;
    } & {
        updateId: string;
    }>;
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        userId: string;
        albumId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        albumId: string;
        userId: string;
        role: import("../enum").AlbumUserRole;
    } & {
        updateId: string;
    }>;
}
declare class AssetSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        assetId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    } & {
        updateId: string;
    }>;
}
declare class AuthUserSync extends BaseSync {
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        name: string;
        id: string;
        email: string;
        profileImagePath: string;
        avatarColor: import("../enum").UserAvatarColor | null;
        deletedAt: Date | null;
        profileChangedAt: Date;
        updateId: string;
    } & {
        isAdmin: boolean;
        pinCode: string | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
    }>;
}
declare class PersonSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        personId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        ownerId: string;
        isFavorite: boolean;
        isHidden: boolean;
        birthDate: Date | null;
        faceAssetId: string | null;
        color: string | null;
    }>;
}
declare class AssetFaceSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetFaceId: string;
        id: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: import("../enum").SourceType;
        id: string;
        updateId: string;
    }>;
}
declare class AssetExifSync extends BaseSync {
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    } & {
        updateId: string;
    }>;
}
declare class MemorySync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        memoryId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").MemoryType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        data: object;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        hideAt: Date | null;
    } & {
        updateId: string;
    }>;
}
declare class MemoryToAssetSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        assetId: string;
        memoryId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        memoryId: string;
        assetId: string;
    } & {
        updateId: string;
    }>;
}
declare class PartnerSync extends BaseSync {
    getCreatedAfter({ nowId, userId, afterCreateId }: SyncCreatedAfterOptions): Promise<{
        createId: string;
        sharedById: string;
    }[]>;
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        sharedById: string;
        sharedWithId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        updateId: string;
        sharedById: string;
        sharedWithId: string;
        inTimeline: boolean;
    }>;
}
declare class PartnerAssetsSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, partnerId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    } & {
        updateId: string;
    }>;
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        assetId: string;
    }>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        type: import("../enum").AssetType;
        deletedAt: Date | null;
        ownerId: string;
        width: number | null;
        height: number | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        libraryId: string | null;
        localDateTime: Date;
        stackId: string | null;
        visibility: import("../enum").AssetVisibility;
        isEdited: boolean;
    } & {
        updateId: string;
    }>;
}
declare class PartnerAssetExifsSync extends BaseSync {
    getBackfill(options: SyncBackfillOptions, partnerId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    } & {
        updateId: string;
    }>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        assetId: string;
        description: string;
        state: string | null;
        make: string | null;
        model: string | null;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        latitude: number | null;
        longitude: number | null;
        city: string | null;
        country: string | null;
        fps: number | null;
        exposureTime: string | null;
        timeZone: string | null;
        projectionType: string | null;
        profileDescription: string | null;
        rating: number | null;
    } & {
        updateId: string;
    }>;
}
declare class StackSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        stackId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        createdAt: Date;
        updatedAt: Date;
        primaryAssetId: string;
        ownerId: string;
    } & {
        updateId: string;
    }>;
}
declare class PartnerStackSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        stackId: string;
    }>;
    getBackfill(options: SyncBackfillOptions, partnerId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        createdAt: Date;
        updatedAt: Date;
        primaryAssetId: string;
        ownerId: string;
    } & {
        updateId: string;
    }>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        createdAt: Date;
        updatedAt: Date;
        primaryAssetId: string;
        ownerId: string;
    } & {
        updateId: string;
    }>;
}
declare class UserSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
        userId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        name: string;
        id: string;
        email: string;
        profileImagePath: string;
        avatarColor: import("../enum").UserAvatarColor | null;
        deletedAt: Date | null;
        profileChangedAt: Date;
        updateId: string;
    }>;
}
declare class UserMetadataSync extends BaseSync {
    getDeletes(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        key: import("../enum").UserMetadataKey;
        id: string;
        userId: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        key: import("../enum").UserMetadataKey;
        value: {
            isOnboarded: boolean;
        } | {
            albums?: {
                defaultAssetOrder?: import("../enum").AssetOrder | undefined;
            } | undefined;
            folders?: {
                enabled?: boolean | undefined;
                sidebarWeb?: boolean | undefined;
            } | undefined;
            memories?: {
                enabled?: boolean | undefined;
                duration?: number | undefined;
            } | undefined;
            people?: {
                enabled?: boolean | undefined;
                sidebarWeb?: boolean | undefined;
            } | undefined;
            ratings?: {
                enabled?: boolean | undefined;
            } | undefined;
            sharedLinks?: {
                enabled?: boolean | undefined;
                sidebarWeb?: boolean | undefined;
            } | undefined;
            tags?: {
                enabled?: boolean | undefined;
                sidebarWeb?: boolean | undefined;
            } | undefined;
            emailNotifications?: {
                enabled?: boolean | undefined;
                albumInvite?: boolean | undefined;
                albumUpdate?: boolean | undefined;
            } | undefined;
            download?: {
                archiveSize?: number | undefined;
                includeEmbeddedVideos?: boolean | undefined;
            } | undefined;
            purchase?: {
                showSupportBadge?: boolean | undefined;
                hideBuyButtonUntil?: string | undefined;
            } | undefined;
            cast?: {
                gCastEnabled?: boolean | undefined;
            } | undefined;
        } | {
            licenseKey: string;
            activationKey: string;
            activatedAt: string;
        };
        userId: string;
        updateId: string;
    }>;
}
declare class AssetMetadataSync extends BaseSync {
    getDeletes(options: SyncQueryOptions, userId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        key: string;
        assetId: string;
        id: string;
    }>;
    cleanupAuditTable(daysAgo: number): Promise<import("kysely").DeleteResult[]>;
    getUpserts(options: SyncQueryOptions, userId: string): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        key: string;
        assetId: string;
        value: object;
        updateId: string;
    }>;
}
export {};
