"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "asset" ADD COLUMN "width" integer;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset" ADD COLUMN "height" integer;`.execute(db);
    await (0, kysely_1.sql) `
    UPDATE "asset"
    SET 
      "width" = CASE
        WHEN "asset_exif"."orientation" IN ('5', '6', '7', '8', '-90', '90') THEN "asset_exif"."exifImageHeight"
        ELSE "asset_exif"."exifImageWidth"
      END,
      "height" = CASE
        WHEN "asset_exif"."orientation" IN ('5', '6', '7', '8', '-90', '90') THEN "asset_exif"."exifImageWidth"
        ELSE "asset_exif"."exifImageHeight"
      END
    FROM "asset_exif"
    WHERE "asset"."id" = "asset_exif"."assetId"
      AND ("asset_exif"."exifImageWidth" IS NOT NULL OR "asset_exif"."exifImageHeight" IS NOT NULL)
  `.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "asset" DROP COLUMN "width";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "asset" DROP COLUMN "height";`.execute(db);
}
//# sourceMappingURL=1768336661963-AddAssetWidthHeight.js.map