import { ColumnType } from 'kysely';
import { UserAvatarColor, UserStatus } from 'src/enum';
import { Generated, Timestamp } from 'src/sql-tools';
export declare class UserTable {
    id: Generated<string>;
    email: string;
    password: Generated<string>;
    pinCode: string | null;
    createdAt: Generated<Timestamp>;
    profileImagePath: Generated<string>;
    isAdmin: Generated<boolean>;
    shouldChangePassword: Generated<boolean>;
    avatarColor: UserAvatarColor | null;
    deletedAt: Timestamp | null;
    oauthId: Generated<string>;
    updatedAt: Generated<Timestamp>;
    storageLabel: string | null;
    name: Generated<string>;
    quotaSizeInBytes: ColumnType<number> | null;
    quotaUsageInBytes: Generated<ColumnType<number>>;
    status: Generated<UserStatus>;
    profileChangedAt: Generated<Timestamp>;
    updateId: Generated<string>;
}
