import { AssetResponseDto, SanitizedAssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetBulkDeleteDto, AssetBulkUpdateDto, AssetCopyDto, AssetJobsDto, AssetMetadataBulkDeleteDto, AssetMetadataBulkResponseDto, AssetMetadataBulkUpsertDto, AssetMetadataResponseDto, AssetMetadataUpsertDto, AssetStatsDto, UpdateAssetDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetEditActionListDto, AssetEditsDto } from 'src/dtos/editing.dto';
import { AssetOcrResponseDto } from 'src/dtos/ocr.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class AssetService extends BaseService {
    getStatistics(auth: AuthDto, dto: AssetStatsDto): Promise<import("src/dtos/asset.dto").AssetStatsResponseDto>;
    getRandom(auth: AuthDto, count: number): Promise<AssetResponseDto[]>;
    getUserAssetsByDeviceId(auth: AuthDto, deviceId: string): Promise<string[]>;
    get(auth: AuthDto, id: string): Promise<AssetResponseDto | SanitizedAssetResponseDto>;
    update(auth: AuthDto, id: string, dto: UpdateAssetDto): Promise<AssetResponseDto>;
    updateAll(auth: AuthDto, dto: AssetBulkUpdateDto): Promise<void>;
    copy(auth: AuthDto, { sourceId, targetId, albums, sidecar, sharedLinks, stack, favorite, }: AssetCopyDto): Promise<void>;
    private copyStack;
    private copySidecar;
    handleAssetDeletionCheck(): Promise<JobStatus>;
    handleAssetDeletion(job: JobOf<JobName.AssetDelete>): Promise<JobStatus>;
    deleteAll(auth: AuthDto, dto: AssetBulkDeleteDto): Promise<void>;
    getMetadata(auth: AuthDto, id: string): Promise<AssetMetadataResponseDto[]>;
    getOcr(auth: AuthDto, id: string): Promise<AssetOcrResponseDto[]>;
    upsertBulkMetadata(auth: AuthDto, dto: AssetMetadataBulkUpsertDto): Promise<AssetMetadataBulkResponseDto[]>;
    upsertMetadata(auth: AuthDto, id: string, dto: AssetMetadataUpsertDto): Promise<AssetMetadataResponseDto[]>;
    getMetadataByKey(auth: AuthDto, id: string, key: string): Promise<AssetMetadataResponseDto>;
    deleteMetadataByKey(auth: AuthDto, id: string, key: string): Promise<void>;
    deleteBulkMetadata(auth: AuthDto, dto: AssetMetadataBulkDeleteDto): Promise<void>;
    run(auth: AuthDto, dto: AssetJobsDto): Promise<void>;
    private findOrFail;
    private updateExif;
    getAssetEdits(auth: AuthDto, id: string): Promise<AssetEditsDto>;
    editAsset(auth: AuthDto, id: string, dto: AssetEditActionListDto): Promise<AssetEditsDto>;
    removeAssetEdits(auth: AuthDto, id: string): Promise<void>;
}
