import { DatabaseBackupListResponseDto } from 'src/dtos/database-backup.dto';
import { JobStatus } from 'src/enum';
import { MaintenanceHealthRepository } from 'src/maintenance/maintenance-health.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { CronRepository } from 'src/repositories/cron.repository';
import { DatabaseRepository } from 'src/repositories/database.repository';
import { ArgOf } from 'src/repositories/event.repository';
import { JobRepository } from 'src/repositories/job.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { ProcessRepository } from 'src/repositories/process.repository';
import { StorageRepository } from 'src/repositories/storage.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
import { ImmichFileResponse } from 'src/utils/file';
export declare class DatabaseBackupService {
    private readonly logger;
    private readonly storageRepository;
    private readonly configRepository;
    private readonly systemMetadataRepository;
    private readonly processRepository;
    private readonly databaseRepository;
    private readonly cronRepository;
    private readonly jobRepository;
    private readonly maintenanceHealthRepository;
    constructor(logger: LoggingRepository, storageRepository: StorageRepository, configRepository: ConfigRepository, systemMetadataRepository: SystemMetadataRepository, processRepository: ProcessRepository, databaseRepository: DatabaseRepository, cronRepository: CronRepository, jobRepository: JobRepository, maintenanceHealthRepository: MaintenanceHealthRepository);
    private backupLock;
    onConfigInit({ newConfig: { backup: { database }, }, }: ArgOf<'ConfigInit'>): Promise<void>;
    onConfigUpdate({ newConfig: { backup } }: ArgOf<'ConfigUpdate'>): void;
    handleBackupDatabase(): Promise<JobStatus>;
    buildPostgresLaunchArguments(bin: 'pg_dump' | 'pg_dumpall' | 'psql', options?: {
        singleTransaction?: boolean;
    }): Promise<{
        bin: string;
        args: string[];
        databaseUsername: string;
        databasePassword: string;
        databaseVersion: string;
        databaseMajorVersion?: number;
    }>;
    createDatabaseBackup(filenamePrefix?: string): Promise<string>;
    uploadBackup(file: Express.Multer.File): Promise<void>;
    downloadBackup(fileName: string): ImmichFileResponse;
    listBackups(): Promise<DatabaseBackupListResponseDto>;
    deleteBackup(files: string[]): Promise<void>;
    cleanupDatabaseBackups(): Promise<void>;
    restoreDatabaseBackup(filename: string, progressCb?: (action: 'backup' | 'restore' | 'migrations' | 'rollback', progress: number) => void): Promise<void>;
}
