"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HashNamingStrategy = void 0;
const helpers_1 = require("../helpers");
const default_naming_1 = require("./default.naming");
const fallback = new default_naming_1.DefaultNamingStrategy();
const asKey = (prefix, tableName, values) => (prefix + (0, helpers_1.sha1)(`${tableName}_${values.toSorted().join('_')}`)).slice(0, 30);
class HashNamingStrategy {
    getName(item) {
        switch (item.type) {
            case 'primaryKey': {
                return asKey('PK_', item.tableName, item.columnNames);
            }
            case 'foreignKey': {
                return asKey('FK_', item.tableName, item.columnNames);
            }
            case 'check': {
                return asKey('CHK_', item.tableName, [item.expression]);
            }
            case 'unique': {
                return asKey('UQ_', item.tableName, item.columnNames);
            }
            case 'index': {
                const items = [];
                for (const columnName of item.columnNames ?? []) {
                    items.push(columnName);
                }
                if (item.where) {
                    items.push(item.where);
                }
                return asKey('IDX_', item.tableName, items);
            }
            case 'trigger': {
                return asKey('TR_', item.tableName, [...item.actions, item.scope, item.timing, item.functionName]);
            }
            default: {
                return fallback.getName(item);
            }
        }
    }
}
exports.HashNamingStrategy = HashNamingStrategy;
//# sourceMappingURL=hash.naming.js.map