"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processors = void 0;
const check_constraint_processor_1 = require("./check-constraint.processor");
const column_processor_1 = require("./column.processor");
const configuration_parameter_processor_1 = require("./configuration-parameter.processor");
const database_processor_1 = require("./database.processor");
const enum_processor_1 = require("./enum.processor");
const extension_processor_1 = require("./extension.processor");
const foreign_key_column_processor_1 = require("./foreign-key-column.processor");
const foreign_key_constraint_processor_1 = require("./foreign-key-constraint.processor");
const function_processor_1 = require("./function.processor");
const index_processor_1 = require("./index.processor");
const override_processor_1 = require("./override.processor");
const primary_key_contraint_processor_1 = require("./primary-key-contraint.processor");
const table_processor_1 = require("./table.processor");
const trigger_processor_1 = require("./trigger.processor");
const unique_constraint_processor_1 = require("./unique-constraint.processor");
exports.processors = [
    database_processor_1.processDatabases,
    configuration_parameter_processor_1.processConfigurationParameters,
    enum_processor_1.processEnums,
    extension_processor_1.processExtensions,
    function_processor_1.processFunctions,
    table_processor_1.processTables,
    column_processor_1.processColumns,
    foreign_key_column_processor_1.processForeignKeyColumns,
    foreign_key_constraint_processor_1.processForeignKeyConstraints,
    unique_constraint_processor_1.processUniqueConstraints,
    check_constraint_processor_1.processCheckConstraints,
    primary_key_contraint_processor_1.processPrimaryKeyConstraints,
    index_processor_1.processIndexes,
    trigger_processor_1.processTriggers,
    override_processor_1.processOverrides,
];
//# sourceMappingURL=index.js.map