"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processPrimaryKeyConstraints = void 0;
const types_1 = require("../types");
const processPrimaryKeyConstraints = (ctx) => {
    for (const table of ctx.tables) {
        const columnNames = [];
        for (const column of table.columns) {
            if (column.primary) {
                columnNames.push(column.name);
            }
        }
        if (columnNames.length > 0) {
            const tableMetadata = ctx.getTableMetadata(table);
            table.constraints.push({
                type: types_1.ConstraintType.PRIMARY_KEY,
                name: tableMetadata.options.primaryConstraintName ||
                    ctx.getNameFor({
                        type: 'primaryKey',
                        tableName: table.name,
                        columnNames,
                    }),
                tableName: table.name,
                columnNames,
                synchronize: tableMetadata.options.synchronize ?? true,
            });
        }
    }
};
exports.processPrimaryKeyConstraints = processPrimaryKeyConstraints;
//# sourceMappingURL=primary-key-contraint.processor.js.map