"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readTables = void 0;
const kysely_1 = require("kysely");
const readTables = async (ctx, db) => {
    const tables = await db
        .selectFrom('information_schema.tables')
        .where('table_schema', '=', ctx.schemaName)
        .where('table_type', '=', kysely_1.sql.lit('BASE TABLE'))
        .selectAll()
        .execute();
    for (const table of tables) {
        ctx.tables.push({
            name: table.table_name,
            columns: [],
            indexes: [],
            triggers: [],
            constraints: [],
            synchronize: true,
        });
    }
};
exports.readTables = readTables;
//# sourceMappingURL=table.reader.js.map