"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asOverrideDrop = exports.asOverrideUpdate = exports.asOverrideCreate = exports.transformOverrides = void 0;
const helpers_1 = require("../helpers");
const transformOverrides = (ctx, item) => {
    const tableName = ctx.overrideTableName;
    switch (item.type) {
        case 'OverrideCreate': {
            return (0, exports.asOverrideCreate)(tableName, item.override);
        }
        case 'OverrideUpdate': {
            return (0, exports.asOverrideUpdate)(tableName, item.override);
        }
        case 'OverrideDrop': {
            return (0, exports.asOverrideDrop)(tableName, item.overrideName);
        }
        default: {
            return false;
        }
    }
};
exports.transformOverrides = transformOverrides;
const asOverrideCreate = (tableName, override) => {
    return `INSERT INTO "${tableName}" ("name", "value") VALUES ('${override.name}', ${(0, helpers_1.asJsonString)(override.value)});`;
};
exports.asOverrideCreate = asOverrideCreate;
const asOverrideUpdate = (tableName, override) => {
    return `UPDATE "${tableName}" SET "value" = ${(0, helpers_1.asJsonString)(override.value)} WHERE "name" = '${override.name}';`;
};
exports.asOverrideUpdate = asOverrideUpdate;
const asOverrideDrop = (tableName, overrideName) => {
    return `DELETE FROM "${tableName}" WHERE "name" = '${overrideName}';`;
};
exports.asOverrideDrop = asOverrideDrop;
//# sourceMappingURL=override.transformer.js.map