"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTimeZone = exports.extractTimeZone = exports.asDateString = void 0;
const luxon_1 = require("luxon");
const asDateString = (x) => {
    return x instanceof Date ? x.toISOString().split('T')[0] : x;
};
exports.asDateString = asDateString;
const extractTimeZone = (dateTimeOriginal) => {
    const extractedTimeZone = dateTimeOriginal ? luxon_1.DateTime.fromISO(dateTimeOriginal, { setZone: true }).zone : undefined;
    return extractedTimeZone?.type === 'fixed' ? extractedTimeZone : undefined;
};
exports.extractTimeZone = extractTimeZone;
const mergeTimeZone = (dateTimeOriginal, timeZone) => {
    return dateTimeOriginal
        ? luxon_1.DateTime.fromISO(dateTimeOriginal, { zone: 'UTC' }).setZone(timeZone ?? undefined)
        : undefined;
};
exports.mergeTimeZone = mergeTimeZone;
//# sourceMappingURL=date.js.map