import { AssetFace } from 'src/database';
import { AssetOcrResponseDto } from 'src/dtos/ocr.dto';
import { ImageDimensions } from 'src/types';
type BoundingBox = {
    x1: number;
    y1: number;
    x2: number;
    y2: number;
};
export declare const boundingBoxOverlap: (boxA: BoundingBox, boxB: BoundingBox) => number;
export declare const checkFaceVisibility: (faces: AssetFace[], originalAssetDimensions: ImageDimensions, crop?: BoundingBox) => {
    visible: AssetFace[];
    hidden: AssetFace[];
};
export declare const checkOcrVisibility: (ocrs: (AssetOcrResponseDto & {
    isVisible: boolean;
})[], originalAssetDimensions: ImageDimensions, crop?: BoundingBox) => {
    visible: AssetOcrResponseDto[];
    hidden: AssetOcrResponseDto[];
};
export {};
