import { AssetType } from 'src/enum';
export declare const mimeTypes: {
    image: Record<string, string[]>;
    profile: Record<string, string[]>;
    sidecar: Record<string, string[]>;
    video: Record<string, string[]>;
    raw: {
        '.3fr': string[];
        '.ari': string[];
        '.arw': string[];
        '.cap': string[];
        '.cin': string[];
        '.cr2': string[];
        '.cr3': string[];
        '.crw': string[];
        '.dcr': string[];
        '.dng': string[];
        '.erf': string[];
        '.fff': string[];
        '.iiq': string[];
        '.k25': string[];
        '.kdc': string[];
        '.mrw': string[];
        '.nef': string[];
        '.nrw': string[];
        '.orf': string[];
        '.ori': string[];
        '.pef': string[];
        '.psd': string[];
        '.raf': string[];
        '.raw': string[];
        '.rw2': string[];
        '.rwl': string[];
        '.sr2': string[];
        '.srf': string[];
        '.srw': string[];
        '.x3f': string[];
    };
    webUnsupportedImage: {
        '.heic': string[];
        '.heif': string[];
        '.hif': string[];
        '.insp': string[];
        '.jp2': string[];
        '.jpe': string[];
        '.jxl': string[];
        '.svg': string[];
        '.tif': string[];
        '.tiff': string[];
        '.3fr': string[];
        '.ari': string[];
        '.arw': string[];
        '.cap': string[];
        '.cin': string[];
        '.cr2': string[];
        '.cr3': string[];
        '.crw': string[];
        '.dcr': string[];
        '.dng': string[];
        '.erf': string[];
        '.fff': string[];
        '.iiq': string[];
        '.k25': string[];
        '.kdc': string[];
        '.mrw': string[];
        '.nef': string[];
        '.nrw': string[];
        '.orf': string[];
        '.ori': string[];
        '.pef': string[];
        '.psd': string[];
        '.raf': string[];
        '.raw': string[];
        '.rw2': string[];
        '.rwl': string[];
        '.sr2': string[];
        '.srf': string[];
        '.srw': string[];
        '.x3f': string[];
    };
    isAsset: (filename: string) => boolean;
    isImage: (filename: string) => boolean;
    isWebSupportedImage: (filename: string) => boolean;
    isPossiblyAnimatedImage: (filename: string) => boolean;
    isProfile: (filename: string) => boolean;
    isSidecar: (filename: string) => boolean;
    isVideo: (filename: string) => boolean;
    isRaw: (filename: string) => boolean;
    lookup: (filename: string) => string;
    toExtension: (mimeType: string) => string | undefined;
    assetType: (filename: string) => AssetType.Image | AssetType.Video | AssetType.Other;
    getSupportedFileExtensions: () => string[];
};
