"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.upsertTags = void 0;
const upsertTags = async (repository, { userId, tags }) => {
    tags = [...new Set(tags)];
    const results = [];
    for (const tag of tags) {
        const parts = tag.split('/').filter(Boolean);
        let parent;
        for (const part of parts) {
            const value = parent ? `${parent.value}/${part}` : part;
            parent = await repository.upsertValue({ userId, value, parentId: parent?.id });
        }
        if (parent) {
            results.push(parent);
        }
    }
    return results;
};
exports.upsertTags = upsertTags;
//# sourceMappingURL=tag.js.map