"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWarning = isWarning;
const String_1 = require("./String");
// This is quite lax by design: it's up to the user to check .warnings!
const WarningRE = /\bwarning: |\bnothing to (?:write|do)\b/i;
/**
 * This is the default implementation of IgnorableError, and ignores null,
 * undefined, errors without a message, warnings about duplicate tags, and
 * ICC_Profile deletions.
 */
function isWarning(err) {
    if (err == null)
        return true;
    const msg = (err instanceof Error ? err.message : (0, String_1.toS)(err)).trim();
    return (0, String_1.blank)(msg) || WarningRE.test(msg);
}
//# sourceMappingURL=IsWarning.js.map