"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var CliUtilityService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliUtilityService = void 0;
const common_1 = require("@nestjs/common");
let CliUtilityService = CliUtilityService_1 = class CliUtilityService {
    parseBoolean(val) {
        val = val.toLowerCase();
        const trueValue = CliUtilityService_1.trueValues.some((tVal) => tVal === val);
        const falseValue = CliUtilityService_1.falseValues.some((fVal) => fVal === val);
        if (trueValue) {
            return true;
        }
        if (falseValue) {
            return false;
        }
        throw new Error(`${val} is not a proper value for a boolean input. Please use ${CliUtilityService_1.falseValues.join(', ')} for a "false" value or ${CliUtilityService_1.trueValues.join(', ')} for a "true" value`);
    }
    parseInt(val, radix = 10) {
        return Number.parseInt(val, radix);
    }
    parseFloat(val) {
        return Number.parseFloat(val);
    }
};
exports.CliUtilityService = CliUtilityService;
CliUtilityService.trueValues = ['yes', '1', 'y', 'true', 't'];
CliUtilityService.falseValues = ['no', 'n', '0', 'false', 'f'];
exports.CliUtilityService = CliUtilityService = CliUtilityService_1 = __decorate([
    (0, common_1.Injectable)()
], CliUtilityService);
//# sourceMappingURL=cli-utility.service.js.map