export declare const CommandMeta: string;
export declare const SubCommandMeta: string;
export declare const RootCommandMeta: string;
export declare const OptionMeta: string;
export declare const OptionChoiceMeta: string;
export declare const QuestionSetMeta: string;
export declare const QuestionMeta: string;
export declare const ValidateMeta: string;
export declare const TransformMeta: string;
export declare const WhenMeta: string;
export declare const ChoicesMeta: string;
export declare const DefaultMeta: string;
export declare const MessageMeta: string;
export declare const Commander: unique symbol;
export declare const CommanderOptions: unique symbol;
export declare const Inquirer: unique symbol;
export declare const HelpMeta: string;
export declare const cliPluginError: (cliName?: string, pluginsAvailable?: boolean) => string;
export declare const COMPLETION_SH_TEMPLATE = "###-begin-{{app_name}}-completions-###\n#\n# nest commander command completion script\n#\n# Installation: {{app_path}} {{completion_command}} >> ~/.bashrc\n#    or {{app_path}} {{completion_command}} >> ~/.bash_profile on OSX.\n#\n_{{app_name}}_nest_commander_completions()\n{\n    local cur_word args type_list\n\n    cur_word=\"${COMP_WORDS[COMP_CWORD]}\"\n    args=(\"${COMP_WORDS[@]}\")\n\n    # Check if {{app_name}}_nest_commander_filesystem_completions is set to \"true\" or \"1\"\n    # If it is, use filename completion if last word starts with common filesystem operator chars\n    #  `.` , `/` or `~` e.g. `./`, `../`, `/`, `~/` \n    if [[ \"${{{app_name}}_nest_commander_filesystem_completions}\" == \"true\" ]] || [[ \"${{{app_name}}_nest_commander_filesystem_completions}\" == \"1\" ]]; then\n        if [[ \"${cur_word}\" =~ ^\\.  ]] || [[ \"${cur_word}\" =~ ^/ ]] || [[ \"${cur_word}\" =~ ^~ ]]; then\n            COMPREPLY=($(compgen -f -- \"${cur_word}\"))\n            return 0\n        fi\n    fi\n\n    # ask nest commander to generate completions.\n    type_list=$({{app_path}} completion \"${args[@]}\")\n\n    COMPREPLY=( $(compgen -W \"${type_list}\" -- ${cur_word}) )\n\n    # if no match was found, fall back to filename completion\n    if [ ${#COMPREPLY[@]} -eq 0 ]; then\n      COMPREPLY=()\n    fi\n\n    return 0\n}\ncomplete -o bashdefault -o default -F _{{app_name}}_nest_commander_completions {{app_name}} completion\n###-end-{{app_name}}-completions-###\n";
export declare const COMPLETION_ZSH_TEMPLATE = "#compdef {{app_name}}\n###-begin-{{app_name}}-completions-###\n#\n# nest commander command completion script\n#\n# Installation: {{app_path}} {{completion_command}} >> ~/.zshrc\n#    or {{app_path}} {{completion_command}} >> ~/.zprofile on OSX.\n#\n_{{app_name}}_nest_commander_completions()\n{\n  local reply\n  local si=$IFS\n\n  # Check if {{app_name}}_nest_commander_filesystem_completions is set to \"true\" or \"1\"\n  # If it is, use zsh filename completion if last word starts with common filesystem operator chars\n  #  `.` , `/` or `~` e.g. `./`, `../`, `/`, `~/` \n  if [[ \"${{{app_name}}_nest_commander_filesystem_completions}\" == \"true\" ]] || [[ \"${{{app_name}}_nest_commander_filesystem_completions}\" == \"1\" ]]; then\n    if [[ \"${words[-1]}\" =~ ^\\.  ]] || [[ \"${words[-1]}\" =~ ^/ ]] || [[ \"${words[-1]}\" =~ ^~ ]]; then\n      _path_files\n      return\n    fi\n  fi\n\n  IFS=$'\n' reply=($(COMP_CWORD=\"$((CURRENT-1))\" COMP_LINE=\"$BUFFER\" COMP_POINT=\"$CURSOR\" {{app_path}} completion \"${words[@]}\"))\n  IFS=$si\n\n  # if no match was found, fall back to filename completion\n  if [[ -z \"${reply[*]}\" ]]; then\n    _path_files\n    return\n  fi\n\n  _describe 'values' reply\n}\ncompdef _{{app_name}}_nest_commander_completions {{app_name}}\n###-end-{{app_name}}-completions-###\n";
