"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InjectableProxy = InjectableProxy;
const common_1 = require("@nestjs/common");
const proxy_provider_constants_1 = require("./proxy-provider.constants");
/**
 * Mark a Proxy provider with this decorator to distinguish it from regular NestJS singleton providers
 */
function InjectableProxy(options = {}) {
    return (target) => (0, common_1.Injectable)()((0, common_1.SetMetadata)(proxy_provider_constants_1.CLS_PROXY_METADATA_KEY, options)(target));
}
//# sourceMappingURL=injectable-proxy.decorator.js.map