/*
 *  endian.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _ENDIAN_H_INCLUDED
#define _ENDIAN_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#if defined( _POSIX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */

#define LITTLE_ENDIAN   1234
#define BIG_ENDIAN      4321

#define _SWAPNC_16(w)   \
(\
    (((w) & 0x00FFU) << 8)\
    | (((w) & 0xFF00U) >> 8)\
)
#define _SWAPNC_32(w)   \
(\
    (((w) & 0x000000FFUL) << 24)\
    | (((w) & 0x0000FF00UL) << 8)\
    | (((w) & 0x00FF0000UL) >> 8)\
    | (((w) & 0xFF000000UL) >> 24)\
)
#define _SWAPNC_64(w)   \
(\
    (((w) & 0x00000000000000FFULL) << 56)\
    | (((w) & 0x000000000000FF00ULL) << 40)\
    | (((w) & 0x0000000000FF0000ULL) << 24)\
    | (((w) & 0x00000000FF000000ULL) << 8)\
    | (((w) & 0x000000FF00000000ULL) >> 8)\
    | (((w) & 0x0000FF0000000000ULL) >> 24)\
    | (((w) & 0x00FF000000000000ULL) >> 40)\
    | (((w) & 0xFF00000000000000ULL) >> 56)\
)

#define BYTE_ORDER      LITTLE_ENDIAN

#define htobe16(x) _SWAPNC_16(x)
#define htole16(x) (x)
#define be16toh(x) _SWAPNC_16(x)
#define le16toh(x) (x)

#define htobe32(x) _SWAPNC_32(x)
#define htole32(x) (x)
#define be32toh(x) _SWAPNC_32(x)
#define le32toh(x) (x)

#define htobe64(x) _SWAPNC_64(x)
#define htole64(x) (x)
#define be64toh(x) _SWAPNC_64(x)
#define le64toh(x) (x)

#endif /* extensions enabled */

#endif
