/*
 *  aclui.h     Access control user interface functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ACLUI_H_
#define _ACLUI_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <objbase.h>
#include <commctrl.h>
#include <accctrl.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify access control user interface functions */
#define ACLUIAPI    DECLSPEC_IMPORT WINAPI

/* ISecurityInformation object information flags */
#define SI_EDIT_PERMS                       0x00000000L
#define SI_EDIT_OWNER                       0x00000001L
#define SI_EDIT_AUDITS                      0x00000002L
#define SI_CONTAINER                        0x00000004L
#define SI_READONLY                         0x00000008L
#define SI_ADVANCED                         0x00000010L
#define SI_RESET                            0x00000020L
#define SI_OWNER_READONLY                   0x00000040L
#define SI_EDIT_PROPERTIES                  0x00000080L
#define SI_OWNER_RECURSE                    0x00000100L
#define SI_NO_ACL_PROTECT                   0x00000200L
#define SI_NO_TREE_APPLY                    0x00000400L
#define SI_PAGE_TITLE                       0x00000800L
#define SI_SERVER_IS_DC                     0x00001000L
#define SI_RESET_DACL_TREE                  0x00004000L
#define SI_RESET_SACL_TREE                  0x00008000L
#define SI_OBJECT_GUID                      0x00010000L
#define SI_EDIT_EFFECTIVE                   0x00020000L
#define SI_RESET_DACL                       0x00040000L
#define SI_RESET_SACL                       0x00080000L
#define SI_RESET_OWNER                      0x00100000L
#define SI_NO_ADDITIONAL_PERMISSION         0x00200000L
#if (NTDDI_VERSION >= 0x06000000)
    #define SI_VIEW_ONLY                    0x00400000L
    #define SI_PERMS_ELEVATION_REQUIRED     0x01000000L
    #define SI_AUDITS_ELEVATION_REQUIRED    0x02000000L
    #define SI_OWNER_ELEVATION_REQUIRED     0x04000000L
#endif
#define SI_MAY_WRITE                        0x10000000L
#define SI_EDIT_ALL \
    (SI_EDIT_PERMS | SI_EDIT_OWNER | SI_EDIT_AUDITS)

/* ISecurityInformation access flags */
#define SI_ACCESS_SPECIFIC  0x00010000L
#define SI_ACCESS_GENERAL   0x00020000L
#define SI_ACCESS_CONTAINER 0x00040000L
#define SI_ACCESS_PROPERTY  0x00080000L

/* ISecurityInformation property sheet page callback messages */
#define PSPCB_SI_INITDIALOG (WM_USER + 1)

/* Security identifier information list clipboard format */
#define CFSTR_ACLUI_SID_INFO_LIST   TEXT("CFSTR_ACLUI_SID_INFO_LIST")

/* ISecurityInformation object information */
typedef struct _SI_OBJECT_INFO {
    DWORD       dwFlags;
    HINSTANCE   hInstance;
    LPWSTR      pszServerName;
    LPWSTR      pszObjectName;
    LPWSTR      pszPageTitle;
    GUID        guidObjectType;
} SI_OBJECT_INFO;
typedef SI_OBJECT_INFO  *PSI_OBJECT_INFO;

/* ISecurityInformation access */
typedef struct _SI_ACCESS {
    const GUID  *pguid;
    ACCESS_MASK mask;
    LPCWSTR     pszName;
    DWORD       dwFlags;
} SI_ACCESS;
typedef SI_ACCESS   *PSI_ACCESS;

/* ISecurityInformation inherit type */
typedef struct _SI_INHERIT_TYPE {
    const GUID  *pguid;
    ULONG       dwFlags;
    LPCWSTR     pszName;
} SI_INHERIT_TYPE;
typedef SI_INHERIT_TYPE *PSI_INHERIT_TYPE;

/* ISecurityInformation page types */
typedef enum _SI_PAGE_TYPE {
    SI_PAGE_PERM            = 0,
    SI_PAGE_ADVPERM         = 1,
    SI_PAGE_AUDIT           = 2,
    SI_PAGE_OWNER           = 3,
#if (NTDDI_VERSION >= 0x06000000)
    SI_PAGE_EFFECTIVE       = 4,
    SI_PAGE_TAKEOWNERSHIP   = 5
#else
    SI_PAGE_EFFECTIVE       = 4
#endif
} SI_PAGE_TYPE;

/* Security identifier information */
typedef struct _SID_INFO {
    PSID    pSid;
    PWSTR   pwzCommonName;
    PWSTR   pwzClass;
    PWSTR   pwzUPN;
} SID_INFO;
typedef SID_INFO    *PSID_INFO;

/* Security identifier information list */
typedef struct _SID_INFO_LIST {
    ULONG       cItems;
    SID_INFO    aSidInfo[ANYSIZE_ARRAY];
} SID_INFO_LIST;
typedef SID_INFO_LIST   *PSID_INFO_LIST;

/* ISecurityInformation interface */
#undef INTERFACE
#define INTERFACE   ISecurityInformation
DECLARE_INTERFACE_( ISecurityInformation, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISecurityInformation methods */
    STDMETHOD( GetObjectInformation )( THIS_ PSI_OBJECT_INFO ) PURE;
    STDMETHOD( GetSecurity )( THIS_ SECURITY_INFORMATION, PSECURITY_DESCRIPTOR *, BOOL ) PURE;
    STDMETHOD( SetSecurity )( THIS_ SECURITY_INFORMATION, PSECURITY_DESCRIPTOR ) PURE;
    STDMETHOD( GetAccessRights )( THIS_ const GUID *, DWORD, PSI_ACCESS *, ULONG *, ULONG * ) PURE;
    STDMETHOD( MapGeneric )( THIS_ const GUID *, UCHAR *, ACCESS_MASK * ) PURE;
    STDMETHOD( GetInheritTypes )( THIS_ PSI_INHERIT_TYPE *, ULONG * ) PURE;
    STDMETHOD( PropertySheetPageCallback )( THIS_ HWND, UINT, SI_PAGE_TYPE ) PURE;
};
typedef ISecurityInformation    *LPSECURITYINFO;

/* ISecurityInformation2 interface */
#undef INTERFACE
#define INTERFACE   ISecurityInformation2
DECLARE_INTERFACE_( ISecurityInformation2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISecurityInformation2 methods */
    STDMETHOD_( BOOL, IsDaclCanonical )( THIS_ PACL ) PURE;
    STDMETHOD( LookupSids )( ULONG, PSID *, LPDATAOBJECT * ) PURE;
};
typedef ISecurityInformation2   *LPSECURITYINFO2;

/* IEffectivePermission interface */
#undef INTERFACE
#define INTERFACE   IEffectivePermission
DECLARE_INTERFACE_( IEffectivePermission, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEffectivePermission methods */
    STDMETHOD( GetEffectivePermission )( THIS_ const GUID *, PSID, LPCWSTR, PSECURITY_DESCRIPTOR, POBJECT_TYPE_LIST *, ULONG *, PACCESS_MASK *, ULONG * ) PURE;
};
typedef IEffectivePermission    *LPEFFECTIVEPERMISSION;

/* ISecurityObjectTypeInfo interface */
#undef INTERFACE
#define INTERFACE   ISecurityObjectTypeInfo
DECLARE_INTERFACE_( ISecurityObjectTypeInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISecurityObjectTypeInfo methods */
    STDMETHOD( GetInheritSource )( SECURITY_INFORMATION, PACL, PINHERITED_FROM * ) PURE;
};
typedef ISecurityObjectTypeInfo *LPSecurityObjectTypeInfo;

/* ISecurityInformation3 interface */
#if (NTDDI_VERSION >= 0x06000000)
#undef INTERFACE
#define INTERFACE   ISecurityInformation3
DECLARE_INTERFACE_( ISecurityInformation3, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISecurityInformation3 methods */
    STDMETHOD( GetFullResourceName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( OpenElevatedEditor )( THIS_ HWND, SI_PAGE_TYPE ) PURE;
};
typedef ISecurityInformation3   *LPSECURITYINFO3;
#endif

/* Functions in ACLUI.DLL */
HPROPSHEETPAGE ACLUIAPI CreateSecurityPage( LPSECURITYINFO );
BOOL ACLUIAPI           EditSecurity( HWND, LPSECURITYINFO );
#if (NTDDI_VERSION >= 0x06000000)
HRESULT ACLUIAPI        EditSecurityAdvanced( HWND, LPSECURITYINFO, SI_PAGE_TYPE );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_ISecurityInformation;
EXTERN_C const IID  __cdecl IID_ISecurityInformation2;
EXTERN_C const IID  __cdecl IID_IEffectivePermission;
EXTERN_C const IID  __cdecl IID_ISecurityObjectTypeInfo;
#if (NTDDI_VERSION >= 0x06000000)
EXTERN_C const IID  __cdecl IID_ISecurityInformation3;
#endif

#endif /* _ACLUI_H_ */
