/*
 *  basetyps.h  Macros to declare COM interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _BASETYPS_H_
#define _BASETYPS_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <guiddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macro used to specify extern "C" */
#ifdef __cplusplus
    #define EXTERN_C    extern "C"
#else
    #define EXTERN_C    extern
#endif

/* Standard method and API calling conventions */
#define STDMETHODCALLTYPE   __stdcall
#define STDMETHODVCALLTYPE  __cdecl
#define STDAPICALLTYPE      __stdcall
#define STDAPIVCALLTYPE     __cdecl

/* Standard method implementation and API declaration macros */
#define STDAPI                      EXTERN_C HRESULT STDAPICALLTYPE
#define STDAPI_( x )                EXTERN_C x STDAPICALLTYPE
#define STDAPIV                     EXTERN_C HRESULT STDAPIVCALLTYPE
#define STDAPIV_( x )               EXTERN_C x STDAPIVCALLTYPE
#define STDMETHODIMP                HRESULT STDMETHODCALLTYPE
#define STDMETHODIMP_( x )          x STDMETHODCALLTYPE
#define STDMETHODIMPV               HRESULT STDMETHODVCALLTYPE
#define STDMETHODIMPV_( x )         x STDMETHODVCALLTYPE

/*
 * Macros to declare interfaces - these macros can be used for both C and C++. Define
 * CINTERFACE to have these macros expand in C++ code as if they were in C code.
 * Define CONST_VTABLE to have constant vtables in C. 
 */
#if defined( __cplusplus ) && !defined( CINTERFACE )
    #define __STRUCT__                              struct
    #define interface                               __STRUCT__
    #define STDMETHOD( f )                          virtual HRESULT STDMETHODCALLTYPE f
    #define STDMETHOD_( x, f )                      virtual x STDMETHODCALLTYPE f
    #define STDMETHODV( f )                         virtual HRESULT STDMETHODVCALLTYPE f
    #define STDMETHODV_( x, f )                     virtual x STDMETHODVCALLTYPE f
    #define PURE                                    = 0
    #define THIS_
    #define THIS                                    void
    #define DECLARE_INTERFACE( x )                  interface x
    #define DECLARE_INTERFACE_( x, p )              interface x : public p
#else
    #define interface                               struct
    #define STDMETHOD( f )                          HRESULT (STDMETHODCALLTYPE *f)
    #define STDMETHOD_( x, f )                      x (STDMETHODCALLTYPE *f)
    #define STDMETHODV( f )                         HRESULT (STDMETHODVCALLTYPE *f)
    #define STDMETHODV_( x, f )                     x (STDMETHODVCALLTYPE *f)
    #define PURE
    #define THIS_                                   INTERFACE FAR *This,
    #define THIS                                    INTERFACE FAR *This
    #ifdef CONST_VTABLE
        #define DECLARE_INTERFACE( x ) \
            typedef interface x { \
                const struct x##Vtbl *lpVtbl; \
            } x; \
            typedef const struct x##Vtbl x##Vtbl; \
            const struct x##Vtbl
    #else
        #define DECLARE_INTERFACE( x ) \
            typedef interface x { \
                struct x##Vtbl *lpVtbl; \
            } x; \
            typedef struct x##Vtbl x##Vtbl; \
            struct x##Vtbl
    #endif
    #define DECLARE_INTERFACE_( x, p )              DECLARE_INTERFACE( x )
#endif
#define IFACEMETHOD( f )                            STDMETHOD( f )
#define IFACEMETHOD_( x, f )                        STDMETHOD_( x, f )
#define IFACEMETHODV( f )                           STDMETHODV( f )
#define IFACEMETHODV_( x, f )                       STDMETHODV_( x, f )
/*
 * header files internal macros used to simplify complexity
 */
#if defined( __cplusplus ) && !defined( CINTERFACE )
    #define _INTRFMEMBP( x, y, ... )                ((x)->y( __VA_ARGS__ ))
    #define _INTRFMEMBN( x, y )                     ((x)->y())
#else
    #define _INTRFMEMBP( x, y, ... )                ((x)->lpVtbl->y( x, __VA_ARGS__ ))
    #define _INTRFMEMBN( x, y )                     ((x)->lpVtbl->y( x ))
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _BASETYPS_H_ */
