/*
 *  ctl3d.h     3D control functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Ctl3dAutoSubclassEx() flags */
#define CTL3D_SUBCLASS_DYNCREATE    0x00000001L
#define CTL3D_NOSUBCLASS_DYNCREATE  0x00000002L

/* 3D control identifiers */
#define CTL3D_BUTTON_CTL    0
#define CTL3D_LISTBOX_CTL   1
#define CTL3D_EDIT_CTL      2
#define CTL3D_COMBO_CTL     3
#define CTL3D_STATIC_CTL    4

/* Ctl3dSubclassDlg() flags */
#define CTL3D_BUTTONS           0x0001
#define CTL3D_LISTBOXES         0x0002
#define CTL3D_EDITS             0x0004
#define CTL3D_COMBOS            0x0008
#define CTL3D_STATICTEXTS       0x0010
#define CTL3D_STATICFRAMES      0x0020
#define CTL3D_ALL               0xffff

/* Ctl3dSubclassDlgEx() flags */
#define CTL3D_NODLGWINDOW       0x00010000

/* 3D control messages */
#define WM_DLGBORDER            (WM_USER + 3567)
#define WM_DLGSUBCLASS          (WM_USER + 3568)
#define CTLMSGOFFSET            3569
#define CTL3D_CTLCOLORMSGBOX    (WM_USER + CTLMSGOFFSET + 0)
#define CTL3D_CTLCOLOREDIT      (WM_USER + CTLMSGOFFSET + 1)
#define CTL3D_CTLCOLORLISTBOX   (WM_USER + CTLMSGOFFSET + 2)
#define CTL3D_CTLCOLORBTN       (WM_USER + CTLMSGOFFSET + 3)
#define CTL3D_CTLCOLORSCROLLBAR (WM_USER + CTLMSGOFFSET + 4)
#define CTL3D_CTLCOLORSTATIC    (WM_USER + CTLMSGOFFSET + 5)
#define CTL3D_CTLCOLORDLG       (WM_USER + CTLMSGOFFSET + 6)

/* WM_DLGBORDER return codes */
#define CTL3D_NOBORDER  0
#define CTL3D_BORDER    1

/* WM_DLGSUBCLASS return codes */
#define CTL3D_NOSUBCLASS    0
#define CTL3D_SUBCLASS      1

/* 3D control resource identifiers */
#define CTL3D_3DCHECK   26567

/* Functions in CTL3D32.DLL */
BOOL WINAPI     Ctl3dAutoSubclass( HINSTANCE );
BOOL WINAPI     Ctl3dAutoSubclassEx( HINSTANCE, WORD );
BOOL WINAPI     Ctl3dColorChange( void );
HBRUSH WINAPI   Ctl3dCtlColor( HDC, LONG );
HBRUSH WINAPI   Ctl3dCtlColorEx( UINT, WPARAM, LPARAM );
LONG WINAPI     Ctl3dDlgFramePaint( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI     Ctl3dEnabled( void );
WORD WINAPI     Ctl3dGetVer( void );
BOOL WINAPI     Ctl3dIsAutoSubclass( VOID );
BOOL WINAPI     Ctl3dRegister( HINSTANCE );
BOOL WINAPI     Ctl3dSubclassCtl( HWND );
BOOL WINAPI     Ctl3dSubclassCtlEx( HWND, int );
BOOL WINAPI     Ctl3dSubclassDlg( HWND, WORD );
BOOL WINAPI     Ctl3dSubclassDlgEx( HWND, DWORD );
BOOL WINAPI     Ctl3dUnAutoSubclass( VOID );
BOOL WINAPI     Ctl3dUnregister( HINSTANCE );
BOOL WINAPI     Ctl3dUnsubclassCtl( HWND );
VOID WINAPI     Ctl3dWinIniChange( void );

#ifdef __cplusplus
} /* extern "C" */
#endif
