/*
 *  ntddk.h     NT Device Driver Kit (DDK) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDDK_
#define _NTDDK_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <wdm.h>
#include <mce.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef GUID    UUID;
typedef ULONG   NODE_REQUIREMENT;

/* Kernel stack sizes */
#ifdef _X86_
    #define KERNEL_STACK_SIZE           12288
    #define KERNEL_LARGE_STACK_SIZE     61440
    #define KERNEL_LARGE_STACK_COMMIT   12288
#endif

/* Size of the 80387 registers in the x86 context record */
#ifdef _X86_
    #define SIZE_OF_80387_REGISTERS 80
#endif

/* Context flags for the x86 processor */
#ifdef _X86_
    #define CONTEXT_i386                0x00010000L
    #define CONTEXT_i486                0x00010000L
    #define CONTEXT_CONTROL             (CONTEXT_i386 | 0x00000001L)
    #define CONTEXT_INTEGER             (CONTEXT_i386 | 0x00000002L)
    #define CONTEXT_SEGMENTS            (CONTEXT_i386 | 0x00000004L)
    #define CONTEXT_FLOATING_POINT      (CONTEXT_i386 | 0x00000008L)
    #define CONTEXT_DEBUG_REGISTERS     (CONTEXT_i386 | 0x00000010L)
    #define CONTEXT_EXTENDED_REGISTERS  (CONTEXT_i386 | 0x00000020L)
    #define CONTEXT_XSTATE              (CONTEXT_i386 | 0x00000040L)
    #define CONTEXT_FULL \
        (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS)
    #define CONTEXT_ALL  \
        (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS | \
        CONTEXT_FLOATING_POINT | CONTEXT_DEBUG_REGISTERS | \
        CONTEXT_EXTENDED_REGISTERS)
#endif

/* Unsolicited input privilege */
#define SE_UNSOLICITED_INPUT_PRIVILEGE  6L

/* Run once initializer */
#define RTL_RUN_ONCE_INIT   { 0 }

/* Run once flags */
#define RTL_RUN_ONCE_CHECK_ONLY     0x00000001L
#define RTL_RUN_ONCE_ASYNC          0x00000002L
#define RTL_RUN_ONCE_INIT_FAILED    0x00000004L

/* Hash flags */
#define RTL_HASH_ALLOCATED_HEADER   0x00000001L

/* Stack walking mode frames to skip shift */
#define RTL_STACK_WALKING_MODE_FRAMES_TO_SKIP_SHIFT 8

/* Version comparison operators */
#define VER_EQUAL           1
#define VER_GREATER         2
#define VER_GREATER_EQUAL   3
#define VER_LESS            4
#define VER_LESS_EQUAL      5
#define VER_AND             6
#define VER_OR              7

/* Version information types */
#define VER_MINORVERSION        0x00000001L
#define VER_MAJORVERSION        0x00000002L
#define VER_BUILDNUMBER         0x00000004L
#define VER_PLATFORMID          0x00000008L
#define VER_SERVICEPACKMINOR    0x00000010L
#define VER_SERVICEPACKMAJOR    0x00000020L
#define VER_SUITENAME           0x00000040L
#define VER_PRODUCT_TYPE        0x00000080L

/* Version product types */
#define VER_NT_WORKSTATION          0x01
#define VER_NT_DOMAIN_CONTROLLER    0x02
#define VER_NT_SERVER               0x03

/* Version platform identifiers */
#define VER_PLATFORM_WIN32s         0L
#define VER_PLATFORM_WIN32_WINDOWS  1L
#define VER_PLATFORM_WIN32_NT       2L

/* File device characteristics */
#if (NTDDI_VERSION >= 0x06010000)
    #define FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_EX          0x00004000L
    #define FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_EX         0x00008000L
    #define FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_EX \
        (FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_EX | \
        FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_EX)
    #define FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_DEPRECATED  0x00000200L
    #define FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_DEPRECATED 0x00000300L
    #define FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_DEPRECATED     0x00000300L
#else
    #define FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL             0x00000200L
    #define FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL            0x00000300L
    #define FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK                0x00000300L
    #define FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_EX \
        FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL
    #define FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_EX \
        FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL
    #define FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_EX \
        FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK
#endif
#define FILE_CHARACTERISTICS_PROPAGATED \
    (FILE_REMOVABLE_MEDIA | FILE_READ_ONLY_DEVICE | FILE_FLOPPY_DISKETTE | \
    FILE_WRITE_ONCE_MEDIA | FILE_DEVICE_SECURE_OPEN)

/* AVIO device I/O control codes */
#define IOCTL_AVIO_ALLOCATE_STREAM \
    CTL_CODE( FILE_DEVICE_AVIO, 1, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
#define IOCTL_AVIO_FREE_STREAM \
    CTL_CODE( FILE_DEVICE_AVIO, 2, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )
#define IOCTL_AVIO_MODIFY_STREAM \
    CTL_CODE( FILE_DEVICE_AVIO, 3, METHOD_BUFFERED, FILE_SPECIAL_ACCESS )

/* Process device map flags */
#define PROCESS_LUID_DOSDEVICES_ONLY    0x00000001L

/* Maximum number of process handle tracing stacks */
#define PROCESS_HANDLE_TRACING_MAX_STACKS   16

/* Quota limits flags */
#define QUOTA_LIMITS_HARDWS_MIN_ENABLE  0x00000001L
#define QUOTA_LIMITS_HARDWS_MIN_DISABLE 0x00000002L
#define QUOTA_LIMITS_HARDWS_MAX_ENABLE  0x00000004L
#define QUOTA_LIMITS_HARDWS_MAX_DISABLE 0x00000008L
#define QUOTA_LIMITS_USE_DEFAULT_LIMITS 0x00000010L

/* Maximum number of hardware counters */
#define MAX_HW_COUNTERS 16

/* Thread profiling flags */
#define THREAD_PROFILING_FLAG_DISPATCH  0x00000001L

/* Process exception port state flags */
#define PROCESS_EXCEPTION_PORT_ALL_STATE_BITS   3
#define PROCESS_EXCEPTION_PORT_ALL_STATE_FLAGS \
    ((ULONG_PTR)((1 << PROCESS_EXCEPTION_PORT_ALL_STATE_BITS) - 1))

/* Processor control region version numbers */
#ifdef _X86_
    #define PCR_MINOR_VERSION   1
    #define PCR_MAJOR_VERSION   1
#endif

/* Various shifts */
#ifdef _X86_
    #define PDI_SHIFT_X86       22
    #define PDI_SHIFT_X86PAE    21
    #define PDI_SHIFT           PDI_SHIFT_X86
    #define PPI_SHIFT           30
    #define PTI_SHIFT           12
#endif

/* Guard page size */
#ifdef _X86_
    #define GUARD_PAGE_SIZE PAGE_SIZE
#endif

/* Memory management special addresses */
#ifdef _X86_
    #define MM_SYSTEM_SPACE_END         0xFFFFFFFF
    #define MM_LOWEST_USER_ADDRESS      ((PVOID)0x00010000)
    #define MM_LOWEST_SYSTEM_ADDRESS    ((PVOID)0xC0C00000)
#endif

/* Driver verifier flags */
#define DRIVER_VERIFIER_SPECIAL_POOLING             0x0001
#define DRIVER_VERIFIER_FORCE_IRQL_CHECKING         0x0002
#define DRIVER_VERIFIER_INJECT_ALLOCATION_FAILURES  0x0004
#define DRIVER_VERIFIER_TRACK_POOL_ALLOCATIONS      0x0008
#define DRIVER_VERIFIER_IO_CHECKING                 0x0010

/* Extended state features */
#define XSTATE_LEGACY_FLOATING_POINT    0
#define XSTATE_LEGACY_SSE               1
#define XSTATE_GSSE                     2
#define MAXIMUM_XSTATE_FEATURES         64

/* Extended state feature masks */
#define XSTATE_MASK_LEGACY_FLOATING_POINT   (1LL << XSTATE_LEGACY_FLOATING_POINT)
#define XSTATE_MASK_LEGACY_SSE              (1LL << XSTATE_LEGACY_SSE)
#define XSTATE_MASK_GSSE                    (1LL << XSTATE_GSSE)
#define XSTATE_MASK_LEGACY \
    (XSTATE_MASK_LEGACY_FLOATING_POINT | XSTATE_MASK_LEGACY_SSE)

/* Maximum number of WOW64 shared entries */
#define MAX_WOW64_SHARED_ENTRIES    16

/* NX support policy values */
#define NX_SUPPORT_POLICY_ALWAYSOFF 0
#define NX_SUPPORT_POLICY_ALWAYSON  1
#define NX_SUPPORT_POLICY_OPTIN     2
#define NX_SUPPORT_POLICY_OPTOUT    3

/* Shared global flags */
#define SHARED_GLOBAL_FLAGS_ERROR_PORT_V                0
#define SHARED_GLOBAL_FLAGS_ERROR_PORT                  0x00000001L
#define SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED_V         1
#define SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED           0x00000002L
#define SHARED_GLOBAL_FLAGS_VIRT_ENABLED_V              2
#define SHARED_GLOBAL_FLAGS_VIRT_ENABLED                0x00000004L
#define SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED_V  3
#define SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED    0x00000008L
#define SHARED_GLOBAL_FLAGS_SPARE_V                     4
#define SHARED_GLOBAL_FLAGS_SPARE                       0x00000010L
#define SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED_V      5
#define SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED        0x00000020L
#define SHARED_GLOBAL_FLAGS_SEH_VALIDATION_ENABLED_V    6
#define SHARED_GLOBAL_FLAGS_SEH_VALIDATION_ENABLED      0x00000040L

/* Maximum resource type */
#define CmResourceTypeMaximum   8

/* PC card flags */
#define PCCARD_MAP_ERROR        0x01
#define PCCARD_DEVICE_PCI       0x10

/* PC card error codes */
#define PCCARD_SCAN_DISABLED    0x01
#define PCCARD_MAP_ZERO         0x02
#define PCCARD_NO_TIMER         0x03
#define PCCARD_NO_PIC           0x04
#define PCCARD_NO_LEGACY_BASE   0x05
#define PCCARD_DUP_LEGACY_BASE  0x06
#define PCCARD_NO_CONTROLLERS   0x07

/* Maximum expansion size */
#define MAXIMUM_EXPANSION_SIZE  (KERNEL_LARGE_STACK_SIZE - (PAGE_SIZE / 2 ))

/* Pool tag high order bit */
#define PROTECTED_POOL  0x80000000L

/* Node requirement special value */
#define MM_ANY_NODE_OK  0x80000000L

/* Image addressing modes */
#define IMAGE_ADDRESSING_MODE_32BIT 3

/* I/O request packet minor function codes for directory control */
#define IRP_MN_QUERY_DIRECTORY          0x01
#define IRP_MN_NOTIFY_CHANGE_DIRECTORY  0x02

/* I/O request packet minor function codes for file system control */
#define IRP_MN_USER_FS_REQUEST  0x00
#define IRP_MN_MOUNT_VOLUME     0x01
#define IRP_MN_VERIFY_VOLUME    0x02
#define IRP_MN_LOAD_FILE_SYSTEM 0x03
#define IRP_MN_TRACK_LINK       0x04
#define IRP_MN_KERNEL_CALL      0x04

/* I/O request packet minor function codes for lock control */
#define IRP_MN_LOCK                 0x01
#define IRP_MN_UNLOCK_SINGLE        0x02
#define IRP_MN_UNLOCK_ALL           0x03
#define IRP_MN_UNLOCK_ALL_BY_KEY    0x04

/* I/O request packet flush minor function code */
#define IRP_MN_FLUSH_AND_PURGE  0x01

/* I/O request packet minor function codes for read and write */
#define IRP_MN_NORMAL           0x00
#define IRP_MN_DPC              0x01
#define IRP_MN_MDL              0x02
#define IRP_MN_COMPLETE         0x04
#define IRP_MN_COMPRESSED       0x08
#define IRP_MN_MDL_DPC          (IRP_MN_MDL | IRP_MN_DPC)
#define IRP_MN_COMPLETE_MDL     (IRP_MN_COMPLETE | IRP_MN_MDL)
#define IRP_MN_COMPLETE_MDL_DPC (IRP_MN_COMPLETE_MDL | IRP_MN_DPC)
#define IRP_MN_QUERY_LEGACY_BUS_INFORMATION 0x18

/* I/O flags */
#define IO_CHECK_CREATE_PARAMETERS      0x0200
#define IO_ATTACH_DEVICE                0x0400
#define IO_IGNORE_SHARE_ACCESS_CHECK    0x0800

/* Device object flags */
#define DO_DEVICE_HAS_NAME              0x00000040L
#define DO_SYSTEM_BOOT_PARTITION        0x00000100L
#define DO_LONG_TERM_REQUESTS           0x00000200L
#define DO_NEVER_LAST_DEVICE            0x00000400L
#define DO_LOW_PRIORITY_FILESYSTEM      0x00010000L
#define DO_SUPPORTS_TRANSACTIONS        0x00040000L
#define DO_FORCE_NEITHER_IO             0x00080000L
#define DO_VOLUME_DEVICE_OBJECT         0x00100000L
#define DO_SYSTEM_SYSTEM_PARTITION      0x00200000L
#define DO_SYSTEM_CRITICAL_PARTITION    0x00400000L
#define DO_DISALLOW_EXECUTE             0x00800000L

/* Driver object flags */
#define DRVO_REINIT_REGISTERED      0x00000008L
#define DRVO_INITIALIZED            0x00000010L
#define DRVO_BOOTREINIT_REGISTERED  0x00000020L
#define DRVO_LEGACY_RESOURCES       0x00000040L

/* Transaction file system context */
#define TXF_MINIVERSION_DEFAULT_VIEW    0xFFFE

/* Arbiter flags */
#define ARBITER_FLAG_BOOT_CONFIG    0x00000001L

/* Arbiter interface flags */
#define ARBITER_PARTIAL 0x00000001L

/* Hardware abstraction layer dispatch table version number */
#define HAL_DISPATCH_VERSION    4

/* Hardware abstraction layer MCE constants */
#ifdef _X86_
    #define HAL_MCE_INTERRUPTS_BASED    0xFFFFFFFFL
    #define HAL_MCE_DISABLED            0x00000000L
    #define HAL_CMC_INTERRUPTS_BASED    HAL_MCE_INTERRUPTS_BASED
    #define HAL_CMC_DISABLED            HAL_MCE_DISABLED
    #define HAL_CPE_INTERRUPTS_BASED    HAL_MCE_INTERRUPTS_BASED
    #define HAL_CPE_DISABLED            HAL_MCE_DISABLED
    #define HAL_MCA_INTERRUPTS_BASED    HAL_MCE_INTERRUPTS_BASED
    #define HAL_MCA_DISABLED            HAL_MCE_DISABLED
#endif

/* Hardware abstraction layer platform flags */
#define HAL_PLATFORM_DISABLE_WRITE_COMBINING        0x00000001L
#define HAL_PLATFORM_DISABLE_PTCG                   0x00000004L
#define HAL_PLATFORM_DISABLE_UC_MAIN_MEMORY         0x00000008L
#define HAL_PLATFORM_ENABLE_WRITE_COMBINING_MMIO    0x00000010L
#define HAL_PLATFORM_ACPI_TABLES_CACHED             0x00000020L

/* PCI AGP rates */
#define PCI_AGP_RATE_1X 0x00000001L
#define PCI_AGP_RATE_2X 0x00000002L
#define PCI_AGP_RATE_4X 0x00000004L

/* PCI bus mode frequencies */
#define PCIX_MODE_CONVENTIONAL_PCI  0x00000000L
#define PCIX_MODE1_66MHZ            0x00000001L
#define PCIX_MODE1_100MHZ           0x00000002L
#define PCIX_MODE1_133MHZ           0x00000003L
#define PCIX_MODE2_266_66MHZ        0x00000009L
#define PCIX_MODE2_266_100MHZ       0x0000000AL
#define PCIX_MODE2_266_133MHZ       0x0000000BL
#define PCIX_MODE2_533_66MHZ        0x0000000DL
#define PCIX_MODE2_533_100MHZ       0x0000000EL
#define PCIX_MODE2_533_133MHZ       0x0000000FL

/* PCI version numbers */
#define PCIX_VERSION_MODE1_ONLY     0x00000000L
#define PCIX_VERSION_MODE2_ECC      0x00000001L
#define PCIX_VERSION_DUAL_MODE_ECC  0x00000002L

/* OSC flags */
#define OSC_FIRMWARE_FAILURE        0x02
#define OSC_UNRECOGNIZED_UUID       0x04
#define OSC_UNRECOGNIZED_REVISION   0x08
#define OSC_CAPABILITIES_MASKED     0x10

/* PCI root bus OSC method capability revision */
#define PCI_ROOT_BUS_OSC_METHOD_CAPABILITY_REVISION 0x01

/* PCI data tag and version number */
#define PCI_DATA_TAG        ' ICP'
#define PCI_DATA_VERSION    1

/* PCI bus interface standard version number */
#define PCI_BUS_INTERFACE_STANDARD_VERSION  1

/* Error types */
#define ERRTYP_INTERNAL         0x01
#define ERRTYP_BUS              0x10
#define ERRTYP_MEM              0x04
#define ERRTYP_TLB              0x05
#define ERRTYP_CACHE            0x06
#define ERRTYP_FUNCTION         0x07
#define ERRTYP_SELFTEST         0x08
#define ERRTYP_FLOW             0x09
#define ERRTYP_MAP              0x11
#define ERRTYP_IMPROPER         0x12
#define ERRTYP_UNIMPL           0x13
#define ERRTYP_LOSSOFLOCKSTEP   0x14
#define ERRTYP_RESPONSE         0x15
#define ERRTYP_PARITY           0x16
#define ERRTYP_PROTOCOL         0x17
#define ERRTYP_PATHERROR        0x18
#define ERRTYP_TIMEOUT          0x19
#define ERRTYP_POISONED         0x1A

/* Generic processor types */
#define GENPROC_PROCTYPE_XPF    0
#define GENPROC_PROCTYPE_IPF    1

/* Generic processor instruction sets */
#define GENPROC_PROCISA_X86     0
#define GENPROC_PROCISA_IPF     1
#define GENPROC_PROCISA_X64     2

/* Generic processor error types */
#define GENPROC_PROCERRTYPE_UNKNOWN 0
#define GENPROC_PROCERRTYPE_CACHE   1
#define GENPROC_PROCERRTYPE_TLB     2
#define GENPROC_PROCERRTYPE_BUS     4
#define GENPROC_PROCERRTYPE_MAE     8

/* Generic processor operations */
#define GENPROC_OP_GENERIC          0
#define GENPROC_OP_DATAREAD         1
#define GENPROC_OP_DATAWRITE        2
#define GENPROC_OP_INSTRUCTIONEXE   3

/* Generic processor flags */
#define GENPROC_FLAGS_RESTARTABLE   0x01
#define GENPROC_FLAGS_PRECISEIP     0x02
#define GENPROC_FLAGS_OVERFLOW      0x04
#define GENPROC_FLAGS_CORRECTED     0x08

/* XPF cache check transaction types */
#define XPF_CACHE_CHECK_TRANSACTIONTYPE_INSTRUCTION 0
#define XPF_CACHE_CHECK_TRANSACTIONTYPE_DATAACCESS  1
#define XPF_CACHE_CHECK_TRANSACTIONTYPE_GENERIC     2

/* XPF cache check operations */
#define XPF_CACHE_CHECK_OPERATION_GENERIC           0
#define XPF_CACHE_CHECK_OPERATION_GENREAD           1
#define XPF_CACHE_CHECK_OPERATION_GENWRITE          2
#define XPF_CACHE_CHECK_OPERATION_DATAREAD          3
#define XPF_CACHE_CHECK_OPERATION_DATAWRITE         4
#define XPF_CACHE_CHECK_OPERATION_INSTRUCTIONFETCH  5
#define XPF_CACHE_CHECK_OPERATION_PREFETCH          6
#define XPF_CACHE_CHECK_OPERATION_EVICTION          7
#define XPF_CACHE_CHECK_OPERATION_SNOOP             8

/* XPF TLB check transaction types */
#define XPF_TLB_CHECK_TRANSACTIONTYPE_INSTRUCTION   0
#define XPF_TLB_CHECK_TRANSACTIONTYPE_DATAACCESS    1
#define XPF_TLB_CHECK_TRANSACTIONTYPE_GENERIC       2

/* XPF TLB check operations */
#define XPF_TLB_CHECK_OPERATION_GENERIC             0
#define XPF_TLB_CHECK_OPERATION_GENREAD             1
#define XPF_TLB_CHECK_OPERATION_GENWRITE            2
#define XPF_TLB_CHECK_OPERATION_DATAREAD            3
#define XPF_TLB_CHECK_OPERATION_DATAWRITE           4
#define XPF_TLB_CHECK_OPERATION_INSTRUCTIONFETCH    5
#define XPF_TLB_CHECK_OPERATION_PREFETCH            6

/* XPF bus check transaction types */
#define XPF_BUS_CHECK_TRANSACTIONTYPE_INSTRUCTION   0
#define XPF_BUS_CHECK_TRANSACTIONTYPE_DATAACCESS    1
#define XPF_BUS_CHECK_TRANSACTIONTYPE_GENERIC       2

/* XPF bus check operations */
#define XPF_BUS_CHECK_OPERATION_GENERIC             0
#define XPF_BUS_CHECK_OPERATION_GENREAD             1
#define XPF_BUS_CHECK_OPERATION_GENWRITE            2
#define XPF_BUS_CHECK_OPERATION_DATAREAD            3
#define XPF_BUS_CHECK_OPERATION_DATAWRITE           4
#define XPF_BUS_CHECK_OPERATION_INSTRUCTIONFETCH    5
#define XPF_BUS_CHECK_OPERATION_PREFETCH            6

/* XPF bus check participation types */
#define XPF_BUS_CHECK_PARTICIPATION_PROCORIGINATED  0
#define XPF_BUS_CHECK_PARTICIPATION_PROCRESPONDED   1
#define XPF_BUS_CHECK_PARTICIPATION_PROCOBSERVED    2
#define XPF_BUS_CHECK_PARTICIPATION_GENERIC         3

/* XPF bus check address spaces */
#define XPF_BUS_CHECK_ADDRESS_MEMORY    0
#define XPF_BUS_CHECK_ADDRESS_RESERVED  1
#define XPF_BUS_CHECK_ADDRESS_IO        2
#define XPF_BUS_CHECK_ADDRESS_OTHER     3

/* XPF micro-architecture specific check error types */
#define XPF_MS_CHECK_ERRORTYPE_NOERROR              0
#define XPF_MS_CHECK_ERRORTYPE_UNCLASSIFIED         1
#define XPF_MS_CHECK_ERRORTYPE_MCROMPARITY          2
#define XPF_MS_CHECK_ERRORTYPE_EXTERNAL             3
#define XPF_MS_CHECK_ERRORTYPE_FRC                  4
#define XPF_MS_CHECK_ERRORTYPE_INTERNALUNCLASSIFIED 5

/* XPF context information constants */
#define XPF_CONTEXT_INFO_UNCLASSIFIEDDATA   0
#define XPF_CONTEXT_INFO_MSRREGISTERS       1
#define XPF_CONTEXT_INFO_32BITCONTEXT       2
#define XPF_CONTEXT_INFO_64BITCONTEXT       3
#define XPF_CONTEXT_INFO_FXSAVE             4
#define XPF_CONTEXT_INFO_32BITDEBUGREGS     5
#define XPF_CONTEXT_INFO_64BITDEBUGREGS     6
#define XPF_CONTEXT_INFO_MMREGISTERS        7

/* Windows Hardware Error Architecture memory error types */
#define WHEA_MEMERRTYPE_UNKNOWN             0x00
#define WHEA_MEMERRTYPE_NOERROR             0x01
#define WHEA_MEMERRTYPE_SINGLEBITECC        0x02
#define WHEA_MEMERRTYPE_MULTIBITECC         0x03
#define WHEA_MEMERRTYPE_SINGLESYMCHIPKILL   0x04
#define WHEA_MEMERRTYPE_MULTISYMCHIPKILL    0x05
#define WHEA_MEMERRTYPE_MASTERABORT         0x06
#define WHEA_MEMERRTYPE_TARGETABORT         0x07
#define WHEA_MEMERRTYPE_PARITYERROR         0x08
#define WHEA_MEMERRTYPE_WATCHDOGTIMEOUT     0x09
#define WHEA_MEMERRTYPE_INVALIDADDRESS      0x0A
#define WHEA_MEMERRTYPE_MIRRORBROKEN        0x0B
#define WHEA_MEMERRTYPE_MEMORYSPARING       0x0C

/* Windows Hardware Error Architecture error source descriptor version number */
#define WHEA_ERROR_SOURCE_DESCRIPTOR_VERSION_10 10

/* Maximum number of MC banks */
#define WHEA_MAX_MC_BANKS   32

/* Windows Hardware Error Architecture error source flags */
#define WHEA_ERROR_SOURCE_FLAG_FIRMWAREFIRST                0x00000001L
#define WHEA_ERROR_SOURCE_FLAG_GLOBAL                       0x00000002L
#define WHEA_ERROR_SOURCE_FLAG_PREALLOCATE_PER_PROCESSOR    0x00000004L
#define WHEA_ERROR_SOURCE_FLAG_DEFAULTSOURCE                0x80000000L

/* Windows Hardware Error Architecture error source descriptor types */
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_XPFMCE        0L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_XPFCMC        1L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_XPFNMI        2L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_IPFMCA        3L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_IPFCMC        4L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_IPFCPE        5L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_AERROOTPORT   6L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_AERENDPOINT   7L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_AERBRIDGE     8L
#define WHEA_ERROR_SOURCE_DESCRIPTOR_TYPE_GENERIC       9L

/* Windows Hardware Error Architecture XPF MC bank status formats */
#define WHEA_XPF_MC_BANK_STATUSFORMAT_IA32MCA       0L
#define WHEA_XPF_MC_BANK_STATUSFORMAT_Intel64MCA    1L
#define WHEA_XPF_MC_BANK_STATUSFORMAT_AMD64MCA      2L

/* Windows Hardware Error Architecture notification types */
#define WHEA_NOTIFICATION_TYPE_POLLED               0L
#define WHEA_NOTIFICATION_TYPE_EXTERNALINTERRUPT    1L
#define WHEA_NOTIFICATION_TYPE_LOCALINTERRUPT       2L
#define WHEA_NOTIFICATION_TYPE_SCI                  3L
#define WHEA_NOTIFICATION_TYPE_NMI                  4L

/* Windows Hardware Error Architecture section descriptor flags */
#define WHEA_SECTION_DESCRIPTOR_FLAGS_PRIMARY           0x00000001L
#define WHEA_SECTION_DESCRIPTOR_FLAGS_CONTAINMENTWRN    0x00000002L
#define WHEA_SECTION_DESCRIPTOR_FLAGS_RESET             0x00000004L
#define WHEA_SECTION_DESCRIPTOR_FLAGS_THRESHOLDEXCEEDED 0x00000008L
#define WHEA_SECTION_DESCRIPTOR_FLAGS_RESOURCENA        0x00000010L
#define WHEA_SECTION_DESCRIPTOR_FLAGS_LATENTERROR       0x00000020L

/* Windows Hardware Error Architecture section descriptor revision */
#define WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_REVISION   0x0201
#if WHEA_DOWNLEVEL_TYPE_NAMES
    #define WHEA_SECTION_DESCRIPTOR_REVISION \
        WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_REVISION
#endif

/* Windows Hardware Error Architecture error record flags */
#define WHEA_ERROR_RECORD_FLAGS_RECOVERED       0x00000001L
#define WHEA_ERROR_RECORD_FLAGS_PREVIOUSERROR   0x00000002L
#define WHEA_ERROR_RECORD_FLAGS_SIMULATED       0x00000004L

/* Windows Hardware Error Architecture error record validation flags */
#define WHEA_ERROR_RECORD_VALID_PLATFORMID  0x00000001L
#define WHEA_ERROR_RECORD_VALID_TIMESTAMP   0x00000002L
#define WHEA_ERROR_RECORD_VALID_PARTITIONID 0x00000004L

/* Windows Hardware Error Architecture error record signature and revision number */
#define WHEA_ERROR_RECORD_SIGNATURE     'REPC'
#define WHEA_ERROR_RECORD_REVISON       0x0210
#define WHEA_ERROR_RECORD_SIGNATURE_END 0xFFFFFFFFL

/* PCIX bus error types */
#define PCIXBUS_ERRTYPE_UNKNOWN             0x0000
#define PCIXBUS_ERRTYPE_DATAPARITY          0x0001
#define PCIXBUS_ERRTYPE_SYSTEM              0x0002
#define PCIXBUS_ERRTYPE_MASTERABORT         0x0003
#define PCIXBUS_ERRTYPE_BUSTIMEOUT          0x0004
#define PCIXBUS_ERRTYPE_MASTERDATAPARITY    0x0005
#define PCIXBUS_ERRTYPE_ADDRESSPARITY       0x0006
#define PCIXBUS_ERRTYPE_COMMANDPARITY       0x0007

/* Windows Hardware Error Architecture firmware record types */
#define WHEA_FIRMWARE_RECORD_TYPE_IPFSAL    0

/* Maximum number of XPF MCA extended registers */
#define WHEA_XPF_MCA_EXTREG_MAX_COUNT   24

/* Windows Hardware Error Architecture XPF MCA section version number */
#define WHEA_XPF_MCA_SECTION_VERSION    1L

/* Windows Hardware Error Architecture error packet version numbers and signatures */
#define WHEA_ERROR_PACKET_V1_SIGNATURE  'tPrE'
#define WHEA_ERROR_PACKET_V1_VERSION    2L
#define WHEA_ERROR_PACKET_V2_SIGNATURE  'AEHW'
#define WHEA_ERROR_PACKET_V2_VERSION    3L
#if (NTDDI_VERSION >= 0x06010000)
    #define WHEA_ERROR_PACKET_SIGNATURE WHEA_ERROR_PACKET_V2_SIGNATURE
    #define WHEA_ERROR_PACKET_VERSION   WHEA_ERROR_PACKET_V2_VERSION
#else
    #define WHEA_ERROR_PACKET_SIGNATURE WHEA_ERROR_PACKET_V1_SIGNATURE
    #define WHEA_ERROR_PACKET_VERSION   WHEA_ERROR_PACKET_V1_VERSION
    #define WHEA_ERROR_PKT_SIGNATURE    WHEA_ERROR_PACKET_SIGNATURE
    #define WHEA_ERROR_PKT_VERSION      WHEA_ERROR_PACKET_VERSION
#endif

/* Injection error types */
#define INJECT_ERRTYPE_PROCESSOR_CORRECTABLE            0x00000001L
#define INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLENONFATAL  0x00000002L
#define INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLEFATAL     0x00000004L
#define INJECT_ERRTYPE_MEMORY_CORRECTABLE               0x00000008L
#define INJECT_ERRTYPE_MEMORY_UNCORRECTABLENONFATAL     0x00000010L
#define INJECT_ERRTYPE_MEMORY_UNCORRECTABLEFATAL        0x00000020L
#define INJECT_ERRTYPE_PCIEXPRESS_CORRECTABLE           0x00000040L
#define INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLENONFATAL 0x00000080L
#define INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLEFATAL    0x00000100L
#define INJECT_ERRTYPE_PLATFORM_CORRECTABLE             0x00000200L
#define INJECT_ERRTYPE_PLATFORM_UNCORRECTABLENONFATAL   0x00000400L
#define INJECT_ERRTYPE_PLATFORM_UNCORRECTABLEFATAL      0x00000800L

/* Windows Hardware Error Architecture plugin registration packet version number */
#define WHEA_PLUGIN_REGISTRATION_PACKET_VERSION 0x00010000L

/* PSHED functional area mask flags */
#define PshedFADiscovery                0x00000001L
#define PshedFAErrorSourceControl       0x00000002L
#define PshedFAErrorRecordPersistence   0x00000004L
#define PshedFAErrorInfoRetrieval       0x00000008L
#define PshedFAErrorRecovery            0x00000010L
#define PshedFAErrorInjection           0x00000020L

/* Opaque data types */
typedef struct _PEB                             *PPEB;
typedef struct _BUS_HANDLER                     *PBUS_HANDLER;
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _WHEA_ERROR_SOURCE_DESCRIPTOR    *PWHEA_ERROR_SOURCE_DESCRIPTOR;
#endif

/* Floating save area for the x86 context */
#ifdef _X86_
typedef struct _FLOATING_SAVE_AREA {
    ULONG   ControlWord;
    ULONG   StatusWord;
    ULONG   TagWord;
    ULONG   ErrorOffset;
    ULONG   ErrorSelector;
    ULONG   DataOffset;
    ULONG   DataSelector;
    UCHAR   RegisterArea[SIZE_OF_80387_REGISTERS];
    ULONG   Cr0NpxState;
} FLOATING_SAVE_AREA;
typedef FLOATING_SAVE_AREA  *PFLOATING_SAVE_AREA;
#endif

/* Context record for the x86 processor */
#ifdef _X86_
typedef struct _CONTEXT {
    ULONG               ContextFlags;
    ULONG               Dr0;
    ULONG               Dr1;
    ULONG               Dr2;
    ULONG               Dr3;
    ULONG               Dr6;
    ULONG               Dr7;
    FLOATING_SAVE_AREA  FloatSave;
    ULONG               SegGs;
    ULONG               SegFs;
    ULONG               SegEs;
    ULONG               SegDs;
    ULONG               Edi;
    ULONG               Esi;
    ULONG               Ebx;
    ULONG               Edx;
    ULONG               Ecx;
    ULONG               Eax;
    ULONG               Ebp;
    ULONG               Eip;
    ULONG               SegCs;
    ULONG               EFlags;
    ULONG               Esp;
    ULONG               SegSs;
    UCHAR               ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
} CONTEXT;
typedef CONTEXT *PCONTEXT;
#endif

/* Well known SID types */
typedef enum {
    WinNullSid                                  = 0,
    WinWorldSid                                 = 1,
    WinLocalSid                                 = 2,
    WinCreatorOwnerSid                          = 3,
    WinCreatorGroupSid                          = 4,
    WinCreatorOwnerServerSid                    = 5,
    WinCreatorGroupServerSid                    = 6,
    WinNtAuthoritySid                           = 7,
    WinDialupSid                                = 8,
    WinNetworkSid                               = 9,
    WinBatchSid                                 = 10,
    WinInteractiveSid                           = 11,
    WinServiceSid                               = 12,
    WinAnonymousSid                             = 13,
    WinProxySid                                 = 14,
    WinEnterpriseControllersSid                 = 15,
    WinSelfSid                                  = 16,
    WinAuthenticatedUserSid                     = 17,
    WinRestrictedCodeSid                        = 18,
    WinTerminalServerSid                        = 19,
    WinRemoteLogonIdSid                         = 20,
    WinLogonIdsSid                              = 21,
    WinLocalSystemSid                           = 22,
    WinLocalServiceSid                          = 23,
    WinNetworkServiceSid                        = 24,
    WinBuiltinDomainSid                         = 25,
    WinBuiltinAdministratorsSid                 = 26,
    WinBuiltinUsersSid                          = 27,
    WinBuiltinGuestsSid                         = 28,
    WinBuiltinPowerUsersSid                     = 29,
    WinBuiltinAccountOperatorsSid               = 30,
    WinBuiltinSystemOperatorsSid                = 31,
    WinBuiltinPrintOperatorsSid                 = 32,
    WinBuiltinBackupOperatorsSid                = 33,
    WinBuiltinReplicatorSid                     = 34,
    WinBuiltinPreWindows2000CompatibleAccessSid = 35,
    WinBuiltinRemoteDesktopUsersSid             = 36,
    WinBuiltinNetworkConfigurationOperatorsSid  = 37,
    WinAccountAdministratorSid                  = 38,
    WinAccountGuestSid                          = 39,
    WinAccountKrbtgtSid                         = 40,
    WinAccountDomainAdminsSid                   = 41,
    WinAccountDomainUsersSid                    = 42,
    WinAccountDomainGuestsSid                   = 43,
    WinAccountComputersSid                      = 44,
    WinAccountControllersSid                    = 45,
    WinAccountCertAdminsSid                     = 46,
    WinAccountSchemaAdminsSid                   = 47,
    WinAccountEnterpriseAdminsSid               = 48,
    WinAccountPolicyAdminsSid                   = 49,
    WinAccountRasAndIasServersSid               = 50,
    WinNTLMAuthenticationSid                    = 51,
    WinDigestAuthenticationSid                  = 52,
    WinSChannelAuthenticationSid                = 53,
    WinThisOrganizationSid                      = 54,
    WinOtherOrganizationSid                     = 55,
    WinBuiltinIncomingForestTrustBuildersSid    = 56,
    WinBuiltinPerfMonitoringUsersSid            = 57,
    WinBuiltinPerfLoggingUsersSid               = 58,
    WinBuiltinAuthorizationAccessSid            = 59,
    WinBuiltinTerminalServerLicenseServersSid   = 60,
    WinBuiltinDCOMUsersSid                      = 61,
    WinBuiltinIUsersSid                         = 62,
    WinIUserSid                                 = 63,
    WinBuiltinCryptoOperatorsSid                = 64,
    WinUntrustedLabelSid                        = 65,
    WinLowLabelSid                              = 66,
    WinMediumLabelSid                           = 67,
    WinHighLabelSid                             = 68,
    WinSystemLabelSid                           = 69,
    WinWriteRestrictedCodeSid                   = 70,
    WinCreatorOwnerRightsSid                    = 71,
    WinCacheablePrincipalsGroupSid              = 72,
    WinNonCacheablePrincipalsGroupSid           = 73,
    WinEnterpriseReadonlyControllersSid         = 74,
    WinAccountReadonlyControllersSid            = 75,
    WinBuiltinEventLogReadersGroup              = 76,
    WinNewEnterpriseReadonlyControllersSid      = 77,
    WinBuiltinCertSvcDComAccessGroup            = 78,
    WinMediumPlusLabelSid                       = 79,
    WinLocalLogonSid                            = 80,
    WinConsoleLogonSid                          = 81,
    WinThisOrganizationCertificateSid           = 82
} WELL_KNOWN_SID_TYPE;

/* Run once */
typedef union _RTL_RUN_ONCE {
    PVOID   Ptr;
} RTL_RUN_ONCE;
typedef RTL_RUN_ONCE    *PRTL_RUN_ONCE;

/* Run once initialization function */
typedef ULONG       (NTAPI RTL_RUN_ONCE_INIT_FN)( PRTL_RUN_ONCE, PVOID, PVOID * );
typedef RTL_RUN_ONCE_INIT_FN    *PRTL_RUN_ONCE_INIT_FN;

/* Table search results */
typedef enum _TABLE_SEARCH_RESULT {
    TableEmptyTree      = 0,
    TableFoundNode      = 1,
    TableInsertAsLeft   = 2,
    TableInsertAsRight  = 3
} TABLE_SEARCH_RESULT;

/* Generic compare results */
typedef enum _RTL_GENERIC_COMPARE_RESULTS {
    GenericLessThan     = 0,
    GenericGreaterThan  = 1,
    GenericEqual        = 2
} RTL_GENERIC_COMPARE_RESULTS;

/* AVL callbacks */
typedef RTL_GENERIC_COMPARE_RESULTS (NTAPI RTL_AVL_COMPARE_ROUTINE)( struct _RTL_AVL_TABLE *, PVOID, PVOID );
typedef PVOID       (NTAPI RTL_AVL_ALLOCATE_ROUTINE)( struct _RTL_AVL_TABLE *, CLONG );
typedef VOID        (NTAPI RTL_AVL_FREE_ROUTINE)( struct _RTL_AVL_TABLE *, PVOID );
typedef NTSTATUS    (NTAPI RTL_AVL_MATCH_FUNCTION)( struct _RTL_AVL_TABLE *, PVOID, PVOID );
typedef RTL_AVL_COMPARE_ROUTINE     *PRTL_AVL_COMPARE_ROUTINE;
typedef RTL_AVL_ALLOCATE_ROUTINE    *PRTL_AVL_ALLOCATE_ROUTINE;
typedef RTL_AVL_FREE_ROUTINE        *PRTL_AVL_FREE_ROUTINE;
typedef RTL_AVL_MATCH_FUNCTION      *PRTL_AVL_MATCH_FUNCTION;
#ifdef RTL_USE_AVL_TABLES
    #define RTL_GENERIC_COMPARE_ROUTINE     RTL_AVL_COMPARE_ROUTINE
    #define PRTL_GENERIC_COMPARE_ROUTINE    PRTL_AVL_COMPARE_ROUTINE
    #define RTL_GENERIC_ALLOCATE_ROUTINE    RTL_AVL_ALLOCATE_ROUTINE
    #define PRTL_GENERIC_ALLOCATE_ROUTINE   PRTL_AVL_ALLOCATE_ROUTINE
    #define RTL_GENERIC_FREE_ROUTINE        RTL_AVL_FREE_ROUTINE
    #define PRTL_GENERIC_FREE_ROUTINE       PRTL_AVL_FREE_ROUTINE
#endif

/* Balacned links */
typedef struct _RTL_BALANCED_LINKS {
    struct _RTL_BALANCED_LINKS  *Parent;
    struct _RTL_BALANCED_LINKS  *LeftChild;
    struct _RTL_BALANCED_LINKS  *RightChild;
    CHAR                        Balance;
    UCHAR                       Reserved[3];
} RTL_BALANCED_LINKS;
typedef RTL_BALANCED_LINKS  *PRTL_BALANCED_LINKS;

/* AVL table */
typedef struct _RTL_AVL_TABLE {
    RTL_BALANCED_LINKS          BalancedRoot;
    PVOID                       OrderedPointer;
    ULONG                       WhichOrderedElement;
    ULONG                       NumberGenericTableElements;
    ULONG                       DepthOfTree;
    PRTL_BALANCED_LINKS         RestartKey;
    ULONG                       DeleteCount;
    PRTL_AVL_COMPARE_ROUTINE    CompareRoutine;
    PRTL_AVL_ALLOCATE_ROUTINE   AllocateRoutine;
    PRTL_AVL_FREE_ROUTINE       FreeRoutine;
    PVOID                       TableContext;
} RTL_AVL_TABLE;
typedef RTL_AVL_TABLE   *PRTL_AVL_TABLE;
#ifdef RTL_USE_AVL_TABLES
    #define RTL_GENERIC_TABLE   RTL_AVL_TABLE
    #define PRTL_GENERIC_TABLE  PRTL_AVL_TABLE
#endif

/* Splay links */
typedef struct _RTL_SPLAY_LINKS {
    struct _RTL_SPLAY_LINKS *Parent;
    struct _RTL_SPLAY_LINKS *LeftChild;
    struct _RTL_SPLAY_LINKS *RightChild;
} RTL_SPLAY_LINKS;
typedef RTL_SPLAY_LINKS *PRTL_SPLAY_LINKS;

/* Generic table callbacks */
#ifndef RTL_USE_AVL_TABLES
typedef RTL_GENERIC_COMPARE_RESULTS (NTAPI RTL_GENERIC_COMPARE_ROUTINE)( struct _RTL_GENERIC_TABLE *, PVOID, PVOID );
typedef PVOID       (NTAPI RTL_GENERIC_ALLOCATE_ROUTINE)( struct _RTL_GENERIC_TABLE *, CLONG );
typedef VOID        (NTAPI RTL_GENERIC_FREE_ROUTINE)( struct _RTL_GENERIC_TABLE *, PVOID );
typedef RTL_GENERIC_COMPARE_ROUTINE     *PRTL_GENERIC_COMPARE_ROUTINE;
typedef RTL_GENERIC_ALLOCATE_ROUTINE    *PRTL_GENERIC_ALLOCATE_ROUTINE;
typedef RTL_GENERIC_FREE_ROUTINE        *PRTL_GENERIC_FREE_ROUTINE;
#endif

/* Generic table */
#ifndef RTL_USE_AVL_TABLES
typedef struct _RTL_GENERIC_TABLE {
    PRTL_SPLAY_LINKS                TableRoots;
    LIST_ENTRY                      InsertOrderList;
    PLIST_ENTRY                     OrderedPointer;
    ULONG                           WhichOrderedElement;
    ULONG                           NumberGenericTableElements;
    PRTL_GENERIC_COMPARE_ROUTINE    CompareRoutine;
    PRTL_GENERIC_ALLOCATE_ROUTINE   AllocateRoutine;
    PRTL_GENERIC_FREE_ROUTINE       FreeRoutine;
    PVOID                           TableContext;
} RTL_GENERIC_TABLE;
typedef RTL_GENERIC_TABLE   *PRTL_GENERIC_TABLE;
#endif

/* Dynamic hash table entry */
typedef struct _RTL_DYNAMIC_HASH_TABLE_ENTRY {
    LIST_ENTRY  Linkage;
    ULONG_PTR   Signature;
} RTL_DYNAMIC_HASH_TABLE_ENTRY;
typedef RTL_DYNAMIC_HASH_TABLE_ENTRY    *PRTL_DYNAMIC_HASH_TABLE_ENTRY;

/* Macro to manipulate hash entries */
#define HASH_ENTRY_KEY( x ) ((x)->Signature)

/* Dynamic hash table context */
typedef struct _RTL_DYNAMIC_HASH_TABLE_CONTEXT {
    PLIST_ENTRY ChainHead;
    PLIST_ENTRY PrevLinkage;
    ULONG_PTR   Signature;
} RTL_DYNAMIC_HASH_TABLE_CONTEXT;
typedef RTL_DYNAMIC_HASH_TABLE_CONTEXT  *PRTL_DYNAMIC_HASH_TABLE_CONTEXT;

/* Dynamic hash table enumerator */
typedef struct _RTL_DYNAMIC_HASH_TABLE_ENUMERATOR {
    RTL_DYNAMIC_HASH_TABLE_ENTRY    HashEntry;
    PLIST_ENTRY                     ChainHead;
    ULONG                           BucketIndex;
} RTL_DYNAMIC_HASH_TABLE_ENUMERATOR;
typedef RTL_DYNAMIC_HASH_TABLE_ENUMERATOR   *PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR;

/* Dynamic hash table */
typedef struct _RTL_DYNAMIC_HASH_TABLE {
    ULONG   Flags;
    ULONG   Shift;
    ULONG   TableSize;
    ULONG   Pivot;
    ULONG   DivisorMask;
    ULONG   NumEntries;
    ULONG   NonEmptyBuckets;
    ULONG   NumEnumerators;
    PVOID   Directory;
} RTL_DYNAMIC_HASH_TABLE;
typedef RTL_DYNAMIC_HASH_TABLE  *PRTL_DYNAMIC_HASH_TABLE;

/* Operating system version information */
typedef struct _OSVERSIONINFOA {
    ULONG   dwOSVersionInfoSize;
    ULONG   dwMajorVersion;
    ULONG   dwMinorVersion;
    ULONG   dwBuildNumber;
    ULONG   dwPlatformId;
    CHAR    szCSDVersion[128];
} OSVERSIONINFOA;
typedef OSVERSIONINFOA      *POSVERSIONINFOA;
typedef OSVERSIONINFOA      *LPOSVERSIONINFOA;
typedef struct _OSVERSIONINFOW {
    ULONG   dwOSVersionInfoSize;
    ULONG   dwMajorVersion;
    ULONG   dwMinorVersion;
    ULONG   dwBuildNumber;
    ULONG   dwPlatformId;
    WCHAR   szCSDVersion[128];
} OSVERSIONINFOW;
typedef OSVERSIONINFOW      *POSVERSIONINFOW;
typedef OSVERSIONINFOW      *LPOSVERSIONINFOW;
typedef OSVERSIONINFOW      RTL_OSVERSIONINFOW;
typedef OSVERSIONINFOW      *PRTL_OSVERSIONINFOW;
#ifdef UNICODE
typedef OSVERSIONINFOW      OSVERSIONINFO;
typedef POSVERSIONINFOW     POSVERSIONINFO;
typedef LPOSVERSIONINFOW    LPOSVERSIONINFO;
#else
typedef OSVERSIONINFOA      OSVERSIONINFO;
typedef POSVERSIONINFOA     POSVERSIONINFO;
typedef LPOSVERSIONINFOA    LPOSVERSIONINFO;
#endif

/* Operating system version information (extended version) */
typedef struct _OSVERSIONINFOEXA {
    ULONG   dwOSVersionInfoSize;
    ULONG   dwMajorVersion;
    ULONG   dwMinorVersion;
    ULONG   dwBuildNumber;
    ULONG   dwPlatformId;
    CHAR    szCSDVersion[128];
    USHORT  wServicePackMajor;
    USHORT  wServicePackMinor;
    USHORT  wSuiteMask;
    UCHAR   wProductType;
    UCHAR   wReserved;
} OSVERSIONINFOEXA;
typedef OSVERSIONINFOEXA    *POSVERSIONINFOEXA;
typedef OSVERSIONINFOEXA    *LPOSVERSIONINFOEXA;
typedef struct _OSVERSIONINFOEXW {
    ULONG   dwOSVersionInfoSize;
    ULONG   dwMajorVersion;
    ULONG   dwMinorVersion;
    ULONG   dwBuildNumber;
    ULONG   dwPlatformId;
    WCHAR   szCSDVersion[128];
    USHORT  wServicePackMajor;
    USHORT  wServicePackMinor;
    USHORT  wSuiteMask;
    UCHAR   wProductType;
    UCHAR   wReserved;
} OSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    *POSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    *LPOSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    RTL_OSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    *PRTL_OSVERSIONINFOEXW;
#ifdef UNICODE
typedef OSVERSIONINFOEXW    OSVERSIONINFOEX;
typedef POSVERSIONINFOEXW   POSVERSIONINFOEX;
typedef LPOSVERSIONINFOEXW  LPOSVERSIONINFOEX;
#else
typedef OSVERSIONINFOEXA    OSVERSIONINFOEX;
typedef POSVERSIONINFOEXA   POSVERSIONINFOEX;
typedef LPOSVERSIONINFOEXA  LPOSVERSIONINFOEX;
#endif

/* File alignment information */
typedef struct _FILE_ALIGNMENT_INFORMATION {
    ULONG   AlignmentRequirement;
} FILE_ALIGNMENT_INFORMATION;
typedef FILE_ALIGNMENT_INFORMATION  *PFILE_ALIGNMENT_INFORMATION;

/* File name information */
typedef struct _FILE_NAME_INFORMATION {
    ULONG   FileNameLength;
    WCHAR   FileName[1];
} FILE_NAME_INFORMATION;
typedef FILE_NAME_INFORMATION   *PFILE_NAME_INFORMATION;

/* File attribute tag information */
typedef struct _FILE_ATTRIBUTE_TAG_INFORMATION {
    ULONG   FileAttributes;
    ULONG   ReparseTag;
} FILE_ATTRIBUTE_TAG_INFORMATION;
typedef FILE_ATTRIBUTE_TAG_INFORMATION  *PFILE_ATTRIBUTE_TAG_INFORMATION;

/* File disposition information */
typedef struct _FILE_DISPOSITION_INFORMATION {
    BOOLEAN DeleteFile;
} FILE_DISPOSITION_INFORMATION;
typedef FILE_DISPOSITION_INFORMATION    *PFILE_DISPOSITION_INFORMATION;

/* File end of file information */
typedef struct _FILE_END_OF_FILE_INFORMATION {
    LARGE_INTEGER   EndOfFile;
} FILE_END_OF_FILE_INFORMATION;
typedef FILE_END_OF_FILE_INFORMATION    *PFILE_END_OF_FILE_INFORMATION;

/* File valid data length information */
typedef struct _FILE_VALID_DATA_LENGTH_INFORMATION {
    LARGE_INTEGER   ValidDataLength;
} FILE_VALID_DATA_LENGTH_INFORMATION;

/* File system label information */
typedef struct _FILE_FS_LABEL_INFORMATION {
    ULONG   VolumeLabelLength;
    WCHAR   VolumeLabel[1];
} FILE_FS_LABEL_INFORMATION;
typedef FILE_FS_LABEL_INFORMATION   *PFILE_FS_LABEL_INFORMATION;

/* File system volume information */
typedef struct _FILE_FS_VOLUME_INFORMATION {
    LARGE_INTEGER   VolumeCreationTime;
    ULONG           VolumeSerialNumber;
    ULONG           VolumeLabelLength;
    BOOLEAN         SupportsObjects;
    WCHAR           VolumeLabel[1];
} FILE_FS_VOLUME_INFORMATION;
typedef FILE_FS_VOLUME_INFORMATION  *PFILE_FS_VOLUME_INFORMATION;

/* File system size information */
typedef struct _FILE_FS_SIZE_INFORMATION {
    LARGE_INTEGER   TotalAllocationUnits;
    LARGE_INTEGER   AvailableAllocationUnits;
    ULONG           SectorsPerAllocationUnit;
    ULONG           BytesPerSector;
} FILE_FS_SIZE_INFORMATION;
typedef FILE_FS_SIZE_INFORMATION    *PFILE_FS_SIZE_INFORMATION;

/* File system full size information */
typedef struct _FILE_FS_FULL_SIZE_INFORMATION {
    LARGE_INTEGER   TotalAllocationUnits;
    LARGE_INTEGER   CallerAvailableAllocationUnits;
    LARGE_INTEGER   ActualAvailableAllocationUnits;
    ULONG           SectorsPerAllocationUnit;
    ULONG           BytesPerSector;
} FILE_FS_FULL_SIZE_INFORMATION;
typedef FILE_FS_FULL_SIZE_INFORMATION   *PFILE_FS_FULL_SIZE_INFORMATION;

/* File system object identifier information */
typedef struct _FILE_FS_OBJECTID_INFORMATION {
    UCHAR   ObjectId[16];
    UCHAR   ExtendedInfo[48];
} FILE_FS_OBJECTID_INFORMATION;
typedef FILE_FS_OBJECTID_INFORMATION    *PFILE_FS_OBJECTID_INFORMATION;

/* File segment element */
typedef union _FILE_SEGMENT_ELEMENT {
    PVOID64     Buffer;
    ULONGLONG   Alignment;
} FILE_SEGMENT_ELEMENT;
typedef FILE_SEGMENT_ELEMENT    *PFILE_SEGMENT_ELEMENT;

/* Bus data types */
typedef enum _BUS_DATA_TYPE {
    ConfigurationSpaceUndefined = -1,
    Cmos                        = 0,
    EisaConfiguration           = 1,
    Pos                         = 2,
    CbusConfiguration           = 3,
    PCIConfiguration            = 4,
    VMEConfiguration            = 5,
    NuBusConfiguration          = 6,
    PCMCIAConfiguration         = 7,
    MPIConfiguration            = 8,
    MPSAConfiguration           = 9,
    PNPISAConfiguration         = 10,
    SgiInternalConfiguration    = 11,
    MaximumBusDataType          = 12
} BUS_DATA_TYPE;
typedef BUS_DATA_TYPE   *PBUS_DATA_TYPE;

/* Registry key name information */
typedef struct _KEY_NAME_INFORMATION {
    ULONG   NameLength;
    WCHAR   Name[1];
} KEY_NAME_INFORMATION;
typedef KEY_NAME_INFORMATION    *PKEY_NAME_INFORMATION;

/* Registry key cached information */
typedef struct _KEY_CACHED_INFORMATION {
    LARGE_INTEGER   LastWriteTime;
    ULONG           TitleIndex;
    ULONG           SubKeys;
    ULONG           MaxNameLen;
    ULONG           Values;
    ULONG           MaxValueNameLen;
    ULONG           MaxValueDataLen;
    ULONG           NameLength;
} KEY_CACHED_INFORMATION;
typedef KEY_CACHED_INFORMATION  *PKEY_CACHED_INFORMATION;

/* Registry key virtualization information */
typedef struct _KEY_VIRTUALIZATION_INFORMATION {
    ULONG   VirtualizationCandidate : 1;
    ULONG   VirtualizationEnabled   : 1;
    ULONG   VirtualTarget           : 1;
    ULONG   VirtualStore            : 1;
    ULONG   VirtualSource           : 1;
    ULONG   Reserved                : 27;
} KEY_VIRTUALIZATION_INFORMATION;
typedef KEY_VIRTUALIZATION_INFORMATION  *PKEY_VIRTUALIZATION_INFORMATION;

/* NT thread information block */
typedef struct _NT_TIB {
    struct _EXCEPTION_REGISTRATION_RECORD   *ExceptionList;
    PVOID           StackBase;
    PVOID           StackLimit;
    PVOID           SubSystemTib;
    union {
        PVOID   FiberData;
        ULONG   Version;
    };
    PVOID           ArbitraryUserPointer;
    struct _NT_TIB  *Self;
} NT_TIB;
typedef NT_TIB  *PNT_TIB;

/* NT thread information block (32-bit version) */
typedef struct _NT_TIB32 {
    ULONG   ExceptionList;
    ULONG   StackBase;
    ULONG   StackLimit;
    ULONG   SubSystemTib;
    union {
        ULONG   FiberData;
        ULONG   Version;
    };
    ULONG   ArbitraryUserPointer;
    ULONG   Self;
} NT_TIB32;
typedef NT_TIB32    *PNT_TIB32;

/* NT thread information block (64-bit version) */
typedef struct _NT_TIB64 {
    ULONG64 ExceptionList;
    ULONG64 StackBase;
    ULONG64 StackLimit;
    ULONG64 SubSystemTib;
    union {
        ULONG64 FiberData;
        ULONG   Version;
    };
    ULONG64 ArbitraryUserPointer;
    ULONG64 Self;
} NT_TIB64;
typedef NT_TIB64    *PNT_TIB64;

/* Process information classes */
typedef enum _PROCESSINFOCLASS {
    ProcessBasicInformation             = 0,
    ProcessQuotaLimits                  = 1,
    ProcessIoCounters                   = 2,
    ProcessVmCounters                   = 3,
    ProcessTimes                        = 4,
    ProcessBasePriority                 = 5,
    ProcessRaisePriority                = 6,
    ProcessDebugPort                    = 7,
    ProcessExceptionPort                = 8,
    ProcessAccessToken                  = 9,
    ProcessLdtInformation               = 10,
    ProcessLdtSize                      = 11,
    ProcessDefaultHardErrorMode         = 12,
    ProcessIoPortHandlers               = 13,
    ProcessPooledUsageAndLimits         = 14,
    ProcessWorkingSetWatch              = 15,
    ProcessUserModeIOPL                 = 16,
    ProcessEnableAlignmentFaultFixup    = 17,
    ProcessPriorityClass                = 18,
    ProcessWx86Information              = 19,
    ProcessHandleCount                  = 20,
    ProcessAffinityMask                 = 21,
    ProcessPriorityBoost                = 22,
    ProcessDeviceMap                    = 23,
    ProcessSessionInformation           = 24,
    ProcessForegroundInformation        = 25,
    ProcessWow64Information             = 26,
    ProcessImageFileName                = 27,
    ProcessLUIDDeviceMapsEnabled        = 28,
    ProcessBreakOnTermination           = 29,
    ProcessDebugObjectHandle            = 30,
    ProcessDebugFlags                   = 31,
    ProcessHandleTracing                = 32,
    ProcessIoPriority                   = 33,
    ProcessExecuteFlags                 = 34,
    ProcessTlsInformation               = 35,
    ProcessCookie                       = 36,
    ProcessImageInformation             = 37,
    ProcessCycleTime                    = 38,
    ProcessPagePriority                 = 39,
    ProcessInstrumentationCallback      = 40,
    ProcessThreadStackAllocation        = 41,
    ProcessWorkingSetWatchEx            = 42,
    ProcessImageFileNameWin32           = 43,
    ProcessImageFileMapping             = 44,
    ProcessAffinityUpdateMode           = 45,
    ProcessMemoryAllocationMode         = 46,
    ProcessGroupInformation             = 47,
    ProcessTokenVirtualizationEnabled   = 48,
    ProcessConsoleHostProcess           = 49,
    ProcessWindowInformation            = 50,
    MaxProcessInfoClass                 = 51
} PROCESSINFOCLASS;

/* Thread information classes */
typedef enum _THREADINFOCLASS {
    ThreadBasicInformation          = 0,
    ThreadTimes                     = 1,
    ThreadPriority                  = 2,
    ThreadBasePriority              = 3,
    ThreadAffinityMask              = 4,
    ThreadImpersonationToken        = 5,
    ThreadDescriptorTableEntry      = 6,
    ThreadEnableAlignmentFaultFixup = 7,
    ThreadEventPair_Reusable        = 8,
    ThreadQuerySetWin32StartAddress = 9,
    ThreadZeroTlsCell               = 10,
    ThreadPerformanceCount          = 11,
    ThreadAmILastThread             = 12,
    ThreadIdealProcessor            = 13,
    ThreadPriorityBoost             = 14,
    ThreadSetTlsArrayAddress        = 15,
    ThreadIsIoPending               = 16,
    ThreadHideFromDebugger          = 17,
    ThreadBreakOnTermination        = 18,
    ThreadSwitchLegacyState         = 19,
    ThreadIsTerminated              = 20,
    ThreadLastSystemCall            = 21,
    ThreadIoPriority                = 22,
    ThreadCycleTime                 = 23,
    ThreadPagePriority              = 24,
    ThreadActualBasePriority        = 25,
    ThreadTebInformation            = 26,
    ThreadCSwitchMon                = 27,
    ThreadCSwitchPmu                = 28,
    ThreadWow64Context              = 29,
    ThreadGroupInformation          = 30,
    ThreadUmsInformation            = 31,
    ThreadCounterProfiling          = 32,
    ThreadIdealProcessorEx          = 33,
    MaxThreadInfoClass              = 34
} THREADINFOCLASS;

/* Page priority information */
typedef struct _PAGE_PRIORITY_INFORMATION {
    ULONG   PagePriority;
} PAGE_PRIORITY_INFORMATION;
typedef PAGE_PRIORITY_INFORMATION   *PPAGE_PRIORITY_INFORMATION;

/* Process working set watch information */
typedef struct _PROCESS_WS_WATCH_INFORMATION {
    PVOID   FaultingPc;
    PVOID   FaultingVa;
} PROCESS_WS_WATCH_INFORMATION;
typedef PROCESS_WS_WATCH_INFORMATION    *PPROCESS_WS_WATCH_INFORMATION;

/* Process basic information */
typedef struct _PROCESS_BASIC_INFORMATION {
    NTSTATUS    ExitStatus;
    PPEB        PebBaseAddress;
    ULONG_PTR   AffinityMask;
    KPRIORITY   BasePriority;
    ULONG_PTR   UniqueProcessId;
    ULONG_PTR   InheritedFromUniqueProcessId;
} PROCESS_BASIC_INFORMATION;
typedef PROCESS_BASIC_INFORMATION   *PPROCESS_BASIC_INFORMATION;

/* Process extended basic information */
typedef struct _PROCESS_EXTENDED_BASIC_INFORMATION {
    SIZE_T                      Size;
    PROCESS_BASIC_INFORMATION   BasicInfo;
    union {
        ULONG   Flags;
        struct {
            ULONG   IsProtectedProcess      : 1;
            ULONG   IsWow64Process          : 1;
            ULONG   IsProcessDeleting       : 1;
            ULONG   IsCrossSessionCreate    : 1;
            ULONG   SpareBits               : 28;
        };
    };
} PROCESS_EXTENDED_BASIC_INFORMATION;
typedef PROCESS_EXTENDED_BASIC_INFORMATION  *PPROCESS_EXTENDED_BASIC_INFORMATION;

/* Process device map information */
typedef struct _PROCESS_DEVICEMAP_INFORMATION {
    union {
        struct {
            HANDLE  DirectoryHandle;
        } Set;
        struct {
            ULONG   DriveMap;
            UCHAR   DriveType[32];
        } Query;
    };
} PROCESS_DEVICEMAP_INFORMATION;
typedef PROCESS_DEVICEMAP_INFORMATION   *PPROCESS_DEVICEMAP_INFORMATION;

/* Process device map information (extended version) */
typedef struct _PROCESS_DEVICEMAP_INFORMATION_EX {
    union {
        struct {
            HANDLE  DirectoryHandle;
        } Set;
        struct {
            ULONG   DriveMap;
            UCHAR   DriveType[32];
        } Query;
    };
    ULONG   Flags;
} PROCESS_DEVICEMAP_INFORMATION_EX;
typedef PROCESS_DEVICEMAP_INFORMATION_EX    *PPROCESS_DEVICEMAP_INFORMATION_EX;

/* Process session information */
typedef struct _PROCESS_SESSION_INFORMATION {
    ULONG   SessionId;
} PROCESS_SESSION_INFORMATION;
typedef PROCESS_SESSION_INFORMATION *PPROCESS_SESSION_INFORMATION;

/* Process handle tracing enable information */
typedef struct _PROCESS_HANDLE_TRACING_ENABLE {
    ULONG   Flags;
} PROCESS_HANDLE_TRACING_ENABLE;
typedef PROCESS_HANDLE_TRACING_ENABLE   *PPROCESS_HANDLE_TRACING_ENABLE;

/* Process handle tracing enable information (extended version) */
typedef struct _PROCESS_HANDLE_TRACING_ENABLE_EX {
    ULONG   Flags;
    ULONG   TotalSlots;
} PROCESS_HANDLE_TRACING_ENABLE_EX;
typedef PROCESS_HANDLE_TRACING_ENABLE_EX    *PPROCESS_HANDLE_TRACING_ENABLE_EX;

/* Process handle tracing entry */
typedef struct _PROCESS_HANDLE_TRACING_ENTRY {
    HANDLE      Handle;
    CLIENT_ID   ClientId;
    ULONG       Type;
    PVOID       Stacks[PROCESS_HANDLE_TRACING_MAX_STACKS];
} PROCESS_HANDLE_TRACING_ENTRY;
typedef PROCESS_HANDLE_TRACING_ENTRY    *PPROCESS_HANDLE_TRACING_ENTRY;

/* Process handle tracing query */
typedef struct _PROCESS_HANDLE_TRACING_QUERY {
    HANDLE                          Handle;
    ULONG                           TotalTraces;
    PROCESS_HANDLE_TRACING_ENTRY    HandleTrace[1];
} PROCESS_HANDLE_TRACING_QUERY;
typedef PROCESS_HANDLE_TRACING_QUERY    *PPROCESS_HANDLE_TRACING_QUERY;

/* Quota limits */
typedef struct _QUOTA_LIMITS {
    SIZE_T          PagedPoolLimit;
    SIZE_T          NonPagedPoolLimit;
    SIZE_T          MinimumWorkingSetSize;
    SIZE_T          MaximumWorkingSetSize;
    SIZE_T          PagefileLimit;
    LARGE_INTEGER   TimeLimit;
} QUOTA_LIMITS;
typedef QUOTA_LIMITS    *PQUOTA_LIMITS;

/* Rate quota limit */
typedef union _RATE_QUOTA_LIMIT {
    ULONG   RateData;
    struct {
        ULONG   RatePercent : 7;
        ULONG   Reserved0   : 25;
    };
} RATE_QUOTA_LIMIT;
typedef RATE_QUOTA_LIMIT    *PRATE_QUOTA_LIMIT;

/* Quota limits (extended version) */
typedef struct _QUOTA_LIMITS_EX {
    SIZE_T              PagedPoolLimit;
    SIZE_T              NonPagedPoolLimit;
    SIZE_T              MinimumWorkingSetSize;
    SIZE_T              MaximumWorkingSetSize;
    SIZE_T              PagefileLimit;
    LARGE_INTEGER       TimeLimit;
    SIZE_T              WorkingSetLimit;
    SIZE_T              Reserved2;
    SIZE_T              Reserved3;
    SIZE_T              Reserved4;
    ULONG               Flags;
    RATE_QUOTA_LIMIT    CpuRateLimit;
} QUOTA_LIMITS_EX;
typedef QUOTA_LIMITS_EX *PQUOTA_LIMITS_EX;

/* I/O counters */
typedef struct _IO_COUNTERS {
    ULONGLONG   ReadOperationCount;
    ULONGLONG   WriteOperationCount;
    ULONGLONG   OtherOperationCount;
    ULONGLONG   ReadTransferCount;
    ULONGLONG   WriteTransferCount;
    ULONGLONG   OtherTransferCount;
} IO_COUNTERS;
typedef IO_COUNTERS *PIO_COUNTERS;

/* Virtual memory counters */
typedef struct _VM_COUNTERS {
    SIZE_T  PeakVirtualSize;
    SIZE_T  VirtualSize;
    ULONG   PageFaultCount;
    SIZE_T  PeakWorkingSetSize;
    SIZE_T  WorkingSetSize;
    SIZE_T  QuotaPeakPagedPoolUsage;
    SIZE_T  QuotaPagedPoolUsage;
    SIZE_T  QuotaPeakNonPagedPoolUsage;
    SIZE_T  QuotaNonPagedPoolUsage;
    SIZE_T  PagefileUsage;
    SIZE_T  PeakPagefileUsage;
} VM_COUNTERS;
typedef VM_COUNTERS *PVM_COUNTERS;

/* Virtual memory counters (extended version) */
typedef struct _VM_COUNTERS_EX {
    SIZE_T  PeakVirtualSize;
    SIZE_T  VirtualSize;
    ULONG   PageFaultCount;
    SIZE_T  PeakWorkingSetSize;
    SIZE_T  WorkingSetSize;
    SIZE_T  QuotaPeakPagedPoolUsage;
    SIZE_T  QuotaPagedPoolUsage;
    SIZE_T  QuotaPeakNonPagedPoolUsage;
    SIZE_T  QuotaNonPagedPoolUsage;
    SIZE_T  PagefileUsage;
    SIZE_T  PeakPagefileUsage;
    SIZE_T  PrivateUsage;
} VM_COUNTERS_EX;
typedef VM_COUNTERS_EX  *PVM_COUNTERS_EX;

/* Hardware counter types */
typedef enum _HARDWARE_COUNTER_TYPE {
    PMCCounter              = 0,
    MaxHardwareCounterType  = 1
} HARDWARE_COUNTER_TYPE;
typedef HARDWARE_COUNTER_TYPE   *PHARDWARE_COUNTER_TYPE;

/* Hardware counter */
typedef struct _HARDWARE_COUNTER {
    HARDWARE_COUNTER_TYPE   Type;
    ULONG                   Reserved;
    ULONG64                 Index;
} HARDWARE_COUNTER;
typedef HARDWARE_COUNTER    *PHARDWARE_COUNTER;

/* Pooled usage and limits */
typedef struct _POOLED_USAGE_AND_LIMITS {
    SIZE_T  PeakPagedPoolUsage;
    SIZE_T  PagedPoolUsage;
    SIZE_T  PagedPoolLimit;
    SIZE_T  PeakNonPagedPoolUsage;
    SIZE_T  NonPagedPoolUsage;
    SIZE_T  NonPagedPoolLimit;
    SIZE_T  PeakPagefileUsage;
    SIZE_T  PagefileUsage;
    SIZE_T  PagefileLimit;
} POOLED_USAGE_AND_LIMITS;
typedef POOLED_USAGE_AND_LIMITS *PPOOLED_USAGE_AND_LIMITS;

/* Process access token */
typedef struct _PROCESS_ACCESS_TOKEN {
    HANDLE  Token;
    HANDLE  Thread;
} PROCESS_ACCESS_TOKEN;
typedef PROCESS_ACCESS_TOKEN    *PPROCESS_ACCESS_TOKEN;

/* Process exception port */
typedef struct _PROCESS_EXCEPTION_PORT {
    HANDLE  ExceptionPortHandle;
    ULONG   StateFlags;
} PROCESS_EXCEPTION_PORT;
typedef PROCESS_EXCEPTION_PORT  *PPROCESS_EXCEPTION_PORT;

/* Kernel and user times */
typedef struct _KERNEL_USER_TIMES {
    LARGE_INTEGER   CreateTime;
    LARGE_INTEGER   ExitTime;
    LARGE_INTEGER   KernelTime;
    LARGE_INTEGER   UserTime;
} KERNEL_USER_TIMES;
typedef KERNEL_USER_TIMES   *PKERNEL_USER_TIMES;

/* Kernel processor control region */
#ifdef _X86_
typedef struct _KPCR {
    union {
        NT_TIB  NtTib;
        struct {
            struct _EXCEPTION_REGISTRATION_RECORD   *Used_ExceptionList;
            PVOID       Used_StackBase;
            PVOID       Spare2;
            PVOID       TssCopy;
            ULONG       ContextSwitches;
            KAFFINITY   SetMemberCopy;
            PVOID       Used_Self;
        };
    };
    struct _KPCR        *SelfPcr;
    struct _KPRCB       *Prcb;
    KIRQL               Irql;
    ULONG               IPR;
    ULONG               IrrActive;
    ULONG               IDR;
    PVOID               KdVersionBlock;
    struct _KIDTENTRY   *IDT;
    struct _KGDTENTRY   *GDT;
    struct _KTSS        *TSS;
    USHORT              MajorVersion;
    USHORT              MinorVersion;
    KAFFINITY           SetMember;
    ULONG               StallScaleFactor;
    UCHAR               SpareUnused;
    UCHAR               Number;
    UCHAR               Spare0;
    UCHAR               SecondLevelCacheAssociativity;
    ULONG               VdmAlert;
    ULONG               KernelReserved[14];
    ULONG               SeconeLevelCacheSize;
    ULONG               HalReserved[16];
} KPCR;
typedef KPCR    *PKPCR;
#endif

/* Interlocked results */
#ifdef _X86_
typedef enum _INTERLOCKED_RESULT {
    ResultNegative  = RESULT_NEGATIVE,
    ResultZero      = RESULT_ZERO,
    ResultPositive  = RESULT_POSITIVE
} INTERLOCKED_RESULT;
#endif

/* System firmware table actions */
typedef enum _SYSTEM_FIRMWARE_TABLE_ACTION {
    SystemFirmwareTable_Enumerate   = 0,
    SystemFirmwareTable_Get         = 1
} SYSTEM_FIRMWARE_TABLE_ACTION;

/* System firmware table information */
typedef struct _SYSTEM_FIRMWARE_TABLE_INFORMATION {
    ULONG                           ProviderSignature;
    SYSTEM_FIRMWARE_TABLE_ACTION    Action;
    ULONG                           TableID;
    ULONG                           TableBufferLength;
    UCHAR                           TableBuffer[ANYSIZE_ARRAY];
} SYSTEM_FIRMWARE_TABLE_INFORMATION;
typedef SYSTEM_FIRMWARE_TABLE_INFORMATION   *PSYSTEM_FIRMWARE_TABLE_INFORMATION;

/* Firmware table handler callback */
typedef NTSTATUS    (__cdecl *PFNFTH)( PSYSTEM_FIRMWARE_TABLE_INFORMATION );

/* System firmware table handler */
typedef struct _SYSTEM_FIRMWARE_TABLE_HANDLER {
    ULONG   ProviderSignature;
    BOOLEAN Register;
    PFNFTH  FirmwareTableHandler;
    PVOID   DriverObject;
} SYSTEM_FIRMWARE_TABLE_HANDLER;
typedef SYSTEM_FIRMWARE_TABLE_HANDLER   *PSYSTEM_FIRMWARE_TABLE_HANDLER;

/* Timer APC routine */
typedef VOID        (NTAPI *PTIMER_APC_ROUTINE)( PVOID, ULONG, LONG );

/* Timer set information classes */
typedef enum _TIMER_SET_INFORMATION_CLASS {
    TimerSetCoalescableTimer    = 0,
    MaxTimerInfoClass           = 1
} TIMER_SET_INFORMATION_CLASS;

/* Timer set coalescable timer information */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _TIMER_SET_COALESCABLE_TIMER_INFO {
    LARGE_INTEGER                   DueTime;
    PTIMER_APC_ROUTINE              TimerApcRoutine;
    PVOID                           TimerContext;
    struct _COUNTED_REASON_CONTEXT  *WakeContext;
    ULONG                           Period;
    ULONG                           TolerableDelay;
    PBOOLEAN                        PreviousState;
} TIMER_SET_COALESCABLE_TIMER_INFO;
typedef TIMER_SET_COALESCABLE_TIMER_INFO    *PTIMER_SET_COALESCABLE_TIMER_INFO;
#endif

/* Driver verifier thunk routine */
typedef ULONG_PTR   (NTAPI *PDRIVER_VERIFIER_THUNK_ROUTINE)( PVOID );

/* Driver verifier thunk pairs */
typedef struct _DRIVER_VERIFIER_THUNK_PAIRS {
    PDRIVER_VERIFIER_THUNK_ROUTINE  PristineRoutine;
    PDRIVER_VERIFIER_THUNK_ROUTINE  NewRoutine;
} DRIVER_VERIFIER_THUNK_PAIRS;
typedef DRIVER_VERIFIER_THUNK_PAIRS *PDRIVER_VERIFIER_THUNK_PAIRS;

/* Extended state feature */
typedef struct _XSTATE_FEATURE {
    ULONG   Offset;
    ULONG   Size;
} XSTATE_FEATURE;
typedef XSTATE_FEATURE  *PXSTATE_FEATURE;

/* Extended state configuration */
typedef struct _XSTATE_CONFIGURATION {
    ULONG64         EnabledFeatures;
    ULONG           Size;
    ULONG           OptimizedSave   : 1;
    XSTATE_FEATURE  Features[MAXIMUM_XSTATE_FEATURES];
} XSTATE_CONFIGURATION;
typedef XSTATE_CONFIGURATION    *PXSTATE_CONFIGURATION;

/* Kernel/user shared data */
typedef struct _KUSER_SHARED_DATA {
    ULONG                   TickCountLowDeprecated;
    ULONG                   TickCountMultiplier;
    volatile KSYSTEM_TIME   InterruptTime;
    volatile KSYSTEM_TIME   SystemTime;
    volatile KSYSTEM_TIME   TimeZoneBias;
    USHORT                  ImageNumberLow;
    USHORT                  ImageNumberHigh;
    WCHAR                   NtSystemRoot[260];
    ULONG                   MaxStackTraceDepth;
    ULONG                   CryptoExponent;
    ULONG                   TimeZoneId;
    ULONG                   LargePageMinimum;
    ULONG                   Reserved2[7];
    NT_PRODUCT_TYPE         NtProductType;
    BOOLEAN                 ProductTypeIsValid;
    ULONG                   NtMajorVersion;
    ULONG                   NtMinorVersion;
    BOOLEAN                 ProcessorFeatures[PROCESSOR_FEATURE_MAX];
    ULONG                   Reserved1;
    ULONG                   Reserved3;
    volatile ULONG          TimeSlip;
    ALTERNATIVE_ARCHITECTURE_TYPE   AlternativeArchitecture;
    ULONG                   AltArchitecturePad[1];
    LARGE_INTEGER           SystemExpirationDate;
    ULONG                   SuiteMask;
    BOOLEAN                 KdDebuggerEnabled;
    UCHAR                   NXSupportPolicy;
    volatile ULONG          ActiveConsoleId;
    volatile ULONG          DismountCount;
    ULONG                   ComPlusPackage;
    ULONG                   LastSystemRITEventTickCount;
    ULONG                   NumberOfPhysicalPages;
    BOOLEAN                 SafeBootMode;
    union {
        UCHAR   TscQpcData;
        struct {
            UCHAR   TscQpcEnabled   : 1;
            UCHAR   TscQpcSpareFlag : 1;
            UCHAR   TscQpcShift     : 6;
        };
    };
    UCHAR                   TscQpcPad[2];
    union {
        ULONG   SharedDataFlags;
        struct {
            ULONG   DbgErrorPortPresent         : 1;
            ULONG   DbgElevationEnabled         : 1;
            ULONG   DbgVirtEnabled              : 1;
            ULONG   DbgInstallerDetectEnabled   : 1;
            ULONG   DbgSystemDllRelocated       : 1;
            ULONG   DbgDynProcessorEnabled      : 1;
            ULONG   DbgSEHValidationEnabled     : 1;
            ULONG   SpareBits                   : 25;
        };
    };
    ULONG                   DataFlagsPad[1];
    ULONGLONG               TestRetInstruction;
    ULONG                   SystemCall;
    ULONG                   SystemCallReturn;
    ULONGLONG               SystemCallPad[3];
    union {
        volatile KSYSTEM_TIME   TickCount;
        volatile ULONG64        TickCountQuad;
        struct {
            ULONG   ReservedTickCountOverlay[3];
            ULONG   TickCountPad[1];
        };
    };
    ULONG                   Cookie;
    ULONG                   CookiePad[1];
    LONGLONG                ConsoleSessionForegroundProcessId;
    ULONG                   Wow64SharedInformation[MAX_WOW64_SHARED_ENTRIES];
    USHORT                  UserModeGlobalLogger[16];
    ULONG                   ImageFileExecutionOptions;
    ULONGLONG               Reserved5;
    volatile ULONG64        InterruptTimeBias;
    volatile ULONG64        TscQpcBias;
    volatile ULONG          ActiveProcessorCount;
    volatile USHORT         ActiveGroupCount;
    USHORT                  Reserved4;
    volatile ULONG          AitSamplingValue;
    volatile ULONG          AppCompatFlag;
    ULONGLONG               SystemDllNativeRelocation;
    ULONG                   SystemDllWowRelocation;
    ULONG                   XStatePad[1];
    XSTATE_CONFIGURATION    XState;
} KUSER_SHARED_DATA;
typedef KUSER_SHARED_DATA   *PKUSER_SHARED_DATA;

/* PC card device data */
typedef struct _CM_PCCARD_DEVICE_DATA {
    UCHAR   Flags;
    UCHAR   ErrorCode;
    USHORT  Reserved;
    ULONG   BusData;
    ULONG   DeviceId;
    ULONG   LegacyBaseAddress;
    UCHAR   IRQMap[16];
} CM_PCCARD_DEVICE_DATA;
typedef CM_PCCARD_DEVICE_DATA   *PCM_PCCARD_DEVICE_DATA;

/* Configuration types */
typedef enum _CONFIGURATION_TYPE {
    ArcSystem               = 0,
    CentralProcessor        = 1,
    FloatingPointProcessor  = 2,
    PrimaryIcache           = 3,
    PrimaryDcache           = 4,
    SecondaryIcache         = 5,
    SecondaryDcache         = 6,
    SecondaryCache          = 7,
    EisaAdapter             = 8,
    TcAdapter               = 9,
    ScsiAdapter             = 10,
    DtiAdapter              = 11,
    MultiFunctionAdapter    = 12,
    DiskController          = 13,
    TapeController          = 14,
    CdromController         = 15,
    WormController          = 16,
    SerialController        = 17,
    NetworkController       = 18,
    DisplayController       = 19,
    ParallelController      = 20,
    PointerController       = 21,
    KeyboardController      = 22,
    AudioController         = 23,
    OtherController         = 24,
    DiskPeripheral          = 25,
    FloppyDiskPeripheral    = 26,
    TapePeripheral          = 27,
    ModemPeripheral         = 28,
    MonitorPeripheral       = 29,
    PrinterPeripheral       = 30,
    PointerPeripheral       = 31,
    KeyboardPeripheral      = 32,
    TerminalPeripheral      = 33,
    OtherPeripheral         = 34,
    LinePeripheral          = 35,
    NetworkPeripheral       = 36,
    SystemMemory            = 37,
    DockingInformation      = 38,
    RealModeIrqRoutingTable = 39,
    RealModePCIEnumeration  = 40,
    MaximumType             = 41
} CONFIGURATION_TYPE;
typedef CONFIGURATION_TYPE  *PCONFIGURATION_TYPE;

/* Expand stack callout */
typedef VOID        (NTAPI EXPAND_STACK_CALLOUT)( PVOID );
typedef EXPAND_STACK_CALLOUT    *PEXPAND_STACK_CALLOUT;

/* Zone segment header */
typedef struct _ZONE_SEGMENT_HEADER {
    SINGLE_LIST_ENTRY   SegmentList;
    PVOID               Reserved;
} ZONE_SEGMENT_HEADER;
typedef ZONE_SEGMENT_HEADER *PZONE_SEGMENT_HEADER;

/* Zone header */
typedef struct _ZONE_HEADER {
    SINGLE_LIST_ENTRY   FreeList;
    SINGLE_LIST_ENTRY   SegmentList;
    ULONG               BlockSize;
    ULONG               TotalSegmentSize;
} ZONE_HEADER;
typedef ZONE_HEADER *PZONE_HEADER;

/* Physical memory range */
typedef struct _PHYSICAL_MEMORY_RANGE {
    PHYSICAL_ADDRESS    BaseAddress;
    LARGE_INTEGER       NumberOfBytes;
} PHYSICAL_MEMORY_RANGE;
typedef PHYSICAL_MEMORY_RANGE   *PPHYSICAL_MEMORY_RANGE;

/* Memory management rotate copy callback function */
typedef NTSTATUS    (NTAPI *PMM_ROTATE_COPY_CALLBACK_FUNCTION)( PMDL, PMDL, PVOID );

/* Memory management rotate directions */
typedef enum _MM_ROTATE_DIRECTION {
    MmToFrameBuffer             = 0,
    MmToFrameBufferNoCopy       = 1,
    MmToRegularMemory           = 2,
    MmToRegularMemoryNoCopy     = 3,
    MmMaximumRotateDirection    = 4
} MM_ROTATE_DIRECTION;
typedef MM_ROTATE_DIRECTION *PMM_ROTATE_DIRECTION;

/* Image information */
typedef struct _IMAGE_INFO {
    union {
        ULONG   Properties;
        struct {
            ULONG   ImageAddressingMode     : 8;
            ULONG   SystemModeImage         : 1;
            ULONG   ImageMappedToAllPids    : 1;
            ULONG   ExtendedInfoPresent     : 1;
            ULONG   Reserved                : 21;
        };
    };
    PVOID   ImageBase;
    ULONG   ImageSelector;
    SIZE_T  ImageSize;
    ULONG   ImageSectionNumber;
} IMAGE_INFO;
typedef IMAGE_INFO  *PIMAGE_INFO;

/* Image information (extended version) */
typedef struct _IMAGE_INFO_EX {
    SIZE_T              Size;
    IMAGE_INFO          ImageInfo;
    struct _FILE_OBJECT *FileObject;
} IMAGE_INFO_EX;
typedef IMAGE_INFO_EX   *PIMAGE_INFO_EX;

/* Process create notification information */
typedef struct _PS_CREATE_NOTIFY_INFO {
    SIZE_T              Size;
    union {
        ULONG   Flags;
        struct {
            ULONG   FileOpenNameAvailable   : 1;
            ULONG   Reserved                : 31;
        };
    };
    HANDLE              ParentProcessId;
    CLIENT_ID           CreatingThreadId;
    struct _FILE_OBJECT *FileObject;
    PCUNICODE_STRING    ImageFileName;
    PCUNICODE_STRING    CommandLine;
    NTSTATUS            CreationStatus;
} PS_CREATE_NOTIFY_INFO;
typedef PS_CREATE_NOTIFY_INFO   *PPS_CREATE_NOTIFY_INFO;

/* Notification callbacks */
typedef VOID        (NTAPI *PCREATE_PROCESS_NOTIFY_ROUTINE)( HANDLE, HANDLE, BOOLEAN );
typedef VOID        (NTAPI *PCREATE_PROCESS_NOTIFY_ROUTINE_EX)( PEPROCESS, HANDLE, PPS_CREATE_NOTIFY_INFO );
typedef VOID        (NTAPI *PCREATE_THREAD_NOTIFY_ROUTINE)( HANDLE, HANDLE, BOOLEAN );
typedef VOID        (NTAPI *PLOAD_IMAGE_NOTIFY_ROUTINE)( PUNICODE_STRING, HANDLE, PIMAGE_INFO );

/* I/O query device callback */
typedef NTSTATUS    (NTAPI *PIO_QUERY_DEVICE_ROUTINE)( PVOID, PUNICODE_STRING, INTERFACE_TYPE, ULONG, PKEY_VALUE_FULL_INFORMATION *, CONFIGURATION_TYPE, ULONG, PKEY_VALUE_FULL_INFORMATION *, CONFIGURATION_TYPE, ULONG, PKEY_VALUE_FULL_INFORMATION * );

/* I/O query device data formats */
typedef enum _IO_QUERY_DEVICE_DATA_FORMAT {
    IoQueryDeviceIdentifier             = 0,
    IoQueryDeviceConfigurationData      = 1,
    IoQueryDeviceComponentInformation   = 2,
    IoQueryDeviceMaxData                = 3
} IO_QUERY_DEVICE_DATA_FORMAT;
typedef IO_QUERY_DEVICE_DATA_FORMAT *PIO_QUERY_DEVICE_DATA_FORMAT;

/* Driver reinitialization callback */
typedef VOID NTAPI DRIVER_REINITIALIZE( struct _DRIVER_OBJECT *, PVOID, ULONG );
typedef DRIVER_REINITIALIZE *PDRIVER_REINITIALIZE;

/* Controller object */
typedef struct _CONTROLLER_OBJECT {
    CSHORT          Type;
    CSHORT          Size;
    PVOID           ControllerExtension;
    KDEVICE_QUEUE   DeviceWaitQueue;
    ULONG           Spare1;
    LARGE_INTEGER   Spare2;
} CONTROLLER_OBJECT;
typedef CONTROLLER_OBJECT   *PCONTROLLER_OBJECT;

/* Configuration information */
typedef struct _CONFIGURATION_INFORMATION {
    ULONG   DiskCount;
    ULONG   FloppyCount;
    ULONG   CdRomCount;
    ULONG   TapeCount;
    ULONG   ScsiPortCount;
    ULONG   SerialCount;
    ULONG   ParallelCount;
    BOOLEAN AtDiskPrimaryAddressClaimed;
    BOOLEAN AtDiskSecondaryAddressClaimed;
    ULONG   Version;
    ULONG   MediumChangerCount;
} CONFIGURATION_INFORMATION;
typedef CONFIGURATION_INFORMATION   *PCONFIGURATION_INFORMATION;

/* Disk signature */
typedef struct _DISK_SIGNATURE {
    ULONG   PartitionStyle;
    union {
        struct {
            ULONG   Signature;
            ULONG   CheckSum;
        } Mbr;
        struct {
            GUID    DiskId;
        } Gpt;
    };
} DISK_SIGNATURE;
typedef DISK_SIGNATURE  *PDISK_SIGNATURE;

/* Transaction parameter block */
typedef struct _TXN_PARAMETER_BLOCK {
    USHORT  Length;
    USHORT  TxFsContext;
    PVOID   TransactionObject;
} TXN_PARAMETER_BLOCK;
typedef TXN_PARAMETER_BLOCK *PTXN_PARAMETER_BLOCK;

/* I/O driver create context */
typedef struct _IO_DRIVER_CREATE_CONTEXT {
    CSHORT                  Size;
    struct _ECP_LIST        *ExtraCreateParameter;
    PVOID                   DeviceObjectHint;
    PTXN_PARAMETER_BLOCK    TxnParameters;
} IO_DRIVER_CREATE_CONTEXT;
typedef IO_DRIVER_CREATE_CONTEXT    *PIO_DRIVER_CREATE_CONTEXT;

/* AGP target bus interface standard */
typedef struct _AGP_TARGET_BUS_INTERFACE_STANDARD {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
    PGET_SET_DEVICE_DATA    SetBusData;
    PGET_SET_DEVICE_DATA    GetBusData;
    UCHAR                   CapabilityID;
} AGP_TARGET_BUS_INTERFACE_STANDARD;
typedef AGP_TARGET_BUS_INTERFACE_STANDARD   *PAGP_TARGET_BUS_INTERFACE_STANDARD;

/* Device location interface callbacks */
typedef NTSTATUS    (NTAPI *PGET_LOCATION_STRING)( PVOID, PWCHAR * );

/* Plug and Play location interface */
typedef struct _PNP_LOCATION_INTERFACE {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
    PGET_LOCATION_STRING    GetLocationString;
} PNP_LOCATION_INTERFACE;
typedef PNP_LOCATION_INTERFACE  *PPNP_LOCATION_INTERFACE;

/* Arbiter actions */
typedef enum _ARBITER_ACTION {
    ArbiterActionTestAllocation             = 0,
    ArbiterActionRetestAllocation           = 1,
    ArbiterActionCommitAllocation           = 2,
    ArbiterActionRollbackAllocation         = 3,
    ArbiterActionQueryAllocatedResources    = 4,
    ArbiterActionWriteReservedResources     = 5,
    ArbiterActionQueryConflict              = 6,
    ArbiterActionQueryArbitrate             = 7,
    ArbiterActionAddReserved                = 8,
    ArbiterActionBootAllocation             = 9
} ARBITER_ACTION;
typedef ARBITER_ACTION  *PARBITER_ACTION;

/* Arbiter conflict information */
typedef struct _ARBITER_CONFLICT_INFO {
    PDEVICE_OBJECT  OwningObject;
    ULONGLONG       Start;
    ULONGLONG       End;
} ARBITER_CONFLICT_INFO;
typedef ARBITER_CONFLICT_INFO   *PARBITER_CONFLICT_INFO;

/* Arbiter test allocation parameters */
typedef struct _ARBITER_TEST_ALLOCATION_PARAMETERS {
    PLIST_ENTRY                     ArbitrationList;
    ULONG                           AllocateFromCount;
    PCM_PARTIAL_RESOURCE_DESCRIPTOR AllocateFrom;
} ARBITER_TEST_ALLOCATION_PARAMETERS;
typedef ARBITER_TEST_ALLOCATION_PARAMETERS  *PARBITER_TEST_ALLOCATION_PARAMETERS;

/* Arbiter retest allocation parameters */
typedef struct _ARBITER_RETEST_ALLOCATION_PARAMETERS {
    PLIST_ENTRY                     ArbitrationList;
    ULONG                           AllocateFromCount;
    PCM_PARTIAL_RESOURCE_DESCRIPTOR AllocateFrom;
} ARBITER_RETEST_ALLOCATION_PARAMETERS;
typedef ARBITER_RETEST_ALLOCATION_PARAMETERS    *PARBITER_RETEST_ALLOCATION_PARAMETERS;

/* Arbiter boot allocation parameters */
typedef struct _ARBITER_BOOT_ALLOCATION_PARAMETERS {
    PLIST_ENTRY ArbitrationList;
} ARBITER_BOOT_ALLOCATION_PARAMETERS;
typedef ARBITER_BOOT_ALLOCATION_PARAMETERS  *PARBITER_BOOT_ALLOCATION_PARAMETERS;

/* Arbiter query allocated resources parameters */
typedef struct _ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    PCM_PARTIAL_RESOURCE_LIST   *AllocatedResources;
} ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS;
typedef ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS    *PARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS;

/* Arbiter query conflict parameters */
typedef struct _ARBITER_QUERY_CONFLICT_PARAMETERS {
    PDEVICE_OBJECT          PhysicalDeviceObject;
    PIO_RESOURCE_DESCRIPTOR ConflictingResource;
    PULONG                  ConflictCount;
    PARBITER_CONFLICT_INFO  *Conflicts;
} ARBITER_QUERY_CONFLICT_PARAMETERS;
typedef ARBITER_QUERY_CONFLICT_PARAMETERS   *PARBITER_QUERY_CONFLICT_PARAMETERS;

/* Arbiter query arbitrate parameters */
typedef struct _ARBITER_QUERY_ARBITRATE_PARAMETERS {
    PLIST_ENTRY ArbitrationList;
} ARBITER_QUERY_ARBITRATE_PARAMETERS;
typedef ARBITER_QUERY_ARBITRATE_PARAMETERS  *PARBITER_QUERY_ARBITRATE_PARAMETERS;

/* Arbiter add reserved parameters */
typedef struct _ARBITER_ADD_RESERVED_PARAMETERS {
    PDEVICE_OBJECT  ReserveDevice;
} ARBITER_ADD_RESERVED_PARAMETERS;
typedef ARBITER_ADD_RESERVED_PARAMETERS *PARBITER_ADD_RESERVED_PARAMETERS;

/* Arbiter parameters */
typedef struct _ARBITER_PARAMETERS {
    union {
        ARBITER_TEST_ALLOCATION_PARAMETERS              TestAllocation;
        ARBITER_RETEST_ALLOCATION_PARAMETERS            RetestAllocation;
        ARBITER_BOOT_ALLOCATION_PARAMETERS              BootAllocation;
        ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS    QueryAllocatedResources;
        ARBITER_QUERY_CONFLICT_PARAMETERS               QueryConflict;
        ARBITER_QUERY_ARBITRATE_PARAMETERS              QueryArbitrate;
        ARBITER_ADD_RESERVED_PARAMETERS                 AddReserved;
    } Parameters;
} ARBITER_PARAMETERS;
typedef ARBITER_PARAMETERS  *PARBITER_PARAMETERS;

/* Arbiter request sources */
typedef enum _ARBITER_REQUEST_SOURCE {
    ArbiterRequestUndefined         = -1,
    ArbiterRequestLegacyReported    = 0,
    ArbiterRequestHalReported       = 1,
    ArbiterRequestLegacyAssigned    = 2,
    ArbiterRequestPnpDetected       = 3,
    ArbiterRequestPnpEnumerated     = 4
} ARBITER_REQUEST_SOURCE;

/* Arbiter results */
typedef enum _ARBITER_RESULT {
    ArbiterResultUndefined          = -1,
    ArbiterResultSuccess            = 0,
    ArbiterResultExternalConflict   = 1,
    ArbiterResultNullRequest        = 2
} ARBITER_RESULT;

/* Arbiter list entry */
typedef struct _ARBITER_LIST_ENTRY {
    LIST_ENTRY              ListEntry;
    ULONG                   AlternativeCount;
    PIO_RESOURCE_DESCRIPTOR Alternatives;
    PDEVICE_OBJECT          PhysicalDeviceObject;
    ARBITER_REQUEST_SOURCE  RequestSource;
    ULONG                   Flags;
    LONG_PTR                WorkSpace;
    INTERFACE_TYPE          InterfaceType;
    ULONG                   SlotNumber;
    ULONG                   BusNumber;
    PCM_PARTIAL_RESOURCE_DESCRIPTOR Assignment;
    PIO_RESOURCE_DESCRIPTOR SelectedAlternative;
    ARBITER_RESULT          Result;
} ARBITER_LIST_ENTRY;
typedef ARBITER_LIST_ENTRY  *PARBITER_LIST_ENTRY;

/* Arbiter handler */
typedef NTSTATUS    (NTAPI *PARBITER_HANDLER)( PVOID, ARBITER_ACTION, PARBITER_PARAMETERS );

/* Arbiter interface */
typedef struct _ARBITER_INTERFACE {
    USHORT                  Size;
    USHORT                  Version;
    PVOID                   Context;
    PINTERFACE_REFERENCE    InterfaceReference;
    PINTERFACE_DEREFERENCE  InterfaceDereference;
    PARBITER_HANDLER        ArbiterHandler;
    ULONG                   Flags;
} ARBITER_INTERFACE;
typedef ARBITER_INTERFACE   *PARBITER_INTERFACE;

/* Resource translation directions */
typedef enum _RESOURCE_TRANSLATION_DIRECTION {
    TranslateChildToParent  = 0,
    TranslatePartentToChild = 1
} RESOURCE_TRANSLATION_DIRECTION;

/* Resource translation callbacks */
typedef NTSTATUS    (NTAPI *PTRANSLATE_RESOURCE_HANDLER)( PVOID, PCM_PARTIAL_RESOURCE_DESCRIPTOR, RESOURCE_TRANSLATION_DIRECTION, ULONG, IO_RESOURCE_DESCRIPTOR [], PDEVICE_OBJECT, PCM_PARTIAL_RESOURCE_LIST );
typedef NTSTATUS    (NTAPI *PTRANSLATE_RESOURCE_REQUIREMENTS_HANDLER)( PVOID, PIO_RESOURCE_DESCRIPTOR, PDEVICE_OBJECT, PULONG, PIO_RESOURCE_DESCRIPTOR * );

/* Translator interface */
typedef struct _TRANSLATOR_INTERFACE {
    USHORT                                      Size;
    USHORT                                      Version;
    PVOID                                       Context;
    PINTERFACE_REFERENCE                        InterfaceReference;
    PINTERFACE_DEREFERENCE                      InterfaceDereference;
    PTRANSLATE_RESOURCE_HANDLER                 TranslateResources;
    PTRANSLATE_RESOURCE_REQUIREMENTS_HANDLER    TranslateResourceRequirements;
} TRANSLATOR_INTERFACE;
typedef TRANSLATOR_INTERFACE    *PTRANSLATOR_INTERFACE;

/* Hardware abstraction layer reset display parameters callback */
typedef BOOLEAN     (NTAPI *PHAL_RESET_DISPLAY_PARAMETERS)( ULONG, ULONG );

/* Hardware abstraction layer query information classes */
typedef enum _HAL_QUERY_INFORMATION_CLASS {
    HalInstalledBusInformation          = 0,
    HalProfileSourceInformation         = 1,
    HalPowerInformation                 = 3,
    HalProcessorSpeedInformation        = 4,
    HalCallbackInformation              = 5,
    HalMapRegisterInformation           = 6,
    HalMcaLogInformation                = 7,
    HalFrameBufferCachingInformation    = 8,
    HalDisplayBiosInformation           = 9,
    HalProcessorFeatureInformation      = 10,
    HalNumaTopologyInterface            = 11,
    HalErrorInformation                 = 12,
    HalCmcLogInformation                = 13,
    HalCpeLogInformation                = 14,
    HalQueryMcaInformation              = 15,
    HalQueryAMLIIllegalIOPortAddresses  = 16,
    HalQueryMaxHotPlugMemoryAddress     = 17,
    HalPartitionIpiInterface            = 18,
    HalPlatformInformation              = 19,
    HalQueryProfileSourceList           = 20,
    HalInitLogInformation               = 21,
    HalFrequencyInformation             = 22,
    HalProcessorBrandString             = 23,
    HalHypervisorInformation            = 24,
    HalPlatformTimerInformation         = 25,
    HalAcpiAuditInformation             = 26
} HAL_QUERY_INFORMATION_CLASS;
typedef HAL_QUERY_INFORMATION_CLASS *PHAL_QUERY_INFORMATION_CLASS;

/* Hardware abstraction layer set information classes */
typedef enum _HAL_SET_INFORMATION_CLASS {
    HalProfileSourceInterval                = 0,
    HalProfileSourceInterruptHandler        = 1,
    HalMcaRegisterDriver                    = 2,
    HalKernelErrorHandler                   = 3,
    HalCmcRegisterDriver                    = 4,
    HalCpeRegisterDriver                    = 5,
    HalMcaLog                               = 6,
    HalCmcLog                               = 7,
    HalCpeLog                               = 8,
    HalGenerateCmcInterrupt                 = 9,
    HalProfileSourceTimerHandler            = 10,
    HalEnlightment                          = 11,
    HalProfileDpgoSourceInterruptHandler    = 12
} HAL_SET_INFORMATION_CLASS;
typedef HAL_SET_INFORMATION_CLASS   *PHAL_SET_INFORMATION_CLASS;

/* Power management dispatch table */
typedef struct _PM_DISPATCH_TABLE {
    ULONG   Signature;
    ULONG   Version;
    PVOID   Function[1];
} PM_DISPATCH_TABLE;
typedef PM_DISPATCH_TABLE   *PPM_DISPATCH_TABLE;

/* PCI error handler callback */
typedef VOID        (NTAPI *PCI_ERROR_HANDLER_CALLBACK)( VOID );

/* Hardware abstraction layer callbacks */
typedef PBUS_HANDLER (FASTCALL *pHalHandlerForBus)( INTERFACE_TYPE, ULONG );
typedef VOID        (FASTCALL *pHalReferenceBusHandler)( PBUS_HANDLER );
typedef NTSTATUS    (NTAPI *pHalQuerySystemInformation)( HAL_QUERY_INFORMATION_CLASS, ULONG, PVOID, PULONG );
typedef NTSTATUS    (NTAPI *pHalSetSystemInformation)( HAL_SET_INFORMATION_CLASS, ULONG, PVOID );
typedef VOID        (FASTCALL *pHalExamineMBR)( PDEVICE_OBJECT, ULONG, ULONG, PVOID * );
typedef NTSTATUS    (FASTCALL *pHalIoReadPartitionTable)( PDEVICE_OBJECT, ULONG, BOOLEAN, struct _DRIVE_LAYOUT_INFORMATION ** );
typedef NTSTATUS    (FASTCALL *pHalIoSetPartitionInformation)( PDEVICE_OBJECT, ULONG, ULONG, ULONG );
typedef NTSTATUS    (FASTCALL *pHalIoWritePartitionTable)( PDEVICE_OBJECT, ULONG, ULONG, ULONG, struct _DRIVE_LAYOUT_INFORMATION * );
typedef NTSTATUS    (NTAPI *pHalQueryBusSlots)( PBUS_HANDLER, ULONG, PULONG, PULONG );
typedef NTSTATUS    (NTAPI *pHalInitPnpDriver)( VOID );
typedef NTSTATUS    (NTAPI *pHalInitPowerManagement)( PPM_DISPATCH_TABLE, PPM_DISPATCH_TABLE * );
typedef struct _DMA_ADAPTER * (NTAPI *pHalGetDmaAdapter)( PVOID, struct _DEVICE_DESCRIPTION *, PULONG );
typedef NTSTATUS    (NTAPI *pHalGetInterruptTranslator)( INTERFACE_TYPE, ULONG, INTERFACE_TYPE, USHORT, USHORT, PTRANSLATOR_INTERFACE, PULONG );
typedef BOOLEAN     (NTAPI *pHalTranslateBusAddress)( INTERFACE_TYPE, ULONG, PHYSICAL_ADDRESS, PULONG, PPHYSICAL_ADDRESS );
typedef NTSTATUS    (NTAPI *pHalAssignSlotResources)( PUNICODE_STRING, PUNICODE_STRING, PDRIVER_OBJECT, PDEVICE_OBJECT, INTERFACE_TYPE, ULONG, ULONG, PCM_RESOURCE_LIST * );
typedef VOID        (NTAPI *pHalHaltSystem)( VOID );
typedef BOOLEAN     (NTAPI *pHalResetDisplay)( VOID );
typedef UCHAR       (NTAPI *pHalVectorToIDTEntry)( ULONG );
typedef BOOLEAN     (NTAPI *pHalFindBusAddressTranslation)( PHYSICAL_ADDRESS, PULONG, PPHYSICAL_ADDRESS, PULONG_PTR, BOOLEAN );
typedef NTSTATUS    (NTAPI *pHalStartMirroring)( VOID );
typedef NTSTATUS    (NTAPI *pHalEndMirroring)( ULONG );
typedef NTSTATUS    (NTAPI *pHalMirrorPhysicalMemory)( PHYSICAL_ADDRESS, LARGE_INTEGER );
typedef NTSTATUS    (NTAPI *pHalMirrorVerify)( PHYSICAL_ADDRESS, LARGE_INTEGER );
typedef VOID        (NTAPI *pHalEndOfBoot)( VOID );
typedef PVOID       (NTAPI *pHalGetAcpiTable)( ULONG, PCSTR, PCSTR );
typedef VOID        (NTAPI *pHalSetPciErrorHandlerCallback)( PCI_ERROR_HANDLER_CALLBACK );

/* Map register entry */
typedef struct _MAP_REGISTER_ENTRY {
    PVOID   MapRegister;
    BOOLEAN WriteToDevice;
} MAP_REGISTER_ENTRY;
typedef MAP_REGISTER_ENTRY  *PMAP_REGISTER_ENTRY;

/* Debug device address */
typedef struct {
    UCHAR   Type;
    BOOLEAN Valid;
    UCHAR   Reserved[2];
    PUCHAR  TranslatedAddress;
    ULONG   Length;
} DEBUG_DEVICE_ADDRESS;
typedef DEBUG_DEVICE_ADDRESS    *PDEBUG_DEVICE_ADDRESS;

/* Debug memory requirements */
typedef struct {
    PHYSICAL_ADDRESS    Start;
    PHYSICAL_ADDRESS    MaxEnd;
    PVOID               VirtualAddress;
    ULONG               Length;
    BOOLEAN             Cached;
    BOOLEAN             Aligned;
} DEBUG_MEMORY_REQUIREMENTS;
typedef DEBUG_MEMORY_REQUIREMENTS   *PDEBUG_MEMORY_REQUIREMENTS;

/* Debug device descriptor */
typedef struct {
    ULONG                       Bus;
    USHORT                      Segment;
    ULONG                       Slot;
    USHORT                      VendorID;
    USHORT                      DeviceID;
    UCHAR                       BaseClass;
    UCHAR                       SubClass;
    UCHAR                       ProgIf;
    BOOLEAN                     Initialized;
    BOOLEAN                     Configured;
    DEBUG_DEVICE_ADDRESS        BaseAddress[6];
    DEBUG_MEMORY_REQUIREMENTS   Memory;
} DEBUG_DEVICE_DESCRIPTOR;
typedef DEBUG_DEVICE_DESCRIPTOR *PDEBUG_DEVICE_DESCRIPTOR;

/* Kernel debugger callbacks */
typedef NTSTATUS    (NTAPI *pKdSetupPciDeviceForDebugging)( PVOID, PDEBUG_DEVICE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *pKdReleasePciDeviceForDebugging)( PDEBUG_DEVICE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *pKdGetAcpiTablePhase0)( struct _LOADER_PARAMETER_BLOCK *, ULONG );
typedef VOID        (NTAPI *pKdCheckPowerButton)( VOID );
typedef PVOID       (NTAPI *pKdMapPhysicalMemory64)( PHYSICAL_ADDRESS, ULONG, BOOLEAN );
typedef VOID        (NTAPI *pKdUnmapVirtualAddress)( PVOID, ULONG, BOOLEAN );
typedef ULONG       (NTAPI *pKdGetPciDataByOffset)( ULONG, ULONG, PVOID, ULONG, ULONG );
typedef ULONG       (NTAPI *pKdSetPciDataByOffset)( ULONG, ULONG, PVOID, ULONG, ULONG );

/* Hardware abstraction layer dispatch table */
typedef struct {
    ULONG                           Version;
    pHalQuerySystemInformation      HalQuerySystemInformation;
    pHalSetSystemInformation        HalSetSystemInformation;
    pHalQueryBusSlots               HalQueryBusSlots;
    ULONG                           Spare1;
    pHalExamineMBR                  HalExamineMBR;
    pHalIoReadPartitionTable        HalIoReadPartitionTable;
    pHalIoSetPartitionInformation   HalIoSetPartitionInformation;
    pHalIoWritePartitionTable       HalIoWritePartitionTable;
    pHalHandlerForBus               HalReferenceHandlerForBus;
    pHalReferenceBusHandler         HalReferenceBusHandler;
    pHalReferenceBusHandler         HalDereferenceBusHandler;
    pHalInitPnpDriver               HalInitPnpDriver;
    pHalInitPowerManagement         HalInitPowerManagement;
    pHalGetDmaAdapter               HalGetDmaAdapter;
    pHalGetInterruptTranslator      HalGetInterruptTranslator;
    pHalStartMirroring              HalStartMirroring;
    pHalEndMirroring                HalEndMirroring;
    pHalMirrorPhysicalMemory        HalMirrorPhysicalMemory;
    pHalEndOfBoot                   HalEndOfBoot;
    pHalMirrorVerify                HalMirrorVerify;
    pHalGetAcpiTable                HalGetCachedAcpiTable;
    pHalSetPciErrorHandlerCallback  HalSetpciErrorHandlerCallback;
} HAL_DISPATCH;
typedef HAL_DISPATCH    *PHAL_DISPATCH;

/* Hardware abstraction layer bus information */
typedef struct _HAL_BUS_INFORMATION {
    INTERFACE_TYPE  BusType;
    BUS_DATA_TYPE   ConfigurationType;
    ULONG           BusNumber;
    ULONG           Reserved;
} HAL_BUS_INFORMATION;
typedef HAL_BUS_INFORMATION *PHAL_BUS_INFORMATION;

/* Hardware abstraction layer profile source information */
typedef struct _HAL_PROFILE_SOURCE_INFORMATION {
    KPROFILE_SOURCE Source;
    BOOLEAN         Supported;
    ULONG           Interval;
} HAL_PROFILE_SOURCE_INFORMATION;
typedef HAL_PROFILE_SOURCE_INFORMATION  *PHAL_PROFILE_SOURCE_INFORMATION;

/* Hardware abstraction layer profile source information (extended version) */
typedef struct _HAL_PROFILE_SOURCE_INFORMATION_EX {
    KPROFILE_SOURCE Source;
    BOOLEAN         Supported;
    ULONG_PTR       Interval;
    ULONG_PTR       DefInterval;
    ULONG_PTR       MaxInterval;
    ULONG_PTR       MinInterval;
} HAL_PROFILE_SOURCE_INFORMATION_EX;
typedef HAL_PROFILE_SOURCE_INFORMATION_EX   *PHAL_PROFILE_SOURCE_INFORMATION_EX;

/* Hardware abstraction layer profile source interval */
typedef struct _HAL_PROFILE_SOURCE_INTERVAL {
    KPROFILE_SOURCE Source;
    ULONG_PTR       Interval;
} HAL_PROFILE_SOURCE_INTERVAL;
typedef HAL_PROFILE_SOURCE_INTERVAL *PHAL_PROFILE_SOURCE_INTERVAL;

/* Hardware abstraction layer profile source list */
typedef struct _HAL_PROFILE_SOURCE_LIST {
    KPROFILE_SOURCE Source;
    PWSTR           Description;
} HAL_PROFILE_SOURCE_LIST;
typedef HAL_PROFILE_SOURCE_LIST *PHAL_PROFILE_SOURCE_LIST;

/* Hardware abstraction layer display BIOS information */
typedef enum _HAL_DISPLAY_BIOS_INFORMATION {
    HalDisplayInt10Bios     = 0,
    HalDisplayEmulatedBios  = 1,
    HalDispalyNoBios        = 2
} HAL_DISPLAY_BIOS_INFORMATION;
typedef HAL_DISPLAY_BIOS_INFORMATION    *PHAL_DISPLAY_BIOS_INFORMATION;

/* Hardware abstraction layer power information */
typedef struct _HAL_POWER_INFORMATION {
    ULONG   TBD;
} HAL_POWER_INFORMATION;
typedef HAL_POWER_INFORMATION   *PHAL_POWER_INFORMATION;

/* Hardware abstraction layer processor speed information */
typedef struct _HAL_PROCESSOR_SPEED_INFO {
    ULONG   ProcessorSpeed;
} HAL_PROCESSOR_SPEED_INFO;
typedef HAL_PROCESSOR_SPEED_INFO    *PHAL_PROCESSOR_SPEED_INFO;

/* Hardware abstraction layer callbacks */
typedef struct _HAL_CALLBACKS {
    PCALLBACK_OBJECT    SetSystemInformation;
    PCALLBACK_OBJECT    BusCheck;
} HAL_CALLBACKS;
typedef HAL_CALLBACKS   *PHAL_CALLBACKS;

/* Hardware abstraction layer processor feature */
typedef struct _HAL_PROCESSOR_FEATURE {
    ULONG   UsableFeatureBits;
} HAL_PROCESSOR_FEATURE;
typedef HAL_PROCESSOR_FEATURE   *PHAL_PROCESSOR_FEATURE;

/* Hardware abstraction layer I/O read/write handler */
typedef NTSTATUS    (NTAPI *PHALIOREADWRITEHANDLER)( BOOLEAN, ULONG, ULONG, PULONG );

/* Hardware abstraction layer bad I/O address list */
typedef struct _HAL_AMLI_BAD_IO_ADDRESS_LIST {
    ULONG                   BadAddrBegin;
    ULONG                   BadAddrSize;
    ULONG                   OSVersionTrigger;
    PHALIOREADWRITEHANDLER  IOHandler;
} HAL_AMLI_BAD_IO_ADDRESS_LIST;
typedef HAL_AMLI_BAD_IO_ADDRESS_LIST    *PHAL_AMLI_BAD_IO_ADDRESS_LIST;

/* Hardware abstraction layer MCA interface callbacks */
#ifdef _X86_
typedef VOID        (NTAPI *PHALMCAINTERFACELOCK)( VOID );
typedef VOID        (NTAPI *PHALMCAINTERFACEUNLOCK)( VOID );
typedef NTSTATUS    (NTAPI *PHALMCAINTERFACEREADREGISTER)( UCHAR, PVOID );
#endif

/* Hardware abstraction layer MCA interface */
#ifdef _X86_
typedef struct _HAL_MCA_INTERFACE {
    PHALMCAINTERFACELOCK            Lock;
    PHALMCAINTERFACEUNLOCK          Unlock;
    PHALMCAINTERFACEREADREGISTER    ReadRegister;
} HAL_MCA_INTERFACE;
#endif

/* Hardware abstraction layer APIC destination modes */
#ifdef _X86_
typedef enum {
    ApicDestinationModePhysical         = 1,
    ApicDestinationModeLogicalFlat      = 2,
    ApicDestinationModeLogicalClustered = 3,
    ApicDestinationModeUnknown          = 4
} HAL_APIC_DESTINATION_MODE;
typedef HAL_APIC_DESTINATION_MODE   *PHAL_APIC_DESTINATION_MODE;
#endif

/* Driver exception callback */
#ifdef _X86_
typedef VOID        (NTAPI *PDRIVER_EXCPTN_CALLBACK)( PVOID, PMCA_EXCEPTION );
typedef PDRIVER_EXCPTN_CALLBACK PDRIVER_MCA_EXCEPTION_CALLBACK;
#endif

/* MCA driver information */
#ifdef _X86_
typedef struct _MCA_DRIVER_INFO {
    PDRIVER_MCA_EXCEPTION_CALLBACK  ExceptionCallback;
    PKDEFERRED_ROUTINE              DpcCallback;
    PVOID                           DeviceContext;
} MCA_DRIVER_INFO;
typedef MCA_DRIVER_INFO *PMCA_DRIVER_INFO;
#endif

/* Hardware abstraction layer error information */
#ifdef _X86_
typedef struct _HAL_ERROR_INFO {
    ULONG       Version;
    ULONG       InitMaxSize;
    ULONG       McaMaxSize;
    ULONG       McaPreviousEventsCount;
    ULONG       McaCorrectedEventsCount;
    ULONG       McaKernelDeliveryFails;
    ULONG       McaDriverDpcQueueFails;
    ULONG       McaReserved;
    ULONG       CmcMaxSize;
    ULONG       CmcPollingInterval;
    ULONG       CmcInterruptsCount;
    ULONG       CmcKernelDeliveryFails;
    ULONG       CmcDriverDpcQueueFails;
    ULONG       CmcGetStateFails;
    ULONG       CmcClearStateFails;
    ULONG       CmcReserved;
    ULONGLONG   CmcLogId;
    ULONG       CpeMaxSize;
    ULONG       CpePollingInterval;
    ULONG       CpeInterruptsCount;
    ULONG       CpeKernelDeliveryFails;
    ULONG       CpeDriverDpcQueueFails;
    ULONG       CpeGetStateFails;
    ULONG       CpeClearStateFails;
    ULONG       CpeInterruptSources;
    ULONGLONG   CpeLogId;
    ULONGLONG   KernelReserved[4];
} HAL_ERROR_INFO;
typedef HAL_ERROR_INFO  *PHAL_ERROR_INFO;
#endif

/* Driver exception callbacks */
#ifdef _X86_
typedef VOID        (NTAPI *PDRIVER_CMC_EXCEPTION_CALLBACK)( PVOID, PCMC_EXCEPTION );
typedef VOID        (NTAPI *PDRIVER_CPE_EXCEPTION_CALLBACK)( PVOID, PCPE_EXCEPTION );
#endif

/* CMC driver information */
#ifdef _X86_
typedef struct _CMC_DRIVER_INFO {
    PDRIVER_CMC_EXCEPTION_CALLBACK  ExceptionCallback;
    PKDEFERRED_ROUTINE              DpcCallback;
    PVOID                           DeviceContext;
} CMC_DRIVER_INFO;
typedef CMC_DRIVER_INFO *PCMC_DRIVER_INFO;
#endif

/* CPE driver information */
#ifdef _X86_
typedef struct _CPE_DRIVER_INFO {
    PDRIVER_CPE_EXCEPTION_CALLBACK  ExceptionCallback;
    PKDEFERRED_ROUTINE              DpcCallback;
    PVOID                           DeviceContext;
} CPE_DRIVER_INFO;
typedef CPE_DRIVER_INFO *PCPE_DRIVER_INFO;
#endif

/* Hardware abstraction layer platform information */
typedef struct _HAL_PLATFORM_INFORMATION {
    ULONG   PlatformFlags;
} HAL_PLATFORM_INFORMATION;
typedef HAL_PLATFORM_INFORMATION    *PHAL_PLATFORM_INFORMATION;

/* Physical couter resource descriptor types */
typedef enum _PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE {
    ResourceTypeSingle                          = 0,
    ResourceTypeRange                           = 1,
    ResourceTypeExtendedCounterConfiguration    = 2,
    ResourceTypeOverflow                        = 3,
    ResourceTypeMax                             = 4
} PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE;

/* Physical counter resource descriptor */
typedef struct _PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR {
    PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE   Type;
    ULONG                                       Flags;
    union {
        ULONG   CounterIndex;
        ULONG   ExtendedRegisterAddress;
        struct {
            ULONG   Begin;
            ULONG   End;
        } Range;
    } u;
} PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR;
typedef PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR    *PPHYSICAL_COUNTER_RESOURCE_DESCRIPTOR;

/* Physical counter resource list */
typedef struct _PHYSICAL_COUNTER_RESOURCE_LIST {
    ULONG                                   Count;
    PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR    Descriptors[ANYSIZE_ARRAY];
} PHYSICAL_COUNTER_RESOURCE_LIST;
typedef PHYSICAL_COUNTER_RESOURCE_LIST  *PPHYSICAL_COUNTER_RESOURCE_LIST;

/* PCI AGP capability */
typedef struct _PCI_AGP_CAPABILITY {
    PCI_CAPABILITIES_HEADER Header;
    USHORT                  Minor   : 4;
    USHORT                  Major   : 4;
    USHORT                  Rsvd1   : 8;
    struct _PCI_AGP_STATUS {
        ULONG   Rate                        : 3;
        ULONG   Agp3Mode                    : 1;
        ULONG   FastWrite                   : 1;
        ULONG   FourGB                      : 1;
        ULONG   HostTransDisable            : 1;
        ULONG   Gart64                      : 1;
        ULONG   ITA_Coherent                : 1;
        ULONG   SideBandAddressing          : 1;
        ULONG   CalibrationCycle            : 3;
        ULONG   AsyncRequestSize            : 3;
        ULONG   Rsvd1                       : 1;
        ULONG   Isoch                       : 1;
        ULONG   Rsvd2                       : 6;
        ULONG   RequestQueueDepthMaximum    : 8;
    } AGPStatus;
    struct _PCI_AGP_COMMAND {
        ULONG   Rate                : 3;
        ULONG   Rsvd1               : 1;
        ULONG   FastWriteEnable     : 1;
        ULONG   FourGBEnable        : 1;
        ULONG   Rsvd2               : 1;
        ULONG   Gart64              : 1;
        ULONG   AGPEnable           : 1;
        ULONG   SBAEnable           : 1;
        ULONG   CalibrationCycle    : 3;
        ULONG   AsyncReqSize        : 3;
        ULONG   Rsvd3               : 8;
        ULONG   RequestQueueDepth   : 8;
    } AGPCommand;
} PCI_AGP_CAPABILITY;
typedef PCI_AGP_CAPABILITY  *PPCI_AGP_CAPABILITY;

/* Extended AGP registers */
typedef enum _EXTENDED_AGP_REGISTER {
    IsochStatus         = 0,
    AgpControl          = 1,
    ApertureSize        = 2,
    AperturePageSize    = 3,
    GartLow             = 4,
    GartHigh            = 5,
    IsochCommand        = 6
} EXTENDED_AGP_REGISTER;
typedef EXTENDED_AGP_REGISTER   *PEXTENDED_AGP_REGISTER;

/* PCI AGP ISOCH status */
typedef struct _PCI_AGP_ISOCH_STATUS {
    ULONG   ErrorCode   : 2;
    ULONG   Rsvd1       : 1;
    ULONG   Isoch_L     : 3;
    ULONG   Isoch_Y     : 2;
    ULONG   Isoch_N     : 8;
    ULONG   Rsvd2       : 16;
} PCI_AGP_ISOCH_STATUS;
typedef PCI_AGP_ISOCH_STATUS    *PPCI_AGP_ISOCH_STATUS;

/* PCI AGP control */
typedef struct _PCI_AGP_CONTROL {
    ULONG   Rsvd1       : 7;
    ULONG   GTLB_Enable : 1;
    ULONG   AP_Enable   : 1;
    ULONG   CAL_Disable : 1;
    ULONG   Rsvd2       : 22;
} PCI_AGP_CONTROL;
typedef PCI_AGP_CONTROL *PPCI_AGP_CONTROL;

/* PCI AGP aperture page size */
typedef struct _PCI_AGP_APERTURE_PAGE_SIZE {
    USHORT  PageSizeMask    : 11;
    USHORT  Rsvd1           : 1;
    USHORT  PageSizeSelect  : 4;
} PCI_AGP_APERTURE_PAGE_SIZE;
typedef PCI_AGP_APERTURE_PAGE_SIZE  *PPCI_AGP_APERTURE_PAGE_SIZE;

/* PCI AGP ISOCH command */
typedef struct _PCI_AGP_ISOCH_COMMAND {
    USHORT  Rsvd1   : 6;
    USHORT  Isoch_Y : 2;
    USHORT  Isoch_N : 8;
} PCI_AGP_ISOCH_COMMAND;
typedef PCI_AGP_ISOCH_COMMAND   *PPCI_AGP_ISOCH_COMMAND;

/* PCI AGP extended capability */
typedef struct PCI_AGP_EXTENDED_CAPABILITY {
    PCI_AGP_ISOCH_STATUS        IsochStatus;
    PCI_AGP_CONTROL             AgpControl;
    USHORT                      ApertureSize;
    PCI_AGP_APERTURE_PAGE_SIZE  AperturePageSize;
    ULONG                       GartLow;
    ULONG                       GartHigh;
    PCI_AGP_ISOCH_COMMAND       IsochCommand;
} PCI_AGP_EXTENDED_CAPABILITY;
typedef PCI_AGP_EXTENDED_CAPABILITY *PPCI_AGP_EXTENDED_CAPABILITY;

/* PCI bridge capability */
typedef struct _PCIX_BRIDGE_CAPABILITY {
    PCI_CAPABILITIES_HEADER Header;
    union {
        struct {
            USHORT  Bus64Bit                    : 1;
            USHORT  Bus133MHzCapable            : 1;
            USHORT  SplitCompletionDiscarded    : 1;
            USHORT  UnexpectedSplitCompletion   : 1;
            USHORT  SplitCompletionOverrun      : 1;
            USHORT  SplitRequestDelayed         : 1;
            USHORT  BusModeFrequency            : 4;
            USHORT  Rsvd                        : 2;
            USHORT  Version                     : 2;
            USHORT  Bus266MHzCapable            : 1;
            USHORT  Bus533MHzCapable            : 1;
        };
        USHORT  AsUSHORT;
    } SecondaryStatus;
    union {
        struct {
            ULONG   FunctionNumber              : 3;
            ULONG   DeviceNumber                : 5;
            ULONG   BusNumber                   : 8;
            ULONG   Device64Bit                 : 1;
            ULONG   Device133MHzCapable         : 1;
            ULONG   SplitCompletionDiscarded    : 1;
            ULONG   UnexpectedSplitCompletion   : 1;
            ULONG   SplitCompletionOverrun      : 1;
            ULONG   SplitRequestDelayed         : 1;
            ULONG   Rsvd                        : 7;
            ULONG   DIMCapable                  : 1;
            ULONG   Device266MHzCapable         : 1;
            ULONG   Device533MHzCapable         : 1;
        };
        ULONG   AsULONG;
    } BridgeStatus;
    USHORT  UpstreamSplitTransactionCapacity;
    USHORT  UpstreamSplitTransactionLimit;
    USHORT  DownstreamSplitTransactionCapacity;
    USHORT  DownstreamSplitTransactionLimit;
    union {
        struct {
            ULONG   SelectSecondaryRegisters        : 1;
            ULONG   ErrorPresentInOtherBank         : 1;
            ULONG   AdditionalCorrectableError      : 1;
            ULONG   AdditionalUncorrectableError    : 1;
            ULONG   ErrorPhase                      : 3;
            ULONG   ErrorCorrected                  : 1;
            ULONG   Syndrome                        : 8;
            ULONG   ErrorFirstCommand               : 4;
            ULONG   ErrorSecondCommand              : 4;
            ULONG   ErrorUpperAttributes            : 4;
            ULONG   ControlUpdateEnable             : 1;
            ULONG   Rsvd                            : 1;
            ULONG   DisableSingleBitCorrection      : 1;
            ULONG   EccMode                         : 1;
        };
        ULONG   AsULONG;
    } EccControlStatus;
    ULONG   EccFirstAddress;
    ULONG   EccSecondAddress;
    ULONG   EccAttribute;
} PCIX_BRIDGE_CAPABILITY;
typedef PCIX_BRIDGE_CAPABILITY  *PPCIX_BRIDGE_CAPABILITY;

/* PCI subsystem identifiers capability */
typedef struct _PCI_SUBSYSTEM_IDS_CAPABILITY {
    PCI_CAPABILITIES_HEADER Header;
    USHORT                  Reserved;
    USHORT                  SubVendorID;
    USHORT                  SubSystemID;
} PCI_SUBSYSTEM_IDS_CAPABILITY;
typedef PCI_SUBSYSTEM_IDS_CAPABILITY    *PPCI_SUBSYSTEM_IDS_CAPABILITY;

/* PCI root bus OSC support field */
typedef struct _PCI_ROOT_BUS_OSC_SUPPORT_FIELD {
    union {
        struct {
            ULONG   ExtendedConfigOpRegions             : 1;
            ULONG   ActiveStatePowerManagement          : 1;
            ULONG   ClockPowerManagement                : 1;
            ULONG   SegmentGroups                       : 1;
            ULONG   MessageSignaledInterrupts           : 1;
            ULONG   WindowsHardwareErrorArchitecture    : 1;
            ULONG   Reserved                            : 26;
        };
        ULONG   AsULONG;
    } u;
} PCI_ROOT_BUS_OSC_SUPPORT_FIELD;
typedef PCI_ROOT_BUS_OSC_SUPPORT_FIELD  *PPCI_ROOT_BUS_OSC_SUPPORT_FIELD;

/* PCI root bus OSC control field */
typedef struct _PCI_ROOT_BUS_OSC_CONTROL_FIELD {
    union {
        struct {
            ULONG   ExpressNativeHotPlug            : 1;
            ULONG   ShpcNativeHotPlug               : 1;
            ULONG   ExpressNativePME                : 1;
            ULONG   ExpressAdvancedErrorReporting   : 1;
            ULONG   ExpressCapabilityStructure      : 1;
            ULONG   Reserved                        : 27;
        };
        ULONG   AsULONG;
    } u;
} PCI_ROOT_BUS_OSC_CONTROL_FIELD;
typedef PCI_ROOT_BUS_OSC_CONTROL_FIELD  *PPCI_ROOT_BUS_OSC_CONTROL_FIELD;

/* PCI hardware interfaces */
typedef enum _PCI_HARDWARE_INTERFACE {
    PciConventional = 0,
    PciXMode1       = 1,
    PciXMode2       = 2,
    PciExpress      = 3
} PCI_HARDWARE_INTERFACE;
typedef PCI_HARDWARE_INTERFACE  *PPCI_HARDWARE_INTERFACE;

/* PCI bus widths */
typedef enum {
    BusWidth32Bits  = 0,
    BusWidth64Bits  = 1
} PCI_BUS_WIDTH;

/* PCI root bus hardware capability */
typedef struct _PCI_ROOT_BUS_HARDWARE_CAPABILITY {
    PCI_HARDWARE_INTERFACE  SecondaryInterface;
    struct {
        BOOLEAN         BusCapabilitiesFound;
        ULONG           CurrentSpeedAndMode;
        ULONG           SupportedSpeedsAndModes;
        BOOLEAN         DeviceIDMessagingCapable;
        PCI_BUS_WIDTH   SecondaryBusWidth;
    };
    PCI_ROOT_BUS_OSC_SUPPORT_FIELD  OscFeatureSupport;
    PCI_ROOT_BUS_OSC_CONTROL_FIELD  OscControlSupport;
    PCI_ROOT_BUS_OSC_CONTROL_FIELD  OscControlGranted;
} PCI_ROOT_BUS_HARDWARE_CAPABILITY;
typedef PCI_ROOT_BUS_HARDWARE_CAPABILITY    *PPCI_ROOT_BUS_HARDWARE_CAPABILITY;

/* PCI express capabilities register */
typedef union _PCI_EXPRESS_CAPABILITIES_REGISTER {
    struct {
        USHORT  CapabilitiesVersion     : 4;
        USHORT  DeviceType              : 4;
        USHORT  SlotImplemented         : 1;
        USHORT  InterruptMessageNumber  : 5;
        USHORT  Rsvd                    : 2;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_CAPABILITIES_REGISTER;
typedef PCI_EXPRESS_CAPABILITIES_REGISTER   *PPCI_EXPRESS_CAPABILITIES_REGISTER;

/* PCI express device capabilities register */
typedef union _PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER {
    struct {
        ULONG   MaxPayloadSizeSupported     : 3;
        ULONG   PhantomFunctionsSupported   : 2;
        ULONG   ExtendedTagSupported        : 1;
        ULONG   L0sAcceptableLatency        : 3;
        ULONG   L1AcceptableLatency         : 3;
        ULONG   Undefined                   : 3;
        ULONG   RoleBasedErrorReporting     : 1;
        ULONG   Rsvd1                       : 2;
        ULONG   CapturedSlotPowerLimit      : 8;
        ULONG   CapturedSlotPowerLimitScale : 2;
        ULONG   Rsvd2                       : 4;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER;
typedef PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER    *PPCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER;

/* PCI express device control register */
typedef union _PCI_EXPRESS_DEVICE_CONTROL_REGISTER {
    struct {
        USHORT  CorrectableErrorEnable          : 1;
        USHORT  NonFatalErrorEnable             : 1;
        USHORT  FatalErrorEnable                : 1;
        USHORT  UnsupportedRequestErrorEnable   : 1;
        USHORT  EnableRelaxedOrder              : 1;
        USHORT  MaxPayloadSize                  : 3;
        USHORT  ExtendedTagEnable               : 1;
        USHORT  PhantomFunctionsEnable          : 1;
        USHORT  AuxPowerEnable                  : 1;
        USHORT  NoSnoopEnable                   : 1;
        USHORT  MaxReadRequestSize              : 3;
        USHORT  BridgeConfigRetryEnable         : 1;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_DEVICE_CONTROL_REGISTER;
typedef PCI_EXPRESS_DEVICE_CONTROL_REGISTER *PPCI_EXPRESS_DEVICE_CONTROL_REGISTER;

/* PCI express device status register */
typedef union _PCI_EXPRESS_DEVICE_STATUS_REGISTER {
    struct {
        USHORT  CorrectableErrorDetected    : 1;
        USHORT  NonFatalErrorDetected       : 1;
        USHORT  FatalErrorDetected          : 1;
        USHORT  UnsupportedRequestDetected  : 1;
        USHORT  AuxPowerDetected            : 1;
        USHORT  TransactionsPending         : 1;
        USHORT  Rsvd                        : 10;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_DEVICE_STATUS_REGISTER;
typedef PCI_EXPRESS_DEVICE_STATUS_REGISTER  *PPCI_EXPRESS_DEVICE_STATUS_REGISTER;

/* PCI express link capabilities register */
typedef union _PCI_EXPRESS_LINK_CAPABILITIES_REGISTER {
    struct {
        ULONG   MaximumLinkSpeed                    : 4;
        ULONG   MaximumLinkWidth                    : 6;
        ULONG   ActiveStatePMSupport                : 2;
        ULONG   L0sExitLatency                      : 3;
        ULONG   L1ExitLatency                       : 3;
        ULONG   ClockPowerManagement                : 1;
        ULONG   SurpriseDownErrorReportingCapable   : 1;
        ULONG   DataLinkLayerActiveReportingCapable : 1;
        ULONG   Rsvd                                : 3;
        ULONG   PortNumber                          : 8;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_LINK_CAPABILITIES_REGISTER;
typedef PCI_EXPRESS_LINK_CAPABILITIES_REGISTER  *PPCI_EXPRESS_LINK_CAPABILITIES_REGISTER;

/* PCI express link control register */
typedef union _PCI_EXPRESS_LINK_CONTROL_REGISTER {
    struct {
        USHORT  ActiveStatePMControl        : 2;
        USHORT  Rsvd1                       : 1;
        USHORT  ReadCompletionBoundary      : 1;
        USHORT  LinkDisable                 : 1;
        USHORT  RetrainLink                 : 1;
        USHORT  CommonClockConfig           : 1;
        USHORT  ExtendedSynch               : 1;
        USHORT  EnableClockPowerManagement  : 1;
        USHORT  Rsvd2                       : 7;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_LINK_CONTROL_REGISTER;
typedef PCI_EXPRESS_LINK_CONTROL_REGISTER   *PPCI_EXPRESS_LINK_CONTROL_REGISTER;

/* PCI express link status register */
typedef union _PCI_EXPRESS_LINK_STATUS_REGISTER {
    struct {
        USHORT  LinkSpeed           : 4;
        USHORT  LinkWidth           : 6;
        USHORT  Undefined           : 1;
        USHORT  LinkTraining        : 1;
        USHORT  SlotClockConfig     : 1;
        USHORT  DataLinkLayerActive : 1;
        USHORT  Rsvd                : 2;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_LINK_STATUS_REGISTER;
typedef PCI_EXPRESS_LINK_STATUS_REGISTER    *PPCI_EXPRESS_LINK_STATUS_REGISTER;

/* PCI express slot capabilities register */
typedef union _PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER {
    struct {
        ULONG   AttentionButtonPresent          : 1;
        ULONG   PowerControllerPresent          : 1;
        ULONG   MRLSensorPresent                : 1;
        ULONG   AttentionIndicatorPresent       : 1;
        ULONG   PowerIndicatorPresent           : 1;
        ULONG   HotPlugSurprise                 : 1;
        ULONG   HotPlugCapable                  : 1;
        ULONG   SlotPowerLimit                  : 8;
        ULONG   SlotPowerLimitScale             : 2;
        ULONG   ElectromechanicalLockPresent    : 1;
        ULONG   NoCommandCompletedSupport       : 1;
        ULONG   PhysicalSlotNumber              : 13;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER;
typedef PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER  *PPCI_EXPRESS_SLOT_CAPABILITIES_REGISTER;

/* PCI express slot control register */
typedef union _PCI_EXPRESS_SLOT_CONTROL_REGISTER {
    struct {
        USHORT  AttentionButtonEnable           : 1;
        USHORT  PowerFaultDetectEnable          : 1;
        USHORT  MRLSensorEnable                 : 1;
        USHORT  PresenceDetectEnable            : 1;
        USHORT  CommandCompletedEnable          : 1;
        USHORT  HotPlugInterruptEnable          : 1;
        USHORT  AttentionIndicatorControl       : 2;
        USHORT  PowerIndicatorControl           : 2;
        USHORT  PowerControllerControl          : 1;
        USHORT  ElectromechanicalLockControl    : 1;
        USHORT  DataLinkStateChangeEnable       : 1;
        USHORT  Rsvd                            : 3;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_SLOT_CONTROL_REGISTER;
typedef PCI_EXPRESS_SLOT_CONTROL_REGISTER   *PPCI_EXPRESS_SLOT_CONTROL_REGISTER;

/* PCI express slot status register */
typedef union _PCI_EXPRESS_SLOT_STATUS_REGISTER {
    struct {
        USHORT  AttentionButtonPressed          : 1;
        USHORT  PowerFaultDetected              : 1;
        USHORT  MRLSensorChanged                : 1;
        USHORT  PresenceDetectChanged           : 1;
        USHORT  CommandCompleted                : 1;
        USHORT  MRLSensorState                  : 1;
        USHORT  PresenceDetectState             : 1;
        USHORT  ElectromechanicalLockEngaged    : 1;
        USHORT  DataLinkStateChanged            : 1;
        USHORT  Rsvd                            : 7;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_SLOT_STATUS_REGISTER;
typedef PCI_EXPRESS_SLOT_STATUS_REGISTER    *PPCI_EXPRESS_SLOT_STATUS_REGISTER;

/* PCI express root control register */
typedef union _PCI_EXPRESS_ROOT_CONTROL_REGISTER {
    struct {
        USHORT  CorrectableSerrEnable       : 1;
        USHORT  NonFatalSerrEnable          : 1;
        USHORT  FatalSerrEnable             : 1;
        USHORT  PMEInterruptEnable          : 1;
        USHORT  CRSSoftwareVisibilityEnable : 1;
        USHORT  Rsvd                        : 11;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_ROOT_CONTROL_REGISTER;
typedef PCI_EXPRESS_ROOT_CONTROL_REGISTER   *PPCI_EXPRESS_ROOT_CONTROL_REGISTER;

/* PCI express root capabilities register */
typedef union _PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER {
    struct {
        USHORT  CRSSoftwareVisibility   : 1;
        USHORT  Rsvd                    : 15;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER;
typedef PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER  *PPCI_EXPRESS_ROOT_CAPABILITIES_REGISTER;

/* PCI express root status register */
typedef union _PCI_EXPRESS_ROOT_STATUS_REGISTER {
    struct {
        ULONG   PMERequestorId  : 16;
        ULONG   PMEStatus       : 1;
        ULONG   PMEPending      : 1;
        ULONG   Rsvd            : 14;
    };
    ULONG   AsULONG;
} PCI_EXPRESS_ROOT_STATUS_REGISTER;
typedef PCI_EXPRESS_ROOT_STATUS_REGISTER    *PPCI_EXPRESS_ROOT_STATUS_REGISTER;

/* PCI express capability */
typedef struct _PCI_EXPRESS_CAPABILITY {
    PCI_CAPABILITIES_HEADER                     Header;
    PCI_EXPRESS_CAPABILITIES_REGISTER           ExpressCapabilities;
    PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER    DeviceCapabilities;
    PCI_EXPRESS_DEVICE_CONTROL_REGISTER         DeviceControl;
    PCI_EXPRESS_DEVICE_STATUS_REGISTER          DeviceStatus;
    PCI_EXPRESS_LINK_CAPABILITIES_REGISTER      LinkCapabilities;
    PCI_EXPRESS_LINK_CONTROL_REGISTER           LinkControl;
    PCI_EXPRESS_LINK_STATUS_REGISTER            LinkStatus;
    PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER      SlotCapabilities;
    PCI_EXPRESS_SLOT_CONTROL_REGISTER           SlotControl;
    PCI_EXPRESS_SLOT_STATUS_REGISTER            SlotStatus;
    PCI_EXPRESS_ROOT_CONTROL_REGISTER           RootControl;
    PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER      RootCapabilities;
    PCI_EXPRESS_ROOT_STATUS_REGISTER            RootStatus;
} PCI_EXPRESS_CAPABILITY;
typedef PCI_EXPRESS_CAPABILITY  *PPCI_EXPRESS_CAPABILITY;

/* PCI express MRL states */
typedef enum {
    MRLClosed   = 0,
    MRLOpen     = 1
} PCI_EXPRESS_MRL_STATE;

/* PCI express card presence values */
typedef enum {
    SlotEmpty   = 0,
    CardPresent = 1
} PCI_EXPRESS_CARD_PRESENCE;

/* PCI express indicator states */
typedef enum {
    IndicatorOn     = 1,
    IndicatorBlink  = 2,
    IndicatorOff    = 3
} PCI_EXPRESS_INDICATOR_STATE;

/* PCI express power states */
typedef enum {
    PowerOn     = 0,
    PowerOff    = 1
} PCI_EXPRESS_POWER_STATE;

/* PCI express ASPM support values */
typedef enum {
    L0sEntrySupport         = 1,
    L0sAndL1EntrySupport    = 3
} PCI_EXPRESS_ASPM_SUPPORT;

/* PCI express ASPM control values */
typedef enum {
    L0sAndL1EntryDisabled   = 0,
    L0sEntryEnabled         = 1,
    L1EntryEnabled          = 2,
    L0sAndL1EntryEnabled    = 3
} PCI_EXPRESS_ASPM_CONTROL;

/* PCI express L0s exit latency values */
typedef enum {
    L0s_Below64ns   = 0,
    L0s_64ns_128ns  = 1,
    L0s_128ns_256ns = 2,
    L0s_256ns_512ns = 3,
    L0s_512ns_1us   = 4,
    L0s_1us_2us     = 5,
    L0s_2us_4s      = 6,
    L0s_Above4us    = 7
} PCI_EXPRESS_L0s_EXIT_LATENCY;

/* PCI express L1 exit latency values */
typedef enum {
    L1_Below1us     = 0,
    L1_1us_2us      = 1,
    L1_2us_4us      = 2,
    L1_4us_8us      = 4,
    L1_8us_16us     = 8,
    L1_16us_32us    = 16,
    L1_32us_64us    = 32,
    L1_Above64us    = 64
} PCI_EXPRESS_L1_EXIT_LATENCY;

/* PCI express device types */
typedef enum {
    PciExpressEndpoint                      = 0,
    PciExpressLegacyEndpoint                = 1,
    PciExpressRootPart                      = 4,
    PciExpressUpstreamSwitchPort            = 5,
    PciExpressDownstreamSwitchPort          = 6,
    PciExpressToPciXBridge                  = 7,
    PciXToExpressBridge                     = 8,
    PciExpressRootComplexIntegratedEndpoint = 9,
    PciExpressRootComplexEventCollector     = 10
} PCI_EXPRESS_DEVICE_TYPE;

/* PCI express maximum payload sizes */
typedef enum {
    MaxPayload128Bytes  = 0,
    MaxPayload256Bytes  = 1,
    MaxPayload512Bytes  = 2,
    MaxPayload1024Bytes = 4,
    MaxPayload2048Bytes = 8,
    MaxPayload4096Bytes = 16
} PCI_EXPRESS_MAX_PAYLOAD_SIZE;

/* PCI express PME requestor identifier */
typedef union _PCI_EXPRESS_PME_REQUESTOR_ID {
    struct {
        USHORT  FunctionNumber  : 3;
        USHORT  DeviceNumber    : 5;
        USHORT  BusNumber       : 8;
    };
    USHORT  AsUSHORT;
} PCI_EXPRESS_PME_REQUESTOR_ID;
typedef PCI_EXPRESS_PME_REQUESTOR_ID    *PPCI_EXPRESS_PME_REQUESTOR_ID;

/* PCI callbacks */
typedef VOID        (NTAPI *PciPin2Line)( struct _BUS_HANDLER *, struct _BUS_HANDLER *, PCI_SLOT_NUMBER, PPCI_COMMON_CONFIG );
typedef VOID        (NTAPI *PciLine2Pin)( struct _BUS_HANDLER *, struct _BUS_HANDLER *, PCI_SLOT_NUMBER, PPCI_COMMON_CONFIG, PPCI_COMMON_CONFIG );
typedef VOID        (NTAPI *PciReadWriteConfig)( struct _BUS_HANDLER *, PCI_SLOT_NUMBER, PVOID, ULONG, ULONG );

/* PCI bus data */
typedef struct _PCIBUSDATA {
    ULONG               Tag;
    ULONG               Version;
    PciReadWriteConfig  ReadConfig;
    PciReadWriteConfig  WriteConfig;
    PciPin2Line         Pin2Line;
    PciLine2Pin         Line2Pin;
    PCI_SLOT_NUMBER     ParentSlot;
    PVOID               Reserved[4];
} PCIBUSDATA;
typedef PCIBUSDATA  *PPCIBUSDATA;

/* PCI bus interface callbacks */
typedef ULONG       (NTAPI *PCI_READ_WRITE_CONFIG)( PVOID, ULONG, ULONG, PVOID, ULONG, ULONG );
typedef VOID        (NTAPI *PCI_PIN_TO_LINE)( PVOID, PPCI_COMMON_CONFIG );
typedef VOID        (NTAPI *PCI_LINE_TO_PIN)( PVOID, PPCI_COMMON_CONFIG, PPCI_COMMON_CONFIG );
typedef VOID        (NTAPI *PCI_ROOT_BUS_CAPABILITY)( PVOID, PPCI_ROOT_BUS_HARDWARE_CAPABILITY );
typedef VOID        (NTAPI *PCI_EXPRESS_WAKE_CONTROL)( PVOID, BOOLEAN );

/* PCI bus interface standard */
typedef struct _PCI_BUS_INTERFACE_STANDARD {
    USHORT                      Size;
    USHORT                      Version;
    PVOID                       Context;
    PINTERFACE_REFERENCE        InterfaceReference;
    PINTERFACE_DEREFERENCE      InterfaceDereference;
    PCI_READ_WRITE_CONFIG       ReadConfig;
    PCI_READ_WRITE_CONFIG       WriteConfig;
    PCI_PIN_TO_LINE             PinToLine;
    PCI_LINE_TO_PIN             LineToPin;
    PCI_ROOT_BUS_CAPABILITY     RootBusCapability;
    PCI_EXPRESS_WAKE_CONTROL    ExpressWakeControl;
} PCI_BUS_INTERFACE_STANDARD;
typedef PCI_BUS_INTERFACE_STANDARD  *PPCI_BUS_INTERFACE_STANDARD;

/* Windows Hardware Error Architecture physical address data type */
#define WHEA_PHYSICAL_ADDRESS   LARGE_INTEGER

/* Windows Hardware Error Architecture error source types */
typedef enum _WHEA_ERROR_SOURCE_TYPE {
    WheaErrSrcTypeMCE           = 0x00,
    WheaErrSrcTypeCMC           = 0x01,
    WheaErrSrcTypeCPE           = 0x02,
    WheaErrSrcTypeNMI           = 0x03,
    WheaErrSrcTypePCIe          = 0x04,
    WheaErrSrcTypeGeneric       = 0x05,
    WheaErrSrcTypeINIT          = 0x06,
    WheaErrSrcTypeBOOT          = 0x07,
    WheaErrSrcTypeSCIGeneric    = 0x08,
    WheaErrSrcTypeIPFMCA        = 0x09,
    WheaErrSrcTypeIPFCMC        = 0x0A,
    WheaErrSrcTypeIPFCPE        = 0x0B,
    WheaErrSrcTypeMax           = 0x0C
} WHEA_ERROR_SOURCE_TYPE;
typedef WHEA_ERROR_SOURCE_TYPE  *PWHEA_ERROR_SOURCE_TYPE;

/* Windows Hardware Error Architecture error source states */
typedef enum _WHEA_ERROR_SOURCE_STATE {
    WheaErrSrcStateStopped  = 0x01,
    WheaErrSrcStateStarted  = 0x02
} WHEA_ERROR_SOURCE_STATE;
typedef WHEA_ERROR_SOURCE_STATE *PWHEA_ERROR_SOURCE_STATE;

/* The following structures get 1-byte packing. */
#pragma pack( __push, 1 )

/* Windows Hardware Error Architecture notification flags */
typedef union _WHEA_NOTIFICATION_FLAGS {
    struct {
        USHORT  PollIntervalRW              : 1;
        USHORT  SwitchToPollingThresholdRW  : 1;
        USHORT  SwitchToPollingWindowRW     : 1;
        USHORT  ErrorThresholdRW            : 1;
        USHORT  ErrorThresholdWindowRW      : 1;
        USHORT  Reserved                    : 11;
    };
    USHORT  AsUSHORT;
} WHEA_NOTIFICATION_FLAGS;
typedef WHEA_NOTIFICATION_FLAGS *PWHEA_NOTIFICATION_FLAGS;

/* XPF MC bank flags */
typedef union _XPF_MC_BANK_FLAGS {
    struct {
        UCHAR   ClearOnInitializationRW : 1;
        UCHAR   ControlDataRW           : 1;
        UCHAR   Reserved                : 6;
    };
    UCHAR   AsUCHAR;
} XPF_MC_BANK_FLAGS;
typedef XPF_MC_BANK_FLAGS   *PXPF_MC_BANK_FLAGS;

/* XPF MCE flags */
typedef union _XPF_MCE_FLAGS {
    struct {
        ULONG   MCG_CapabilityRW    : 1;
        ULONG   MCG_GlobalControlRW : 1;
        ULONG   Reserved            : 30;
    };
    ULONG   AsULONG;
} XPF_MCE_FLAGS;
typedef XPF_MCE_FLAGS   *PXPF_MCE_FLAGS;

/* Advanced error reporting root port descriptor flags */
typedef union _AER_ROOTPORT_DESCRIPTOR_FLAGS {
    struct {
        USHORT  UncorrectableErrorMaskRW        : 1;
        USHORT  UncorrectableErrorSeverityRW    : 1;
        USHORT  CorrectableErrorMaskRW          : 1;
        USHORT  AdvancedCapsAndControlRW        : 1;
        USHORT  RootErrorCommandRW              : 1;
        USHORT  Reserved                        : 11;
    };
    USHORT  AsUSHORT;
} AER_ROOTPORT_DESCRIPTOR_FLAGS;
typedef AER_ROOTPORT_DESCRIPTOR_FLAGS   *PAER_ROOTPORT_DESCRIPTOR_FLAGS;

/* Advanced error reporting endpoint descriptor flags */
typedef union _AER_ENDPOINT_DESCRIPTOR_FLAGS {
    struct {
        USHORT  UncorrectableErrorMaskRW        : 1;
        USHORT  UncorrectableErrorSeverityRW    : 1;
        USHORT  CorrectableErrorMaskRW          : 1;
        USHORT  AdvancedCapsAndControlRW        : 1;
        USHORT  Reserved                        : 12;
    };
    USHORT  AsUSHORT;
} AER_ENDPOINT_DESCRIPTOR_FLAGS;
typedef AER_ENDPOINT_DESCRIPTOR_FLAGS   *PAER_ENDPOINT_DESCRIPTOR_FLAGS;

/* Advanced error reporting bridge descriptor flags */
typedef union _AER_BRIDGE_DESCRIPTOR_FLAGS {
    struct {
        USHORT  UncorrectableErrorMaskRW                : 1;
        USHORT  UncorrectableErrorSeverityRW            : 1;
        USHORT  CorrectableErrorMaskRW                  : 1;
        USHORT  AdvancedCapsAndControlRW                : 1;
        USHORT  SecondaryUncorrectableErrorMaskRW       : 1;
        USHORT  SecondaryUncorrectableErrorSeverityRW   : 1;
        USHORT  SecondaryCapsAndControlRW               : 1;
        USHORT  Reserved                                : 9;
    };
    USHORT  AsUSHORT;
} AER_BRIDGE_DESCRIPTOR_FLAGS;
typedef AER_BRIDGE_DESCRIPTOR_FLAGS *PAER_BRIDGE_DESCRIPTOR_FLAGS;

/* Windows Hardware Error Architecture notification descriptor */
typedef struct _WHEA_NOTIFICATION_DESCRIPTOR {
    UCHAR                   Type;
    UCHAR                   Length;
    WHEA_NOTIFICATION_FLAGS Flags;
    union {
        struct {
            ULONG   PollInterval;
        } Polled;
        struct {
            ULONG   PollInterval;
            ULONG   Vector;
            ULONG   SwitchToPollingThreshold;
            ULONG   SwitchToPollingWindow;
            ULONG   ErrorThreshold;
            ULONG   ErrorThresholdWindow;
        } Interrupt;
        struct {
            ULONG   PollInterval;
            ULONG   Vector;
            ULONG   SwitchToPollingThreshold;
            ULONG   SwitchToPollingWindow;
            ULONG   ErrorThreshold;
            ULONG   ErrorThresholdWindow;
        } LocalInterrupt;
        struct {
            ULONG   PollInterval;
            ULONG   Vector;
            ULONG   SwitchToPollingThreshold;
            ULONG   SwitchToPollingWindow;
            ULONG   ErrorThreshold;
            ULONG   ErrorThresholdWindow;
        } Sci;
        struct {
            ULONG   PollInterval;
            ULONG   Vector;
            ULONG   SwitchToPollingThreshold;
            ULONG   SwitchToPollingWindow;
            ULONG   ErrorThreshold;
            ULONG   ErrorThresholdWindow;
        } Nmi;
    } u;
} WHEA_NOTIFICATION_DESCRIPTOR;
typedef WHEA_NOTIFICATION_DESCRIPTOR    *PWHEA_NOTIFICATION_DESCRIPTOR;

/* Windows Hardware Error Architecture XPF MC bank descriptor */
typedef struct _WHEA_XPF_MC_BANK_DESCRIPTOR {
    UCHAR               BankNumber;
    BOOLEAN             ClearOnInitialization;
    UCHAR               StatusDataFormat;
    XPF_MC_BANK_FLAGS   Flags;
    ULONG               ControlMsr;
    ULONG               StatusMsr;
    ULONG               AddressMsr;
    ULONG               MiscMsr;
    ULONGLONG           ControlData;
} WHEA_XPF_MC_BANK_DESCRIPTOR;
typedef WHEA_XPF_MC_BANK_DESCRIPTOR *PWHEA_XPF_MC_BANK_DESCRIPTOR;

/* Windows Hardware Error Architecture XPF MCE descriptor */
typedef struct _WHEA_XPF_MCE_DESCRIPTOR {
    USHORT                      Type;
    UCHAR                       Enabled;
    UCHAR                       NumberOfBanks;
    XPF_MCE_FLAGS               Flags;
    ULONGLONG                   MCG_Capability;
    ULONGLONG                   MCG_GlobalControl;
    WHEA_XPF_MC_BANK_DESCRIPTOR Banks[WHEA_MAX_MC_BANKS];
} WHEA_XPF_MCE_DESCRIPTOR;
typedef WHEA_XPF_MCE_DESCRIPTOR *PWHEA_XPF_MCE_DESCRIPTOR;

/* Windows Hardware Error Architecture XPF CMC descriptor */
typedef struct _WHEA_XPF_CMC_DESCRIPTOR {
    USHORT                          Type;
    BOOLEAN                         Enabled;
    UCHAR                           NumberOfBanks;
    ULONG                           Reserved;
    WHEA_NOTIFICATION_DESCRIPTOR    Notify;
    WHEA_XPF_MC_BANK_DESCRIPTOR     Banks[WHEA_MAX_MC_BANKS];
} WHEA_XPF_CMC_DESCRIPTOR;
typedef WHEA_XPF_CMC_DESCRIPTOR *PWHEA_XPF_CMC_DESCRIPTOR;

/* Windows Hardware Error Architecture PCI slot number */
typedef struct _WHEA_PCI_SLOT_NUMBER {
    union {
        struct {
            ULONG   DeviceNumber    : 5;
            ULONG   FunctionNumber  : 3;
            ULONG   Reserved        : 24;
        } bits;
        ULONG   AsULONG;
    } u;
} WHEA_PCI_SLOT_NUMBER;
typedef WHEA_PCI_SLOT_NUMBER    *PWHEA_PCI_SLOT_NUMBER;

/* Windows Hardware Error Architecture XPF NMI descriptor */
typedef struct _WHEA_XPF_NMI_DESCRIPTOR {
    USHORT  Type;
    BOOLEAN Enabled;
} WHEA_XPF_NMI_DESCRIPTOR;
typedef WHEA_XPF_NMI_DESCRIPTOR *PWHEA_XPF_NMI_DESCRIPTOR;

/* Windows Hardware Error Architecture advanced error reporting root port descriptor */
typedef struct _WHEA_AER_ROOTPORT_DESCRIPTOR {
    USHORT                          Type;
    BOOLEAN                         Enabled;
    UCHAR                           Reserved;
    ULONG                           BusNumber;
    WHEA_PCI_SLOT_NUMBER            Slot;
    USHORT                          DeviceControl;
    AER_ROOTPORT_DESCRIPTOR_FLAGS   Flags;
    ULONG                           UncorrectableErrorMask;
    ULONG                           UncorrectableErrorSeverity;
    ULONG                           CorrectableErrorMask;
    ULONG                           AdvancedCapsAndControl;
    ULONG                           RootErrorCommand;
} WHEA_AER_ROOTPORT_DESCRIPTOR;
typedef WHEA_AER_ROOTPORT_DESCRIPTOR    *PWHEA_AER_ROOTPORT_DESCRIPTOR;

/* Windows Hardware Error Architecture advanced error reporting endpoint descriptor */
typedef struct _WHEA_AER_ENDPOINT_DESCRIPTOR {
    USHORT                          Type;
    BOOLEAN                         Enabled;
    UCHAR                           Reserved;
    ULONG                           BusNumber;
    WHEA_PCI_SLOT_NUMBER            Slot;
    USHORT                          DeviceControl;
    AER_ENDPOINT_DESCRIPTOR_FLAGS   Flags;
    ULONG                           UncorrectableErrorMask;
    ULONG                           UncorrectableErrorSeverity;
    ULONG                           CorrectableErrorMask;
    ULONG                           AdvancedCapsAndControl;
} WHEA_AER_ENDPOINT_DESCRIPTOR;
typedef WHEA_AER_ENDPOINT_DESCRIPTOR    *PWHEA_AER_ENDPOINT_DESCRIPTOR;

/* Windows Hardware Error Architecture advanced error reporting bridge descriptor */
typedef struct _WHEA_AER_BRIDGE_DESCRIPTOR {
    USHORT                      Type;
    BOOLEAN                     Enabled;
    UCHAR                       Reserved;
    ULONG                       BusNumber;
    WHEA_PCI_SLOT_NUMBER        Slot;
    USHORT                      DeviceControl;
    AER_BRIDGE_DESCRIPTOR_FLAGS Flags;
    ULONG                       UncorrectableErrorMask;
    ULONG                       UncorrectableErrorSeverity;
    ULONG                       CorrectableErrorMask;
    ULONG                       AdvancedCapsAndControl;
    ULONG                       SecondaryUncorrectableErrorMask;
    ULONG                       SecondaryUncorrectableErrorSev;
    ULONG                       SecondaryCapsAndControl;
} WHEA_AER_BRIDGE_DESCRIPTOR;
typedef WHEA_AER_BRIDGE_DESCRIPTOR  *PWHEA_AER_BRIDGE_DESCRIPTOR;

/* Windows Hardware Error Architecture generic error descriptor */
typedef struct _WHEA_GENERIC_ERROR_DESCRIPTOR {
    USHORT                          Type;
    UCHAR                           Reserved;
    UCHAR                           Enabled;
    ULONG                           ErrStatusBlockLength;
    ULONG                           RelatedErrorSourceId;
    UCHAR                           ErrStatusAddressSpaceID;
    UCHAR                           ErrStatusAddressBitWidth;
    UCHAR                           ErrStatusAddressBitOffset;
    UCHAR                           ErrStatusAddressAccessSize;
    WHEA_PHYSICAL_ADDRESS           ErrStatusAddress;
    WHEA_NOTIFICATION_DESCRIPTOR    Notify;
} WHEA_GENERIC_ERROR_DESCRIPTOR;
typedef WHEA_GENERIC_ERROR_DESCRIPTOR   *PWHEA_GENERIC_ERROR_DESCRIPTOR;

/* Windows Hardware Error Architecture IPF MCA descriptor */
typedef struct _WHEA_IPF_MCA_DESCRIPTOR {
    USHORT  Type;
    UCHAR   Enabled;
    UCHAR   Reserved;
} WHEA_IPF_MCA_DESCRIPTOR;
typedef WHEA_IPF_MCA_DESCRIPTOR *PWHEA_IPF_MCA_DESCRIPTOR;

/* Windows Hardware Error Architecture IPF CMC descriptor */
typedef struct _WHEA_IPF_CMC_DESCRIPTOR {
    USHORT  Type;
    UCHAR   Enabled;
    UCHAR   Reserved;
} WHEA_IPF_CMC_DESCRIPTOR;
typedef WHEA_IPF_CMC_DESCRIPTOR *PWHEA_IPF_CMC_DESCRIPTOR;

/* Windows Hardware Error Architecture IPF CPE descriptor */
typedef struct _WHEA_IPF_CPE_DESCRIPTOR {
    USHORT  Type;
    UCHAR   Enabled;
    UCHAR   Reserved;
} WHEA_IPF_CPE_DESCRIPTOR;
typedef WHEA_IPF_CPE_DESCRIPTOR *PWHEA_IPF_CPE_DESCRIPTOR;

/* Windows Hardware Error Architecture error source descriptor */
typedef struct _WHEA_ERROR_SOURCE_DESCRIPTOR {
    ULONG                           Length;
    ULONG                           Version;
    WHEA_ERROR_SOURCE_TYPE          Type;
    WHEA_ERROR_SOURCE_STATE         State;
    ULONG                           MaxRawDataLength;
    ULONG                           NumRecordsToPreallocate;
    ULONG                           MaxSectionsPerRecord;
    ULONG                           ErrorSourceId;
    ULONG                           PlatformErrorSourceId;
    ULONG                           Flags;
    union {
        WHEA_XPF_MCE_DESCRIPTOR         XpfMceDescriptor;
        WHEA_XPF_CMC_DESCRIPTOR         XpfCmcDescriptor;
        WHEA_XPF_NMI_DESCRIPTOR         XpfNmiDescriptor;
        WHEA_IPF_MCA_DESCRIPTOR         IpfMcaDescriptor;
        WHEA_IPF_CMC_DESCRIPTOR         IpfCmcDescriptor;
        WHEA_IPF_CPE_DESCRIPTOR         IpfCpeDescriptor;
        WHEA_AER_ROOTPORT_DESCRIPTOR    AerRootportDescriptor;
        WHEA_AER_ENDPOINT_DESCRIPTOR    AerEndpointDescriptor;
        WHEA_AER_BRIDGE_DESCRIPTOR      AerBridgeDescriptor;
        WHEA_GENERIC_ERROR_DESCRIPTOR   GenErrDescriptor;
    } Info;
} WHEA_ERROR_SOURCE_DESCRIPTOR;
typedef WHEA_ERROR_SOURCE_DESCRIPTOR    *PWHEA_ERROR_SOURCE_DESCRIPTOR;

/* Windows Hardware Error Architecture revision */
typedef union _WHEA_REVISION {
    struct {
        UCHAR   MinorRevision;
        UCHAR   MajorRevision;
    };
    USHORT  AsUSHORT;
} WHEA_REVISION;
typedef WHEA_REVISION   *PWHEA_REVISION;

/* Windows Hardware Error Architecture error severities */
typedef enum _WHEA_ERROR_SEVERITY {
    WheaErrSevRecoverable   = 0,
    WheaErrSevFatal         = 1,
    WheaErrSevCorrected     = 2,
    WheaErrSevInformational = 3
} WHEA_ERROR_SEVERITY;
typedef WHEA_ERROR_SEVERITY *PWHEA_ERROR_SEVERITY;

/* Windows Hardware Error Architecture timestamp */
typedef union _WHEA_TIMESTAMP {
    struct {
        ULONG   Seconds     : 8;
        ULONG   Minutes     : 8;
        ULONG   Hours       : 8;
        ULONG   Precise     : 1;
        ULONG   Reserved    : 7;
        ULONG   Day         : 8;
        ULONG   Month       : 8;
        ULONG   Year        : 8;
        ULONG   Century     : 8;
    };
    LARGE_INTEGER   AsLARGE_INTEGER;
} WHEA_TIMESTAMP;
typedef WHEA_TIMESTAMP  *PWHEA_TIMESTAMP;

/* Windows Hardware Error Architecture persistence information */
typedef union _WHEA_PERSISTENCE_INFO {
#if 0
    struct {
        ULONGLONG   Signature   : 16;
        ULONGLONG   Length      : 24;
        ULONGLONG   Identifier  : 16;
        ULONGLONG   Attributes  : 2;
        ULONGLONG   DoNotLog    : 1;
        ULONGLONG   Reserved    : 5;
    };
#endif
    ULONGLONG   AsULONGLONG;
} WHEA_PERSISTENCE_INFO;
typedef WHEA_PERSISTENCE_INFO   *PWHEA_PERSISTENCE_INFO;

/* Windows Hardware Error Architecture error status */
typedef union _WHEA_ERROR_STATUS {
    ULONGLONG   ErrorStatus;
    struct {
        ULONG   Reserved1   : 8;
        ULONG   ErrorType   : 8;
        ULONG   Address     : 1;
        ULONG   Control     : 1;
        ULONG   Data        : 1;
        ULONG   Responder   : 1;
        ULONG   Requester   : 1;
        ULONG   FirstError  : 1;
        ULONG   Overflow    : 1;
        ULONG   Reserved2   : 9;
        ULONG   Reserved3   : 32;
    };
} WHEA_ERROR_STATUS;
typedef WHEA_ERROR_STATUS   *PWHEA_ERROR_STATUS;

/* Windows Hardware Error Architecture error record header valid bits */
typedef union _WHEA_ERROR_RECORD_HEADER_VALIDBITS {
    struct {
        ULONG   PlatformId  : 1;
        ULONG   Timestamp   : 1;
        ULONG   PartitionId : 1;
        ULONG   Reserved    : 29;
    };
    ULONG   AsULONG;
} WHEA_ERROR_RECORD_HEADER_VALIDBITS;
typedef WHEA_ERROR_RECORD_HEADER_VALIDBITS  *PWHEA_ERROR_RECORD_HEADER_VALIDBITS;

/* Windows Hardware Error architecture error record header flags */
typedef union _WHEA_ERROR_RECORD_HEADER_FLAGS {
    struct {
        ULONG   Recovered       : 1;
        ULONG   PreviousError   : 1;
        ULONG   Simulated       : 1;
        ULONG   Reserved        : 29;
    };
    ULONG   AsULONG;
} WHEA_ERROR_RECORD_HEADER_FLAGS;
typedef WHEA_ERROR_RECORD_HEADER_FLAGS  *PWHEA_ERROR_RECORD_HEADER_FLAGS;

/* Windows Hardware Error Architecture error record header */
typedef struct _WHEA_ERROR_RECORD_HEADER {
    ULONG                               Signature;
    WHEA_REVISION                       Revision;
    ULONG                               SignatureEnd;
    USHORT                              SectionCount;
    WHEA_ERROR_SEVERITY                 Severity;
    WHEA_ERROR_RECORD_HEADER_VALIDBITS  ValidationBits;
    ULONG                               Length;
    WHEA_TIMESTAMP                      Timestamp;
    GUID                                PlatformId;
    GUID                                PartitionId;
    GUID                                CreatorId;
    GUID                                NotifyType;
    ULONGLONG                           RecordId;
    WHEA_ERROR_RECORD_HEADER_FLAGS      Flags;
    WHEA_PERSISTENCE_INFO               PersistenceInfo;
    UCHAR                               Reserved[12];
} WHEA_ERROR_RECORD_HEADER;
typedef WHEA_ERROR_RECORD_HEADER    *PWHEA_ERROR_RECORD_HEADER;

/* Windows Hardware Error Architecture error record section descriptor flags */
typedef union _WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS {
    struct {
        ULONG   Primary                 : 1;
        ULONG   ContainmentWarning      : 1;
        ULONG   Reset                   : 1;
        ULONG   ThresholdExceeded       : 1;
        ULONG   ResourceNotAvailable    : 1;
        ULONG   LatentError             : 1;
        ULONG   Reserved                : 26;
    };
    ULONG   AsULONG;
} WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS;
typedef WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS  *PWHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS;

/* Windows Hardware Error Architecture error record section descriptor valid bits */
typedef union _WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS {
    struct {
        UCHAR   FRUId       : 1;
        UCHAR   FRUText     : 1;
        UCHAR   Reserved    : 6;
    };
    UCHAR   AsUCHAR;
} WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS;
typedef WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS  *PWHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS;

/* Windows Hardware Error Architecture error record section descriptor */
typedef struct _WHEA_ERROR_RECORD_SECTION_DESCRIPTOR {
    ULONG                                           SectionOffset;
    ULONG                                           SectionLength;
    WHEA_REVISION                                   Revision;
    WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS  ValidationBits;
    UCHAR                                           Reserved;
    WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS      Flags;
    GUID                                            SectionType;
    GUID                                            FRUId;
    WHEA_ERROR_SEVERITY                             SectionSeverity;
    CCHAR                                           FRUText[20];
} WHEA_ERROR_RECORD_SECTION_DESCRIPTOR;
typedef WHEA_ERROR_RECORD_SECTION_DESCRIPTOR    *PWHEA_ERROR_RECORD_SECTION_DESCRIPTOR;

/* Windows Hardware Error Architecture error record */
typedef struct _WHEA_ERROR_RECORD {
    WHEA_ERROR_RECORD_HEADER                Header;
    WHEA_ERROR_RECORD_SECTION_DESCRIPTOR    SectionDescriptor[1];
} WHEA_ERROR_RECORD;
typedef WHEA_ERROR_RECORD   *PWHEA_ERROR_RECORD;

/* Windows Hardware Error Architecture processor family information */
typedef union _WHEA_PROCESSOR_FAMILY_INFO {
    struct {
        ULONG   Stepping        : 4;
        ULONG   Model           : 4;
        ULONG   Family          : 4;
        ULONG   ProcessorType   : 2;
        ULONG   Reserved1       : 2;
        ULONG   ExtendedModel   : 4;
        ULONG   ExtendedFamily  : 8;
        ULONG   Reserved2       : 4;
        ULONG   Reserved3;
    };
    ULONGLONG   AsULONGLONG;
} WHEA_PROCESSOR_FAMILY_INFO;
typedef WHEA_PROCESSOR_FAMILY_INFO  *PWHEA_PROCESSOR_FAMILY_INFO;

/* Windows Hardware Error Architecture processor generic error section valid bits */
typedef union _WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   ProcessorType       : 1;
        ULONG   InstructionSet      : 1;
        ULONG   ErrorType           : 1;
        ULONG   Operation           : 1;
        ULONG   Flags               : 1;
        ULONG   Level               : 1;
        ULONG   CPUVersion          : 1;
        ULONG   CPUBrandString      : 1;
        ULONG   ProcessorId         : 1;
        ULONG   TargetAddress       : 1;
        ULONG   RequesterId         : 1;
        ULONG   ResponderId         : 1;
        ULONG   InstructionPointer  : 1;
        ULONG   Reserved            : 19;
        ULONG   Reserved2           : 32;
    };
    ULONGLONG   ValidBits;
} WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS;
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS  *PWHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS  WHEA_GENERIC_PROCESSOR_ERROR_VALIDBITS;
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS  *PWHEA_GENERIC_PROCESSOR_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture processor generic error section */
typedef struct _WHEA_PROCESSOR_GENERIC_ERROR_SECTION {
    WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS  ValidBits;
    UCHAR       ProcessorType;
    UCHAR       InstructionSet;
    UCHAR       ErrorType;
    UCHAR       Operation;
    UCHAR       Flags;
    UCHAR       Level;
    USHORT      Reserved;
    ULONGLONG   CPUVersion;
    UCHAR       CPUBrandString[128];
    ULONGLONG   ProcessorId;
    ULONGLONG   TargetAddress;
    ULONGLONG   RequesterId;
    ULONGLONG   ResponderId;
    ULONGLONG   InstructionPointer;
} WHEA_PROCESSOR_GENERIC_ERROR_SECTION;
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION    *PWHEA_PROCESSOR_GENERIC_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION    WHEA_GENERIC_PROCESSOR_ERROR;
typedef WHEA_PROCESSOR_GENERIC_ERROR_SECTION    *PWHEA_GENERIC_PROCESSOR_ERROR;
#endif

/* Windows Hardware Error Architecture XPF cache check */
typedef union _WHEA_XPF_CACHE_CHECK {
    struct {
        ULONG   TransactionTypeValid            : 1;
        ULONG   OperationValid                  : 1;
        ULONG   LevelValid                      : 1;
        ULONG   ProcessorContextCorruptValid    : 1;
        ULONG   UncorrectedValid                : 1;
        ULONG   PreciseIPValid                  : 1;
        ULONG   RestartableIPValid              : 1;
        ULONG   OverflowValid                   : 1;
        ULONG   ReservedValid                   : 8;
        ULONG   TransactionType                 : 2;
        ULONG   Operation                       : 4;
        ULONG   Level                           : 3;
        ULONG   ProcessorContextCorrupt         : 1;
        ULONG   Uncorrected                     : 1;
        ULONG   PreciseIP                       : 1;
        ULONG   RestartableIP                   : 1;
        ULONG   Overflow                        : 1;
        ULONG   Reserved                        : 2;
        ULONG   Reserved2;
    };
    ULONGLONG   XpfCacheCheck;
} WHEA_XPF_CACHE_CHECK;
typedef WHEA_XPF_CACHE_CHECK    *PWHEA_XPF_CACHE_CHECK;

/* Windows Hardware Error Architecture XPF TLB check */
typedef union _WHEA_XPF_TLB_CHECK {
    struct {
        ULONG   TransactionTypeValid            : 1;
        ULONG   OperationValid                  : 1;
        ULONG   LevelValid                      : 1;
        ULONG   ProcessorContextCorruptValid    : 1;
        ULONG   UncorrectedValid                : 1;
        ULONG   PreciseIPValid                  : 1;
        ULONG   RestartableIPValid              : 1;
        ULONG   OverflowValid                   : 1;
        ULONG   ReservedValid                   : 8;
        ULONG   TransactionType                 : 2;
        ULONG   Operation                       : 4;
        ULONG   Level                           : 3;
        ULONG   ProcessorContextCorrupt         : 1;
        ULONG   Uncorrected                     : 1;
        ULONG   PreciseIP                       : 1;
        ULONG   RestartableIP                   : 1;
        ULONG   Overflow                        : 1;
        ULONG   Reserved                        : 2;
        ULONG   Reserved2;
    };
    ULONGLONG   XpfTLBCheck;
} WHEA_XPF_TLB_CHECK;
typedef WHEA_XPF_TLB_CHECK  *PWHEA_XPF_TLB_CHECK;

/* Windows Hardware Error Architecture XPF bus check */
typedef union _WHEA_XPF_BUS_CHECK {
    struct {
        ULONG   TransactionTypeValid            : 1;
        ULONG   OperationValid                  : 1;
        ULONG   LevelValid                      : 1;
        ULONG   ProcessorContextCorruptValid    : 1;
        ULONG   UncorrectedValid                : 1;
        ULONG   PreciseIPValid                  : 1;
        ULONG   RestartableIPValid              : 1;
        ULONG   OverflowValid                   : 1;
        ULONG   ParticipationValid              : 1;
        ULONG   TimeoutValid                    : 1;
        ULONG   AddressSpaceValid               : 1;
        ULONG   ReservedValid                   : 5;
        ULONG   TransactionType                 : 2;
        ULONG   Operation                       : 4;
        ULONG   Level                           : 3;
        ULONG   ProcessorContextCorrupt         : 1;
        ULONG   Uncorrected                     : 1;
        ULONG   PreciseIP                       : 1;
        ULONG   RestartableIP                   : 1;
        ULONG   Overflow                        : 1;
        ULONG   Participation                   : 2;
        ULONG   Timeout                         : 1;
        ULONG   AddressSpace                    : 2;
        ULONG   Reserved                        : 29;
    };
    ULONGLONG   XpfBusCheck;
} WHEA_XPF_BUS_CHECK;
typedef WHEA_XPF_BUS_CHECK  *PWHEA_XPF_BUS_CHECK;

/* Windows Hardware Error Architecture XPF micro-architecture specific check */
typedef union _WHEA_XPF_MS_CHECK {
    struct {
        ULONG   ErrorTypeValid                  : 1;
        ULONG   ProcessorContextCorruptValid    : 1;
        ULONG   UncorrectedValid                : 1;
        ULONG   PreciseIPValid                  : 1;
        ULONG   RestartableIPValid              : 1;
        ULONG   OverflowValid                   : 1;
        ULONG   ReservedValue                   : 10;
        ULONG   ErrorType                       : 3;
        ULONG   ProcessorContextCorrupt         : 1;
        ULONG   Uncorrected                     : 1;
        ULONG   PreciseIP                       : 1;
        ULONG   RestartableIP                   : 1;
        ULONG   Overflow                        : 1;
        ULONG   Reserved                        : 8;
        ULONG   Reserved2;
    };
    ULONGLONG   XpfMsCheck;
} WHEA_XPF_MS_CHECK;
typedef WHEA_XPF_MS_CHECK   *PWHEA_XPF_MS_CHECK;

/* Windows Hardware Error Architecture XPF processor information valid bits */
typedef union _WHEA_XPF_PROCINFO_VALIDBITS {
    struct {
        ULONG   CheckInfo           : 1;
        ULONG   TargetId            : 1;
        ULONG   RequesterId         : 1;
        ULONG   ResponderId         : 1;
        ULONG   InstructionPointer  : 1;
        ULONG   Reserved            : 27;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_XPF_PROCINFO_VALIDBITS;
typedef WHEA_XPF_PROCINFO_VALIDBITS *PWHEA_XPF_PROCINFO_VALIDBITS;

/* Windows Hardware Error Architecture XPF processor information */
typedef struct _WHEA_XPF_PROCINFO {
    GUID                        CheckInfoId;
    WHEA_XPF_PROCINFO_VALIDBITS ValidBits;
    union {
        WHEA_XPF_CACHE_CHECK    CacheCheck;
        WHEA_XPF_TLB_CHECK      TlbCheck;
        WHEA_XPF_BUS_CHECK      BusCheck;
        WHEA_XPF_MS_CHECK       MsCheck;
        ULONGLONG               AsULONGLONG;
    } CheckInfo;
    ULONGLONG                   TargetId;
    ULONGLONG                   RequesterId;
    ULONGLONG                   ResponderId;
    ULONGLONG                   InstructionPointer;
} WHEA_XPF_PROCINFO;
typedef WHEA_XPF_PROCINFO   *PWHEA_XPF_PROCINFO;

/* Windows Hardware Error Architecture x86 register state */
typedef struct _WHEA_X86_REGISTER_STATE {
    ULONG       Eax;
    ULONG       Ebx;
    ULONG       Ecx;
    ULONG       Edx;
    ULONG       Esi;
    ULONG       Edi;
    ULONG       Ebp;
    ULONG       Esp;
    USHORT      Cs;
    USHORT      Ds;
    USHORT      Ss;
    USHORT      Es;
    USHORT      Fs;
    USHORT      Gs;
    ULONG       Eflags;
    ULONG       Eip;
    ULONG       Cr0;
    ULONG       Cr1;
    ULONG       Cr2;
    ULONG       Cr3;
    ULONG       Cr4;
    ULONGLONG   Gdtr;
    ULONGLONG   Idtr;
    USHORT      Ldtr;
    USHORT      Tr;
} WHEA_X86_REGISTER_STATE;
typedef WHEA_X86_REGISTER_STATE *PWHEA_X86_REGISTER_STATE;

/* Windows Hardware Error Architecture 128-bit number */
typedef struct _WHEA128A {
    ULONGLONG   Low;
    LONGLONG    High;
} WHEA128A;
typedef WHEA128A    *PWHEA128A;

/* Windows Hardware Error Architecture X64 register state */
typedef struct _WHEA_X64_REGISTER_STATE {
    ULONGLONG   Rax;
    ULONGLONG   Rbx;
    ULONGLONG   Rcx;
    ULONGLONG   Rdx;
    ULONGLONG   Rsi;
    ULONGLONG   Rdi;
    ULONGLONG   Rbp;
    ULONGLONG   Rsp;
    ULONGLONG   R8;
    ULONGLONG   R9;
    ULONGLONG   R10;
    ULONGLONG   R11;
    ULONGLONG   R12;
    ULONGLONG   R13;
    ULONGLONG   R14;
    ULONGLONG   R15;
    USHORT      Cs;
    USHORT      Ds;
    USHORT      Ss;
    USHORT      Es;
    USHORT      Fs;
    USHORT      Gs;
    ULONG       Reserved;
    ULONGLONG   Rflags;
    ULONGLONG   Eip;
    ULONGLONG   Cr0;
    ULONGLONG   Cr1;
    ULONGLONG   Cr2;
    ULONGLONG   Cr3;
    ULONGLONG   Cr4;
    ULONGLONG   Cr8;
    WHEA128A    Gdtr;
    WHEA128A    Idtr;
    USHORT      Ldtr;
    USHORT      Tr;
} WHEA_X64_REGISTER_STATE;
typedef WHEA_X64_REGISTER_STATE *PWHEA_X64_REGISTER_STATE;

/* Windows Hardware Error Architecture XPF context information */
typedef struct _WHEA_XPF_CONTEXT_INFO {
    USHORT      RegisterContextType;
    USHORT      RegisterArraySize;
    ULONG       MSRAddress;
    ULONGLONG   MmRegisterAddress;
} WHEA_XPF_CONTEXT_INFO;
typedef WHEA_XPF_CONTEXT_INFO   *PWHEA_XPF_CONTEXT_INFO;

/* Windows Hardware Error Architecture XPF processor error section valid bits */
typedef union _WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   LocalAPICId         : 1;
        ULONG   CpuId               : 1;
        ULONG   ProcInfoCount       : 6;
        ULONG   ContextInfoCount    : 6;
        ULONG   Reserved            : 18;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS;
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS  *PWHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS  WHEA_XPF_PROCESSOR_ERROR_VALIDBITS;
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS  *PWHEA_XPF_PROCESSOR_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture XPF processor error section */
typedef struct _WHEA_XPF_PROCESSOR_ERROR_SECTION {
    WHEA_XPF_PROCESSOR_ERROR_SECTION_VALIDBITS  ValidBits;
    ULONGLONG   LocalAPICId;
    UCHAR       CpuId[48];
    UCHAR       VariableInfo[ANYSIZE_ARRAY];
} WHEA_XPF_PROCESSOR_ERROR_SECTION;
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION    *PWHEA_XPF_PROCESSOR_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION    WHEA_XPF_PROCESSOR_ERROR;
typedef WHEA_XPF_PROCESSOR_ERROR_SECTION    *PWHEA_XPF_PROCESSOR_ERROR;
#endif

/* Windows Hardware Error Architecture memory error section valid bits */
typedef union _WHEA_MEMORY_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   ErrorStatus         : 1;
        ULONG   PhysicalAddress     : 1;
        ULONG   PhysicalAddressMask : 1;
        ULONG   Node                : 1;
        ULONG   Card                : 1;
        ULONG   Module              : 1;
        ULONG   Bank                : 1;
        ULONG   Device              : 1;
        ULONG   Row                 : 1;
        ULONG   Column              : 1;
        ULONG   BitPosition         : 1;
        ULONG   RequesterId         : 1;
        ULONG   ResponderId         : 1;
        ULONG   TargetId            : 1;
        ULONG   ErrorType           : 1;
        ULONG   Reserved            : 17;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_MEMORY_ERROR_SECTION_VALIDBITS;
typedef WHEA_MEMORY_ERROR_SECTION_VALIDBITS *PWHEA_MEMORY_ERROR_SECTION_VALIDBITS;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_MEMORY_ERROR_SECTION_VALIDBITS WHEA_MEMORY_ERROR_VALIDBITS;
typedef WHEA_MEMORY_ERROR_SECTION_VALIDBITS *PWHEA_MEMORY_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture memory error section */
typedef struct _WHEA_MEMORY_ERROR_SECTION {
    WHEA_MEMORY_ERROR_SECTION_VALIDBITS ValidBits;
    WHEA_ERROR_STATUS                   ErrorStatus;
    ULONGLONG                           PhysicalAddress;
    ULONGLONG                           PhysicalAddressMask;
    USHORT                              Node;
    USHORT                              Card;
    USHORT                              Module;
    USHORT                              Bank;
    USHORT                              Device;
    USHORT                              Row;
    USHORT                              Column;
    USHORT                              BitPosition;
    ULONGLONG                           RequesterId;
    ULONGLONG                           ResponderId;
    ULONGLONG                           TargetId;
    UCHAR                               ErrorType;
} WHEA_MEMORY_ERROR_SECTION;
typedef WHEA_MEMORY_ERROR_SECTION   *PWHEA_MEMORY_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_MEMORY_ERROR_SECTION   WHEA_MEMORY_ERROR;
typedef WHEA_MEMORY_ERROR_SECTION   *PWHEA_MEMORY_ERROR;
#endif

/* Windows Hardware Error Architecture PCI express error section valid bits */
typedef union _WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   PortType            : 1;
        ULONG   Version             : 1;
        ULONG   CommandStatus       : 1;
        ULONG   DeviceId            : 1;
        ULONG   DeviceSerialNumber  : 1;
        ULONG   BridgeControlStatus : 1;
        ULONG   ExpressCapability   : 1;
        ULONG   AerInfo             : 1;
        ULONG   Reserved            : 24;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS;
typedef WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS *PWHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS WHEA_PCI_EXPRESS_ERROR_VALIDBITS;
typedef WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS *PWHEA_PCI_EXPRESS_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture PCI express device identifier */
typedef struct _WHEA_PCIEXPRESS_DEVICE_ID { 
    USHORT  VendorID;
    USHORT  DeviceID;
    ULONG   ClassCode           : 24;
    ULONG   FunctionNumber      : 8;
    ULONG   DeviceNumber        : 8;
    ULONG   Segment             : 16;
    ULONG   PrimaryBusNumber    : 8;
    ULONG   SecondaryBusNumber  : 8;
    ULONG   Reserved1           : 3;
    ULONG   SlotNumber          : 13;
    ULONG   Reserved2           : 8;
} WHEA_PCIEXPRESS_DEVICE_ID;
typedef WHEA_PCIEXPRESS_DEVICE_ID   *PWHEA_PCIEXPRESS_DEVICE_ID;

/* Windows Hardware Error Architecture PCI express version */
typedef union _WHEA_PCIEXPRESS_VERSION {
    struct {
        UCHAR   MinorVersion;
        UCHAR   MajorVersion;
        USHORT  Reserved;
    };
    ULONG   AsULONG;
} WHEA_PCIEXPRESS_VERSION;
typedef WHEA_PCIEXPRESS_VERSION *PWHEA_PCIEXPRESS_VERSION;

/* Windows Hardware Error Architecture PCI express command status */
typedef union _WHEA_PCIEXPRESS_COMMAND_STATUS {
    struct {
        USHORT  Command;
        USHORT  Status;
    };
    ULONG   AsULONG;
} WHEA_PCIEXPRESS_COMMAND_STATUS;
typedef WHEA_PCIEXPRESS_COMMAND_STATUS  *PWHEA_PCIEXPRESS_COMMAND_STATUS;

/* Windows Hardware Error Architecture PCI express bridge control status */
typedef union _WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS {
    struct {
        USHORT  BridgeSecondaryStatus;
        USHORT  BridgeControl;
    };
    ULONG   AsULONG;
} WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS;
typedef WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS   *PWHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS;

/* Windows Hardware Error Architecture PCI express device types */
typedef enum _WHEA_PCIEXPRESS_DEVICE_TYPE {
    WheaPciExpressEndpoint                      = 0,
    WheaPciExpressLegacyEndpoint                = 1,
    WheaPciExpressRootPart                      = 2,
    WheaPciExpressUpstreamSwitchPort            = 3,
    WheaPciExpressDownstreamSwitchPort          = 4,
    WheaPciExpressToPciXBridge                  = 5,
    WheaPciXToExpressBridge                     = 6,
    WheaPciExpressRootComplexIntegratedEndpoint = 7,
    WheaPciExpressRootComplexEventCollector     = 8
} WHEA_PCIEXPRESS_DEVICE_TYPE;

/* Windows Hardware Error Architecture PCI express error section */
typedef struct _WHEA_PCIEXPRESS_ERROR_SECTION {
    WHEA_PCIEXPRESS_ERROR_SECTION_VALIDBITS ValidBits;
    WHEA_PCIEXPRESS_DEVICE_TYPE             PortType;
    WHEA_PCIEXPRESS_VERSION                 Version;
    WHEA_PCIEXPRESS_COMMAND_STATUS          CommandStatus;
    ULONG                                   Reserved;
    WHEA_PCIEXPRESS_DEVICE_ID               DeviceId;
    ULONGLONG                               DeviceSerialNumber;
    WHEA_PCIEXPRESS_BRIDGE_CONTROL_STATUS   BridgeControlStatus;
    UCHAR                                   ExpressCapability[60];
    UCHAR                                   AerInfo[96];
} WHEA_PCIEXPRESS_ERROR_SECTION;
typedef WHEA_PCIEXPRESS_ERROR_SECTION   *PWHEA_PCIEXPRESS_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PCIEXPRESS_ERROR_SECTION   WHEA_PCIEXPRESS_ERROR;
typedef WHEA_PCIEXPRESS_ERROR_SECTION   *PWHEA_PCIEXPRESS_ERROR;
#endif

/* Windows Hardware Error Architecture PCIX bus error section valid bits */
typedef union _WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   ErrorStatus : 1;
        ULONG   ErrorType   : 1;
        ULONG   BusId       : 1;
        ULONG   BusAddress  : 1;
        ULONG   BusData     : 1;
        ULONG   BusCommand  : 1;
        ULONG   RequesterId : 1;
        ULONG   CompleterId : 1;
        ULONG   TargetId    : 1;
        ULONG   Reserved    : 23;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS;
typedef WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS    *PWHEA_PCIXBUS_ERROR_SECTION_VALIDBITS;
#if WHEA_PCIXBUS_TYPE_NAMES
typedef WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS    WHEA_PCIXBUS_ERROR_VALIDBITS;
typedef WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS    *PWHEA_PCIXBUS_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture PCIX bus identifier */
typedef union _WHEA_PCIXBUS_ID {
    struct {
        UCHAR   BusNumber;
        UCHAR   BusSegment;
    };
    USHORT  AsUSHORT;
} WHEA_PCIXBUS_ID;
typedef WHEA_PCIXBUS_ID *PWHEA_PCIXBUS_ID;

/* Windows Hardware Error Architecture PCIX bus command */
typedef union _WHEA_PCIXBUS_COMMAND {
#if 0
    struct {
        ULONGLONG   Command     : 56;
        ULONGLONG   PCIXCommand : 1;
        ULONGLONG   Reserved    : 7;
    };
#endif
    ULONGLONG   AsULONGLONG;
} WHEA_PCIXBUS_COMMAND;
typedef WHEA_PCIXBUS_COMMAND    *PWHEA_PCIXBUS_COMMAND;

/* Windows Hardware Error Architecture PCIX bus error section */
typedef struct _WHEA_PCIXBUS_ERROR_SECTION {
    WHEA_PCIXBUS_ERROR_SECTION_VALIDBITS    ValidBits;
    WHEA_ERROR_STATUS                       ErrorStatus;
    USHORT                                  ErrorType;
    WHEA_PCIXBUS_ID                         BusId;
    ULONG                                   Reserved;
    ULONGLONG                               BusAddress;
    ULONGLONG                               BusData;
    WHEA_PCIXBUS_COMMAND                    BusCommand;
    ULONGLONG                               RequesterId;
    ULONGLONG                               CompleterId;
    ULONGLONG                               TargetId;
} WHEA_PCIXBUS_ERROR_SECTION;
typedef WHEA_PCIXBUS_ERROR_SECTION  *PWHEA_PCIXBUS_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PCIXBUS_ERROR_SECTION  WHEA_PCIXBUS_ERROR;
typedef WHEA_PCIXBUS_ERROR_SECTION  *PWHEA_PCIXBUS_ERROR;
#endif

/* Windows Hardware Error Architecture PCIX device error section valid bits */
typedef union _WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS {
    struct {
        ULONG   ErrorStatus         : 1;
        ULONG   IdInfo              : 1;
        ULONG   MemoryNumber        : 1;
        ULONG   IdNumber            : 1;
        ULONG   RegisterDataPairs   : 1;
        ULONG   Reserved            : 27;
        ULONG   Reserved2;
    };
    ULONGLONG   ValidBits;
} WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS;
typedef WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS *PWHEA_PCIXDEVICE_ERROR_SECTION_VALID_BITS;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS WHEA_PCIXDEVICE_ERROR_VALIDBITS;
typedef WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS *PWHEA_PCIXDEVICE_ERROR_VALIDBITS;
#endif

/* Windows Hardware Error Architecture PCIX device identifier */
typedef struct _WHEA_PCIXDEVICE_ID {
    USHORT  VendorId;
    USHORT  DeviceId;
    ULONG   ClassCode       : 24;
    ULONG   FunctionNumber  : 8;
    ULONG   DeviceNumber    : 8;
    ULONG   BusNumber       : 8;
    ULONG   SegmentNumber   : 8;
    ULONG   Reserved1       : 8;
    ULONG   Reserved2;
} WHEA_PCIXDEVICE_ID;
typedef WHEA_PCIXDEVICE_ID  *PWHEA_PCIXDEVICE_ID;

/* Windows Hardware Error Architecture PCIX device register pair */
typedef struct WHEA_PCIXDEVICE_REGISTER_PAIR {
    ULONGLONG   Register;
    ULONGLONG   Data;
} WHEA_PCIXDEVICE_REGISTER_PAIR;
typedef WHEA_PCIXDEVICE_REGISTER_PAIR   *PWHEA_PCIXDEVICE_REGISTER_PAIR;

/* Windows Hardware Error Architecture PCIX device error section */
typedef struct _WHEA_PCIXDEVICE_ERROR_SECTION {
    WHEA_PCIXDEVICE_ERROR_SECTION_VALIDBITS ValidBits;
    WHEA_ERROR_STATUS                       ErrorStatus;
    WHEA_PCIXDEVICE_ID                      IdInfo;
    ULONG                                   MemoryNumber;
    ULONG                                   IoNumber;
    WHEA_PCIXDEVICE_REGISTER_PAIR           RegisterDataPairs[ANYSIZE_ARRAY];
} WHEA_PCIXDEVICE_ERROR_SECTION;
typedef WHEA_PCIXDEVICE_ERROR_SECTION   *PWHEA_PCIXDEVICE_ERROR_SECTION;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_PCIXDEVICE_ERROR_SECTION   WHEA_PCIXDEVICE_ERROR;
typedef WHEA_PCIXDEVICE_ERROR_SECTION   *PWHEA_PCIXDEVICE_ERROR;
#endif

/* Windows Hardware Error Architecture firmware error record reference */
typedef struct _WHEA_FIRMWARE_ERROR_RECORD_REFERENCE {
    UCHAR       Type;
    UCHAR       Reserved[7];
    ULONGLONG   FirmwareRecordId;
} WHEA_FIRMWARE_ERROR_RECORD_REFERENCE;
typedef WHEA_FIRMWARE_ERROR_RECORD_REFERENCE    *PWHEA_FIRMWARE_ERROR_RECORD_REFERENCE;
#if WHEA_DOWNLEVEL_TYPE_NAMES
typedef WHEA_FIRMWARE_ERROR_RECORD_REFERENCE    WHEA_FIRMWARE_RECORD;
typedef WHEA_FIRMWARE_ERROR_RECORD_REFERENCE    *PWHEA_FIRMWARE_RECORD;
#endif

/* MCG status */
typedef union _MCG_STATUS {
    struct {
        ULONG   RestartIpValid          : 1;
        ULONG   ErrorIpValid            : 1;
        ULONG   MachineCheckInProgress  : 1;
        ULONG   Reserved1               : 29;
        ULONG   Reserved2;
    };
    ULONGLONG   QuadPart;
} MCG_STATUS;
typedef MCG_STATUS  *PMCG_STATUS;

/* MCI status */
typedef union _MCI_STATUS {
    struct {
        USHORT  McaErrorCode;
        USHORT  ModelErrorCode;
        ULONG   OtherInformation    : 23;
        ULONG   ActionRequired      : 1;
        ULONG   Signalling          : 1;
        ULONG   ContextCorrupt      : 1;
        ULONG   AddressValid        : 1;
        ULONG   MiscValid           : 1;
        ULONG   ErrorEnabled        : 1;
        ULONG   UncorrectedError    : 1;
        ULONG   StatusOverflow      : 1;
        ULONG   Valid               : 1;
    };
    ULONG64 QuadPart;
} MCI_STATUS;
typedef MCI_STATUS  *PMCI_STATUS;

/* Windows Hardware Error Architecture CPU vendors */
typedef enum _WHEA_CPU_VENDOR {
    WheaCpuVendorOther  = 0,
    WheaCpuVendorIntel  = 1,
    WheaCpuVendorAmd    = 2
} WHEA_CPU_VENDOR;
typedef WHEA_CPU_VENDOR *PWHEA_CPU_VENDOR;

/* Windows Hardware Error Architecture XPF MCA section */
typedef struct _WHEA_XPF_MCA_SECTION {
    ULONG           VersionNumber;
    WHEA_CPU_VENDOR CpuVendor;
    LARGE_INTEGER   Timestamp;
    ULONG           ProcessorNumber;
    MCG_STATUS      GlobalStatus;
    ULONGLONG       InstructionPointer;
    ULONG           BankNumber;
    MCI_STATUS      Status;
    ULONGLONG       Address;
    ULONGLONG       Misc;
    ULONG           ExtendedRegisterCount;
    ULONG           Reserved2;
    ULONGLONG       ExtendedRegisters[WHEA_XPF_MCA_EXTREG_MAX_COUNT];
} WHEA_XPF_MCA_SECTION;
typedef WHEA_XPF_MCA_SECTION    *PWHEA_XPF_MCA_SECTION;

/* Windows Hardware Error Architecture NMI error section flags */
typedef union _WHEA_NMI_ERROR_SECTION_FLAGS {
    struct {
        ULONG   HypervisorError : 1;
        ULONG   Reserved        : 31;
    };
    ULONG   AsULONG;
} WHEA_NMI_ERROR_SECTION_FLAGS;
typedef WHEA_NMI_ERROR_SECTION_FLAGS    *PWHEA_ERROR_SECTION_FLAGS;

/* Windows Hardware Error Architecture NMI error section */
typedef struct _WHEA_NMI_ERROR_SECTION {
    UCHAR                           Data[8];
    WHEA_NMI_ERROR_SECTION_FLAGS    Flags;
} WHEA_NMI_ERROR_SECTION;
typedef WHEA_NMI_ERROR_SECTION  *PWHEA_NMI_ERROR_SECTION;

/* Windows Hardware Error Architecture error types */
typedef enum _WHEA_ERROR_TYPE {
    WheaErrTypeProcessor    = 0,
    WheaErrTypeMemory       = 1,
    WheaErrTypePCIExpress   = 2,
    WheaErrTypeNMI          = 3,
    WheaErrTypePCIXBus      = 4,
    WheaErrTypePCIXDevice   = 5,
    WheaErrTypeGeneric      = 6
} WHEA_ERROR_TYPE;

/* Windows Hardware Error Architecture error packet flags */
typedef union _WHEA_ERROR_PACKET_FLAGS {
    struct {
        ULONG   PreviousError           : 1;
        ULONG   Reserved1               : 1;
        ULONG   HypervisorError         : 1;
        ULONG   Simulated               : 1;
        ULONG   PlatformPfaControl      : 1;
        ULONG   PlatformDirectedOffline : 1;
        ULONG   Reserved2               : 26;
    };
    ULONG   AsULONG;
} WHEA_ERROR_PACKET_FLAGS;
typedef WHEA_ERROR_PACKET_FLAGS *PWHEA_ERROR_PACKET_FLAGS;

/* Windows Hardware Error Architecture error packet data formats */
typedef enum _WHEA_ERROR_PACKET_DATA_FORMAT {
    WheaDataFormatIPFSalRecord  = 0,
    WheaDataFormatXPFMCA        = 1,
    WheaDataFormatMemory        = 2,
    WheaDataFormatPCIExpress    = 3,
    WheaDataFormatNMIPort       = 4,
    WheaDataFormatPCIXBus       = 5,
    WheaDataFormatPCIXDevice    = 6,
    WheaDataFormatGeneric       = 7,
    WheaDataFormatMax           = 8
} WHEA_ERROR_PACKET_DATA_FORMAT;
typedef WHEA_ERROR_PACKET_DATA_FORMAT   *PWHEA_ERROR_PACKET_DATA_FORMAT;

/* Windows Hardware Error Architecture raw data format */
typedef enum _WHEA_RAW_DATA_FORMAT {
    WheaRawDataFormatIPFSalRecord   = 0x00,
    WheaRawDataFormatIA32MCA        = 0x01,
    WheaRawDataFormatIntel64MCA     = 0x02,
    WheaRawDataFormatAMD64MCA       = 0x03,
    WheaRawDataFormatMemory         = 0x04,
    WheaRawDataFormatPCIExpress     = 0x05,
    WheaRawDataFormatNMIPort        = 0x06,
    WheaRawDataFormatPCIXBus        = 0x07,
    WheaRawDataFormatPCIXDevice     = 0x08,
    WheaRawDataFormatGeneric        = 0x09,
    WheaRawDataFormatMax            = 0x0A
} WHEA_RAW_DATA_FORMAT;
typedef WHEA_RAW_DATA_FORMAT    *PWHEA_RAW_DATA_FORMAT;

/* Windows Hardware Error Architecture error packet (version 1) */
typedef struct _WHEA_ERROR_PACKET_V1 {
    ULONG                       Signature;
    WHEA_ERROR_PACKET_FLAGS     Flags;
    ULONG                       Size;
    ULONG                       RawDataLength;
    ULONGLONG                   Reserved1;
    ULONGLONG                   Context;
    WHEA_ERROR_TYPE             ErrorType;
    WHEA_ERROR_SEVERITY         ErrorSeverity;
    ULONG                       ErrorSourceId;
    WHEA_ERROR_SOURCE_TYPE      ErrorSourceType;
    ULONG                       Reserved2;
    ULONG                       Version;
    ULONGLONG                   Cpu;
    union {
        WHEA_PROCESSOR_GENERIC_ERROR_SECTION    ProcessorError;
        WHEA_MEMORY_ERROR_SECTION               MemoryError;
        WHEA_NMI_ERROR_SECTION                  NmiError;
        WHEA_PCIEXPRESS_ERROR_SECTION           PciExpressError;
        WHEA_PCIXBUS_ERROR_SECTION              PciXBusError;
        WHEA_PCIXDEVICE_ERROR_SECTION           PciXDeviceError;
    } u;
    WHEA_RAW_DATA_FORMAT        RawDataFormat;
    ULONG                       RawDataOffset;
    UCHAR                       RawData[1];
} WHEA_ERROR_PACKET_V1;
typedef WHEA_ERROR_PACKET_V1    *PWHEA_ERROR_PACKET_V1;

/* Windows Hardware Error Architecture error packet (version 2) */
typedef struct _WHEA_ERROR_PACKET_V2 {
    ULONG                           Signature;
    ULONG                           Version;
    ULONG                           Length;
    WHEA_ERROR_PACKET_FLAGS         Flags;
    WHEA_ERROR_TYPE                 ErrorType;
    WHEA_ERROR_SEVERITY             ErrorSeverity;
    ULONG                           ErrorSourceId;
    WHEA_ERROR_SOURCE_TYPE          ErrorSourceType;
    GUID                            NotifyType;
    ULONGLONG                       Context;
    WHEA_ERROR_PACKET_DATA_FORMAT   DataFormat;
    ULONG                           Reserved1;
    ULONG                           DataOffset;
    ULONG                           DataLength;
    ULONG                           PshedDataOffset;
    ULONG                           PshedDataLength;
} WHEA_ERROR_PACKET_V2;
typedef WHEA_ERROR_PACKET_V2    *PWHEA_ERROR_PACKET_V2;

/* Windows Hardware Error Architecture error packet */
#if (NTDDI_VERSION >= 0x06010000)
typedef WHEA_ERROR_PACKET_V2    WHEA_ERROR_PACKET;
typedef WHEA_ERROR_PACKET_V2    *PWHEA_ERROR_PACKET;
#else
typedef WHEA_ERROR_PACKET_V1    WHEA_ERROR_PACKET;
typedef WHEA_ERROR_PACKET_V1    *PWHEA_ERROR_PACKET;
#endif

/* Windows Hardware Error Architecture generic error block status */
typedef union _WHEA_GENERIC_ERROR_BLOCKSTATUS {
    struct {
        ULONG   UncorrectableError          : 1;
        ULONG   CorrectableError            : 1;
        ULONG   MultipleUncorrectableErrors : 1;
        ULONG   MultipleCorrectableErrors   : 1;
        ULONG   ErrorDataEntryCount         : 10;
        ULONG   Reserved                    : 18;
    };
    ULONG   AsULONG;
} WHEA_GENERIC_ERROR_BLOCKSTATUS;
typedef WHEA_GENERIC_ERROR_BLOCKSTATUS  *PWHEA_GENERIC_ERROR_BLOCKSTATUS;

/* Windows Hardware Error Architecture generic error */
typedef struct _WHEA_GENERIC_ERROR {
    WHEA_GENERIC_ERROR_BLOCKSTATUS  BlockStatus;
    ULONG                           RawDataOffset;
    ULONG                           RawDataLength;
    ULONG                           DataLength;
    WHEA_ERROR_SEVERITY             ErrorSeverity;
    UCHAR                           Data[1];
} WHEA_GENERIC_ERROR;
typedef WHEA_GENERIC_ERROR  *PWHEA_GENERIC_ERROR;

/* Windows Hardware Error Architecture generic error data entry */
typedef struct _WHEA_GENERIC_ERROR_DATA_ENTRY {
    GUID                SectionType;
    WHEA_ERROR_SEVERITY ErrorSeverity;
    WHEA_REVISION       Revision;
    UCHAR               ValidBits;
    UCHAR               Flags;
    ULONG               ErrorDataLength;
    GUID                FRUId;
    UCHAR               FRUText[20];
    UCHAR               Data[1];
} WHEA_GENERIC_ERROR_DATA_ENTRY;
typedef WHEA_GENERIC_ERROR_DATA_ENTRY   *PWHEA_GENERIC_ERROR_DATA_ENTRY;

/* Revert to default packing. */
#pragma pack( __pop )

/* Windows Hardware Error Architecture error injection capabilities */
typedef union _WHEA_ERROR_INJECTION_CAPABILITIES {
    struct {
        ULONG   ProcessorCorrectable            : 1;
        ULONG   ProcessorUncorrectableNonFatal  : 1;
        ULONG   ProcessorUncorrectableFatal     : 1;
        ULONG   MemoryCorrectable               : 1;
        ULONG   MemoryUncorrectableNonFatal     : 1;
        ULONG   MemoryUncorrectableFatal        : 1;
        ULONG   PCIExpressCorrectable           : 1;
        ULONG   PCIExpressUncorrectableNonFatal : 1;
        ULONG   PCIExpressUncorrectableFatal    : 1;
        ULONG   PlatformCorrectable             : 1;
        ULONG   PlatformUncorrectableNonFatal   : 1;
        ULONG   PlatformUncorrectableFatal      : 1;
        ULONG   IA64Corrected                   : 1;
        ULONG   IA64Recoverable                 : 1;
        ULONG   IA64Fatal                       : 1;
        ULONG   IA64RecoverableCache            : 1;
        ULONG   IA64RecoverableRegFile          : 1;
        ULONG   Reserved                        : 15;
    };
    ULONG   AsULONG;
} WHEA_ERROR_INJECTION_CAPABILITIES;
typedef WHEA_ERROR_INJECTION_CAPABILITIES   *PWHEA_ERROR_INJECTION_CAPABILITIES;

/* PSHED plugin callbacks */
typedef NTSTATUS    (NTAPI *PSHED_PI_GET_ALL_ERROR_SOURCES)( PVOID, PULONG, PWHEA_ERROR_SOURCE_DESCRIPTOR *, PULONG );
typedef NTSTATUS    (NTAPI *PSHED_PI_GET_ERROR_SOURCE_INFO)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *PSHED_PI_SET_ERROR_SOURCE_INFO)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *PSHED_PI_ENABLE_ERROR_SOURCE)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *PSHED_PI_DISABLE_ERROR_SOURCE)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR );
typedef NTSTATUS    (NTAPI *PSHED_PI_WRITE_ERROR_RECORD)( PVOID, ULONG, ULONG, PWHEA_ERROR_RECORD );
typedef NTSTATUS    (NTAPI *PSHED_PI_READ_ERROR_RECORD)( PVOID, ULONG, ULONGLONG, PULONGLONG, PULONG, PWHEA_ERROR_RECORD );
typedef NTSTATUS    (NTAPI *PSHED_PI_CLEAR_ERROR_RECORD)( PVOID, ULONG, ULONGLONG );
typedef NTSTATUS    (NTAPI *PSHED_PI_RETRIEVE_ERROR_INFO)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR, ULONGLONG, PWHEA_ERROR_PACKET );
typedef NTSTATUS    (NTAPI *PSHED_PI_FINALIZE_ERROR_RECORD)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR, ULONG, PWHEA_ERROR_RECORD );
typedef NTSTATUS    (NTAPI *PSHED_PI_CLEAR_ERROR_STATUS)( PVOID, PWHEA_ERROR_SOURCE_DESCRIPTOR, ULONG, PWHEA_ERROR_RECORD );
typedef NTSTATUS    (NTAPI *PSHED_PI_ATTEMPT_ERROR_RECOVERY)( PVOID, ULONG, PWHEA_ERROR_RECORD );
typedef NTSTATUS    (NTAPI *PSHED_PI_GET_INJECTION_CAPABILITIES)( PVOID, PWHEA_ERROR_INJECTION_CAPABILITIES );
typedef NTSTATUS    (NTAPI *PSHED_PI_INJECT_ERROR)( PVOID, ULONGLONG, ULONGLONG, ULONGLONG, ULONGLONG, ULONGLONG );

/* Windows Hardware Error Architecture PSHED plugin callbacks */
typedef struct _WHEA_PSHED_PLUGIN_CALLBACKS {
    PSHED_PI_GET_ALL_ERROR_SOURCES      GetAllErrorSources;
    PVOID                               Reserved;
    PSHED_PI_GET_ERROR_SOURCE_INFO      GetErrorSourceInfo;
    PSHED_PI_SET_ERROR_SOURCE_INFO      SetErrorSourceInfo;
    PSHED_PI_ENABLE_ERROR_SOURCE        EnableErrorSource;
    PSHED_PI_DISABLE_ERROR_SOURCE       DisableErrorSource;
    PSHED_PI_WRITE_ERROR_RECORD         WriteErrorSource;
    PSHED_PI_READ_ERROR_RECORD          ReadErrorSource;
    PSHED_PI_RETRIEVE_ERROR_INFO        RetrieveErrorInfo;
    PSHED_PI_FINALIZE_ERROR_RECORD      FinalizeErrorRecord;
    PSHED_PI_CLEAR_ERROR_STATUS         ClearErrorStatus;
    PSHED_PI_ATTEMPT_ERROR_RECOVERY     AttemptRecovery;
    PSHED_PI_GET_INJECTION_CAPABILITIES GetInjectionCapabilities;
    PSHED_PI_INJECT_ERROR               InjectError;
} WHEA_PSHED_PLUGIN_CALLBACKS;
typedef WHEA_PSHED_PLUGIN_CALLBACKS *PWHEA_PSHED_PLUGIN_CALLBACKS;

/* Windows Hardware Error Architecture PSHED plugin registration packet */
typedef struct _WHEA_PSHED_PLUGIN_REGISTRATION_PACKET {
    ULONG                       Length;
    ULONG                       Version;
    PVOID                       Context;
    ULONG                       FunctionalAreaMask;
    ULONG                       Reserved;
    WHEA_PSHED_PLUGIN_CALLBACKS Callbacks;
} WHEA_PSHED_PLUGIN_REGISTRATION_PACKET;
typedef WHEA_PSHED_PLUGIN_REGISTRATION_PACKET   *PWHEA_PSHED_PLUGIN_REGISTRATION_PACKET;

/* Global variables in NTOSKRNL.EXE */
extern NTKERNELAPI PHAL_DISPATCH __cdecl HalDispatchTable;
extern NTKERNELAPI PEPROCESS __cdecl PsInitialSystemProcess;
#ifdef _X86_
extern NTKERNELAPI PVOID    __cdecl MmHighestUserAddress;
extern NTKERNELAPI PVOID    __cdecl MmSystemRangeStart;
extern NTKERNELAPI ULONG    __cdecl MmUserProbeAddress;
#endif

/* Functions in NTDLL.DLL and NTOSKRNL.EXE */
NTSYSAPI ULONG          NTAPI DbgPrompt( PCCH, PCH, ULONG );
NTSYSAPI NTSTATUS       NTAPI RtlRunOnceBeginInitialize( PRTL_RUN_ONCE, ULONG, PVOID * );
NTSYSAPI NTSTATUS       NTAPI RtlRunOnceComplete( PRTL_RUN_ONCE, ULONG, PVOID );
NTSYSAPI NTSTATUS       NTAPI RtlRunOnceExecuteOnce( PRTL_RUN_ONCE, PRTL_RUN_ONCE_INIT_FN, PVOID, PVOID * );
NTSYSAPI VOID           NTAPI RtlRunOnceInitialize( PRTL_RUN_ONCE );
NTSYSAPI NTSTATUS       NTAPI ZwAllocateLocallyUniqueId( PLUID );
NTSYSAPI NTSTATUS       NTAPI ZwOpenProcess( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PCLIENT_ID );
NTSYSAPI NTSTATUS       NTAPI ZwTerminateProcess( HANDLE, NTSTATUS );
#if (NTDDI_VERSION >= 0x05000000)
NTSYSAPI NTSTATUS       NTAPI RtlCharToInteger( PCSZ, ULONG, PULONG );
NTSYSAPI LONG           NTAPI RtlCompareString( const STRING *, const STRING *, BOOLEAN );
NTSYSAPI VOID           NTAPI RtlCopyString( PSTRING, const STRING * );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlDelete( PRTL_SPLAY_LINKS );
NTSYSAPI VOID           NTAPI RtlDeleteNoSplay( PRTL_SPLAY_LINKS, PRTL_SPLAY_LINKS * );
NTSYSAPI BOOLEAN        NTAPI RtlEqualString( const STRING *, const STRING *, BOOLEAN );
NTSYSAPI VOID           NTAPI RtlGetCallersAddress( PVOID *, PVOID * );
NTSYSAPI NTSTATUS       NTAPI RtlGetVersion( PRTL_OSVERSIONINFOW );
NTSYSAPI LARGE_INTEGER  NTAPI RtlLargeIntegerDivide( LARGE_INTEGER, LARGE_INTEGER, PLARGE_INTEGER );
NTSYSAPI VOID           NTAPI RtlMapGenericMask( PACCESS_MASK, PGENERIC_MAPPING );
NTSYSAPI BOOLEAN        NTAPI RtlPrefixUnicodeString( PCUNICODE_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlRealPredeccesor( PRTL_SPLAY_LINKS );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlRealSuccessor( PRTL_SPLAY_LINKS );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlSplay( PRTL_SPLAY_LINKS );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlSubtreePredecessor( PRTL_SPLAY_LINKS );
NTSYSAPI PRTL_SPLAY_LINKS NTAPI RtlSubtreeSuccessor( PRTL_SPLAY_LINKS );
NTSYSAPI NTSTATUS       NTAPI RtlUpcaseUnicodeString( PUNICODE_STRING, PCUNICODE_STRING, BOOLEAN );
NTSYSAPI CHAR           NTAPI RtlUpperChar( CHAR );
NTSYSAPI VOID           NTAPI RtlUpperString( PSTRING, const STRING * );
NTSYSAPI NTSTATUS       NTAPI RtlVerifyVersionInfo( PRTL_OSVERSIONINFOEXW, ULONG, ULONGLONG );
NTSYSAPI NTSTATUS       NTAPI RtlVolumeDeviceToDosName( PVOID, PUNICODE_STRING );
NTSYSAPI ULONG          NTAPI RtlWalkFrameChain( PVOID *, ULONG, ULONG );
NTSYSAPI ULONGLONG      NTAPI VerSetConditionMask( ULONGLONG, ULONG, UCHAR );
NTSYSAPI NTSTATUS       NTAPI ZwCancelTimer( HANDLE, PBOOLEAN );
NTSYSAPI NTSTATUS       NTAPI ZwCreateTimer( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, TIMER_TYPE );
NTSYSAPI NTSTATUS       NTAPI ZwDeviceIoControlFile( HANDLE, HANDLE, PIO_APC_ROUTINE, PVOID, PIO_STATUS_BLOCK, ULONG, PVOID, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwDisplayString( PUNICODE_STRING );
NTSYSAPI NTSTATUS       NTAPI ZwOpenTimer( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES );
NTSYSAPI NTSTATUS       NTAPI ZwPowerInformation( POWER_INFORMATION_LEVEL, PVOID, ULONG, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwQueryVolumeInformationFile( HANDLE, PIO_STATUS_BLOCK, PVOID, ULONG, FS_INFORMATION_CLASS );
NTSYSAPI NTSTATUS       NTAPI ZwSetInformationThread( HANDLE, THREADINFOCLASS, PVOID, ULONG );
NTSYSAPI NTSTATUS       NTAPI ZwSetTimer( HANDLE, PLARGE_INTEGER, PTIMER_APC_ROUTINE, PVOID, BOOLEAN, LONG, PBOOLEAN );
#ifndef RTL_USE_AVL_TABLES
NTSYSAPI BOOLEAN        NTAPI RtlDeleteElementGenericTable( PRTL_GENERIC_TABLE, PVOID );
NTSYSAPI PVOID          NTAPI RtlEnumerateGenericTable( PRTL_GENERIC_TABLE, BOOLEAN );
NTSYSAPI PVOID          NTAPI RtlEnumerateGenericTableWithoutSplaying( PRTL_GENERIC_TABLE, PVOID * );
NTSYSAPI PVOID          NTAPI RtlGetElementGenericTable( PRTL_GENERIC_TABLE, ULONG );
NTSYSAPI VOID           NTAPI RtlInitializeGenericTable( PRTL_GENERIC_TABLE, PRTL_GENERIC_COMPARE_ROUTINE, PRTL_GENERIC_ALLOCATE_ROUTINE, PRTL_GENERIC_FREE_ROUTINE, PVOID );
NTSYSAPI PVOID          NTAPI RtlInsertElementGenericTable( PRTL_GENERIC_TABLE, PVOID, CLONG, PBOOLEAN );
NTSYSAPI PVOID          NTAPI RtlInsertElementGenericTableFull( PRTL_GENERIC_TABLE, PVOID, CLONG, PBOOLEAN, PVOID, TABLE_SEARCH_RESULT );
NTSYSAPI BOOLEAN        NTAPI RtlIsGenericTableEmpty( PRTL_GENERIC_TABLE );
NTSYSAPI PVOID          NTAPI RtlLookupElementGenericTable( PRTL_GENERIC_TABLE, PVOID );
NTSYSAPI PVOID          NTAPI RtlLookupElementGenericTableFull( PRTL_GENERIC_TABLE, PVOID, PVOID *, TABLE_SEARCH_RESULT * );
NTSYSAPI ULONG          NTAPI RtlNumberGenericTableElements( PRTL_GENERIC_TABLE );
#endif
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTSYSAPI BOOLEAN        NTAPI RtlDeleteElementGenericTableAvl( PRTL_AVL_TABLE, PVOID );
NTSYSAPI PVOID          NTAPI RtlEnumerateGenericTableAvl( PRTL_AVL_TABLE, BOOLEAN );
NTSYSAPI PVOID          NTAPI RtlEnumerateGenericTableLikeADictionary( PRTL_AVL_TABLE, PRTL_AVL_MATCH_FUNCTION, PVOID, ULONG, PVOID *, PULONG, PVOID );
NTSYSAPI PVOID          NTAPI RtlEnumerateGenericTableWithoutSplayingAvl( PRTL_AVL_TABLE, PVOID * );
NTSYSAPI PVOID          NTAPI RtlGetElementGenericTableAvl( PRTL_AVL_TABLE, ULONG );
NTSYSAPI VOID           NTAPI RtlInitializeGenericTableAvl( PRTL_AVL_TABLE, PRTL_AVL_COMPARE_ROUTINE, PRTL_AVL_ALLOCATE_ROUTINE, PRTL_AVL_FREE_ROUTINE, PVOID );
NTSYSAPI PVOID          NTAPI RtlInsertElementGenericTableAvl( PRTL_AVL_TABLE, PVOID, CLONG, PBOOLEAN );
NTSYSAPI PVOID          NTAPI RtlInsertElementGenericTableFullAvl( PRTL_AVL_TABLE, PVOID, CLONG, PBOOLEAN, PVOID, TABLE_SEARCH_RESULT );
NTSYSAPI BOOLEAN        NTAPI RtlIsGenericTableEmptyAvl( PRTL_AVL_TABLE );
NTSYSAPI PVOID          NTAPI RtlLookupElementGenericTableAvl( PRTL_AVL_TABLE, PVOID );
NTSYSAPI PVOID          NTAPI RtlLookupElementGenericTableFullAvl( PRTL_AVL_TABLE, PVOID, PVOID *, TABLE_SEARCH_RESULT * );
NTSYSAPI PVOID          NTAPI RtlLookupFirstMatchingElementGenericTableAvl( PRTL_AVL_TABLE, PVOID, PVOID * );
NTSYSAPI ULONG          NTAPI RtlNumberGenericTableElementsAvl( PRTL_AVL_TABLE );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTSYSAPI BOOLEAN        NTAPI RtlGetProductInfo( ULONG, ULONG, ULONG, ULONG, PULONG );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTSYSAPI BOOLEAN        NTAPI RtlContractHashTable( PRTL_DYNAMIC_HASH_TABLE );
NTSYSAPI BOOLEAN        NTAPI RtlCreateHashTable( PRTL_DYNAMIC_HASH_TABLE, ULONG, ULONG );
NTSYSAPI VOID           NTAPI RtlDeleteHashTable( PRTL_DYNAMIC_HASH_TABLE );
NTSYSAPI VOID           NTAPI RtlEndEnumerationHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI VOID           NTAPI RtlEndWeakEnumerationHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI PRTL_DYNAMIC_HASH_TABLE_ENTRY NTAPI RtlEnumerateEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI BOOLEAN        NTAPI RtlExpandHashTable( PRTL_DYNAMIC_HASH_TABLE );
NTSYSAPI PRTL_DYNAMIC_HASH_TABLE_ENTRY NTAPI RtlGetNextEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_CONTEXT );
NTSYSAPI BOOLEAN        NTAPI RtlInitEnumerationHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI BOOLEAN        NTAPI RtlInitWeakEnumerationHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI BOOLEAN        NTAPI RtlInsertEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENTRY, ULONG_PTR, PRTL_DYNAMIC_HASH_TABLE_CONTEXT );
NTSYSAPI PRTL_DYNAMIC_HASH_TABLE_ENTRY NTAPI RtlLookupEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, ULONG_PTR, PRTL_DYNAMIC_HASH_TABLE_CONTEXT );
NTSYSAPI BOOLEAN        NTAPI RtlRemoveEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_CONTEXT );
NTSYSAPI PRTL_DYNAMIC_HASH_TABLE_ENTRY NTAPI RtlWeaklyEnumerateEntryHashTable( PRTL_DYNAMIC_HASH_TABLE, PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR );
NTSYSAPI NTSTATUS       NTAPI ZwSetTimerEx( HANDLE, TIMER_SET_INFORMATION_CLASS, PVOID, ULONG );
#endif

/* System call functions in NTDLL.DLL and NTOSKRNL.EXE */
NTSYSCALLAPI NTSTATUS   NTAPI NtOpenProcess( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PCLIENT_ID );
NTSYSCALLAPI NTSTATUS   NTAPI NtQueryInformationProcess( HANDLE, PROCESSINFOCLASS, PVOID, ULONG, PULONG );

/* Functions in NTOSKRNL.EXE */
NTKERNELAPI VOID        FASTCALL KeInvalidateRangeAllCaches( PVOID, ULONG );
#ifdef _X86_
NTKERNELAPI INTERLOCKED_RESULT FASTCALL Exfi386InterlockedDecrementLong( LONG volatile * );
NTKERNELAPI ULONG       FASTCALL Exfi386InterlockedExchangeUlong( ULONG volatile *, ULONG );
NTKERNELAPI INTERLOCKED_RESULT FASTCALL Exfi386InterlockedIncrementLong( LONG volatile * );
#endif
#if (NTDDI_VERSION >= 0x05000000)
NTKERNELAPI NTSTATUS    NTAPI ExExtendZone( PZONE_HEADER, PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI ExInitializeZone( PZONE_HEADER, ULONG, PVOID, ULONG );
NTKERNELAPI NTSTATUS    NTAPI ExInterlockedExtendZone( PZONE_HEADER, PVOID, ULONG, PKSPIN_LOCK );
NTKERNELAPI DECLSPEC_NORETURN VOID NTAPI ExRaiseAccessViolation( VOID );
NTKERNELAPI DECLSPEC_NORETURN VOID NTAPI ExRaiseDatatypeMisalignment( VOID );
NTKERNELAPI NTSTATUS    NTAPI ExUuidCreate( UUID * );
NTKERNELAPI BOOLEAN     NTAPI FsRtlIsTotalDeviceFailure( NTSTATUS );
NTKERNELAPI NTSTATUS    NTAPI IoAllocateAdapterChannel( PADAPTER_OBJECT, PDEVICE_OBJECT, ULONG, PDRIVER_CONTROL, PVOID );
NTKERNELAPI VOID        NTAPI IoAllocateController( PCONTROLLER_OBJECT, PDEVICE_OBJECT, PDRIVER_CONTROL, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoAssignResources( PUNICODE_STRING, PUNICODE_STRING, PDRIVER_OBJECT, PDEVICE_OBJECT, PIO_RESOURCE_REQUIREMENTS_LIST, PCM_RESOURCE_LIST * );
NTKERNELAPI NTSTATUS    NTAPI IoAttachDeviceByPointer( PDEVICE_OBJECT, PDEVICE_OBJECT );
NTKERNELAPI VOID        NTAPI IoCancelFileOpen( PDEVICE_OBJECT, PFILE_OBJECT );
NTKERNELAPI PCONTROLLER_OBJECT NTAPI IoCreateController( ULONG );
NTKERNELAPI VOID        NTAPI IoDeleteController( PCONTROLLER_OBJECT );
NTKERNELAPI VOID        NTAPI IoFreeController( PCONTROLLER_OBJECT );
NTKERNELAPI PCONFIGURATION_INFORMATION NTAPI IoGetConfigurationInformation( VOID );
NTKERNELAPI PDEVICE_OBJECT NTAPI IoGetDeviceToVerify( PETHREAD );
NTKERNELAPI PGENERIC_MAPPING NTAPI IoGetFileObjectGenericMapping( VOID );
NTKERNELAPI PIRP        NTAPI IoMakeAssociatedIrp( PIRP, CCHAR );
NTKERNELAPI NTSTATUS    NTAPI IoQueryDeviceDescription( PINTERFACE_TYPE, PULONG, PCONFIGURATION_TYPE, PULONG, PCONFIGURATION_TYPE, PULONG, PIO_QUERY_DEVICE_ROUTINE, PVOID );
NTKERNELAPI VOID        NTAPI IoRaiseHardError( PIRP, PVPB, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI IoRaiseInformationalHardError( NTSTATUS, PUNICODE_STRING, PKTHREAD );
NTKERNELAPI VOID        NTAPI IoRegisterBootDriverReinitialization( PDRIVER_OBJECT, PDRIVER_REINITIALIZE, PVOID );
NTKERNELAPI VOID        NTAPI IoRegisterDriverReinitialization( PDRIVER_OBJECT, PDRIVER_REINITIALIZE, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoReportDetectedDevice( PDRIVER_OBJECT, INTERFACE_TYPE, ULONG, ULONG, PCM_RESOURCE_LIST, PIO_RESOURCE_REQUIREMENTS_LIST, BOOLEAN, PDEVICE_OBJECT * );
NTKERNELAPI NTSTATUS    NTAPI IoReportResourceForDetection( PDRIVER_OBJECT, PCM_RESOURCE_LIST, ULONG, PDEVICE_OBJECT, PCM_RESOURCE_LIST, ULONG, PBOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoReportResourceUsage( PUNICODE_STRING, PDRIVER_OBJECT, PCM_RESOURCE_LIST, ULONG, PDEVICE_OBJECT, PCM_RESOURCE_LIST, ULONG, BOOLEAN, PBOOLEAN );
NTKERNELAPI VOID        NTAPI IoSetHardErrorOrVerifyDevice( PIRP, PDEVICE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI IoSetThreadHardErrorMode( BOOLEAN );
NTKERNELAPI DECLSPEC_NORETURN VOID NTAPI KeBugCheck( ULONG );
NTKERNELAPI LONG        NTAPI KePulseEvent( PRKEVENT, KPRIORITY, BOOLEAN );
NTKERNELAPI KAFFINITY   NTAPI KeQueryActiveProcessors( VOID );
NTKERNELAPI LONG        NTAPI KeSetBasePriorityThread( PKTHREAD, LONG );
NTKERNELAPI NTSTATUS    NTAPI MmAddPhysicalMemory( PPHYSICAL_ADDRESS, PLARGE_INTEGER );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemory( SIZE_T, PHYSICAL_ADDRESS );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemorySpecifyCache( SIZE_T, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, MEMORY_CACHING_TYPE );
NTKERNELAPI PVOID       NTAPI MmAllocateContiguousMemorySpecifyCacheNode( SIZE_T, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS, MEMORY_CACHING_TYPE, NODE_REQUIREMENT );
NTKERNELAPI PVOID       NTAPI MmAllocateNonCachedMemory( SIZE_T );
NTKERNELAPI VOID        NTAPI MmFreeContiguousMemory( PVOID );
NTKERNELAPI VOID        NTAPI MmFreeContiguousMemorySpecifyCache( PVOID, SIZE_T, MEMORY_CACHING_TYPE );
NTKERNELAPI VOID        NTAPI MmFreeNonCachedMemory( PVOID, SIZE_T );
NTKERNELAPI PHYSICAL_ADDRESS NTAPI MmGetPhysicalAddress( PVOID );
NTKERNELAPI PPHYSICAL_MEMORY_RANGE NTAPI MmGetPhysicalMemoryRanges( VOID );
NTKERNELAPI PVOID       NTAPI MmGetVirtualForPhysical( PHYSICAL_ADDRESS );
NTKERNELAPI BOOLEAN     NTAPI MmIsAddressValid( PVOID );
NTKERNELAPI BOOLEAN     NTAPI MmIsNonPagedSystemAddressValid( PVOID );
NTKERNELAPI BOOLEAN     NTAPI MmIsThisAnNtSystem( VOID );
NTKERNELAPI VOID        NTAPI MmLockPagableSectionByHandle( PVOID );
NTKERNELAPI NTSTATUS    NTAPI MmMapUserAddressesToPage( PVOID, SIZE_T, PVOID );
NTKERNELAPI PVOID       NTAPI MmMapVideoDisplay( PPHYSICAL_ADDRESS, SIZE_T, MEMORY_CACHING_TYPE );
NTKERNELAPI NTSTATUS    NTAPI MmMapViewInSessionSpace( PVOID, PVOID *, PSIZE_T );
NTKERNELAPI NTSTATUS    NTAPI MmMapViewInSystemSpace( PVOID, PVOID *, PSIZE_T );
NTKERNELAPI NTSTATUS    NTAPI MmRemovePhysicalMemory( PPHYSICAL_ADDRESS, PLARGE_INTEGER );
NTKERNELAPI HANDLE      NTAPI MmSecureVirtualMemory( PVOID, SIZE_T, ULONG );
NTKERNELAPI VOID        NTAPI MmUnmapVideoDisplay( PVOID, SIZE_T );
NTKERNELAPI NTSTATUS    NTAPI MmUnmapViewInSessionSpace( PVOID );
NTKERNELAPI NTSTATUS    NTAPI MmUnmapViewInSystemSpace( PVOID );
NTKERNELAPI VOID        NTAPI MmUnsecureVirtualMemory( HANDLE );
NTKERNELAPI HANDLE      NTAPI PsGetCurrentProcessId( VOID );
NTKERNELAPI HANDLE      NTAPI PsGetCurrentThreadId( VOID );
NTKERNELAPI BOOLEAN     NTAPI PsGetVersion( PULONG, PULONG, PULONG, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI PsSetCreateProcessNotifyRoutine( PCREATE_PROCESS_NOTIFY_ROUTINE, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI PsSetCreateThreadNotifyRoutine( PCREATE_THREAD_NOTIFY_ROUTINE );
NTKERNELAPI NTSTATUS    NTAPI PsSetLoadImageNotifyRoutine( PLOAD_IMAGE_NOTIFY_ROUTINE );
NTKERNELAPI BOOLEAN     NTAPI SeSinglePrivilegeCheck( LUID, KPROCESSOR_MODE );
#endif
#if (NTDDI_VERSION >= 0x05000300)
NTKERNELAPI BOOLEAN     NTAPI IoIsFileOriginRemote( PFILE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoSetFileOrigin( PFILE_OBJECT, BOOLEAN );
#endif
#if (NTDDI_VERSION >= 0x05010000)
NTKERNELAPI VOID        FASTCALL HalExamineMBR( PDEVICE_OBJECT, ULONG, ULONG, PVOID * );
NTKERNELAPI NTSTATUS    NTAPI IoAttachDeviceToDeviceStackSafe( PDEVICE_OBJECT, PDEVICE_OBJECT, PDEVICE_OBJECT * );
NTKERNELAPI NTSTATUS    NTAPI IoCreateDisk( PDEVICE_OBJECT, struct _CREATE_DISK * );
NTKERNELAPI NTSTATUS    NTAPI IoCreateFileSpecifyDeviceObjectHint( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, PLARGE_INTEGER, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG, CREATE_FILE_TYPE, PVOID, ULONG, PVOID );
NTKERNELAPI NTSTATUS    NTAPI IoReadDiskSignature( PDEVICE_OBJECT, ULONG, PDISK_SIGNATURE );
NTKERNELAPI NTSTATUS    FASTCALL IoReadPartitionTable( PDEVICE_OBJECT, ULONG, BOOLEAN, struct _DRIVE_LAYOUT_INFORMATION ** );
NTKERNELAPI NTSTATUS    NTAPI IoReadPartitionTableEx( PDEVICE_OBJECT, struct _DRIVE_LAYOUT_INFORMATION_EX ** );
NTKERNELAPI NTSTATUS    FASTCALL IoSetPartitionInformation( PDEVICE_OBJECT, ULONG, ULONG, ULONG );
NTKERNELAPI NTSTATUS    NTAPI IoSetPartitionInformationEx( PDEVICE_OBJECT, ULONG, struct _SET_PARTITION_INFORMATION_EX * );
NTKERNELAPI NTSTATUS    NTAPI IoSetSystemPartition( PUNICODE_STRING );
NTKERNELAPI NTSTATUS    NTAPI IoVerifyPartitionTable( PDEVICE_OBJECT, BOOLEAN );
NTKERNELAPI NTSTATUS    NTAPI IoVolumeDeviceToDosName( PVOID, PUNICODE_STRING );
NTKERNELAPI NTSTATUS    FASTCALL IoWritePartitionTable( PDEVICE_OBJECT, ULONG, ULONG, ULONG, struct _DRIVE_LAYOUT_INFORMATION * );
NTKERNELAPI NTSTATUS    NTAPI IoWritePartitionTableEx( PDEVICE_OBJECT, struct _DRIVE_LAYOUT_INFORMATION_EX * );
NTKERNELAPI LONGLONG    NTAPI PsGetProcessCreateTimeQuadPart( PEPROCESS );
NTKERNELAPI HANDLE      NTAPI PsGetProcessId( PEPROCESS );
NTKERNELAPI HANDLE      NTAPI PsGetThreadId( PETHREAD );
NTKERNELAPI NTSTATUS    NTAPI PsRemoveCreateThreadNotifyRoutine( PCREATE_THREAD_NOTIFY_ROUTINE );
NTKERNELAPI NTSTATUS    NTAPI PsRemoveLoadImageNotifyRoutine( PLOAD_IMAGE_NOTIFY_ROUTINE );
#endif
#if (NTDDI_VERSION >= 0x05020000)
NTKERNELAPI IO_PAGING_PRIORITY FASTCALL IoGetPagingIoPriority( PIRP );
NTKERNELAPI BOOLEAN     NTAPI KeInvalidateAllCaches( VOID );
NTKERNELAPI NTSTATUS    NTAPI MmCreateMirror( VOID );
NTKERNELAPI HANDLE      NTAPI PsGetThreadProcessId( PETHREAD );
#endif
#if (NTDDI_VERSION >= 0x05020100)
NTKERNELAPI BOOLEAN     NTAPI IoTranslateBusAddress( INTERFACE_TYPE, ULONG, PHYSICAL_ADDRESS, PULONG, PPHYSICAL_ADDRESS );
NTKERNELAPI NTSTATUS    NTAPI KeExpandKernelStackAndCallout( PEXPAND_STACK_CALLOUT, PVOID, SIZE_T );
#endif
#if (NTDDI_VERSION >= 0x06000000)
NTKERNELAPI VOID        NTAPI IoClearIrpExtraCreateParameter( PIRP );
NTKERNELAPI NTSTATUS    NTAPI IoCreateFileEx( PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES, PIO_STATUS_BLOCK, PLARGE_INTEGER, ULONG, ULONG, ULONG, ULONG, PVOID, ULONG, CREATE_FILE_TYPE, PVOID, ULONG, PIO_DRIVER_CREATE_CONTEXT );
NTKERNELAPI NTSTATUS    NTAPI IoGetIrpExtraCreateParameter( PIRP, struct _ECP_LIST ** );
NTKERNELAPI PTXN_PARAMETER_BLOCK NTAPI IoGetTransactionParameterBlock( PFILE_OBJECT );
NTKERNELAPI BOOLEAN     NTAPI IoIsFileObjectIgnoringSharing( PFILE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI IoSetIrpExtraCreateParameter( PIRP, struct _ECP_LIST * );
NTKERNELAPI NTSTATUS    NTAPI MmRotatePhysicalView( PVOID, PSIZE_T, PMDLX, MM_ROTATE_DIRECTION, PMM_ROTATE_COPY_CALLBACK_FUNCTION, PVOID );
NTKERNELAPI BOOLEAN     NTAPI PsIsCurrentThreadPrefetching( VOID );
NTKERNELAPI BOOLEAN     NTAPI PsSetCurrentThreadPrefetching( BOOLEAN );
#endif
#if (NTDDI_VERSION >= 0x06000100)
NTKERNELAPI NTSTATUS    NTAPI PsSetCreateProcessNotifyRoutineEx( PCREATE_PROCESS_NOTIFY_ROUTINE_EX, BOOLEAN );
#endif
#if (NTDDI_VERSION >= 0x06010000)
NTKERNELAPI NTSTATUS    NTAPI IoSetFileObjectIgnoreSharing( PFILE_OBJECT );
NTKERNELAPI NTSTATUS    NTAPI KeQueryHardwareCounterConfiguration( PHARDWARE_COUNTER, ULONG, PULONG );
NTKERNELAPI NTSTATUS    NTAPI KeSetHardwareCounterConfiguration( PHARDWARE_COUNTER, ULONG );
#endif

/* Functions in HAL.DLL */
NTHALAPI NTSTATUS       NTAPI HalAllocateHardwareCounters( PGROUP_AFFINITY, ULONG, PPHYSICAL_COUNTER_RESOURCE_LIST, PHANDLE );
NTHALAPI NTSTATUS       NTAPI HalFreeHardwareCounters( HANDLE );
#if (NTDDI_VERSION >= 0x05000000)
NTHALAPI VOID           NTAPI HalAcquireDisplayOwnership( PHAL_RESET_DISPLAY_PARAMETERS );
NTHALAPI NTSTATUS       NTAPI HalAllocateAdapterChannel( PADAPTER_OBJECT, PWAIT_CONTEXT_BLOCK, ULONG, PDRIVER_CONTROL );
NTHALAPI PVOID          NTAPI HalAllocateCommonBuffer( PADAPTER_OBJECT, ULONG, PPHYSICAL_ADDRESS, BOOLEAN );
NTHALAPI PVOID          NTAPI HalAllocateCrashDumpRegisters( PADAPTER_OBJECT, PULONG );
NTHALAPI NTSTATUS       NTAPI HalAssignSlotResources( PUNICODE_STRING, PUNICODE_STRING, PDRIVER_OBJECT, PDEVICE_OBJECT, INTERFACE_TYPE, ULONG, ULONG, PCM_RESOURCE_LIST * );
NTHALAPI VOID           NTAPI HalFreeCommonBuffer( PADAPTER_OBJECT, ULONG, PHYSICAL_ADDRESS, PVOID, BOOLEAN );
NTHALAPI PADAPTER_OBJECT NTAPI HalGetAdapter( PDEVICE_DESCRIPTION, PULONG );
NTHALAPI ULONG          NTAPI HalGetBusData( BUS_DATA_TYPE, ULONG, ULONG, PVOID, ULONG );
NTHALAPI ULONG          NTAPI HalGetBusDataByOffset( BUS_DATA_TYPE, ULONG, ULONG, PVOID, ULONG, ULONG );
NTHALAPI ULONG          NTAPI HalGetInterruptVector( INTERFACE_TYPE, ULONG, ULONG, ULONG, PKIRQL, PKAFFINITY );
NTHALAPI BOOLEAN        NTAPI HalMakeBeep( ULONG );
NTHALAPI ULONG          NTAPI HalReadDmaCounter( PADAPTER_OBJECT );
NTHALAPI ULONG          NTAPI HalSetBusData( BUS_DATA_TYPE, ULONG, ULONG, PVOID, ULONG );
NTHALAPI ULONG          NTAPI HalSetBusDataByOffset( BUS_DATA_TYPE, ULONG, ULONG, PVOID, ULONG, ULONG );
NTHALAPI BOOLEAN        NTAPI HalTranslateBusAddress( INTERFACE_TYPE, ULONG, PHYSICAL_ADDRESS, PULONG, PPHYSICAL_ADDRESS );
NTHALAPI BOOLEAN        NTAPI IoFlushAdapterBuffers( PADAPTER_OBJECT, PMDL, PVOID, PVOID, ULONG, BOOLEAN );
NTHALAPI VOID           NTAPI IoFreeAdapterChannel( PADAPTER_OBJECT );
NTHALAPI VOID           NTAPI IoFreeMapRegisters( PADAPTER_OBJECT, PVOID, ULONG );
NTHALAPI PHYSICAL_ADDRESS NTAPI IoMapTransfer( PADAPTER_OBJECT, PMDL, PVOID, PVOID, PULONG, BOOLEAN );
#ifdef _X86_
NTHALAPI KIRQL          NTAPI KeRaiseIrqlToSynchLevel( VOID );
#endif
#endif

/* Functions in HAL.DLL that are defined differently on different versions
 * of Windows.
 */
#if (NTDDI_VERSION >= 0x06010000)
NTHALAPI VOID           NTAPI HalBugCheckSystem( PWHEA_ERROR_SOURCE_DESCRIPTOR, PWHEA_ERROR_RECORD );
#else
NTHALAPI VOID           NTAPI HalBugCheckSystem( PWHEA_ERROR_RECORD );
#endif

/* Functions in PSHED.DLL */
PVOID                   NTAPI PshedAllocateMemory( ULONG );
VOID                    NTAPI PshedFreeMemory( PVOID );
BOOLEAN                 NTAPI PshedIsSystemWheaEnabled( VOID );
NTSTATUS                NTAPI PshedRegisterPlugin( PWHEA_PSHED_PLUGIN_REGISTRATION_PACKET );
BOOLEAN                 NTAPI PshedSynchronizeExecution( PWHEA_ERROR_SOURCE_DESCRIPTOR, PKSYNCHRONIZE_ROUTINE, PVOID );

#ifdef _X86_
/* Functions implemented with inline assembly code */
extern PKPCR            KeGetCurrentKPCR( void );
#pragma aux KeGetCurrentKPCR = \
        "mov eax, fs:[0x18]" \
    __parm              [] \
    __value             [__eax] \
    __modify __exact    [__eax]
#endif

/* Functions implemented as macros */
#define RtlInitializeSplayLinks( x ) \
    { \
        PRTL_SPLAY_LINKS    v; \
        v = (PRTL_SPLAY_LINKS)(x); \
        v->Parent = v; \
        v->LeftChild = NULL; \
        v->RightChild = NULL; \
    }
#define RtlParent( x )                  ((PRTL_SPLAY_LINKS)(x)->Parent)
#define RtlLeftChild( x )               ((PRTL_SPLAY_LINKS)(x)->LeftChild)
#define RtlRightChild( x )              ((PRTL_SPLAY_LINKS)(x)->RightChild)
#define RtlIsRoot( x )                  (RtlParent( x ) == (PRTL_SPLAY_LINKS)(x))
#define RtlIsLeftChild( x ) \
    (RtlLeftChild( RtlParent( x ) ) == (PRTL_SPLAY_LINKS)(x))
#define RtlIsRightChild( x ) \
    (RtlRightChild( RtlParent( x ) ) == (PRTL_SPLAY_LINKS)(x))
#define RtlInsertAsLeftChild( x, p ) \
    { \
        PRTL_SPLAY_LINKS    v1; \
        PRTL_SPLAY_LINKS    v2; \
        v1 = (PRTL_SPLAY_LINKS)(x); \
        v2 = (PRTL_SPLAY_LINKS)(p); \
        v1->LeftChild = v2; \
        v2->Parent = v1; \
    }
#define RtlInsertAsRightChild( x, p ) \
    { \
        PRTL_SPLAY_LINKS    v1; \
        PRTL_SPLAY_LINKS    v2; \
        v1 = (PRTL_SPLAY_LINKS)(x); \
        v2 = (PRTL_SPLAY_LINKS)(p); \
        v1->RightChild = v2; \
        v2->Parent = v1; \
    }
#define ExFreeToZone( x, p ) \
    (((PSINGLE_LIST_ENTRY)(p))->Next = (x)->FreeList.Next, \
    (x)->FreeList.Next = ((PSINGLE_LIST_ENTRY)(p)), \
    ((PSINGLE_LIST_ENTRY)(p))->Next)
#define ExIsFullZone( x ) \
    ((x)->FreeList.Next == NULL)
#define ExInterlockedAllocateFromZone( x, p ) \
    (PVOID)ExInterlockedPopEntryList( &(x)->FreeList, p )
#define ExInterlockedFreeToZone( x, p1, p2 ) \
    ExInterlockedPushEntryList( &(x)->FreeList, (PSINGLE_LIST_ENTRY)(p1), p2 )
#define ExIsObjectInFirstZoneSegment( x, p ) \
    ((BOOLEAN)(((PUCHAR)(p) >= (PUCHAR)(x)->SegmentList.Next) && \
    ((PUCHAR)(p) < (PUCHAR)(x)->SegmentList.Next + (x)->TotalSegmentSize))
#define IoAssignArcName( p1, p2 )           IoCreateSymbolicLink( p1, p2 )
#define IoDeassignArcName( x )              IoDeleteSymbolicLink( x )
#define WheaIsPreviousError( x ) \
    ((x)->Header.Flags & WHEA_ERROR_RECORD_FLAGS_PREVIOUSERROR)
#ifdef _X86_
    #define KeGetCurrentProcessorNumber()   ((ULONG)KeGetCurrentKPCR()->Number)
    #define HalGetDmaAlignmentRequirement() 1L
#endif

/* Aliases */
#ifdef RTL_USE_AVL_TABLES
    #define RtlInitializeGenericTable               RtlInitializeGenericTableAvl
    #define RtlInsertElementGenericTable            RtlInsertElementGenericTableAvl
    #define RtlInsertElementGenericTableFull        RtlInsertElementGenericTableFullAvl
    #define RtlDeleteElementGenericTable            RtlDeleteElementGenericTableAvl
    #define RtlLookupElementGenericTable            RtlLookupElementGenericTableAvl
    #define RtlLookupElementGenericTableFull        RtlLookupElementGenericTableFullAvl
    #define RtlEnumerateGenericTable                RtlEnumerateGenericTableAvl
    #define RtlEnumerateGenericTableWithoutSplaying RtlEnumerateGenericTableWithoutSplayingAvl
    #define RtlGetElementGenericTable               RtlGetElementGenericTableAvl
    #define RtlNumberGenericTableElements           RtlNumberGenericTableElementsAvl
    #define RtlIsGenericTableEmpty                  RtlIsGenericTableEmptyAvl
#endif
#define ExInitializeResource            ExInitializeResourceLite
#define ExAcquireResourceShared         ExAcquireResourceSharedLite
#define ExAcquireResourceExclusive      ExAcquireResourceExclusiveLite
#define ExReleaseResourceForThread      ExReleaseResourceForThreadLite
#define ExConvertExclusiveToShared      ExConvertExclusiveToSharedLite
#define ExDeleteResource                ExDeleteResourceLite
#define ExIsResourceAcquiredExclusive   ExIsResourceAcquiredExclusiveLite
#define ExIsResourceAcquiredShared      ExIsResourceAcquiredSharedLite
#define ExIsResourceAcquired            ExIsResourceAcquiredSharedLite

/* Other macros */
#define VER_SET_CONDITION( p1, p2, p3 ) \
    ((p1) = VerSetConditionMask( p1, p2, p3 ))
#define HALDISPATCH                     HalDispatchTable
#define HalDispatchTableVersion         HALDISPATCH->Version
#define HalQuerySystemInformation       HALDISPATCH->HalQuerySystemInformation
#define HalSetSystemInformation         HALDISPATCH->HalSetSystemInformation
#define HalQueryBusSlots                HALDISPATCH->HalQueryBusSlots
#define HalReferenceHandlerForBus       HALDISPATCH->HalReferenceHandlerForBus
#define HalReferenceBusHandler          HALDISPATCH->HalReferenceBusHandler
#define HalDereferenceBusHandler        HALDISPATCH->HalDereferenceBusHandler
#define HalInitPnpDriver                HALDISPATCH->HalInitPnpDriver
#define HalInitPowerManagement          HALDISPATCH->HalInitPowerManagement
#define HalGetDmaAdapter                HALDISPATCH->HalGetDmaAdapter
#define HalGetInterruptTranslator       HALDISPATCH->HalGetInterruptTranslator
#define HalStartMirroring               HALDISPATCH->HalStartMirroring
#define HalEndMirroring                 HALDISPATCH->HalEndMirroring
#define HalMirrorPhysicalMemory         HALDISPATCH->HalMirrorPhysicalMemory
#define HalEndOfBoot                    HALDISPATCH->HalEndOfBoot
#define HalMirrorVerify                 HALDISPATCH->HalMirrorVerify
#define HalGetCachedAcpiTable           HALDISPATCH->HalGetCachedAcpiTable
#define HalSetPciErrorHandlerCallback   HALDISPATCH->HalSetPciErrorHandlerCallback
#ifdef _X86_
    #define MM_HIGHEST_USER_ADDRESS     MmHighestUserAddress
    #define MM_SYSTEM_RANGE_START       MmSystemRangeStart
    #define MM_USER_PROBE_ADDRESS       MmUserProbeAddress
    #define MM_KSEG0_BASE               MM_SYSTEM_RANGE_START
#endif

__inline LUID RtlConvertLongToLuid( LONG x )
{
    LARGE_INTEGER   v1;
    LUID            v2;
    v1.QuadPart = x;
    v2.LowPart = v1.LowPart;
    v2.HighPart = v1.HighPart;
    return( v2 );
}

__inline LUID RtlConvertUlongToLuid( ULONG x )
{
    LUID    v;
    v.LowPart = x;
    v.HighPart = 0;
    return( v );
}

__inline PVOID ExAllocateFromZone( PZONE_HEADER x )
{
    PVOID   v;
    v = (PVOID)(x->FreeList.Next);
    if( x->FreeList.Next ) {
        x->FreeList.Next = x->FreeList.Next->Next;
    }
    return( v );
}

__inline VOID IoInitializeDriverCreateContext( PIO_DRIVER_CREATE_CONTEXT x )
{
    RtlZeroMemory( x, sizeof( IO_DRIVER_CREATE_CONTEXT ) );
    x->Size = sizeof( IO_DRIVER_CREATE_CONTEXT );
}

#if (NTDDI_VERSION >= 0x06010000)

__inline VOID RtlInitHashTableContext( PRTL_DYNAMIC_HASH_TABLE_CONTEXT x )
{
    x->ChainHead = NULL;
    x->PrevLinkage = NULL;
}

__inline VOID RtlInitHashTableContextFromEnumerator( PRTL_DYNAMIC_HASH_TABLE_CONTEXT x,
                                                     PRTL_DYNAMIC_HASH_TABLE_ENUMERATOR p )
{
    x->ChainHead = p->ChainHead;
    x->PrevLinkage = p->HashEntry.Linkage.Blink;
}

__inline void RtlReleaseHashTableContext( PRTL_DYNAMIC_HASH_TABLE_CONTEXT x )
{
    x = x;
}

__inline ULONG RtlTotalBucketsHashTable( PRTL_DYNAMIC_HASH_TABLE x )
{
    return( x->TableSize );
}

__inline ULONG RtlNonEmptyBucketsHashTable( PRTL_DYNAMIC_HASH_TABLE x )
{
    return( x->NonEmptyBuckets );
}

__inline ULONG RtlEmptyBucketsHashTable( PRTL_DYNAMIC_HASH_TABLE x )
{
    return( x->TableSize - x->NonEmptyBuckets );
}

__inline ULONG RtlTotalEntriesHashTable( PRTL_DYNAMIC_HASH_TABLE x )
{
    return( x->NumEntries );
}

__inline ULONG RtlActiveEnumeratorsHashTable( PRTL_DYNAMIC_HASH_TABLE x )
{
    return( x->NumEnumerators );
}

#endif /* (NTDDI_VERSION >= 0x06010000) */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDDK_ */
