/*
 *  d3dtypes.h  Direct3D data types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _D3DTYPES_H_
#define _D3DTYPES_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <ddraw.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Direct3D version number */
#ifndef DIRECT3D_VERSION
    #define DIRECT3D_VERSION    0x0700
#endif

#ifndef DX_SHARED_DEFINES
#define DX_SHARED_DEFINES

/* Direct3D color data type */
#ifndef D3DCOLOR_DEFINED
#define D3DCOLOR_DEFINED
typedef DWORD   D3DCOLOR;
#endif

/* DirectX shared primitive data types */
typedef float   D3DVALUE;
typedef float   *LPD3DVALUE;
typedef DWORD   *LPD3DCOLOR;

/* Direct3D vectors */
typedef struct _D3DVECTOR {
    union {
        D3DVALUE    x;
        D3DVALUE    dvX;
    };
    union {
        D3DVALUE    y;
        D3DVALUE    dvY;
    };
    union {
        D3DVALUE    z;
        D3DVALUE    dvZ;
    };
} D3DVECTOR;
typedef D3DVECTOR   *LPD3DVECTOR;

#endif /* DX_SHARED_DEFINES */

/* Direct3D primitive data types */
typedef LONG    D3DFIXED;
typedef DWORD   D3DMATERIALHANDLE;
typedef DWORD   *LPD3DMATERIALHANDLE;
typedef DWORD   D3DTEXTUREHANDLE;
typedef DWORD   *LPD3DTEXTUREHANDLE;
typedef DWORD   D3DMATRIXHANDLE;
typedef DWORD   *LPD3DMATRIXHANDLE;
#if (DIRECT3D_VERSION >= 0x0500)
typedef DWORD   D3DCOLORMODEL;
#endif

/* Macros to manipulate Direct3D values */
#define D3DVALP( p1, p2 )   ((float)(p1))
#define D3DVAL( x )         ((float)(x))

/* Direct3D value arithmetic */
#define D3DDivide( p1, p2 )     (float)((double)(p1) / (double)(p2))
#define D3DMultiply( p1, p2 )   ((p1) * (p2))

/* Macros to manipulate color indices */
#define CI_GETALPHA( x )        ((x) >> 24)
#define CI_GETINDEX( x )        (((x) >> 8) & 0x0000FFFFL)
#define CI_GETFRACTION( x )     ((x) & 0x000000FFL)
#define CI_ROUNDINDEX( x )      CI_GETINDEX((x) + 0x00000080L)
#define CI_MASKALPHA( x )       ((x) & 0x00FFFFFFL)
#define CI_MAKE( p1, p2, p3 )   (((p1) << 24) | ((p2) << 8) | (p3))

/* Macros to manipulate RGBA colors */
#define RGBA_GETALPHA( x )      ((x) >> 24)
#define RGBA_GETRED( x )        (((x) >> 16) & 0x000000FFL)
#define RGBA_GETGREEN( x )      (((x) >> 8) & 0x000000FFL)
#define RGBA_GETBLUE( x )       ((x) & 0x000000FFL)
#define RGBA_MAKE( p1, p2, p3, p4 ) \
    ((D3DCOLOR)(((p4) << 24) | ((p1) << 16) | ((p2) << 8) | (p3)))
#define RGBA_SETALPHA( p1, p2 ) (((p1) << 24) | ((p2) & 0x00FFFFFFL))
#define RGBA_TORGB( x )         ((D3DCOLOR)((x) & 0x00FFFFFFL))

/* Macros to make Direct3D colors */
#define D3DRGB( p1, p2, p3 ) \
    (0xFF000000L | ((long)((p1) * 255) << 16) | \
    ((long)((p2) * 255) << 8) | (long)((p3) * 255))
#define D3DRGBA( p1, p2, p3, p4) \
    (((long)((p4) * 255) << 24) | \
     ((long)((p1) * 255) << 16) | \
     ((long)((p2) * 255) << 8) | \
      (long)((p3) * 255))

/* Macros to manipulate RGB colors */
#define RGB_GETRED( x )         (((x) >> 16) & 0x000000FFL)
#define RGB_GETGREEN( x )       (((x) >> 8) & 0x000000FFL)
#define RGB_GETBLUE( x )        ((x) & 0x000000FFL)
#define RGB_MAKE( p1, p2, p3 )  ((D3DCOLOR)(((p1) << 16) | ((p2) << 8) | (p3)))
#define RGB_TORGBA( x )         ((D3DCOLOR)((x) | 0xFF000000L))

/* Direct3D enumeration return flags */
#define D3DENUMRET_CANCEL   DDENUMRET_CANCEL
#define D3DENUMRET_OK       DDENUMRET_OK

/* Maximum number of clip planes */
#if (DIRECT3D_VERSION >= 0x0700)
    #define D3DMAXUSERCLIPPLANES    32
#endif

/* Direct3D clip plane flags */
#if (DIRECT3D_VERSION >= 0x0700)
    #define D3DCLIPPLANE0   (1 << 0)
    #define D3DCLIPPLANE1   (1 << 1)
    #define D3DCLIPPLANE2   (1 << 2)
    #define D3DCLIPPLANE3   (1 << 3)
    #define D3DCLIPPLANE4   (1 << 4)
    #define D3DCLIPPLANE5   (1 << 5)
#endif

/* Direct3D clip flags */
#define D3DCLIP_LEFT    0x00000001L
#define D3DCLIP_RIGHT   0x00000002L
#define D3DCLIP_TOP     0x00000004L
#define D3DCLIP_BOTTOM  0x00000008L
#define D3DCLIP_FRONT   0x00000010L
#define D3DCLIP_BACK    0x00000020L
#define D3DCLIP_GEN0    0x00000040L
#define D3DCLIP_GEN1    0x00000080L
#define D3DCLIP_GEN2    0x00000100L
#define D3DCLIP_GEN3    0x00000200L
#define D3DCLIP_GEN4    0x00000400L
#define D3DCLIP_GEN5    0x00000800L

/* Direct3D status flags */
#define D3DSTATUS_CLIPUNIONLEFT             D3DCLIP_LEFT
#define D3DSTATUS_CLIPUNIONRIGHT            D3DCLIP_RIGHT
#define D3DSTATUS_CLIPUNIONTOP              D3DCLIP_TOP
#define D3DSTATUS_CLIPUNIONBOTTOM           D3DCLIP_BOTTOM
#define D3DSTATUS_CLIPUNIONFRONT            D3DCLIP_FRONT
#define D3DSTATUS_CLIPUNIONBACK             D3DCLIP_BACK
#define D3DSTATUS_CLIPUNIONGEN0             D3DCLIP_GEN0
#define D3DSTATUS_CLIPUNIONGEN1             D3DCLIP_GEN1
#define D3DSTATUS_CLIPUNIONGEN2             D3DCLIP_GEN2
#define D3DSTATUS_CLIPUNIONGEN3             D3DCLIP_GEN3
#define D3DSTATUS_CLIPUNIONGEN4             D3DCLIP_GEN4
#define D3DSTATUS_CLIPUNIONGEN5             D3DCLIP_GEN5
#define D3DSTATUS_CLIPINTERSECTIONLEFT      0x00001000L
#define D3DSTATUS_CLIPINTERSECTIONRIGHT     0x00002000L
#define D3DSTATUS_CLIPINTERSECTIONTOP       0x00004000L
#define D3DSTATUS_CLIPINTERSECTIONBOTTOM    0x00008000L
#define D3DSTATUS_CLIPINTERSECTIONFRONT     0x00010000L
#define D3DSTATUS_CLIPINTERSECTIONBACK      0x00020000L
#define D3DSTATUS_CLIPINTERSECTIONGEN0      0x00040000L
#define D3DSTATUS_CLIPINTERSECTIONGEN1      0x00080000L
#define D3DSTATUS_CLIPINTERSECTIONGEN2      0x00100000L
#define D3DSTATUS_CLIPINTERSECTIONGEN3      0x00200000L
#define D3DSTATUS_CLIPINTERSECTIONGEN4      0x00400000L
#define D3DSTATUS_CLIPINTERSECTIONGEN5      0x00800000L
#define D3DSTATUS_ZNOTVISIBLE               0x01000000L
#define D3DSTATUS_CLIPUNIONALL \
    (D3DSTATUS_CLIPUNIONLEFT | D3DSTATUS_CLIPUNIONRIGHT | D3DSTATUS_CLIPUNIONTOP | \
    D3DSTATUS_CLIPUNIONBOTTOM | D3DSTATUS_CLIPUNIONFRONT | D3DSTATUS_CLIPUNIONBACK | \
    D3DSTATUS_CLIPUNIONGEN0 | D3DSTATUS_CLIPUNIONGEN1 | D3DSTATUS_CLIPUNIONGEN2 | \
    D3DSTATUS_CLIPUNIONGEN3 | D3DSTATUS_CLIPUNIONGEN4 | D3DSTATUS_CLIPUNIONGEN5)
#define D3DSTATUS_CLIPINTERSECTIONALL \
    (D3DSTATUS_CLIPINTERSECTIONLEFT | D3DSTATUS_CLIPINTERSECTIONRIGHT | \
    D3DSTATUS_CLIPINTERSECTIONTOP | D3DSTATUS_CLIPINTERSECTIONBOTTOM | \
    D3DSTATUS_CLIPINTERSECTIONFRONT | D3DSTATUS_CLIPINTERSECTIONBACK | \
    D3DSTATUS_CLIPINTERSECTIONGEN0 | D3DSTATUS_CLIPINTERSECTIONGEN1 | \
    D3DSTATUS_CLIPINTERSECTIONGEN2 | D3DSTATUS_CLIPINTERSECTIONGEN3 | \
    D3DSTATUS_CLIPINTERSECTIONGEN4 | D3DSTATUS_CLIPINTERSECTIONGEN5)
#define D3DSTATUS_DEFAULT \
    (D3DSTATUS_CLIPINTERSECTIONALL | D3DSTATUS_ZNOTVISIBLE)

/* Direct3D transform flags */
#define D3DTRANSFORM_CLIPPED    0x00000001L
#define D3DTRANSFORM_UNCLIPPED  0x00000002L

/* Direct3D light flags */
#if (DIRECT3D_VERSION >= 0x0500)
    #define D3DLIGHT_ACTIVE         0x00000001L
    #define D3DLIGHT_NO_SPECULAR    0x00000002L
    #define D3DLIGHT_ALL            (D3DLIGHT_ACTIVE | D3DLIGH_NO_SPECULAR)
#endif

/* Direct3D color model flags */
#if (DIRECT3D_VERSION >= 0x0500)
    #define D3DCOLOR_MONO   1L
    #define D3DCOLOR_RGB    2L
#endif

/* Direct3D clear flags */
#define D3DCLEAR_TARGET         0x00000001L
#define D3DCLEAR_ZBUFFER        0x00000002L
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DCLEAR_STENCIL    0x00000004L
#endif

/* Direct3D state override bias */
#define D3DSTATE_OVERRIDE_BIAS  256

/* Direct3D wrap flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DWRAP_U   0x00000001L
    #define D3DWRAP_V   0x00000002L
#endif

/* Direct3D wrap coordinates */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DWRAPCOORD_0  0x00000001L
    #define D3DWRAPCOORD_1  0x00000002L
    #define D3DWRAPCOORD_2  0x00000004L
    #define D3DWRAPCOORD_3  0x00000008L
#endif

/* Direct3D process vertices flags */
#define D3DPROCESSVERTICES_TRANSFORMLIGHT   0x00000000L
#define D3DPROCESSVERTICES_TRANSFORM        0x00000001L
#define D3DPROCESSVERTICES_COPY             0x00000002L
#define D3DPROCESSVERTICES_OPMASK           0x00000007L
#define D3DPROCESSVERTICES_UPDATEEXTENTS    0x00000008L
#define D3DPROCESSVERTICES_NOCOLOR          0x00000010L

/* Texture coordinate index flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DTSS_TCI_PASSTHRU                     0x00000000L
    #define D3DTSS_TCI_CAMERASPACENORMAL            0x00010000L
    #define D3DTSS_TCI_CAMERASPACEPOSITION          0x00020000L
    #define D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR  0x00030000L
#endif

/* Direct3D texture argument flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DTA_SELECTMASK        0x0000000FL
    #define D3DTA_DIFFUSE           0x00000000L
    #define D3DTA_CURRENT           0x00000001L
    #define D3DTA_TEXTURE           0x00000002L
    #define D3DTA_TFACTOR           0x00000003L
#endif
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DTA_SPECULAR          0x00000004L
#endif
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DTA_COMPLEMENT        0x00000010L
    #define D3DTA_ALPHAREPLICATE    0x00000020L
#endif

/* Direct3D triangle flags */
#define D3DTRIFLAG_START            0x00000000L
#define D3DTRIFLAG_STARTFLAT( x )   (x)
#define D3DTRIFLAG_ODD              0x0000001EL
#define D3DTRIFLAG_EVEN             0x0000001FL
#define D3DTRIFLAG_EDGEENABLE1      0x00000100L
#define D3DTRIFLAG_EDGEENABLE2      0x00000200L
#define D3DTRIFLAG_EDGEENABLE3      0x00000400L
#define D3DTRIFLAG_EDGEENABLETRIANGLE \
    (D3DTRIFLAG_EDGEENABLE1 | D3DTRIFLAG_EDGEENABLE2 | D3DTRIFLAG_EDGEENABLE3)

/* Direct3D status flags */
#define D3DSETSTATUS_STATUS     0x00000001L
#define D3DSETSTATUS_EXTENTS    0x00000002L
#define D3DSETSTATUS_ALL        (D3DSETSTATUS_STATUS | D3DSETSTATUS_EXTENTS)

/* Direct3D clip status flags */
#if (DIRECT3D_VERSION >= 0x0500)
    #define D3DCLIPSTATUS_STATUS    0x00000001L
    #define D3DCLIPSTATUS_EXTENTS2  0x00000002L
    #define D3DCLIPSTATUS_EXTENTS3  0x00000004L
#endif

/* Direct3D execute options */
#define D3DEXECUTE_CLIPPED      0x00000001L
#define D3DEXECUTE_UNCLIPPED    0x00000002L

/* Direct3D palette entry flags */
#define D3DPAL_FREE     0x00
#define D3DPAL_READONLY 0x40
#define D3DPAL_RESERVED 0x80

/* Direct3D vertex buffer capabilities */
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DVBCAPS_SYSTEMMEMORY  0x00000800L
    #define D3DVBCAPS_WRITEONLY     0x00010000L
    #define D3DVBCAPS_OPTIMIZED     0x80000000L
    #define D3DVBCAPS_DONOTCLIP     0x00000001L
#endif

/* Direct3D vertex operations */
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DVOP_LIGHT        (1 << 10)
    #define D3DVOP_TRANSFORM    (1 << 0)
    #define D3DVOP_CLIP         (1 << 2)
    #define D3DVOP_EXTENTS      (1 << 3)
#endif

/* Direct3D maximum numbers */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DMAXNUMVERTICES   ((1 << 16) - 1)
    #define D3DMAXNUMPRIMITIVES ((1 << 16) - 1)
#endif

/* Direct3D process vertices flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DPV_NONOTCOPYDATA (1 << 0)
#endif

/* Direct3D flexible vertex format flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DFVF_RESERVED0        0x0001
    #define D3DFVF_POSITION_MASK    0x000E
    #define D3DFVF_XYZ              0x0002
    #define D3DFVF_XYZRHW           0x0004
#endif
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DFVF_XYZB1            0x0006
    #define D3DFVF_XYZB2            0x0008
    #define D3DFVF_XYZB3            0x000A
    #define D3DFVF_XYZB4            0x000C
    #define D3DFVF_XYZB5            0x000E
#endif
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DFVF_NORMAL           0x0010
#endif
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DFVF_RESERVED1        0x0020
#endif
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
    #define D3DFVF_DIFFUSE          0x0040
    #define D3DFVF_SPECULAR         0x0080
    #define D3DFVF_TEXCOUNT_MASK    0x0F00
    #define D3DFVF_TEXCOUNT_SHIFT   8
    #define D3DFVF_TEX0             0x0000
    #define D3DFVF_TEX1             0x0100
    #define D3DFVF_TEX2             0x0200
    #define D3DFVF_TEX3             0x0300
    #define D3DFVF_TEX4             0x0400
    #define D3DFVF_TEX5             0x0500
    #define D3DFVF_TEX6             0x0600
    #define D3DFVF_TEX7             0x0700
    #define D3DFVF_TEX8             0x0800
    #define D3DFVF_RESERVED2        0xF000
#endif
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DFVF_VERTEX           (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1)
    #define D3DFVF_LVERTEX \
        (D3DFVF_XYZ | D3DFVF_RESERVED1 | D3DFVF_DIFFUSE | D3DFVF_SPECULAR | D3DVFX_TEX1)
    #define D3DFVF_TLVERTEX \
        (D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_SPECULAR | D3DFVF_TEX1)
#endif

/* Direct3D maximum texture coordinate */
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DDP_MAXTEXCOORD   8
#endif

/* Direct3D visibility values */
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DVIS_INSIDE_FRUSTUM       0
    #define D3DVIS_INTERSECT_FRUSTUM    1
    #define D3DVIS_OUTSIDE_FRUSTUM      2
    #define D3DVIS_INSIDE_LEFT          (0 << 2)
    #define D3DVIS_INTERSECT_LEFT       (1 << 2)
    #define D3DVIS_OUTSIDE_LEFT         (2 << 2)
    #define D3DVIS_INSIDE_RIGHT         (0 << 4)
    #define D3DVIS_INTERSECT_RIGHT      (1 << 4)
    #define D3DVIS_OUTSIDE_RIGHT        (2 << 4)
    #define D3DVIS_INSIDE_TOP           (0 << 6)
    #define D3DVIS_INTERSECT_TOP        (1 << 6)
    #define D3DVIS_OUTSIDE_TOP          (2 << 6)
    #define D3DVIS_INSIDE_BOTTOM        (0 << 8)
    #define D3DVIS_INTERSECT_BOTTOM     (1 << 8)
    #define D3DVIS_OUTSIDE_BOTTOM       (2 << 8)
    #define D3DVIS_INSIDE_NEAR          (0 << 10)
    #define D3DVIS_INTERSECT_NEAR       (1 << 10)
    #define D3DVIS_OUTSIDE_NEAR         (2 << 10)
    #define D3DVIS_INSIDE_FAR           (0 << 12)
    #define D3DVIS_INTERSECT_FAR        (1 << 12)
    #define D3DVIS_OUTSIDE_FAR          (2 << 12)
    #define D3DVIS_MASK_FRUSTUM         (3 << 0)
    #define D3DVIS_MASK_LEFT            (3 << 2)
    #define D3DVIS_MASK_RIGHT           (3 << 4)
    #define D3DVIS_MASK_TOP             (3 << 6)
    #define D3DVIS_MASK_BOTTOM          (3 << 8)
    #define D3DVIS_MASK_NEAR            (3 << 10)
    #define D3DVIS_MASK_FAR             (3 << 12)
#endif

/* Direct3D device information identifiers */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DDEVINFOID_TEXTUREMANAGER     1
    #define D3DDEVINFOID_D3DTEXTUREMANAGER  2
    #define D3DDEVINFOID_TEXTURING          3
#endif

/* Direct3D texture formats */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
    #define D3DFVF_TEXTUREFORMAT2       0
    #define D3DFVF_TEXTUREFORMAT1       3
    #define D3DFVF_TEXTUREFORMAT3       1
    #define D3DFVF_TEXTUREFORMAT4       2
    #define D3DFVF_TEXCOORDSIZE3( x )   (D3DFVF_TEXTUREFORMAT3 << (x * 2 + 16))
    #define D3DFVF_TEXCOORDSIZE2( x )   D3DFVF_TEXTUREFORMAT2
    #define D3DFVF_TEXCOORDSIZE4( x )   (D3DFVF_TEXTUREFORMAT4 << (x * 2 + 16))
    #define D3DFVF_TEXCOORDSIZE1( x )   (D3DFVF_TEXTUREFORMAT1 << (x * 2 + 16))
#endif

/* Direct3D enumeration callbacks */
typedef HRESULT (CALLBACK *LPD3DVALIDATECALLBACK)( LPVOID, DWORD );
typedef HRESULT (CALLBACK *LPD3DENUMTEXTUREFORMATSCALLBACK)( LPDDSURFACEDESC, LPVOID ) PURE;
typedef HRESULT (CALLBACK *LPD3DENUMPIXELFORMATSCALLBACK)( LPDDPIXELFORMAT, LPVOID ) PURE;

/* Direct3D color value */
typedef struct _D3DCOLORVALUE {
    union {
        D3DVALUE    r;
        D3DVALUE    dvR;
    };
    union {
        D3DVALUE    g;
        D3DVALUE    dvG;
    };
    union {
        D3DVALUE    b;
        D3DVALUE    dvB;
    };
    union {
        D3DVALUE    a;
        D3DVALUE    dvA;
    };
} D3DCOLORVALUE;
typedef D3DCOLORVALUE   *LPD3DCOLORVALUE;

/* Direct3D rectangle */
typedef struct _D3DRECT {
    union {
        LONG    x1;
        LONG    lX1;
    };
    union {
        LONG    y1;
        LONG    lY1;
    };
    union {
        LONG    x2;
        LONG    lX2;
    };
    union {
        LONG    y2;
        LONG    lY2;
    };
} D3DRECT;
typedef D3DRECT *LPD3DRECT;

/* Direct3D homogeneous vertex */
typedef struct _D3DHVERTEX {
    DWORD   dwFlags;
    union {
        D3DVALUE    hx;
        D3DVALUE    dvHX;
    };
    union {
        D3DVALUE    hy;
        D3DVALUE    dvHY;
    };
    union {
        D3DVALUE    hz;
        D3DVALUE    dvHZ;
    };
} D3DHVERTEX;
typedef D3DHVERTEX  *LPD3DHVERTEX;

/* Direct3D transformed/lit vertex */
typedef struct _D3DTLVERTEX {
    union {
        D3DVALUE    sx;
        D3DVALUE    dvSX;
    };
    union {
        D3DVALUE    sy;
        D3DVALUE    dvSY;
    };
    union {
        D3DVALUE    sz;
        D3DVALUE    dvSZ;
    };
    union {
        D3DVALUE    rhw;
        D3DVALUE    dvRHW;
    };
    union {
        D3DCOLOR    color;
        D3DCOLOR    dcColor;
    };
    union {
        D3DCOLOR    specular;
        D3DCOLOR    dcSpecular;
    };
    union {
        D3DVALUE    tu;
        D3DVALUE    dvTU;
    };
    union {
        D3DVALUE    tv;
        D3DVALUE    dvTV;
    };
} D3DTLVERTEX;
typedef D3DTLVERTEX *LPD3DTLVERTEX;

/* Direct3D lit vertex */
typedef struct _D3DLVERTEX {
    union {
        D3DVALUE    x;
        D3DVALUE    dvX;
    };
    union {
        D3DVALUE    y;
        D3DVALUE    dvY;
    };
    union {
        D3DVALUE    z;
        D3DVALUE    dvZ;
    };
    DWORD   dwReserved;
    union {
        D3DCOLOR    color;
        D3DCOLOR    dcColor;
    };
    union {
        D3DCOLOR    specular;
        D3DCOLOR    dcSpecular;
    };
    union {
        D3DVALUE    tu;
        D3DVALUE    dvTU;
    };
    union {
        D3DVALUE    dv;
        D3DVALUE    dvTV;
    };
} D3DLVERTEX;
typedef D3DLVERTEX  *LPD3DLVERTEX;

/* Direct3D vertex */
typedef struct _D3DVERTEX {
    union {
        D3DVALUE    x;
        D3DVALUE    dvX;
    };
    union {
        D3DVALUE    y;
        D3DVALUE    dvY;
    };
    union {
        D3DVALUE    z;
        D3DVALUE    dvZ;
    };
    union {
        D3DVALUE    ny;
        D3DVALUE    dvNY;
    };
    union {
        D3DVALUE    nz;
        D3DVALUE    dvNZ;
    };
    union {
        D3DVALUE    tu;
        D3DVALUE    dvTU;
    };
    union {
        D3DVALUE    tv;
        D3DVALUE    dvTV;
    };
} D3DVERTEX;
typedef D3DVERTEX   *LPD3DVERTEX;

/* Direct3D matrix */
typedef struct _D3DMATRIX {
    D3DVALUE    _11;
    D3DVALUE    _12;
    D3DVALUE    _13;
    D3DVALUE    _14;
    D3DVALUE    _21;
    D3DVALUE    _22;
    D3DVALUE    _23;
    D3DVALUE    _24;
    D3DVALUE    _31;
    D3DVALUE    _32;
    D3DVALUE    _33;
    D3DVALUE    _34;
    D3DVALUE    _41;
    D3DVALUE    _42;
    D3DVALUE    _43;
    D3DVALUE    _44;
} D3DMATRIX;
typedef D3DMATRIX   *LPD3DMATRIX;

/* Direct3D viewport */
typedef struct _D3DVIEWPORT {
    DWORD       dwSize;
    DWORD       dwX;
    DWORD       dwY;
    DWORD       dwWidth;
    DWORD       dwHeight;
    D3DVALUE    dvScaleX;
    D3DVALUE    dvScaleY;
    D3DVALUE    dvMaxX;
    D3DVALUE    dvMaxY;
    D3DVALUE    dvMinZ;
    D3DVALUE    dvMaxZ;
} D3DVIEWPORT;
typedef D3DVIEWPORT *LPD3DVIEWPORT;

/* Direct3D viewport (version 2) */
#if (DIRECT3D_VERSION >= 0x0500)
typedef struct _D3DVIEWPORT2 {
    DWORD       dwSize;
    DWORD       dwX;
    DWORD       dwY;
    DWORD       dwWidth;
    DWORD       dwHeight;
    D3DVALUE    dvClipX;
    D3DVALUE    dvClipY;
    D3DVALUE    dvClipWidth;
    D3DVALUE    dvClipHeight;
    D3DVALUE    dvMinZ;
    D3DVALUE    dvMaxZ;
} D3DVIEWPORT2;
typedef D3DVIEWPORT2    *LPD3DVIEWPORT2;
#endif

/* Direct3D viewport (version 7) */
#if (DIRECT3D_VERSION >= 0x0700)
typedef struct _D3DVIEWPORT7 {
    DWORD       dwX;
    DWORD       dwY;
    DWORD       dwWidth;
    DWORD       dwHeight;
    D3DVALUE    dvMinZ;
    D3DVALUE    dvMaxZ;
} D3DVIEWPORT7;
typedef D3DVIEWPORT7    *LPD3DVIEWPORT7;
#endif

/* Direct3D transform data */
typedef struct _D3DTRANSFORMDATA {
    DWORD           dwSize;
    LPVOID          lpIn;
    DWORD           dwInSize;
    LPVOID          lpOut;
    DWORD           dwOutSize;
    LPD3DHVERTEX    lpHOut;
    DWORD           dwClip;
    DWORD           dwClipIntersection;
    DWORD           dwClipUnion;
    D3DRECT         drExtent;
} D3DTRANSFORMDATA;
typedef D3DTRANSFORMDATA    *LPD3DTRANSFORMDATA;

/* Direct3D lighting element */
typedef struct _D3DLIGHTINGELEMENT {
    D3DVECTOR   dvPosition;
    D3DVECTOR   dvNormal;
} D3DLIGHTINGELEMENT;
typedef D3DLIGHTINGELEMENT  *LPD3DLIGHTINGELEMENT;

/* Direct3D material */
typedef struct _D3DMATERIAL {
    DWORD               dwSize;
    union {
        D3DCOLORVALUE   diffuse;
        D3DCOLORVALUE   dcvDiffuse;
    };
    union {
        D3DCOLORVALUE   ambient;
        D3DCOLORVALUE   dcvAmbient;
    };
    union {
        D3DCOLORVALUE   specular;
        D3DCOLORVALUE   dcvSpecular;
    };
    union {
        D3DCOLORVALUE   emissive;
        D3DCOLORVALUE   dcvEmissive;
    };
    union {
        D3DVALUE    power;
        D3DVALUE    dvPower;
    };
    D3DTEXTUREHANDLE    hTexture;
    DWORD               dwRampSize;
} D3DMATERIAL;
typedef D3DMATERIAL *LPD3DMATERIAL;

/* Direct3D material (version 7) */
#if (DIRECT3D_VERSION >= 0x0700)
typedef struct _D3DMATERIAL7 {
    union {
        D3DCOLORVALUE   diffuse;
        D3DCOLORVALUE   dcvDiffuse;
    };
    union {
        D3DCOLORVALUE   ambient;
        D3DCOLORVALUE   dcvAmbient;
    };
    union {
        D3DCOLORVALUE   specular;
        D3DCOLORVALUE   dcvSpecular;
    };
    union {
        D3DCOLORVALUE   emissive;
        D3DCOLORVALUE   dcvEmissive;
    };
    union {
        D3DVALUE    power;
        D3DVALUE    dvPower;
    };
} D3DMATERIAL7;
typedef D3DMATERIAL7    *LPD3DMATERIAL7;
#endif

/* Direct3D light types */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DLIGHTTYPE {
    D3DLIGHT_POINT          = 1,
    D3DLIGHT_SPOT           = 2,
    D3DLIGHT_DIRECTIONAL    = 3,
    D3DLIGHT_PARALLELPOINT  = 4,
#if (DIRECT3D_VERSION < 0x0500)
    D3DLIGHT_GLSPOT         = 5
#endif
    D3DLIGHT_FORCE_DWORD    = 0x7FFFFFFF
} D3DLIGHTTYPE;
#else
typedef enum _D3DLIGHTTYPE      D3DLIGHTTYPE;
#define D3DLIGHT_PARALLELPOINT  4
#define D3DLIGHT_GLSPOT         5
#endif

/* Direct3D light */
typedef struct _D3DLIGHT {
    DWORD           dwSize;
    D3DLIGHTTYPE    dltType;
    D3DCOLORVALUE   dcvColor;
    D3DVECTOR       dvPosition;
    D3DVECTOR       dvDirection;
    D3DVALUE        dvRange;
    D3DVALUE        dvFalloff;
    D3DVALUE        dvAttenuation0;
    D3DVALUE        dvAttenuation1;
    D3DVALUE        dvAttenuation2;
    D3DVALUE        dvTheta;
    D3DVALUE        dvPhi;
} D3DLIGHT;
typedef D3DLIGHT    *LPD3DLIGHT;

/* Direct3D light (version 7) */
#if (DIRECT3D_VERSION >= 0x0700)
typedef struct _D3DLIGHT7 {
    D3DLIGHTTYPE    dltType;
    D3DCOLORVALUE   dcvDiffuse;
    D3DCOLORVALUE   dcvSpecular;
    D3DCOLORVALUE   dcvAmbient;
    D3DVECTOR       dvPosition;
    D3DVECTOR       dvDirection;
    D3DVALUE        dvRange;
    D3DVALUE        dvFalloff;
    D3DVALUE        dvAttenuation0;
    D3DVALUE        dvAttenuation1;
    D3DVALUE        dvAttenuation2;
    D3DVALUE        dvTheta;
    D3DVALUE        dvPhi;
} D3DLIGHT7;
typedef D3DLIGHT7   *LPD3DLIGHT7;
#endif

/* Direct3D light (version 2) */
#if (DIRECT3D_VERSION >= 0x0500)
typedef struct _D3DLIGHT2 {
    DWORD           dwSize;
    D3DLIGHTTYPE    dltType;
    D3DCOLORVALUE   dcvColor;
    D3DVECTOR       dvPosition;
    D3DVECTOR       dvDirection;
    D3DVALUE        dvRange;
    D3DVALUE        dvFalloff;
    D3DVALUE        dvAttenuation0;
    D3DVALUE        dvAttenuation1;
    D3DVALUE        dvAttenuation2;
    D3DVALUE        dvTheta;
    D3DVALUE        dvPhi;
    DWORD           dwFlags;
} D3DLIGHT2;
typedef D3DLIGHT2   *LPD3DLIGHT2;
#endif

/* Direct3D light data */
typedef struct _D3DLIGHTDATA {
    DWORD                   dwSize;
    LPD3DLIGHTINGELEMENT    lpIn;
    DWORD                   dwInSize;
    LPD3DTLVERTEX           lpOut;
    DWORD                   dwOutSize;
} D3DLIGHTDATA;
typedef D3DLIGHTDATA    *LPD3DLIGHTDATA;

/* Direct3D operation codes */
typedef enum _D3DOPCODE {
    D3DOP_POINT             = 1,
    D3DOP_LINE              = 2,
    D3DOP_TRIANGLE          = 3,
    D3DOP_MATRIXLOAD        = 4,
    D3DOP_MATRIXMULTIPLY    = 5,
    D3DOP_STATETRANSFORM    = 6,
    D3DOP_STATELIGHT        = 7,
    D3DOP_STATERENDER       = 8,
    D3DOP_PROCESSVERTICES   = 9,
    D3DOP_TEXTURELOAD       = 10,
    D3DOP_EXIT              = 11,
    D3DOP_BRANCHFORWARD     = 12,
    D3DOP_SPAN              = 13,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DOP_SETSTATUS         = 14,
    D3DOP_FORCE_DWORD       = 0x7FFFFFFF
#else
    D3DOP_SETSTATUS         = 14
#endif
} D3DOPCODE;

/* Direct3D instruction */
typedef struct _D3DINSTRUCTION {
    BYTE    bOpcode;
    BYTE    bSize;
    WORD    wCount;
} D3DINSTRUCTION;
typedef D3DINSTRUCTION  *LPD3DINSTRUCTION;

/* Direct3D texture load information */
typedef struct _D3DTEXTURELOAD {
    D3DTEXTUREHANDLE    hDestTexture;
    D3DTEXTUREHANDLE    hSrcTexture;
} D3DTEXTURELOAD;
typedef D3DTEXTURELOAD  *LPD3DTEXTURELOAD;

/* Direct3D pick record information */
typedef struct _D3DPICKRECORD {
    BYTE        bOpcode;
    BYTE        bPad;
    DWORD       dwOffset;
    D3DVALUE    dvZ;
} D3DPICKRECORD;
typedef D3DPICKRECORD   *LPD3DPICKRECORD;

/* Direct3D shade modes */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DSHADEMODE {
    D3DSHADE_FLAT       = 1,
    D3DSHADE_GOURAUD    = 2,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DSHADE_PHONG      = 3,
    D3DSHADE_FORCE_DWORD    = 0x7FFFFFFF
#else
    D3DSHADE_PHONG      = 3
#endif
} D3DSHADEMODE;
#endif

/* Direct3D fill modes */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DFILLMODE {
    D3DFILL_POINT       = 1,
    D3DFILL_WIREFRAME   = 2,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DFILL_SOLID       = 3,
    D3DFILL_FORCE_DWORD = 0x7FFFFFFF
#else
    D3DFILL_SOLID       = 3
#endif
} D3DFILLMODE;
#endif

/* Direct3D line pattern */
#if (DIRECT3D_VERSION < 0x0800)
typedef struct _D3DLINEPATTERN {
    WORD    wRepeatFactor;
    WORD    wLinePattern;
} D3DLINEPATTERN;
#endif

/* Direct3D texture filter values */
typedef enum _D3DTEXTUREFILTER {
    D3DFILTER_NEAREST           = 1,
    D3DFILTER_LINEAR            = 2,
    D3DFILTER_MIPNEAREST        = 3,
    D3DFILTER_MIPLINEAR         = 4,
    D3DFILTER_LINEARMIPNEAREST  = 5,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DFILTER_LINEARMIPLINEAR   = 6,
    D3DFILTER_FORCE_DWORD       = 0x7FFFFFFF
#else
    D3DFILTER_LINEARMIPLINEAR   = 6
#endif
} D3DTEXTUREFILTER;

/* Direct3D blend values */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DBLEND {
    D3DBLEND_ZERO               = 1,
    D3DBLEND_ONE                = 2,
    D3DBLEND_SRCCOLOR           = 3,
    D3DBLEND_INVSRCCOLOR        = 4,
    D3DBLEND_SRCALPHA           = 5,
    D3DBLEND_INVSRCALPHA        = 6,
    D3DBLEND_DESTALPHA          = 7,
    D3DBLEND_INVDESTALPHA       = 8,
    D3DBLEND_DESTCOLOR          = 9,
    D3DBLEND_INVDESTCOLOR       = 10,
    D3DBLEND_SRCALPHASAT        = 11,
    D3DBLEND_BOTHSRCALPHA       = 12,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DBLEND_BOTHINVSRCALPHA    = 13,
    D3DBLEND_FORCE_DWORD        = 0x7FFFFFFF
#else
    D3DBLEND_BOTHINVSRCALPHA    = 13
#endif
} D3DBLEND;
#endif

/* Direct3D texture blend values */
typedef enum _D3DTEXTUREBLEND {
    D3DTBLEND_DECAL         = 1,
    D3DTBLEND_MODULATE      = 2,
    D3DTBLEND_DECALALPHA    = 3,
    D3DTBLEND_MODULATEALPHA = 4,
    D3DTBLEND_DECALMASK     = 5,
    D3DTBLEND_MODULATEMAKS  = 6,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DTBLEND_COPY          = 7,
    D3DTBLEND_ADD           = 8,
    D3DTBLEND_FORCE_DWORD   = 0x7FFFFFFF
#else
    D3DTBLEND_COPY          = 7
#endif
} D3DTEXTUREBLEND;

/* Direct3D texture address values */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DTEXTUREADDRESS {
    D3DTADDRESS_WRAP        = 1,
    D3DTADDRESS_MIRROR      = 2,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DTADDRESS_CLAMP       = 3,
    D3DTADDRESS_BORDER      = 4,
    D3DTADDRESS_FORCE_DWORD = 0x7FFFFFFF
#else
    D3DTADDRESS_CLAMP       = 3
#endif
} D3DTEXTUREADDRESS;
#endif

/* Direct3D cull values */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DCULL {
    D3DCULL_NONE        = 1,
    D3DCULL_CW          = 2,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DCULL_CCW         = 3,
    D3DCULL_FORCE_DWORD = 0x7FFFFFFF
#else
    D3DCULL_CCW         = 3
#endif
} D3DCULL;
#endif

/* Direct3D compare functions */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DCMPFUNC {
    D3DCMP_NEVER        = 1,
    D3DCMP_LESS         = 2,
    D3DCMP_EQUAL        = 3,
    D3DCMP_LESSEQUAL    = 4,
    D3DCMP_GREATER      = 5,
    D3DCMP_NOTEQUAL     = 6,
    D3DCMP_GREATEREQUAL = 7,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DCMP_ALWAYS       = 8,
    D3DCMP_FORCE_DWORD  = 0x7FFFFFFF
#else
    D3DCMP_ALWAYS       = 8
#endif
} D3DCMPFUNC;
#endif

/* Direct3D stencil operations */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DSTENCILOP {
    D3DSTENCILOP_KEEP           = 1,
    D3DSTENCILOP_ZERO           = 2,
    D3DSTENCILOP_REPLACE        = 3,
    D3DSTENCILOP_INCRSAT        = 4,
    D3DSTENCILOP_DECRSAT        = 5,
    D3DSTENCILOP_INVERT         = 6,
    D3DSTENCILOP_INCR           = 7,
    D3DSTENCILOP_DECR           = 8,
    D3DSTENCILOP_FORCE_DWORD    = 0x7FFFFFFF
} D3DSTENCILOP;
#endif

/* Direct3D fog modes */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DFOGMODE {
    D3DFOG_NONE         = 0,
    D3DFOG_EXP          = 1,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DFOG_EXP2         = 2,
    D3DFOG_LINEAR       = 3,
    D3DFOG_FORCE_DWORD  = 0x7FFFFFFF
#else
    D3DFOG_EXP2         = 2
#endif
} D3DFOGMODE;
#endif

/* Direct3D z-buffer types */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DZBUFFERTYPE {
    D3DZB_FALSE         = 0,
    D3DZB_TRUE          = 1,
    D3DZB_USEW          = 2,
    D3DZB_FORCE_DWORD   = 0x7FFFFFFF
} D3DZBUFFERTYPE;
#endif

/* Direct3D anti-aliasing modes */
#if (DIRECT3D_VERSION >= 0x0500)
typedef enum _D3DANTIALIASMODE {
    D3DANTIALIAS_NONE               = 0,
    D3DANTIALIAS_SORTDEPENDENT      = 1,
    D3DANTIALIAS_SORTINDEPENDENT    = 2,
    D3DANTIALIAS_FORCE_DWORD        = 0x7FFFFFFF
} D3DANTIALIAS;
#endif

/* Direct3D vertex types */
#if (DIRECT3D_VERSION >= 0x0500)
typedef enum _D3DVERTEXTYPE {
    D3DVT_VERTEX        = 1,
    D3DVT_LVERTEX       = 2,
    D3DVT_TLVERTEX      = 3,
    D3DVT_FORCE_DWORD   = 0x7FFFFFFF
} D3DVERTEXTYPE;
#endif

/* Direct3D primitive types */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0500)
typedef enum _D3DPRIMITIVETYPE {
    D3DPT_POINTLIST     = 1,
    D3DPT_LINELIST      = 2,
    D3DPT_LINESTRIP     = 3,
    D3DPT_TRIANGLELIST  = 4,
    D3DPT_TRIANGLESTRIP = 5,
    D3DPT_TRIANGLEFAN   = 6,
    D3DPT_FORCE_DWORD   = 0x7FFFFFFF
} D3DPRIMITIVETYPE;
#endif

/* Direct3D transform state types */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DTRANSFORMSTATETYPE {
    D3DTRANSFORMSTATE_WORLD         = 1,
    D3DTRANSFORMSTATE_VIEW          = 2,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DTRANSFORMSTATE_PROJECTION    = 3,
#if (DIRECT3D_VERSION >= 0x0700)
    D3DTRANSFORMSTATE_WORLD1        = 4,
    D3DTRANSFORMSTATE_WORLD2        = 5,
    D3DTRANSFORMSTATE_WORLD3        = 6,
    D3DTRANSFORMSTATE_TEXTURE0      = 16,
    D3DTRANSFORMSTATE_TEXTURE1      = 17,
    D3DTRANSFORMSTATE_TEXTURE2      = 18,
    D3DTRANSFORMSTATE_TEXTURE3      = 19,
    D3DTRANSFORMSTATE_TEXTURE4      = 20,
    D3DTRANSFORMSTATE_TEXTURE5      = 21,
    D3DTRANSFORMSTATE_TEXTURE6      = 22,
    D3DTRANSFORMSTATE_TEXTURE7      = 23,
#endif
    D3DTRANSFORMSTATE_FORCE_DWORD   = 0x7FFFFFFF
#else
    D3DTRANSFORMSTATE_PROJECTION    = 3
#endif
} D3DTRANSFORMSTATETYPE;
#else
typedef enum _D3DTRANSFORMSTATETYPE     D3DTRANSFORMSTATETYPE;
#define D3DTRANSFORMSTATE_WORLD         1
#define D3DTRANSFORMSTATE_VIEW          2
#define D3DTRANSFORMSTATE_PROJECTION    3
#define D3DTRANSFORMSTATE_WORLD1        4
#define D3DTRANSFORMSTATE_WORLD2        5
#define D3DTRANSFORMSTATE_WORLD3        6
#define D3DTRANSFORMSTATE_TEXTURE0      16
#define D3DTRANSFORMSTATE_TEXTURE1      17
#define D3DTRANSFORMSTATE_TEXTURE2      18
#define D3DTRANSFORMSTATE_TEXTURE3      19
#define D3DTRANSFORMSTATE_TEXTURE4      20
#define D3DTRANSFORMSTATE_TEXTURE5      21
#define D3DTRANSFORMSTATE_TEXTURE6      22
#define D3DTRANSFORMSTATE_TEXTURE7      23
#endif

/* Direct3D light state types */
typedef enum _D3DLIGHTSTATETYPE {
    D3DLIGHTSTATE_MATERIAL      = 1,
    D3DLIGHTSTATE_AMBIENT       = 2,
    D3DLIGHTSTATE_COLORMODEL    = 3,
    D3DLIGHTSTATE_FOGMODE       = 4,
    D3DLIGHTSTATE_FOGSTART      = 5,
    D3DLIGHTSTATE_FOGEND        = 6,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DLIGHTSTATE_FOGDENSITY    = 7,
#if (DIRECT3D_VERSION >= 0x0600)
    D3DLIGHTSTATE_COLORVERTEX   = 8,
#endif
    D3DLIGHTSTATE_FORCE_DWORD   = 0x7FFFFFFF
#endif
} D3DLIGHTSTATETYPE;

/* Direct3D render state types */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DRENDERSTATETYPE {
    D3DRENDERSTATE_ANTIALIAS                    = 2,
    D3DRENDERSTATE_TEXTUREPERSPECTIVE           = 4,
    D3DRENDERSTATE_ZENABLE                      = 7,
    D3DRENDERSTATE_FILLMODE                     = 8,
    D3DRENDERSTATE_SHADEMODE                    = 9,
    D3DRENDERSTATE_LINEPATTERN                  = 10,
    D3DRENDERSTATE_ZWRITEENABLE                 = 14,
    D3DRENDERSTATE_ALPHATESTENABLE              = 15,
    D3DRENDERSTATE_LASTPIXEL                    = 16,
    D3DRENDERSTATE_SRCBLEND                     = 19,
    D3DRENDERSTATE_DESTBLEND                    = 20,
    D3DRENDERSTATE_CULLMODE                     = 22,
    D3DRENDERSTATE_ZFUNC                        = 23,
    D3DRENDERSTATE_ALPHAREF                     = 24,
    D3DRENDERSTATE_ALPHAFUNC                    = 25,
    D3DRENDERSTATE_DITHERENABLE                 = 26,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DRENDERSTATE_ALPHABLENDENABLE             = 27,
#endif
    D3DRENDERSTATE_FOGENABLE                    = 28,
    D3DRENDERSTATE_SPECULARENABLE               = 29,
    D3DRENDERSTATE_ZVISIBLE                     = 30,
    D3DRENDERSTATE_STIPPLEDALPHA                = 33,
    D3DRENDERSTATE_FOGCOLOR                     = 34,
    D3DRENDERSTATE_FOGTABLEMODE                 = 35,
#if (DIRECT3D_VERSION >= 0x0700)
    D3DRENDERSTATE_FOGSTART                     = 36,
    D3DRENDERSTATE_FOGEND                       = 37,
    D3DRENDERSTATE_FOGDENSITY                   = 38,
#endif
#if (DIRECT3D_VERSION >= 0x0500)
    D3DRENDERSTATE_EDGEANTIALIAS                = 40,
    D3DRENDERSTATE_COLORKEYENABLE               = 41,
    D3DRENDERSTATE_ZBIAS                        = 47,
    D3DRENDERSTATE_RANGEFOGENABLE               = 48,
#endif
#if (DIRECT3D_VERSION >= 0x0600)
    D3DRENDERSTATE_STENCILENABLE                = 52,
    D3DRENDERSTATE_STENCILFAIL                  = 53,
    D3DRENDERSTATE_STENCILZFAIL                 = 54,
    D3DRENDERSTATE_STENCILPASS                  = 55,
    D3DRENDERSTATE_STENCILFUNC                  = 56,
    D3DRENDERSTATE_STENCILREF                   = 57,
    D3DRENDERSTATE_STENCILMASK                  = 58,
    D3DRENDERSTATE_STENCILWRITEMASK             = 59,
    D3DRENDERSTATE_TEXTUREFACTOR                = 60,
    D3DRENDERSTATE_WRAP0                        = 128,
    D3DRENDERSTATE_WRAP1                        = 129,
    D3DRENDERSTATE_WRAP2                        = 130,
    D3DRENDERSTATE_WRAP3                        = 131,
    D3DRENDERSTATE_WRAP4                        = 132,
    D3DRENDERSTATE_WRAP5                        = 133,
    D3DRENDERSTATE_WRAP6                        = 134,
    D3DRENDERSTATE_WRAP7                        = 135,
#endif
#if (DIRECT3D_VERSION >= 0x0700)
    D3DRENDERSTATE_CLIPPING                     = 136,
    D3DRENDERSTATE_LIGHTING                     = 137,
    D3DRENDERSTATE_EXTENTS                      = 138,
    D3DRENDERSTATE_AMBIENT                      = 139,
    D3DRENDERSTATE_FOGVERTEXMODE                = 140,
    D3DRENDERSTATE_COLORVERTEX                  = 141,
    D3DRENDERSTATE_LOCALVIEWER                  = 142,
    D3DRENDERSTATE_NORMALIZENORMALS             = 143,
    D3DRENDERSTATE_COLORKEYBLENDENABLE          = 144,
    D3DRENDERSTATE_DIFFUSEMATERIALSOURCE        = 145,
    D3DRENDERSTATE_SPECULARMATERIALSOURCE       = 146,
    D3DRENDERSTATE_AMBIENTMATERIALSOURCE        = 147,
    D3DRENDERSTATE_EMISSIVEMATERIALSOURCE       = 148,
    D3DRENDERSTATE_VERTEXBLEND                  = 151,
    D3DRENDERSTATE_CLIPPLANEENABLE              = 152,
#endif
    D3DRENDERSTATE_TEXTUREHANDLE                = 1,
    D3DRENDERSTATE_TEXTUREADDRESS               = 3,
    D3DRENDERSTATE_WRAPU                        = 5,
    D3DRENDERSTATE_WRAPV                        = 6,
    D3DRENDERSTATE_MONOENABLE                   = 11,
    D3DRENDERSTATE_ROP2                         = 12,
    D3DRENDERSTATE_PLANEMASK                    = 13,
    D3DRENDERSTATE_TEXTUREMAG                   = 17,
    D3DRENDERSTATE_TEXTUREMIN                   = 18,
    D3DRENDERSTATE_TEXTUREMAPBLEND              = 21,
    D3DRENDERSTATE_SUBPIXEL                     = 31,
    D3DRENDERSTATE_SUBPIXELX                    = 32,
    D3DRENDERSTATE_STIPPLEENABLE                = 39,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DRENDERSTATE_BORDERCOLOR                  = 43,
    D3DRENDERSTATE_TEXTUREADDRESSU              = 44,
    D3DRENDERSTATE_TEXTUREADDRESSV              = 45,
    D3DRENDERSTATE_MIPMAPLODBIAS                = 46,
    D3DRENDERSTATE_ANISOTROPY                   = 49,
#endif
    D3DRENDERSTATE_FLUSHBATCH                   = 50,
#if (DIRECT3D_VERSION >= 0x0600)
    D3DRENDERSTATE_TRANSLUCENTSORTINDEPENDENT   = 51,
#endif
    D3DRENDERSTATE_STIPPLEPATTERN00             = 64,
    D3DRENDERSTATE_STIPPLEPATTERN01             = 65,
    D3DRENDERSTATE_STIPPLEPATTERN02             = 66,
    D3DRENDERSTATE_STIPPLEPATTERN03             = 67,
    D3DRENDERSTATE_STIPPLEPATTERN04             = 68,
    D3DRENDERSTATE_STIPPLEPATTERN05             = 69,
    D3DRENDERSTATE_STIPPLEPATTERN06             = 70,
    D3DRENDERSTATE_STIPPLEPATTERN07             = 71,
    D3DRENDERSTATE_STIPPLEPATTERN08             = 72,
    D3DRENDERSTATE_STIPPLEPATTERN09             = 73,
    D3DRENDERSTATE_STIPPLEPATTERN10             = 74,
    D3DRENDERSTATE_STIPPLEPATTERN11             = 75,
    D3DRENDERSTATE_STIPPLEPATTERN12             = 76,
    D3DRENDERSTATE_STIPPLEPATTERN13             = 77,
    D3DRENDERSTATE_STIPPLEPATTERN14             = 78,
    D3DRENDERSTATE_STIPPLEPATTERN15             = 79,
    D3DRENDERSTATE_STIPPLEPATTERN16             = 80,
    D3DRENDERSTATE_STIPPLEPATTERN17             = 81,
    D3DRENDERSTATE_STIPPLEPATTERN18             = 82,
    D3DRENDERSTATE_STIPPLEPATTERN19             = 83,
    D3DRENDERSTATE_STIPPLEPATTERN20             = 84,
    D3DRENDERSTATE_STIPPLEPATTERN21             = 85,
    D3DRENDERSTATE_STIPPLEPATTERN22             = 86,
    D3DRENDERSTATE_STIPPLEPATTERN23             = 87,
    D3DRENDERSTATE_STIPPLEPATTERN24             = 88,
    D3DRENDERSTATE_STIPPLEPATTERN25             = 89,
    D3DRENDERSTATE_STIPPLEPATTERN26             = 90,
    D3DRENDERSTATE_STIPPLEPATTERN27             = 91,
    D3DRENDERSTATE_STIPPLEPATTERN28             = 92,
    D3DRENDERSTATE_STIPPLEPATTERN29             = 93,
    D3DRENDERSTATE_STIPPLEPATTERN30             = 94,
    D3DRENDERSTATE_STIPPLEPATTERN31             = 95,
    D3DRENDERSTATE_FOGTABLESTART                = 36,
    D3DRENDERSTATE_FOGTABLEEND                  = 37,
#if (DIRECT3D_VERSION >= 0x0500)
    D3DRENDERSTATE_FOGTABLEDENSITY              = 38,
    D3DRENDERSTATE_FORCE_DWORD                  = 0x7FFFFFFF
#else
    D3DRENDERSTATE_FOGTABLEDENSITY              = 38
#endif
} D3DRENDERSTATETYPE;
#if (DIRECT3D_VERSION >= 0x0500)
    #define D3DRENDERSTATE_BLENDENABLE          D3DRENDERSTATE_ALPHABLENDENABLE
#endif
#if (DIRECT3D_VERSION >= 0x0600)
    #define D3DRENDERSTATE_WRAPBIAS             128
#endif
#else
typedef enum _D3DRENDERSTATETYPE                D3DRENDERSTATETYPE;
#define D3DRENDERSTATE_TEXTUREPERSPECTIVE       4
#define D3DRENDERSTATE_ZENABLE                  7
#define D3DRENDERSTATE_FILLMODE                 8
#define D3DRENDERSTATE_SHADEMODE                9
#define D3DRENDERSTATE_LINEPATTERN              10
#define D3DRENDERSTATE_ZWRITEENABLE             14
#define D3DRENDERSTATE_ALPHATESTENABLE          15
#define D3DRENDERSTATE_LASTPIXEL                16
#define D3DRENDERSTATE_SRCBLEND                 19
#define D3DRENDERSTATE_DESTBLEND                20
#define D3DRENDERSTATE_CULLMODE                 22
#define D3DRENDERSTATE_ZFUNC                    23
#define D3DRENDERSTATE_ALPHAREF                 24
#define D3DRENDERSTATE_ALPHAFUNC                25
#define D3DRENDERSTATE_DITHERENABLE             26
#define D3DRENDERSTATE_ALPHABLENDENABLE         27
#define D3DRENDERSTATE_FOGENABLE                28
#define D3DRENDERSTATE_SPECULARENABLE           29
#define D3DRENDERSTATE_ZVISIBLE                 30
#define D3DRENDERSTATE_STIPPLEDALPHA            33
#define D3DRENDERSTATE_FOGCOLOR                 34
#define D3DRENDERSTATE_FOGTABLEMODE             35
#define D3DRENDERSTATE_FOGSTART                 36
#define D3DRENDERSTATE_FOGEND                   37
#define D3DRENDERSTATE_FOGDENSITY               38
#define D3DRENDERSTATE_EDGEANTIALIAS            40
#define D3DRENDERSTATE_ZBIAS                    47
#define D3DRENDERSTATE_RANGEFOGENABLE           48
#define D3DRENDERSTATE_STENCILENABLE            52
#define D3DRENDERSTATE_STENCILFAIL              53
#define D3DRENDERSTATE_STENCILZFAIL             54
#define D3DRENDERSTATE_STENCILPASS              55
#define D3DRENDERSTATE_STENCILFUNC              56
#define D3DRENDERSTATE_STENCILREF               57
#define D3DRENDERSTATE_STENCILMASK              58
#define D3DRENDERSTATE_STENCILWRITEMASK         59
#define D3DRENDERSTATE_TEXTUREFACTOR            60
#define D3DRENDERSTATE_WRAP0                    128
#define D3DRENDERSTATE_WRAP1                    129
#define D3DRENDERSTATE_WRAP2                    130
#define D3DRENDERSTATE_WRAP3                    131
#define D3DRENDERSTATE_WRAP4                    132
#define D3DRENDERSTATE_WRAP5                    133
#define D3DRENDERSTATE_WRAP6                    134
#define D3DRENDERSTATE_WRAP7                    135
#define D3DRENDERSTATE_CLIPPING                 136
#define D3DRENDERSTATE_LIGHTING                 137
#define D3DRENDERSTATE_EXTENTS                  138
#define D3DRENDERSTATE_AMBIENT                  139
#define D3DRENDERSTATE_FOGVERTEXMODE            140
#define D3DRENDERSTATE_COLORVERTEX              141
#define D3DRENDERSTATE_LOCALVIEWER              142
#define D3DRENDERSTATE_NORMALIZENORMALS         143
#define D3DRENDERSTATE_COLORKEYBLENDENABLE      144
#define D3DRENDERSTATE_DIFFUSEMATERIALSOURCE    145
#define D3DRENDERSTATE_SPECULARMATERIALSOURCE   146
#define D3DRENDERSTATE_AMBIENTMATERIALSOURCE    147
#define D3DRENDERSTATE_EMISSIVEMATERIALSOURCE   148
#define D3DRENDERSTATE_VERTEXBLEND              151
#define D3DRENDERSTATE_CLIPPLANEENABLE          152
#define D3DRENDERSTATE_TEXTUREHANDLE            1
#define D3DRENDERSTATE_ANTIALIAS                2
#define D3DRENDERSTATE_TEXTUREADDRESS           3
#define D3DRENDERSTATE_WRAPU                    5
#define D3DRENDERSTATE_WRAPV                    6
#define D3DRENDERSTATE_MONOENABLE               11
#define D3DRENDERSTATE_ROP2                     12
#define D3DRENDERSTATE_PLANEMASK                13
#define D3DRENDERSTATE_TEXTUREMAG               17
#define D3DRENDERSTATE_TEXTUREMIN               18
#define D3DRENDERSTATE_TEXTUREMAPBLEND          21
#define D3DRENDERSTATE_SUBPIXEL                 31
#define D3DRENDERSTATE_SUBPIXELX                32
#define D3DRENDERSTATE_STIPPLEENABLE            39
#define D3DRENDERSTATE_OLDALPHABLENDENABLE      42
#define D3DRENDERSTATE_BORDERCOLOR              43
#define D3DRENDERSTATE_TEXTUREADDRESSU          44
#define D3DRENDERSTATE_TEXTUREADDRESSV          45
#define D3DRENDERSTATE_MIPMAPLODBIAS            46
#define D3DRENDERSTATE_ANISOTROPY               49
#define D3DRENDERSTATE_FLUSHBATCH               50
#define D3DRENDERSTATE_TRANSLUCENTSORTINDEPENDENT   51
#define D3DRENDERSTATE_STIPPLEPATTERN00         64
#define D3DRENDERSTATE_STIPPLEPATTERN01         64
#define D3DRENDERSTATE_STIPPLEPATTERN02         64
#define D3DRENDERSTATE_STIPPLEPATTERN03         64
#define D3DRENDERSTATE_STIPPLEPATTERN04         64
#define D3DRENDERSTATE_STIPPLEPATTERN05         64
#define D3DRENDERSTATE_STIPPLEPATTERN06         64
#define D3DRENDERSTATE_STIPPLEPATTERN07         64
#define D3DRENDERSTATE_STIPPLEPATTERN08         64
#define D3DRENDERSTATE_STIPPLEPATTERN09         64
#define D3DRENDERSTATE_STIPPLEPATTERN10         64
#define D3DRENDERSTATE_STIPPLEPATTERN11         64
#define D3DRENDERSTATE_STIPPLEPATTERN12         64
#define D3DRENDERSTATE_STIPPLEPATTERN13         64
#define D3DRENDERSTATE_STIPPLEPATTERN14         64
#define D3DRENDERSTATE_STIPPLEPATTERN15         64
#define D3DRENDERSTATE_STIPPLEPATTERN16         64
#define D3DRENDERSTATE_STIPPLEPATTERN17         64
#define D3DRENDERSTATE_STIPPLEPATTERN18         64
#define D3DRENDERSTATE_STIPPLEPATTERN19         64
#define D3DRENDERSTATE_STIPPLEPATTERN20         64
#define D3DRENDERSTATE_STIPPLEPATTERN21         64
#define D3DRENDERSTATE_STIPPLEPATTERN22         64
#define D3DRENDERSTATE_STIPPLEPATTERN23         64
#define D3DRENDERSTATE_STIPPLEPATTERN24         64
#define D3DRENDERSTATE_STIPPLEPATTERN25         64
#define D3DRENDERSTATE_STIPPLEPATTERN26         64
#define D3DRENDERSTATE_STIPPLEPATTERN27         64
#define D3DRENDERSTATE_STIPPLEPATTERN28         64
#define D3DRENDERSTATE_STIPPLEPATTERN29         64
#define D3DRENDERSTATE_STIPPLEPATTERN30         64
#define D3DRENDERSTATE_STIPPLEPATTERN31         64
#define D3DRENDERSTATE_COLORKEYENABLE           41
#define D3DRENDERSTATE_COLORKEYBLENDABLE        144
#define D3DRENDERSTATE_BLENDENABLE              27
#define D3DRENDERSTATE_FOGTABLESTART            36
#define D3DRENDERSTATE_FOGTABLEEND              37
#define D3DRENDERSTATE_FOGTABLEDENSITY          38
#endif
#define D3DRENDERSTATE_STIPPLEPATTERN( x )      (D3DRENDERSTATE_STIPPLEPATTERN00 + (x))

/* Direct3D material color sources */
#if (DIRECT3D_VERSION < 0x0800)
typedef enum _D3DMATERIALCOLORSOURCE {
    D3DMCS_MATERIAL     = 0,
    D3DMCS_COLOR1       = 1,
    D3DMCS_COLOR2       = 2,
    D3DMCS_FORCE_DWORD  = 0x7FFFFFFF
} D3DMATERIALCOLORSOURCE;
#endif

/* Direct3D state */
typedef struct _D3DSTATE {
    union {
#if (DIRECT3D_VERSION < 0x0800)
        D3DTRANSFORMSTATETYPE   dtstTransformStateType;
#endif
        D3DLIGHTSTATETYPE       dlstLightStateType;
        D3DRENDERSTATETYPE      drstRenderStateType;
    };
    union {
        DWORD       dwArg[1];
        D3DVALUE    dvArg[1];
    };
} D3DSTATE;
typedef D3DSTATE    *LPD3DSTATE;

/* Direct3D matrix load parameters */
typedef struct _D3DMATRIXLOAD {
    D3DMATRIXHANDLE hDestMatrix;
    D3DMATRIXHANDLE hSrcMatrix;
} D3DMATRIXLOAD;
typedef D3DMATRIXLOAD   *LPD3DMATRIXLOAD;

/* Direct3D matrix multiply parameters */
typedef struct _D3DMATRIXMULTIPLY {
    D3DMATRIXHANDLE hDestMatrix;
    D3DMATRIXHANDLE hSrcMatrix1;
    D3DMATRIXHANDLE hSrcMatrix2;
} D3DMATRIXMULTIPLY;
typedef D3DMATRIXMULTIPLY   *LPD3DMATRIXMULTIPLY;

/* Direct3D process vertices parameters */
typedef struct _D3DPROCESSVERTICES {
    DWORD   dwFlags;
    WORD    wStart;
    WORD    wDest;
    DWORD   dwCount;
    DWORD   dwReserved;
} D3DPROCESSVERTICES;
typedef D3DPROCESSVERTICES  *LPD3DPROCESSVERTICES;

/* Direct3D texture stage state types */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DTEXTURESTAGESTATETYPE {
    D3DTSS_COLOROP                  = 1,
    D3DTSS_COLORARG1                = 2,
    D3DTSS_COLORARG2                = 3,
    D3DTSS_ALPHAOP                  = 4,
    D3DTSS_ALPHAARG1                = 5,
    D3DTSS_ALPHAARG2                = 6,
    D3DTSS_BUMPENVMAT00             = 7,
    D3DTSS_BUMPENVMAT01             = 8,
    D3DTSS_BUMPENVMAT10             = 9,
    D3DTSS_BUMPENVMAT11             = 10,
    D3DTSS_TEXCOORDINDEX            = 11,
    D3DTSS_ADDRESS                  = 12,
    D3DTSS_ADDRESSU                 = 13,
    D3DTSS_ADDRESSV                 = 14,
    D3DTSS_BORDERCOLOR              = 15,
    D3DTSS_MAGFILTER                = 16,
    D3DTSS_MINFILTER                = 17,
    D3DTSS_MIPFILTER                = 18,
    D3DTSS_MIPMAPLODBIAS            = 19,
    D3DTSS_MAXMIPLEVEL              = 20,
    D3DTSS_MAXANISOTROPY            = 21,
    D3DTSS_BUMPENVLSCALE            = 22,
    D3DTSS_BUMPENVLOFFSET           = 23,
#if (DIRECT3D_VERSION >= 0x0700)
    D3DTSS_TEXTURETRANSFORMFLAGS    = 24,
#endif
    D3DTSS_FORCE_DWORD              = 0x7FFFFFFF
} D3DTEXTURESTAGESTATETYPE;
#endif

/* Direct3D texture operations */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DTEXTUREOP {
    D3DTOP_DISABLE                      = 1,
    D3DTOP_SELECTARG1                   = 2,
    D3DTOP_SELECTARG2                   = 3,
    D3DTOP_MODULATE                     = 4,
    D3DTOP_MODULATE2X                   = 5,
    D3DTOP_MODULATE4X                   = 6,
    D3DTOP_ADD                          = 7,
    D3DTOP_ADDSIGNED                    = 8,
    D3DTOP_ADDSIGNED2X                  = 9,
    D3DTOP_SUBTRACT                     = 10,
    D3DTOP_ADDSMOOTH                    = 11,
    D3DTOP_BLENDDIFFUSEALPHA            = 12,
    D3DTOP_BLENDTEXTUREALPHA            = 13,
    D3DTOP_BLENDFACTORALPHA             = 14,
    D3DTOP_BLENDTEXTUREALPHAPM          = 15,
    D3DTOP_BLENDCURRENTALPHA            = 16,
    D3DTOP_PREMODULATE                  = 17,
    D3DTOP_MODULATEALPHA_ADDCOLOR       = 18,
    D3DTOP_MODULATECOLOR_ADDALPHA       = 19,
    D3DTOP_MODULATEINVALPHA_ADDCOLOR    = 20,
    D3DTOP_MODULATEINVCOLOR_ADDALPHA    = 21,
    D3DTOP_BUMPENVMAP                   = 22,
    D3DTOP_BUMPENVMAPLUMINANCE          = 23,
    D3DTOP_DOTPRODUCT3                  = 24,
    D3DTOP_FORCE_DWORD                  = 0x7FFFFFFF
} D3DTEXTUREOP;
#endif

/* Direct3D texture magnification filters */
#if (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DTEXTUREMAGFILTER {
    D3DTFG_POINT            = 1,
    D3DTFG_LINEAR           = 2,
    D3DTFG_FLATCUBIC        = 3,
    D3DTFG_GAUSSIANCUBIC    = 4,
    D3DTFG_ANISOTROPIC      = 5,
    D3DTFG_FORCE_DWORD      = 0x7FFFFFFF
} D3DTEXTUREMAGFILTER;
#endif

/* Direct3D texture minification filters */
#if (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DTEXTUREMINFILTER {
    D3DTFN_POINT        = 1,
    D3DTFN_LINEAR       = 2,
    D3DTFN_ANISOTROPIC  = 3,
    D3DTFN_FORCE_DOWRD  = 0x7FFFFFFF
} D3DTEXTUREMINFILTER;
#endif

/* Direct3D texture mip filters */
#if (DIRECT3D_VERSION >= 0x0600)
typedef enum _D3DTEXTUREMIPFILTER {
    D3DTFP_NONE         = 1,
    D3DTFP_POINT        = 2,
    D3DTFP_LINEAR       = 3,
    D3DTFP_FORCE_DWORD  = 0x7FFFFFFF
} D3DTEXTUREMIPFILTER;
#endif

/* Direct3D triangle */
typedef struct _D3DTRIANGLE {
    union {
        WORD    v1;
        WORD    wV1;
    };
    union {
        WORD    v2;
        WORD    wV2;
    };
    union {
        WORD    v3;
        WORD    wV3;
    };
    WORD    wFlags;
} D3DTRIANGLE;
typedef D3DTRIANGLE *LPD3DTRIANGLE;

/* Direct3D line */
typedef struct _D3DLINE {
    union {
        WORD    v1;
        WORD    wV1;
    };
    union {
        WORD    v2;
        WORD    wV2;
    };
} D3DLINE;
typedef D3DLINE *LPD3DLINE;

/* Direct3D span */
typedef struct _D3DSPAN {
    WORD    wCount;
    WORD    wFirst;
} D3DSPAN;
typedef D3DSPAN *LPD3DSPAN;

/* Direct3D point */
typedef struct _D3DPOINT {
    WORD    wCount;
    WORD    wFirst;
} D3DPOINT;
typedef D3DPOINT    *LPD3DPOINT;

/* Direct3D branch */
typedef struct _D3DBRANCH {
    DWORD   dwMask;
    DWORD   dwValue;
    BOOL    bNegate;
    DWORD   dwOffset;
} D3DBRANCH;
typedef D3DBRANCH   *LPD3DBRANCH;

/* Direct3D status */
typedef struct _D3DSTATUS {
    DWORD   dwFlags;
    DWORD   dwStatus;
    D3DRECT drExtent;
} D3DSTATUS;
typedef D3DSTATUS   *LPD3DSTATUS;

/* Direct3D clip status */
#if (DIRECT3D_VERSION >= 0x0500)
typedef struct _D3DCLIPSTATUS {
    DWORD   dwFlags;
    DWORD   dwStatus;
    float   minx;
    float   maxx;
    float   miny;
    float   maxy;
    float   minz;
    float   maxz;
} D3DCLIPSTATUS;
typedef D3DCLIPSTATUS   *LPD3DCLIPSTATUS;
#endif

/* Direct3D statistics */
typedef struct _D3DSTATS {
    DWORD   dwSize;
    DWORD   dwTrianglesDrawn;
    DWORD   dwLinesDrawn;
    DWORD   dwPointsDrawn;
    DWORD   dwSpansDrawn;
    DWORD   dwVerticesProcessed;
} D3DSTATS;
typedef D3DSTATS    *LPD3DSTATS;

/* Direct3D execute data */
typedef struct _D3DEXECUTEDATA {
    DWORD       dwSize;
    DWORD       dwVertexOffset;
    DWORD       dwVertexCount;
    DWORD       dwInstructionOffset;
    DWORD       dwInstructionLength;
    DWORD       dwHVertexOffset;
    D3DSTATUS   dsStatus;
} D3DEXECUTEDATA;
typedef D3DEXECUTEDATA  *LPD3DEXECUTEDATA;

/* Direct3D vertex buffer description */
#if (DIRECT3D_VERSION >= 0x0600)
typedef struct _D3DVERTEXBUFFERDESC {
    DWORD   dwSize;
    DWORD   dwCaps;
    DWORD   dwFVF;
    DWORD   dwNumVertices;
} D3DVERTEXBUFFERDESC;
typedef D3DVERTEXBUFFERDESC *LPD3DVERTEXBUFFERDESC;
#endif

/* Direct3D pointer stride */
#if (DIRECT3D_VERSION >= 0x0600)
typedef struct _D3DDP_PTRSTRIDE {
    LPVOID  lpvData;
    DWORD   dwStride;
} D3DDP_PTRSTRIDE;
#endif

/* Direct3D draw primitive strided data */
#if (DIRECT3D_VERSION >= 0x0600)
typedef struct _D3DDRAWPRIMITIVESTRIDEDDATA {
    D3DDP_PTRSTRIDE position;
    D3DDP_PTRSTRIDE normal;
    D3DDP_PTRSTRIDE diffuse;
    D3DDP_PTRSTRIDE specular;
    D3DDP_PTRSTRIDE textureCoords[D3DDP_MAXTEXCOORD];
} D3DDRAWPRIMITIVESTRIDEDDATA;
typedef D3DDRAWPRIMITIVESTRIDEDDATA *LPD3DDRAWPRIMITIVESTRIDEDDATA;
#endif

/* Direct3D state block types */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
typedef enum _D3DSTATEBLOCKTYPE {
    D3DSBT_ALL          = 1,
    D3DSBT_PIXELSTATE   = 2,
    D3DSBT_VERTEXSTATE  = 3,
    D3DSBT_FORCE_DWORD  = 0xFFFFFFFF
} D3DSTATEBLOCKTYPE;
#endif

/* Direct3D vertex blend flags */
#if (DIRECT3D_VERSION < 0x0800)
#if (DIRECT3D_VERSION >= 0x0700)
typedef enum _D3DVERTEXBLENDFLAGS {
    D3DVBLEND_DISABLE   = 0,
    D3DVBLEND_1WEIGHT   = 1,
    D3DVBLEND_2WEIGHTS  = 2,
    D3DVBLEND_3WEIGHTS  = 3
} D3DVERTEXBLENDFLAGS;
#endif
#else
typedef enum _D3DVERTEXBLENDFLAGS   D3DVERTEXBLENDFLAGS;
#define D3DVBLEND_DISABLE           0
#define D3DVBLEND_1WEIGHT           1
#define D3DVBLEND_2WEIGHTS          2
#define D3DVBLEND_3WEIGHTS          3
#endif

/* Direct3D texture transform flags */
#if (DIRECT3D_VERSION < 0x0800) && (DIRECT3D_VERSION >= 0x0700)
typedef enum _D3DTEXTURETRANSFORMFLAGS {
    D3DTTFF_DISABLE     = 0,
    D3DTTFF_COUNT1      = 1,
    D3DTTFF_COUNT2      = 2,
    D3DTTFF_COUNT3      = 3,
    D3DTTFF_COUNT4      = 4,
    D3DTTFF_PROJECTED   = 256,
    D3DTTFF_FORCE_DWORD = 0x7FFFFFFF
} D3DTEXTURETRANSFORMFLAGS;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _D3DTYPES_H_ */
