/*
 *  dsrole.h    Directory Service role functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __DSROLE_H__
#define __DSROLE_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Directory Service primary domain information flags */
#define DSROLE_PRIMARY_DS_RUNNING           0x00000001L
#define DSROLE_PRIMARY_DS_MIXED_MODE        0x00000002L
#define DSROLE_UPGRADE_IN_PROGRESS          0x00000004L
#define DSROLE_PRIMARY_DS_READONLY          0x00000008L
#define DSROLE_PRIMARY_DOMAIN_GUID_PRESENT  0x01000000L

/* Directory Service machine roles */
typedef enum _DSROLE_MACHINE_ROLE {
    DsRole_RoleStandaloneWorkstation    = 0,
    DsRole_RoleMemberWorkstation        = 1,
    DsRole_RoleStandaloneServer         = 2,
    DsRole_RoleMemberServer             = 3,
    DsRole_RoleBackupDomainController   = 4,
    DsRole_RolePrimaryDomainController  = 5
} DSROLE_MACHINE_ROLE;

/* Directory Service server states */
typedef enum _DSROLE_SERVER_STATE {
    DsRoleServerUnknown = 0,
    DsRoleServerPrimary = 1,
    DsRoleServerBackup  = 2
} DSROLE_SERVER_STATE;
typedef DSROLE_SERVER_STATE *PDSROLE_SERVER_STATE;

/* Directory Service primary domain information levels */
typedef enum _DSROLE_PRIMARY_DOMAIN_INFO_LEVEL {
    DsRolePrimaryDomainInfoBasic    = 1,
    DsRoleUpgradeStatus             = 2,
    DsRoleOperationState            = 3
} DSROLE_PRIMARY_DOMAIN_INFO_LEVEL;

/* Directory Service basic primary domain information */
typedef struct _DSROLE_PRIMARY_DOMAIN_INFO_BASIC {
    DSROLE_MACHINE_ROLE MachineRole;
    ULONG               Flags;
    LPWSTR              DomainNameFlat;
    LPWSTR              DomainNameDns;
    LPWSTR              DomainForestName;
    GUID                DomainGuid;
} DSROLE_PRIMARY_DOMAIN_INFO_BASIC;
typedef DSROLE_PRIMARY_DOMAIN_INFO_BASIC    *PDSROLE_PRIMARY_DOMAIN_INFO_BASIC;

/* Directory Service upgrade status information */
typedef struct _DSROLE_UPGRADE_STATUS_INFO {
    ULONG               OperationState;
    DSROLE_SERVER_STATE PreviousServerState;
} DSROLE_UPGRADE_STATUS_INFO;
typedef DSROLE_UPGRADE_STATUS_INFO  *PDSROLE_UPGRADE_STATUS_INFO;

/* Directory Service operation states */
typedef enum _DSROLE_OPERATION_STATE {
    DsRoleOperationIdle         = 0,
    DsRoleOperationActive       = 1,
    DsRoleOperationNeedReboot   = 2
} DSROLE_OPERATION_STATE;

/* Directory Service operation state information */
typedef struct _DSROLE_OPERATION_STATE_INFO {
    DSROLE_OPERATION_STATE  OperationState;
} DSROLE_OPERATION_STATE_INFO;
typedef DSROLE_OPERATION_STATE_INFO *PDSROLE_OPERATION_STATE_INFO;

/* Functions in NETAPI32.DLL */
VOID WINAPI     DsRoleFreeMemory( PVOID );
DWORD WINAPI    DsRoleGetPrimaryDomainInformation( LPCWSTR, DSROLE_PRIMARY_DOMAIN_INFO_LEVEL, PBYTE * );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __DSROLE_H__ */
