/*
 *  imm.h       Input Method Manager functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _IMM_
#define _IMM_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* IMM handle data types */
DECLARE_HANDLE( HIMC );
DECLARE_HANDLE( HIMCC );

/* Style description size */
#define STYLE_DESCRIPTION_SIZE  32

/* IME menu item string size */
#if (WINVER >= 0x040A)
    #define IMEMENUITEM_STRING_SIZE 80
#endif

/* WM_IME_CONTROL commands */
#define IMC_GETCANDIDATEPOS         0x0007
#define IMC_SETCANDIDATEPOS         0x0008
#define IMC_GETCOMPOSITIONFONT      0x0009
#define IMC_SETCOMPOSITIONFONT      0x000A
#define IMC_GETCOMPOSITIONWINDOW    0x000B
#define IMC_SETCOMPOSITIONWINDOW    0x000C
#define IMC_GETSTATUSWINDOWPOS      0x000F
#define IMC_SETSTATUSWINDOWPOS      0x0010
#define IMC_CLOSESTATUSWINDOW       0x0021
#define IMC_OPENSTATUSWINDOW        0x0022

/* ImmNotifyIME() actions */
#define NI_OPENCANDIDATE            0x00000010L
#define NI_CLOSECANDIDATE           0x00000011L
#define NI_SELECTCANDIDATESTR       0x00000012L
#define NI_CHANGECANDIDATELIST      0x00000013L
#define NI_FINALIZECONVERSIONRESULT 0x00000014L
#define NI_COMPOSITIONSTR           0x00000015L
#define NI_SETCANDIDATE_PAGESTART   0x00000016L
#define NI_SETCANDIDATE_PAGESIZE    0x00000017L
#define NI_IMEMENUSELECTED          0x00000018L

/* WM_IME_SETCONTEXT flags */
#define ISC_SHOWUICANDIDATEWINDOW       0x00000001L
#define ISC_SHOWUICOMPOSITIONWINDOW     0x80000000L
#define ISC_SHOWUIGUIDELINE             0x40000000L
#define ISC_SHOWUIALLCANDIDATEWINDOW    0x0000000FL
#define ISC_SHOWUIALL                   0xC000000FL

/* NI_COMPOSITIONSTR indices */
#define CPS_COMPLETE    0x00000001L
#define CPS_CONVERT     0x00000002L
#define CPS_REVERT      0x00000003L
#define CPS_CANCEL      0x00000004L

/* Hot key modifiers */
#define MOD_LEFT                0x8000
#define MOD_RIGHT               0x4000
#define MOD_ON_KEYUP            0x0800
#define MOD_IGNORE_ALL_MODIFIER 0x0400

/* Simplified Chinese hot key identifiers */
#define IME_CHOTKEY_IME_NONIME_TOGGLE   0x00000010
#define IME_CHOTKEY_SHAPE_TOGGLE        0x00000011
#define IME_CHOTKEY_SYMBOL_TOGGLE       0x00000012

/* Japanese hot key identifiers */
#define IME_JHOTKEY_CLOSE_OPEN  0x00000030

/* Korean hot key identifiers */
#define IME_KHOTKEY_SHAPE_TOGGLE    0x00000050
#define IME_KHOTKEY_HANJACONVERT    0x00000051
#define IME_KHOTKEY_ENGLISH         0x00000052

/* Traditional Chinese hot key identifiers */
#define IME_THOTKEY_IME_NONIME_TOGGLE   0x00000070
#define IME_THOTKEY_SHAPE_TOGGLE        0x00000071
#define IME_THOTKEY_SYMBOL_TOGGLE       0x00000072

/* Direct switch hot key identifiers */
#define IME_HOTKEY_DSWITCH_FIRST    0x00000100
#define IME_HOTKEY_DSWITCH_LAST     0x0000011F

/* Private hot key identifiers */
#define IME_HOTKEY_PRIVATE_FIRST            0x00000200
#define IME_ITHOTKEY_RESEND_RESULTSTR       0x00000200
#define IME_ITHOTKEY_PREVIOUS_COMPOSITION   0x00000201
#define IME_ITHOTKEY_UISTYLE_TOGGLE         0x00000202
#define IME_ITHOTKEY_RECONVERTSTRING        0x00000203
#define IME_HOTKEY_PRIVATE_LAST             0x0000021F

/* ImmGetCompositionString() flags */
#define GCS_COMPREADSTR         0x00000001L
#define GCS_COMPREADATTR        0x00000002L
#define GCS_COMPREADCLAUSE      0x00000004L
#define GCS_COMPSTR             0x00000008L
#define GCS_COMPATTR            0x00000010L
#define GCS_COMPCLAUSE          0x00000020L
#define GCS_CURSORPOS           0x00000040L
#define GCS_DELTASTART          0x00000100L
#define GCS_RESULTREADSTR       0x00000200L
#define GCS_RESULTREADCLAUSE    0x00000400L
#define GCS_RESULTSTR           0x00000800L
#define GCS_RESULTCLAUSE        0x00001000L

/* WM_IME_COMPOSITION styles */
#define CS_INSERTCHAR   0x2000
#define CS_NOMOVECARET  0x4000

/* IME versions */
#define IMEVER_0310 0x0003000AL
#define IMEVER_0400 0x00040000L

/* IME property flags */
#define IME_PROP_AT_CARET               0x00010000L
#define IME_PROP_SPECIAL_UI             0x00020000L
#define IME_PROP_CANDLIST_START_FROM_1  0x00040000L
#define IME_PROP_UNICODE                0x00080000L
#define IME_PROP_COMPLETE_ON_UNSELECT   0x00100000L

/* IME UI capabilities */
#define UI_CAP_2700     0x00000001L
#define UI_CAP_ROT90    0x00000002L
#define UI_CAP_ROTANY   0x00000004L

/* ImmSetCompositionString() capabilities */
#define SCS_CAP_COMPSTR             0x00000001L
#define SCS_CAP_MAKEREAD            0x00000002L
#define SCS_CAP_SETRECONVERTSTRING  0x00000004L

/* WM_IME_SELECT capabilities */
#define SELECT_CAP_CONVERSION   0x00000001L
#define SELECT_CAP_SENTENCE     0x00000002L

/* ImmGetGuideLine() indices */
#define GGL_LEVEL   0x00000001L
#define GGL_INDEX   0x00000002L
#define GGL_STRING  0x00000003L
#define GGL_PRIVATE 0x00000004L

/* Guide line levels */
#define GL_LEVEL_NOGUIDELINE    0x00000000L
#define GL_LEVEL_FATAL          0x00000001L
#define GL_LEVEL_ERROR          0x00000002L
#define GL_LEVEL_WARNING        0x00000003L
#define GL_LEVEL_INFORMATION    0x00000004L

/* Guide line indices */
#define GL_ID_UNKNOWN           0x00000000L
#define GL_ID_NOMODULE          0x00000001L
#define GL_ID_NODICTIONARY      0x00000010L
#define GL_ID_CANNOTSAVE        0x00000011L
#define GL_ID_NOCONVERT         0x00000020L
#define GL_ID_TYPINGERROR       0x00000021L
#define GL_ID_TOOMANYSTROKE     0x00000022L
#define GL_ID_READINGCONFLICT   0x00000023L
#define GL_ID_INPUTREADING      0x00000024L
#define GL_ID_INPUTRADICAL      0x00000025L
#define GL_ID_INPUTCODE         0x00000026L
#define GL_ID_INPUTSYMBOL       0x00000027L
#define GL_ID_CHOOSECANDIDATE   0x00000028L
#define GL_ID_REVERSECONVERSION 0x00000029L
#define GL_ID_PRIVATE_FIRST     0x00008000L
#define GL_ID_PRIVATE_LAST      0x0000FFFFL

/* ImmGetProperty() indices */
#define IGP_GETIMEVERSION   (-4L)
#define IGP_PROPERTY        0x00000004L
#define IGP_CONVERSION      0x00000008L
#define IGP_SENTENCE        0x0000000CL
#define IGP_UI              0x00000010L
#define IGP_SETCOMPSTR      0x00000014L
#define IGP_SELECT          0x00000018L

/* ImmSetCompositionString() indices */
#define SCS_SETSTR                  (GCS_COMPREADSTR | GCS_COMPSTR)
#define SCS_CHANGEATTR              (GCS_COMPREADATTR | GCS_COMPATTR)
#define SCS_CHANGECLAUSE            (GCS_COMPREADCLAUSE | GCS_COMPCLAUSE)
#define SCS_SETRECONVERTSTRING      0x00010000L
#define SCS_QUERYRECONVERTSTRING    0x00020000L

/* Composition string attributes */
#define ATTR_INPUT                  0x00
#define ATTR_TARGET_CONVERTED       0x01
#define ATTR_CONVERTED              0x02
#define ATTR_TARGET_NOTCONVERTED    0x03
#define ATTR_INPUT_ERROR            0x04
#define ATTR_FIXEDCONVERTED         0x05

/* Composition form styles */
#define CFS_DEFAULT         0x00000000L
#define CFS_RECT            0x00000001L
#define CFS_POINT           0x00000002L
#define CFS_FORCE_POSITION  0x00000020L
#define CFS_CANDIDATEPOS    0x00000040L
#define CFS_EXCLUDE         0x00000080L

/* ImmGetConversionList() flags */
#define GCL_CONVERSION          0x00000001
#define GCL_REVERSECONVERSION   0x00000002
#define GCL_REVERSE_LENGTH      0x00000003

/* IME conversion modes */
#define IME_CMODE_ALPHANUMERIC  0x00000000L
#define IME_CMODE_NATIVE        0x00000001L
#define IME_CMODE_CHINESE       IME_CMODE_NATIVE
#define IME_CMODE_HANGEUL       IME_CMODE_NATIVE
#define IME_CMODE_HANGUL        IME_CMODE_NATIVE
#define IME_CMODE_JAPANESE      IME_CMODE_NATIVE
#define IME_CMODE_KATAKANA      0x00000002L
#define IME_CMODE_LANGUAGE      0x00000003L
#define IME_CMODE_FULLSHAPE     0x00000008L
#define IME_CMODE_ROMAN         0x00000010L
#define IME_CMODE_CHARCODE      0x00000020L
#define IME_CMODE_HANJACONVERT  0x00000040L
#define IME_CMODE_SOFTKBD       0x00000080L
#define IME_CMODE_NOCONVERSION  0x00000100L
#define IME_CMODE_EUDC          0x00000200L
#define IME_CMODE_SYMBOL        0x00000400L
#define IME_CMODE_FIXED         0x00000800L
#define IME_CMODE_RESERVED      0xF0000000L

/* IME sentence modes */
#define IME_SMODE_NONE          0x00000000L
#define IME_SMODE_PLURALCLAUSE  0x00000001L
#define IME_SMODE_SINGLECONVERT 0x00000002L
#define IME_SMODE_AUTOMATIC     0x00000004L
#define IME_SMODE_PHRASEPREDICT 0x00000008L
#define IME_SMODE_CONVERSATION  0x00000010L
#define IME_SMODE_RESERVED      0x0000F000L

/* IME candidate styles */
#define IME_CAND_UNKNOWN    0x00000000L
#define IME_CAND_READ       0x00000001L
#define IME_CAND_CODE       0x00000002L
#define IME_CAND_MEANING    0x00000003L
#define IME_CAND_RADICAL    0x00000004L
#define IME_CAND_STROKE     0x00000005L

/* IME notifications */
#define IMN_CLOSESTATUSWINDOW       0x0001
#define IMN_OPENSTATUSWINDOW        0x0002
#define IMN_CHANGECANDIDATE         0x0003
#define IMN_CLOSECANDIDATE          0x0004
#define IMN_OPENCANDIDATE           0x0005
#define IMN_SETCONVERSIONMODE       0x0006
#define IMN_SETSENTENCEMODE         0x0007
#define IMN_SETOPENSTATUS           0x0008
#define IMN_SETCANDIDATEPOS         0x0009
#define IMN_SETCOMPOSITIONFONT      0x000A
#define IMN_SETCOMPOSITIONWINDOW    0x000B
#define IMN_SETSTATUSWINDOWPOS      0x000C
#define IMN_GUIDELINE               0x000D
#define IMN_PRIVATE                 0x000E

/* IME requests */
#if (WINVER >= 0x040A)
    #define IMR_COMPOSITIONWINDOW       0x0001
    #define IMR_CANDIDATEWINDOW         0x0002
    #define IMR_COMPOSITIONFONT         0x0003
    #define IMR_RECONVERTSTRING         0x0004
    #define IMR_CONFIRMRECONVERTSTRING  0x0005
    #define IMR_QUERYCHARPOSITION       0x0006
    #define IMR_DOCUMENTFEED            0x0007
#endif

/* ImmGetCompositionString() error codes */
#define IMM_ERROR_NODATA    (-1)
#define IMM_ERROR_GENERAL   (-2)

/* ImmConfigureIME() modes */
#define IME_CONFIG_GENERAL          1L
#define IME_CONFIG_REGISTERWORD     2L
#define IME_CONFIG_SELECTDICTIONARY 3L

/* IME escapes */
#define IME_ESC_QUERY_SUPPORT           0x00000003L
#define IME_ESC_RESERVED_FIRST          0x00000004L
#define IME_ESC_RESERVED_LAST           0x000007FFL
#define IME_ESC_PRIVATE_FIRST           0x00000800L
#define IME_ESC_PRIVATE_LAST            0x00000FFFL
#define IME_ESC_SEQUENCE_TO_INTERNAL    0x00001001L
#define IME_ESC_GET_EUDC_DICTIONARY     0x00001003L
#define IME_ESC_SET_EUDC_DICTIONARY     0x00001004L
#define IME_ESC_MAX_KEY                 0x00001005L
#define IME_ESC_IME_NAME                0x00001006L
#define IME_ESC_SYNC_HOTKEY             0x00001007L
#define IME_ESC_HANJA_MODE              0x00001008L
#define IME_ESC_AUTOMATA                0x00001009L
#define IME_ESC_PRIVATE_HOTKEY          0x0000100AL
#define IME_ESC_GETHELPFILENAME         0x0000100BL

/* ImmRegisterWord() styles */
#define IME_REGWORD_STYLE_EUDC          0x00000001L
#define IME_REGWORD_STYLE_USER_FIRST    0x80000000L
#define IME_REGWORD_STYLE_USER_LAST     0xFFFFFFFFL

/* ImmAssociateContextEx() flags */
#if (WINVER >= 0x040A)
    #define IACE_CHILDREN           0x00000001L
    #define IACE_DEFAULT            0x00000010L
    #define IACE_IGNORENOCONTEXT    0x000000020L
#endif

/* ImmGetImeMenuItems() flags */
#if (WINVER >= 0x040A)
    #define IGIMIF_RIGHTMENU    0x00000001L
#endif

/* ImmGetImeMenuItems() types */
#if (WINVER >= 0x040A)
    #define IGIMII_CMODE        0x00000001L
    #define IGIMII_SMODE        0x00000002L
    #define IGIMII_CONFIGURE    0x00000004L
    #define IGIMII_TOOLS        0x00000008L
    #define IGIMII_HELP         0x00000010L
    #define IGIMII_OTHER        0x00000020L
    #define IGIMII_INPUTTOOLS   0x00000040L
#endif

/* IME menu item types */
#if (WINVER >= 0x040A)
    #define IMFT_RADIOCHECK 0x00000001
    #define IMFT_SEPARATOR  0x00000002
    #define IMFT_SUBMENU    0x00000004
#endif

/* IME menu item states */
#if (WINVER >= 0x040A)
    #define IMFS_GRAYED     MFS_GRAYED
    #define IMFS_DISABLED   MFS_DISABLED
    #define IMFS_CHECKED    MFS_CHECKED
    #define IMFS_HILITE     MFS_HILITE
    #define IMFS_ENABLED    MFS_ENABLED
    #define IMFS_UNCHECKED  MFS_UNCHECKED
    #define IMFS_UNHILITE   MFS_UNHILITE
    #define IMFS_DEFAULT    MFS_DEFAULT
#endif

/* Soft keyboard types */
#define SOFTKEYBOARD_TYPE_T1    0x0001
#define SOFTKEYBOARD_TYPE_C1    0x0002

/* Composition form */
typedef struct tagCOMPOSITIONFORM {
    DWORD   dwStyle;
    POINT   ptCurrentPos;
    RECT    rcArea;
} COMPOSITIONFORM;
typedef COMPOSITIONFORM *PCOMPOSITIONFORM;
typedef COMPOSITIONFORM *NPCOMPOSITIONFORM;
typedef COMPOSITIONFORM *LPCOMPOSITIONFORM;

/* Candidate form */
typedef struct tagCANDIDATEFORM {
    DWORD   dwIndex;
    DWORD   dwStyle;
    POINT   ptCurrentPos;
    RECT    rcArea;
} CANDIDATEFORM;
typedef CANDIDATEFORM   *PCANDIDATEFORM;
typedef CANDIDATEFORM   *NPCANDIDATEFORM;
typedef CANDIDATEFORM   *LPCANDIDATEFORM;

/* Candidate list */
typedef struct tagCANDIDATELIST {
    DWORD   dwSize;
    DWORD   dwStyle;
    DWORD   dwCount;
    DWORD   dwSelection;
    DWORD   dwPageStart;
    DWORD   dwPageSize;
    DWORD   dwOffset[1];
} CANDIDATELIST;
typedef CANDIDATELIST   *PCANDIDATELIST;
typedef CANDIDATELIST   *NPCANDIDATELIST;
typedef CANDIDATELIST   *LPCANDIDATELIST;

/* Register word */
typedef struct tagREGISTERWORDA {
    LPSTR   lpReading;
    LPSTR   lpWord;
} REGISTERWORDA;
typedef REGISTERWORDA   *PREGISTERWORDA;
typedef REGISTERWORDA   *NPREGISTERWORDA;
typedef REGISTERWORDA   *LPREGISTERWORDA;
typedef struct tagREGISTERWORDW {
    LPWSTR  lpReading;
    LPWSTR  lpWord;
} REGISTERWORDW;
typedef REGISTERWORDW   *PREGISTERWORDW;
typedef REGISTERWORDW   *NPREGISTERWORDW;
typedef REGISTERWORDW   *LPREGISTERWORDW;
#ifdef UNICODE
typedef REGISTERWORDW   REGISTERWORD;
typedef PREGISTERWORDW  PREGISTERWORD;
typedef NPREGISTERWORDW NPREGISTERWORD;
typedef LPREGISTERWORDW LPREGISTERWORD;
#else
typedef REGISTERWORDA   REGISTERWORD;
typedef PREGISTERWORDA  PREGISTERWORD;
typedef NPREGISTERWORDA NPREGISTERWORD;
typedef LPREGISTERWORDA LPREGISTERWORD;
#endif

/* Reconvert string */
#if (WINVER >= 0x040A)
typedef struct tagRECONVERTSTRING {
    DWORD   dwSize;
    DWORD   dwVersion;
    DWORD   dwStrLen;
    DWORD   dwStrOffset;
    DWORD   dwCompStrLen;
    DWORD   dwCompStrOffset;
    DWORD   dwTargetStrLen;
    DWORD   dwTargetStrOffset;
} RECONVERTSTRING;
typedef RECONVERTSTRING *PRECONVERTSTRING;
typedef RECONVERTSTRING *NPRECONVERTSTRING;
typedef RECONVERTSTRING *LPRECONVERTSTRING;
#endif

/* Style buffer */
typedef struct tagSTYLEBUFA {
    DWORD   dwStyle;
    CHAR    szDescription[STYLE_DESCRIPTION_SIZE];
} STYLEBUFA;
typedef STYLEBUFA   *PSTYLEBUFA;
typedef STYLEBUFA   *NPSTYLEBUFA;
typedef STYLEBUFA   *LPSTYLEBUFA;
typedef struct tagSTYLEBUFW {
    DWORD   dwStyle;
    WCHAR   szDescription[STYLE_DESCRIPTION_SIZE];
} STYLEBUFW;
typedef STYLEBUFW   *PSTYLEBUFW;
typedef STYLEBUFW   *NPSTYLEBUFW;
typedef STYLEBUFW   *LPSTYLEBUFW;
#ifdef UNICODE
typedef STYLEBUFW   STYLEBUF;
typedef PSTYLEBUFW  PSTYLEBUF;
typedef NPSTYLEBUFW NPSTYLEBUF;
typedef LPSTYLEBUFW LPSTYLEBUF;
#else
typedef STYLEBUFA   STYLEBUF;
typedef PSTYLEBUFA  PSTYLEBUF;
typedef NPSTYLEBUFA NPSTYLEBUF;
typedef LPSTYLEBUFA LPSTYLEBUF;
#endif

/* IME menu item information */
#if (WINVER >= 0x040A)
typedef struct tagIMEMENUITEMINFOA {
    UINT    cbSize;
    UINT    fType;
    UINT    fState;
    UINT    wID;
    HBITMAP hbmpChecked;
    HBITMAP hbmpUnchecked;
    DWORD   dwItemData;
    CHAR    szString[IMEMENUITEM_STRING_SIZE];
    HBITMAP hbmpItem;
} IMEMENUITEMINFOA;
typedef IMEMENUITEMINFOA    *PIMEMENUITEMINFOA;
typedef IMEMENUITEMINFOA    *NPIMEMENUITEMINFOA;
typedef IMEMENUITEMINFOA    *LPIMEMENUITEMINFOA;
typedef struct tagIMEMENUITEMINFOW {
    UINT    cbSize;
    UINT    fType;
    UINT    fState;
    UINT    wID;
    HBITMAP hbmpChecked;
    HBITMAP hbmpUnchecked;
    DWORD   dwItemData;
    WCHAR   szString[IMEMENUITEM_STRING_SIZE];
    HBITMAP hbmpItem;
} IMEMENUITEMINFOW;
typedef IMEMENUITEMINFOW    *PIMEMENUITEMINFOW;
typedef IMEMENUITEMINFOW    *NPIMEMENUITEMINFOW;
typedef IMEMENUITEMINFOW    *LPIMEMENUITEMINFOW;
#ifdef UNICODE
typedef IMEMENUITEMINFOW    IMEMENUITEMINFO;
typedef PIMEMENUITEMINFOW   PIMEMENUITEMINFO;
typedef NPIMEMENUITEMINFOW  NPIMEMENUITEMINFO;
typedef LPIMEMENUITEMINFOW  LPIMEMENUITEMINFO;
#else
typedef IMEMENUITEMINFOA    IMEMENUITEMINFO;
typedef PIMEMENUITEMINFOA   PIMEMENUITEMINFO;
typedef NPIMEMENUITEMINFOA  NPIMEMENUITEMINFO;
typedef LPIMEMENUITEMINFOA  LPIMEMENUITEMINFO;
#endif
#endif

/* IME character position */
#if (WINVER >= 0x040A)
typedef struct tagIMECHARPOSITION {
    DWORD   dwSize;
    DWORD   dwCharPos;
    POINT   pt;
    UINT    cLineHeight;
    RECT    rcDocument;
} IMECHARPOSITION;
typedef IMECHARPOSITION *PIMECHARPOSITION;
typedef IMECHARPOSITION *NPIMECHARPOSITION;
typedef IMECHARPOSITION *LPIMECHARPOSITION;
#endif

/* Input method context enumeration callback */
typedef BOOL (CALLBACK *IMCENUMPROC)( HIMC, LPARAM );

/* Register word enumeration callback */
typedef int (CALLBACK *REGISTERWORDENUMPROCA)( LPCSTR, DWORD, LPCSTR, LPVOID );
typedef int (CALLBACK *REGISTERWORDENUMPROCW)( LPCWSTR, DWORD, LPCWSTR, LPVOID );
#ifdef UNICODE
    #define REGISTERWORDENUMPROC    REGISTERWORDENUMPROCW
#else
    #define REGISTERWORDENUMPROC    REGISTERWORDENUMPROCA
#endif

/* Functions in IMM32.DLL */
HIMC WINAPI     ImmAssociateContext( HWND, HIMC );
BOOL WINAPI     ImmConfigureIMEA( HKL, HWND, DWORD, LPVOID );
BOOL WINAPI     ImmConfigureIMEW( HKL, HWND, DWORD, LPVOID );
HIMC WINAPI     ImmCreateContext( void );
BOOL WINAPI     ImmDestroyContext( HIMC );
UINT WINAPI     ImmEnumRegisterWordA( HKL, REGISTERWORDENUMPROCA, LPCSTR, DWORD, LPCSTR, LPVOID );
UINT WINAPI     ImmEnumRegisterWordW( HKL, REGISTERWORDENUMPROCW, LPCWSTR, DWORD, LPCWSTR, LPVOID );
LRESULT WINAPI  ImmEscapeA( HKL, HIMC, UINT, LPVOID );
LRESULT WINAPI  ImmEscapeW( HKL, HIMC, UINT, LPVOID );
DWORD WINAPI    ImmGetCandidateListA( HIMC, DWORD, LPCANDIDATELIST, DWORD );
DWORD WINAPI    ImmGetCandidateListCountA( HIMC, LPDWORD );
DWORD WINAPI    ImmGetCandidateListCountW( HIMC, LPDWORD );
DWORD WINAPI    ImmGetCandidateListW( HIMC, DWORD, LPCANDIDATELIST, DWORD );
BOOL WINAPI     ImmGetCandidateWindow( HIMC, DWORD, LPCANDIDATEFORM );
BOOL WINAPI     ImmGetCompositionFontA( HIMC, LPLOGFONTA );
BOOL WINAPI     ImmGetCompositionFontW( HIMC, LPLOGFONTW );
LONG WINAPI     ImmGetCompositionStringA( HIMC, DWORD, LPVOID, DWORD );
LONG WINAPI     ImmGetCompositionStringW( HIMC, DWORD, LPVOID, DWORD );
BOOL WINAPI     ImmGetCompositionWindow( HIMC, LPCOMPOSITIONFORM );
HIMC WINAPI     ImmGetContext( HWND );
DWORD WINAPI    ImmGetConversionListA( HKL, HIMC, LPCSTR, LPCANDIDATELIST, DWORD, UINT );
DWORD WINAPI    ImmGetConversionListW( HKL, HIMC, LPCWSTR, LPCANDIDATELIST, DWORD, UINT );
BOOL WINAPI     ImmGetConversionStatus( HIMC, LPDWORD, LPDWORD );
HWND WINAPI     ImmGetDefaultIMEWnd( HWND );
UINT WINAPI     ImmGetDescriptionA( HKL, LPSTR, UINT );
UINT WINAPI     ImmGetDescriptionW( HKL, LPWSTR, UINT );
DWORD WINAPI    ImmGetGuideLineA( HIMC, DWORD, LPSTR, DWORD );
DWORD WINAPI    ImmGetGuideLineW( HIMC, DWORD, LPWSTR, DWORD );
UINT WINAPI     ImmGetIMEFileNameA( HKL, LPSTR, UINT );
UINT WINAPI     ImmGetIMEFileNameW( HKL, LPWSTR, UINT );
BOOL WINAPI     ImmGetOpenStatus( HIMC );
DWORD WINAPI    ImmGetProperty( HKL, DWORD );
UINT WINAPI     ImmGetRegisterWordStyleA( HKL, UINT, LPSTYLEBUFA );
UINT WINAPI     ImmGetRegisterWordStyleW( HKL, UINT, LPSTYLEBUFW );
BOOL WINAPI     ImmGetStatusWindowPos( HIMC, LPPOINT );
UINT WINAPI     ImmGetVirtualKey( HWND );
HKL WINAPI      ImmInstallIMEA( LPCSTR, LPCSTR );
HKL WINAPI      ImmInstallIMEW( LPCWSTR, LPCWSTR );
BOOL WINAPI     ImmIsIME( HKL );
BOOL WINAPI     ImmIsUIMessageA( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI     ImmIsUIMessageW( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI     ImmNotifyIME( HIMC, DWORD, DWORD, DWORD );
BOOL WINAPI     ImmRegisterWordA( HKL, LPCSTR, DWORD, LPCSTR );
BOOL WINAPI     ImmRegisterWordW( HKL, LPCWSTR, DWORD, LPCWSTR );
BOOL WINAPI     ImmReleaseContext( HWND, HIMC );
BOOL WINAPI     ImmSetCandidateWindow( HIMC, LPCANDIDATEFORM );
BOOL WINAPI     ImmSetCompositionFontA( HIMC, LPLOGFONTA );
BOOL WINAPI     ImmSetCompositionFontW( HIMC, LPLOGFONTW );
BOOL WINAPI     ImmSetCompositionStringA( HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD );
BOOL WINAPI     ImmSetCompositionStringW( HIMC, DWORD, LPVOID, DWORD, LPVOID, DWORD );
BOOL WINAPI     ImmSetCompositionWindow( HIMC, LPCOMPOSITIONFORM );
BOOL WINAPI     ImmSetConversionStatus( HIMC, DWORD, DWORD );
BOOL WINAPI     ImmSetOpenStatus( HIMC, BOOL );
BOOL WINAPI     ImmSetStatusWindowPos( HIMC, LPPOINT );
BOOL WINAPI     ImmSimulateHotKey( HWND, DWORD );
BOOL WINAPI     ImmUnregisterWordA( HKL, LPCSTR, DWORD, LPCSTR );
BOOL WINAPI     ImmUnregisterWordW( HKL, LPCWSTR, DWORD, LPCWSTR );
#if (WINVER >= 0x040A)
BOOL WINAPI     ImmAssociateContextEx( HWND, HIMC, DWORD );
BOOL WINAPI     ImmDisableIME( DWORD );
BOOL WINAPI     ImmDisableTextFrameService( DWORD );
BOOL WINAPI     ImmEnumInputContext( DWORD, IMCENUMPROC, LPARAM );
DWORD WINAPI    ImmGetImeMenuItemsA( HIMC, DWORD, DWORD, LPIMEMENUITEMINFOA, LPIMEMENUITEMINFOA, DWORD );
DWORD WINAPI    ImmGetImeMenuItemsW( HIMC, DWORD, DWORD, LPIMEMENUITEMINFOW, LPIMEMENUITEMINFOW, DWORD );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define ImmConfigureIME             ImmConfigureIMEW
    #define ImmEnumRegisterWord         ImmEnumRegisterWordW
    #define ImmEscape                   ImmEscapeW
    #define ImmGetCandidateList         ImmGetCandidateListW
    #define ImmGetCandidateListCount    ImmGetCandidateListCountW
    #define ImmGetCompositionFont       ImmGetCompositionFontW
    #define ImmGetCompositionString     ImmGetCompositionStringW
    #define ImmGetConversionList        ImmGetConversionListW
    #define ImmGetDescription           ImmGetDescriptionW
    #define ImmGetGuideLine             ImmGetGuideLineW
    #define ImmGetIMEFileName           ImmGetIMEFileNameW
    #define ImmGetRegisterWordStyle     ImmGetRegisterWordStyleW
    #define ImmInstallIME               ImmInstallIMEW
    #define ImmIsUIMessage              ImmIsUIMessageW
    #define ImmRegisterWord             ImmRegisterWordW
    #define ImmSetCompositionFont       ImmSetCompositionFontW
    #define ImmSetCompositionString     ImmSetCompositionStringW
    #define ImmUnregisterWord           ImmUnregisterWordW
    #if (WINVER >= 0x040A)
        #define ImmGetImeMenuItems      ImmGetImeMenuItemsW
    #endif
#else
    #define ImmConfigureIME             ImmConfigureIMEA
    #define ImmEnumRegisterWord         ImmEnumRegisterWordA
    #define ImmEscape                   ImmEscapeA
    #define ImmGetCandidateList         ImmGetCandidateListA
    #define ImmGetCandidateListCount    ImmGetCandidateListCountA
    #define ImmGetCompositionFont       ImmGetCompositionFontA
    #define ImmGetCompositionString     ImmGetCompositionStringA
    #define ImmGetConversionList        ImmGetConversionListA
    #define ImmGetDescription           ImmGetDescriptionA
    #define ImmGetGuideLine             ImmGetGuideLineA
    #define ImmGetIMEFileName           ImmGetIMEFileNameA
    #define ImmGetRegisterWordStyle     ImmGetRegisterWordStyleA
    #define ImmInstallIME               ImmInstallIMEA
    #define ImmIsUIMessage              ImmIsUIMessageA
    #define ImmRegisterWord             ImmRegisterWordA
    #define ImmSetCompositionFont       ImmSetCompositionFontA
    #define ImmSetCompositionString     ImmSetCompositionStringA
    #define ImmUnregisterWord           ImmUnregisterWordA
    #if (WINVER >= 0x040A)
        #define ImmGetImeMenuItems      ImmGetImeMenuItemsA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _IMM_ */
