/*
 *  nspapi.h    Namespace provider functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NSPAPI_INCLUDED
#define _NSPAPI_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Blob */
#ifndef _BLOB_DEFINED
#define _BLOB_DEFINED
typedef struct tagBLOB {
    ULONG   cbSize;
    BYTE    *pBlobData;
} BLOB;
typedef BLOB    *LPBLOB;
#endif /* _BLOB_DEFINED */

/* Service categories */
#define SERVICE_RESOURCE    0x00000001L
#define SERVICE_SERVICE     0x00000002L
#define SERVICE_LOCAL       0x00000004L

/* SetService() operations */
#define SERVICE_REGISTER    0x00000001L
#define SERVICE_DEREGISTER  0x00000002L
#define SERVICE_FLUSH       0x00000003L
#define SERVICE_ADD_TYPE    0x00000004L
#define SERVICE_DELETE_TYPE 0x00000005L

/* Service flags */
#define SERVICE_FLAG_DEFER  0x00000001L
#define SERVICE_FLAG_HARD   0x00000002L

/* GetService() properties */
#define PROP_COMMENT        0x00000001L
#define PROP_LOCALE         0x00000002L
#define PROP_DISPLAY_HINT   0x00000004L
#define PROP_VERSION        0x00000008L
#define PROP_START_TIME     0x00000010L
#define PROP_MACHINE        0x00000020L
#define PROP_ADDRESSES      0x00000100L
#define PROP_SD             0x00000200L
#define PROP_ALL            0x80000000L

/* Service address flags */
#define SERVICE_ADDRESS_FLAG_RPC_CN 0x00000001L
#define SERVICE_ADDRESS_FLAG_RPC_DG 0x00000002L
#define SERVICE_ADDRESS_FLAG_RPC_NB 0x00000004L

/* Namespaces */
#define NS_DEFAULT      0
#define NS_SAP          1
#define NS_NDS          2
#define NS_PEER_BROWSE  3
#define NS_TCPIP_LOCAL  10
#define NS_TCPIP_HOSTS  11
#define NS_DNS          12
#define NS_NETBT        13
#define NS_WINS         14
#define NS_NBP          20
#define NS_MS           30
#define NS_STDA         31
#define NS_NTDS         32
#define NS_X500         40
#define NS_NIS          41
#define NS_VNS          50

/* Namespace attributes */
#define NSTYPE_HIERARCHICAL 0x00000001L
#define NSTYPE_DYNAMIC      0x00000002L
#define NSTYPE_ENUMERABLE   0x00000004L
#define NSTYPE_WORKGROUP    0x00000008L

/* Transport attributes */
#define XP_CONNECTIONLESS       0x00000001L
#define XP_GUARANTEED_DELIVERY  0x00000002L
#define XP_GUARANTEED_ORDER     0x00000004L
#define XP_MESSAGE_ORIENTED     0x00000008L
#define XP_PSEUDO_STREAM        0x00000010L
#define XP_GRACEFUL_CLOSE       0x00000020L
#define XP_EXPEDITED_DATA       0x00000040L
#define XP_CONNECT_DATA         0x00000080L
#define XP_DISCONNECT_DATA      0x00000100L
#define XP_SUPPORTS_BROADCAST   0x00000200L
#define XP_SUPPORTS_MULTICAST   0x00000400L
#define XP_BANDWIDTH_ALLOCATION 0x00000800L
#define XP_FRAGMENTATION        0x00001000L
#define XP_ENCRYPTS             0x00002000L

/* GetAddressByName() resolution flags */
#define RES_SOFT_SEARCH     0x00000001L
#define RES_FIND_MULTIPLE   0x00000002L
#define RES_SERVICE         0x00000004L

/* Service type names */
#define SERVICE_TYPE_VALUE_SAPIDA       "SapId"
#define SERVICE_TYPE_VALUE_SAPIDW       L"SapId"
#define SERVICE_TYPE_VALUE_CONNA        "ConnectionOriented"
#define SERVICE_TYPE_VALUE_CONNW        L"ConnectionOriented"
#define SERVICE_TYPE_VALUE_TCPPORTA     "TcpPort"
#define SERVICE_TYPE_VALUE_TCPPORTW     L"TcpPort"
#define SERVICE_TYPE_VALUE_UDPPORTA     "UdpPort"
#define SERVICE_TYPE_VALUE_UDPPORTW     L"UdpPort"
#ifdef UNICODE
    #define SERVICE_TYPE_VALUE_SAPID    SERVICE_TYPE_VALUE_SAPIDW
    #define SERVICE_TYPE_VALUE_CONN     SERVICE_TYPE_VALUE_CONNW
    #define SERVICE_TYPE_VALUE_TCPPORT  SERVICE_TYPE_VALUE_TCPPORTW
    #define SERVICE_TYPE_VALUE_UDPPORT  SERVICE_TYPE_VALUE_UDPPORTW
#else
    #define SERVICE_TYPE_VALUE_SAPID    SERVICE_TYPE_VALUE_SAPIDA
    #define SERVICE_TYPE_VALUE_CONN     SERVICE_TYPE_VALUE_CONNA
    #define SERVICE_TYPE_VALUE_TCPPORT  SERVICE_TYPE_VALUE_TCPPORTA
    #define SERVICE_TYPE_VALUE_UDPPORT  SERVICE_TYPE_VALUE_UDPPORTA
#endif

/* SetService() status flags */
#define SET_SERVICE_PARTIAL_SUCCESS 0x00000001L

/* Namespace information */
typedef struct _NS_INFOA {
    DWORD   dwNameSpace;
    DWORD   dwNameSpaceFlags;
    LPSTR   lpNameSpace;
} NS_INFOA;
typedef NS_INFOA    *PNS_INFOA;
typedef NS_INFOA    *LPNS_INFOA;
typedef struct _NS_INFOW {
    DWORD   dwNameSpace;
    DWORD   dwNameSpaceFlags;
    LPWSTR  lpNameSpace;
} NS_INFOW;
typedef NS_INFOW    *PNS_INFOW;
typedef NS_INFOW    *LPNS_INFOW;
#ifdef UNICODE
typedef NS_INFOW    NS_INFO;
typedef PNS_INFOW   PNS_INFO;
typedef LPNS_INFOW  LPNS_INFO;
#else
typedef NS_INFOA    NS_INFO;
typedef PNS_INFOA   PNS_INFO;
typedef LPNS_INFOA  LPNS_INFO;
#endif

/* Service type value */
typedef struct _SERVICE_TYPE_VALUE {
    DWORD   dwNameSpace;
    DWORD   dwValueType;
    DWORD   dwValueSize;
    DWORD   dwValueNameOffset;
    DWORD   dwValueOffset;
} SERVICE_TYPE_VALUE;
typedef SERVICE_TYPE_VALUE  *PSERVICE_TYPE_VALUE;
typedef SERVICE_TYPE_VALUE  *LPSERVICE_TYPE_VALUE;

/* Absolute service type value */
typedef struct _SERVICE_TYPE_VALUE_ABSA {
    DWORD   dwNameSpace;
    DWORD   dwValueType;
    DWORD   dwValueSize;
    LPSTR   lpValueName;
    PVOID   lpValue;
} SERVICE_TYPE_VALUE_ABSA;
typedef SERVICE_TYPE_VALUE_ABSA     *PSERVICE_TYPE_VALUE_ABSA;
typedef SERVICE_TYPE_VALUE_ABSA     *LPSERVICE_TYPE_VALUE_ABSA;
typedef struct _SERVICE_TYPE_VALUE_ABSW {
    DWORD   dwNameSpace;
    DWORD   dwValueType;
    DWORD   dwValueSize;
    LPWSTR  lpValueName;
    PVOID   lpValue;
} SERVICE_TYPE_VALUE_ABSW;
typedef SERVICE_TYPE_VALUE_ABSW     *PSERVICE_TYPE_VALUE_ABSW;
typedef SERVICE_TYPE_VALUE_ABSW     *LPSERVICE_TYPE_VALUE_ABSW;
#ifdef UNICODE
typedef SERVICE_TYPE_VALUE_ABSW     SERVICE_TYPE_VALUE_ABS;
typedef PSERVICE_TYPE_VALUE_ABSW    PSERVICE_TYPE_VALUE_ABS;
typedef LPSERVICE_TYPE_VALUE_ABSW   LPSERVICE_TYPE_VALUE_ABS;
#else
typedef SERVICE_TYPE_VALUE_ABSA     SERVICE_TYPE_VALUE_ABS;
typedef PSERVICE_TYPE_VALUE_ABSA    PSERVICE_TYPE_VALUE_ABS;
typedef LPSERVICE_TYPE_VALUE_ABSA   LPSERVICE_TYPE_VALUE_ABS;
#endif

/* Service type information */
typedef struct _SERVICE_TYPE_INFO {
    DWORD               dwTypeNameOffset;
    DWORD               dwValueCount;
    SERVICE_TYPE_VALUE  Values[1];
} SERVICE_TYPE_INFO;
typedef SERVICE_TYPE_INFO   *PSERVICE_TYPE_INFO;
typedef SERVICE_TYPE_INFO   *LPSERVICE_TYPE_INFO;

/* Absolute service type information */
typedef struct _SERVICE_TYPE_INFO_ABSA {
    LPSTR                   lpTypeName;
    DWORD                   dwValueCount;
    SERVICE_TYPE_VALUE_ABSA Values[1];
} SERVICE_TYPE_INFO_ABSA;
typedef SERVICE_TYPE_INFO_ABSA      *PSERVICE_TYPE_INFO_ABSA;
typedef SERVICE_TYPE_INFO_ABSA      *LPSERVICE_TYPE_INFO_ABSA;
typedef struct _SERVICE_TYPE_INFO_ABSW {
    LPWSTR                  lpTypeName;
    DWORD                   dwValueCount;
    SERVICE_TYPE_VALUE_ABSW Values[1];
} SERVICE_TYPE_INFO_ABSW;
typedef SERVICE_TYPE_INFO_ABSW      *PSERVICE_TYPE_INFO_ABSW;
typedef SERVICE_TYPE_INFO_ABSW      *LPSERVICE_TYPE_INFO_ABSW;
#ifdef UNICODE
typedef SERVICE_TYPE_INFO_ABSW      SERVICE_TYPE_INFO_ABS;
typedef PSERVICE_TYPE_INFO_ABSW     PSERVICE_TYPE_INFO_ABS;
typedef LPSERVICE_TYPE_INFO_ABSW    LPSERVICE_TYPE_INFO_ABS;
#else
typedef SERVICE_TYPE_INFO_ABSA      SERVICE_TYPE_INFO_ABS;
typedef PSERVICE_TYPE_INFO_ABSA     PSERVICE_TYPE_INFO_ABS;
typedef LPSERVICE_TYPE_INFO_ABSA    LPSERVICE_TYPE_INFO_ABS;
#endif

/* Service address */
typedef struct _SERVICE_ADDRESS {
    DWORD   dwAddressType;
    DWORD   dwAddressFlags;
    DWORD   dwAddressLength;
    DWORD   dwPrincipalLength;
    BYTE    *lpAddress;
    BYTE    *lpPrincipal;
} SERVICE_ADDRESS;
typedef SERVICE_ADDRESS *PSERVICE_ADDRESS;
typedef SERVICE_ADDRESS *LPSERVICE_ADDRESS;

/* Service addresses */
typedef struct _SERVICE_ADDRESSES {
    DWORD           dwAddressCount;
    SERVICE_ADDRESS Addresses[1];
} SERVICE_ADDRESSES;
typedef SERVICE_ADDRESSES   *PSERVICE_ADDRESSES;
typedef SERVICE_ADDRESSES   *LPSERVICE_ADDRESSES;

/* Service information */
typedef struct _SERVICE_INFOA {
    LPGUID              lpServiceType;
    LPSTR               lpServiceName;
    LPSTR               lpComment;
    LPSTR               lpLocale;
    DWORD               dwDisplayHint;
    DWORD               dwVersion;
    DWORD               dwTime;
    LPSTR               lpMachineName;
    LPSERVICE_ADDRESSES lpServiceAddress;
    BLOB                ServiceSpecificInfo;
} SERVICE_INFOA;
typedef SERVICE_INFOA   *PSERVICE_INFOA;
typedef SERVICE_INFOA   *LPSERVICE_INFOA;
typedef struct _SERVICE_INFOW {
    LPGUID              lpServiceType;
    LPWSTR              lpServiceName;
    LPWSTR              lpComment;
    LPWSTR              lpLocale;
    DWORD               dwDisplayHint;
    DWORD               dwVersion;
    DWORD               dwTime;
    LPWSTR              lpMachineName;
    LPSERVICE_ADDRESSES lpServiceAddress;
    BLOB                ServiceSpecificInfo;
} SERVICE_INFOW;
typedef SERVICE_INFOW   *PSERVICE_INFOW;
typedef SERVICE_INFOW   *LPSERVICE_INFOW;
#ifdef UNICODE
typedef SERVICE_INFOW   SERVICE_INFO;
typedef PSERVICE_INFOW  PSERVICE_INFO;
typedef LPSERVICE_INFOW LPSERVICE_INFO;
#else
typedef SERVICE_INFOA   SERVICE_INFO;
typedef PSERVICE_INFOA  PSERVICE_INFO;
typedef LPSERVICE_INFOA LPSERVICE_INFO;
#endif

/* Namespace service information */
typedef struct _NS_SERVICE_INFOA {
    DWORD           dwNameSpace;
    SERVICE_INFOA   ServiceInfo;
} NS_SERVICE_INFOA;
typedef NS_SERVICE_INFOA    *PNS_SERVICE_INFOA;
typedef NS_SERVICE_INFOA    *LPNS_SERVICE_INFOA;
typedef struct _NS_SERVICE_INFOW {
    DWORD           dwNameSpace;
    SERVICE_INFOW   ServiceInfo;
} NS_SERVICE_INFOW;
typedef NS_SERVICE_INFOW    *PNS_SERVICE_INFOW;
typedef NS_SERVICE_INFOW    *LPNS_SERVICE_INFOW;
#ifdef UNICODE
typedef NS_SERVICE_INFOW    NS_SERVICE_INFO;
typedef PNS_SERVICE_INFOW   PNS_SERVICE_INFO;
typedef LPNS_SERVICE_INFOW  LPNS_SERVICE_INFO;
#else
typedef NS_SERVICE_INFOA    NS_SERVICE_INFO;
typedef PNS_SERVICE_INFOA   PNS_SERVICE_INFO;
typedef LPNS_SERVICE_INFOA  LPNS_SERVICE_INFO;
#endif

/* Socket address */
typedef struct _SOCKET_ADDRESS {
    LPSOCKADDR  lpSockaddr;
    INT         iSockaddrLength;
} SOCKET_ADDRESS;
typedef SOCKET_ADDRESS  *PSOCKET_ADDRESS;
typedef SOCKET_ADDRESS  *LPSOCKET_ADDRESS;

/* CSAddr information */
typedef struct _CSADDR_INFO {
    SOCKET_ADDRESS  LocalAddr;
    SOCKET_ADDRESS  RemoteAddr;
    INT             iSocketType;
    INT             iProtocol;
} CSADDR_INFO;
typedef CSADDR_INFO *PCSADDR_INFO;
typedef CSADDR_INFO *LPCSADDR_INFO;

/* Protocol information */
typedef struct _PROTOCOL_INFOA {
    DWORD   dwServiceFlags;
    INT     iAddressFamily;
    INT     iMaxSockAddr;
    INT     iMinSockAddr;
    INT     iSocketType;
    INT     iProtocol;
    DWORD   dwMessageSize;
    LPSTR   lpProtocols;
} PROTOCOL_INFOA;
typedef PROTOCOL_INFOA      *PPROTOCOL_INFOA;
typedef PROTOCOL_INFOA      *LPPROTOCOL_INFOA;
typedef struct _PROTOCOL_INFOW {
    DWORD   dwServiceFlags;
    INT     iAddressFamily;
    INT     iMaxSockAddr;
    INT     iMinSockAddr;
    INT     iSocketType;
    INT     iProtocol;
    DWORD   dwMessageSize;
    LPWSTR  lpProtocols;
} PROTOCOL_INFOW;
typedef PROTOCOL_INFOW      *PPROTOCOL_INFOW;
typedef PROTOCOL_INFOW      *LPPROTOCOL_INFOW;
#ifdef UNICODE
typedef PROTOCOL_INFOW      PROTOCOL_INFO;
typedef PPROTOCOL_INFOW     PPROTOCOL_INFO;
typedef LPPROTOCOL_INFOW    LPPROTOCOL_INFO;
#else
typedef PROTOCOL_INFOA      PROTOCOL_INFO;
typedef PPROTOCOL_INFOA     PPROTOCOL_INFO;
typedef LPPROTOCOL_INFOA    LPPROTOCOL_INFO;
#endif

/* Network resource information (version 2) */
typedef struct _NETRESOURCE2A {
    DWORD   dwScope;
    DWORD   dwType;
    DWORD   dwUsage;
    DWORD   dwDisplayType;
    LPSTR   lpLocalName;
    LPSTR   lpRemoteName;
    LPSTR   lpComment;
    NS_INFO ns_info;
    GUID    ServiceType;
    DWORD   dwProtocols;
    LPINT   lpiProtocols;
} NETRESOURCE2A;
typedef NETRESOURCE2A   *PNETRESOURCE2A;
typedef NETRESOURCE2A   *LPNETRESOURCE2A;
typedef struct _NETRESOURCE2W {
    DWORD   dwScope;
    DWORD   dwType;
    DWORD   dwUsage;
    DWORD   dwDisplayType;
    LPWSTR  lpLocalName;
    LPWSTR  lpRemoteName;
    LPWSTR  lpComment;
    NS_INFO ns_info;
    GUID    ServiceType;
    DWORD   dwProtocols;
    LPINT   lpiProtocols;
} NETRESOURCE2W;
typedef NETRESOURCE2W   *PNETRESOURCE2W;
typedef NETRESOURCE2W   *LPNETRESOURCE2W;
#ifdef UNICODE
typedef NETRESOURCE2W   NETRESOURCE2;
typedef PNETRESOURCE2W  PNETRESOURCE2;
typedef LPNETRESOURCE2W LPNETRESOURCE2;
#else
typedef NETRESOURCE2A   NETRESOURCE2;
typedef PNETRESOURCE2A  PNETRESOURCE2;
typedef LPNETRESOURCE2A LPNETRESOURCE2;
#endif

/* Namespace provider callback functions */
typedef DWORD (*LPFN_NSPAPI)( VOID );
typedef VOID (*LPSERVICE_CALLBACK_PROC)( LPARAM, HANDLE );

/* Service asynchronous information */
typedef struct _SERVICE_ASYNC_INFO {
    LPSERVICE_CALLBACK_PROC lpServiceCallbackProc;
    LPARAM                  lParam;
    HANDLE                  hAsyncTaskHandle;
} SERVICE_ASYNC_INFO;
typedef SERVICE_ASYNC_INFO  *PSERVICE_ASYNC_INFO;
typedef SERVICE_ASYNC_INFO  *LPSERVICE_ASYNC_INFO;

/* Functions in WSOC32.DLL and MSWSOCK.DLL */
INT APIENTRY    EnumProtocolsA( LPINT, LPVOID, LPDWORD );
INT APIENTRY    EnumProtocolsW( LPINT, LPVOID, LPDWORD );
INT APIENTRY    GetAddressByNameA( DWORD, LPGUID, LPSTR, LPINT, DWORD, LPSERVICE_ASYNC_INFO, LPVOID, LPDWORD, LPSTR, LPDWORD );
INT APIENTRY    GetAddressByNameW( DWORD, LPGUID, LPWSTR, LPINT, DWORD, LPSERVICE_ASYNC_INFO, LPVOID, LPDWORD, LPWSTR, LPDWORD );
INT APIENTRY    GetNameByTypeA( LPGUID, LPSTR, DWORD );
INT APIENTRY    GetNameByTypeW( LPGUID, LPWSTR, DWORD );
INT APIENTRY    GetServiceA( DWORD, LPGUID, LPSTR, DWORD, LPVOID, LPDWORD, LPSERVICE_ASYNC_INFO );
INT APIENTRY    GetServiceW( DWORD, LPGUID, LPWSTR, DWORD, LPVOID, LPDWORD, LPSERVICE_ASYNC_INFO );
INT APIENTRY    GetTypeByNameA( LPSTR, LPGUID );
INT APIENTRY    GetTypeByNameW( LPWSTR, LPGUID );
INT APIENTRY    SetServiceA( DWORD, DWORD, DWORD, LPSERVICE_INFOA, LPSERVICE_ASYNC_INFO, LPDWORD );
INT APIENTRY    SetServiceW( DWORD, DWORD, DWORD, LPSERVICE_INFOW, LPSERVICE_ASYNC_INFO, LPDWORD );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define EnumProtocols       EnumProtocolsW
    #define GetAddressByName    GetAddressByNameW
    #define GetNameByType       GetNameByTypeW
    #define GetService          GetServiceW
    #define GetTypeByName       GetTypeByNameW
    #define SetService          SetServiceW
#else
    #define EnumProtocols       EnumProtocolsA
    #define GetAddressByName    GetAddressByNameA
    #define GetNameByType       GetNameByTypeA
    #define GetService          GetServiceA
    #define GetTypeByName       GetTypeByNameA
    #define SetService          SetServiceA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NSPAPI_INCLUDED */
