/*
 *  oaidl.h     OLE automation interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __oaidl_h__
#define __oaidl_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <objidl.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IDispatch     IDispatch;
typedef interface IRecordInfo   IRecordInfo;
typedef interface ITypeComp     ITypeComp;
typedef interface ITypeInfo     ITypeInfo;
typedef interface ITypeLib      ITypeLib;

/* Primitive data types for automation */
typedef LONG    DISPID;
typedef DISPID  MEMBERID;
typedef DWORD   HREFTYPE;

/* Safe array features */
#define FADF_AUTO           0x0001
#define FADF_STATIC         0x0002
#define FADF_EMBEDDED       0x0004
#define FADF_FIXEDSIZE      0x0010
#define FADF_RECORD         0x0020
#define FADF_HAVEIID        0x0040
#define FADF_HAVEVARTYPE    0x0080
#define FADF_BSTR           0x0100
#define FADF_UNKNOWN        0x0200
#define FADF_DISPATCH       0x0400
#define FADF_VARIANT        0x0800

/* Parameter flags */
#define PARAMFLAG_NONE          0x0000
#define PARAMFLAG_FIN           0x0001
#define PARAMFLAG_FOUT          0x0002
#define PARAMFLAG_FLCID         0x0004
#define PARAMFLAG_FRETVAL       0x0008
#define PARAMFLAG_FOPT          0x0010
#define PARAMFLAG_FHASDEFAULT   0x0020
#define PARAMFLAG_FHASCUSTDATA  0x0040

/* IDL flags */
#define IDLFLAG_NONE    PARAMFLAG_NONE
#define IDLFLAG_FIN     PARAMFLAG_FIN
#define IDLFLAG_FOUT    PARAMFLAG_FOUT
#define IDLFLAG_FLCID   PARAMFLAG_FLCID
#define IDLFLAG_FRETVAL PARAMFLAG_FRETVAL

/* Implementation type flags */
#define IMPLTYPEFLAG_FDEFAULT       0x0001
#define IMPLTYPEFLAG_FSOURCE        0x0002
#define IMPLTYPEFLAG_FRESTRICTED    0x0004
#define IMPLTYPEFLAG_FDEFAULTVTABLE 0x0008

/* Dispatch identifier special values */
#define DISPID_UNKNOWN      (-1)
#define DISPID_VALUE        0
#define DISPID_PROPERTYPUT  (-3)
#define DISPID_NEWENUM      (-4)
#define DISPID_EVALUATE     (-5)
#define DISPID_CONSTRUCTOR  (-6)
#define DISPID_DESTRUCTOR   (-7)
#define DISPID_COLLECT      (-8)

/* Currency data type */
typedef CY  CURRENCY;

/* Safe array bound */
typedef struct tagSAFEARRAYBOUND {
    ULONG   cElements;
    LONG    lLbound;
} SAFEARRAYBOUND;
typedef SAFEARRAYBOUND  *LPSAFEARRAYBOUND;

/* Safe array types */
typedef enum tagSF_TYPE {
    SF_ERROR    = VT_ERROR,
    SF_I1       = VT_I1,
    SF_I2       = VT_I2,
    SF_I4       = VT_I4,
    SF_I8       = VT_I8,
    SF_BSTR     = VT_BSTR,
    SF_UNKNOWN  = VT_UNKNOWN,
    SF_DISPATCH = VT_DISPATCH,
    SF_VARIANT  = VT_VARIANT,
    SF_RECORD   = VT_RECORD,
    SF_HAVEIID  = (VT_UNKNOWN | VT_RESERVED)
} SF_TYPE;

/* Safe array */
typedef struct tagSAFEARRAY {
    USHORT          cDims;
    USHORT          fFeatures;
    ULONG           cbElements;
    ULONG           cLocks;
    PVOID           pvData;
    SAFEARRAYBOUND  rgsabound[1];
} SAFEARRAY;
typedef SAFEARRAY   *LPSAFEARRAY;

/* Variant */
#if (__STDC__ && !defined( _FORCENAMELESSUNION )) || defined( NONAMELESSUNION )
    #define __VARIANT_NAME_1    n1
    #define __VARIANT_NAME_2    n2
    #define __VARIANT_NAME_3    n3
    #define __VARIANT_NAME_4    brecVal
#else
    #define __tagVARIANT
    #define __VARIANT_NAME_1
    #define __VARIANT_NAME_2
    #define __VARIANT_NAME_3
    #define __VARIANT_NAME_4
    #define __tagBRECORD
#endif
typedef struct tagVARIANT {
    union {
        struct __tagVARIANT {
            VARTYPE vt;
            WORD    wReserved1;
            WORD    wReserved2;
            WORD    wReserved3;
            union {
                LONGLONG            llVal;
                LONG                lVal;
                BYTE                bVal;
                SHORT               iVal;
                FLOAT               fltVal;
                DOUBLE              dblVal;
                VARIANT_BOOL        boolVal;
                SCODE               scode;
                CY                  cyVal;
                DATE                date;
                BSTR                bstrVal;
                IUnknown            *punkVal;
                IDispatch           *pdispVal;
                SAFEARRAY           *parray;
                BYTE                *pbVal;
                SHORT               *piVal;
                LONG                *plVal;
                LONGLONG            *pllVal;
                FLOAT               *pfltVal;
                DOUBLE              *pdblVal;
                VARIANT_BOOL        *pboolVal;
                SCODE               *pscode;
                CY                  *pcyVal;
                DATE                *pdate;
                BSTR                *pbstrVal;
                IUnknown            **ppunkVal;
                IDispatch           **ppdispVal;
                SAFEARRAY           **pparray;
                struct tagVARIANT   *pvarVal;
                PVOID               byref;
                CHAR                cVal;
                USHORT              uiVal;
                ULONG               ulVal;
                ULONGLONG           ullVal;
                INT                 intVal;
                UINT                uintVal;
                DECIMAL             *pdecVal;
                CHAR                *pcVal;
                USHORT              *puiVal;
                ULONG               *pulVal;
                ULONGLONG           *pullVal;
                INT                 *pintVal;
                UINT                *puintVal;
                struct __tagBRECORD {
                    PVOID       pvRecord;
                    IRecordInfo *pRecInfo;
                } __VARIANT_NAME_4;
            } __VARIANT_NAME_3;
        } __VARIANT_NAME_2;
        DECIMAL decVal;
    } __VARIANT_NAME_1;
} VARIANT;
typedef VARIANT *LPVARIANT;
typedef VARIANT VARIANTARG;
typedef VARIANT *LPVARIANTARG;
#ifdef __cplusplus
    #define REFVARIANT  const VARIANT &
#else
    #define REFVARIANT  const VARIANT *const
#endif

/* Type kinds */
typedef enum tagTYPEKIND {
    TKIND_ENUM      = 0,
    TKIND_RECORD    = 1,
    TKIND_MODULE    = 2,
    TKIND_INTERFACE = 3,
    TKIND_DISPATCH  = 4,
    TKIND_COCLASS   = 5,
    TKIND_ALIAS     = 6,
    TKIND_UNION     = 7,
    TKIND_MAX       = 8
} TYPEKIND;

/* Type descriptor */
typedef struct tagTYPEDESC {
    union {
        struct tagTYPEDESC  *lptdesc;
        struct tagARRAYDESC *lpadesc;
        HREFTYPE            hreftype;
    };
    VARTYPE vt;
} TYPEDESC;

/* Array descriptor */
typedef struct tagARRAYDESC {
    TYPEDESC        tdescElem;
    USHORT          cDims;
    SAFEARRAYBOUND  rgbounds[1];
} ARRAYDESC;

/* Parameter descriptor (extended version) */
typedef struct tagPARAMDESCEX {
    ULONG       cBytes;
    VARIANTARG  varDefaultValue;
} PARAMDESCEX;
typedef PARAMDESCEX *LPPARAMDESCEX;

/* Parameter descriptor */
typedef struct tagPARAMDESC {
    LPPARAMDESCEX   pparamdescex;
    USHORT          wParamFlags;
} PARAMDESC;
typedef PARAMDESC   *LPPARAMDESC;

/* IDL descriptor */
typedef struct tagIDLDESC {
    ULONG_PTR   dwReserved;
    USHORT      wIDLFlags;
} IDLDESC;
typedef IDLDESC *LPIDLDESC;

/* Element descriptor */
typedef struct tagELEMDESC {
    TYPEDESC    tdesc;
    union {
        IDLDESC     idldesc;
        PARAMDESC   paramdesc;
    };
} ELEMDESC;
typedef ELEMDESC    *LPELEMDESC;

/* Type attributes */
typedef struct tagTYPEATTR {
    GUID        guid;
    LCID        lcid;
    DWORD       dwReserved;
    MEMBERID    memidConstructor;
    MEMBERID    memidDestructor;
    LPOLESTR    lpstrSchema;
    ULONG       cbSizeInstance;
    TYPEKIND    typekind;
    WORD        cFuncs;
    WORD        cVars;
    WORD        cImplTypes;
    WORD        cbSizeVft;
    WORD        cbAlignment;
    WORD        wTypeFlags;
    WORD        wMajorVerNum;
    WORD        wMinorVerNum;
    TYPEDESC    tdescAlias;
    IDLDESC     idldescType;
} TYPEATTR;
typedef TYPEATTR    *LPTYPEATTR;

/* Dispatch parameters */
typedef struct tagDISPPARAMS {
    VARIANTARG  *rgvarg;
    DISPID      *rgdispidNamedArgs;
    UINT        cArgs;
    UINT        cNamedArgs;
} DISPPARAMS;

/* Exception information */
typedef struct tagEXCEPINFO {
    WORD    wCode;
    WORD    wReserved;
    BSTR    bstrSource;
    BSTR    bstrDescription;
    BSTR    bstrHelpFile;
    DWORD   dwHelpContext;
    PVOID   pvReserved;
    HRESULT (__stdcall *pfnDeferredFillIn)( struct tagEXCEPINFO * );
    SCODE   scode;
} EXCEPINFO;
typedef EXCEPINFO   *LPEXCEPINFO;

/* Calling conventions */
typedef enum tagCALLCONV {
    CC_FASTCALL     = 0,
    CC_CDECL        = 1,
    CC_MSCPASCAL    = 2,
    CC_PASCAL       = CC_MSCPASCAL,
    CC_MACPASCAL    = 3,
    CC_STDCALL      = 4,
    CC_FPFASTCALL   = 5,
    CC_SYSCALL      = 6,
    CC_MPWCDECL     = 7,
    CC_MPWPASCAL    = 8,
    CC_MAX          = 9
} CALLCONV;

/* Function kinds */
typedef enum tagFUNCKIND {
    FUNC_VIRTUAL        = 0,
    FUNC_PUREVIRTUAL    = 1,
    FUNC_NONVIRTUAL     = 2,
    FUNC_STATIC         = 3,
    FUNC_DISPATCH       = 4
} FUNCKIND;

/* Invoke kinds */
typedef enum tagINVOKEKIND {
    INVOKE_FUNC             = 1,
    INVOKE_PROPERTYGET      = 2,
    INVOKE_PROPERTYPUT      = 4,
    INVOKE_PROPERTYPUTREF   = 8
} INVOKEKIND;

/* Function descriptor */
typedef struct tagFUNCDESC {
    MEMBERID    memid;
    SCODE       *lprgscode;
    ELEMDESC    *lprgelemdescParam;
    FUNCKIND    funckind;
    INVOKEKIND  invkind;
    CALLCONV    callconv;
    SHORT       cParams;
    SHORT       cParamsOpt;
    SHORT       oVft;
    SHORT       cScodes;
    ELEMDESC    elemdescFunc;
    WORD        wFuncFlags;
} FUNCDESC;
typedef FUNCDESC    *LPFUNCDESC;

/* Variable kinds */
typedef enum tagVARKIND {
    VAR_PERINSTANCE = 0,
    VAR_STATIC      = 1,
    VAR_CONST       = 2,
    VAR_DISPATCH    = 3
} VARKIND;

/* Variable descriptor */
typedef struct tagVARDESC {
    MEMBERID    memid;
    LPOLESTR    lpstrSchema;
    union {
        ULONG   oInst;
        VARIANT *lpvarValue;
    };
    ELEMDESC    elemdescVar;
    WORD        wVarFlags;
    VARKIND     varkind;
} VARDESC;
typedef VARDESC *LPVARDESC;

/* Type flags */
typedef enum tagTYPEFLAGS {
    TYPEFLAG_FAPPOBJECT     = 0x0001,
    TYPEFLAG_FCANCREATE     = 0x0002,
    TYPEFLAG_FLICENSED      = 0x0004,
    TYPEFLAG_FPREDECLID     = 0x0008,
    TYPEFLAG_FHIDDEN        = 0x0010,
    TYPEFLAG_FCONTROL       = 0x0020,
    TYPEFLAG_FDUAL          = 0x0040,
    TYPEFLAG_FNONEXTENSIBLE = 0x0080,
    TYPEFLAG_FOLEAUTOMATION = 0x0100,
    TYPEFLAG_FRESTRICTED    = 0x0200,
    TYPEFLAG_FAGGREGATABLE  = 0x0400,
    TYPEFLAG_FREPLACEABLE   = 0x0800,
    TYPEFLAG_FDISPATCHABLE  = 0x1000,
    TYPEFLAG_FREVERSEBIND   = 0x2000,
    TYPEFLAG_FPROXY         = 0x4000
} TYPEFLAGS;

/* Function flags */
typedef enum tagFUNCFLAGS {
    FUNCFLAG_FRESTRICTED        = 0x0001,
    FUNCFLAG_FSOURCE            = 0x0002,
    FUNCFLAG_FBINDABLE          = 0x0004,
    FUNCFLAG_FREQUESTEDIT       = 0x0008,
    FUNCFLAG_FDISPLAYBIND       = 0x0010,
    FUNCFLAG_FDEFAULTBIND       = 0x0020,
    FUNCFLAG_FHIDDEN            = 0x0040,
    FUNCFLAG_FUSESGETLASTERROR  = 0x0080,
    FUNCFLAG_FDEFAULTCOLLELEM   = 0x0100,
    FUNCFLAG_FUIDEFAULT         = 0x0200,
    FUNCFLAG_FNONBROWSABLE      = 0x0400,
    FUNCFLAG_FREPLACEABLE       = 0x0800,
    FUNCFLAG_FIMMEDIATEBIND     = 0x1000
} FUNCFLAG;

/* Variable flags */
typedef enum tagVARFLAGS {
    VARFLAG_FREADONLY           = 0x0001,
    VARFLAG_FSOURCE             = 0x0002,
    VARFLAG_FBINDABLE           = 0x0004,
    VARFLAG_FREQUESTEDIT        = 0x0008,
    VARFLAG_FDISPLAYBIND        = 0x0010,
    VARFLAG_FDEFAULTBIND        = 0x0020,
    VARFLAG_FHIDDEN             = 0x0040,
    VARFLAG_FRESTRICTED         = 0x0080,
    VARFLAG_FDEFAULTCOLLELEM    = 0x0100,
    VARFLAG_FUIDEFAULT          = 0x0200,
    VARFLAG_FNONBROWSABLE       = 0x0400,
    VARFLAG_FREPLACEABLE        = 0x0800,
    VARFLAG_FIMMEDIATEBIND      = 0x1000,
} VARFLAGS;

/* Clean local storage */
typedef struct tagCLEANLOCALSTORAGE {
    IUnknown    *pInterface;
    PVOID       pStorage;
    DWORD       flags;
} CLEANLOCALSTORAGE;

/* Custom data item */
typedef struct tagCUSTDATAITEM {
    GUID        guid;
    VARIANTARG  varValue;
} CUSTDATAITEM;
typedef CUSTDATAITEM    *LPCUSTDATAITEM;

/* Custom data */
typedef struct tagCUSTDATA {
    DWORD           cCustData;
    LPCUSTDATAITEM  prgCustData;
} CUSTDATA;
typedef CUSTDATA    *LPCUSTDATA;

/* Descriptor kinds */
typedef enum tagDESCKIND {
    DESCKIND_NONE           = 0,
    DESCKIND_FUNCDESC       = 1,
    DESCKIND_VARDESC        = 2,
    DESCKIND_TYPECOMP       = 3,
    DESCKIND_IMPLICITAPPOBJ = 4,
    DESCKIND_MAX            = 5
} DESCKIND;

/* Bind pointer */
typedef struct tagBINDPTR {
    FUNCDESC    *lpfuncdesc;
    VARDESC     *lpvardesc;
    ITypeComp   *lptcomp;
} BINDPTR;
typedef BINDPTR *LPBINDPTR;

/* System kinds */
typedef enum tagSYSKIND {
    SYS_WIN16   = 0,
    SYS_WIN32   = 1,
    SYS_MAC     = 2,
    SYS_WIN64   = 3
} SYSKIND;

/* Library flags */
typedef enum tagLIBFLAGS {
    LIBFLAG_FRESTRICTED     = 0x0001,
    LIBFLAG_FCONTROL        = 0x0002,
    LIBFLAG_FHIDDEN         = 0x0004,
    LIBFLAG_FHASDISKIMAGE   = 0x0008
} LIBFLAGS;

/* Type library attribute */
typedef struct tagTLIBATTR {
    GUID    guid;
    LCID    lcid;
    SYSKIND syskind;
    WORD    wMajorVerNum;
    WORD    wMinorVerNum;
    WORD    wLibFlags;
} TLIBATTR;
typedef TLIBATTR    *LPTLIBATTR;

/* Change kinds */
typedef enum tagCHANGEKIND {
    CHANGEKIND_ADDMEMBER        = 0,
    CHANGEKIND_DELETEMEMBER     = 1,
    CHANGEKIND_SETNAMES         = 2,
    CHANGEKIND_SETDOCUMENTATION = 3,
    CHANGEKIND_GENERAL          = 4,
    CHANGEKIND_INVALIDATE       = 5,
    CHANGEKIND_CHANGEFAILED     = 6,
    CHANGEKIND_MAX              = 7
} CHANGEKIND;

/* ICreateTypeInfo interface */
#undef INTERFACE
#define INTERFACE   ICreateTypeInfo
DECLARE_INTERFACE_( ICreateTypeInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICreateTypeInfo methods */
    STDMETHOD( SetGuid )( THIS_ REFGUID ) PURE;
    STDMETHOD( SetTypeFlags )( THIS_ UINT ) PURE;
    STDMETHOD( SetDocString )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpContext )( THIS_ DWORD ) PURE;
    STDMETHOD( SetVersion )( THIS_ WORD, WORD ) PURE;
    STDMETHOD( AddRefTypeInfo )( THIS_ ITypeInfo *, HREFTYPE * ) PURE;
    STDMETHOD( AddFuncDesc )( THIS_ UINT, FUNCDESC * ) PURE;
    STDMETHOD( AddImplType )( THIS_ UINT, HREFTYPE ) PURE;
    STDMETHOD( SetImplTypeFlags )( THIS_ UINT, INT ) PURE;
    STDMETHOD( SetAlignment )( THIS_ WORD ) PURE;
    STDMETHOD( SetSchema )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( AddVarDesc )( THIS_ UINT, VARDESC * ) PURE;
    STDMETHOD( SetFuncAndParamNames )( THIS_ UINT, LPOLESTR *, UINT ) PURE;
    STDMETHOD( SetVarName )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetTypeDescAlias )( THIS_ TYPEDESC * ) PURE;
    STDMETHOD( DefineFuncAsDllEntry )( THIS_ UINT, LPOLESTR, LPOLESTR ) PURE;
    STDMETHOD( SetFuncDocString )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetVarDocString )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetFuncHelpContext )( THIS_ UINT, DWORD ) PURE;
    STDMETHOD( SetVarHelpContext )( THIS_ UINT, DWORD ) PURE;
    STDMETHOD( SetMops )( THIS_ UINT, BSTR ) PURE;
    STDMETHOD( SetTypeIdlDesc )( THIS_ IDLDESC * ) PURE;
    STDMETHOD( LayOut )( THIS ) PURE;
};
typedef ICreateTypeInfo *LPCREATETYPEINFO;

/* ICreateTypeInfo2 interface */
#undef INTERFACE
#define INTERFACE   ICreateTypeInfo2
DECLARE_INTERFACE_( ICreateTypeInfo2, ICreateTypeInfo ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICreateTypeInfo methods */
    STDMETHOD( SetGuid )( THIS_ REFGUID ) PURE;
    STDMETHOD( SetTypeFlags )( THIS_ UINT ) PURE;
    STDMETHOD( SetDocString )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpContext )( THIS_ DWORD ) PURE;
    STDMETHOD( SetVersion )( THIS_ WORD, WORD ) PURE;
    STDMETHOD( AddRefTypeInfo )( THIS_ ITypeInfo *, HREFTYPE * ) PURE;
    STDMETHOD( AddFuncDesc )( THIS_ UINT, FUNCDESC * ) PURE;
    STDMETHOD( AddImplType )( THIS_ UINT, HREFTYPE ) PURE;
    STDMETHOD( SetImplTypeFlags )( THIS_ UINT, INT ) PURE;
    STDMETHOD( SetAlignment )( THIS_ WORD ) PURE;
    STDMETHOD( SetSchema )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( AddVarDesc )( THIS_ UINT, VARDESC * ) PURE;
    STDMETHOD( SetFuncAndParamNames )( THIS_ UINT, LPOLESTR *, UINT ) PURE;
    STDMETHOD( SetVarName )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetTypeDescAlias )( THIS_ TYPEDESC * ) PURE;
    STDMETHOD( DefineFuncAsDllEntry )( THIS_ UINT, LPOLESTR, LPOLESTR ) PURE;
    STDMETHOD( SetFuncDocString )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetVarDocString )( THIS_ UINT, LPOLESTR ) PURE;
    STDMETHOD( SetFuncHelpContext )( THIS_ UINT, DWORD ) PURE;
    STDMETHOD( SetVarHelpContext )( THIS_ UINT, DWORD ) PURE;
    STDMETHOD( SetMops )( THIS_ UINT, BSTR ) PURE;
    STDMETHOD( SetTypeIdlDesc )( THIS_ IDLDESC * ) PURE;
    STDMETHOD( LayOut )( THIS ) PURE;
    
    /* ICreateTypeInfo2 methods */
    STDMETHOD( DeleteFuncDesc )( THIS_ UINT ) PURE;
    STDMETHOD( DeleteFuncDescByMemId )( THIS_ MEMBERID, INVOKEKIND ) PURE;
    STDMETHOD( DeleteVarDesc )( THIS_ UINT ) PURE;
    STDMETHOD( DeleteVarDescByMemId )( THIS_ MEMBERID ) PURE;
    STDMETHOD( DeleteImplType )( THIS_ UINT ) PURE;
    STDMETHOD( SetCustData )( THIS_ REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetFuncCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetParamCustData )( THIS_ UINT, UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetVarCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetImplTypeCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetHelpStringContext )( THIS_ ULONG ) PURE;
    STDMETHOD( SetFuncHelpStringContext )( THIS_ UINT, ULONG ) PURE;
    STDMETHOD( SetVarHelpStringContext )( THIS_ UINT, ULONG ) PURE;
    STDMETHOD( Invalidate )( THIS ) PURE;
    STDMETHOD( SetName )( THIS_ LPOLESTR ) PURE;
};
typedef ICreateTypeInfo2    *LPCREATETYPEINFO2;

/* ICreateTypeLib interface */
#undef INTERFACE
#define INTERFACE   ICreateTypeLib
DECLARE_INTERFACE_( ICreateTypeLib, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICreateTypeLib methods */
    STDMETHOD( CreateTypeInfo )( THIS_ LPOLESTR, TYPEKIND, ICreateTypeInfo ** ) PURE;
    STDMETHOD( SetName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetVersion )( THIS_ WORD, WORD ) PURE;
    STDMETHOD( SetGuid )( THIS_ REFGUID ) PURE;
    STDMETHOD( SetDocString )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpFileName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpContext )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLcid )( THIS_ LCID ) PURE;
    STDMETHOD( SetLibFlags )( THIS_ UINT ) PURE;
    STDMETHOD( SaveAllChanges )( THIS ) PURE;
};
typedef ICreateTypeLib  *LPCREATETYPELIB;

/* ICreateTypeLib2 interface */
#undef INTERFACE
#define INTERFACE   ICreateTypeLib2
DECLARE_INTERFACE_( ICreateTypeLib2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICreateTypeLib methods */
    STDMETHOD( CreateTypeInfo )( THIS_ LPOLESTR, TYPEKIND, ICreateTypeInfo ** ) PURE;
    STDMETHOD( SetName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetVersion )( THIS_ WORD, WORD ) PURE;
    STDMETHOD( SetGuid )( THIS_ REFGUID ) PURE;
    STDMETHOD( SetDocString )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpFileName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpContext )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLcid )( THIS_ LCID ) PURE;
    STDMETHOD( SetLibFlags )( THIS_ UINT ) PURE;
    STDMETHOD( SaveAllChanges )( THIS ) PURE;
    
    /* ICreateTypeLib2 methods */
    STDMETHOD( DeleteTypeInfo )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetCustData )( THIS_ REFGUID, VARIANT * ) PURE;
    STDMETHOD( SetHelpStringContext )( THIS_ ULONG ) PURE;
    STDMETHOD( SetHelpStringDll )( THIS_ LPOLESTR ) PURE;
};
typedef ICreateTypeLib2 *LPCREATETYPELIB2;

/* IDispatch interface */
#undef INTERFACE
#define INTERFACE   IDispatch
DECLARE_INTERFACE_( IDispatch, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};
typedef IDispatch   *LPDISPATCH;

/* IEnumVARIANT interface */
#undef INTERFACE
#define INTERFACE   IEnumVARIANT
DECLARE_INTERFACE_( IEnumVARIANT, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumVARIANT methods */
    STDMETHOD( Next )( THIS_ ULONG, VARIANT *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumVARIANT ** ) PURE;
};
typedef IEnumVARIANT    *LPENUMVARIANT;

/* ITypeComp interface */
#undef INTERFACE
#define INTERFACE   ITypeComp
DECLARE_INTERFACE_( ITypeComp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeComp methods */
    STDMETHOD( Bind )( THIS_ LPOLESTR, ULONG, WORD, ITypeInfo **, DESCKIND *, BINDPTR * ) PURE;
    STDMETHOD( BindType )( THIS_ LPOLESTR, ULONG, ITypeInfo **, ITypeComp ** ) PURE;
};
typedef ITypeComp   *LPTYPECOMP;

/* ITypeInfo interface */
#undef INTERFACE
#define INTERFACE   ITypeInfo
DECLARE_INTERFACE_( ITypeInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeInfo methods */
    STDMETHOD( GetTypeAttr )( THIS_ TYPEATTR ** ) PURE;
    STDMETHOD( GetTypeComp )( THIS_ ITypeComp ** ) PURE;
    STDMETHOD( GetFuncDesc )( THIS_ UINT, FUNCDESC ** ) PURE;
    STDMETHOD( GetVarDesc )( THIS_ UINT, VARDESC ** ) PURE;
    STDMETHOD( GetNames )( THIS_ MEMBERID, BSTR *, UINT, UINT * ) PURE;
    STDMETHOD( GetRefTypeOfImplType )( THIS_ UINT, HREFTYPE * ) PURE;
    STDMETHOD( GetImplTypeFlags )( THIS_ UINT, INT * ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ LPOLESTR *, UINT, MEMBERID * ) PURE;
    STDMETHOD( Invoke )( THIS_ PVOID, MEMBERID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    STDMETHOD( GetDocumentation )( THIS_ MEMBERID, BSTR *, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( GetDllEntry )( THIS_ MEMBERID, INVOKEKIND, BSTR *, BSTR *, WORD * ) PURE;
    STDMETHOD( GetRefTypeInfo )( THIS_ HREFTYPE, ITypeInfo ** ) PURE;
    STDMETHOD( AddressOfMember )( THIS_ MEMBERID, INVOKEKIND, PVOID * ) PURE;
    STDMETHOD( CreateInstance )( THIS_ IUnknown *, REFIID, PVOID * ) PURE;
    STDMETHOD( GetMops )( THIS_ MEMBERID, BSTR * ) PURE;
    STDMETHOD( GetContainingTypeLib )( THIS_ ITypeLib **, UINT * ) PURE;
    STDMETHOD_( void, ReleaseTypeAttr )( THIS_ TYPEATTR * ) PURE;
    STDMETHOD_( void, ReleaseFuncDesc )( THIS_ FUNCDESC * ) PURE;
    STDMETHOD_( void, ReleaseVarDesc )( THIS_ VARDESC * ) PURE;
};
typedef ITypeInfo   *LPTYPEINFO;

/* ITypeInfo2 interface */
#undef INTERFACE
#define INTERFACE   ITypeInfo2
DECLARE_INTERFACE_( ITypeInfo2, ITypeInfo ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeInfo methods */
    STDMETHOD( GetTypeAttr )( THIS_ TYPEATTR ** ) PURE;
    STDMETHOD( GetTypeComp )( THIS_ ITypeComp ** ) PURE;
    STDMETHOD( GetFuncDesc )( THIS_ UINT, FUNCDESC ** ) PURE;
    STDMETHOD( GetVarDesc )( THIS_ UINT, VARDESC ** ) PURE;
    STDMETHOD( GetNames )( THIS_ MEMBERID, BSTR *, UINT, UINT * ) PURE;
    STDMETHOD( GetRefTypeOfImplType )( THIS_ UINT, HREFTYPE * ) PURE;
    STDMETHOD( GetImplTypeFlags )( THIS_ UINT, INT * ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ LPOLESTR *, UINT, MEMBERID * ) PURE;
    STDMETHOD( Invoke )( THIS_ PVOID, MEMBERID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    STDMETHOD( GetDocumentation )( THIS_ MEMBERID, BSTR *, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( GetDllEntry )( THIS_ MEMBERID, INVOKEKIND, BSTR *, BSTR *, WORD * ) PURE;
    STDMETHOD( GetRefTypeInfo )( THIS_ HREFTYPE, ITypeInfo ** ) PURE;
    STDMETHOD( AddressOfMember )( THIS_ MEMBERID, INVOKEKIND, PVOID * ) PURE;
    STDMETHOD( CreateInstance )( THIS_ IUnknown *, REFIID, PVOID * ) PURE;
    STDMETHOD( GetMops )( THIS_ MEMBERID, BSTR * ) PURE;
    STDMETHOD( GetContainingTypeLib )( THIS_ ITypeLib **, UINT * ) PURE;
    STDMETHOD_( void, ReleaseTypeAttr )( THIS_ TYPEATTR * ) PURE;
    STDMETHOD_( void, ReleaseFuncDesc )( THIS_ FUNCDESC * ) PURE;
    STDMETHOD_( void, ReleaseVarDesc )( THIS_ VARDESC * ) PURE;
    
    /* ITypeInfo2 methods */
    STDMETHOD( GetTypeKind )( THIS_ TYPEKIND * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetFuncIndexOfMemId )( THIS_ MEMBERID, INVOKEKIND, UINT * ) PURE;
    STDMETHOD( GetVarIndexOfMemId )( THIS_ MEMBERID, UINT * ) PURE;
    STDMETHOD( GetCustData )( THIS_ REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetFuncCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetParamCustData )( THIS_ UINT, UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetVarCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetImplTypeCustData )( THIS_ UINT, REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetDocumentation2 )( THIS_ MEMBERID, LCID, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( GetAllCustData )( THIS_ CUSTDATA * ) PURE;
    STDMETHOD( GetAllFuncCustData )( THIS_ UINT, CUSTDATA * ) PURE;
    STDMETHOD( GetAllParamCustData )( THIS_ UINT, UINT, CUSTDATA * ) PURE;
    STDMETHOD( GetAllVarCustData )( THIS_ UINT, CUSTDATA * ) PURE;
    STDMETHOD( GetAllImplTypeCustData )( THIS_ UINT, CUSTDATA * ) PURE;
};
typedef ITypeInfo2  *LPTYPEINFO2;

/* ITypeLib interface */
#undef INTERFACE
#define INTERFACE   ITypeLib
DECLARE_INTERFACE_( ITypeLib, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeLib methods */
    STDMETHOD_( UINT, GetTypeInfoCount )( THIS ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, ITypeInfo ** ) PURE;
    STDMETHOD( GetTypeInfoType )( THIS_ UINT, TYPEKIND * ) PURE;
    STDMETHOD( GetTypeInfoOfGuid )( THIS_ REFGUID, ITypeInfo ** ) PURE;
    STDMETHOD( GetLibAttr )( THIS_ TLIBATTR ** ) PURE;
    STDMETHOD( GetTypeComp )( THIS_ ITypeComp ** ) PURE;
    STDMETHOD( GetDocumentation )( THIS_ INT, BSTR *, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( IsName )( THIS_ LPOLESTR, ULONG, BOOL * ) PURE;
    STDMETHOD( FindName )( THIS_ LPOLESTR, ULONG, ITypeInfo **, MEMBERID *, USHORT * ) PURE;
    STDMETHOD_( void, ReleaseTLibAttr )( THIS_ TLIBATTR * ) PURE;
};
typedef ITypeLib    *LPTYPELIB;

/* ITypeLib2 interface */
#undef INTERFACE
#define INTERFACE   ITypeLib2
DECLARE_INTERFACE_( ITypeLib2, ITypeLib ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeLib methods */
    STDMETHOD_( UINT, GetTypeInfoCount )( THIS ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, ITypeInfo ** ) PURE;
    STDMETHOD( GetTypeInfoType )( THIS_ UINT, TYPEKIND * ) PURE;
    STDMETHOD( GetTypeInfoOfGuid )( THIS_ REFGUID, ITypeInfo ** ) PURE;
    STDMETHOD( GetLibAttr )( THIS_ TLIBATTR ** ) PURE;
    STDMETHOD( GetTypeComp )( THIS_ ITypeComp ** ) PURE;
    STDMETHOD( GetDocumentation )( THIS_ INT, BSTR *, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( IsName )( THIS_ LPOLESTR, ULONG, BOOL * ) PURE;
    STDMETHOD( FindName )( THIS_ LPOLESTR, ULONG, ITypeInfo **, MEMBERID *, USHORT * ) PURE;
    STDMETHOD_( void, ReleaseTLibAttr )( THIS_ TLIBATTR * ) PURE;
    
    /* ITypeLib2 methods */
    STDMETHOD( GetCustData )( THIS_ REFGUID, VARIANT * ) PURE;
    STDMETHOD( GetLibStatistics )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetDocumentation2 )( THIS_ INT, LCID, BSTR *, DWORD *, BSTR * ) PURE;
    STDMETHOD( GetAllCustData )( THIS_ CUSTDATA * ) PURE;
};
typedef ITypeLib2   *LPTYPELIB2;

/* ITypeChangeEvents interface */
#undef INTERFACE
#define INTERFACE   ITypeChangeEvents
DECLARE_INTERFACE_( ITypeChangeEvents, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeChangeEvents methods */
    STDMETHOD( RequestTypeChange )( THIS_ CHANGEKIND, ITypeInfo *, LPOLESTR, INT * ) PURE;
    STDMETHOD( AfterTypeChange )( THIS_ CHANGEKIND, ITypeInfo *, LPOLESTR ) PURE;
};
typedef ITypeChangeEvents   *LPTYPECHANGEEVENTS;

/* IErrorInfo interface */
#undef INTERFACE
#define INTERFACE   IErrorInfo
DECLARE_INTERFACE_( IErrorInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IErrorInfo methods */
    STDMETHOD( GetGUID )( THIS_ GUID * ) PURE;
    STDMETHOD( GetSource )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetDescription )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetHelpFile )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetHelpContext )( THIS_ DWORD * ) PURE;
};
typedef IErrorInfo  *LPERRORINFO;

/* ICreateErrorInfo interface */
#undef INTERFACE
#define INTERFACE   ICreateErrorInfo
DECLARE_INTERFACE_( ICreateErrorInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICreateErrorInfo methods */
    STDMETHOD( SetGUID )( THIS_ REFGUID ) PURE;
    STDMETHOD( SetSource )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetDescription )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpFile )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( SetHelpContext )( THIS_ DWORD ) PURE;
};
typedef ICreateErrorInfo    *LPCREATEERRORINFO;

/* ISupportErrorInfo interface */
#undef INTERFACE
#define INTERFACE   ISupportErrorInfo
DECLARE_INTERFACE_( ISupportErrorInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISupportErrorInfo methods */
    STDMETHOD( InterfaceSupportsErrorInfo )( THIS_ REFIID ) PURE;
};
typedef ISupportErrorInfo   *LPSUPPORTERRORINFO;

/* ITypeFactory interface */
#undef INTERFACE
#define INTERFACE   ITypeFactory
DECLARE_INTERFACE_( ITypeFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeFactory methods */
    STDMETHOD( CreateFromTypeInfo )( THIS_ ITypeInfo *, REFIID, IUnknown ** ) PURE;
};

/* ITypeMarshal interface */
#undef INTERFACE
#define INTERFACE   ITypeMarshal
DECLARE_INTERFACE_( ITypeMarshal, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITypeMarshal methods */
    STDMETHOD( Size )( THIS_ PVOID, DWORD, PVOID, ULONG * ) PURE;
    STDMETHOD( Marshal )( THIS_ PVOID, DWORD, PVOID, ULONG, BYTE *, ULONG * ) PURE;
    STDMETHOD( Unmarshal )( THIS_ PVOID, DWORD, ULONG, BYTE *, ULONG * ) PURE;
    STDMETHOD( Free )( THIS_ PVOID ) PURE;
};

/* IRecordInfo interface */
#undef INTERFACE
#define INTERFACE   IRecordInfo
DECLARE_INTERFACE_( IRecordInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRecordInfo methods */
    STDMETHOD( RecordInit )( THIS_ PVOID ) PURE;
    STDMETHOD( RecordClear )( THIS_ PVOID ) PURE;
    STDMETHOD( RecordCopy )( THIS_ PVOID, PVOID ) PURE;
    STDMETHOD( GetGuid )( THIS_ GUID * ) PURE;
    STDMETHOD( GetName )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetSize )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ ITypeInfo ** ) PURE;
    STDMETHOD( GetField )( THIS_ PVOID, LPCOLESTR, VARIANT * ) PURE;
    STDMETHOD( GetFieldNoCopy )( THIS_ PVOID, LPCOLESTR, VARIANT *, PVOID * ) PURE;
    STDMETHOD( PutField )( THIS_ ULONG, PVOID, LPCOLESTR, VARIANT * ) PURE;
    STDMETHOD( PutFieldNoCopy )( THIS_ ULONG, PVOID, LPCOLESTR, VARIANT * ) PURE;
    STDMETHOD( GetFieldNames )( THIS_ ULONG *, BSTR * ) PURE;
    STDMETHOD_( BOOL, IsMatchingType )( THIS_ IRecordInfo * ) PURE;
    STDMETHOD_( PVOID, RecordCreate )( THIS ) PURE;
    STDMETHOD( RecordCreateCopy )( THIS_ PVOID, PVOID * ) PURE;
    STDMETHOD( RecordDestroy )( THIS_ PVOID ) PURE;
};
typedef IRecordInfo *LPRECORDINFO;

/* IErrorLog interface */
#undef INTERFACE
#define INTERFACE   IErrorLog
DECLARE_INTERFACE_( IErrorLog, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IErrorLog methods */
    STDMETHOD( AddError )( THIS_ LPCOLESTR, EXCEPINFO * ) PURE;
};
typedef IErrorLog   *LPERRORLOG;

/* IPropertyBag interface */
#undef INTERFACE
#define INTERFACE   IPropertyBag
DECLARE_INTERFACE_( IPropertyBag, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPropertyBag methods */
    STDMETHOD( Read )( THIS_ LPCOLESTR, VARIANT *, IErrorLog * ) PURE;
    STDMETHOD( Write )( THIS_ LPCOLESTR, VARIANT * ) PURE;
};
typedef IPropertyBag    *LPPROPERTYBAG;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define ICreateTypeInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateTypeInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateTypeInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateTypeInfo_SetGuid( x, p ) \
        (x)->lpVtbl->SetGuid( x, p )
    #define ICreateTypeInfo_SetTypeFlags( x, p ) \
        (x)->lpVtbl->SetTypeFlags( x, p )
    #define ICreateTypeInfo_SetDocString( x, p ) \
        (x)->lpVtbl->SetDocString( x, p )
    #define ICreateTypeInfo_SetHelpContext( x, p ) \
        (x)->lpVtbl->SetHelpContext( x, p )
    #define ICreateTypeInfo_SetVersion( x, p1, p2 ) \
        (x)->lpVtbl->SetVersion( x, p1, p2 )
    #define ICreateTypeInfo_AddRefTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->AddRefTypeInfo( x, p1, p2 )
    #define ICreateTypeInfo_AddFuncDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddFuncDesc( x, p1, p2 )
    #define ICreateTypeInfo_AddImplDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddImplDesc( x, p1, p2 )
    #define ICreateTypeInfo_SetImplTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->SetImplTypeFlags( x, p1, p2 )
    #define ICreateTypeInfo_SetAlignment( x, p ) \
        (x)->lpVtbl->SetAlignment( x, p )
    #define ICreateTypeInfo_SetSchema( x, p ) \
        (x)->lpVtbl->SetSchema( x, p )
    #define ICreateTypeInfo_AddVarDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddVarDesc( x, p1, p2 )
    #define ICreateTypeInfo_SetFuncAndParamNames( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetFuncAndParamNames( x, p1, p2, p3 )
    #define ICreateTypeInfo_SetVarName( x, p1, p2 ) \
        (x)->lpVtbl->SetVarName( x, p1, p2 )
    #define ICreateTypeInfo_SetTypeDescAlias( x, p ) \
        (x)->lpVtbl->SetTypeDescAlias( x, p )
    #define ICreateTypeInfo_DefineFuncAsDllEntry( x, p1, p2, p3 ) \
        (x)->lpVtbl->DefineFuncAsDllEntry( x, p1, p2, p3 )
    #define ICreateTypeInfo_SetFuncDocString( x, p1, p2 ) \
        (x)->lpVtbl->SetFuncDocString( x, p1, p2 )
    #define ICreateTypeInfo_SetVarDocString( x, p1, p2 ) \
        (x)->lpVtbl->SetVarDocString( x, p1, p2 )
    #define ICreateTypeInfo_SetFuncHelpContext( x, p1, p2 ) \
        (x)->lpVtbl->SetFuncHelpContext( x, p1, p2 )
    #define ICreateTypeInfo_SetVarHelpContext( x, p1, p2 ) \
        (x)->lpVtbl->SetVarHelpContext( x, p1, p2 )
    #define ICreateTypeInfo_SetMops( x, p1, p2 ) \
        (x)->lpVtbl->SetMops( x, p1, p2 )
    #define ICreateTypeInfo_SetTypeIdldesc( x, p ) \
        (x)->lpVtbl->SetTypeIdldesc( x, p )
    #define ICreateTypeInfo_LayOut( x ) \
        (x)->lpVtbl->LayOut( x )
    #define ICreateTypeInfo2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateTypeInfo2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateTypeInfo2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateTypeInfo2_SetGuid( x, p ) \
        (x)->lpVtbl->SetGuid( x, p )
    #define ICreateTypeInfo2_SetTypeFlags( x, p ) \
        (x)->lpVtbl->SetTypeFlags( x, p )
    #define ICreateTypeInfo2_SetDocString( x, p ) \
        (x)->lpVtbl->SetDocString( x, p )
    #define ICreateTypeInfo2_SetHelpContext( x, p ) \
        (x)->lpVtbl->SetHelpContext( x, p )
    #define ICreateTypeInfo2_SetVersion( x, p1, p2 ) \
        (x)->lpVtbl->SetVersion( x, p1, p2 )
    #define ICreateTypeInfo2_AddRefTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->AddRefTypeInfo( x, p1, p2 )
    #define ICreateTypeInfo2_AddFuncDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddFuncDesc( x, p1, p2 )
    #define ICreateTypeInfo2_AddImplDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddImplDesc( x, p1, p2 )
    #define ICreateTypeInfo2_SetImplTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->SetImplTypeFlags( x, p1, p2 )
    #define ICreateTypeInfo2_SetAlignment( x, p ) \
        (x)->lpVtbl->SetAlignment( x, p )
    #define ICreateTypeInfo2_SetSchema( x, p ) \
        (x)->lpVtbl->SetSchema( x, p )
    #define ICreateTypeInfo2_AddVarDesc( x, p1, p2 ) \
        (x)->lpVtbl->AddVarDesc( x, p1, p2 )
    #define ICreateTypeInfo2_SetFuncAndParamNames( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetFuncAndParamNames( x, p1, p2, p3 )
    #define ICreateTypeInfo2_SetVarName( x, p1, p2 ) \
        (x)->lpVtbl->SetVarName( x, p1, p2 )
    #define ICreateTypeInfo2_SetTypeDescAlias( x, p ) \
        (x)->lpVtbl->SetTypeDescAlias( x, p )
    #define ICreateTypeInfo2_DefineFuncAsDllEntry( x, p1, p2, p3 ) \
        (x)->lpVtbl->DefineFuncAsDllEntry( x, p1, p2, p3 )
    #define ICreateTypeInfo2_SetFuncDocString( x, p1, p2 ) \
        (x)->lpVtbl->SetFuncDocString( x, p1, p2 )
    #define ICreateTypeInfo2_SetVarDocString( x, p1, p2 ) \
        (x)->lpVtbl->SetVarDocString( x, p1, p2 )
    #define ICreateTypeInfo2_SetFuncHelpContext( x, p1, p2 ) \
        (x)->lpVtbl->SetFuncHelpContext( x, p1, p2 )
    #define ICreateTypeInfo2_SetVarHelpContext( x, p1, p2 ) \
        (x)->lpVtbl->SetVarHelpContext( x, p1, p2 )
    #define ICreateTypeInfo2_SetMops( x, p1, p2 ) \
        (x)->lpVtbl->SetMops( x, p1, p2 )
    #define ICreateTypeInfo2_SetTypeIdldesc( x, p ) \
        (x)->lpVtbl->SetTypeIdldesc( x, p )
    #define ICreateTypeInfo2_LayOut( x ) \
        (x)->lpVtbl->LayOut( x )
    #define ICreateTypeInfo2_DeleteFuncDesc( x, p ) \
        (x)->lpVtbl->DeleteFuncDesc( x, p )
    #define ICreateTypeInfo2_DeleteFuncDescByMemId( x, p1, p2 ) \
        (x)->lpVtbl->DeleteFuncDescByMemId( x, p1, p2 )
    #define ICreateTypeInfo2_DeleteVarDesc( x, p ) \
        (x)->lpVtbl->DeleteVarDesc( x, p )
    #define ICreateTypeInfo2_DeleteVarDescByMemId( x, p1, p2 ) \
        (x)->lpVtbl->DeleteVarDescByMemId( x, p1, p2 )
    #define ICreateTypeInfo2_DeleteImplType( x, p ) \
        (x)->lpVtbl->DeleteImplType( x, p )
    #define ICreateTypeInfo2_SetCustData( x, p1, p2 ) \
        (x)->lpVtbl->SetCustData( x, p1, p2 )
    #define ICreateTypeInfo2_SetFuncCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetFuncCustData( x, p1, p2, p3 )
    #define ICreateTypeInfo2_SetParamCustData( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetParamCustData( x, p1, p2, p3, p4 )
    #define ICreateTypeInfo2_SetVarCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetVarCustData( x, p1, p2, p3 )
    #define ICreateTypeInfo2_SetImplTypeCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetImplTypeCustData( x, p1, p2, p3 )
    #define ICreateTypeInfo2_SetHelpStringContext( x, p ) \
        (x)->lpVtbl->SetHelpStringContext( x, p )
    #define ICreateTypeInfo2_SetFuncHelpStringContext( x, p1, p2 ) \
        (x)->lpVtbl->SetFuncHelpStringContext( x, p1, p2 )
    #define ICreateTypeInfo2_SetVarHelpStringContext( x, p1, p2 ) \
        (x)->lpVtbl->SetVarHelpStringContext( x, p1, p2 )
    #define ICreateTypeInfo2_Invalidate( x ) \
        (x)->lpVtbl->Invalidate( x )
    #define ICreateTypeInfo2_SetName( x, p ) \
        (x)->lpVtbl->SetName( x, p )
    #define ICreateTypeLib_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateTypeLib_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateTypeLib_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateTypeLib_CreateTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateTypeInfo( x, p1, p2, p3 )
    #define ICreateTypeLib_SetName( x, p ) \
        (x)->lpVtbl->SetName( x, p )
    #define ICreateTypeLib_SetVersion( x, p1, p2 ) \
        (x)->lpVtbl->SetVersion( x, p1, p2 )
    #define ICreateTypeLib_SetGuid( x, p ) \
        (x)->lpVtbl->SetGuid( x, p )
    #define ICreateTypeLib_SetDocString( x, p ) \
        (x)->lpVtbl->SetDocString( x, p )
    #define ICreateTypeLib_SetHelpFileName( x, p ) \
        (x)->lpVtbl->SetHelpFileName( x, p )
    #define ICreateTypeLib_SetHelpContext( x, p ) \
        (x)->lpVtbl->SetHelpContext( x, p )
    #define ICreateTypeLib_SetLcid( x, p ) \
        (x)->lpVtbl->SetLcid( x, p )
    #define ICreateTypeLib_SetLibFlags( x, p ) \
        (x)->lpVtbl->SetLibFlags( x, p )
    #define ICreateTypeLib_SaveAllChanges( x ) \
        (x)->lpVtbl->SaveAllChanges( x )
    #define ICreateTypeLib2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateTypeLib2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateTypeLib2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateTypeLib2_CreateTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateTypeInfo( x, p1, p2, p3 )
    #define ICreateTypeLib2_SetName( x, p ) \
        (x)->lpVtbl->SetName( x, p )
    #define ICreateTypeLib2_SetVersion( x, p1, p2 ) \
        (x)->lpVtbl->SetVersion( x, p1, p2 )
    #define ICreateTypeLib2_SetGuid( x, p ) \
        (x)->lpVtbl->SetGuid( x, p )
    #define ICreateTypeLib2_SetDocString( x, p ) \
        (x)->lpVtbl->SetDocString( x, p )
    #define ICreateTypeLib2_SetHelpFileName( x, p ) \
        (x)->lpVtbl->SetHelpFileName( x, p )
    #define ICreateTypeLib2_SetHelpContext( x, p ) \
        (x)->lpVtbl->SetHelpContext( x, p )
    #define ICreateTypeLib2_SetLcid( x, p ) \
        (x)->lpVtbl->SetLcid( x, p )
    #define ICreateTypeLib2_SetLibFlags( x, p ) \
        (x)->lpVtbl->SetLibFlags( x, p )
    #define ICreateTypeLib2_SaveAllChanges( x ) \
        (x)->lpVtbl->SaveAllChanges( x )
    #define ICreateTypeLib2_DeleteTypeInfo( x, p ) \
        (x)->lpVtbl->DeleteTypeInfo( x, p )
    #define ICreateTypeLib2_SetCustData( x, p1, p2 ) \
        (x)->lpVtbl->SetCustData( x, p1, p2 )
    #define ICreateTypeLib2_SetHelpStringContext( x, p ) \
        (x)->lpVtbl->SetHelpStringContext( x, p )
    #define ICreateTypeLib2_SetHelpStringDll( x, p ) \
        (x)->lpVtbl->SetHelpStringDll( x, p )
    #define IDispatch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDispatch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDispatch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDispatch_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IDispatch_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IDispatch_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IDispatch_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IEnumVARIANT_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumVARIANT_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumVARIANT_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumVARIANT_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumVARIANT_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumVARIANT_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumVARIANT_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define ITypeComp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeComp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeComp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeComp_Bind( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->Bind( x, p1, p2, p3, p4, p5, p6 )
    #define ITypeComp_BindType( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BindType( x, p1, p2, p3, p4 )
    #define ITypeInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeInfo_GetTypeAttr( x, p ) \
        (x)->lpVtbl->GetTypeAttr( x, p )
    #define ITypeInfo_GetTypeComp( x, p ) \
        (x)->lpVtbl->GetTypeComp( x, p )
    #define ITypeInfo_GetFuncDesc( x, p1, p2 ) \
        (x)->lpVtbl->GetFuncDesc( x, p1, p2 )
    #define ITypeInfo_GetVarDesc( x, p1, p2 ) \
        (x)->lpVtbl->GetVarDesc( x, p1, p2 )
    #define ITypeInfo_GetNames( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetNames( x, p1, p2, p3, p4 )
    #define ITypeInfo_GetRefTypeOfImplType( x, p1, p2 ) \
        (x)->lpVtbl->GetRefTypeOfImplType( x, p1, p2 )
    #define ITypeInfo_GetImplTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetImplTypeFlags( x, p1, p2 )
    #define ITypeInfo_GetIDsOfNames( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3 )
    #define ITypeInfo_Invoke( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7 )
    #define ITypeInfo_GetDocumentation( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation( x, p1, p2, p3, p4, p5 )
    #define ITypeInfo_GetDllEntry( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDllEntry( x, p1, p2, p3, p4, p5 )
    #define ITypeInfo_GetRefTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetRefTypeInfo( x, p1, p2 )
    #define ITypeInfo_AddressOfMember( x, p1, p2, p3 ) \
        (x)->lpVtbl->AddressOfMember( x, p1, p2, p3 )
    #define ITypeInfo_CreateInstance( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateInstance( x, p1, p2, p3 )
    #define ITypeInfo_GetMops( x, p1, p2 ) \
        (x)->lpVtbl->GetMops( x, p1, p2 )
    #define ITypeInfo_GetContainingTypeLib( x, p1, p2 ) \
        (x)->lpVtbl->GetContainingTypeLib( x, p1, p2 )
    #define ITypeInfo_ReleaseTypeAttr( x, p ) \
        (x)->lpVtbl->ReleaseTypeAttr( x, p )
    #define ITypeInfo_ReleaseFuncDesc( x, p ) \
        (x)->lpVtbl->ReleaseFuncDesc( x, p )
    #define ITypeInfo_ReleaseVarDesc( x, p ) \
        (x)->lpVtbl->ReleaseVarDesc( x, p )
    #define ITypeInfo2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeInfo2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeInfo2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeInfo2_GetTypeAttr( x, p ) \
        (x)->lpVtbl->GetTypeAttr( x, p )
    #define ITypeInfo2_GetTypeComp( x, p ) \
        (x)->lpVtbl->GetTypeComp( x, p )
    #define ITypeInfo2_GetFuncDesc( x, p1, p2 ) \
        (x)->lpVtbl->GetFuncDesc( x, p1, p2 )
    #define ITypeInfo2_GetVarDesc( x, p1, p2 ) \
        (x)->lpVtbl->GetVarDesc( x, p1, p2 )
    #define ITypeInfo2_GetNames( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetNames( x, p1, p2, p3, p4 )
    #define ITypeInfo2_GetRefTypeOfImplType( x, p1, p2 ) \
        (x)->lpVtbl->GetRefTypeOfImplType( x, p1, p2 )
    #define ITypeInfo2_GetImplTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetImplTypeFlags( x, p1, p2 )
    #define ITypeInfo2_GetIDsOfNames( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3 )
    #define ITypeInfo2_Invoke( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7 )
    #define ITypeInfo2_GetDocumentation( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation( x, p1, p2, p3, p4, p5 )
    #define ITypeInfo2_GetDllEntry( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDllEntry( x, p1, p2, p3, p4, p5 )
    #define ITypeInfo2_GetRefTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetRefTypeInfo( x, p1, p2 )
    #define ITypeInfo2_AddressOfMember( x, p1, p2, p3 ) \
        (x)->lpVtbl->AddressOfMember( x, p1, p2, p3 )
    #define ITypeInfo2_CreateInstance( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateInstance( x, p1, p2, p3 )
    #define ITypeInfo2_GetMops( x, p1, p2 ) \
        (x)->lpVtbl->GetMops( x, p1, p2 )
    #define ITypeInfo2_GetContainingTypeLib( x, p1, p2 ) \
        (x)->lpVtbl->GetContainingTypeLib( x, p1, p2 )
    #define ITypeInfo2_ReleaseTypeAttr( x, p ) \
        (x)->lpVtbl->ReleaseTypeAttr( x, p )
    #define ITypeInfo2_ReleaseFuncDesc( x, p ) \
        (x)->lpVtbl->ReleaseFuncDesc( x, p )
    #define ITypeInfo2_ReleaseVarDesc( x, p ) \
        (x)->lpVtbl->ReleaseVarDesc( x, p )
    #define ITypeInfo2_GetTypeKind( x, p ) \
        (x)->lpVtbl->GetTypeKind( x, p )
    #define ITypeInfo2_GetTypeFlags( x, p ) \
        (x)->lpVtbl->GetTypeFlags( x, p )
    #define ITypeInfo2_GetFuncIndexOfMemId( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetFuncIndexOfMemId( x, p1, p2, p3 )
    #define ITypeInfo2_GetVarIndexOfMemId( x, p1, p2 ) \
        (x)->lpVtbl->GetVarIndexOfMemId( x, p1, p2 )
    #define ITypeInfo2_GetCustData( x, p1, p2 ) \
        (x)->lpVtbl->GetCustData( x, p1, p2 )
    #define ITypeInfo2_GetFuncCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetFuncCustData( x, p1, p2, p3 )
    #define ITypeInfo2_GetParamCustData( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetParamCustData( x, p1, p2, p3, p4 )
    #define ITypeInfo2_GetVarCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetVarCustData( x, p1, p2, p3 )
    #define ITypeInfo2_GetImplTypeCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetImplTypeCustData( x, p1, p2, p3 )
    #define ITypeInfo2_GetDocumentation2( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation2( x, p1, p2, p3, p4, p5 )
    #define ITypeInfo2_GetAllCustData( x, p ) \
        (x)->lpVtbl->GetAllCustData( x, p )
    #define ITypeInfo2_GetAllFuncCustData( x, p1, p2 ) \
        (x)->lpVtbl->GetAllFuncCustData( x, p1, p2 )
    #define ITypeInfo2_GetAllParamCustData( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAllParamCustData( x, p1, p2, p3 )
    #define ITypeInfo2_GetAllVarCustData( x, p1, p2 ) \
        (x)->lpVtbl->GetAllVarCustData( x, p1, p2 )
    #define ITypeInfo2_GetAllImplTypeCustData( x, p1, p2 ) \
        (x)->lpVtbl->GetAllImplTypeCustData( x, p1, p2 )
    #define ITypeLib_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeLib_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeLib_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeLib_GetTypeInfoCount( x ) \
        (x)->lpVtbl->GetTypeInfoCount( x )
    #define ITypeLib_GetTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2 )
    #define ITypeLib_GetTypeInfoType( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfoType( x, p1, p2 )
    #define ITypeLib_GetTypeInfoOfGuid( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfoOfGuid( x, p1, p2 )
    #define ITypeLib_GetLibAttr( x, p ) \
        (x)->lpVtbl->GetLibAttr( x, p )
    #define ITypeLib_GetTypeComp( x, p ) \
        (x)->lpVtbl->GetTypeComp( x, p )
    #define ITypeLib_GetDocumentation( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation( x, p1, p2, p3, p4, p5 )
    #define ITypeLib_IsName( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsName( x, p1, p2, p3 )
    #define ITypeLib_FindName( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->FindName( x, p1, p2, p3, p4, p5 )
    #define ITypeLib_ReleaseTLibAttr( x, p ) \
        (x)->lpVtbl->ReleaseTLibAttr( x, p )
    #define ITypeLib2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeLib2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeLib2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeLib2_GetTypeInfoCount( x ) \
        (x)->lpVtbl->GetTypeInfoCount( x )
    #define ITypeLib2_GetTypeInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2 )
    #define ITypeLib2_GetTypeInfoType( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfoType( x, p1, p2 )
    #define ITypeLib2_GetTypeInfoOfGuid( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeInfoOfGuid( x, p1, p2 )
    #define ITypeLib2_GetLibAttr( x, p ) \
        (x)->lpVtbl->GetLibAttr( x, p )
    #define ITypeLib2_GetTypeComp( x, p ) \
        (x)->lpVtbl->GetTypeComp( x, p )
    #define ITypeLib2_GetDocumentation( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation( x, p1, p2, p3, p4, p5 )
    #define ITypeLib2_IsName( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsName( x, p1, p2, p3 )
    #define ITypeLib2_FindName( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->FindName( x, p1, p2, p3, p4, p5 )
    #define ITypeLib2_ReleaseTLibAttr( x, p ) \
        (x)->lpVtbl->ReleaseTLibAttr( x, p )
    #define ITypeLib2_GetCustData( x, p1, p2 ) \
        (x)->lpVtbl->GetCustData( x, p1, p2 )
    #define ITypeLib2_GetLibStatistics( x, p1, p2 ) \
        (x)->lpVtbl->GetLibStatistics( x, p1, p2 )
    #define ITypeLib2_GetDocumentation2( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetDocumentation2( x, p1, p2, p3, p4, p5 )
    #define ITypeLib2_GetAllCustData( x, p ) \
        (x)->lpVtbl->GetAllCustData( x, p )
    #define ITypeChangeEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeChangeEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeChangeEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeChangeEvents_RequestTypeChange( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RequestTypeChange( x, p1, p2, p3, p4 )
    #define ITypeChangeEvents_AfterTypeChange( x, p1, p2, p3 ) \
        (x)->lpVtbl->AfterTypeChange( x, p1, p2, p3 )
    #define IErrorInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IErrorInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IErrorInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IErrorInfo_GetGUID( x, p ) \
        (x)->lpVtbl->GetGUID( x, p )
    #define IErrorInfo_GetSource( x, p ) \
        (x)->lpVtbl->GetSource( x, p )
    #define IErrorInfo_GetDescription( x, p ) \
        (x)->lpVtbl->GetDescription( x, p )
    #define IErrorInfo_GetHelpFile( x, p ) \
        (x)->lpVtbl->GetHelpFile( x, p )
    #define IErrorInfo_GetHelpContext( x, p ) \
        (x)->lpVtbl->GetHelpContext( x, p )
    #define ICreateErrorInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateErrorInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateErrorInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateErrorInfo_SetGUID( x, p ) \
        (x)->lpVtbl->SetGUID( x, p )
    #define ICreateErrorInfo_SetSource( x, p ) \
        (x)->lpVtbl->SetSource( x, p )
    #define ICreateErrorInfo_SetDescription( x, p ) \
        (x)->lpVtbl->SetDescription( x, p )
    #define ICreateErrorInfo_SetHelpFile( x, p ) \
        (x)->lpVtbl->SetHelpFile( x, p )
    #define ICreateErrorInfo_SetHelpContext( x, p ) \
        (x)->lpVtbl->SetHelpContext( x, p )
    #define ISupportErrorInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISupportErrorInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISupportErrorInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISupportErrorInfo_InterfaceSupportsErrorInfo( x, p ) \
        (x)->lpVtbl->InterfaceSupportsErrorInfo( x, p )
    #define ITypeFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeFactory_CreateFromTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateFromTypeInfo( x, p1, p2, p3 )
    #define ITypeMarshal_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITypeMarshal_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITypeMarshal_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITypeMarshal_Size( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Size( x, p1, p2, p3, p4 )
    #define ITypeMarshal_Marshal( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->Marshal( x, p1, p2, p3, p4, p5, p6 )
    #define ITypeMarshal_Unmarshal( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->Unmarshal( x, p1, p2, p3, p4, p5 )
    #define ITypeMarshal_Free( x, p ) \
        (x)->lpVtbl->Free( x, p )
    #define IRecordInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRecordInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRecordInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRecordInfo_RecordInit( x, p ) \
        (x)->lpVtbl->RecordInit( x, p )
    #define IRecordInfo_RecordClear( x, p ) \
        (x)->lpVtbl->RecordClear( x, p )
    #define IRecordInfo_RecordCopy( x, p1, p2 ) \
        (x)->lpVtbl->RecordCopy( x, p1, p2 )
    #define IRecordInfo_GetGuid( x, p ) \
        (x)->lpVtbl->GetGuid( x, p )
    #define IRecordInfo_GetName( x, p ) \
        (x)->lpVtbl->GetName( x, p )
    #define IRecordInfo_GetSize( x, p ) \
        (x)->lpVtbl->GetSize( x, p )
    #define IRecordInfo_GetTypeInfo( x, p ) \
        (x)->lpVtbl->GetTypeInfo( x, p )
    #define IRecordInfo_GetField( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetField( x, p1, p2, p3 )
    #define IRecordInfo_GetFieldNoCopy( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetFieldNoCopy( x, p1, p2, p3, p4 )
    #define IRecordInfo_PutField( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PutField( x, p1, p2, p3, p4 )
    #define IRecordInfo_PutFieldNoCopy( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PutFieldNoCopy( x, p1, p2, p3, p4 )
    #define IRecordInfo_GetFieldNames( x, p1, p2 ) \
        (x)->lpVtbl->GetFieldNames( x, p1, p2 )
    #define IRecordInfo_IsMatchingType( x, p ) \
        (x)->lpVtbl->IsMatchingType( x, p )
    #define IRecordInfo_RecordCreate( x ) \
        (x)->lpVtbl->RecordCreate( x )
    #define IRecordInfo_RecordCreateCopy( x, p1, p2 ) \
        (x)->lpVtbl->RecordCreateCopy( x, p1, p2 )
    #define IRecordInfo_RecordDestroy( x ) \
        (x)->lpVtbl->RecordDestroy( x )
    #define IErrorLog_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IErrorLog_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IErrorLog_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IErrorLog_AddError( x, p1, p2 ) \
        (x)->lpVtbl->AddError( x, p1, p2 )
    #define IPropertyBag_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyBag_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyBag_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyBag_Read( x, p1, p2, p3 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3 )
    #define IPropertyBag_Write( x, p1, p2 ) \
        (x)->lpVtbl->Write( x, p1, p2 )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_ICreateTypeInfo;
EXTERN_C const IID  __cdecl IID_ICreateTypeInfo2;
EXTERN_C const IID  __cdecl IID_ICreateTypeLib;
EXTERN_C const IID  __cdecl IID_ICreateTypeLib2;
EXTERN_C const IID  __cdecl IID_IDispatch;
EXTERN_C const IID  __cdecl IID_IEnumVARIANT;
EXTERN_C const IID  __cdecl IID_ITypeComp;
EXTERN_C const IID  __cdecl IID_ITypeInfo;
EXTERN_C const IID  __cdecl IID_ITypeInfo2;
EXTERN_C const IID  __cdecl IID_ITypeLib;
EXTERN_C const IID  __cdecl IID_ITypeLib2;
EXTERN_C const IID  __cdecl IID_ITypeChangeEvents;
EXTERN_C const IID  __cdecl IID_IErrorInfo;
EXTERN_C const IID  __cdecl IID_ICreateErrorInfo;
EXTERN_C const IID  __cdecl IID_ISupportErrorInfo;
EXTERN_C const IID  __cdecl IID_ITypeFactory;
EXTERN_C const IID  __cdecl IID_ITypeMarshal;
EXTERN_C const IID  __cdecl IID_IRecordInfo;
EXTERN_C const IID  __cdecl IID_IErrorLog;
EXTERN_C const IID  __cdecl IID_IPropertyBag;

#endif /* __oaidl_h__ */
