/*
 *  objarray.h / objectarray.h  IObjectArray interface
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __objectarray_h__
#define __objectarray_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <oaidl.h>
#include <ocidl.h>

/* IObjectArray interface */
#undef INTERFACE
#define INTERFACE   IObjectArray
DECLARE_INTERFACE_( IObjectArray, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IObjectArray methods */
    STDMETHOD( GetCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetAt )( THIS_ UINT, REFIID, void ** ) PURE;
};

/* IObjectCollection interface */
#undef INTERFACE
#define INTERFACE   IObjectCollection
DECLARE_INTERFACE_( IObjectCollection, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IObjectCollection methods */
    STDMETHOD( AddObject )( THIS_ IUnknown * ) PURE;
    STDMETHOD( AddFromArray )( THIS_ IObjectArray * ) PURE;
    STDMETHOD( RemoveObjectAt )( THIS_ UINT ) PURE;
    STDMETHOD( Clear )( THIS ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IObjectArray_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IObjectArray_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IObjectArray_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IObjectArray_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IObjectArray_GetAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAt( x, p1, p2, p3 )
    #define IObjectCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IObjectCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IObjectCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IObjectCollection_AddObject( x, p ) \
        (x)->lpVtbl->AddObject( x, p )
    #define IObjectCollection_AddFromArray( x, p ) \
        (x)->lpVtbl->AddFromArray( x, p )
    #define IObjectCollection_RemoveObjectAt( x, p ) \
        (x)->lpVtbl->RemoveObjectAt( x, p )
    #define IObjectCollection_Clear( x ) \
        (x)->lpVtbl->Clear( x )
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_IObjectArray;
EXTERN_C const IID  __cdecl IID_IObjectCollection;

#endif /* __objectarray_h__ */
