/*
 *  propsys.h   Property system interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __propsys_h__
#define __propsys_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <objidl.h>
#include <oleidl.h>
#include <ocidl.h>
#include <shtypes.h>
#ifndef RC_INVOKED
    #pragma include_alias( <structuredquery.h>, <strquery.h> )
    #pragma include_alias( <propkeydef.h>, <propkdef.h> )
    #include <structuredquery.h>
    #include <propkeydef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify property system functions */
#ifndef PSSTDAPI
    #define PSSTDAPI        STDAPI
    #define PSSTDAPI_( x )  STDAPI_( x )
#endif

/* Maximum string lengths */
#define PKEY_PIDSTR_MAX 10
#define GUIDSTRING_MAX  39
#define PKEYSTR_MAX     (GUIDSTRING_MAX + PKEY_PIDSTR_MAX + 1)

/* Get property store flags */
typedef enum GETPROPERTYSTOREFLAGS {
    GPS_DEFAULT                 = 0x00000000,
    GPS_HANDLERPROPERTIESONLY   = 0x00000001,
    GPS_READWRITE               = 0x00000002,
    GPS_TEMPORARY               = 0x00000004,
    GPS_FASTPROPERTIESONLY      = 0x00000008,
    GPS_OPENSLOWITEM            = 0x00000010,
    GPS_DELAYCREATION           = 0x00000020,
    GPS_BESTEFFORT              = 0x00000040,
    GPS_NO_OPLOCK               = 0x00000080,
    GPS_MASK_VALID              = 0x000000FF
} GETPROPERTYSTOREFLAGS;

/* Property key flags */
typedef enum PKA_FLAGS {
    PKA_SET     = 0,
    PKA_APPEND  = 1,
    PKA_DELETE  = 2
} PKA_FLAGS;

/* Property store cache states */
typedef enum PSC_STATE {
    PSC_NORMAL      = 0,
    PSC_NOTINSOURCE = 1,
    PSC_DIRTY       = 2,
    PSC_READONLY    = 3
} PSC_STATE;

/* Property enumeration types */
typedef enum PROPENUMTYPE {
    PET_DISCRETEVALUE   = 0,
    PET_RANGEDVALUE     = 1,
    PET_DEFAULTVALUE    = 2,
    PET_ENDRANGE        = 3
} PROPENUMTYPE;

/* Property description type flags */
typedef enum PROPDESC_TYPE_FLAGS {
    PDTF_DEFAULT                = 0x00000000,
    PDTF_MULTIPLEVALUES         = 0x00000001,
    PDTF_ISINNATE               = 0x00000002,
    PDTF_ISGROUP                = 0x00000004,
    PDTF_CANGROUPBY             = 0x00000008,
    PDTF_CANSTACKBY             = 0x00000010,
    PDTF_ISTREEPROPERTY         = 0x00000020,
    PDTF_INCLUDEINFULLTEXTQUERY = 0x00000040,
    PDTF_ISVIEWABLE             = 0x00000080,
    PDTF_ISQUERYABLE            = 0x00000100,
    PDTF_CANBEPURGED            = 0x00000200,
    PDTF_SEARCHRAWVALUE         = 0x00000400,
    PDTF_ISSYSTEMPROPERTY       = 0x80000000,
    PDTF_MASK_ALL               = 0x800007FF
} PROPDESC_TYPE_FLAGS;

/* Property description view flags */
typedef enum PROPDESC_VIEW_FLAGS {
    PDVF_DEFAULT                = 0x00000000,
    PDVF_CENTERALIGN            = 0x00000001,
    PDVF_RIGHTALIGN             = 0x00000002,
    PDVF_BEGINNEWGROUP          = 0x00000004,
    PDVF_FILLAREA               = 0x00000008,
    PDVF_SORTDESCENDING         = 0x00000010,
    PDVF_SHOWONLYIFPRESENT      = 0x00000020,
    PDVF_SHOWBYDEFAULT          = 0x00000040,
    PDVF_SHOWINPRIMARYLIST      = 0x00000080,
    PDVF_SHOWINSECONDARYLIST    = 0x00000100,
    PDVF_HIDELABEL              = 0x00000200,
    PDVF_HIDDEN                 = 0x00000800,
    PDVF_CANWRAP                = 0x00001000,
    PDVF_MASK_ALL               = 0x00001BFF
} PROPDESC_VIEW_FLAGS;

/* Property description display types */
typedef enum PROPDESC_DISPLAYTYPE {
    PDDT_STRING     = 0,
    PDDT_NUMBER     = 1,
    PDDT_BOOLEAN    = 2,
    PDDT_DATETIME   = 3,
    PDDT_ENUMERATED = 4
} PROPDESC_DISPLAYTYPE;

/* Property description grouping ranges */
typedef enum PROPDESC_GROUPING_RANGE {
    PDGR_DISCRETE       = 0,
    PDGR_ALPHANUMERIC   = 1,
    PDGR_SIZE           = 2,
    PDGR_DYNAMIC        = 3,
    PDGR_DATE           = 4,
    PDGR_PERCENT        = 5,
    PDGR_ENUMERATED     = 6
} PROPDESC_GROUPING_RANGE;

/* Property description format flags */
typedef enum PROPDESC_FORMAT_FLAGS {
    PDFF_DEFAULT            = 0x00000000,
    PDFF_PREFIXNAME         = 0x00000001,
    PDFF_FILENAME           = 0x00000002,
    PDFF_ALWAYSKB           = 0x00000004,
    PDFF_SHORTTIME          = 0x00000010,
    PDFF_LONGTIME           = 0x00000020,
    PDFF_HIDETIME           = 0x00000040,
    PDFF_SHORTDATE          = 0x00000080,
    PDFF_LONGDATE           = 0x00000100,
    PDFF_HIDEDATE           = 0x00000200,
    PDFF_RELATIVEDATE       = 0x00000400,
    PDFF_USEEDITINVITATION  = 0x00000800,
    PDFF_READONLY           = 0x00001000,
    PDFF_NOAUTOREADINGORDER = 0x00002000
} PROPDESC_FORMAT_FLAGS;

/* Property description sort descriptions */
typedef enum PROPDESC_SORTDESCRIPTION {
    PDSD_GENERAL            = 0,
    PDSD_A_Z                = 1,
    PDSD_LOWEST_HIGHEST     = 2,
    PDSD_SMALLEST_BIGGEST   = 3,
    PDSD_OLDEST_NEWEST      = 4
} PROPDESC_SORTDESCRIPTION;

/* Property description relative description types */
typedef enum PROPDESC_RELATIVEDESCRIPTION_TYPE {
    PDRDT_GENERAL   = 0,
    PDRDT_DATE      = 1,
    PDRDT_SIZE      = 2,
    PDRDT_COUNT     = 3,
    PDRDT_REVISION  = 4,
    PDRDT_LENGTH    = 5,
    PDRDT_DURATION  = 6,
    PDRDT_SPEED     = 7,
    PDRDT_RATE      = 8,
    PDRDT_RATING    = 9,
    PDRDT_PRIORITY  = 10
} PROPDESC_RELATIVEDESCRIPTION_TYPE;

/* Property description aggregation types */
typedef enum PROPDESC_AGGREGATION_TYPE {
    PDAT_DEFAULT    = 0,
    PDAT_FIRST      = 1,
    PDAT_SUM        = 2,
    PDAT_AVERAGE    = 3,
    PDAT_DATERANGE  = 4,
    PDAT_UNION      = 5,
    PDAT_MAX        = 6,
    PDAT_MIN        = 7
} PROPDESC_AGGREGATION_TYPE;

/* Property description condition types */
typedef enum PROPDESC_CONDITION_TYPE {
    PDCOT_NONE      = 0,
    PDCOT_STRING    = 1,
    PDCOT_SIZE      = 2,
    PDCOT_DATETIME  = 3,
    PDCOT_BOOLEAN   = 4,
    PDCOT_NUMBER    = 5
} PROPDESC_CONDITION_TYPE;

/* Property description search information flags */
typedef enum PROPDESC_SEARCHINFO_FLAGS {
    PDSIF_DEFAULT           = 0x00000000,
    PDSIF_ININVERTEDINDEX   = 0x00000001,
    PDSIF_ISCOLUMN          = 0x00000002,
    PDSIF_ISCOLUMNSPARSE    = 0x00000004,
    PDSIF_ALWAYSINCLUDE     = 0x00000008
} PROPDESC_SEARCHINFO_FLAGS;

/* Property description column index types */
typedef enum PROPDESC_COLUMNINDEX_TYPE {
    PDCIT_NONE          = 0,
    PDCIT_ONDISK        = 1,
    PDCIT_INMEMORY      = 2,
    PDCIT_ONDEMAND      = 3,
    PDCIT_ONDISKALL     = 4,
    PDCIT_ONDISKVECTOR  = 5
} PROPDESC_COLUMNINDEX_TYPE;

/* Property description enumeration filter flags */
typedef enum PROPDESC_ENUMFILTER {
    PDEF_ALL                = 0,
    PDEF_SYSTEM             = 1,
    PDEF_NONSYSTEM          = 2,
    PDEF_VIEWABLE           = 3,
    PDEF_QUERYABLE          = 4,
    PDEF_INFULLTEXTQUERY    = 5,
    PDEF_COLUMN             = 6
} PROPDESC_ENUMFILTER;

/* Persist serialized property store flags */
enum _PERSIST_SPROPSTORE_FLAGS {
    FPSPS_DEFAULT   = 0x00000000,
    FPSPS_READONLY  = 0x00000001
};
typedef int PERSIST_SPROPSTORE_FLAGS;

/* Serialized property storage */
typedef struct tagSERIALIZEDPROPSTORAGE SERIALIZEDPROPSTORAGE;
typedef SERIALIZEDPROPSTORAGE           *PUSERIALIZEDPROPSTORAGE;
typedef const SERIALIZEDPROPSTORAGE     *PCUSERIALIZEDPROPSTORAGE;

/* IInitializeWithFile interface */
#undef INTERFACE
#define INTERFACE   IInitializeWithFile
DECLARE_INTERFACE_( IInitializeWithFile, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInitializeWithFile methods */
    STDMETHOD( Initialize )( THIS_ LPCWSTR, DWORD ) PURE;
};

/* IInitializeWithStream interface */
#undef INTERFACE
#define INTERFACE   IInitializeWithStream
DECLARE_INTERFACE_( IInitializeWithStream, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInitializeWithStream methods */
    STDMETHOD( Initialize )( THIS_ IStream *, DWORD ) PURE;
};

/* IPropertyStore interface */
#undef INTERFACE
#define INTERFACE   IPropertyStore
DECLARE_INTERFACE_( IPropertyStore, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyStore methods */
    STDMETHOD( GetCount )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetAt )( THIS_ DWORD, PROPERTYKEY * ) PURE;
    STDMETHOD( GetValue )( THIS_ REFPROPERTYKEY, PROPVARIANT * ) PURE;
    STDMETHOD( SetValue )( THIS_ REFPROPERTYKEY, REFPROPVARIANT ) PURE;
    STDMETHOD( Commit )( THIS ) PURE;
};
typedef IPropertyStore  *LPPROPERTYSTORE;

/* INamedPropertyStore interface */
#undef INTERFACE
#define INTERFACE   INamedPropertyStore
DECLARE_INTERFACE_( INamedPropertyStore, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* INamedPropertyStore methods */
    STDMETHOD( GetNamedValue )( THIS_ LPCWSTR, PROPVARIANT * ) PURE;
    STDMETHOD( SetNamedValue )( THIS_ LPCWSTR, REFPROPVARIANT ) PURE;
    STDMETHOD( GetNameCount )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetNameAt )( THIS_ DWORD, BSTR * ) PURE;
};

/* IObjectWithPropertyKey interface */
#undef INTERFACE
#define INTERFACE   IObjectWithPropertyKey
DECLARE_INTERFACE_( IObjectWithPropertyKey, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IObjectWithPropertyKey methods */
    STDMETHOD( SetPropertyKey )( THIS_ REFPROPERTYKEY ) PURE;
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
};

/* IPropertyChange interface */
#undef INTERFACE
#define INTERFACE   IPropertyChange
DECLARE_INTERFACE_( IPropertyChange, IObjectWithPropertyKey ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IObjectWithPropertyKey methods */
    STDMETHOD( SetPropertyKey )( THIS_ REFPROPERTYKEY ) PURE;
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;

    /* IPropertyChange methods */
    STDMETHOD( ApplyToPropVariant )( THIS_ REFPROPVARIANT, PROPVARIANT * ) PURE;
};

/* IPropertyChangeArray interface */
#undef INTERFACE
#define INTERFACE   IPropertyChangeArray
DECLARE_INTERFACE_( IPropertyChangeArray, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyChangeArray methods */
    STDMETHOD( GetCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetAt )( THIS_ UINT, REFIID, void ** ) PURE;
    STDMETHOD( InsertAt )( THIS_ UINT, IPropertyChange * ) PURE;
    STDMETHOD( Append )( THIS_ IPropertyChange * ) PURE;
    STDMETHOD( AppendOrReplace )( THIS_ IPropertyChange * ) PURE;
    STDMETHOD( RemoveAt )( THIS_ UINT ) PURE;
    STDMETHOD( IsKeyInArray )( THIS_ REFPROPERTYKEY ) PURE;
};

/* IPropertyStoreCapabilities interface */
#undef INTERFACE
#define INTERFACE   IPropertyStoreCapabilities
DECLARE_INTERFACE_( IPropertyStoreCapabilities, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyStoreCapabilities methods */
    STDMETHOD( IsPropertyWritable )( THIS_ REFPROPERTYKEY ) PURE;
};

/* IPropertyStoreCache interface */
#undef INTERFACE
#define INTERFACE   IPropertyStoreCache
DECLARE_INTERFACE_( IPropertyStoreCache, IPropertyStore ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyStore methods */
    STDMETHOD( GetCount )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetAt )( THIS_ DWORD, PROPERTYKEY * ) PURE;
    STDMETHOD( GetValue )( THIS_ REFPROPERTYKEY, PROPVARIANT * ) PURE;
    STDMETHOD( SetValue )( THIS_ REFPROPERTYKEY, REFPROPVARIANT ) PURE;
    STDMETHOD( Commit )( THIS ) PURE;

    /* IPropertyStoreCache methods */
    STDMETHOD( GetState )( THIS_ REFPROPERTYKEY, PSC_STATE * ) PURE;
    STDMETHOD( GetValueAndState )( THIS_ REFPROPERTYKEY, PROPVARIANT *, PSC_STATE * ) PURE;
    STDMETHOD( SetState )( THIS_ REFPROPERTYKEY, PSC_STATE ) PURE;
    STDMETHOD( SetValueAndState )( THIS_ REFPROPERTYKEY, const PROPVARIANT *, PSC_STATE ) PURE;
};

/* IPropertyEnumType interface */
#undef INTERFACE
#define INTERFACE   IPropertyEnumType
DECLARE_INTERFACE_( IPropertyEnumType, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyEnumType methods */
    STDMETHOD( GetEnumType )( THIS_ PROPENUMTYPE * ) PURE;
    STDMETHOD( GetValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetRangeMinValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetRangeSetValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetDisplayText )( THIS_ LPWSTR * ) PURE;
};

/* IPropertyEnumType2 interface */
#undef INTERFACE
#define INTERFACE   IPropertyEnumType2
DECLARE_INTERFACE_( IPropertyEnumType2, IPropertyEnumType ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyEnumType methods */
    STDMETHOD( GetEnumType )( THIS_ PROPENUMTYPE * ) PURE;
    STDMETHOD( GetValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetRangeMinValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetRangeSetValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( GetDisplayText )( THIS_ LPWSTR * ) PURE;

    /* IPropertyEnumType2 methods */
    STDMETHOD( GetImageReference )( THIS_ LPWSTR * ) PURE;
};

/* IPropertyEnumTypeList interface */
#undef INTERFACE
#define INTERFACE   IPropertyEnumTypeList
DECLARE_INTERFACE_( IPropertyEnumTypeList, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyEnumTypeList methods */
    STDMETHOD( GetCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetAt )( THIS_ UINT, REFIID, void ** ) PURE;
    STDMETHOD( GetConditionAt )( THIS_ UINT, REFIID, void ** ) PURE;
    STDMETHOD( FindMatchingIndex )( THIS_ REFPROPVARIANT, UINT * ) PURE;
};

/* IPropertyDescription interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescription
DECLARE_INTERFACE_( IPropertyDescription, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescription methods */
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
    STDMETHOD( GetCanonicalName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetPropertyType )( THIS_ VARTYPE * ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetEditInvitation )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ PROPDESC_TYPE_FLAGS, PROPDESC_TYPE_FLAGS * ) PURE;
    STDMETHOD( GetViewFlags )( THIS_ PROPDESC_VIEW_FLAGS * ) PURE;
    STDMETHOD( GetDefaultColumnWidth )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDisplayType )( THIS_ PROPDESC_DISPLAYTYPE * ) PURE;
    STDMETHOD( GetColumnState )( THIS_ SHCOLSTATEF * ) PURE;
    STDMETHOD( GetGroupingRange )( THIS_ PROPDESC_GROUPING_RANGE * ) PURE;
    STDMETHOD( GetRelativeDescriptionType )( THIS_ PROPDESC_RELATIVEDESCRIPTION_TYPE * ) PURE;
    STDMETHOD( GetRelativeDescription )( THIS_ REFPROPVARIANT, REFPROPVARIANT, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetSortDescription )( THIS_ PROPDESC_SORTDESCRIPTION * ) PURE;
    STDMETHOD( GetSortDescriptionLabel )( THIS_ BOOL, LPWSTR * ) PURE;
    STDMETHOD( GetAggregationType )( THIS_ PROPDESC_AGGREGATION_TYPE * ) PURE;
    STDMETHOD( GetConditionType )( THIS_ PROPDESC_CONDITION_TYPE *, CONDITION_OPERATION * ) PURE;
    STDMETHOD( GetEnumTypeList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( CoerceToCanonicalValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( IsValueCanonical )( THIS_ REFPROPVARIANT ) PURE;
};

/* IPropertyDescription2 interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescription2
DECLARE_INTERFACE_( IPropertyDescription2, IPropertyDescription ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescription methods */
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
    STDMETHOD( GetCanonicalName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetPropertyType )( THIS_ VARTYPE * ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetEditInvitation )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ PROPDESC_TYPE_FLAGS, PROPDESC_TYPE_FLAGS * ) PURE;
    STDMETHOD( GetViewFlags )( THIS_ PROPDESC_VIEW_FLAGS * ) PURE;
    STDMETHOD( GetDefaultColumnWidth )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDisplayType )( THIS_ PROPDESC_DISPLAYTYPE * ) PURE;
    STDMETHOD( GetColumnState )( THIS_ SHCOLSTATEF * ) PURE;
    STDMETHOD( GetGroupingRange )( THIS_ PROPDESC_GROUPING_RANGE * ) PURE;
    STDMETHOD( GetRelativeDescriptionType )( THIS_ PROPDESC_RELATIVEDESCRIPTION_TYPE * ) PURE;
    STDMETHOD( GetRelativeDescription )( THIS_ REFPROPVARIANT, REFPROPVARIANT, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetSortDescription )( THIS_ PROPDESC_SORTDESCRIPTION * ) PURE;
    STDMETHOD( GetSortDescriptionLabel )( THIS_ BOOL, LPWSTR * ) PURE;
    STDMETHOD( GetAggregationType )( THIS_ PROPDESC_AGGREGATION_TYPE * ) PURE;
    STDMETHOD( GetConditionType )( THIS_ PROPDESC_CONDITION_TYPE *, CONDITION_OPERATION * ) PURE;
    STDMETHOD( GetEnumTypeList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( CoerceToCanonicalValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( IsValueCanonical )( THIS_ REFPROPVARIANT ) PURE;

    /* IPropertyDescription2 methods */
    STDMETHOD( GetImageReferenceForValue )( THIS_ REFPROPVARIANT, LPWSTR * ) PURE;
};

/* IPropertyDescriptionAliasInfo interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescriptionAliasInfo
DECLARE_INTERFACE_( IPropertyDescriptionAliasInfo, IPropertyDescription ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescription methods */
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
    STDMETHOD( GetCanonicalName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetPropertyType )( THIS_ VARTYPE * ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetEditInvitation )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ PROPDESC_TYPE_FLAGS, PROPDESC_TYPE_FLAGS * ) PURE;
    STDMETHOD( GetViewFlags )( THIS_ PROPDESC_VIEW_FLAGS * ) PURE;
    STDMETHOD( GetDefaultColumnWidth )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDisplayType )( THIS_ PROPDESC_DISPLAYTYPE * ) PURE;
    STDMETHOD( GetColumnState )( THIS_ SHCOLSTATEF * ) PURE;
    STDMETHOD( GetGroupingRange )( THIS_ PROPDESC_GROUPING_RANGE * ) PURE;
    STDMETHOD( GetRelativeDescriptionType )( THIS_ PROPDESC_RELATIVEDESCRIPTION_TYPE * ) PURE;
    STDMETHOD( GetRelativeDescription )( THIS_ REFPROPVARIANT, REFPROPVARIANT, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetSortDescription )( THIS_ PROPDESC_SORTDESCRIPTION * ) PURE;
    STDMETHOD( GetSortDescriptionLabel )( THIS_ BOOL, LPWSTR * ) PURE;
    STDMETHOD( GetAggregationType )( THIS_ PROPDESC_AGGREGATION_TYPE * ) PURE;
    STDMETHOD( GetConditionType )( THIS_ PROPDESC_CONDITION_TYPE *, CONDITION_OPERATION * ) PURE;
    STDMETHOD( GetEnumTypeList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( CoerceToCanonicalValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( IsValueCanonical )( THIS_ REFPROPVARIANT ) PURE;

    /* IPropertyDescriptionAliasInfo methods */
    STDMETHOD( GetSortByAlias )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( GetAdditionalSortByAliases )( THIS_ REFIID, void ** ) PURE;
};

/* IPropertyDescriptionSearchInfo interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescriptionSearchInfo
DECLARE_INTERFACE_( IPropertyDescriptionSearchInfo, IPropertyDescription ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescription methods */
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
    STDMETHOD( GetCanonicalName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetPropertyType )( THIS_ VARTYPE * ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetEditInvitation )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ PROPDESC_TYPE_FLAGS, PROPDESC_TYPE_FLAGS * ) PURE;
    STDMETHOD( GetViewFlags )( THIS_ PROPDESC_VIEW_FLAGS * ) PURE;
    STDMETHOD( GetDefaultColumnWidth )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDisplayType )( THIS_ PROPDESC_DISPLAYTYPE * ) PURE;
    STDMETHOD( GetColumnState )( THIS_ SHCOLSTATEF * ) PURE;
    STDMETHOD( GetGroupingRange )( THIS_ PROPDESC_GROUPING_RANGE * ) PURE;
    STDMETHOD( GetRelativeDescriptionType )( THIS_ PROPDESC_RELATIVEDESCRIPTION_TYPE * ) PURE;
    STDMETHOD( GetRelativeDescription )( THIS_ REFPROPVARIANT, REFPROPVARIANT, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetSortDescription )( THIS_ PROPDESC_SORTDESCRIPTION * ) PURE;
    STDMETHOD( GetSortDescriptionLabel )( THIS_ BOOL, LPWSTR * ) PURE;
    STDMETHOD( GetAggregationType )( THIS_ PROPDESC_AGGREGATION_TYPE * ) PURE;
    STDMETHOD( GetConditionType )( THIS_ PROPDESC_CONDITION_TYPE *, CONDITION_OPERATION * ) PURE;
    STDMETHOD( GetEnumTypeList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( CoerceToCanonicalValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( IsValueCanonical )( THIS_ REFPROPVARIANT ) PURE;

    /* IPropertyDescriptionSearchInfo methods */
    STDMETHOD( GetSearchInfoFlags )( THIS_ PROPDESC_SEARCHINFO_FLAGS * ) PURE;
    STDMETHOD( GetColumnIndexType )( THIS_ PROPDESC_COLUMNINDEX_TYPE * ) PURE;
    STDMETHOD( GetProjectionString )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetMaxSize )( THIS_ UINT * ) PURE;
};

/* IPropertyDescriptionRelatedPropertyInfo interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescriptionRelatedPropertyInfo
DECLARE_INTERFACE_( IPropertyDescriptionRelatedPropertyInfo, IPropertyDescription ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescription methods */
    STDMETHOD( GetPropertyKey )( THIS_ PROPERTYKEY * ) PURE;
    STDMETHOD( GetCanonicalName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetPropertyType )( THIS_ VARTYPE * ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetEditInvitation )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( GetTypeFlags )( THIS_ PROPDESC_TYPE_FLAGS, PROPDESC_TYPE_FLAGS * ) PURE;
    STDMETHOD( GetViewFlags )( THIS_ PROPDESC_VIEW_FLAGS * ) PURE;
    STDMETHOD( GetDefaultColumnWidth )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDisplayType )( THIS_ PROPDESC_DISPLAYTYPE * ) PURE;
    STDMETHOD( GetColumnState )( THIS_ SHCOLSTATEF * ) PURE;
    STDMETHOD( GetGroupingRange )( THIS_ PROPDESC_GROUPING_RANGE * ) PURE;
    STDMETHOD( GetRelativeDescriptionType )( THIS_ PROPDESC_RELATIVEDESCRIPTION_TYPE * ) PURE;
    STDMETHOD( GetRelativeDescription )( THIS_ REFPROPVARIANT, REFPROPVARIANT, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetSortDescription )( THIS_ PROPDESC_SORTDESCRIPTION * ) PURE;
    STDMETHOD( GetSortDescriptionLabel )( THIS_ BOOL, LPWSTR * ) PURE;
    STDMETHOD( GetAggregationType )( THIS_ PROPDESC_AGGREGATION_TYPE * ) PURE;
    STDMETHOD( GetConditionType )( THIS_ PROPDESC_CONDITION_TYPE *, CONDITION_OPERATION * ) PURE;
    STDMETHOD( GetEnumTypeList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( CoerceToCanonicalValue )( THIS_ PROPVARIANT * ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( IsValueCanonical )( THIS_ REFPROPVARIANT ) PURE;

    /* IPropertyDescriptionRelatedPropertyInfo methods */
    STDMETHOD( GetRelatedProperty )( THIS_ LPCWSTR, REFIID, void ** ) PURE;
};

/* IPropertySystem interface */
#undef INTERFACE
#define INTERFACE   IPropertySystem
DECLARE_INTERFACE_( IPropertySystem, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertySystem methods */
    STDMETHOD( GetPropertyDescription )( THIS_ REFPROPERTYKEY, REFIID, void ** ) PURE;
    STDMETHOD( GetPropertyDescriptionByName )( THIS_ LPCWSTR, REFIID, void ** ) PURE;
    STDMETHOD( GetPropertyDescriptionListFromString )( THIS_ LPCWSTR, REFIID, void ** ) PURE;
    STDMETHOD( EnumeratePropertyDescriptions )( THIS_ PROPDESC_ENUMFILTER, REFIID, void ** ) PURE;
    STDMETHOD( FormatForDisplay )( THIS_ REFPROPERTYKEY, REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR, DWORD ) PURE;
    STDMETHOD( FormatForDisplayAlloc )( THIS_ REFPROPERTYKEY, REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR * ) PURE;
    STDMETHOD( RegisterPropertySchema )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( UnregisterPropertySchema )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( RefreshPropertySchema )( THIS ) PURE;
};

/* IPropertyDescriptionList interface */
#undef INTERFACE
#define INTERFACE   IPropertyDescriptionList
DECLARE_INTERFACE_( IPropertyDescriptionList, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyDescriptionList methods */
    STDMETHOD( GetCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetAt )( THIS_ UINT, REFIID, void ** ) PURE;
};

/* IPropertyStoreFactory interface */
#undef INTERFACE
#define INTERFACE   IPropertyStoreFactory
DECLARE_INTERFACE_( IPropertyStoreFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyStoreFactory methods */
    STDMETHOD( GetPropertyStore )( THIS_ GETPROPERTYSTOREFLAGS, IUnknown *, REFIID, void ** ) PURE;
    STDMETHOD( GetPropertyStoreForKeys )( THIS_ const PROPERTYKEY *, UINT, GETPROPERTYSTOREFLAGS, REFIID, void ** ) PURE;
};

/* IDelayedPropertyStoreFactory interface */
#undef INTERFACE
#define INTERFACE   IDelayedPropertyStoreFactory
DECLARE_INTERFACE_( IDelayedPropertyStoreFactory, IPropertyStoreFactory ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertyStoreFactory methods */
    STDMETHOD( GetPropertyStore )( THIS_ GETPROPERTYSTOREFLAGS, IUnknown *, REFIID, void ** ) PURE;
    STDMETHOD( GetPropertyStoreForKeys )( THIS_ const PROPERTYKEY *, UINT, GETPROPERTYSTOREFLAGS, REFIID, void ** ) PURE;

    /* IDelayedPropertyStoreFactory methods */
    STDMETHOD( GetDelayedPropertyStore )( THIS_ GETPROPERTYSTOREFLAGS, DWORD, REFIID, void ** ) PURE;
};

/* IPersistSerializedPropStorage interface */
#undef INTERFACE
#define INTERFACE   IPersistSerializedPropStorage
DECLARE_INTERFACE_( IPersistSerializedPropStorage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPersistSerializedPropStorage methods */
    STDMETHOD( SetFlags )( THIS_ PERSIST_SPROPSTORE_FLAGS ) PURE;
    STDMETHOD( SetPropertyStorage )( THIS_ PCUSERIALIZEDPROPSTORAGE, DWORD ) PURE;
    STDMETHOD( GetPropertyStorage )( THIS_ SERIALIZEDPROPSTORAGE **, DWORD * ) PURE;
};

/* IPersistSerializedPropStorage2 interface */
#undef INTERFACE
#define INTERFACE   IPersistSerializedPropStorage2
DECLARE_INTERFACE_( IPersistSerializedPropStorage2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPersistSerializedPropStorage methods */
    STDMETHOD( SetFlags )( THIS_ PERSIST_SPROPSTORE_FLAGS ) PURE;
    STDMETHOD( SetPropertyStorage )( THIS_ PCUSERIALIZEDPROPSTORAGE, DWORD ) PURE;
    STDMETHOD( GetPropertyStorage )( THIS_ SERIALIZEDPROPSTORAGE **, DWORD * ) PURE;

    /* IPersistSerializedPropStorage2 methods */
    STDMETHOD( GetPropertyStorageSize )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetPropertyStorageBuffer )( THIS_ SERIALIZEDPROPSTORAGE *, DWORD, DWORD * ) PURE;
};

/* IPropertySystemChangeNotify interface */
#undef INTERFACE
#define INTERFACE   IPropertySystemChangeNotify
DECLARE_INTERFACE_( IPropertySystemChangeNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertySystemChangeNotify methods */
    STDMETHOD( SchemaRefreshed )( THIS ) PURE;
};

/* ICreateObject interface */
#undef INTERFACE
#define INTERFACE   ICreateObject
DECLARE_INTERFACE_( ICreateObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICreateObject methods */
    STDMETHOD( CreateObject )( THIS_ REFCLSID, IUnknown *, REFIID, void ** ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IInitializeWithFile_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInitializeWithFile_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInitializeWithFile_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInitializeWithFile_Initialize( x, p1, p2 ) \
        (x)->lpVtbl->Initialize( x, p1, p2 )
    #define IInitializeWithStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInitializeWithStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInitializeWithStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInitializeWithStream_Initialize( x, p1, p2 ) \
        (x)->lpVtbl->Initialize( x, p1, p2 )
    #define IPropertyStore_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyStore_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyStore_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyStore_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IPropertyStore_GetAt( x, p1, p2 ) \
        (x)->lpVtbl->GetAt( x, p1, p2 )
    #define IPropertyStore_GetValue( x, p1, p2 ) \
        (x)->lpVtbl->GetValue( x, p1, p2 )
    #define IPropertyStore_SetValue( x, p1, p2 ) \
        (x)->lpVtbl->SetValue( x, p1, p2 )
    #define IPropertyStore_Commit( x ) \
        (x)->lpVtbl->Commit( x )
    #define INamedPropertyStore_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define INamedPropertyStore_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define INamedPropertyStore_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define INamedPropertyStore_GetNamedValue( x, p1, p2 ) \
        (x)->lpVtbl->GetNamedValue( x, p1, p2 )
    #define INamedPropertyStore_SetNamedValue( x, p1, p2 ) \
        (x)->lpVtbl->SetNamedValue( x, p1, p2 )
    #define INamedPropertyStore_GetNameCount( x, p ) \
        (x)->lpVtbl->GetNameCount( x, p )
    #define INamedPropertyStore_GetNameAt( x, p1, p2 ) \
        (x)->lpVtbl->GetNameAt( x, p1, p2 )
    #define IObjectWithPropertyKey_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IObjectWithPropertyKey_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IObjectWithPropertyKey_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IObjectWithPropertyKey_SetPropertyKey( x, p ) \
        (x)->lpVtbl->SetPropertyKey( x, p )
    #define IObjectWithPropertyKey_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyChange_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyChange_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyChange_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyChange_SetPropertyKey( x, p ) \
        (x)->lpVtbl->SetPropertyKey( x, p )
    #define IPropertyChange_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyChange_ApplyToPropVariant( x, p1, p2 ) \
        (x)->lpVtbl->ApplyToPropVariant( x, p1, p2 )
    #define IPropertyChangeArray_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyChangeArray_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyChangeArray_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyChangeArray_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IPropertyChangeArray_GetAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAt( x, p1, p2, p3 )
    #define IPropertyChangeArray_InsertAt( x, p1, p2 ) \
        (x)->lpVtbl->InsertAt( x, p1, p2 )
    #define IPropertyChangeArray_Append( x, p ) \
        (x)->lpVtbl->Append( x, p )
    #define IPropertyChangeArray_AppendOrReplace( x, p ) \
        (x)->lpVtbl->AppendOrReplace( x, p )
    #define IPropertyChangeArray_RemoveAt( x, p ) \
        (x)->lpVtbl->RemoveAt( x, p )
    #define IPropertyChangeArray_IsKeyInArray( x, p ) \
        (x)->lpVtbl->IsKeyInArray( x, p )
    #define IPropertyStoreCapabilities_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyStoreCapabilities_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyStoreCapabilities_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyStoreCapabilities_IsPropertyWritable( x, p ) \
        (x)->lpVtbl->IsPropertyWritable( x, p )
    #define IPropertyStoreCache_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyStoreCache_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyStoreCache_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyStoreCache_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IPropertyStoreCache_GetAt( x, p1, p2 ) \
        (x)->lpVtbl->GetAt( x, p1, p2 )
    #define IPropertyStoreCache_GetValue( x, p1, p2 ) \
        (x)->lpVtbl->GetValue( x, p1, p2 )
    #define IPropertyStoreCache_SetValue( x, p1, p2 ) \
        (x)->lpVtbl->SetValue( x, p1, p2 )
    #define IPropertyStoreCache_Commit( x ) \
        (x)->lpVtbl->Commit( x )
    #define IPropertyStoreCache_GetState( x, p1, p2 ) \
        (x)->lpVtbl->GetState( x, p1, p2 )
    #define IPropertyStoreCache_GetValueAndState( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetValueAndState( x, p1, p2, p3 )
    #define IPropertyStoreCache_SetState( x, p1, p2 ) \
        (x)->lpVtbl->SetState( x, p1, p2 )
    #define IPropertyStoreCache_SetValueAndState( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetValueAndState( x, p1, p2, p3 )
    #define IPropertyEnumType_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyEnumType_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyEnumType_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyEnumType_GetEnumType( x, p ) \
        (x)->lpVtbl->GetEnumType( x, p )
    #define IPropertyEnumType_GetValue( x, p ) \
        (x)->lpVtbl->GetValue( x, p )
    #define IPropertyEnumType_GetRangeMinValue( x, p ) \
        (x)->lpVtbl->GetRangeMinValue( x, p )
    #define IPropertyEnumType_GetRangeSetValue( x, p ) \
        (x)->lpVtbl->GetRangeSetValue( x, p )
    #define IPropertyEnumType_GetDisplayText( x, p ) \
        (x)->lpVtbl->GetDisplayText( x, p )
    #define IPropertyEnumType2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyEnumType2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyEnumType2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyEnumType2_GetEnumType( x, p ) \
        (x)->lpVtbl->GetEnumType( x, p )
    #define IPropertyEnumType2_GetValue( x, p ) \
        (x)->lpVtbl->GetValue( x, p )
    #define IPropertyEnumType2_GetRangeMinValue( x, p ) \
        (x)->lpVtbl->GetRangeMinValue( x, p )
    #define IPropertyEnumType2_GetRangeSetValue( x, p ) \
        (x)->lpVtbl->GetRangeSetValue( x, p )
    #define IPropertyEnumType2_GetDisplayText( x, p ) \
        (x)->lpVtbl->GetDisplayText( x, p )
    #define IPropertyEnumType2_GetImageReference( x, p ) \
        (x)->lpVtbl->GetImageReference( x, p )
    #define IPropertyEnumTypeList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyEnumTypeList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyEnumTypeList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyEnumTypeList_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IPropertyEnumTypeList_GetAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAt( x, p1, p2, p3 )
    #define IPropertyEnumTypeList_GetConditionAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetConditionAt( x, p1, p2, p3 )
    #define IPropertyEnumTypeList_FindMatchingIndex( x, p1, p2 ) \
        (x)->lpVtbl->FindMatchingIndex( x, p1, p2 )
    #define IPropertyDescription_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescription_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescription_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescription_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyDescription_GetCanonicalName( x, p ) \
        (x)->lpVtbl->GetCanonicalName( x, p )
    #define IPropertyDescription_GetPropertyType( x, p ) \
        (x)->lpVtbl->GetPropertyType( x, p )
    #define IPropertyDescription_GetDisplayName( x, p ) \
        (x)->lpVtbl->GetDisplayName( x, p )
    #define IPropertyDescription_GetEditInvitation( x, p ) \
        (x)->lpVtbl->GetEditInvitation( x, p )
    #define IPropertyDescription_GetTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeFlags( x, p1, p2 )
    #define IPropertyDescription_GetViewFlags( x, p ) \
        (x)->lpVtbl->GetViewFlags( x, p )
    #define IPropertyDescription_GetDefaultColumnWidth( x, p ) \
        (x)->lpVtbl->GetDefaultColumnWidth( x, p )
    #define IPropertyDescription_GetDisplayType( x, p ) \
        (x)->lpVtbl->GetDisplayType( x, p )
    #define IPropertyDescription_GetColumnState( x, p ) \
        (x)->lpVtbl->GetColumnState( x, p )
    #define IPropertyDescription_GetGroupingRange( x, p ) \
        (x)->lpVtbl->GetGroupingRange( x, p )
    #define IPropertyDescription_GetRelativeDescriptionType( x, p ) \
        (x)->lpVtbl->GetRelativeDescriptionType( x, p )
    #define IPropertyDescription_GetRelativeDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRelativeDescription( x, p1, p2, p3, p4 )
    #define IPropertyDescription_GetSortDescription( x, p ) \
        (x)->lpVtbl->GetSortDescription( x, p )
    #define IPropertyDescription_GetSortDescriptionLabel( x, p1, p2 ) \
        (x)->lpVtbl->GetSortDescriptionLabel( x, p1, p2 )
    #define IPropertyDescription_GetAggregationType( x, p ) \
        (x)->lpVtbl->GetAggregationType( x, p )
    #define IPropertyDescription_GetConditionType( x, p1, p2 ) \
        (x)->lpVtbl->GetConditionType( x, p1, p2 )
    #define IPropertyDescription_GetEnumTypeList( x, p1, p2 ) \
        (x)->lpVtbl->GetEnumTypeList( x, p1, p2 )
    #define IPropertyDescription_CoerceToCanonicalValue( x, p ) \
        (x)->lpVtbl->CoerceToCanonicalValue( x, p )
    #define IPropertyDescription_FormatForDisplay( x, p1, p2, p3 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3 )
    #define IPropertyDescription_IsValueCanonical( x, p ) \
        (x)->lpVtbl->IsValueCanonical( x, p )
    #define IPropertyDescription2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescription2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescription2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescription2_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyDescription2_GetCanonicalName( x, p ) \
        (x)->lpVtbl->GetCanonicalName( x, p )
    #define IPropertyDescription2_GetPropertyType( x, p ) \
        (x)->lpVtbl->GetPropertyType( x, p )
    #define IPropertyDescription2_GetDisplayName( x, p ) \
        (x)->lpVtbl->GetDisplayName( x, p )
    #define IPropertyDescription2_GetEditInvitation( x, p ) \
        (x)->lpVtbl->GetEditInvitation( x, p )
    #define IPropertyDescription2_GetTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeFlags( x, p1, p2 )
    #define IPropertyDescription2_GetViewFlags( x, p ) \
        (x)->lpVtbl->GetViewFlags( x, p )
    #define IPropertyDescription2_GetDefaultColumnWidth( x, p ) \
        (x)->lpVtbl->GetDefaultColumnWidth( x, p )
    #define IPropertyDescription2_GetDisplayType( x, p ) \
        (x)->lpVtbl->GetDisplayType( x, p )
    #define IPropertyDescription2_GetColumnState( x, p ) \
        (x)->lpVtbl->GetColumnState( x, p )
    #define IPropertyDescription2_GetGroupingRange( x, p ) \
        (x)->lpVtbl->GetGroupingRange( x, p )
    #define IPropertyDescription2_GetRelativeDescriptionType( x, p ) \
        (x)->lpVtbl->GetRelativeDescriptionType( x, p )
    #define IPropertyDescription2_GetRelativeDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRelativeDescription( x, p1, p2, p3, p4 )
    #define IPropertyDescription2_GetSortDescription( x, p ) \
        (x)->lpVtbl->GetSortDescription( x, p )
    #define IPropertyDescription2_GetSortDescriptionLabel( x, p1, p2 ) \
        (x)->lpVtbl->GetSortDescriptionLabel( x, p1, p2 )
    #define IPropertyDescription2_GetAggregationType( x, p ) \
        (x)->lpVtbl->GetAggregationType( x, p )
    #define IPropertyDescription2_GetConditionType( x, p1, p2 ) \
        (x)->lpVtbl->GetConditionType( x, p1, p2 )
    #define IPropertyDescription2_GetEnumTypeList( x, p1, p2 ) \
        (x)->lpVtbl->GetEnumTypeList( x, p1, p2 )
    #define IPropertyDescription2_CoerceToCanonicalValue( x, p ) \
        (x)->lpVtbl->CoerceToCanonicalValue( x, p )
    #define IPropertyDescription2_FormatForDisplay( x, p1, p2, p3 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3 )
    #define IPropertyDescription2_IsValueCanonical( x, p ) \
        (x)->lpVtbl->IsValueCanonical( x, p )
    #define IPropertyDescription2_GetImageReferenceForValue( x, p1, p2 ) \
        (x)->lpVtbl->GetImageReferenceForValue( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescriptionAliasInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescriptionAliasInfo_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyDescriptionAliasInfo_GetCanonicalName( x, p ) \
        (x)->lpVtbl->GetCanonicalName( x, p )
    #define IPropertyDescriptionAliasInfo_GetPropertyType( x, p ) \
        (x)->lpVtbl->GetPropertyType( x, p )
    #define IPropertyDescriptionAliasInfo_GetDisplayName( x, p ) \
        (x)->lpVtbl->GetDisplayName( x, p )
    #define IPropertyDescriptionAliasInfo_GetEditInvitation( x, p ) \
        (x)->lpVtbl->GetEditInvitation( x, p )
    #define IPropertyDescriptionAliasInfo_GetTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeFlags( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_GetViewFlags( x, p ) \
        (x)->lpVtbl->GetViewFlags( x, p )
    #define IPropertyDescriptionAliasInfo_GetDefaultColumnWidth( x, p ) \
        (x)->lpVtbl->GetDefaultColumnWidth( x, p )
    #define IPropertyDescriptionAliasInfo_GetDisplayType( x, p ) \
        (x)->lpVtbl->GetDisplayType( x, p )
    #define IPropertyDescriptionAliasInfo_GetColumnState( x, p ) \
        (x)->lpVtbl->GetColumnState( x, p )
    #define IPropertyDescriptionAliasInfo_GetGroupingRange( x, p ) \
        (x)->lpVtbl->GetGroupingRange( x, p )
    #define IPropertyDescriptionAliasInfo_GetRelativeDescriptionType( x, p ) \
        (x)->lpVtbl->GetRelativeDescriptionType( x, p )
    #define IPropertyDescriptionAliasInfo_GetRelativeDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRelativeDescription( x, p1, p2, p3, p4 )
    #define IPropertyDescriptionAliasInfo_GetSortDescription( x, p ) \
        (x)->lpVtbl->GetSortDescription( x, p )
    #define IPropertyDescriptionAliasInfo_GetSortDescriptionLabel( x, p1, p2 ) \
        (x)->lpVtbl->GetSortDescriptionLabel( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_GetAggregationType( x, p ) \
        (x)->lpVtbl->GetAggregationType( x, p )
    #define IPropertyDescriptionAliasInfo_GetConditionType( x, p1, p2 ) \
        (x)->lpVtbl->GetConditionType( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_GetEnumTypeList( x, p1, p2 ) \
        (x)->lpVtbl->GetEnumTypeList( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_CoerceToCanonicalValue( x, p ) \
        (x)->lpVtbl->CoerceToCanonicalValue( x, p )
    #define IPropertyDescriptionAliasInfo_FormatForDisplay( x, p1, p2, p3 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3 )
    #define IPropertyDescriptionAliasInfo_IsValueCanonical( x, p ) \
        (x)->lpVtbl->IsValueCanonical( x, p )
    #define IPropertyDescriptionAliasInfo_GetSortByAlias( x, p1, p2 ) \
        (x)->lpVtbl->GetSortByAlias( x, p1, p2 )
    #define IPropertyDescriptionAliasInfo_GetAdditionalSortByAliases( x, p1, p2 ) \
        (x)->lpVtbl->GetAdditionalSortByAliases( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescriptionSearchInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescriptionSearchInfo_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyDescriptionSearchInfo_GetCanonicalName( x, p ) \
        (x)->lpVtbl->GetCanonicalName( x, p )
    #define IPropertyDescriptionSearchInfo_GetPropertyType( x, p ) \
        (x)->lpVtbl->GetPropertyType( x, p )
    #define IPropertyDescriptionSearchInfo_GetDisplayName( x, p ) \
        (x)->lpVtbl->GetDisplayName( x, p )
    #define IPropertyDescriptionSearchInfo_GetEditInvitation( x, p ) \
        (x)->lpVtbl->GetEditInvitation( x, p )
    #define IPropertyDescriptionSearchInfo_GetTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeFlags( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_GetViewFlags( x, p ) \
        (x)->lpVtbl->GetViewFlags( x, p )
    #define IPropertyDescriptionSearchInfo_GetDefaultColumnWidth( x, p ) \
        (x)->lpVtbl->GetDefaultColumnWidth( x, p )
    #define IPropertyDescriptionSearchInfo_GetDisplayType( x, p ) \
        (x)->lpVtbl->GetDisplayType( x, p )
    #define IPropertyDescriptionSearchInfo_GetColumnState( x, p ) \
        (x)->lpVtbl->GetColumnState( x, p )
    #define IPropertyDescriptionSearchInfo_GetGroupingRange( x, p ) \
        (x)->lpVtbl->GetGroupingRange( x, p )
    #define IPropertyDescriptionSearchInfo_GetRelativeDescriptionType( x, p ) \
        (x)->lpVtbl->GetRelativeDescriptionType( x, p )
    #define IPropertyDescriptionSearchInfo_GetRelativeDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRelativeDescription( x, p1, p2, p3, p4 )
    #define IPropertyDescriptionSearchInfo_GetSortDescription( x, p ) \
        (x)->lpVtbl->GetSortDescription( x, p )
    #define IPropertyDescriptionSearchInfo_GetSortDescriptionLabel( x, p1, p2 ) \
        (x)->lpVtbl->GetSortDescriptionLabel( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_GetAggregationType( x, p ) \
        (x)->lpVtbl->GetAggregationType( x, p )
    #define IPropertyDescriptionSearchInfo_GetConditionType( x, p1, p2 ) \
        (x)->lpVtbl->GetConditionType( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_GetEnumTypeList( x, p1, p2 ) \
        (x)->lpVtbl->GetEnumTypeList( x, p1, p2 )
    #define IPropertyDescriptionSearchInfo_CoerceToCanonicalValue( x, p ) \
        (x)->lpVtbl->CoerceToCanonicalValue( x, p )
    #define IPropertyDescriptionSearchInfo_FormatForDisplay( x, p1, p2, p3 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3 )
    #define IPropertyDescriptionSearchInfo_IsValueCanonical( x, p ) \
        (x)->lpVtbl->IsValueCanonical( x, p )
    #define IPropertyDescriptionSearchInfo_GetSearchInfoFlags( x, p ) \
        (x)->lpVtbl->GetSearchInfoFlags( x, p )
    #define IPropertyDescriptionSearchInfo_GetColumnIndexType( x, p ) \
        (x)->lpVtbl->GetColumnIndexType( x, p )
    #define IPropertyDescriptionSearchInfo_GetProjectionString( x, p ) \
        (x)->lpVtbl->GetProjectionString( x, p )
    #define IPropertyDescriptionSearchInfo_GetMaxSize( x, p ) \
        (x)->lpVtbl->GetMaxSize( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescriptionRelatedPropertyInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescriptionRelatedPropertyInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescriptionRelatedPropertyInfo_GetPropertyKey( x, p ) \
        (x)->lpVtbl->GetPropertyKey( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetCanonicalName( x, p ) \
        (x)->lpVtbl->GetCanonicalName( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetPropertyType( x, p ) \
        (x)->lpVtbl->GetPropertyType( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetDisplayName( x, p ) \
        (x)->lpVtbl->GetDisplayName( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetEditInvitation( x, p ) \
        (x)->lpVtbl->GetEditInvitation( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetTypeFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetTypeFlags( x, p1, p2 )
    #define IPropertyDescriptionRelatedPropertyInfo_GetViewFlags( x, p ) \
        (x)->lpVtbl->GetViewFlags( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetDefaultColumnWidth( x, p ) \
        (x)->lpVtbl->GetDefaultColumnWidth( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetDisplayType( x, p ) \
        (x)->lpVtbl->GetDisplayType( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetColumnState( x, p ) \
        (x)->lpVtbl->GetColumnState( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetGroupingRange( x, p ) \
        (x)->lpVtbl->GetGroupingRange( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetRelativeDescriptionType( x, p ) \
        (x)->lpVtbl->GetRelativeDescriptionType( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetRelativeDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetRelativeDescription( x, p1, p2, p3, p4 )
    #define IPropertyDescriptionRelatedPropertyInfo_GetSortDescription( x, p ) \
        (x)->lpVtbl->GetSortDescription( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetSortDescriptionLabel( x, p1, p2 ) \
        (x)->lpVtbl->GetSortDescriptionLabel( x, p1, p2 )
    #define IPropertyDescriptionRelatedPropertyInfo_GetAggregationType( x, p ) \
        (x)->lpVtbl->GetAggregationType( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetConditionType( x, p1, p2 ) \
        (x)->lpVtbl->GetConditionType( x, p1, p2 )
    #define IPropertyDescriptionRelatedPropertyInfo_GetEnumTypeList( x, p1, p2 ) \
        (x)->lpVtbl->GetEnumTypeList( x, p1, p2 )
    #define IPropertyDescriptionRelatedPropertyInfo_CoerceToCanonicalValue( x, p ) \
        (x)->lpVtbl->CoerceToCanonicalValue( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_FormatForDisplay( x, p1, p2, p3 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3 )
    #define IPropertyDescriptionRelatedPropertyInfo_IsValueCanonical( x, p ) \
        (x)->lpVtbl->IsValueCanonical( x, p )
    #define IPropertyDescriptionRelatedPropertyInfo_GetRelatedProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRelatedProperty( x, p1, p2, p3 )
    #define IPropertySystem_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertySystem_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertySystem_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertySystem_GetPropertyDescription( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPropertyDescription( x, p1, p2, p3 )
    #define IPropertySystem_GetPropertyDescriptionByName( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPropertyDescriptionByName( x, p1, p2, p3 )
    #define IPropertySystem_GetPropertyDescriptionListFromString( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPropertyDescriptionListFromString( x, p1, p2, p3 )
    #define IPropertySystem_EnumeratePropertyDescriptions( x, p1, p2, p3 ) \
        (x)->lpVtbl->EnumeratePropertyDescriptions( x, p1, p2, p3 )
    #define IPropertySystem_FormatForDisplay( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->FormatForDisplay( x, p1, p2, p3, p4, p5 )
    #define IPropertySystem_FormatForDisplayAlloc( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FormatForDisplayAlloc( x, p1, p2, p3, p4 )
    #define IPropertySystem_RegisterPropertySchema( x, p ) \
        (x)->lpVtbl->RegisterPropertySchema( x, p )
    #define IPropertySystem_UnregisterPropertySchema( x, p ) \
        (x)->lpVtbl->UnregisterPropertySchema( x, p )
    #define IPropertySystem_RefreshPropertySchema( x ) \
        (x)->lpVtbl->RefreshPropertySchema( x )
    #define IPropertyDescriptionList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyDescriptionList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyDescriptionList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyDescriptionList_GetCount( x, p ) \
        (x)->lpVtbl->GetCount( x, p )
    #define IPropertyDescriptionList_GetAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAt( x, p1, p2, p3 )
    #define IPropertyStoreFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertyStoreFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertyStoreFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertyStoreFactory_GetPropertyStore( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetPropertyStore( x, p1, p2, p3, p4 )
    #define IPropertyStoreFactory_GetPropertyStoreForKeys( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetPropertyStoreForKeys( x, p1, p2, p3, p4, p5 )
    #define IDelayedPropertyStoreFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDelayedPropertyStoreFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDelayedPropertyStoreFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDelayedPropertyStoreFactory_GetPropertyStore( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetPropertyStore( x, p1, p2, p3, p4 )
    #define IDelayedPropertyStoreFactory_GetPropertyStoreForKeys( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetPropertyStoreForKeys( x, p1, p2, p3, p4, p5 )
    #define IDelayedPropertyStoreFactory_GetDelayedPropertyStoreFactory( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDelayedPropertyStoreFactory( x, p1, p2, p3, p4 )
    #define IPersistSerializedPropStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistSerializedPropStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistSerializedPropStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistSerializedPropStorage_SetFlags( x, p ) \
        (x)->lpVtbl->SetFlags( x, p )
    #define IPersistSerializedPropStorage_SetPropertyStorage( x, p1, p2 ) \
        (x)->lpVtbl->SetPropertyStorage( x, p1, p2 )
    #define IPersistSerializedPropStorage_GetPropertyStorage( x, p1, p2 ) \
        (x)->lpVtbl->GetPropertyStorage( x, p1, p2 )
    #define IPersistSerializedPropStorage2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistSerializedPropStorage2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistSerializedPropStorage2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistSerializedPropStorage2_SetFlags( x, p ) \
        (x)->lpVtbl->SetFlags( x, p )
    #define IPersistSerializedPropStorage2_SetPropertyStorage( x, p1, p2 ) \
        (x)->lpVtbl->SetPropertyStorage( x, p1, p2 )
    #define IPersistSerializedPropStorage2_GetPropertyStorage( x, p1, p2 ) \
        (x)->lpVtbl->GetPropertyStorage( x, p1, p2 )
    #define IPersistSerializedPropStorage2_GetPropertyStorageSize( x, p ) \
        (x)->lpVtbl->GetPropertyStorageSize( x, p )
    #define IPersistSerializedPropStorage2_GetPropertyStorageBuffer( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPropertyStorageBuffer( x, p1, p2, p3 )
    #define IPropertySystemChangeNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertySystemChangeNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertySystemChangeNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertySystemChangeNotify_SchemaRefreshed( x ) \
        (x)->lpVtbl->SchemaRefreshed( x )
    #define ICreateObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateObject_CreateObject( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateObject( x, p1, p2, p3, p4 )
#endif

/* Functions in PROPSYS.DLL */
PSSTDAPI    PSCoerceToCanonicalValue( REFPROPERTYKEY, PROPVARIANT * );
PSSTDAPI    PSCreateAdapterFromPropertyStore( IPropertyStore *, REFIID, void ** );
PSSTDAPI    PSCreateDelayedMultiplexPropertyStore( GETPROPERTYSTOREFLAGS, IDelayedPropertyStoreFactory *, const DWORD *, DWORD, REFIID, void ** );
PSSTDAPI    PSCreateMemoryPropertyStore( REFIID, void ** );
PSSTDAPI    PSCreateMultiplexPropertyStore( IUnknown **, DWORD, REFIID, void ** );
PSSTDAPI    PSCreatePropertyChangeArray( const PROPERTYKEY *, const PKA_FLAGS *, const PROPVARIANT *, UINT, REFIID, void ** );
PSSTDAPI    PSCreatePropertyStoreFromObject( IUnknown *, DWORD, REFIID, void ** );
PSSTDAPI    PSCreatePropertyStoreFromPropertySetStorage( IPropertySetStorage *, DWORD, REFIID, void ** );
PSSTDAPI    PSCreateSimplePropertyChange( PKA_FLAGS, REFPROPERTYKEY, REFPROPVARIANT, REFIID, void ** );
PSSTDAPI    PSEnumeratePropertyDescriptions( PROPDESC_ENUMFILTER, REFIID, void ** );
PSSTDAPI    PSFormatForDisplay( REFPROPERTYKEY, REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, LPWSTR, DWORD );
PSSTDAPI    PSFormatForDisplayAlloc( REFPROPERTYKEY, REFPROPVARIANT, PROPDESC_FORMAT_FLAGS, PWSTR * );
PSSTDAPI    PSFormatPropertyValue( IPropertyStore *, IPropertyDescription *, PROPDESC_FORMAT_FLAGS, LPWSTR * );
PSSTDAPI    PSGetImageReferenceForValue( REFPROPERTYKEY, REFPROPVARIANT, PWSTR * );
PSSTDAPI    PSGetItemPropertyHandler( IUnknown *, BOOL, REFIID, void ** );
PSSTDAPI    PSGetItemPropertyHandlerWithCreateObject( IUnknown *, BOOL, IUnknown *, REFIID, void ** );
PSSTDAPI    PSGetNameFromPropertyKey( REFPROPERTYKEY, PWSTR * );
PSSTDAPI    PSGetNamedPropertyFromPropertyStorage( PCUSERIALIZEDPROPSTORAGE, DWORD, LPCWSTR, PROPVARIANT * );
PSSTDAPI    PSGetPropertyDescription( REFPROPERTYKEY, REFIID, void ** );
PSSTDAPI    PSGetPropertyDescriptionByName( LPCWSTR, REFIID, void ** );
PSSTDAPI    PSGetPropertyDescriptionListFromString( LPCWSTR, REFIID, void ** );
PSSTDAPI    PSGetPropertyFromPropertyStorage( PCUSERIALIZEDPROPSTORAGE, DWORD, REFPROPERTYKEY, PROPVARIANT * );
PSSTDAPI    PSGetPropertyKeyFromName( PCWSTR, PROPERTYKEY * );
PSSTDAPI    PSGetPropertySystem( REFIID, void ** );
PSSTDAPI    PSGetPropertyValue( IPropertyStore *, IPropertyDescription *, PROPVARIANT * );
PSSTDAPI    PSLookupPropertyHandlerCLSID( PCWSTR, CLSID * );
PSSTDAPI    PSPropertyBag_Delete( IPropertyBag *, LPCWSTR );
PSSTDAPI    PSPropertyBag_ReadBOOL( IPropertyBag *, LPCWSTR, BOOL * );
PSSTDAPI    PSPropertyBag_ReadBSTR( IPropertyBag *, LPCWSTR, BSTR * );
PSSTDAPI    PSPropertyBag_ReadDWORD( IPropertyBag *, LPCWSTR, DWORD * );
PSSTDAPI    PSPropertyBag_ReadGUID( IPropertyBag *, LPCWSTR, GUID * );
PSSTDAPI    PSPropertyBag_ReadInt( IPropertyBag *, LPCWSTR, INT * );
PSSTDAPI    PSPropertyBag_ReadLONG( IPropertyBag *, LPCWSTR, LONG * );
PSSTDAPI    PSPropertyBag_ReadPOINTL( IPropertyBag *, LPCWSTR, POINTL * );
PSSTDAPI    PSPropertyBag_ReadPOINTS( IPropertyBag *, LPCWSTR, POINTS * );
PSSTDAPI    PSPropertyBag_ReadPropertyKey( IPropertyBag *, LPCWSTR, PROPERTYKEY * );
PSSTDAPI    PSPropertyBag_ReadRECTL( IPropertyBag *, LPCWSTR, RECTL * );
PSSTDAPI    PSPropertyBag_ReadSHORT( IPropertyBag *, LPCWSTR, SHORT * );
PSSTDAPI    PSPropertyBag_ReadStr( IPropertyBag *, LPCWSTR, LPWSTR, int );
PSSTDAPI    PSPropertyBag_ReadStrAlloc( IPropertyBag *, LPCWSTR, PWSTR * );
PSSTDAPI    PSPropertyBag_ReadStream( IPropertyBag *, LPCWSTR, IStream ** );
PSSTDAPI    PSPropertyBag_ReadType( IPropertyBag *, LPCWSTR, VARIANT *, VARTYPE );
PSSTDAPI    PSPropertyBag_ReadULONGLONG( IPropertyBag *, LPCWSTR, ULONGLONG * );
PSSTDAPI    PSPropertyBag_ReadUnknown( IPropertyBag *, LPCWSTR, REFIID, void ** );
PSSTDAPI    PSPropertyBag_WriteBOOL( IPropertyBag *, LPCWSTR, BOOL );
PSSTDAPI    PSPropertyBag_WriteBSTR( IPropertyBag *, LPCWSTR, BSTR );
PSSTDAPI    PSPropertyBag_WriteDWORD( IPropertyBag *, LPCWSTR, DWORD );
PSSTDAPI    PSPropertyBag_WriteGUID( IPropertyBag *, LPCWSTR, const GUID * );
PSSTDAPI    PSPropertyBag_WriteInt( IPropertyBag *, LPCWSTR, INT );
PSSTDAPI    PSPropertyBag_WriteLONG( IPropertyBag *, LPCWSTR, LONG );
PSSTDAPI    PSPropertyBag_WritePOINTL( IPropertyBag *, LPCWSTR, const POINTL * );
PSSTDAPI    PSPropertyBag_WritePOINTS( IPropertyBag *, LPCWSTR, const POINTS * );
PSSTDAPI    PSPropertyBag_WritePropertyKey( IPropertyBag *, LPCWSTR, REFPROPERTYKEY );
PSSTDAPI    PSPropertyBag_WriteRECTL( IPropertyBag *, LPCWSTR, const RECTL * );
PSSTDAPI    PSPropertyBag_WriteSHORT( IPropertyBag *, LPCWSTR, SHORT );
PSSTDAPI    PSPropertyBag_WriteStr( IPropertyBag *, LPCWSTR, LPCWSTR );
PSSTDAPI    PSPropertyBag_WriteStream( IPropertyBag *, LPCWSTR, IStream * );
PSSTDAPI    PSPropertyBag_WriteULONGLONG( IPropertyBag *, LPCWSTR, ULONGLONG );
PSSTDAPI    PSPropertyBag_WriteUnknown( IPropertyBag *, LPCWSTR, IUnknown * );
PSSTDAPI    PSPropertyKeyFromString( LPCWSTR, PROPERTYKEY * );
PSSTDAPI    PSRefreshPropertySchema( void );
PSSTDAPI    PSRegisterPropertySchema( PCWSTR );
PSSTDAPI    PSSetPropertyValue( IPropertyStore *, IPropertyDescription *, REFPROPVARIANT );
PSSTDAPI    PSStringFromPropertyKey( REFPROPERTYKEY, LPWSTR, UINT );
PSSTDAPI    PSUnregisterPropertySchema( PCWSTR );

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID      __cdecl IID_IInitializeWithFile;
EXTERN_C const IID      __cdecl IID_IInitializeWithStream;
EXTERN_C const IID      __cdecl IID_IPropertyStore;
EXTERN_C const IID      __cdecl IID_INamedPropertyStore;
EXTERN_C const IID      __cdecl IID_IObjectWithPropertyKey;
EXTERN_C const IID      __cdecl IID_IPropertyChange;
EXTERN_C const IID      __cdecl IID_IPropertyChangeArray;
EXTERN_C const IID      __cdecl IID_IPropertyStoreCapabilities;
EXTERN_C const IID      __cdecl IID_IPropertyStoreCache;
EXTERN_C const IID      __cdecl IID_IPropertyEnumType;
EXTERN_C const IID      __cdecl IID_IPropertyEnumType2;
EXTERN_C const IID      __cdecl IID_IPropertyEnumTypeList;
EXTERN_C const IID      __cdecl IID_IPropertyDescription;
EXTERN_C const IID      __cdecl IID_IPropertyDescription2;
EXTERN_C const IID      __cdecl IID_IPropertyDescriptionAliasInfo;
EXTERN_C const IID      __cdecl IID_IPropertyDescriptionSearchInfo;
EXTERN_C const IID      __cdecl IID_IPropertyDescriptionRelatedPropertyInfo;
EXTERN_C const IID      __cdecl IID_IPropertySystem;
EXTERN_C const IID      __cdecl IID_IPropertyDescriptionList;
EXTERN_C const IID      __cdecl IID_IPropertyStoreFactory;
EXTERN_C const IID      __cdecl IID_IDelayedPropertyStoreFactory;
EXTERN_C const IID      __cdecl IID_IPersistSerializedPropStorage;
EXTERN_C const IID      __cdecl IID_IPersistSerializedPropStorage2;
EXTERN_C const IID      __cdecl IID_IPropertySystemChangeNotify;
EXTERN_C const IID      __cdecl IID_ICreateObject;
EXTERN_C const IID      __cdecl LIBID_PropSysObjects;
EXTERN_C const CLSID    __cdecl CLSID_InMemoryPropertyStore;
EXTERN_C const CLSID    __cdecl CLSID_PropertySystem;

#endif /* __propsys_h__ */
