/*
 *  qedit.h     DirectShow editing interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __qedit_h__
#define __qedit_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <oaidl.h>
#include <ocidl.h>
#include <dxtrans.h>
#include <amstream.h>
#include <msxml.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IAMTimeline       IAMTimeline;
typedef interface IAMTimelineGroup  IAMTimelineGroup;
typedef interface ISampleGrabber    ISampleGrabber;

/* Dexter error codes */
#define DEX_IDS_BAD_SOURCE_NAME         1400
#define DEX_IDS_BAD_SOURCE_NAME2        1401
#define DEX_IDS_MISSING_SOURCE_NAME     1402
#define DEX_IDS_UNKNOWN_SOURCE          1403
#define DEX_IDS_INSTALL_PROBLEM         1404
#define DEX_IDS_NO_SOURCE_NAMES         1405
#define DEX_IDS_BAD_MEDIATYPE           1406
#define DEX_IDS_STREAM_NUMBER           1407
#define DEX_IDS_OUTOFMEMORY             1408
#define DEX_IDS_DIBSEQ_NOTALLSAME       1409
#define DEX_IDS_CLIPTOOSHORT            1410
#define DEX_IDS_INVALID_DXT             1411
#define DEX_IDS_INVALID_DEFAULT_DXT     1412
#define DEX_IDS_NO_3D                   1413
#define DEX_IDS_BROKEN_DXT              1414
#define DEX_IDS_NO_SUCH_PROPERTY        1415
#define DEX_IDS_ILLEGAL_PROPERTY_VAL    1416
#define DEX_IDS_INVALID_XML             1417
#define DEX_IDS_CANT_FIND_FILTER        1418
#define DEX_IDS_DISK_WRITE_ERROR        1419
#define DEX_IDS_INVALID_AUDIO_FX        1420
#define DEX_IDS_CANT_FIND_COMPRESSOR    1421
#define DEX_IDS_TIMELINE_PARSE          1426
#define DEX_IDS_GRAPH_ERROR             1427
#define DEX_IDS_GRID_ERROR              1428
#define DEX_IDS_INTERFACE_ERROR         1429

/* Dexter flags */
typedef enum {
    DEXTERF_JUMP        = 0,
    DEXTERF_INTERPOLATE = 1
} DEXTERF;

/* Dexter parameter */
typedef struct {
    BSTR    Name;
    DISPID  dispID;
    LONG    nValues;
} DEXTER_PARAM;

/* Dexter value */
typedef struct {
    VARIANT         v;
    REFERENCE_TIME  rt;
    DWORD           dwInterp;
} DEXTER_VALUE;

/* Dexter audio methods */
enum {
    DEXTER_AUDIO_JUMP           = 0,
    DEXTER_AUDIO_INTERPOLATE    = 1
};

/* Dexter audio volume envelope */
typedef struct {
    REFERENCE_TIME  rtEnd;
    double          dLevel;
    BOOL            bMethod;
} DEXTER_AUDIO_VOLUMEENVELOPE;

/* Timeline insert modes */
enum {
    TIMELINE_INSERT_MODE_INSERT     = 1,
    TIMELINE_INSERT_MODE_OVERLAY    = 2
};

/* Timeline major types */
typedef enum {
    TIMELINE_MAJOR_TYPE_COMPOSITE   = 1,
    TIMELINE_MAJOR_TYPE_TRACK       = 2,
    TIMELINE_MAJOR_TYPE_SOURCE      = 4,
    TIMELINE_MAJOR_TYPE_TRANSITION  = 8,
    TIMELINE_MAJOR_TYPE_EFFECT      = 16,
    TIMELINE_MAJOR_TYPE_GROUP       = 128
} TIMELINE_MAJOR_TYPE;

/* Dexter track search flags */
typedef enum {
    DEXTERF_BOUNDING    = -1,
    DEXTERF_EXACTLY_AT  = 0,
    DEXTERF_FORWARDS    = 1
} DEXTERF_TRACK_SEARCH_FLAGS;

/* Smart compression format */
typedef struct _SCompFmt0 {
    long            nFormatId;
    AM_MEDIA_TYPE   MediaType;
} SCompFmt0;

/* Resize flags */
enum {
    RESIZEF_STRETCH                         = 0,
    RESIZEF_CROP                            = 1,
    RESIZEF_PRESERVEASPECTRATIO             = 2,
    RESIZEF_PRESERVEASPECTRATIO_NOLETTERBOX = 3
};

/* Connect flags */
enum {
    CONNECTF_DYNAMIC_NONE       = 0x00000000,
    CONNECTF_DYNAMIC_SOURCES    = 0x00000001,
    CONNECTF_DYNAMIC_EFFECTS    = 0x00000002
};

/* Validate flags */
enum {
    SFN_VALIDATEF_CHECK         = 0x00000001,
    SFN_VALIDATEF_POPUP         = 0x00000002,
    SFN_VALIDATEF_TELLME        = 0x00000004,
    SFN_VALIDATEF_REPLACE       = 0x00000008,
    SFN_VALIDATEF_USELOCAL      = 0x00000010,
    SFN_VALIDATEF_NOFIND        = 0x00000020,
    SFN_VALIDATEF_IGNOREMUTED   = 0x00000040,
    SFN_VALIDATEF_END
};

/* DirectX transformation keys */
enum {
    DXTKEY_RGB          = 0,
    DXTKEY_NONRED       = 1,
    DXTKEY_LUMINANCE    = 2,
    DXTKEY_ALPHA        = 3,
    DXTKEY_HUE          = 4
};

/* Editing return codes */
enum {
    E_NOTINTREE                 = 0x80040400,
    E_RENDER_ENGINE_IS_BROKEN   = 0x80040401,
    E_MUST_INIT_RENDERER        = 0x80040402,
    E_NOTDETERMINED             = 0x80040403,
    E_NO_TIMELINE               = 0x80040404,
    S_WARN_OUTPUTRESET          = 40404
};

/* IPropertySetter interface */
#undef INTERFACE
#define INTERFACE   IPropertySetter
DECLARE_INTERFACE_( IPropertySetter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPropertySetter methods */
    STDMETHOD( LoadXML )( THIS_ IUnknown * ) PURE;
    STDMETHOD( PrintXML )( THIS_ char *, int, int *, int ) PURE;
    STDMETHOD( CloneProps )( THIS_ IPropertySetter **, REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( AddProp )( THIS_ DEXTER_PARAM, DEXTER_VALUE * ) PURE;
    STDMETHOD( GetProps )( THIS_ LONG *, DEXTER_PARAM **, DEXTER_VALUE ** ) PURE;
    STDMETHOD( FreeProps )( THIS_ LONG, DEXTER_PARAM *, DEXTER_VALUE * ) PURE;
    STDMETHOD( ClearProps )( THIS ) PURE;
    STDMETHOD( SaveToBlob )( THIS_ LONG *, BYTE ** ) PURE;
    STDMETHOD( LoadFromBlob )( THIS_ LONG, BYTE * ) PURE;
    STDMETHOD( SetProps )( THIS_ IUnknown *, REFERENCE_TIME ) PURE;
    STDMETHOD( PrintXMLW )( THIS_ WCHAR *, int, int *, int ) PURE;
};

/* IDxtCompositor interface */
#undef INTERFACE
#define INTERFACE   IDxtCompositor
DECLARE_INTERFACE_( IDxtCompositor, IDXEffect ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDXEffect methods */
    STDMETHOD( get_Capabilities )( THIS_ long * ) PURE;
    STDMETHOD( get_Progress )( THIS_ float * ) PURE;
    STDMETHOD( put_Progress )( THIS_ float ) PURE;
    STDMETHOD( get_StepResolution )( THIS_ float * ) PURE;
    STDMETHOD( get_Duration )( THIS_ float * ) PURE;
    STDMETHOD( put_Duration )( THIS_ float ) PURE;
    
    /* IDxtCompositor methods */
    STDMETHOD( get_OffsetX )( THIS_ long * ) PURE;
    STDMETHOD( put_OffsetX )( THIS_ long ) PURE;
    STDMETHOD( get_OffsetY )( THIS_ long * ) PURE;
    STDMETHOD( put_OffsetY )( THIS_ long ) PURE;
    STDMETHOD( get_Width )( THIS_ long * ) PURE;
    STDMETHOD( put_Width )( THIS_ long ) PURE;
    STDMETHOD( get_Height )( THIS_ long * ) PURE;
    STDMETHOD( put_Height )( THIS_ long ) PURE;
    STDMETHOD( get_SrcOffsetX )( THIS_ long * ) PURE;
    STDMETHOD( put_SrcOffsetX )( THIS_ long ) PURE;
    STDMETHOD( get_SrcOffsetY )( THIS_ long * ) PURE;
    STDMETHOD( put_SrcOffsetY )( THIS_ long ) PURE;
    STDMETHOD( get_SrcWidth )( THIS_ long * ) PURE;
    STDMETHOD( put_SrcWidth )( THIS_ long ) PURE;
    STDMETHOD( get_SrcHeight )( THIS_ long * ) PURE;
    STDMETHOD( put_SrcHeight )( THIS_ long ) PURE;
};

/* IDxtAlphaSetter interface */
#undef INTERFACE
#define INTERFACE   IDxtAlphaSetter
DECLARE_INTERFACE_( IDxtAlphaSetter, IDXEffect ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDXEffect methods */
    STDMETHOD( get_Capabilities )( THIS_ long * ) PURE;
    STDMETHOD( get_Progress )( THIS_ float * ) PURE;
    STDMETHOD( put_Progress )( THIS_ float ) PURE;
    STDMETHOD( get_StepResolution )( THIS_ float * ) PURE;
    STDMETHOD( get_Duration )( THIS_ float * ) PURE;
    STDMETHOD( put_Duration )( THIS_ float ) PURE;

    /* IDxtAlphaSetter methods */
    STDMETHOD( get_Alpha )( THIS_ long * ) PURE;
    STDMETHOD( put_Alpha )( THIS_ long ) PURE;
    STDMETHOD( get_AlphaRamp )( THIS_ double * ) PURE;
    STDMETHOD( put_AlphaRamp )( THIS_ double ) PURE;
};

/* IDxtJpeg interface */
#undef INTERFACE
#define INTERFACE   IDxtJpeg
DECLARE_INTERFACE_( IDxtJpeg, IDXEffect ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDXEffect methods */
    STDMETHOD( get_Capabilities )( THIS_ long * ) PURE;
    STDMETHOD( get_Progress )( THIS_ float * ) PURE;
    STDMETHOD( put_Progress )( THIS_ float ) PURE;
    STDMETHOD( get_StepResolution )( THIS_ float * ) PURE;
    STDMETHOD( get_Duration )( THIS_ float * ) PURE;
    STDMETHOD( put_Duration )( THIS_ float ) PURE;

    /* IDxtJpeg methods */
    STDMETHOD( get_MaskNum )( THIS_ long * ) PURE;
    STDMETHOD( put_MaskNum )( THIS_ long ) PURE;
    STDMETHOD( get_MaskName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_MaskName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ScaleX )( THIS_ double * ) PURE;
    STDMETHOD( put_ScaleX )( THIS_ double ) PURE;
    STDMETHOD( get_ScaleY )( THIS_ double * ) PURE;
    STDMETHOD( put_ScaleY )( THIS_ double ) PURE;
    STDMETHOD( get_OffsetX )( THIS_ long * ) PURE;
    STDMETHOD( put_OffsetX )( THIS_ long ) PURE;
    STDMETHOD( get_OffsetY )( THIS_ long * ) PURE;
    STDMETHOD( put_OffsetY )( THIS_ long ) PURE;
    STDMETHOD( get_ReplicateX )( THIS_ long * ) PURE;
    STDMETHOD( put_ReplicateX )( THIS_ long ) PURE;
    STDMETHOD( get_ReplicateY )( THIS_ long * ) PURE;
    STDMETHOD( put_ReplicateY )( THIS_ long ) PURE;
    STDMETHOD( get_BorderColor )( THIS_ long * ) PURE;
    STDMETHOD( put_BorderColor )( THIS_ long ) PURE;
    STDMETHOD( get_BorderWidth )( THIS_ long * ) PURE;
    STDMETHOD( put_BorderWidth )( THIS_ long ) PURE;
    STDMETHOD( get_BorderSoftness )( THIS_ long * ) PURE;
    STDMETHOD( put_BorderSoftness )( THIS_ long ) PURE;
    STDMETHOD( ApplyChanges )( THIS ) PURE;
    STDMETHOD( LoadDefSettings )( THIS ) PURE;
};

/* IDxtKey interface */
#undef INTERFACE
#define INTERFACE   IDxtKey
DECLARE_INTERFACE_( IDxtKey, IDXEffect ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDXEffect methods */
    STDMETHOD( get_Capabilities )( THIS_ long * ) PURE;
    STDMETHOD( get_Progress )( THIS_ float * ) PURE;
    STDMETHOD( put_Progress )( THIS_ float ) PURE;
    STDMETHOD( get_StepResolution )( THIS_ float * ) PURE;
    STDMETHOD( get_Duration )( THIS_ float * ) PURE;
    STDMETHOD( put_Duration )( THIS_ float ) PURE;

    /* IDxtKey methods */
    STDMETHOD( get_KeyType )( THIS_ int * ) PURE;
    STDMETHOD( put_KeyType )( THIS_ int ) PURE;
    STDMETHOD( get_Hue )( THIS_ int * ) PURE;
    STDMETHOD( put_Hue )( THIS_ int ) PURE;
    STDMETHOD( get_Luminance )( THIS_ int * ) PURE;
    STDMETHOD( put_Luminance )( THIS_ int ) PURE;
    STDMETHOD( get_RGB )( THIS_ DWORD * ) PURE;
    STDMETHOD( put_RGB )( THIS_ DWORD ) PURE;
    STDMETHOD( get_Similarity )( THIS_ int * ) PURE;
    STDMETHOD( put_Similarity )( THIS_ int ) PURE;
    STDMETHOD( get_Invert )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Invert )( THIS_ BOOL ) PURE;
};

/* IMediaLocator interface */
#undef INTERFACE
#define INTERFACE   IMediaLocator
DECLARE_INTERFACE_( IMediaLocator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaLocator methods */
    STDMETHOD( FindMediaFile )( THIS_ BSTR, BSTR, BSTR *, long ) PURE;
    STDMETHOD( AddFoundLocation )( THIS_ BSTR ) PURE;
};

/* IMediaDet interface */
#undef INTERFACE
#define INTERFACE   IMediaDet
DECLARE_INTERFACE_( IMediaDet, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaDet methods */
    STDMETHOD( get_Filter )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( put_Filter )( THIS_ IUnknown * ) PURE;
    STDMETHOD( get_OutputStreams )( THIS_ long * ) PURE;
    STDMETHOD( get_CurrentStream )( THIS_ long * ) PURE;
    STDMETHOD( put_CurrentStream )( THIS_ long ) PURE;
    STDMETHOD( get_StreamType )( THIS_ GUID * ) PURE;
    STDMETHOD( get_StreamTypeB )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_StreamLength )( THIS_ double * ) PURE;
    STDMETHOD( get_Filename )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Filename )( THIS_ BSTR ) PURE;
    STDMETHOD( GetBitmapBits )( THIS_ double, long *, char *, long, long ) PURE;
    STDMETHOD( WriteBitmapBits )( THIS_ double, long, long, BSTR ) PURE;
    STDMETHOD( get_StreamMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetSampleGrabber )( THIS_ ISampleGrabber ** ) PURE;
    STDMETHOD( get_FrameRate )( THIS_ double * ) PURE;
    STDMETHOD( EnterBitmapGrabMode )( THIS_ double ) PURE;
};

/* IGrfCache interface */
#undef INTERFACE
#define INTERFACE   IGrfCache
DECLARE_INTERFACE_( IGrfCache, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IGrfCache methods */
    STDMETHOD( AddFilter )( THIS_ IGrfCache *, LONGLONG, const IBaseFilter *, LPCWSTR ) PURE;
    STDMETHOD( ConnectPins )( THIS_ IGrfCache *, LONGLONG, const IPin *, LONGLONG, const IPin * ) PURE;
    STDMETHOD( SetGraph )( THIS_ const IGraphBuilder * ) PURE;
    STDMETHOD( DoConnectionsNow )( THIS ) PURE;
};

/* IRenderEngine interface */
#undef INTERFACE
#define INTERFACE   IRenderEngine
DECLARE_INTERFACE_( IRenderEngine, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IRenderEngine methods */
    STDMETHOD( SetTimelineObject )( THIS_ IAMTimeline * ) PURE;
    STDMETHOD( GetTimelineObject )( THIS_ IAMTimeline ** ) PURE;
    STDMETHOD( GetFilterGraph )( THIS_ IGraphBuilder ** ) PURE;
    STDMETHOD( SetFilterGraph )( THIS_ IGraphBuilder * ) PURE;
    STDMETHOD( SetInterestRange )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( SetInterestRange2 )( THIS_ double, double ) PURE;
    STDMETHOD( SetRenderRange )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( SetRenderRange2 )( THIS_ double, double ) PURE;
    STDMETHOD( GetGroupOutputPin )( THIS_ long, IPin ** ) PURE;
    STDMETHOD( ScrapIt )( THIS ) PURE;
    STDMETHOD( RenderOutputPins )( THIS ) PURE;
    STDMETHOD( GetVendorString )( THIS_ BSTR * ) PURE;
    STDMETHOD( ConnectFrontEnd )( THIS ) PURE;
    STDMETHOD( SetSourceConnectCallback )( THIS_ IGrfCache * ) PURE;
    STDMETHOD( SetDynamicReconnectLevel )( THIS_ long ) PURE;
    STDMETHOD( DoSmartRecompression )( THIS ) PURE;
    STDMETHOD( UseInSmartRecompressionGraph )( THIS ) PURE;
    STDMETHOD( SetSourceNameValidation )( THIS_ BSTR, IMediaLocator *, LONG ) PURE;
    STDMETHOD( Commit )( THIS ) PURE;
    STDMETHOD( Decommit )( THIS ) PURE;
    STDMETHOD( GetCaps )( THIS_ long, long * ) PURE;
};

/* IRenderEngine2 interface */
#undef INTERFACE
#define INTERFACE   IRenderEngine2
DECLARE_INTERFACE_( IRenderEngine2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IRenderEngine2 methods */
    STDMETHOD( SetResizerGUID )( THIS_ GUID ) PURE;
};

/* IFindCompressorCB interface */
#undef INTERFACE
#define INTERFACE   IFindCompressorCB
DECLARE_INTERFACE_( IFindCompressorCB, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFindCompressorCB methods */
    STDMETHOD( GetCompressor )( THIS_ AM_MEDIA_TYPE *, AM_MEDIA_TYPE *, IBaseFilter ** ) PURE;
};

/* ISmartRenderEngine interface */
#undef INTERFACE
#define INTERFACE   ISmartRenderEngine
DECLARE_INTERFACE_( ISmartRenderEngine, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISmartRenderEngine methods */
    STDMETHOD( SetGroupCompressor )( THIS_ long, IBaseFilter * ) PURE;
    STDMETHOD( GetGroupCompressor )( THIS_ long, IBaseFilter ** ) PURE;
    STDMETHOD( SetFindCompressorCB )( THIS_ IFindCompressorCB * ) PURE;
};

/* IAMTimelineObj interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineObj
DECLARE_INTERFACE_( IAMTimelineObj, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineObj methods */
    STDMETHOD( GetStartStop )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetStartStop2 )( THIS_ REFTIME *, REFTIME * ) PURE;
    STDMETHOD( FixTimes )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( FixTimes2 )( THIS_ REFTIME *, REFTIME * ) PURE;
    STDMETHOD( SetStartStop )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( SetStartStop2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( GetPropertySetter )( THIS_ IPropertySetter ** ) PURE;
    STDMETHOD( SetPropertySetter )( THIS_ IPropertySetter * ) PURE;
    STDMETHOD( GetSubObject )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( SetSubObject )( THIS_ IUnknown * ) PURE;
    STDMETHOD( SetSubObjectGUID )( THIS_ GUID ) PURE;
    STDMETHOD( SetSubObjectGUIDB )( THIS_ BSTR ) PURE;
    STDMETHOD( GetSubObjectGUID )( THIS_ GUID * ) PURE;
    STDMETHOD( GetSubObjectGUIDB )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetSubObjectLoaded )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetTimelineType )( THIS_ TIMELINE_MAJOR_TYPE * ) PURE;
    STDMETHOD( SetTimelineType )( THIS_ TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( GetUserID )( THIS_ long * ) PURE;
    STDMETHOD( SetUserID )( THIS_ long ) PURE;
    STDMETHOD( GetGenID )( THIS_ long * ) PURE;
    STDMETHOD( GetUserName )( THIS_ BSTR * ) PURE;
    STDMETHOD( SetUserName )( THIS_ BSTR ) PURE;
    STDMETHOD( GetUserData )( THIS_ BYTE *, long * ) PURE;
    STDMETHOD( SetUserData )( THIS_ BYTE *, long ) PURE;
    STDMETHOD( GetMuted )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetMuted )( THIS_ BOOL ) PURE;
    STDMETHOD( GetLocked )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetLocked )( THIS_ BOOL ) PURE;
    STDMETHOD( GetDirtyRange )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetDirtyRange2 )( THIS_ REFTIME *, REFTIME * ) PURE;
    STDMETHOD( SetDirtyRange )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( SetDirtyRange2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( ClearDirty )( THIS ) PURE;
    STDMETHOD( Remove )( THIS ) PURE;
    STDMETHOD( RemoveAll )( THIS ) PURE;
    STDMETHOD( GetTimelineNoRef )( THIS_ IAMTimeline ** ) PURE;
    STDMETHOD( GetGroupIBelongTo )( THIS_ IAMTimelineGroup ** ) PURE;
    STDMETHOD( GetEmbedDepth )( THIS_ long * ) PURE;
};
 
/* IAMTimelineEffectable interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineEffectable
DECLARE_INTERFACE_( IAMTimelineEffectable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineEffectable methods */
    STDMETHOD( EffectInsBefore )( THIS_ IAMTimelineObj *, long ) PURE;
    STDMETHOD( EffectSwapPriorities )( THIS_ long, long ) PURE;
    STDMETHOD( EffectGetCount )( THIS_ long * ) PURE;
    STDMETHOD( GetEffect )( THIS_ IAMTimelineObj **, long ) PURE;
};

/* IAMTimelineEffect interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineEffect
DECLARE_INTERFACE_( IAMTimelineEffect, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineEffect methods */
    STDMETHOD( EffectGetPriority )( THIS_ long * ) PURE;
};

/* IAMTimelineTransable interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineTransable
DECLARE_INTERFACE_( IAMTimelineTransable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineTransable methods */
    STDMETHOD( TransAdd )( THIS_ IAMTimelineObj * ) PURE;
    STDMETHOD( TransGetCount )( THIS_ long * ) PURE;
    STDMETHOD( GetNextTrans )( THIS_ IAMTimelineObj **, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetNextTrans2 )( THIS_ IAMTimelineObj **, REFTIME * ) PURE;
    STDMETHOD( GetTransAtTime )( THIS_ IAMTimelineObj **, REFERENCE_TIME, long ) PURE;
    STDMETHOD( GetTransAtTime2 )( THIS_ IAMTimelineObj **, REFTIME, long ) PURE;
};

/* IAMTimelineSplittable interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineSplittable
DECLARE_INTERFACE_( IAMTimelineSplittable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineSplittable methods */
    STDMETHOD( SplitAt )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( SplitAt2 )( THIS_ REFTIME ) PURE;
};

/* IAMTimelineTrans interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineTrans
DECLARE_INTERFACE_( IAMTimelineTrans, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineTrans methods */
    STDMETHOD( GetCutPoint )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( GetCutPoint2 )( THIS_ REFTIME * ) PURE;
    STDMETHOD( SetCutPoint )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( SetCutPoint2 )( THIS_ REFTIME ) PURE;
    STDMETHOD( GetSwapInputs )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetSwapInputs )( THIS_ BOOL ) PURE;
    STDMETHOD( GetCutsOnly )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetCutsOnly )( THIS_ BOOL ) PURE;
};

/* IAMTimelineSrc interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineSrc
DECLARE_INTERFACE_( IAMTimelineSrc, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineSrc methods */
    STDMETHOD( GetMediaTimes )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetMediaTimes2 )( THIS_ REFTIME *, REFTIME * ) PURE;
    STDMETHOD( ModifyStopTime )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( ModifyStopTime2 )( THIS_ REFTIME ) PURE;
    STDMETHOD( FixMediaTimes )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( FixMediaTimes2 )( THIS_ REFTIME *, REFTIME * ) PURE;
    STDMETHOD( SetMediaTimes )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( SetMediaTimes2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( SetMediaLength )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( SetMediaLength2 )( THIS_ REFTIME ) PURE;
    STDMETHOD( GetMediaLength )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( GetMediaLength2 )( THIS_ REFTIME * ) PURE;
    STDMETHOD( GetMediaName )( THIS_ BSTR * ) PURE;
    STDMETHOD( SetMediaName )( THIS_ BSTR ) PURE;
    STDMETHOD( SpliceWithNext )( THIS_ IAMTimelineObj * ) PURE;
    STDMETHOD( GetStreamNumber )( THIS_ long * ) PURE;
    STDMETHOD( SetStreamNumber )( THIS_ long ) PURE;
    STDMETHOD( IsNormalRate )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetDefaultEPS )( THIS_ double * ) PURE;
    STDMETHOD( SetDefaultEPS )( THIS_ double ) PURE;
    STDMETHOD( GetStretchMode )( THIS_ int * ) PURE;
    STDMETHOD( SetStretchMode )( THIS_ int ) PURE;
};

/* IAMTimelineTrack interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineTrack
DECLARE_INTERFACE_( IAMTimelineTrack, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineTrack methods */
    STDMETHOD( SrcAdd )( THIS_ IAMTimelineObj * ) PURE;
    STDMETHOD( GetNextSrc )( THIS_ IAMTimelineObj **, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetNextSrc2 )( THIS_ IAMTimelineObj **, REFTIME * ) PURE;
    STDMETHOD( MoveEverythingBy )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( MoveEverythingBy2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( GetSourcesCount )( THIS_ long * ) PURE;
    STDMETHOD( AreYouBlank )( THIS_ long * ) PURE;
    STDMETHOD( GetSrcAtTime )( THIS_ IAMTimelineObj **, REFERENCE_TIME, long ) PURE;
    STDMETHOD( GetSrcAtTime2 )( THIS_ IAMTimelineObj **, REFTIME, long ) PURE;
    STDMETHOD( InsertSpace )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( InsertSpace2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( ZeroBetween )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( ZeroBetween2 )( THIS_ REFTIME, REFTIME ) PURE;
    STDMETHOD( GetNextSrcEx )( THIS_ IAMTimelineObj *, IAMTimelineObj ** ) PURE;
};

/* IAMTimelineVirtualTrack interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineVirtualTrack
DECLARE_INTERFACE_( IAMTimelineVirtualTrack, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineVirtualTrack methods */
    STDMETHOD( TrackGetPriority )( THIS_ long * ) PURE;
    STDMETHOD( SetTrackDirty )( THIS ) PURE;
};

/* IAMTimelineComp interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineComp
DECLARE_INTERFACE_( IAMTimelineComp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineComp methods */
    STDMETHOD( VTrackInsBefore )( THIS_ IAMTimelineObj *, long ) PURE;
    STDMETHOD( VTrackSwapPriorities )( THIS_ long, long ) PURE;
    STDMETHOD( VTrackGetCount )( THIS_ long * ) PURE;
    STDMETHOD( GetVTrack )( THIS_ IAMTimelineObj **, long ) PURE;
    STDMETHOD( GetCountOfType )( THIS_ long *, long *, TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( GetRecursiveLayerOfType )( THIS_ IAMTimelineObj **, long, TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( GetRecursiveLayerOfTypeI )( THIS_ IAMTimelineObj **, long *, TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( GetNextVTrack )( THIS_ IAMTimelineObj *, IAMTimelineObj ** ) PURE;
};

/* IAMTimelineGroup interface */
#undef INTERFACE
#define INTERFACE   IAMTimelineGroup
DECLARE_INTERFACE_( IAMTimelineGroup, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimelineGroup methods */
    STDMETHOD( SetTimeline )( THIS_ IAMTimeline * ) PURE;
    STDMETHOD( GetTimeline )( THIS_ IAMTimeline ** ) PURE;
    STDMETHOD( GetPriority )( THIS_ long * ) PURE;
    STDMETHOD( GetMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( SetMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( SetOutputFPS )( THIS_ double ) PURE;
    STDMETHOD( GetOutputFPS )( THIS_ double * ) PURE;
    STDMETHOD( SetGroupName )( THIS_ BSTR ) PURE;
    STDMETHOD( GetGroupName )( THIS_ BSTR * ) PURE;
    STDMETHOD( SetPreviewMode )( THIS_ BOOL ) PURE;
    STDMETHOD( GetPreviewMode )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetMediaTypeForVB )( THIS_ long ) PURE;
    STDMETHOD( GetOutputBuffering )( THIS_ int * ) PURE;
    STDMETHOD( SetOutputBuffering )( THIS_ int ) PURE;
    STDMETHOD( SetSmartRecompressFormat )( THIS_ long * ) PURE;
    STDMETHOD( GetSmartRecompressFormat )( THIS_ long ** ) PURE;
    STDMETHOD( IsSmartRecompressFormatSet )( THIS_ BOOL * ) PURE;
    STDMETHOD( IsRecompressFormatDirty )( THIS_ BOOL * ) PURE;
    STDMETHOD( ClearRecompressFormatDirty )( THIS ) PURE;
    STDMETHOD( SetRecompFormatFromSource )( THIS_ IAMTimelineSrc * ) PURE;
};

/* IAMTimeline interface */
#undef INTERFACE
#define INTERFACE   IAMTimeline
DECLARE_INTERFACE_( IAMTimeline, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimeline methods */
    STDMETHOD( CreateEmptyNode )( THIS_ IAMTimelineObj **, TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( AddGroup )( THIS_ IAMTimelineObj * ) PURE;
    STDMETHOD( RemGroupFromList )( THIS_ IAMTimelineObj * ) PURE;
    STDMETHOD( GetGroup )( THIS_ IAMTimelineObj *, long ) PURE;
    STDMETHOD( GetGroupCount )( THIS_ long * ) PURE;
    STDMETHOD( ClearAllGroups )( THIS ) PURE;
    STDMETHOD( GetInsertMode )( THIS_ long * ) PURE;
    STDMETHOD( SetInsertMode )( THIS_ long ) PURE;
    STDMETHOD( EnableTransitions )( THIS_ BOOL ) PURE;
    STDMETHOD( TransitionsEnabled )( THIS_ BOOL * ) PURE;
    STDMETHOD( EnableEffects )( THIS_ BOOL ) PURE;
    STDMETHOD( EffectsEnabled )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetInterestRange )( THIS_ REFERENCE_TIME, REFERENCE_TIME ) PURE;
    STDMETHOD( GetDuration )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( GetDuration2 )( THIS_ double * ) PURE;
    STDMETHOD( SetDefaultFPS )( THIS_ double ) PURE;
    STDMETHOD( GetDefaultFPS )( THIS_ double * ) PURE;
    STDMETHOD( IsDirty )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetDirtyRange )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( GetCountOfType )( THIS_ long, long *, long *, TIMELINE_MAJOR_TYPE ) PURE;
    STDMETHOD( ValidateSourceNames )( THIS_ long, IMediaLocator *, LONG_PTR ) PURE;
    STDMETHOD( SetDefaultTransition )( THIS_ GUID * ) PURE;
    STDMETHOD( GetDefaultTransition )( THIS_ GUID * ) PURE;
    STDMETHOD( SetDefaultEffect )( THIS_ GUID * ) PURE;
    STDMETHOD( GetDefaultEffect )( THIS_ GUID * ) PURE;
    STDMETHOD( SetDefaultTransitionB )( THIS_ BSTR ) PURE;
    STDMETHOD( GetDefaultTransitionB )( THIS_ BSTR * ) PURE;
    STDMETHOD( SetDefaultEffectB )( THIS_ BSTR ) PURE;
    STDMETHOD( GetDefaultEffectB )( THIS_ BSTR * ) PURE;
};

/* IXml2Dex interface */
#undef INTERFACE
#define INTERFACE   IXml2Dex
DECLARE_INTERFACE_( IXml2Dex, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IXml2Dex methods */
    STDMETHOD( CreateGraphFromFile )( THIS_ IUnknown **, IUnknown *, BSTR ) PURE;
    STDMETHOD( WriteGrfFile )( THIS_ IUnknown *, BSTR ) PURE;
    STDMETHOD( WriteXMLFile )( THIS_ IUnknown *, BSTR ) PURE;
    STDMETHOD( ReadXMLFile )( THIS_ IUnknown *, BSTR ) PURE;
    STDMETHOD( Delete )( THIS_ IUnknown *, double, double ) PURE;
    STDMETHOD( WriteXMLPart )( THIS_ IUnknown *, double, double, BSTR ) PURE;
    STDMETHOD( PasteXMLFile )( THIS_ IUnknown *, double, BSTR ) PURE;
    STDMETHOD( CopyXML )( THIS_ IUnknown *, double, double ) PURE;
    STDMETHOD( PasteXML )( THIS_ IUnknown *, double ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( ReadXML )( THIS_ IUnknown *, IUnknown * ) PURE;
    STDMETHOD( WriteXML )( THIS_ IUnknown *, BSTR * ) PURE;
};

/* IAMErrorLog interface */
#undef INTERFACE
#define INTERFACE   IAMErrorLog
DECLARE_INTERFACE_( IAMErrorLog, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMErrorLog methods */
    STDMETHOD( LogError )( THIS_ long, BSTR, long, long, VARIANT * ) PURE;
};

/* IAMSetErrorLog interface */
#undef INTERFACE
#define INTERFACE   IAMSetErrorLog
DECLARE_INTERFACE_( IAMSetErrorLog, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMSetErrorLog methods */
    STDMETHOD( get_ErrorLog )( THIS_ IAMErrorLog ** ) PURE;
    STDMETHOD( put_ErrorLog )( THIS_ IAMErrorLog * ) PURE;
};

/* ISampleGrabberCB interface */
#undef INTERFACE
#define INTERFACE   ISampleGrabberCB
DECLARE_INTERFACE_( ISampleGrabberCB, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISampleGrabberCB methods */
    STDMETHOD( SampleCB )( THIS_ double, IMediaSample * ) PURE;
    STDMETHOD( BufferCB )( THIS_ double, BYTE *, long ) PURE;
};

/* ISampleGrabber interface */
#undef INTERFACE
#define INTERFACE   ISampleGrabber
DECLARE_INTERFACE_( ISampleGrabber, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISampleGrabber methods */
    STDMETHOD( SetOneShot )( THIS_ BOOL ) PURE;
    STDMETHOD( SetMediaType )( THIS_ const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetConnectedMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( SetBufferSamples )( THIS_ BOOL ) PURE;
    STDMETHOD( GetCurrentBuffer )( THIS_ long *, long * ) PURE;
    STDMETHOD( GetCurrentSample )( THIS_ IMediaSample ** ) PURE;
    STDMETHOD( SetCallback )( THIS_ ISampleGrabberCB *, long ) PURE;
};

/* IResize interface */
#undef INTERFACE
#define INTERFACE   IResize
DECLARE_INTERFACE_( IResize, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IResize methods */
    STDMETHOD( get_Size )( THIS_ int *, int *, long * ) PURE;
    STDMETHOD( get_InputSize )( THIS_ int *, int * ) PURE;
    STDMETHOD( put_Size )( THIS_ int, int, long ) PURE;
    STDMETHOD( get_MediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( put_MediaType )( THIS_ const AM_MEDIA_TYPE * ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IPropertySetter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPropertySetter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPropertySetter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPropertySetter_LoadXML( x, p ) \
        (x)->lpVtbl->LoadXML( x, p )
    #define IPropertySetter_PrintXML( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PrintXML( x, p1, p2, p3, p4 )
    #define IPropertySetter_CloneProps( x, p1, p2, p3 ) \
        (x)->lpVtbl->CloneProps( x, p1, p2, p3 )
    #define IPropertySetter_AddProp( x, p1, p2 ) \
        (x)->lpVtbl->AddProp( x, p1, p2 )
    #define IPropertySetter_GetProps( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetProps( x, p1, p2, p3 )
    #define IPropertySetter_FreeProps( x, p1, p2, p3 ) \
        (x)->lpVtbl->FreeProps( x, p1, p2, p3 )
    #define IPropertySetter_ClearProps( x ) \
        (x)->lpVtbl->ClearProps( x )
    #define IPropertySetter_SaveToBlob( x, p1, p2 ) \
        (x)->lpVtbl->SaveToBlob( x, p1, p2 )
    #define IPropertySetter_LoadFromBlob( x, p1, p2 ) \
        (x)->lpVtbl->LoadFromBlob( x, p1, p2 )
    #define IPropertySetter_SetProps( x, p1, p2 ) \
        (x)->lpVtbl->SetProps( x, p1, p2 )
    #define IPropertySetter_PrintXMLW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PrintXMLW( x, p1, p2, p3, p4 )
    #define IDxtCompositor_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDxtCompositor_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDxtCompositor_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDxtCompositor_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IDxtCompositor_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IDxtCompositor_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IDxtCompositor_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IDxtCompositor_get_Capabilities( x, p ) \
        (x)->lpVtbl->get_Capabilities( x, p )
    #define IDxtCompositor_get_Progress( x, p ) \
        (x)->lpVtbl->get_Progress( x, p )
    #define IDxtCompositor_put_Progress( x, p ) \
        (x)->lpVtbl->put_Progress( x, p )
    #define IDxtCompositor_get_StepResolution( x, p ) \
        (x)->lpVtbl->get_StepResolution( x, p )
    #define IDxtCompositor_get_Duration( x, p ) \
        (x)->lpVtbl->get_Duration( x, p )
    #define IDxtCompositor_put_Duration( x, p ) \
        (x)->lpVtbl->put_Duration( x, p )
    #define IDxtCompositor_get_OffsetX( x, p ) \
        (x)->lpVtbl->get_OffsetX( x, p )
    #define IDxtCompositor_put_OffsetX( x, p ) \
        (x)->lpVtbl->put_OffsetX( x, p )
    #define IDxtCompositor_get_OffsetY( x, p ) \
        (x)->lpVtbl->get_OffsetY( x, p )
    #define IDxtCompositor_put_OffsetY( x, p ) \
        (x)->lpVtbl->put_OffsetY( x, p )
    #define IDxtCompositor_put_Width( x, p ) \
        (x)->lpVtbl->put_Width( x, p )
    #define IDxtCompositor_get_Width( x, p ) \
        (x)->lpVtbl->get_Width( x, p )
    #define IDxtCompositor_put_Height( x, p ) \
        (x)->lpVtbl->put_Height( x, p )
    #define IDxtCompositor_get_Height( x, p ) \
        (x)->lpVtbl->get_Height( x, p )
    #define IDxtCompositor_put_SrcOffsetX( x, p ) \
        (x)->lpVtbl->put_SrcOffsetX( x, p )
    #define IDxtCompositor_get_SrcOffsetX( x, p ) \
        (x)->lpVtbl->get_SrcOffsetX( x, p )
    #define IDxtCompositor_put_SrcOffsetY( x, p ) \
        (x)->lpVtbl->put_SrcOffsetY( x, p )
    #define IDxtCompositor_get_SrcOffsetY( x, p ) \
        (x)->lpVtbl->get_SrcOffsetY( x, p )
    #define IDxtCompositor_put_SrcWidth( x, p ) \
        (x)->lpVtbl->put_SrcWidth( x, p )
    #define IDxtCompositor_get_SrcWidth( x, p ) \
        (x)->lpVtbl->get_SrcWidth( x, p )
    #define IDxtCompositor_put_SrcHeight( x, p ) \
        (x)->lpVtbl->put_SrcHeight( x, p )
    #define IDxtCompositor_get_SrcHeight( x, p ) \
        (x)->lpVtbl->get_SrcHeight( x, p )
    #define IDxtAlphaSetter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDxtAlphaSetter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDxtAlphaSetter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDxtAlphaSetter_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IDxtAlphaSetter_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IDxtAlphaSetter_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IDxtAlphaSetter_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IDxtAlphaSetter_get_Capabilities( x, p ) \
        (x)->lpVtbl->get_Capabilities( x, p )
    #define IDxtAlphaSetter_get_Progress( x, p ) \
        (x)->lpVtbl->get_Progress( x, p )
    #define IDxtAlphaSetter_put_Progress( x, p ) \
        (x)->lpVtbl->put_Progress( x, p )
    #define IDxtAlphaSetter_get_StepResolution( x, p ) \
        (x)->lpVtbl->get_StepResolution( x, p )
    #define IDxtAlphaSetter_get_Duration( x, p ) \
        (x)->lpVtbl->get_Duration( x, p )
    #define IDxtAlphaSetter_put_Duration( x, p ) \
        (x)->lpVtbl->put_Duration( x, p )
    #define IDxtAlphaSetter_put_Alpha( x, p ) \
        (x)->lpVtbl->put_Alpha( x, p )
    #define IDxtAlphaSetter_get_Alpha( x, p ) \
        (x)->lpVtbl->get_Alpha( x, p )
    #define IDxtAlphaSetter_put_AlphaRamp( x, p ) \
        (x)->lpVtbl->put_AlphaRamp( x, p )
    #define IDxtAlphaSetter_get_AlphaRamp( x, p ) \
        (x)->lpVtbl->get_AlphaRamp( x, p )
    #define IDxtJpeg_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDxtJpeg_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDxtJpeg_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDxtJpeg_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IDxtJpeg_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IDxtJpeg_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IDxtJpeg_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IDxtJpeg_get_Capabilities( x, p ) \
        (x)->lpVtbl->get_Capabilities( x, p )
    #define IDxtJpeg_get_Progress( x, p ) \
        (x)->lpVtbl->get_Progress( x, p )
    #define IDxtJpeg_put_Progress( x, p ) \
        (x)->lpVtbl->put_Progress( x, p )
    #define IDxtJpeg_get_StepResolution( x, p ) \
        (x)->lpVtbl->get_StepResolution( x, p )
    #define IDxtJpeg_get_Duration( x, p ) \
        (x)->lpVtbl->get_Duration( x, p )
    #define IDxtJpeg_put_Duration( x, p ) \
        (x)->lpVtbl->put_Duration( x, p )
    #define IDxtJpeg_get_MaskNum( x, p ) \
        (x)->lpVtbl->get_MaskNum( x, p )
    #define IDxtJpeg_put_MaskNum( x, p ) \
        (x)->lpVtbl->put_MaskNum( x, p )
    #define IDxtJpeg_get_MaskName( x, p ) \
        (x)->lpVtbl->get_MaskName( x, p )
    #define IDxtJpeg_put_MaskName( x, p ) \
        (x)->lpVtbl->put_MaskName( x, p )
    #define IDxtJpeg_get_ScaleX( x, p ) \
        (x)->lpVtbl->get_ScaleX( x, p )
    #define IDxtJpeg_put_ScaleX( x, p ) \
        (x)->lpVtbl->put_ScaleX( x, p )
    #define IDxtJpeg_get_ScaleY( x, p ) \
        (x)->lpVtbl->get_ScaleY( x, p )
    #define IDxtJpeg_put_ScaleY( x, p ) \
        (x)->lpVtbl->put_ScaleY( x, p )
    #define IDxtJpeg_put_ReplicateX( x, p ) \
        (x)->lpVtbl->put_ReplicateX( x, p )
    #define IDxtJpeg_get_ReplicateX( x, p ) \
        (x)->lpVtbl->get_ReplicateX( x, p )
    #define IDxtJpeg_put_ReplicateY( x, p ) \
        (x)->lpVtbl->put_ReplicateY( x, p )
    #define IDxtJpeg_get_ReplicateY( x, p ) \
        (x)->lpVtbl->get_ReplicateY( x, p )
    #define IDxtJpeg_put_BorderColor( x, p ) \
        (x)->lpVtbl->put_BorderColor( x, p )
    #define IDxtJpeg_get_BorderColor( x, p ) \
        (x)->lpVtbl->get_BorderColor( x, p )
    #define IDxtJpeg_put_BorderWidth( x, p ) \
        (x)->lpVtbl->put_BorderWidth( x, p )
    #define IDxtJpeg_get_BorderWidth( x, p ) \
        (x)->lpVtbl->get_BorderWidth( x, p )
    #define IDxtJpeg_put_BorderSoftness( x, p ) \
        (x)->lpVtbl->put_BorderSoftness( x, p )
    #define IDxtJpeg_get_BorderSoftness( x, p ) \
        (x)->lpVtbl->get_BorderSoftness( x, p )
    #define IDxtJpeg_ApplyChanges( x ) \
        (x)->lpVtbl->ApplyChanges( x )
    #define IDxtJpeg_LoadDefSettings( x ) \
        (x)->lpVtbl->LoadDefSettings( x )
    #define IDxtKey_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDxtKey_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDxtKey_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDxtKey_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IDxtKey_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IDxtKey_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IDxtKey_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IDxtKey_get_Capabilities( x, p ) \
        (x)->lpVtbl->get_Capabilities( x, p )
    #define IDxtKey_get_Progress( x, p ) \
        (x)->lpVtbl->get_Progress( x, p )
    #define IDxtKey_put_Progress( x, p ) \
        (x)->lpVtbl->put_Progress( x, p )
    #define IDxtKey_get_StepResolution( x, p ) \
        (x)->lpVtbl->get_StepResolution( x, p )
    #define IDxtKey_get_Duration( x, p ) \
        (x)->lpVtbl->get_Duration( x, p )
    #define IDxtKey_put_Duration( x, p ) \
        (x)->lpVtbl->put_Duration( x, p )
    #define IDxtKey_get_KeyType( x, p ) \
        (x)->lpVtbl->get_KeyType( x, p )
    #define IDxtKey_put_KeyType( x, p ) \
        (x)->lpVtbl->put_KeyType( x, p )
    #define IDxtKey_get_Hue( x, p ) \
        (x)->lpVtbl->get_Hue( x, p )
    #define IDxtKey_put_Hue( x, p ) \
        (x)->lpVtbl->put_Hue( x, p )
    #define IDxtKey_get_Luminance( x, p ) \
        (x)->lpVtbl->get_Luminance( x, p )
    #define IDxtKey_put_Luminance( x, p ) \
        (x)->lpVtbl->put_Luminance( x, p )
    #define IDxtKey_get_RGB( x, p ) \
        (x)->lpVtbl->get_RGB( x, p )
    #define IDxtKey_put_RGB( x, p ) \
        (x)->lpVtbl->put_RGB( x, p )
    #define IDxtKey_get_Similarity( x, p ) \
        (x)->lpVtbl->get_Similarity( x, p )
    #define IDxtKey_put_Similarity( x, p ) \
        (x)->lpVtbl->put_Similarity( x, p )
    #define IDxtKey_get_Invert( x, p ) \
        (x)->lpVtbl->get_Invert( x, p )
    #define IDxtKey_put_Invert( x, p ) \
        (x)->lpVtbl->put_Invert( x, p )
    #define IMediaLocator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaLocator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaLocator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaLocator_FindMediaFile( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FindMediaFile( x, p1, p2, p3, p4 )
    #define IMediaLocator_AddFoundLocation( x, p ) \
        (x)->lpVtbl->AddFoundLocation( x, p )
    #define IMediaDet_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaDet_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaDet_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaDet_get_Filter( x, p ) \
        (x)->lpVtbl->get_Filter( x, p )
    #define IMediaDet_put_Filter( x, p ) \
        (x)->lpVtbl->put_Filter( x, p )
    #define IMediaDet_get_OutputStreams( x, p ) \
        (x)->lpVtbl->get_OutputStreams( x, p )
    #define IMediaDet_get_CurrentStream( x, p ) \
        (x)->lpVtbl->get_CurrentStream( x, p )
    #define IMediaDet_put_CurrentStream( x, p ) \
        (x)->lpVtbl->put_CurrentStream( x, p )
    #define IMediaDet_get_StreamType( x, p ) \
        (x)->lpVtbl->get_StreamType( x, p )
    #define IMediaDet_get_StreamTypeB( x, p ) \
        (x)->lpVtbl->get_StreamTypeB( x, p )
    #define IMediaDet_get_StreamLength( x, p ) \
        (x)->lpVtbl->get_StreamLength( x, p )
    #define IMediaDet_get_Filename( x, p ) \
        (x)->lpVtbl->get_Filename( x, p )
    #define IMediaDet_put_Filename( x, p ) \
        (x)->lpVtbl->put_Filename( x, p )
    #define IMediaDet_GetBitmapBits( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBitmapBits( x, p1, p2, p3, p4 )
    #define IMediaDet_WriteBitmapBits( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->WriteBitmapBits( x, p1, p2, p3, p4 )
    #define IMediaDet_get_StreamMediaType( x, p ) \
        (x)->lpVtbl->get_StreamMediaType( x, p )
    #define IMediaDet_GetSampleGrabber( x, p ) \
        (x)->lpVtbl->GetSampleGrabber( x, p )
    #define IMediaDet_get_FrameRate( x, p ) \
        (x)->lpVtbl->get_FrameRate( x, p )
    #define IMediaDet_EnterBitmapGrabMode( x, p ) \
        (x)->lpVtbl->EnterBitmapGrabMode( x, p )
    #define IGrfCache_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGrfCache_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGrfCache_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGrfCache_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IGrfCache_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IGrfCache_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IGrfCache_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IGrfCache_AddFilter( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AddFilter( x, p1, p2, p3, p4 )
    #define IGrfCache_ConnectPins( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ConnectPins( x, p1, p2, p3, p4, p5 )
    #define IGrfCache_SetGraph( x, p ) \
        (x)->lpVtbl->SetGraph( x, p )
    #define IGrfCache_DoConnectionsNow( x ) \
        (x)->lpVtbl->DoConnectionsNow( x )
    #define IRenderEngine_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRenderEngine_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRenderEngine_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRenderEngine_SetTimelineObject( x, p ) \
        (x)->lpVtbl->SetTimelineObject( x, p )
    #define IRenderEngine_GetTimelineObject( x, p ) \
        (x)->lpVtbl->GetTimelineObject( x, p )
    #define IRenderEngine_GetFilterGraph( x, p ) \
        (x)->lpVtbl->GetFilterGraph( x, p )
    #define IRenderEngine_SetFilterGraph( x, p ) \
        (x)->lpVtbl->SetFilterGraph( x, p )
    #define IRenderEngine_SetInterestRange( x, p1, p2 ) \
        (x)->lpVtbl->SetInterestRange( x, p1, p2 )
    #define IRenderEngine_SetInterestRange2( x, p1, p2 ) \
        (x)->lpVtbl->SetInterestRange2( x, p1, p2 )
    #define IRenderEngine_SetRenderRange( x, p1, p2 ) \
        (x)->lpVtbl->SetRenderRange( x, p1, p2 )
    #define IRenderEngine_SetRenderRange2( x, p1, p2 ) \
        (x)->lpVtbl->SetRenderRange2( x, p1, p2 )
    #define IRenderEngine_GetGroupOutputPin( x, p1, p2 ) \
        (x)->lpVtbl->GetGroupOutputPin( x, p1, p2 )
    #define IRenderEngine_ScrapIt( x ) \
        (x)->lpVtbl->ScrapIt( x )
    #define IRenderEngine_RenderOutputPins( x ) \
        (x)->lpVtbl->RenderOutputPins( x )
    #define IRenderEngine_GetVendorString( x, p ) \
        (x)->lpVtbl->GetVendorString( x, p )
    #define IRenderEngine_ConnectFrontEnd( x ) \
        (x)->lpVtbl->ConnectFrontEnd( x )
    #define IRenderEngine_SetSourceConnectCallback( x, p ) \
        (x)->lpVtbl->SetSourceConnectCallback( x, p )
    #define IRenderEngine_SetDynamicReconnectLevel( x, p ) \
        (x)->lpVtbl->SetDynamicReconnectLevel( x, p )
    #define IRenderEngine_DoSmartRecompression( x ) \
        (x)->lpVtbl->DoSmartRecompression( x )
    #define IRenderEngine_UseInSmartRecompressionGraph( x ) \
        (x)->lpVtbl->UseInSmartRecompressionGraph( x )
    #define IRenderEngine_SetSourceNameValidation( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetSourceNameValidation( x, p1, p2, p3 )
    #define IRenderEngine_Commit( x ) \
        (x)->lpVtbl->Commit( x )
    #define IRenderEngine_Decommit( x ) \
        (x)->lpVtbl->Decommit( x )
    #define IRenderEngine_GetCaps( x, p1, p2 ) \
        (x)->lpVtbl->GetCaps( x, p1, p2 )
    #define IRenderEngine2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRenderEngine2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRenderEngine2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRenderEngine2_SetResizerGUID( x, p ) \
        (x)->lpVtbl->SetResizerGUID( x, p )
    #define IFindCompressorCB_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFindCompressorCB_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFindCompressorCB_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFindCompressorCB_GetCompressor( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCompressor( x, p1, p2, p3 )
    #define ISmartRenderEngine_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISmartRenderEngine_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISmartRenderEngine_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISmartRenderEngine_SetGroupCompressor( x, p1, p2 ) \
        (x)->lpVtbl->SetGroupCompressor( x, p1, p2 )
    #define ISmartRenderEngine_GetGroupCompressor( x, p1, p2 ) \
        (x)->lpVtbl->GetGroupCompressor( x, p1, p2 )
    #define ISmartRenderEngine_SetFindCompressorCB( x, p ) \
        (x)->lpVtbl->SetFindCompressorCB( x, p )
    #define IAMTimelineObj_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineObj_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineObj_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineObj_GetStartStop( x, p1, p2 ) \
        (x)->lpVtbl->GetStartStop( x, p1, p2 )
    #define IAMTimelineObj_GetStartStop2( x, p1, p2 ) \
        (x)->lpVtbl->GetStartStop2( x, p1, p2 )
    #define IAMTimelineObj_FixTimes( x, p1, p2 ) \
        (x)->lpVtbl->FixTimes( x, p1, p2 )
    #define IAMTimelineObj_FixTimes2( x, p1, p2 ) \
        (x)->lpVtbl->FixTimes2( x, p1, p2 )
    #define IAMTimelineObj_SetStartStop( x, p1, p2 ) \
        (x)->lpVtbl->SetStartStop( x, p1, p2 )
    #define IAMTimelineObj_SetStartStop2( x, p1, p2 ) \
        (x)->lpVtbl->SetStartStop2( x, p1, p2 )
    #define IAMTimelineObj_GetPropertySetter( x, p ) \
        (x)->lpVtbl->GetPropertySetter( x, p )
    #define IAMTimelineObj_SetPropertySetter( x, p ) \
        (x)->lpVtbl->SetPropertySetter( x, p )
    #define IAMTimelineObj_GetSubObject( x, p ) \
        (x)->lpVtbl->GetSubObject( x, p )
    #define IAMTimelineObj_SetSubObject( x, p ) \
        (x)->lpVtbl->SetSubObject( x, p )
    #define IAMTimelineObj_SetSubObjectGUID( x, p ) \
        (x)->lpVtbl->SetSubObjectGUID( x, p )
    #define IAMTimelineObj_SetSubObjectGUIDB( x, p ) \
        (x)->lpVtbl->SetSubObjectGUIDB( x, p )
    #define IAMTimelineObj_GetSubObjectGUID( x, p ) \
        (x)->lpVtbl->GetSubObjectGUID( x, p )
    #define IAMTimelineObj_GetSubObjectGUIDB( x, p ) \
        (x)->lpVtbl->GetSubObjectGUIDB( x, p )
    #define IAMTimelineObj_GetSubObjectLoaded( x, p ) \
        (x)->lpVtbl->GetSubObjectLoaded( x, p )
    #define IAMTimelineObj_GetTimelineType( x, p ) \
        (x)->lpVtbl->GetTimelineType( x, p )
    #define IAMTimelineObj_SetTimelineType( x, p ) \
        (x)->lpVtbl->SetTimelineType( x, p )
    #define IAMTimelineObj_GetUserID( x, p ) \
        (x)->lpVtbl->GetUserID( x, p )
    #define IAMTimelineObj_SetUserID( x, p ) \
        (x)->lpVtbl->SetUserID( x, p )
    #define IAMTimelineObj_GetGenID( x, p ) \
        (x)->lpVtbl->GetGenID( x, p )
    #define IAMTimelineObj_GetUserName( x, p ) \
        (x)->lpVtbl->GetUserName( x, p )
    #define IAMTimelineObj_SetUserName( x, p ) \
        (x)->lpVtbl->SetUserName( x, p )
    #define IAMTimelineObj_GetUserData( x, p1, p2 ) \
        (x)->lpVtbl->GetUserData( x, p1, p2 )
    #define IAMTimelineObj_SetUserData( x, p1, p2 ) \
        (x)->lpVtbl->SetUserData( x, p1, p2 )
    #define IAMTimelineObj_GetMuted( x, p ) \
        (x)->lpVtbl->GetMuted( x, p )
    #define IAMTimelineObj_SetMuted( x, p ) \
        (x)->lpVtbl->SetMuted( x, p )
    #define IAMTimelineObj_GetLocked( x, p ) \
        (x)->lpVtbl->GetLocked( x, p )
    #define IAMTimelineObj_SetLocked( x, p ) \
        (x)->lpVtbl->SetLocked( x, p )
    #define IAMTimelineObj_GetDirtyRange( x, p1, p2 ) \
        (x)->lpVtbl->GetDirtyRange( x, p1, p2 )
    #define IAMTimelineObj_GetDirtyRange2( x, p1, p2 ) \
        (x)->lpVtbl->GetDirtyRange( x, p1, p2 )
    #define IAMTimelineObj_SetDirtyRange( x, p1, p2 ) \
        (x)->lpVtbl->SetDirtyRange( x, p1, p2 )
    #define IAMTimelineObj_SetDirtyRange2( x, p1, p2 ) \
        (x)->lpVtbl->SetDirtyRange2( x, p1, p2 )
    #define IAMTimelineObj_ClearDirty( x ) \
        (x)->lpVtbl->ClearDirty( x )
    #define IAMTimelineObj_Remove( x ) \
        (x)->lpVtbl->Remove( x )
    #define IAMTimelineObj_RemoveAll( x ) \
        (x)->lpVtbl->RemoveAll( x )
    #define IAMTimelineObj_GetTimelineNoRef( x, p ) \
        (x)->lpVtbl->GetTimelineNoRef( x, p )
    #define IAMTimelineObj_GetGroupIBelongTo( x, p ) \
        (x)->lpVtbl->GetGroupIBelongTo( x, p )
    #define IAMTimelineObj_GetEmbedDepth( x, p ) \
        (x)->lpVtbl->GetEmbedDepth( x, p )
    #define IAMTimelineEffectable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineEffectable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineEffectable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineEffectable_EffectInsBefore( x, p1, p2 ) \
        (x)->lpVtbl->EffectInsBefore( x, p1, p2 )
    #define IAMTimelineEffectable_EffectSwapPriorities( x, p1, p2 ) \
        (x)->lpVtbl->EffectSwapPriorities( x, p1, p2 )
    #define IAMTimelineEffectable_EffectGetCount( x, p ) \
        (x)->lpVtbl->EffectGetCount( x, p )
    #define IAMTimelineEffectable_GetEffect( x, p1, p2 ) \
        (x)->lpVtbl->GetEffect( x, p1, p2 )
    #define IAMTimelineEffect_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineEffect_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineEffect_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineEffect_EffectGetPriority( x, p ) \
        (x)->lpVtbl->EffectGetPriority( x, p )
    #define IAMTimelineTransable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineTransable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineTransable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineTransable_TransAdd( x, p ) \
        (x)->lpVtbl->TransAdd( x, p )
    #define IAMTimelineTransable_TransGetCount( x, p ) \
        (x)->lpVtbl->TransGetCount( x, p )
    #define IAMTimelineTransable_GetNextTrans( x, p1, p2 ) \
        (x)->lpVtbl->GetNextTrans( x, p1, p2 )
    #define IAMTimelineTransable_GetNextTrans2( x, p1, p2 ) \
        (x)->lpVtbl->GetNextTrans2( x, p1, p2 )
    #define IAMTimelineTransable_GetTransAtTime( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTransAtTime( x, p1, p2, p3 )
    #define IAMTimelineTransable_GetTransAtTime2( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTransAtTime2( x, p1, p2, p3 )
    #define IAMTimelineSplittable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineSplittable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineSplittable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineSplittable_SplitAt( x, p ) \
        (x)->lpVtbl->SplitAt( x, p )
    #define IAMTimelineSplittable_SplitAt2( x, p ) \
        (x)->lpVtbl->SplitAt2( x, p )
    #define IAMTimelineTrans_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineTrans_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineTrans_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineTrans_GetCutPoint( x, p ) \
        (x)->lpVtbl->GetCutPoint( x, p )
    #define IAMTimelineTrans_GetCutPoint2( x, p ) \
        (x)->lpVtbl->GetCutPoint2( x, p )
    #define IAMTimelineTrans_SetCutPoint( x, p ) \
        (x)->lpVtbl->SetCutPoint( x, p )
    #define IAMTimelineTrans_SetCutPoint2( x, p ) \
        (x)->lpVtbl->SetCutPoint2( x, p )
    #define IAMTimelineTrans_GetSwapInputs( x, p ) \
        (x)->lpVtbl->GetSwapInputs( x, p )
    #define IAMTimelineTrans_SetSwapInputs( x, p ) \
        (x)->lpVtbl->SetSwapInputs( x, p )
    #define IAMTimelineTrans_GetCutsOnly( x, p ) \
        (x)->lpVtbl->GetCutsOnly( x, p )
    #define IAMTimelineTrans_SetCutsOnly( x, p ) \
        (x)->lpVtbl->SetCutsOnly( x, p )
    #define IAMTimelineSrc_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineSrc_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineSrc_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineSrc_GetMediaTimes( x, p1, p2 ) \
        (x)->lpVtbl->GetMediaTimes( x, p1, p2 )
    #define IAMTimelineSrc_GetMediaTimes2( x, p1, p2 ) \
        (x)->lpVtbl->GetMediaTimes2( x, p1, p2 )
    #define IAMTimelineSrc_ModifyStopTime( x, p ) \
        (x)->lpVtbl->ModifyStopTime( x, p )
    #define IAMTimelineSrc_ModifyStopTime2( x, p ) \
        (x)->lpVtbl->ModifyStopTime2( x, p )
    #define IAMTimelineSrc_FixMediaTimes( x, p1, p2 ) \
        (x)->lpVtbl->FixMediaTimes( x, p1, p2 )
    #define IAMTimelineSrc_FixMediaTimes2( x, p1, p2 ) \
        (x)->lpVtbl->FixMediaTimes2( x, p1, p2 )
    #define IAMTimelineSrc_SetMediaTimes( x, p1, p2 ) \
        (x)->lpVtbl->SetMediaTimes( x, p1, p2 )
    #define IAMTimelineSrc_SetMediaTimes2( x, p1, p2 ) \
        (x)->lpVtbl->SetMediaTimes2( x, p1, p2 )
    #define IAMTimelineSrc_SetMediaLength( x, p ) \
        (x)->lpVtbl->SetMediaLength( x, p )
    #define IAMTimelineSrc_SetMediaLength2( x, p ) \
        (x)->lpVtbl->SetMediaLength2( x, p )
    #define IAMTimelineSrc_GetMediaLength( x, p ) \
        (x)->lpVtbl->GetMediaLength( x, p )
    #define IAMTimelineSrc_GetMediaLength2( x, p ) \
        (x)->lpVtbl->GetMediaLength2( x, p )
    #define IAMTimelineSrc_GetMediaName( x, p ) \
        (x)->lpVtbl->GetMediaName( x, p )
    #define IAMTimelineSrc_SetMediaName( x, p ) \
        (x)->lpVtbl->SetMediaName( x, p )
    #define IAMTimelineSrc_SpliceWithNext( x, p ) \
        (x)->lpVtbl->SpliceWithNext( x, p )
    #define IAMTimelineSrc_GetStreamNumber( x, p ) \
        (x)->lpVtbl->GetStreamNumber( x, p )
    #define IAMTimelineSrc_SetStreamNumber( x, p ) \
        (x)->lpVtbl->SetStreamNumber( x, p )
    #define IAMTimelineSrc_IsNormalRate( x, p ) \
        (x)->lpVtbl->IsNormalRate( x, p )
    #define IAMTimelineSrc_GetDefaultFPS( x, p ) \
        (x)->lpVtbl->GetDefaultFPS( x, p )
    #define IAMTimelineSrc_SetDefaultFPS( x, p ) \
        (x)->lpVtbl->SetDefaultFPS( x, p )
    #define IAMTimelineSrc_GetStretchMode( x, p ) \
        (x)->lpVtbl->GetStretchMode( x, p )
    #define IAMTimelineSrc_SetStretchMode( x, p ) \
        (x)->lpVtbl->SetStretchMode( x, p )
    #define IAMTimelineTrack_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineTrack_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineTrack_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineTrack_SrcAdd( x, p ) \
        (x)->lpVtbl->SrcAdd( x, p )
    #define IAMTimelineTrack_GetNextSrc( x, p1, p2 ) \
        (x)->lpVtbl->GetNextSrc( x, p1, p2 )
    #define IAMTimelineTrack_GetNextSrc2( x, p1, p2 ) \
        (x)->lpVtbl->GetNextSrc2( x, p1, p2 )
    #define IAMTimelineTrack_MoveEverythingBy( x, p1, p2 ) \
        (x)->lpVtbl->MoveEverythingBy( x, p1, p2 )
    #define IAMTimelineTrack_MoveEverythingBy2( x, p1, p2 ) \
        (x)->lpVtbl->MoveEverythingBy2( x, p1, p2 )
    #define IAMTimelineTrack_GetSourcesCount( x, p ) \
        (x)->lpVtbl->GetSourcesCount( x, p )
    #define IAMTimelineTrack_AreYouBlank( x, p ) \
        (x)->lpVtbl->AreYouBlank( x, p )
    #define IAMTimelineTrack_GetSrcAtTime( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetSrcAtTime( x, p1, p2, p3 )
    #define IAMTimelineTrack_GetSrcAtTime2( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetSrcAtTime2( x, p1, p2, p3 )
    #define IAMTimelineTrack_InsertSpace( x, p1, p2 ) \
        (x)->lpVtbl->InsertSpace( x, p1, p2 )
    #define IAMTimelineTrack_InsertSpace2( x, p1, p2 ) \
        (x)->lpVtbl->InsertSpace2( x, p1, p2 )
    #define IAMTimelineTrack_ZeroBetween( x, p1, p2 ) \
        (x)->lpVtbl->ZeroBetween( x, p1, p2 )
    #define IAMTimelineTrack_ZeroBetween2( x, p1, p2 ) \
        (x)->lpVtbl->ZeroBetween2( x, p1, p2 )
    #define IAMTimelineTrack_GetNextSrcEx( x, p1, p2 ) \
        (x)->lpVtbl->GetNextSrcEx( x, p1, p2 )
    #define IAMTimelineVirtualTrack_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineVirtualTrack_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineVirtualTrack_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineVirtualTrack_TrackGetPriority( x, p ) \
        (x)->lpVtbl->TrackGetPriority( x, p )
    #define IAMTimelineVirtualTrack_SetTrackDirty( x ) \
        (x)->lpVtbl->SetTrackDirty( x )
    #define IAMTimelineComp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineComp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineComp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineComp_VTrackInsBefore( x, p1, p2 ) \
        (x)->lpVtbl->VTrackInsBefore( x, p1, p2 )
    #define IAMTimelineComp_VTrackSwapPriorities( x, p1, p2 ) \
        (x)->lpVtbl->VTrackSwapPriorities( x, p1, p2 )
    #define IAMTimelineComp_VTrackGetCount( x, p ) \
        (x)->lpVtbl->VTrackGetCount( x, p )
    #define IAMTimelineComp_GetVTrack( x, p1, p2 ) \
        (x)->lpVtbl->GetVTrack( x, p1, p2 )
    #define IAMTimelineComp_GetCountOfType( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCountOfType( x, p1, p2, p3 )
    #define IAMTimelineComp_GetRecursiveLayerOfType( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRecursiveLayerOfType( x, p1, p2, p3 )
    #define IAMTimelineComp_GetRecursiveLayerOfTypeI( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRecursiveLayerOfTypeI( x, p1, p2, p3 )
    #define IAMTimelineComp_GetNextVTrack( x, p1, p2 ) \
        (x)->lpVtbl->GetNextVTrack( x, p1, p2 )
    #define IAMTimelineGroup_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimelineGroup_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimelineGroup_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimelineGroup_SetTimeline( x, p ) \
        (x)->lpVtbl->SetTimeline( x, p )
    #define IAMTimelineGroup_GetTimeline( x, p ) \
        (x)->lpVtbl->GetTimeline( x, p )
    #define IAMTimelineGroup_GetPriority( x, p ) \
        (x)->lpVtbl->GetPriority( x, p )
    #define IAMTimelineGroup_GetMediaType( x, p ) \
        (x)->lpVtbl->GetMediaType( x, p )
    #define IAMTimelineGroup_SetMediaType( x, p ) \
        (x)->lpVtbl->SetMediaType( x, p )
    #define IAMTimelineGroup_SetOutputFPS( x, p ) \
        (x)->lpVtbl->SetOutputFPS( x, p )
    #define IAMTimelineGroup_GetOutputFPS( x, p ) \
        (x)->lpVtbl->GetOutputFPS( x, p )
    #define IAMTimelineGroup_SetGroupName( x, p ) \
        (x)->lpVtbl->SetGroupName( x, p )
    #define IAMTimelineGroup_GetGroupName( x, p ) \
        (x)->lpVtbl->GetGroupName( x, p )
    #define IAMTimelineGroup_SetPreviewMode( x, p ) \
        (x)->lpVtbl->SetPreviewMode( x, p )
    #define IAMTimelineGroup_GetPreviewMode( x, p ) \
        (x)->lpVtbl->GetPreviewMode( x, p )
    #define IAMTimelineGroup_SetMediaTypeForVB( x, p ) \
        (x)->lpVtbl->SetMediaTypeForVB( x, p )
    #define IAMTimelineGroup_GetOutputBuffering( x, p ) \
        (x)->lpVtbl->GetOutputBuffering( x, p )
    #define IAMTimelineGroup_SetOutputBuffering( x, p ) \
        (x)->lpVtbl->SetOutputBuffering( x, p )
    #define IAMTimelineGroup_SetSmartRecompressFormat( x, p ) \
        (x)->lpVtbl->SetSmartRecompressFormat( x, p )
    #define IAMTimelineGroup_GetSmartRecompressFormat( x, p ) \
        (x)->lpVtbl->GetSmartRecompressFormat( x, p )
    #define IAMTimelineGroup_IsSmartRecompressFormatSet( x, p ) \
        (x)->lpVtbl->IsSmartRecompressFormatSet( x, p )
    #define IAMTimelineGroup_IsRecompressFormatDirty( x, p ) \
        (x)->lpVtbl->IsRecompressFormatDirty( x, p )
    #define IAMTimelineGroup_ClearRecompressFormatDirty( x ) \
        (x)->lpVtbl->ClearRecompressFormatDirty( x )
    #define IAMTimelineGroup_SetRecompFormatFromSource( x, p ) \
        (x)->lpVtbl->SetRecompFormatFromSource( x, p )
    #define IAMTimeline_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimeline_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimeline_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimeline_CreateEmptyNode( x, p1, p2 ) \
        (x)->lpVtbl->CreateEmptyNode( x, p1, p2 )
    #define IAMTimeline_AddGroup( x, p ) \
        (x)->lpVtbl->AddGroup( x, p )
    #define IAMTimeline_RemGroupFromList( x, p ) \
        (x)->lpVtbl->RemGroupFromList( x, p )
    #define IAMTimeline_GetGroup( x, p1, p2 ) \
        (x)->lpVtbl->GetGroup( x, p1, p2 )
    #define IAMTimeline_GetGroupCount( x, p ) \
        (x)->lpVtbl->GetGroupCount( x, p )
    #define IAMTimeline_ClearAllGroups( x ) \
        (x)->lpVtbl->ClearAllGroups( x )
    #define IAMTimeline_GetInsertMode( x, p ) \
        (x)->lpVtbl->GetInsertMode( x, p )
    #define IAMTimeline_SetInsertMode( x, p ) \
        (x)->lpVtbl->SetInsertMode( x, p )
    #define IAMTimeline_EnableTransitions( x, p ) \
        (x)->lpVtbl->EnableTransitions( x, p )
    #define IAMTimeline_TransitionsEnabled( x, p ) \
        (x)->lpVtbl->TransitionsEnabled( x, p )
    #define IAMTimeline_EnableEffects( x, p ) \
        (x)->lpVtbl->EnableEffects( x, p )
    #define IAMTimeline_EffectsEnabled( x, p ) \
        (x)->lpVtbl->EffectsEnabled( x, p )
    #define IAMTimeline_SetInterestRange( x, p1, p2 ) \
        (x)->lpVtbl->SetInterestRange( x, p1, p2 )
    #define IAMTimeline_GetDuration( x, p ) \
        (x)->lpVtbl->GetDuration( x, p )
    #define IAMTimeline_GetDuration2( x, p ) \
        (x)->lpVtbl->GetDuration2( x, p )
    #define IAMTimeline_SetDefaultFPS( x, p ) \
        (x)->lpVtbl->SetDefaultFPS( x, p )
    #define IAMTimeline_GetDefaultFPS( x, p ) \
        (x)->lpVtbl->GetDefaultFPS( x, p )
    #define IAMTimeline_IsDirty( x, p ) \
        (x)->lpVtbl->IsDirty( x, p )
    #define IAMTimeline_GetDirtyRange( x, p1, p2 ) \
        (x)->lpVtbl->GetDirtyRange( x, p1, p2 )
    #define IAMTimeline_GetCountOfType( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetCountOfType( x, p1, p2, p3, p4 )
    #define IAMTimeline_ValidateSourceNames( x, p1, p2, p3 ) \
        (x)->lpVtbl->ValidateSourceNames( x, p1, p2, p3 )
    #define IAMTimeline_SetDefaultTransition( x, p ) \
        (x)->lpVtbl->SetDefaultTransition( x, p )
    #define IAMTimeline_GetDefaultTransition( x, p ) \
        (x)->lpVtbl->GetDefaultTransition( x, p )
    #define IAMTimeline_SetDefaultEffect( x, p ) \
        (x)->lpVtbl->SetDefaultEffect( x, p )
    #define IAMTimeline_GetDefaultEffect( x, p ) \
        (x)->lpVtbl->GetDefaultEffect( x, p )
    #define IAMTimeline_SetDefaultTransitionB( x, p ) \
        (x)->lpVtbl->SetDefaultTransitionB( x, p )
    #define IAMTimeline_GetDefaultTransitionB( x, p ) \
        (x)->lpVtbl->GetDefaultTransitionB( x, p )
    #define IAMTimeline_SetDefaultEffectB( x, p ) \
        (x)->lpVtbl->SetDefaultEffectB( x, p )
    #define IAMTimeline_GetDefaultEffectB( x, p ) \
        (x)->lpVtbl->GetDefaultEffectB( x, p )
    #define IXml2Dex_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IXml2Dex_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IXml2Dex_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IXml2Dex_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IXml2Dex_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IXml2Dex_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IXml2Dex_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IXml2Dex_CreateGraphFromFile( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateGraphFromFile( x, p1, p2, p3 )
    #define IXml2Dex_WriteGrfFile( x, p1, p2 ) \
        (x)->lpVtbl->WriteGrfFile( x, p1, p2 )
    #define IXml2Dex_WriteXMLFile( x, p1, p2 ) \
        (x)->lpVtbl->WriteXMLFile( x, p1, p2 )
    #define IXml2Dex_ReadXMLFile( x, p1, p2 ) \
        (x)->lpVtbl->ReadXMLFile( x, p1, p2 )
    #define IXml2Dex_Delete( x, p1, p2, p3 ) \
        (x)->lpVtbl->Delete( x, p1, p2, p3 )
    #define IXml2Dex_WriteXMLPart( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->WriteXMLPart( x, p1, p2, p3, p4 )
    #define IXml2Dex_PasteXMLFile( x, p1, p2, p3 ) \
        (x)->lpVtbl->PasteXMLFile( x, p1, p2, p3 )
    #define IXml2Dex_CopyXML( x, p1, p2, p3 ) \
        (x)->lpVtbl->CopyXML( x, p1, p2, p3 )
    #define IXml2Dex_PasteXML( x, p1, p2 ) \
        (x)->lpVtbl->PasteXML( x, p1, p2 )
    #define IXml2Dex_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IXml2Dex_ReadXML( x, p1, p2 ) \
        (x)->lpVtbl->ReadXML( x, p1, p2 )
    #define IXml2Dex_WriteXML( x, p1, p2 ) \
        (x)->lpVtbl->WriteXML( x, p1, p2 )
    #define IAMErrorLog_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMErrorLog_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMErrorLog_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMErrorLog_LogError( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->LogError( x, p1, p2, p3, p4, p5 )
    #define IAMSetErrorLog_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMSetErrorLog_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMSetErrorLog_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMSetErrorLog_get_ErrorLog( x, p ) \
        (x)->lpVtbl->get_ErrorLog( x, p )
    #define IAMSetErrorLog_put_ErrorLog( x, p ) \
        (x)->lpVtbl->put_ErrorLog( x, p )
    #define ISampleGrabberCB_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISampleGrabberCB_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISampleGrabberCB_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISampleGrabberCB_SampleCB( x, p1, p2 ) \
        (x)->lpVtbl->SampleCB( x, p1, p2 )
    #define ISampleGrabberCB_BufferCB( x, p1, p2, p3 ) \
        (x)->lpVtbl->BufferCB( x, p1, p2, p3 )
    #define ISampleGrabber_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISampleGrabber_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISampleGrabber_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISampleGrabber_SetOneShot( x, p ) \
        (x)->lpVtbl->SetOneShot( x, p )
    #define ISampleGrabber_SetMediaType( x, p ) \
        (x)->lpVtbl->SetMediaType( x, p )
    #define ISampleGrabber_GetConnectedMediaType( x, p ) \
        (x)->lpVtbl->GetConnectedMediaType( x, p )
    #define ISampleGrabber_SetBufferSamples( x, p ) \
        (x)->lpVtbl->SetBufferSamples( x, p )
    #define ISampleGrabber_GetCurrentBuffer( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentBuffer( x, p1, p2 )
    #define ISampleGrabber_GetCurrentSample( x, p ) \
        (x)->lpVtbl->GetCurrentSample( x, p )
    #define ISampleGrabber_SetCallback( x, p1, p2 ) \
        (x)->lpVtbl->SetCallback( x, p1, p2 )
    #define IResize_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IResize_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IResize_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IResize_get_Size( x, p1, p2, p3 ) \
        (x)->lpVtbl->get_Size( x, p1, p2, p3 )
    #define IResize_get_InputSize( x, p1, p2 ) \
        (x)->lpVtbl->get_InputSize( x, p1, p2 )
    #define IResize_put_Size( x, p1, p2, p3 ) \
        (x)->lpVtbl->put_Size( x, p1, p2, p3 )
    #define IResize_get_MediaType( x, p ) \
        (x)->lpVtbl->get_MediaType( x, p )
    #define IResize_put_MediaType( x, p ) \
        (x)->lpVtbl->put_MediaType( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID      __cdecl IID_IPropertySetter;
EXTERN_C const IID      __cdecl IID_IDxtCompositor;
EXTERN_C const IID      __cdecl IID_IDxtAlphaSetter;
EXTERN_C const IID      __cdecl IID_IDxtJpeg;
EXTERN_C const IID      __cdecl IID_IDxtKey;
EXTERN_C const IID      __cdecl IID_IMediaLocator;
EXTERN_C const IID      __cdecl IID_IMediaDet;
EXTERN_C const IID      __cdecl IID_IGrfCache;
EXTERN_C const IID      __cdecl IID_IRenderEngine;
EXTERN_C const IID      __cdecl IID_IRenderEngine2;
EXTERN_C const IID      __cdecl IID_IFindCompressorCB;
EXTERN_C const IID      __cdecl IID_ISmartRenderEngine;
EXTERN_C const IID      __cdecl IID_IAMTimelineObj;
EXTERN_C const IID      __cdecl IID_IAMTimelineEffectable;
EXTERN_C const IID      __cdecl IID_IAMTimelineEffect;
EXTERN_C const IID      __cdecl IID_IAMTimelineTransable;
EXTERN_C const IID      __cdecl IID_IAMTimelineSplittable;
EXTERN_C const IID      __cdecl IID_IAMTimelineTrans;
EXTERN_C const IID      __cdecl IID_IAMTimelineSrc;
EXTERN_C const IID      __cdecl IID_IAMTimelineTrack;
EXTERN_C const IID      __cdecl IID_IAMTimelineVirtualTrack;
EXTERN_C const IID      __cdecl IID_IAMTimelineComp;
EXTERN_C const IID      __cdecl IID_IAMTimelineGroup;
EXTERN_C const IID      __cdecl IID_IAMTimeline;
EXTERN_C const IID      __cdecl IID_IXml2Dex;
EXTERN_C const IID      __cdecl IID_IAMErrorLog;
EXTERN_C const IID      __cdecl IID_IAMSetErrorLog;
EXTERN_C const IID      __cdecl IID_ISampleGrabberCB;
EXTERN_C const IID      __cdecl IID_ISampleGrabber;
EXTERN_C const IID      __cdecl LIBID_DexterLib;
EXTERN_C const IID      __cdecl IID_IResize;
EXTERN_C const CLSID    __cdecl CLSID_AMTimeline;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineObj;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineSrc;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineTrack;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineComp;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineGroup;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineTrans;
EXTERN_C const CLSID    __cdecl CLSID_AMTimelineEffect;
EXTERN_C const CLSID    __cdecl CLSID_RenderEngine;
EXTERN_C const CLSID    __cdecl CLSID_SmartRenderEngine;
EXTERN_C const CLSID    __cdecl CLSID_AudMixer;
EXTERN_C const CLSID    __cdecl CLSID_Xml2Dex;
EXTERN_C const CLSID    __cdecl CLSID_MediaLocator;
EXTERN_C const CLSID    __cdecl CLSID_PropertySetter;
EXTERN_C const CLSID    __cdecl CLSID_MediaDet;
EXTERN_C const CLSID    __cdecl CLSID_SampleGrabber;
EXTERN_C const CLSID    __cdecl CLSID_NullRenderer;
EXTERN_C const CLSID    __cdecl CLSID_DxtCompositor;
EXTERN_C const CLSID    __cdecl CLSID_DxtAlphaSetter;
EXTERN_C const CLSID    __cdecl CLSID_DxtJpeg;
EXTERN_C const CLSID    __cdecl CLSID_ColorSource;
EXTERN_C const CLSID    __cdecl CLSID_DxtKey;

#endif /* __qedit_h__ */
