/*
 *  richole.h   Rich edit OLE interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _RICHOLE_
#define _RICHOLE_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Rich edit object interface flags */
#define REO_GETOBJ_NO_INTERFACES    0x00000000L
#define REO_GETOBJ_POLEOBJ          0x00000001L
#define REO_GETOBJ_PSTG             0x00000002L
#define REO_GETOBJ_POLESITE         0x00000004L
#define REO_GETOBJ_ALL_INTERFACES   0x00000007L

/* Rich edit object special values */
#define REO_CP_SELECTION    0xFFFFFFFFL
#define REO_IOB_SELECTION   0xFFFFFFFFL
#define REO_IOB_USE_CP      0xFFFFFFFEL

/* Rich edit object flags */
#define REO_NULL            0x00000000L
#define REO_READWRITEMASK   0x0000003FL
#define REO_DONTNEEDPALETTE 0x00000020L
#define REO_BLANK           0x00000010L
#define REO_DYNAMICSIZE     0x00000008L
#define REO_INVERTEDSELECT  0x00000004L
#define REO_BELOWBASELINE   0x00000002L
#define REO_RESIZABLE       0x00000001L
#define REO_LINK            0x80000000L
#define REO_STATIC          0x40000000L
#define REO_SELECTED        0x08000000L
#define REO_OPEN            0x04000000L
#define REO_INPLACEACTIVE   0x02000000L
#define REO_HILITED         0x01000000L
#define REO_LINKAVAILABLE   0x00800000L
#define REO_GETMETAFILE     0x00400000L

/* Rich edit clipboard options */
#define RECO_PASTE  0x00000000L
#define RECO_DROP   0x00000001L
#define RECO_COPY   0x00000002L
#define RECO_CUT    0x00000003L
#define RECO_DRAG   0x00000004L

/* Rich edit object */
typedef struct _reobject {
    DWORD           cbStruct;
    LONG            cp;
    CLSID           clsid;
    LPOLEOBJECT     poleobj;
    LPSTORAGE       pstg;
    LPOLECLIENTSITE polesite;
    SIZEL           sizel;
    DWORD           dvaspect;
    DWORD           dwFlags;
    DWORD           dwUser;
} REOBJECT;

/* IRichEditOle interface */
#undef INTERFACE
#define INTERFACE   IRichEditOle
DECLARE_INTERFACE_( IRichEditOle, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IRichEditOle methods */
    STDMETHOD( GetClientSite )( THIS_ LPOLECLIENTSITE * ) PURE;
    STDMETHOD_( LONG, GetObjectCount )( THIS ) PURE;
    STDMETHOD_( LONG, GetLinkCount )( THIS ) PURE;
    STDMETHOD( GetObject )( THIS_ LONG, REOBJECT *, DWORD ) PURE;
    STDMETHOD( InsertObject )( THIS_ REOBJECT * ) PURE;
    STDMETHOD( ConvertObject )( THIS_ LONG, REFCLSID, LPCSTR ) PURE;
    STDMETHOD( ActivateAs )( THIS_ REFCLSID, REFCLSID ) PURE;
    STDMETHOD( SetHostNames )( THIS_ LPCSTR, LPCSTR ) PURE;
    STDMETHOD( SetLinkAvailable )( THIS_ LONG, BOOL ) PURE;
    STDMETHOD( SetDvaspect )( THIS_ LONG, DWORD ) PURE;
    STDMETHOD( HandsOffStorage )( THIS_ LONG ) PURE;
    STDMETHOD( SaveCompleted )( THIS_ LONG, LPSTORAGE ) PURE;
    STDMETHOD( InPlaceDeactivate )( THIS ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    STDMETHOD( GetClipboardData )( THIS_ CHARRANGE *, DWORD, LPDATAOBJECT * ) PURE;
    STDMETHOD( ImportDataObject )( THIS_ LPDATAOBJECT, CLIPFORMAT, HGLOBAL ) PURE;
};
typedef IRichEditOle    *LPRICHEDITOLE;

/* IRichEditOleCallback interface */
#undef INTERFACE
#define INTERFACE   IRichEditOleCallback
DECLARE_INTERFACE_( IRichEditOleCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IRichEditOleCallback methods */
    STDMETHOD( GetNewStorage )( THIS_ LPSTORAGE * ) PURE;
    STDMETHOD( GetInPlaceContext )( THIS_ LPOLEINPLACEFRAME *, LPOLEINPLACEUIWINDOW *, LPOLEINPLACEFRAMEINFO ) PURE;
    STDMETHOD( ShowContainerUI )( THIS_ BOOL ) PURE;
    STDMETHOD( QueryInsertObject )( THIS_ LPCLSID, LPSTORAGE, LONG ) PURE;
    STDMETHOD( DeleteObject )( THIS_ LPOLEOBJECT ) PURE;
    STDMETHOD( QueryAcceptData )( THIS_ LPDATAOBJECT, CLIPFORMAT *, DWORD, BOOL, HGLOBAL ) PURE;
    STDMETHOD( ContextSensitiveHelp )( THIS_ BOOL ) PURE;
    STDMETHOD( GetClipboardData )( THIS_ CHARRANGE *, DWORD, LPDATAOBJECT * ) PURE;
    STDMETHOD( GetDragDropEffect )( THIS_ BOOL, DWORD, LPDWORD ) PURE;
    STDMETHOD( GetContextMenu )( THIS_ WORD, LPOLEOBJECT, CHARRANGE *, HMENU * ) PURE;
};
typedef IRichEditOleCallback    *LPRICHEDITOLECALLBACK;

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_IRichEditOle;
EXTERN_C const IID  __cdecl IID_IRichEditOleCallback;

#endif /* _RICHOLE_ */
