/*
 *  usp10.mh    Uniscribe functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __usp10__
#define __usp10__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Uniscribe OpenType version number */
#ifndef UNISCRIBE_OPENTYPE
    #if (_WIN32_WINNT >= 0x0600)
        #define UNISCRIBE_OPENTYPE  0x0100
    #endif
#endif

/* Uniscribe primitive data types */
typedef void    *SCRIPT_CACHE;
typedef void    *SCRIPT_STRING_ANALYSIS;
#if (UNISCRIBE_OPENTYPE >= 0x0100)
typedef ULONG   OPENTYPE_TAG;
#endif

/* Script special value */
#define SCRIPT_UNDEFINED    0

/* Uniscribe error codes */
#define USP_E_SCRIPT_NOT_IN_FONT    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_ITF, 0x0200 )

/* ScriptGetCMap() flags */
#define SGCM_RTL    0x00000001L

/* ScriptStringAnalyse() flags */
#define SSA_PASSWORD        0x00000001L
#define SSA_TAB             0x00000002L
#define SSA_CLIP            0x00000004L
#define SSA_FIT             0x00000008L
#define SSA_DZWG            0x00000010L
#define SSA_FALLBACK        0x00000020L
#define SSA_BREAK           0x00000040L
#define SSA_GLYPHS          0x00000080L
#define SSA_RTL             0x00000100L
#define SSA_GCP             0x00000200L
#define SSA_HOTKEY          0x00000400L
#define SSA_METAFILE        0x00000800L
#define SSA_LINK            0x00001000L
#define SSA_HIDEHOTKEY      0x00002000L
#define SSA_HOTKEYONLY      0x00002400L
#define SSA_FULLMEASURE     0x04000000L
#define SSA_LPKANSIFALLBACK 0x08000000L
#define SSA_PIDX            0x10000000L
#define SSA_LAYOUTRTL       0x20000000L
#define SSA_DONTGLYPH       0x40000000L
#define SSA_NOKASHIDA       0x80000000L

/* ScriptIsComplex() flags */
#define SIC_COMPLEX     0x00000001L
#define SIC_ASCIIDIGIT  0x00000002L
#define SIC_NEUTRAL     0x00000004L

/* Script digit substitute special values */
#define SCRIPT_DIGITSUBSTITUTE_CONTEXT      0
#define SCRIPT_DIGITSUBSTITUTE_NONE         1
#define SCRIPT_DIGITSUBSTITUTE_NATIONAL     2
#define SCRIPT_DIGITSUBSTITUTE_TRADITIONAL  3

/* OpenType tag special value */
#if (UNISCRIBE_OPENTYPE >= 0x0100)
    #define SCRIPT_TAG_UNKNOWN  0x00000000L
#endif

/* Script control */
typedef struct tag_SCRIPT_CONTROL {
    DWORD   uDefaultLanguage    : 16;
    DWORD   fContextDigits      : 1;
    DWORD   fInvertPreBoundDir  : 1;
    DWORD   fInvertPostBoundDir : 1;
    DWORD   fLinkStringBefore   : 1;
    DWORD   fLinkStringAfter    : 1;
    DWORD   fNeutralOverride    : 1;
    DWORD   fNumericOverride    : 1;
    DWORD   fLegacyBidiClass    : 1;
    DWORD   fMergeNeutralItems  : 1;
    DWORD   fReserved           : 7;
} SCRIPT_CONTROL;

/* Script state */
typedef struct tag_SCRIPT_STATE {
    WORD    uBidiLevel          : 5;
    WORD    fOverrideDirection  : 1;
    WORD    fInhibitSymSwap     : 1;
    WORD    fCharShape          : 1;
    WORD    fDigitSubstitute    : 1;
    WORD    fInhibitLigate      : 1;
    WORD    fDisplayZWG         : 1;
    WORD    fArabicNumContext   : 1;
    WORD    fGcpClusters        : 1;
    WORD    fReserved           : 1;
    WORD    fEngineReserved     : 2;
} SCRIPT_STATE;

/* Script analysis */
typedef struct tag_SCRIPT_ANALYSIS {
    WORD            eScript         : 10;
    WORD            fRTL            : 1;
    WORD            fLayoutRTL      : 1;
    WORD            fLinkBefore     : 1;
    WORD            fLinkAfter      : 1;
    WORD            fLogicalOrder   : 1;
    WORD            fNoGlyphIndex   : 1;
    SCRIPT_STATE    s;
} SCRIPT_ANALYSIS;

/* Script item */
typedef struct tag_SCRIPT_ITEM {
    int             iCharPos;
    SCRIPT_ANALYSIS a;
} SCRIPT_ITEM;

/* Script justification values */
typedef enum tag_SCRIPT_JUSTIFY {
    SCRIPT_JUSTIFY_NONE             = 0,
    SCRIPT_JUSTIFY_ARABIC_BLACK     = 1,
    SCRIPT_JUSTIFY_CHARACTER        = 2,
    SCRIPT_JUSTIFY_BLANK            = 4,
    SCRIPT_JUSTIFY_ARABIC_NORMAL    = 7,
    SCRIPT_JUSTIFY_ARABIC_KASHIDA   = 8,
    SCRIPT_JUSTIFY_ARABIC_ALEF      = 9,
    SCRIPT_JUSTIFY_ARABIC_HA        = 10,
    SCRIPT_JUSTIFY_ARABIC_RA        = 11,
    SCRIPT_JUSTIFY_ARABIC_BA        = 12,
    SCRIPT_JUSTIFY_ARABIC_BARA      = 13,
    SCRIPT_JUSTIFY_ARABIC_SEEN      = 14,
    SCRIPT_JUSTIFY_ARABIC_SEEN_M    = 15
} SCRIPT_JUSTIFY;

/* Script visual attribute */
typedef struct tag_SCRIPT_VISATTR {
    WORD    uJustification  : 4;
    WORD    fClusterStart   : 1;
    WORD    fDiacritic      : 1;
    WORD    fZeroWidth      : 1;
    WORD    fReserved       : 1;
    WORD    fShapeReserved  : 8;
} SCRIPT_VISATTR;

/* Glyph offset */
typedef struct tagGOFFSET {
    LONG    du;
    LONG    dv;
} GOFFSET;

/* Script logical attribute */
typedef struct tag_SCRIPT_LOGATTR {
    BYTE    fSoftBreak  : 1;
    BYTE    fWhiteSpace : 1;
    BYTE    fCharStop   : 1;
    BYTE    fWordStop   : 1;
    BYTE    fInvalid    : 1;
    BYTE    fReserved   : 3;
} SCRIPT_LOGATTR;

/* Script properties */
typedef struct {
    DWORD   langid                  : 16;
    DWORD   fNumeric                : 1;
    DWORD   fComplex                : 1;
    DWORD   fNeedsWordBreaking      : 1;
    DWORD   fNeedsCaretInfo         : 1;
    DWORD   bCharSet                : 8;
    DWORD   fControl                : 1;
    DWORD   fPrivateUseArea         : 1;
    DWORD   fNeedsCharacterJustify  : 1;
    DWORD   fInvalidGlyph           : 1;
    DWORD   fInvalidLogAttr         : 1;
    DWORD   fCDM                    : 1;
    DWORD   fAmbiguousCharSet       : 1;
    DWORD   fClusterSizeVaries      : 1;
    DWORD   fRejectInvalid          : 1;
} SCRIPT_PROPERTIES;

/* Script font properties */
typedef struct {
    int     cBytes;
    WORD    wgBlank;
    WORD    wgDefault;
    WORD    wgInvalid;
    WORD    wgKashida;
    int     iKashidaWidth;
} SCRIPT_FONTPROPERTIES;

/* Script tab definition */
typedef struct tag_SCRIPT_TABDEF {
    int cTabStops;
    int iScale;
    int *pTabStops;
    int iTabOrigin;
} SCRIPT_TABDEF;

/* Script digit substitution */
typedef struct tag_SCRIPT_DIGITSUBSTITUTE {
    DWORD   NationalDigitLanguage       : 16;
    DWORD   TraditionalDigitLanguage    : 16;
    DWORD   DigitSubstitute             : 8;
    DWORD   dwReserved;
} SCRIPT_DIGITSUBSTITUTE;

/* OpenType feature record */
#if (UNISCRIBE_OPENTYPE >= 0x0100)
typedef struct opentype_feature_record {
    OPENTYPE_TAG    tagFeature;
    LONG            lParameter;
} OPENTYPE_FEATURE_RECORD;
#endif

/* Text range properties */
#if (UNISCRIBE_OPENTYPE >= 0x0100)
typedef struct textrange_properties {
    OPENTYPE_FEATURE_RECORD *potfRecords;
    int                     cotfRecords;
} TEXTRANGE_PROPERTIES;
#endif

/* Script character properties */
#if (UNISCRIBE_OPENTYPE >= 0x0100)
typedef struct script_charprop {
    WORD    fCanGlyphAlone  : 1;
    WORD    reserved        : 15;
} SCRIPT_CHARPROP;
#endif

/* Script glyph properties */
#if (UNISCRIBE_OPENTYPE >= 0x0100)
typedef struct script_glyphprop {
    SCRIPT_VISATTR  sva;
    WORD            reserved;
} SCRIPT_GLYPHPROP;
#endif

/* Functions in USP10.DLL */
HRESULT WINAPI      ScriptApplyDigitSubstitution( const SCRIPT_DIGITSUBSTITUTE *, SCRIPT_CONTROL *, SCRIPT_STATE * );
HRESULT WINAPI      ScriptApplyLogicalWidth( const int *, int, int, const WORD *, const SCRIPT_VISATTR *, const int *, const SCRIPT_ANALYSIS *, ABC *, int * );
HRESULT WINAPI      ScriptBreak( const WCHAR *, int, const SCRIPT_ANALYSIS *, SCRIPT_LOGATTR * );
HRESULT WINAPI      ScriptCPtoX( int, BOOL, int, int, const WORD *, const SCRIPT_VISATTR *, const int *, const SCRIPT_ANALYSIS *, int * );
HRESULT WINAPI      ScriptCacheGetHeight( HDC, SCRIPT_CACHE *, long * );
HRESULT WINAPI      ScriptFreeCache( SCRIPT_CACHE * );
HRESULT WINAPI      ScriptGetCMap( HDC, SCRIPT_CACHE *, const WCHAR *, int, DWORD, WORD * );
HRESULT WINAPI      ScriptGetFontProperties( HDC, SCRIPT_CACHE *, SCRIPT_FONTPROPERTIES * );
HRESULT WINAPI      ScriptGetGlyphABCWidth( HDC, SCRIPT_CACHE *, WORD, ABC * );
HRESULT WINAPI      ScriptGetLogicalWidths( const SCRIPT_ANALYSIS *, int, int, const int *, const WORD *, const SCRIPT_VISATTR *, int * );
HRESULT WINAPI      ScriptGetProperties( const SCRIPT_PROPERTIES **, int * );
HRESULT WINAPI      ScriptIsComplex( const WCHAR *, int, DWORD );
HRESULT WINAPI      ScriptItemize( const WCHAR *, int, int, const SCRIPT_CONTROL *, const SCRIPT_STATE *, SCRIPT_ITEM *, int * );
HRESULT WINAPI      ScriptJustify( const SCRIPT_VISATTR *, const int *, int, int, int, int * );
HRESULT WINAPI      ScriptLayout( int, const BYTE *, int *, int * );
HRESULT WINAPI      ScriptPlace( HDC, SCRIPT_CACHE *, const WORD *, int, const SCRIPT_VISATTR *, SCRIPT_ANALYSIS *, int *, GOFFSET *, ABC * );
HRESULT WINAPI      ScriptRecordDigitSubstitution( LCID, SCRIPT_DIGITSUBSTITUTE * );
HRESULT WINAPI      ScriptShape( HDC, SCRIPT_CACHE *, const WCHAR *, int, int, SCRIPT_ANALYSIS *, WORD *, WORD *, SCRIPT_VISATTR *, int * );
HRESULT WINAPI      ScriptStringAnalyse( HDC, const void *, int, int, int, DWORD, int, SCRIPT_CONTROL *, SCRIPT_STATE *, const int *, SCRIPT_TABDEF *, const BYTE *, SCRIPT_STRING_ANALYSIS * );
HRESULT WINAPI      ScriptStringCPtoX( SCRIPT_STRING_ANALYSIS, int, BOOL, int * );
HRESULT WINAPI      ScriptStringFree( SCRIPT_STRING_ANALYSIS * );
HRESULT WINAPI      ScriptStringGetLogicalWidths( SCRIPT_STRING_ANALYSIS, int * );
HRESULT WINAPI      ScriptStringGetOrder( SCRIPT_STRING_ANALYSIS, UINT * );
HRESULT WINAPI      ScriptStringOut( SCRIPT_STRING_ANALYSIS, int, int, UINT, const RECT *, int, int, BOOL );
HRESULT WINAPI      ScriptStringValidate( SCRIPT_STRING_ANALYSIS );
HRESULT WINAPI      ScriptStringXtoCP( SCRIPT_STRING_ANALYSIS, int, int *, int * );
const SCRIPT_LOGATTR * WINAPI   ScriptString_pLogAttr( SCRIPT_STRING_ANALYSIS );
const SIZE * WINAPI ScriptString_pSize( SCRIPT_STRING_ANALYSIS );
const int * WINAPI  ScriptString_pcOutChars( SCRIPT_STRING_ANALYSIS );
HRESULT WINAPI      ScriptTextOut( HDC, SCRIPT_CACHE *, int, int, UINT, const RECT *, const SCRIPT_ANALYSIS *, const WCHAR *, int, const WORD *, int, const int *, const int *, const GOFFSET * );
HRESULT WINAPI      ScriptXtoCP( int, int, int, const WORD *, const SCRIPT_VISATTR *, const int *, const SCRIPT_ANALYSIS *, int *, int * );
#if (UNISCRIBE_OPENTYPE >= 0x0100)
HRESULT WINAPI      ScriptGetFontAlternateGlyphs( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, OPENTYPE_TAG, WORD, int, WORD *, int * );
HRESULT WINAPI      ScriptGetFontFeatureTags( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, int, OPENTYPE_TAG *, int * );
HRESULT WINAPI      ScriptGetFontLanguageTags( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, int, OPENTYPE_TAG *, int * );
HRESULT WINAPI      ScriptGetFontScriptTags( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, int, OPENTYPE_TAG *, int * );
HRESULT WINAPI      ScriptItemizeOpenType( const WCHAR *, int, int, const SCRIPT_CONTROL *, const SCRIPT_STATE *, SCRIPT_ITEM *, OPENTYPE_TAG *, int * );
HRESULT WINAPI      ScriptPlaceOpenType( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, int *, TEXTRANGE_PROPERTIES **, int, const WCHAR *, WORD *, SCRIPT_CHARPROP *, int, const WORD *, const SCRIPT_GLYPHPROP *, int, int *, GOFFSET *, ABC * );
HRESULT WINAPI      ScriptPositionSingleGlyph( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, OPENTYPE_TAG, LONG, WORD, int, GOFFSET, int *, GOFFSET * );
HRESULT WINAPI      ScriptShapeOpenType( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, int *, TEXTRANGE_PROPERTIES **, int, const WCHAR *, int, int, WORD *, SCRIPT_CHARPROP *, WORD *, SCRIPT_GLYPHPROP *, int * );
HRESULT WINAPI      ScriptSubstituteSingleGlyph( HDC, SCRIPT_CACHE *, SCRIPT_ANALYSIS *, OPENTYPE_TAG, OPENTYPE_TAG, OPENTYPE_TAG, LONG, WORD, WORD * );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __usp10__ */
