/*
 *  winbase.h   Win32 base functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINBASE_
#define _WINBASE_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <winerror.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify kernel and advanced functions */
#define WINBASEAPI  DECLSPEC_IMPORT
#define WINADVAPI   DECLSPEC_IMPORT

/* Macro to define an atom identifier */
#define MAKEINTATOM( x )    ((LPTSTR)(ULONG_PTR)(WORD)(x))

/* Invalid return values */
#define INVALID_HANDLE_VALUE        ((HANDLE)(LONG_PTR)-1)
#define INVALID_FILE_SIZE           0xFFFFFFFFL
#define INVALID_SET_FILE_POINTER    0xFFFFFFFFL
#define INVALID_FILE_ATTRIBUTES     0xFFFFFFFFL

/* SetFilePointer() options */
#define FILE_BEGIN      0L
#define FILE_CURRENT    1L
#define FILE_END        2L

/* Invalid time zone identifier */
#define TIME_ZONE_ID_INVALID    0xFFFFFFFFL

/* Return values for wait functions */
#define WAIT_FAILED         0xFFFFFFFFL
#define WAIT_OBJECT_0       STATUS_WAIT_0
#define WAIT_ABANDONED      STATUS_ABANDONED_WAIT_0
#define WAIT_ABANDONED_0    STATUS_ABANDONED_WAIT_0
#define WAIT_IO_COMPLETION  STATUS_USER_APC

/* Return value for GetExitCodeProcess() and GetExitCodeThread() */
#define STILL_ACTIVE    STATUS_PENDING

/* Exception codes */
#define EXCEPTION_ACCESS_VIOLATION          STATUS_ACCESS_VIOLATION
#define EXCEPTION_DATATYPE_MISALIGNMENT     STATUS_DATATYPE_MISALIGNMENT
#define EXCEPTION_BREAKPOINT                STATUS_BREAKPOINT
#define EXCEPTION_SINGLE_STEP               STATUS_SINGLE_STEP
#define EXCEPTION_ARRAY_BOUNDS_EXCEEDED     STATUS_ARRAY_BOUNDS_EXCEEDED
#define EXCEPTION_FLT_DENORMAL_OPERAND      STATUS_FLOAT_DENORMAL_OPERAND
#define EXCEPTION_FLT_DIVIDE_BY_ZERO        STATUS_FLOAT_DIVIDE_BY_ZERO
#define EXCEPTION_FLT_INEXACT_RESULT        STATUS_FLOAT_INEXACT_RESULT
#define EXCEPTION_FLT_INVALID_OPERATION     STATUS_FLOAT_INVALID_OPERATION
#define EXCEPTION_FLT_OVERFLOW              STATUS_FLOAT_OVERFLOW
#define EXCEPTION_FLT_STACK_CHECK           STATUS_FLOAT_STACK_CHECK
#define EXCEPTION_FLT_UNDERFLOW             STATUS_FLOAT_UNDERFLOW
#define EXCEPTION_INT_DIVIDE_BY_ZERO        STATUS_INTEGER_DIVIDE_BY_ZERO
#define EXCEPTION_INT_OVERFLOW              STATUS_INTEGER_OVERFLOW
#define EXCEPTION_PRIV_INSTRUCTION          STATUS_PRIVILEGED_INSTRUCTION
#define EXCEPTION_IN_PAGE_ERROR             STATUS_IN_PAGE_ERROR
#define EXCEPTION_ILLEGAL_INSTRUCTION       STATUS_ILLEGAL_INSTRUCTION
#define EXCEPTION_NONCONTINUABLE_EXCEPTION  STATUS_NONCONTINUABLE_EXCEPTION
#define EXCEPTION_STACK_OVERFLOW            STATUS_STACK_OVERFLOW
#define EXCEPTION_INVALID_DISPOSITION       STATUS_INVALID_DISPOSITION
#define EXCEPTION_GUARD_PAGE                STATUS_GUARD_PAGE_VIOLATION
#define EXCEPTION_INVALID_HANDLE            STATUS_INVALID_HANDLE

/* CTRL+C exit value */
#define CONTROL_C_EXIT                      STATUS_CONTROL_C_EXIT

/* File flags */
#define FILE_FLAG_WRITE_THROUGH         0x80000000L
#define FILE_FLAG_OVERLAPPED            0x40000000L
#define FILE_FLAG_NO_BUFFERING          0x20000000L
#define FILE_FLAG_RANDOM_ACCESS         0x10000000L
#define FILE_FLAG_SEQUENTIAL_SCAN       0x08000000L
#define FILE_FLAG_DELETE_ON_CLOSE       0x04000000L
#define FILE_FLAG_BACKUP_SEMANTICS      0x02000000L
#define FILE_FLAG_POSIX_SEMANTICS       0x01000000L
#define FILE_FLAG_OPEN_REPARSE_POINT    0x00200000L
#define FILE_FLAG_OPEN_NO_RECALL        0x00100000L
#define FILE_FLAG_FIRST_PIPE_INSTANCE   0x00080000L

/* File creation disposition */
#define CREATE_NEW          1L
#define CREATE_ALWAYS       2L
#define OPEN_EXISTING       3L
#define OPEN_ALWAYS         4L
#define TRUNCATE_EXISTING   5L

/* CopyFileEx() callback return codes */
#if (_WIN32_WINNT >= 0x0400)
    #define PROGRESS_CONTINUE   0L
    #define PROGRESS_CANCEL     1L
    #define PROGRESS_STOP       2L
    #define PROGRESS_QUIET      3L
#endif

/* CopyFileEx() callback flags */
#if (_WIN32_WINNT >= 0x0400)
    #define CALLBACK_CHUNK_FINISHED 0x00000000L
    #define CALLBACK_STREAM_SWITCH  0x00000001L
#endif

/* CopyFileEx() flags */
#if (_WIN32_WINNT >= 0x0400)
    #define COPY_FILE_FAIL_IF_EXISTS                0x00000001L
    #define COPY_FILE_RESTARTABLE                   0x00000002L
    #define COPY_FILE_OPEN_SOURCE_FOR_WRITE         0x00000004L
    #define COPY_FILE_ALLOW_DECRYPTED_DESTINATION   0x00000008L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define COPY_FILE_COPY_SYMLINK                  0x00000800L
    #define COPY_FILE_NO_BUFFERING                  0x00001000L
#endif

/* ReplaceFile() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define REPLACEFILE_WRITE_THROUGH       0x00000001L
    #define REPLACEFILE_IGNORE_MERGE_ERRORS 0x00000002L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define REPLACEFILE_IGNORE_ACL_ERRORS   0x00000004L
#endif

/* Named pipe open modes */
#define PIPE_ACCESS_INBOUND     0x00000001L
#define PIPE_ACCESS_OUTBOUND    0x00000002L
#define PIPE_ACCESS_DUPLEX      0x00000003L

/* Named pipe end flags */
#define PIPE_CLIENT_END 0x00000000L
#define PIPE_SERVER_END 0x00000001L

/* Named pipe modes */
#define PIPE_WAIT                   0x00000000L
#define PIPE_NOWAIT                 0x00000001L
#define PIPE_READMODE_BYTE          0x00000000L
#define PIPE_READMODE_MESSAGE       0x00000002L
#define PIPE_TYPE_BYTE              0x00000000L
#define PIPE_TYPE_MESSAGE           0x00000004L
#define PIPE_ACCEPT_REMOTE_CLIENTS  0x00000000L
#define PIPE_REJECT_REMOTE_CLIENTS  0x00000008L

/* Special maximum instance values for CreateNamedPipe() */
#define PIPE_UNLIMITED_INSTANCES    255

/* Security quality of service flags for CreateFile() */
#define SECURITY_ANONYMOUS          (SecurityAnonymous << 16)
#define SECURITY_IDENTIFICATION     (SecurityIdentification << 16)
#define SECURITY_IMPERSONATION      (SecurityImpersonation << 16)
#define SECURITY_DELEGATION         (SecurityDelegation << 16)
#define SECURITY_CONTEXT_TRACKING   0x00040000L
#define SECURITY_EFFECTIVE_ONLY     0x00080000L
#define SECURITY_SQOS_PRESENT       0x00100000L
#define SECURITY_VALID_SQOS_FLAGS   0x001F0000L

#if (_WIN32_WINNT >= 0x0600)
/* Run once flags */
#define INIT_ONCE_CHECK_ONLY        RTL_RUN_ONCE_CHECK_ONLY
#define INIT_ONCE_ASYNC             RTL_RUN_ONCE_ASYNC
#define INIT_ONCE_INIT_FAILED       RTL_RUN_ONCE_INIT_FAILED

/* Run once Static initializer */
#define INIT_ONCE_STATIC_INIT       RTL_RUN_ONCE_INIT

#define INIT_ONCE_CTX_RESERVED_BITS RTL_RUN_ONCE_CTX_RESERVED_BITS
#endif

/* RaiseFailFastException() flags */
#define FAIL_FAST_GENERATE_EXCEPTION_ADDRESS    0x00000001L
#define FAIL_FAST_NO_HARD_ERROR_DLG             0x00000002L

/* Slim reader/writer Static initializer */
#define SRWLOCK_INIT                RTL_SRWLOCK_INIT

/* Condition variable flags */
#define CONDITION_VARIABLE_LOCKMODE_SHARED  RTL_CONDITION_VARIABLE_LOCKMODE_SHARED

/* Condition variable Static initializer */
#define CONDITION_VARIABLE_INIT     RTL_CONDITION_VARIABLE_INIT

/* Mutex access rights */
#define MUTEX_MODIFY_STATE  MUTANT_QUERY_STATE
#define MUTEX_ALL_ACCESS    MUTANT_ALL_ACCESS

/* Communications provider type */
#define SP_SERIALCOMM   0x00000001L

/* Communications provider subtypes */
#define PST_UNSPECIFIED     0x00000000L
#define PST_RS232           0x00000001L
#define PST_PARALLELPORT    0x00000002L
#define PST_RS422           0x00000003L
#define PST_RS423           0x00000004L
#define PST_RS449           0x00000005L
#define PST_MODEM           0x00000006L
#define PST_FAX             0x00000021L
#define PST_SCANNER         0x00000022L
#define PST_NETWORK_BRIDGE  0x00000100L
#define PST_LAT             0x00000101L
#define PST_TCPIP_TELNET    0x00000102L
#define PST_X25             0x00000103L

/* Communications provider capabilities flags */
#define PCF_DTRDSR          0x00000001L
#define PCF_RTSCTS          0x00000002L
#define PCF_RLSD            0x00000004L
#define PCF_PARITY_CHECK    0x00000008L
#define PCF_XONXOFF         0x00000010L
#define PCF_SETXCHAR        0x00000020L
#define PCF_TOTALTIMEOUTS   0x00000040L
#define PCF_INTTIMEOUTS     0x00000080L
#define PCF_SPECIALCHARS    0x00000100L
#define PCF_16BITMODE       0x00000200L

/* Communications settable parameters */
#define SP_PARITY       0x00000001L
#define SP_BAUD         0x00000002L
#define SP_DATABITS     0x00000004L
#define SP_STOPBITS     0x00000008L
#define SP_HANDSHAKING  0x00000010L
#define SP_PARITY_CHECK 0x00000020L
#define SP_RLSD         0x00000040L

/* Communications baud rates */
#define BAUD_075    0x00000001L
#define BAUD_110    0x00000002L
#define BAUD_134_5  0x00000004L
#define BAUD_150    0x00000008L
#define BAUD_300    0x00000010L
#define BAUD_600    0x00000020L
#define BAUD_1200   0x00000040L
#define BAUD_1800   0x00000080L
#define BAUD_2400   0x00000100L
#define BAUD_4800   0x00000200L
#define BAUD_7200   0x00000400L
#define BAUD_9600   0x00000800L
#define BAUD_14400  0x00001000L
#define BAUD_19200  0x00002000L
#define BAUD_38400  0x00004000L
#define BAUD_56K    0x00008000L
#define BAUD_128K   0x00010000L
#define BAUD_115200 0x00020000L
#define BAUD_57600  0x00040000L
#define BAUD_USER   0x10000000L

/* Communications data bits */
#define DATABITS_5      0x0001
#define DATABITS_6      0x0002
#define DATABITS_7      0x0004
#define DATABITS_8      0x0008
#define DATABITS_16     0x0010
#define DATABITS_16X    0x0020

/* Stop bits and parity flags */
#define STOPBITS_10     0x0001
#define STOPBITS_15     0x0002
#define STOPBITS_20     0x0004
#define PARITY_NONE     0x0100
#define PARITY_ODD      0x0200
#define PARITY_EVEN     0x0400
#define PARITY_MARK     0x0800
#define PARITY_SPACE    0x1000

/* Special value used with COMMPROP */
#define COMMPROP_INITIALIZED 0xE73CF52EL

/* DTR control values */
#define DTR_CONTROL_DISABLE     0x00
#define DTR_CONTROL_ENABLE      0x01
#define DTR_CONTROL_HANDSHAKE   0x02

/* RTS control values */
#define RTS_CONTROL_DISABLE     0x00
#define RTS_CONTROL_ENABLE      0x01
#define RTS_CONTROL_HANDSHAKE   0x02
#define RTS_CONTROL_TOGGLE      0x03

/* Global memory flags */
#define GMEM_FIXED          0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7F72
#define GMEM_INVALID_HANDLE 0x8000
#define GHND                (GMEM_MOVEABLE | GMEM_ZEROINIT)
#define GPTR                (GMEM_FIXED | GMEM_ZEROINIT)

/* Flags used with GlobalFlags() */
#define GMEM_DISCARDED  0x4000
#define GMEM_LOCKCOUNT  0x00FF

/* Local memory flags */
#define LMEM_FIXED          0x0000
#define LMEM_MOVEABLE       0x0002
#define LMEM_NOCOMPACT      0x0010
#define LMEM_NODISCARD      0x0020
#define LMEM_ZEROINIT       0x0040
#define LMEM_MODIFY         0x0080
#define LMEM_DISCARDABLE    0x0F00
#define LMEM_VALID_FLAGS    0x0F72
#define LMEM_INVALID_HANDLE 0x8000
#define LHND                (LMEM_MOVEABLE | LMEM_ZEROINIT)
#define LPTR                (LMEM_FIXED | LMEM_ZEROINIT)
#define NONZEROLHND         (LMEM_MOVEABLE)
#define NONZEROLPTR         (LMEM_FIXED)

/* Flags used with LocalFlags() */
#define LMEM_DISCARDED  0x4000
#define LMEM_LOCKCOUNT  0x00FF

/* Numa special values */
#define NUMA_NO_PREFERRED_NODE  0xFFFFFFFFL

/* Process creation flags */
#define DEBUG_PROCESS                       0x00000001L
#define DEBUG_ONLY_THIS_PROCESS             0x00000002L
#define CREATE_SUSPENDED                    0x00000004L
#define DETACHED_PROCESS                    0x00000008L
#define CREATE_NEW_CONSOLE                  0x00000010L
#define NORMAL_PRIORITY_CLASS               0x00000020L
#define IDLE_PRIORITY_CLASS                 0x00000040L
#define HIGH_PRIORITY_CLASS                 0x00000080L
#define REALTIME_PRIORITY_CLASS             0x00000100L
#define CREATE_NEW_PROCESS_GROUP            0x00000200L
#define CREATE_UNICODE_ENVIRONMENT          0x00000400L
#define CREATE_SEPARATE_WOW_VDM             0x00000800L
#define CREATE_SHARED_WOW_VDM               0x00001000L
#define CREATE_FORCEDOS                     0x00002000L
#define BELOW_NORMAL_PRIORITY_CLASS         0x00004000L
#define ABOVE_NORMAL_PRIORITY_CLASS         0x00008000L
#define INHERIT_PARENT_AFFINITY             0x00010000L
#define INHERIT_CALLER_PRIORITY             0x00020000L
#define CREATE_PROTECTED_PROCESS            0x00040000L
#define EXTENDED_STARTUPINFO_PRESENT        0x00080000L
#define PROCESS_MODE_BACKGROUND_BEGIN       0x00100000L
#define PROCESS_MODE_BACKGROUND_END         0x00200000L
#define CREATE_BREAKAWAY_FROM_JOB           0x01000000L
#define CREATE_PRESERVE_CODE_AUTHZ_LEVEL    0x02000000L
#define CREATE_DEFAULT_ERROR_MODE           0x04000000L
#define CREATE_NO_WINDOW                    0x08000000L
#define PROFILE_USER                        0x10000000L
#define PROFILE_KERNEL                      0x20000000L
#define PROFILE_SERVER                      0x40000000L
#define CREATE_IGNORE_SYSTEM_DEFAULT        0x80000000L

/* Thread creation flags */
#define STACK_SIZE_PARAM_IS_A_RESERVATION   0x00010000L

/* Thread priority values */
#define THREAD_PRIORITY_LOWEST          THREAD_BASE_PRIORITY_MIN
#define THREAD_PRIORITY_BELOW_NORMAL    (THREAD_PRIORITY_LOWEST + 1)
#define THREAD_PRIORITY_NORMAL          0
#define THREAD_PRIORITY_HIGHEST         THREAD_BASE_PRIORITY_MAX
#define THREAD_PRIORITY_ABOVE_NORMAL    (THREAD_PRIORITY_HIGHEST - 1)
#define THREAD_PRIORITY_ERROR_RETURN    MAXLONG
#define THREAD_PRIORITY_TIME_CRITICAL   THREAD_BASE_PRIORITY_LOWRT
#define THREAD_PRIORITY_IDLE            THREAD_BASE_PRIORITY_IDLE

/* Thread modes */
#define THREAD_MODE_BACKGROUND_BEGIN    0x00010000L
#define THREAD_MODE_BACKGROUND_END      0x00020000L

/* GetFinalPathNameByHandle() flags */
#define VOLUME_NAME_DOS         0x00000000L
#define VOLUME_NAME_GUID        0x00000001L
#define VOLUME_NAME_NT          0x00000002L
#define VOLUME_NAME_NONE        0x00000004L
#define FILE_NAME_NORMALIZED    0x00000000L
#define FILE_NAME_OPENED        0x00000008L

/* Debug event types */
#define EXCEPTION_DEBUG_EVENT       1L
#define CREATE_THREAD_DEBUG_EVENT   2L
#define CREATE_PROCESS_DEBUG_EVENT  3L
#define EXIT_THREAD_DEBUG_EVENT     4L
#define EXIT_PROCESS_DEBUG_EVENT    5L
#define LOAD_DLL_DEBUG_EVENT        6L
#define UNLOAD_DLL_DEBUG_EVENT      7L
#define OUTPUT_DEBUG_STRING_EVENT   8L
#define RIP_EVENT                   9L

/* Drive types */
#define DRIVE_UNKNOWN       0
#define DRIVE_NO_ROOT_DIR   1
#define DRIVE_REMOVABLE     2
#define DRIVE_FIXED         3
#define DRIVE_REMOTE        4
#define DRIVE_CDROM         5
#define DRIVE_RAMDISK       6

/* File types */
#define FILE_TYPE_UNKNOWN   0x00000000L
#define FILE_TYPE_DISK      0x00000001L
#define FILE_TYPE_CHAR      0x00000002L
#define FILE_TYPE_PIPE      0x00000003L
#define FILE_TYPE_REMOTE    0x00008000L

/* Standard handles */
#define STD_INPUT_HANDLE    ((DWORD)-10)
#define STD_OUTPUT_HANDLE   ((DWORD)-11)
#define STD_ERROR_HANDLE    ((DWORD)-12)

/* Communications parity values */
#define NOPARITY    0
#define ODDPARITY   1
#define EVENPARITY  2
#define MARKPARITY  3
#define SPACEPARITY 4

/* Communications stop bits */
#define ONESTOPBIT      0
#define ONE5STOPBITS    1
#define TWOSTOPBITS     2

/* Infinite timeout value */
#define INFINITE    0xFFFFFFFFL

/* Communications baud rates */
#define CBR_110     110L
#define CBR_300     300L
#define CBR_600     600L
#define CBR_1200    1200L
#define CBR_2400    2400L
#define CBR_4800    4800L
#define CBR_9600    9600L
#define CBR_14400   14400L
#define CBR_19200   19200L
#define CBR_38400   38400L
#define CBR_56000   56000L
#define CBR_57600   57600L
#define CBR_115200  115200L
#define CBR_128000  128000L
#define CBR_256000  256000L

/* Communications error flags */
#define CE_RXOVER   0x00000001L
#define CE_OVERRUN  0x00000002L
#define CE_RXPARITY 0x00000004L
#define CE_FRAME    0x00000008L
#define CE_BREAK    0x00000010L
#define CE_TXFULL   0x00000100L
#define CE_PTO      0x00000200L
#define CE_IOE      0x00000400L
#define CE_DNS      0x00000800L
#define CE_OOP      0x00001000L
#define CE_MODE     0x00008000L

/* Communications events */
#define EV_RXCHAR   0x00000001L
#define EV_RXFLAG   0x00000002L
#define EV_TXEMPTY  0x00000004L
#define EV_CTS      0x00000008L
#define EV_DSR      0x00000010L
#define EV_RLSD     0x00000020L
#define EV_BREAK    0x00000040L
#define EV_ERR      0x00000080L
#define EV_RING     0x00000100L
#define EV_PERR     0x00000200L
#define EV_RX80FULL 0x00000400L
#define EV_EVENT1   0x00000800L
#define EV_EVENT2   0x00001000L

/* Communications escape functions */
#define SETXOFF     1L
#define SETXON      2L
#define SETRTS      3L
#define CLRRTS      4L
#define SETDTR      5L
#define CLRDTR      6L
#define RESETDEV    7L
#define SETBREAK    8L
#define CLRBREAK    9L

/* PurgeComm() flags */
#define PURGE_TXABORT   0x00000001L
#define PURGE_RXABORT   0x00000002L
#define PURGE_TXCLEAR   0x00000004L
#define PURGE_RXCLEAR   0x00000008L

/* Communications modem status flags */
#define MS_CTS_ON   0x00000010L
#define MS_DSR_ON   0x00000020L
#define MS_RING_ON  0x00000040L
#define MS_RLSD_ON  0x00000080L

/* WaitNamedPipe() special timeout values */
#define NMPWAIT_WAIT_FOREVER        0xFFFFFFFFL
#define NMPWAIT_NOWAIT              0x00000001L
#define NMPWAIT_USE_DEFAULT_WAIT    0x00000000L

/* File system flags */
#define FS_CASE_IS_PRESERVED        FILE_CASE_PRESERVED_NAMES
#define FS_CASE_SENSITIVE           FILE_CASE_SENSITIVE_SEARCH
#define FS_UNICODE_STORED_ON_DISK   FILE_UNICODE_ON_DISK
#define FS_PERSISTENT_ACLS          FILE_PERSISTENT_ACLS
#define FS_VOL_IS_COMPRESSED        FILE_VOLUME_IS_COMPRESSED
#define FS_FILE_COMPRESSION         FILE_FILE_COMPRESSION
#define FS_FILE_ENCRYPTION          FILE_SUPPORTS_ENCRYPTION

/* File mapping access rights */
#define FILE_MAP_COPY       SECTION_QUERY
#define FILE_MAP_WRITE      SECTION_MAP_WRITE
#define FILE_MAP_READ       SECTION_MAP_READ
#define FILE_MAP_ALL_ACCESS SECTION_ALL_ACCESS
#define FILE_MAP_EXECUTE    SECTION_MAP_EXECUTE_EXPLICIT

/* OpenFile() flags */
#define OF_READ             0x00000000
#define OF_WRITE            0x00000001
#define OF_READWRITE        0x00000002
#define OF_SHARE_COMPAT     0x00000000
#define OF_SHARE_EXCLUSIVE  0x00000010
#define OF_SHARE_DENY_WRITE 0x00000020
#define OF_SHARE_DENY_READ  0x00000030
#define OF_SHARE_DENY_NONE  0x00000040
#define OF_PARSE            0x00000100
#define OF_DELETE           0x00000200
#define OF_VERIFY           0x00000400
#define OF_CANCEL           0x00000800
#define OF_CREATE           0x00001000
#define OF_PROMPT           0x00002000
#define OF_EXIST            0x00004000
#define OF_REOPEN           0x00008000

/* Maximum path name size for OFSTRUCT */
#define OFS_MAXPATHNAME 128

/* Process heap flags */
#define PROCESS_HEAP_REGION             0x0001
#define PROCESS_HEAP_UNCOMMITTED_RANGE  0x0002
#define PROCESS_HEAP_ENTRY_BUSY         0x0004
#define PROCESS_HEAP_ENTRY_MOVEABLE     0x0010
#define PROCESS_HEAP_ENTRY_DDESHARE     0x0020

/* GetBinaryType() return values */
#define SCS_32BIT_BINARY            0L
#define SCS_DOS_BINARY              1L
#define SCS_WOW_BINARY              2L
#define SCS_PIF_BINARY              3L
#define SCS_POSIX_BINARY            4L
#define SCS_OS216_BINARY            5L
#define SCS_64BIT_BINARY            6L
#define SCS_THIS_PLATFORM_BINARY    SCS_32BIT_BINARY

/* Process affinity update mode flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PROCESS_AFFINITY_ENABLE_AUTO_UPDATE 0x00000001L
#endif

/* CreateFiberEx() flags */
#if (_WIN32_WINNT >= 0x0400)
    #define FIBER_FLAG_FLOAT_SWITCH 0x00000001L
#endif

/* Process data execution prevention (DEP) flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PROCESS_DEP_ENABLE                      0x00000001L
    #define PROCESS_DEP_DISABLE_ATL_THUNK_EMULATION 0x00000002L
#endif

/* SetFileCompletionNotificationModes() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define FILE_SKIP_COMPLETION_PORT_ON_SUCCESS    0x01
    #define FILE_SKIP_SET_EVENT_ON_HANDLE           0x02
#endif

/* SetErrorMode() modes */
#define SEM_FAILCRITICALERRORS      0x0001
#define SEM_NOGPFAULTERRORBOX       0x0002
#define SEM_NOALIGNMENTFAULTEXCEPT  0x0004
#define SEM_NOOPENFILEERRORBOX      0x8000

/* Critical section flags */
#if (_WIN32_WINNT >= 0x0403)
    #define CRITICAL_SECTION_NO_DEBUG_INFO  RTL_CRITICAL_SECTION_FLAG_NO_DEBUG_INFO
#endif

/* LockFileEx() flags */
#define LOCKFILE_FAIL_IMMEDIATELY   0x00000001L
#define LOCKFILE_EXCLUSIVE_LOCK     0x00000002L

/* Handle flags */
#define HANDLE_FLAG_INHERIT             0x00000001L
#define HANDLE_FLAG_PROTECT_FROM_CLOSE  0x00000002L

/* Invalid instance handle value */
#define HINSTANCE_ERROR 32

/* GetTapeParameters() operations */
#define GET_TAPE_MEDIA_INFORMATION  0L
#define GET_TAPE_DRIVE_INFORMATION  1L

/* SetTapeParameters() operations */
#define SET_TAPE_MEDIA_INFORMATION  0L
#define SET_TAPE_DRIVE_INFORMATION  1L

/* File cache flags */
#if (_WIN32_WINNT >= 0x0502)
    #define FILE_CACHE_MAX_HARD_ENABLE  0x00000001L
    #define FILE_CACHE_MAX_HARD_DISABLE 0x00000002L
    #define FILE_CACHE_MIN_HARD_ENABLE  0x00000004L
    #define FILE_CACHE_MIN_HARD_DISABLE 0x00000008L
#endif

/* FormatMessage() flags */
#define FORMAT_MESSAGE_ALLOCATE_BUFFER  0x00000100L
#define FORMAT_MESSAGE_IGNORE_INSERTS   0x00000200L
#define FORMAT_MESSAGE_FROM_STRING      0x00000400L
#define FORMAT_MESSAGE_FROM_HMODULE     0x00000800L
#define FORMAT_MESSAGE_FROM_SYSTEM      0x00001000L
#define FORMAT_MESSAGE_ARGUMENT_ARRAY   0x00002000L
#define FORMAT_MESSAGE_MAX_WIDTH_MASK   0x000000FFL

/* File encryption status values */
#define FILE_ENCRYPTABLE        0L
#define FILE_IS_ENCRYPTED       1L
#define FILE_SYSTEM_ATTR        2L
#define FILE_ROOT_DIR           3L
#define FILE_SYSTEM_DIR         4L
#define FILE_UNKNOWN            5L
#define FILE_SYSTEM_NOT_SUPPORT 6L
#define FILE_USER_DISALLOWED    7L
#define FILE_READ_ONLY          8L
#define FILE_DIR_DISALLOWED     9L

/* OpenEncryptedFileRaw() flags */
#define CREATE_FOR_IMPORT   1L
#define CREATE_FOR_DIR      2L
#define OVERWRITE_HIDDEN    4L
#define EFSRPC_SECURE_ONLY  8L

/* FLS and TLS error values */
#define FLS_OUT_OF_INDEXES  0xFFFFFFFFL
#define TLS_OUT_OF_INDEXES  0xFFFFFFFFL

/* Stream identifiers */
#define BACKUP_INVALID          0x00000000L
#define BACKUP_DATA             0x00000001L
#define BACKUP_EA_DATA          0x00000002L
#define BACKUP_SECURITY_DATA    0x00000003L
#define BACKUP_ALTERNATE_DATA   0x00000004L
#define BACKUP_LINK             0x00000005L
#define BACKUP_PROPERTY_DATA    0x00000006L
#define BACKUP_OBJECT_ID        0x00000007L
#define BACKUP_REPARSE_DATA     0x00000008L
#define BACKUP_SPARSE_BLOCK     0x00000009L
#define BACKUP_TXFS_DATA        0x0000000AL

/* Stream attributes */
#define STREAM_NORMAL_ATTRIBUTE     0x00000000L
#define STREAM_MODIFIED_WHEN_READ   0x00000001L
#define STREAM_CONTAINS_SECURITY    0x00000002L
#define STREAM_CONTAINS_PROPERTIES  0x00000004L
#define STREAM_SPARSE_ATTRIBUTE     0x00000008L

/* Startup information flags */
#define STARTF_USESHOWWINDOW        0x00000001L
#define STARTF_USESIZE              0x00000002L
#define STARTF_USEPOSITION          0x00000004L
#define STARTF_USECOUNTCHARS        0x00000008L
#define STARTF_USEFILLATTRIBUTE     0x00000010L
#define STARTF_RUNFULLSCREEN        0x00000020L
#define STARTF_FORCEONFEEDBACK      0x00000040L
#define STARTF_FORCEOFFFEEDBACK     0x00000080L
#define STARTF_USESTDHANDLES        0x00000100L
#if (WINVER >= 0x0400)
    #define STARTF_USEHOTKEY        0x00000200L
    #define STARTF_TITLEISLINKNAME  0x00000800L
    #define STARTF_TITLEISAPPID     0x00001000L
    #define STARTF_PREVENTPINNING   0x00002000L
#endif

/* Process shutdown flags */
#define SHUTDOWN_NORETRY    0x00000001L

/* CreateMutexEx() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define CREATE_MUTEX_INITIAL_OWNER  0x00000001L
#endif

/* CreateEventEx() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define CREATE_EVENT_MANUAL_RESET   0x00000001L
    #define CREATE_EVENT_INITIAL_SET    0x00000002L
#endif

/* CreateWaitableTimerEx() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define CREATE_WAITABLE_TIMER_MANUAL_RESET  0x00000001L
#endif

/* LoadLibraryEx() flags */
#define DONT_RESOLVE_DLL_REFERENCES         0x00000001L
#define LOAD_LIBRARY_AS_DATAFILE            0x00000002L
#define LOAD_WITH_ALTERED_SEARCH_PATH       0x00000008L
#define LOAD_IGNORE_CODE_AUTHZ_LEVEL        0x00000010L
#define LOAD_LIBRARY_AS_IMAGE_RESOURCE      0x00000020L
#define LOAD_LIBRARY_AS_DATAFILE_EXCLUSIVE  0x00000040L
#define LOAD_LIBRARY_REQUIRE_SIGNED_TARGET  0x00000080L

/* GetModuleHandleEx() flags */
#if (_WIN32_WINNT >= 0x0501)
    #define GET_MODULE_HANDLE_EX_FLAG_PIN                   0x00000001L
    #define GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT    0x00000002L
    #define GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS          0x00000004L
#endif

/* QueryFullProcessImageName() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PROCESS_NAME_NATIVE 0x00000001L
#endif

/* DefineDosDevice() flags */
#define DDD_RAW_TARGET_PATH         0x00000001L
#define DDD_REMOVE_DEFINITION       0x00000002L
#define DDD_EXACT_MATCH_ON_REMOVE   0x00000004L
#define DDD_NO_BROADCAST_SYSTEM     0x00000008L
#define DDD_LUID_BROADCAST_DEVICE   0x00000010L

/* FindFirstFileEx() flags */
#if (_WIN32_WINNT >= 0x0400)
    #define FIND_FIRST_EX_CASE_SENSITIVE    0x00000001L
    #define FIND_FIRST_EX_LARGE_FETCH       0x00000002L
#endif

/* Process and thread attributes */
#if (_WIN32_WINNT >= 0x0600)
    #define PROC_THREAD_ATTRIBUTE_NUMBER    0x0000FFFFL
    #define PROC_THREAD_ATTRIBUTE_THREAD    0x00010000L
    #define PROC_THREAD_ATTRIBUTE_INPUT     0x00020000L
    #define PROC_THREAD_ATTRIBUTE_ADDITIVE  0x00040000L
#endif

/* Process creation mitigation policy flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PROCESS_CREATION_MITIGATION_POLICY_DEP_ENABLE           0x00000001L
    #define PROCESS_CREATION_MITIGATION_POLICY_DEP_ATL_THUNK_ENABLE 0x00000002L
    #define PROCESS_CREATION_MITIGATION_POLICY_SEHOP_ENABLE         0x00000004L
#endif

/* UpdateProcThreadAttribute() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PROC_THREAD_ATTRIBUTE_REPLACE_VALUE 0x00000001L
#endif

/* Resource enumeration flags */
#define RESOURCE_ENUM_LN            0x00000001L
#define RESOURCE_ENUM_MUI           0x00000002L
#define RESOURCE_ENUM_MUI_SYSTEM    0x00000004L
#define RESOURCE_ENUM_VALIDATE      0x00000008L
#define RESOURCE_ENUM_MODULE_EXACT  0x00000010L

/* SetSearchPathMode() flags */
#define BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE     0x00000001L
#define BASE_SEARCH_PATH_DISABLE_SAFE_SEARCHMODE    0x00010000L
#define BASE_SEARCH_PATH_PERMANENT                  0x00008000L

/* MoveFileEx() and MoveFileWithProgress() flags */
#define MOVEFILE_REPLACE_EXISTING           0x00000001L
#define MOVEFILE_COPY_ALLOWED               0x00000002L
#define MOVEFILE_DELAY_UNTIL_REBOOT         0x00000004L
#define MOVEFILE_WRITE_THROUGH              0x00000008L
#if (_WIN32_WINNT >= 0x0500)
    #define MOVEFILE_CREATE_HARDLINK        0x00000010L
    #define MOVEFILE_FAIL_IF_NOT_TRACKABLE  0x00000020L
#endif

/* Event log information classes */
#define EVENTLOG_FULL_INFO  0

/* Maximum computer name length */
#define MAX_COMPUTERNAME_LENGTH 15

/* Logon types */
#define LOGON32_LOGON_INTERACTIVE           2L
#define LOGON32_LOGON_NETWORK               3L
#define LOGON32_LOGON_BATCH                 4L
#define LOGON32_LOGON_SERVICE               5L
#define LOGON32_LOGON_UNLOCK                7L
#if (_WIN32_WINNT >= 0x0500)
    #define LOGON32_LOGON_NETWORK_CLEARTEXT 8L
    #define LOGON32_LOGON_NEW_CREDENTIALS   9L
#endif
/* Logon providers */
#define LOGON32_PROVIDER_DEFAULT        0L
#define LOGON32_PROVIDER_WINNT35        1L
#if (_WIN32_WINNT >= 0x0400)
    #define LOGON32_PROVIDER_WINNT40    2L
#endif
#if (_WIN32_WINNT >= 0x0500)
    #define LOGON32_PROVIDER_WINNT50    3L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LOGON32_PROVIDER_VIRTUAL    4L
#endif

/* CreateProcessWithLogonW() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define LOGON_WITH_PROFILE          0x00000001L
    #define LOGON_NETCREDENTIALS_ONLY   0x00000002L
    #define LOGON_ZERO_PASSWORD_BUFFER  0x80000000L
#endif

/* Hardware profile GUID length */
#if (_WIN32_WINNT >= 0x0400)
    #define HW_PROFILE_GUIDLEN  39
#endif

/* Maximum hardware profile name length */
#if (_WIN32_WINNT >= 0x0400)
    #define MAX_PROFILE_LEN 80
#endif

/* Hardware profile docking flags */
#if (_WIN32_WINNT >= 0x0400)
    #define DOCKINFO_UNDOCKED       0x00000001L
    #define DOCKINFO_DOCKED         0x00000002L
    #define DOCKINFO_USER_SUPPLIED  0x00000004L
    #define DOCKINFO_USER_UNDOCKED  (DOCKINFO_USER_SUPPLIED | DOCKINFO_UNDOCKED)
    #define DOCKINFO_USER_DOCKED    (DOCKINFO_USER_SUPPLIED | DOCKINFO_DOCKED)
#endif

/* AC line status values */
#if (WINVER >= 0x0400)
    #define AC_LINE_OFFLINE         0x00
    #define AC_LINE_ONLINE          0x01
    #define AC_LINE_BACKUP_POWER    0x02
    #define AC_LINE_UNKNOWN         0xFF
#endif

/* Battery flags */
#if (WINVER >= 0x0400)
    #define BATTERY_FLAG_HIGH       0x01
    #define BATTERY_FLAG_LOW        0x02
    #define BATTERY_FLAG_CRITICAL   0x04
    #define BATTERY_FLAG_CHARGING   0x08
    #define BATTERY_FLAG_NO_BATTERY 0x80
    #define BATTERY_FLAG_UNKNOWN    0xFF
#endif

/* Battery percentage special value */
#if (WINVER >= 0x0400)
    #define BATTERY_PERCENTAGE_UNKNOWN  0xFF
#endif

/* Battery life special value */
#if (WINVER >= 0x0400)
    #define BATTERY_LIFE_UNKNOWN    0xFFFFFFFFL
#endif

/* ClosePrivateNamespcae() flags */
#if (_WIN32_WINNT >= 0x0600)
    #define PRIVATE_NAMESPACE_FLAG_DESTROY  0x00000001L
#endif

/* Activation context flags */
#if (_WIN32_WINNT >= 0x0500)
    #define ACTCTX_FLAG_PROCESSOR_ARCHITECTURE_VALID    0x00000001L
    #define ACTCTX_FLAG_LANGID_VALID                    0x00000002L
    #define ACTCTX_FLAG_ASSEMBLY_DIRECTORY_VALID        0x00000004L
    #define ACTCTX_FLAG_RESOURCE_NAME_VALID             0x00000008L
    #define ACTCTX_FLAG_SET_PROCESS_DEFAULT             0x00000010L
    #define ACTCTX_FLAG_APPLICATION_NAME_VALID          0x00000020L
    #define ACTCTX_FLAG_SOURCE_IS_ASSEMBLYREF           0x00000040L
    #define ACTCTX_FLAG_HMODULE_VALID                   0x00000080L
#endif

/* DeactivateActCtx() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define DEACTIVATE_ACTCTX_FLAG_FORCE_EARLY_DEACTIVATION 0x00000001L
#endif

/* FindActCtxSectionString() and FindActCtxSectionGuid() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define FIND_ACTCTX_SECTION_KEY_RETURN_HACTCTX              0x00000001L
    #define FIND_ACTCTX_SECTION_KEY_RETURN_FLAGS                0x00000002L
    #define FIND_ACTCTX_SECTION_KEY_RETURN_ASSEMBLY_METADATA    0x00000004L
#endif

/* QueryActCtxW() flags */
#if (_WIN32_WINNT >= 0x0500)
    #define QUERY_ACTCTX_FLAG_USE_ACTIVE_ACTCTX 0x00000004L
    #define QUERY_ACTCTX_FLAG_ACTCTX_IS_HMODULE 0x00000008L
    #define QUERY_ACTCTX_FLAG_ACTCTX_IS_ADDRESS 0x00000010L
    #define QUERY_ACTCTX_FLAG_NO_ADDREF         0x80000000L
#endif

/* Maximum command line length */
#define RESTART_MAX_CMD_LINE    1024

/* Restart flags */
#define RESTART_NO_CRASH    1L
#define RESTART_NO_HANG     2L
#define RESTART_NO_PATCH    4L
#define RESTART_NO_REBOOT   8L

/* Application recovery constants */
#define RECOVERY_DEFAULT_PING_INTERVAL  5000L
#define RECOVERY_MAX_PING_INTERVAL      300000L

/* File remote protocol information flags */
#if (_WIN32_WINNT >= 0x0600)
    #define REMOTE_PROTOCOL_INFO_FLAG_LOOPBACK  0x00000001L
    #define REMOTE_PROTOCOL_INFO_FLAG_OFFLINE   0x00000002L
#endif

/* Symbolic link flags */
#if (_WIN32_WINNT >= 0x0600)
    #define SYMBOLIC_LINK_FLAG_DIRECTORY    0x00000001L
    #define VALID_SYMBOLIC_LINK_FLAGS       SYMBOLIC_LINK_FLAG_DIRECTORY
#endif

/* Aliases for types defined in winnt.h */
typedef RTL_CRITICAL_SECTION        CRITICAL_SECTION;
typedef PRTL_CRITICAL_SECTION       PCRITICAL_SECTION;
typedef PRTL_CRITICAL_SECTION       LPCRITICAL_SECTION;
typedef RTL_CRITICAL_SECTION_DEBUG  CRITICAL_SECTION_DEBUG;
typedef PRTL_CRITICAL_SECTION_DEBUG PCRITICAL_SECTION_DEBUG;
typedef PRTL_CRITICAL_SECTION_DEBUG LPCRITICAL_SECTION_DEBUG;
#if defined(_X86_)
typedef PLDT_ENTRY                  LPLDT_ENTRY;
#else
typedef LPVOID                      LPLDT_ENTRY;
#endif
typedef PCONTEXT                    LPCONTEXT;
typedef PEXCEPTION_RECORD           LPEXCEPTION_RECORD;
typedef PEXCEPTION_POINTERS         LPEXCEPTION_POINTERS;
#if (_WIN32_WINNT >= 0x0500)
typedef WAITORTIMERCALLBACKFUNC     WAITORTIMERCALLBACK;
#endif
#if (_WIN32_WINNT >= 0x0600)
typedef RTL_RUN_ONCE                INIT_ONCE;
typedef PRTL_RUN_ONCE               PINIT_ONCE;
typedef PRTL_RUN_ONCE               LPINIT_ONCE;
#endif
typedef RTL_SRWLOCK                 SRWLOCK;
typedef RTL_SRWLOCK                 *PSRWLOCK;
typedef RTL_CONDITION_VARIABLE      CONDITION_VARIABLE;
typedef RTL_CONDITION_VARIABLE      *PCONDITION_VARIABLE;

/* Opaque data types */
typedef struct _PROC_THREAD_ATTRIBUTE_LIST  *PPROC_THREAD_ATTRIBUTE_LIST;
typedef struct _PROC_THREAD_ATTRIBUTE_LIST  *LPPROC_THREAD_ATTRIBUTE_LIST;

/* Structure for asynchronous I/O */
typedef struct _OVERLAPPED {
    ULONG_PTR   Internal;
    ULONG_PTR   InternalHigh;
    union {
        struct {
            DWORD   Offset;
            DWORD   OffsetHigh;
        };
        PVOID   Pointer;
    };
    HANDLE  hEvent;
} OVERLAPPED;
typedef OVERLAPPED  *LPOVERLAPPED;

/* Overlapped entry */
typedef struct _OVERLAPPED_ENTRY {
    ULONG_PTR       lpCompletionKey;
    LPOVERLAPPED    lpOverlapped;
    ULONG_PTR       Internal;
    DWORD           dwNumberOfBytesTransferred;
} OVERLAPPED_ENTRY;
typedef OVERLAPPED_ENTRY    *LPOVERLAPPED_ENTRY;

/* Kernel object security attributes */
typedef struct _SECURITY_ATTRIBUTES {
    DWORD   nLength;
    LPVOID  lpSecurityDescriptor;
    BOOL    bInheritHandle;
} SECURITY_ATTRIBUTES;
typedef SECURITY_ATTRIBUTES *PSECURITY_ATTRIBUTES;
typedef SECURITY_ATTRIBUTES *LPSECURITY_ATTRIBUTES;

/* Process information returned by CreateProcess() */
typedef struct _PROCESS_INFORMATION {
    HANDLE  hProcess;
    HANDLE  hThread;
    DWORD   dwProcessId;
    DWORD   dwThreadId;
} PROCESS_INFORMATION;
typedef PROCESS_INFORMATION *PPROCESS_INFORMATION;
typedef PROCESS_INFORMATION *LPPROCESS_INFORMATION;

/* File time */
#ifndef _FILETIME_
#define _FILETIME_
typedef struct _FILETIME {
    DWORD   dwLowDateTime;
    DWORD   dwHighDateTime;
} FILETIME;
typedef FILETIME    *PFILETIME;
typedef FILETIME    *LPFILETIME;
#endif

/* System time */
typedef struct _SYSTEMTIME {
    WORD    wYear;
    WORD    wMonth;
    WORD    wDayOfWeek;
    WORD    wDay;
    WORD    wHour;
    WORD    wMinute;
    WORD    wSecond;
    WORD    wMilliseconds;
} SYSTEMTIME;
typedef SYSTEMTIME  *PSYSTEMTIME;
typedef SYSTEMTIME  *LPSYSTEMTIME;

/* Run once callback */
#if (_WIN32_WINNT >= 0x0600)
typedef BOOL        (WINAPI *PINIT_ONCE_FN)( PINIT_ONCE, PVOID, PVOID * );
#endif

/* Thread procedure */
typedef DWORD       (WINAPI *PTHREAD_START_ROUTINE)( LPVOID );
typedef PTHREAD_START_ROUTINE   LPTHREAD_START_ROUTINE;

/* Fiber procedure */
#if (_WIN32_WINNT >= 0x0400)
typedef VOID        (WINAPI *PFIBER_START_ROUTINE)( LPVOID );
typedef PFIBER_START_ROUTINE    LPFIBER_START_ROUTINE;
#endif

/* Communications properties */
typedef struct _COMMPROP {
    WORD    wPacketLength;
    WORD    wPacketVersion;
    DWORD   dwServiceMask;
    DWORD   dwReserved1;
    DWORD   dwMaxTxQueue;
    DWORD   dwMaxRxQueue;
    DWORD   dwMaxBaud;
    DWORD   dwProvSubType;
    DWORD   dwProvCapabilities;
    DWORD   dwSettableParams;
    DWORD   dwSettableBaud;
    WORD    wSettableData;
    WORD    wSettableStopParity;
    DWORD   dwCurrentTxQueue;
    DWORD   dwCurrentRxQueue;
    DWORD   dwProvSpec1;
    DWORD   dwProvSpec2;
    WCHAR   wcProvChar[1];
} COMMPROP;
typedef COMMPROP    *LPCOMMPROP;

/* Communications status */
typedef struct _COMSTAT {
    DWORD   fCtsHold    : 1;
    DWORD   fDsrHold    : 1;
    DWORD   fRlsdHold   : 1;
    DWORD   fXoffHold   : 1;
    DWORD   fXoffSent   : 1;
    DWORD   fEof        : 1;
    DWORD   fTxim       : 1;
    DWORD   fReserved   : 25;
    DWORD   cbInQue;
    DWORD   cbOutQue;
} COMSTAT;
typedef COMSTAT *LPCOMSTAT;

/* Communications device settings */
typedef struct _DCB {
    DWORD   DCBlength;
    DWORD   BaudRate;
    DWORD   fBinary             : 1;
    DWORD   fParity             : 1;
    DWORD   fOutxCtsFlow        : 1;
    DWORD   fOutxDsrFlow        : 1;
    DWORD   fDtrControl         : 2;
    DWORD   fDsrSensitivity     : 1;
    DWORD   fTXContinueOnXoff   : 1;
    DWORD   fOutX               : 1;
    DWORD   fInX                : 1;
    DWORD   fErrorChar          : 1;
    DWORD   fNull               : 1;
    DWORD   fRtsControl         : 2;
    DWORD   fAbortOnError       : 1;
    DWORD   fDummy2             : 17;
    WORD    wReserved;
    WORD    XonLim;
    WORD    XoffLim;
    BYTE    ByteSize;
    BYTE    Parity;
    BYTE    StopBits;
    char    XonChar;
    char    XoffChar;
    char    ErrorChar;
    char    EofChar;
    char    EvtChar;
    WORD    wReserved1;
} DCB;
typedef DCB *LPDCB;

/* Communications timeouts */
typedef struct _COMMTIMEOUTS {
    DWORD   ReadIntervalTimeout;
    DWORD   ReadTotalTimeoutMultiplier;
    DWORD   ReadTotalTimeoutConstant;
    DWORD   WriteTotalTimeoutMultiplier;
    DWORD   WriteTotalTimeoutConstant;
} COMMTIMEOUTS;
typedef COMMTIMEOUTS    *LPCOMMTIMEOUTS;

/* Communications configuration */
typedef struct _COMMCONFIG {
    DWORD   dwSize;
    WORD    wVersion;
    WORD    wReserved;
    DCB     dcb;
    DWORD   dwProviderSubType;
    DWORD   dwProviderOffset;
    DWORD   dwProviderSize;
    WCHAR   wcProviderData[1];
} COMMCONFIG;
typedef COMMCONFIG  *LPCOMMCONFIG;

/* System information */
typedef struct _SYSTEM_INFO {
    union {
        DWORD   dwOemId;
        struct {
            WORD    wProcessorArchitecture;
            WORD    wReserved;
        };
    };
    DWORD       dwPageSize;
    LPVOID      lpMinimumApplicationAddress;
    LPVOID      lpMaximumApplicationAddress;
    DWORD_PTR   dwActiveProcessorMask;
    DWORD       dwNumberOfProcessors;
    DWORD       dwProcessorType;
    DWORD       dwAllocationGranularity;
    WORD        wProcessorLevel;
    WORD        wProcessorRevision;
} SYSTEM_INFO;
typedef SYSTEM_INFO *LPSYSTEM_INFO;

/* Memory status */
typedef struct _MEMORYSTATUS {
    DWORD   dwLength;
    DWORD   dwMemoryLoad;
    SIZE_T  dwTotalPhys;
    SIZE_T  dwAvailPhys;
    SIZE_T  dwTotalPageFile;
    SIZE_T  dwAvailPageFile;
    SIZE_T  dwTotalVirtual;
    SIZE_T  dwAvailVirtual;
} MEMORYSTATUS;
typedef MEMORYSTATUS    *LPMEMORYSTATUS;

/* Exception debug information */
typedef struct _EXCEPTION_DEBUG_INFO {
    EXCEPTION_RECORD    ExceptionRecord;
    DWORD               dwFirstChance;
} EXCEPTION_DEBUG_INFO;
typedef EXCEPTION_DEBUG_INFO    *LPEXCEPTION_DEBUG_INFO;

/* Create thread debug information */
typedef struct _CREATE_THREAD_DEBUG_INFO {
    HANDLE                  hThread;
    LPVOID                  lpThreadLocalBase;
    LPTHREAD_START_ROUTINE  lpStartAddress;
} CREATE_THREAD_DEBUG_INFO;
typedef CREATE_THREAD_DEBUG_INFO    *LPCREATE_THREAD_DEBUG_INFO;

/* Create process debug information */
typedef struct _CREATE_PROCESS_DEBUG_INFO {
    HANDLE                  hFile;
    HANDLE                  hProcess;
    HANDLE                  hThread;
    LPVOID                  lpBaseOfImage;
    DWORD                   dwDebugInfoFileOffset;
    DWORD                   nDebugInfoSize;
    LPVOID                  lpThreadLocalBase;
    LPTHREAD_START_ROUTINE  lpStartAddress;
    LPVOID                  lpImageName;
    WORD                    fUnicode;
} CREATE_PROCESS_DEBUG_INFO;
typedef CREATE_PROCESS_DEBUG_INFO   *LPCREATE_PROCESS_DEBUG_INFO;

/* Exit thread debug information */
typedef struct _EXIT_THREAD_DEBUG_INFO {
    DWORD   dwExitCode;
} EXIT_THREAD_DEBUG_INFO;
typedef EXIT_THREAD_DEBUG_INFO  *LPEXIT_THREAD_DEBUG_INFO;

/* Exit process debug information */
typedef struct _EXIT_PROCESS_DEBUG_INFO {
    DWORD   dwExitCode;
} EXIT_PROCESS_DEBUG_INFO;
typedef EXIT_PROCESS_DEBUG_INFO *LPEXIT_PROCESS_DEBUG_INFO;

/* Load DLL debug information */
typedef struct _LOAD_DLL_DEBUG_INFO {
    HANDLE  hFile;
    LPVOID  lpBaseOfDll;
    DWORD   dwDebugInfoFileOffset;
    DWORD   nDebugInfoSize;
    LPVOID  lpImageName;
    WORD    fUnicode;
} LOAD_DLL_DEBUG_INFO;
typedef LOAD_DLL_DEBUG_INFO *LPLOAD_DLL_DEBUG_INFO;

/* Unload DLL debug information */
typedef struct _UNLOAD_DLL_DEBUG_INFO {
    LPVOID  lpBaseOfDll;
} UNLOAD_DLL_DEBUG_INFO;
typedef UNLOAD_DLL_DEBUG_INFO   *LPUNLOAD_DLL_DEBUG_INFO;

/* Debug string information */
typedef struct _OUTPUT_DEBUG_STRING_INFO {
    LPSTR   lpDebugStringData;
    WORD    fUnicode;
    WORD    nDebugStringLength;
} OUTPUT_DEBUG_STRING_INFO;
typedef OUTPUT_DEBUG_STRING_INFO    *LPOUTPUT_DEBUG_STRING_INFO;

/* Debug error information */
typedef struct _RIP_INFO {
    DWORD   dwError;
    DWORD   dwType;
} RIP_INFO;
typedef RIP_INFO    *LPRIP_INFO;

/* Debug event */
typedef struct _DEBUG_EVENT {
    DWORD   dwDebugEventCode;
    DWORD   dwProcessId;
    DWORD   dwThreadId;
    union {
        EXCEPTION_DEBUG_INFO        Exception;
        CREATE_THREAD_DEBUG_INFO    CreateThread;
        CREATE_PROCESS_DEBUG_INFO   CreateProcessInfo;
        EXIT_THREAD_DEBUG_INFO      ExitThread;
        EXIT_PROCESS_DEBUG_INFO     ExitProcess;
        LOAD_DLL_DEBUG_INFO         LoadDll;
        UNLOAD_DLL_DEBUG_INFO       UnloadDll;
        OUTPUT_DEBUG_STRING_INFO    DebugString;
        RIP_INFO                    RipInfo;
    } u;
} DEBUG_EVENT;
typedef DEBUG_EVENT *LPDEBUG_EVENT;

/* JIT debugging information */
typedef struct _JIT_DEBUG_INFO {
    DWORD   dwSize;
    DWORD   dwProcessorArchitecture;
    DWORD   dwThreadID;
    DWORD   dwReserved0;
    ULONG64 lpExceptionAddress;
    ULONG64 lpExceptionRecord;
    ULONG64 lpContextRecord;
} JIT_DEBUG_INFO;
typedef JIT_DEBUG_INFO  *PJIT_DEBUG_INFO;
typedef JIT_DEBUG_INFO  JIT_DEBUG_INFO32;
typedef JIT_DEBUG_INFO  *PJIT_DEBUG_INFO32;
typedef JIT_DEBUG_INFO  JIT_DEBUG_INFO64;
typedef JIT_DEBUG_INFO  *PJIT_DEBUG_INFO64;

/* OpenFile() structure */
typedef struct _OFSTRUCT {
    BYTE    cBytes;
    BYTE    fFixedDisk;
    WORD    nErrCode;
    WORD    Reserved1;
    WORD    Reserved2;
    CHAR    szPathName[OFS_MAXPATHNAME];
} OFSTRUCT;
typedef OFSTRUCT    *POFSTRUCT;
typedef OFSTRUCT    *LPOFSTRUCT;

/* Memory status (extended version) */
typedef struct _MEMORYSTATUSEX {
    DWORD       dwLength;
    DWORD       dwMemoryLoad;
    DWORDLONG   ullTotalPhys;
    DWORDLONG   ullAvailPhys;
    DWORDLONG   ullTotalPageFile;
    DWORDLONG   ullAvailPageFile;
    DWORDLONG   ullTotalVirtual;
    DWORDLONG   ullAvailVirtual;
    DWORDLONG   ullAvailExtendedVirtual;
} MEMORYSTATUSEX;
typedef MEMORYSTATUSEX  *LPMEMORYSTATUSEX;

/* Process heap entry */
typedef struct _PROCESS_HEAP_ENTRY {
    PVOID   lpData;
    DWORD   cbData;
    BYTE    cbOverhead;
    BYTE    iRegionIndex;
    WORD    wFlags;
    union {
        struct {
            HANDLE  hMem;
            DWORD   dwReserved[3];
        } Block;
        struct {
            DWORD   dwCommittedSize;
            DWORD   dwUnCommittedSize;
            LPVOID  lpFirstBlock;
            LPVOID  lpLastBlock;
        } Region;
    };
} PROCESS_HEAP_ENTRY;
typedef PROCESS_HEAP_ENTRY  *PPROCESS_HEAP_ENTRY;
typedef PROCESS_HEAP_ENTRY  *LPPROCESS_HEAP_ENTRY;

/* Unhandled exception filter callback */
typedef LONG        (WINAPI *PTOP_LEVEL_EXCEPTION_FILTER)( struct _EXCEPTION_POINTERS * );
typedef PTOP_LEVEL_EXCEPTION_FILTER LPTOP_LEVEL_EXCEPTION_FILTER;

/* Reason context */
#if (_WIN32_WINNT >= 0x0601)
typedef struct _REASON_CONTEXT {
    ULONG   Version;
    DWORD   Flags;
    union {
        struct {
            HMODULE LocalizedReasonModule;
            ULONG   LocalizedReasonId;
            ULONG   ReasonStringCount;
            LPWSTR  *ReasonStrings;
        } Detailed;
        LPWSTR  SimpleReasonString;
    } Reason;
} REASON_CONTEXT;
typedef REASON_CONTEXT  *PREASON_CONTEXT;
typedef REASON_CONTEXT  POWER_REQUEST_CONTEXT;
typedef REASON_CONTEXT  *PPOWER_REQUEST_CONTEXT;
typedef REASON_CONTEXT  *LPPOWER_REQUEST_CONTEXT;
#endif

/* Structure returned by GetFileInformationByHandle() */
typedef struct _BY_HANDLE_FILE_INFORMATION {
    DWORD       dwFileAttributes;
    FILETIME    ftCreationTime;
    FILETIME    ftLastAccessTime;
    FILETIME    ftLastWriteTime;
    DWORD       dwVolumeSerialNumber;
    DWORD       nFileSizeHigh;
    DWORD       nFileSizeLow;
    DWORD       nNumberOfLinks;
    DWORD       nFileIndexHigh;
    DWORD       nFileIndexLow;
} BY_HANDLE_FILE_INFORMATION;
typedef BY_HANDLE_FILE_INFORMATION  *PBY_HANDLE_FILE_INFORMATION;
typedef BY_HANDLE_FILE_INFORMATION  *LPBY_HANDLE_FILE_INFORMATION;

/* Data execution prevention (DEP) system policy types */
typedef enum _DEP_SYSTEM_POLICY_TYPE {
    DEPPolicyAlwaysOff  = 0,
    DEPPolicyAlwaysOn   = 1,
    DEPPolicyOptIn      = 2,
    DEPPolicyOptOut     = 3,
    DEPTotalPolicyCount = 4
} DEP_SYSTEM_POLICY_TYPE;

/* Time zone information */
typedef struct _TIME_ZONE_INFORMATION {
    LONG        Bias;
    WCHAR       StandardName[32];
    SYSTEMTIME  StandardDate;
    LONG        StandardBias;
    WCHAR       DaylightName[32];
    SYSTEMTIME  DaylightDate;
    LONG        DaylightBias;
} TIME_ZONE_INFORMATION;
typedef TIME_ZONE_INFORMATION   *PTIME_ZONE_INFORMATION;
typedef TIME_ZONE_INFORMATION   *LPTIME_ZONE_INFORMATION;

/* Dynamic time zone information */
typedef struct _TIME_DYNAMIC_ZONE_INFORMATION {
    LONG        Bias;
    WCHAR       StandardName[32];
    SYSTEMTIME  StandardDate;
    LONG        StandardBias;
    WCHAR       DaylightName[32];
    SYSTEMTIME  DaylightDate;
    LONG        DaylightBias;
    WCHAR       TimeZoneKeyName[128];
    BOOLEAN     DynamicDaylightTimeDisabled;
} DYNAMIC_TIME_ZONE_INFORMATION;
typedef DYNAMIC_TIME_ZONE_INFORMATION   *PDYNAMIC_TIME_ZONE_INFORMATION;

/* Encryption callbacks */
typedef DWORD       (WINAPI* PFE_EXPORT_FUNC)( PBYTE, PVOID, ULONG );
typedef DWORD       (WINAPI* PFE_IMPORT_FUNC)( PBYTE, PVOID, PULONG );

/* Asynchronous I/O completion callback */
typedef VOID        (WINAPI* LPOVERLAPPED_COMPLETION_ROUTINE)( DWORD, DWORD, LPOVERLAPPED );

/* Stream identifier */
typedef struct _WIN32_STREAM_ID {
    DWORD           dwStreamId;
    DWORD           dwStreamAttributes;
    LARGE_INTEGER   Size;
    DWORD           dwStreamNameSize;
    WCHAR           cStreamName[ANYSIZE_ARRAY];
} WIN32_STREAM_ID;
typedef WIN32_STREAM_ID *PWIN32_STREAM_ID;

/* Process startup information */
typedef struct _STARTUPINFOA {
    DWORD   cb;
    LPSTR   lpReserved;
    LPSTR   lpDesktop;
    LPSTR   lpTitle;
    DWORD   dwX;
    DWORD   dwY;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwXCountChars;
    DWORD   dwYCountChars;
    DWORD   dwFillAttribute;
    DWORD   dwFlags;
    WORD    wShowWindow;
    WORD    cbReserved2;
    LPBYTE  lpReserved2;
    HANDLE  hStdInput;
    HANDLE  hStdOutput;
    HANDLE  hStdError;
} STARTUPINFOA;
typedef STARTUPINFOA    *LPSTARTUPINFOA;
typedef struct _STARTUPINFOW {
    DWORD   cb;
    LPWSTR  lpReserved;
    LPWSTR  lpDesktop;
    LPWSTR  lpTitle;
    DWORD   dwX;
    DWORD   dwY;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwXCountChars;
    DWORD   dwYCountChars;
    DWORD   dwFillAttribute;
    DWORD   dwFlags;
    WORD    wShowWindow;
    WORD    cbReserved2;
    LPBYTE  lpReserved2;
    HANDLE  hStdInput;
    HANDLE  hStdOutput;
    HANDLE  hStdError;
} STARTUPINFOW;
typedef STARTUPINFOW    *LPSTARTUPINFOW;
#ifdef UNICODE
typedef STARTUPINFOW    STARTUPINFO;
typedef LPSTARTUPINFOW  LPSTARTUPINFO;
#else
typedef STARTUPINFOA    STARTUPINFO;
typedef LPSTARTUPINFOA  LPSTARTUPINFO;
#endif

/* Process startup information (extended version) */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _STARTUPINFOEXA {
    STARTUPINFOA                    StartupInfo;
    LPPROC_THREAD_ATTRIBUTE_LIST    lpAttributeList;
} STARTUPINFOEXA;
typedef STARTUPINFOEXA  *LPSTARTUPINFOEXA;
typedef struct _STARTUPINFOEXW {
    STARTUPINFOW                    StartupInfo;
    LPPROC_THREAD_ATTRIBUTE_LIST    lpAttributeList;
} STARTUPINFOEXW;
typedef STARTUPINFOEXW  *LPSTARTUPINFOEXW;
#ifdef UNICODE
typedef STARTUPINFOEXW      STARTUPINFOEX;
typedef LPSTARTUPINFOEXW    LPSTARTUPINFOEX;
#else
typedef STARTUPINFOEXA      STARTUPINFOEX;
typedef LPSTARTUPINFOEXA    LPSTARTUPINFOEX;
#endif
#endif

/* Structure used with FindFirstFile(), etc. */
typedef struct _WIN32_FIND_DATAA {
    DWORD       dwFileAttributes;
    FILETIME    ftCreationTime;
    FILETIME    ftLastAccessTime;
    FILETIME    ftLastWriteTime;
    DWORD       nFileSizeHigh;
    DWORD       nFileSizeLow;
    DWORD       dwReserved0;
    DWORD       dwReserved1;
    CHAR        cFileName[MAX_PATH];
    CHAR        cAlternateFileName[14];
} WIN32_FIND_DATAA;
typedef WIN32_FIND_DATAA    *PWIN32_FIND_DATAA;
typedef WIN32_FIND_DATAA    *LPWIN32_FIND_DATAA;
typedef struct _WIN32_FIND_DATAW {
    DWORD       dwFileAttributes;
    FILETIME    ftCreationTime;
    FILETIME    ftLastAccessTime;
    FILETIME    ftLastWriteTime;
    DWORD       nFileSizeHigh;
    DWORD       nFileSizeLow;
    DWORD       dwReserved0;
    DWORD       dwReserved1;
    WCHAR       cFileName[MAX_PATH];
    WCHAR       cAlternateFileName[14];
} WIN32_FIND_DATAW;
typedef WIN32_FIND_DATAW    *PWIN32_FIND_DATAW;
typedef WIN32_FIND_DATAW    *LPWIN32_FIND_DATAW;
#ifdef UNICODE
typedef WIN32_FIND_DATAW    WIN32_FIND_DATA;
typedef PWIN32_FIND_DATAW   PWIN32_FIND_DATA;
typedef LPWIN32_FIND_DATAW  LPWIN32_FIND_DATA;
#else
typedef WIN32_FIND_DATAA    WIN32_FIND_DATA;
typedef PWIN32_FIND_DATAA   PWIN32_FIND_DATA;
typedef LPWIN32_FIND_DATAA  LPWIN32_FIND_DATA;
#endif

/* File attribute data */
typedef struct _WIN32_FILE_ATTRIBUTE_DATA {
    DWORD       dwFileAttributes;
    FILETIME    ftCreationTime;
    FILETIME    ftLastAccessTime;
    FILETIME    ftLastWriteTime;
    DWORD       nFileSizeHigh;
    DWORD       nFileSizeLow;
} WIN32_FILE_ATTRIBUTE_DATA;
typedef WIN32_FILE_ATTRIBUTE_DATA   *LPWIN32_FILE_ATTRIBUTE_DATA;

/* Waitable timer callback */
#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
typedef VOID        (WINAPI *PTIMERAPCROUTINE)( LPVOID, DWORD, DWORD );
#endif

/* Memory resource notification types */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _MEMORY_RESOURCE_NOTIFICATION_TYPE {
    LowMemoryResourceNotification,
    HighMemoryResourceNotification
} MEMORY_RESOURCE_NOTIFICATION_TYPE;
#endif

/* Process and thread attribute numbers */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _PROC_THREAD_ATTRIBUTE_NUM {
    ProcThreadAttributeParentProcess    = 0,
    ProcThreadAttributeExtendedFlags    = 1,
    ProcThreadAttributeHandleList       = 2,
    ProcThreadAttributeGroupAffinity    = 3,
    ProcThreadAttributePreferredNode    = 4,
    ProcThreadAttributeIdealProcessor   = 5,
    ProcThreadAttributeUmsThread        = 6,
    ProcThreadAttributeMitigationPolicy = 7,
    ProcThreadAttributeMax              = 8
} PROC_THREAD_ATTRIBUTE_NUM;
#endif

/* Resource enumeration callbacks */
typedef BOOL        (CALLBACK *ENUMRESTYPEPROCA)( HMODULE, LPSTR, LONG_PTR );
typedef BOOL        (CALLBACK *ENUMRESTYPEPROCW)( HMODULE, LPWSTR, LONG_PTR );
typedef BOOL        (CALLBACK *ENUMRESNAMEPROCA)( HMODULE, LPCSTR, LPSTR, LONG_PTR );
typedef BOOL        (CALLBACK *ENUMRESNAMEPROCW)( HMODULE, LPCWSTR, LPWSTR, LONG_PTR );
typedef BOOL        (CALLBACK *ENUMRESLANGPROCA)( HMODULE, LPCSTR, LPCSTR, WORD, LONG_PTR );
typedef BOOL        (CALLBACK *ENUMRESLANGPROCW)( HMODULE, LPCWSTR, LPCWSTR, WORD, LONG_PTR );
#ifdef UNICODE
    #define ENUMRESTYPEPROC ENUMRESTYPEPROCW
    #define ENUMRESNAMEPROC ENUMRESNAMEPROCW
    #define ENUMRESLANGPROC ENUMRESLANGPROCW
#else
    #define ENUMRESTYPEPROC ENUMRESTYPEPROCA
    #define ENUMRESNAMEPROC ENUMRESNAMEPROCA
    #define ENUMRESLANGPROC ENUMRESLANGPROCA
#endif

/* GetFileAttributesEx() information levels */
typedef enum _GET_FILEEX_INFO_LEVELS {
    GetFileExInfoStandard,
    GetFileExMaxInfoLevel
} GET_FILEEX_INFO_LEVELS;

/* FindFirstFileEx() information levels */
#if (_WIN32_WINNT >= 0x0400)
typedef enum _FINDEX_INFO_LEVELS {
    FindExInfoStandard      = 0,
    FindExInfoBasic         = 1,
    FindExInfoMaxInfoLevel  = 2
} FINDEX_INFO_LEVELS;
#endif

/* FindFirstFileEx() search operations */
#if (_WIN32_WINNT >= 0x0400)
typedef enum _FINDEX_SEARCH_OPS {
    FindExSearchNameMatch,
    FindExSearchLimitToDirectories,
    FindExSearchLimitToDevices,
    FindExSearchMaxSearchOp
} FINDEX_SEARCH_OPS;
#endif

/* Copy progress callback */
#if (_WIN32_WINNT >= 0x0400)
typedef DWORD       (WINAPI *LPPROGRESS_ROUTINE)( LARGE_INTEGER, LARGE_INTEGER, LARGE_INTEGER, LARGE_INTEGER, DWORD, DWORD, HANDLE, HANDLE, LPVOID );
#endif

/* Stream information levels */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _STREAM_INFO_LEVELS {
    FindStreamInfoStandard,
    FindStreamInfoMaxInfoLevel
} STREAM_INFO_LEVELS;
#endif

/* Structure used with FindFirstStreamW(), etc. */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _WIN32_FIND_STREAM_DATA {
    LARGE_INTEGER   StreamSize;
    WCHAR           cStreamName[MAX_PATH + 36];
} WIN32_FIND_STREAM_DATA;
typedef WIN32_FIND_STREAM_DATA  *PWIN32_FIND_STREAM_DATA;
#endif

/* Pipe attribute types */
typedef enum {
    PipeAttribute,
    PipeConnectionAttribute,
    PipeHandleAttribute
} PIPE_ATTRIBUTE_TYPE;

/* Event log full information */
typedef struct _EVENTLOG_FULL_INFORMATION {
    DWORD   dwFull;
} EVENTLOG_FULL_INFORMATION;
typedef EVENTLOG_FULL_INFORMATION   *LPEVENTLOG_FULL_INFORMATION;

/* Thread pool callback */
#if (_WIN32_WINNT >= 0x0600)
typedef VOID        (WINAPI *PTP_WIN32_IO_CALLBACK)( PTP_CALLBACK_INSTANCE, PVOID, PVOID, ULONG, ULONG_PTR, PTP_IO );
#endif

/* Computer name formats */
#if (_WIN32_WINNT >= 0x0500)
typedef enum _COMPUTER_NAME_FORMAT {
    ComputerNameNetBIOS,
    ComputerNameDnsHostname,
    ComputerNameDnsDomain,
    ComputerNameDnsFullyQualified,
    ComputerNamePhysicalNetBIOS,
    ComputerNamePhysicalDnsHostname,
    ComputerNamePhysicalDnsDomain,
    ComputerNamePhysicalDnsFullyQualified,
    ComputerNameMax
} COMPUTER_NAME_FORMAT;
#endif

/* Hardware profile information */
#if (_WIN32_WINNT >= 0x0400)
typedef struct tagHW_PROFILE_INFOA {
    DWORD   dwDockInfo;
    CHAR    szHwProfileGuid[HW_PROFILE_GUIDLEN];
    CHAR    szHwProfileName[MAX_PROFILE_LEN];
} HW_PROFILE_INFOA;
typedef HW_PROFILE_INFOA    *LPHW_PROFILE_INFOA;
typedef struct tagHW_PROFILE_INFOW {
    DWORD   dwDockInfo;
    WCHAR   szHwProfileGuid[HW_PROFILE_GUIDLEN];
    WCHAR   szHwProfileName[MAX_PROFILE_LEN];
} HW_PROFILE_INFOW;
typedef HW_PROFILE_INFOW    *LPHW_PROFILE_INFOW;
#ifdef UNICODE
typedef HW_PROFILE_INFOW    HW_PROFILE_INFO;
typedef LPHW_PROFILE_INFOW  LPHW_PROFILE_INFO;
#else
typedef HW_PROFILE_INFOA    HW_PROFILE_INFO;
typedef LPHW_PROFILE_INFOA  LPHW_PROFILE_INFO;
#endif
#endif

/* System power status */
#if (WINVER >= 0x0400)
typedef struct _SYSTEM_POWER_STATUS {
    BYTE    ACLineStatus;
    BYTE    BatteryFlag;
    BYTE    BatteryLifePercent;
    BYTE    Reserved1;
    DWORD   BatteryLifeTime;
    DWORD   BatteryFullLifeTime;
} SYSTEM_POWER_STATUS;
typedef SYSTEM_POWER_STATUS *LPSYSTEM_POWER_STATUS;
#endif

/* Activation context */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagACTCTXA {
    ULONG   cbSize;
    DWORD   dwFlags;
    LPCSTR  lpSource;
    USHORT  wProcessorArchitecture;
    LANGID  wLangId;
    LPCSTR  lpAssemblyDirectory;
    LPCSTR  lpResourceName;
    LPCSTR  lpApplicationName;
    HMODULE hModule;
} ACTCTXA;
typedef ACTCTXA         *PACTCTXA;
typedef const ACTCTXA   *PCACTCTXA;
typedef struct tagACTCTXW {
    ULONG   cbSize;
    DWORD   dwFlags;
    LPCWSTR lpSource;
    USHORT  wProcessorArchitecture;
    LANGID  wLangId;
    LPCWSTR lpAssemblyDirectory;
    LPCWSTR lpResourceName;
    LPCWSTR lpApplicationName;
    HMODULE hModule;
} ACTCTXW;
typedef ACTCTXW         *PACTCTXW;
typedef const ACTCTXW   *PCACTCTXW;
#ifdef UNICODE
typedef ACTCTXW         ACTCTX;
typedef PACTCTXW        PACTCTX;
typedef PCACTCTXW       PCACTCTX;
#else
typedef ACTCTXA         ACTCTX;
typedef PACTCTXA        PACTCTX;
typedef PCACTCTXA       PCACTCTX;
#endif
#endif

/* Activation context section keyed data (version from build 2600) */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagACTCTX_SECTION_KEYED_DATA_2600 {
    ULONG   cbSize;
    ULONG   ulDataFormatVersion;
    PVOID   lpData;
    ULONG   ulLength;
    PVOID   lpSectionGlobalData;
    ULONG   ulSectionGlobalDataLength;
    PVOID   lpSectionBase;
    ULONG   ulSectionTotalLength;
    HANDLE  hActCtx;
    ULONG   ulAssemblyRosterIndex;
} ACTCTX_SECTION_KEYED_DATA_2600;
typedef ACTCTX_SECTION_KEYED_DATA_2600          *PACTCTX_SECTION_KEYED_DATA_2600;
typedef const ACTCTX_SECTION_KEYED_DATA_2600    *PCACTCTX_SECTION_KEYED_DATA_2600;
#endif

/* Activation context section keyed data assembly metadata */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA {
    PVOID   lpInformation;
    PVOID   lpSectionBase;
    ULONG   ulSectionLength;
    PVOID   lpSectionGlobalDataBase;
    ULONG   ulSectionGlobalDataLength;
} ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA;
typedef ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA         *PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA;
typedef const ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA   *PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA;
#endif

/* Activation context section keyed data */
#if (_WIN32_WINNT >= 0x0500)
typedef struct tagACTCTX_SECTION_KEYED_DATA {
    ULONG                                       cbSize;
    ULONG                                       ulDataFormatVersion;
    PVOID                                       lpData;
    ULONG                                       ulLength;
    PVOID                                       lpSectionGlobalData;
    ULONG                                       ulSectionGlobalDataLength;
    PVOID                                       lpSectionBase;
    ULONG                                       ulSectionTotalLength;
    HANDLE                                      hActCtx;
    ULONG                                       ulAssemblyRosterIndex;
    ULONG                                       ulFlags;
    ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA AssemblyMetadata;
} ACTCTX_SECTION_KEYED_DATA;
typedef ACTCTX_SECTION_KEYED_DATA       *PACTCTX_SECTION_KEYED_DATA;
typedef const ACTCTX_SECTION_KEYED_DATA *PCACTCTX_SECTION_KEYED_DATA;
#endif

/* Activation context basic information */
#if (_WIN32_WINNT >= 0x0500)
typedef struct _ACTIVATION_CONTEXT_BASIC_INFORMATION {
    HANDLE  hActCtx;
    DWORD   dwFlags;
} ACTIVATION_CONTEXT_BASIC_INFORMATION;
typedef ACTIVATION_CONTEXT_BASIC_INFORMATION        *PACTIVATION_CONTEXT_BASIC_INFORMATION;
typedef const ACTIVATION_CONTEXT_BASIC_INFORMATION  *PCACTIVATION_CONTEXT_BASIC_INFORMATION;
#endif

/* Application recovery callback */
typedef DWORD       (WINAPI *APPLICATION_RECOVERY_CALLBACK)( PVOID );

/* By handle file information classes */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _FILE_INFO_BY_HANDLE_CLASS {
    FileBasicInfo                   = 0,
    FileStandardInfo                = 1,
    FileNameInfo                    = 2,
    FileRenameInfo                  = 3,
    FileDispositionInfo             = 4,
    FileAllocationInfo              = 5,
    FileEndOfFileInfo               = 6,
    FileStreamInfo                  = 7,
    FileCompressionInfo             = 8,
    FileAttributeTagInfo            = 9,
    FileIdBothDirectoryInfo         = 10,
    FileIdBothDirectoryRestartInfo  = 11,
    FileIoPriorityHintInfo          = 12,
    FileRemoteProtocolInfo          = 13,
    MaximumFileInfoByHandleClass    = 14
} FILE_INFO_BY_HANDLE_CLASS;
typedef FILE_INFO_BY_HANDLE_CLASS   *PFILE_INFO_BY_HANDLE_CLASS;
#endif

/* File basic information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_BASIC_INFO {
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    DWORD           FileAttributes;
} FILE_BASIC_INFO;
typedef FILE_BASIC_INFO *PFILE_BASIC_INFO;
#endif

/* File standard information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_STANDARD_INFO {
    LARGE_INTEGER   AllocationSize;
    LARGE_INTEGER   EndOfFile;
    DWORD           NumberOfLinks;
    BOOLEAN         DeletePending;
    BOOLEAN         Directory;
} FILE_STANDARD_INFO;
typedef FILE_STANDARD_INFO  *PFILE_STANDARD_INFO;
#endif

/* File name information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_NAME_INFO {
    DWORD   FileNameLength;
    WCHAR   FileName[1];
} FILE_NAME_INFO;
typedef FILE_NAME_INFO  *PFILE_NAME_INFO;
#endif

/* File rename information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_RENAME_INFO {
    BOOLEAN ReplaceIfExists;
    HANDLE  RootDirectory;
    DWORD   FileNameLength;
    WCHAR   FileName[1];
} FILE_RENAME_INFO;
typedef FILE_RENAME_INFO    *PFILE_RENAME_INFO;
#endif

/* File allocation information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_ALLOCATION_INFO {
    LARGE_INTEGER   AllocationSize;
} FILE_ALLOCATION_SIZE;
typedef FILE_ALLOCATION_SIZE    *PFILE_ALLOCATION_SIZE;
#endif

/* File end of file information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_END_OF_FILE_INFO {
    LARGE_INTEGER   EndOfFile;
} FILE_END_OF_FILE_INFO;
typedef FILE_END_OF_FILE_INFO   *PFILE_END_OF_FILE_INFO;
#endif

/* File stream information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_STREAM_INFO {
    DWORD           NextEntryOffset;
    DWORD           StreamNameLength;
    LARGE_INTEGER   StreamSize;
    LARGE_INTEGER   StreamAllocationSize;
    WCHAR           StreamName[1];
} FILE_STREAM_INFO;
typedef FILE_STREAM_INFO    *PFILE_STREAM_INFO;
#endif

/* File compression information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_COMPRESSION_INFO {
    LARGE_INTEGER   CompressedFileSize;
    WORD            CompressionFormat;
    UCHAR           CompressionUnitShift;
    UCHAR           ChunkShift;
    UCHAR           ClusterShift;
    UCHAR           Reserved[3];
} FILE_COMPRESSION_INFO;
typedef FILE_COMPRESSION_INFO   *PFILE_COMPRESSION_INFO;
#endif

/* File attribute tag information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_ATTRIBUTE_TAG_INFO {
    DWORD   FileAttributes;
    DWORD   ReparseTag;
} FILE_ATTRIBUTE_TAG_INFO;
typedef FILE_ATTRIBUTE_TAG_INFO *PFILE_ATTRIBUTE_TAG_INFO;
#endif

/* File disposition information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_DISPOSITION_INFO {
    BOOLEAN DeleteFile;
} FILE_DISPOSITION_INFO;
typedef FILE_DISPOSITION_INFO   *PFILE_DISPOSITION_INFO;
#endif

/* File ID both directory information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_ID_BOTH_DIR_INFO {
    DWORD           NextEntryOffset;
    DWORD           FileIndex;
    LARGE_INTEGER   CreationTime;
    LARGE_INTEGER   LastAccessTime;
    LARGE_INTEGER   LastWriteTime;
    LARGE_INTEGER   ChangeTime;
    LARGE_INTEGER   EndOfFile;
    LARGE_INTEGER   AllocationSize;
    DWORD           FileAttributes;
    DWORD           FileNameLength;
    DWORD           EaSize;
    CCHAR           ShortNameLength;
    WCHAR           ShortName[12];
    LARGE_INTEGER   FileId;
    WCHAR           FileName[1];
} FILE_ID_BOTH_DIR_INFO;
typedef FILE_ID_BOTH_DIR_INFO   *PFILE_ID_BOTH_DIR_INFO;
#endif

/* I/O priority hint types */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _PRIORITY_HINT {
    IoPriorityHintVeryLow       = 0,
    IoPriorityHintLow           = 1,
    IoPriorityHintNormal        = 2,
    MaximumIoPriorityHintType   = 3
} PRIORITY_HINT;
#endif

/* File I/O priority hint information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_IO_PRIORITY_HINT_INFO {
    PRIORITY_HINT   PriorityHint;
} FILE_IO_PRIORITY_HINT_INFO;
typedef FILE_IO_PRIORITY_HINT_INFO  *PFILE_IO_PRIORITY_HINT_INFO;
#endif

#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_REMOTE_PROTOCOL_INFO {
    USHORT  StructureVersion;
    USHORT  StructureSize;
    DWORD   Protocol;
    USHORT  ProtocolMajorVersion;
    USHORT  ProtocolMinorVersion;
    USHORT  ProtocolRevision;
    USHORT  Reserved;
    DWORD   Flags;
    struct {
        DWORD   Reserved[8];
    } GenericReserved;
    struct {
        DWORD   Reserved[16];
    } ProtocolSpecificReserved;
} FILE_REMOTE_PROTOCOL_INFO;
typedef FILE_REMOTE_PROTOCOL_INFO   *PFILE_REMOTE_PROTOCOL_INFO;
#endif

/* File ID types */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _FILE_ID_TYPE {
    FileIdType,
    ObjectIdType,
    MaximumFileIdType
} FILE_ID_TYPE;
typedef FILE_ID_TYPE    *PFILE_ID_TYPE;
#endif

/* File ID descriptor */
#if (_WIN32_WINNT >= 0x0600)
typedef struct _FILE_ID_DESCRIPTOR {
    DWORD           dwSize;
    FILE_ID_TYPE    Type;
    union {
        LARGE_INTEGER   FileId;
        GUID            ObjectId;
    };
} FILE_ID_DESCRIPTOR;
typedef FILE_ID_DESCRIPTOR  *LPFILE_ID_DESCRIPTOR;
#endif

/* Entry point for Win32 applications */
int             WINAPI WinMain( HINSTANCE, HINSTANCE, LPSTR, int );
int             WINAPI wWinMain( HINSTANCE, HINSTANCE, LPWSTR, int );

/* Functions in KERNEL32.DLL */
WINBASEAPI VOID     WINAPI AcquireSRWLockExclusive( PSRWLOCK );
WINBASEAPI VOID     WINAPI AcquireSRWLockShared( PSRWLOCK );
WINBASEAPI ATOM     WINAPI AddAtomA( LPCSTR );
WINBASEAPI ATOM     WINAPI AddAtomW( LPCWSTR );
WINBASEAPI VOID     WINAPI ApplicationRecoveryFinished( BOOL );
WINBASEAPI HRESULT  WINAPI ApplicationRecoveryInProgress( PBOOL );
WINBASEAPI BOOL     WINAPI AreFileApisANSI( VOID );
WINBASEAPI BOOL     WINAPI BackupRead( HANDLE, LPBYTE, DWORD, LPDWORD, BOOL, BOOL, LPVOID * );
WINBASEAPI BOOL     WINAPI BackupSeek( HANDLE, DWORD, DWORD, LPDWORD, LPDWORD, LPVOID * );
WINBASEAPI BOOL     WINAPI BackupWrite( HANDLE, LPBYTE, DWORD, LPDWORD, BOOL, BOOL, LPVOID * );
WINBASEAPI BOOL     WINAPI Beep( DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI BeginUpdateResourceA( LPCSTR, BOOL );
WINBASEAPI HANDLE   WINAPI BeginUpdateResourceW( LPCWSTR, BOOL );
WINBASEAPI BOOL     WINAPI BuildCommDCBA( LPCSTR, LPDCB );
WINBASEAPI BOOL     WINAPI BuildCommDCBAndTimeoutsA( LPCSTR, LPDCB, LPCOMMTIMEOUTS );
WINBASEAPI BOOL     WINAPI BuildCommDCBAndTimeoutsW( LPCWSTR, LPDCB, LPCOMMTIMEOUTS );
WINBASEAPI BOOL     WINAPI BuildCommDCBW( LPCWSTR, LPDCB );
WINBASEAPI BOOL     WINAPI CallNamedPipeA( LPCSTR, LPVOID, DWORD, LPVOID, DWORD, LPDWORD, DWORD );
WINBASEAPI BOOL     WINAPI CallNamedPipeW( LPCWSTR, LPVOID, DWORD, LPVOID, DWORD, LPDWORD, DWORD );
WINBASEAPI BOOL     WINAPI CancelDeviceWakeupRequest( HANDLE );
WINBASEAPI BOOL     WINAPI CancelIo( HANDLE );
WINBASEAPI BOOL     WINAPI CancelIoEx( HANDLE, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI CancelSynchronousIo( HANDLE );
WINBASEAPI BOOL     WINAPI ClearCommBreak( HANDLE );
WINBASEAPI BOOL     WINAPI ClearCommError( HANDLE, LPDWORD, LPCOMSTAT );
WINBASEAPI BOOL     WINAPI CloseHandle( HANDLE );
WINBASEAPI BOOL     WINAPI CommConfigDialogA( LPCSTR, HWND, LPCOMMCONFIG );
WINBASEAPI BOOL     WINAPI CommConfigDialogW( LPCWSTR, HWND, LPCOMMCONFIG );
WINBASEAPI LONG     WINAPI CompareFileTime( CONST FILETIME *, CONST FILETIME * );
WINBASEAPI BOOL     WINAPI ConnectNamedPipe( HANDLE, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI ContinueDebugEvent( DWORD, DWORD, DWORD );
WINBASEAPI BOOL     WINAPI CopyFileA( LPCSTR, LPCSTR, BOOL );
WINBASEAPI BOOL     WINAPI CopyFileW( LPCWSTR, LPCWSTR, BOOL );
WINBASEAPI BOOL     WINAPI CreateDirectoryA( LPCSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI BOOL     WINAPI CreateDirectoryExA( LPCSTR, LPCSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI BOOL     WINAPI CreateDirectoryExW( LPCWSTR, LPCWSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI BOOL     WINAPI CreateDirectoryW( LPCWSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI HANDLE   WINAPI CreateEventA( LPSECURITY_ATTRIBUTES, BOOL, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateEventW( LPSECURITY_ATTRIBUTES, BOOL, BOOL, LPCWSTR );
WINBASEAPI HANDLE   WINAPI CreateFileA( LPCSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES, DWORD, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI CreateFileMappingA( HANDLE, LPSECURITY_ATTRIBUTES, DWORD, DWORD, DWORD, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateFileMappingW( HANDLE, LPSECURITY_ATTRIBUTES, DWORD, DWORD, DWORD, LPCWSTR );
WINBASEAPI HANDLE   WINAPI CreateFileW( LPCWSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES, DWORD, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI CreateIoCompletionPort( HANDLE, HANDLE, ULONG_PTR, DWORD );
WINBASEAPI HANDLE   WINAPI CreateMailslotA( LPCSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES );
WINBASEAPI HANDLE   WINAPI CreateMailslotW( LPCWSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES );
WINBASEAPI HANDLE   WINAPI CreateMutexA( LPSECURITY_ATTRIBUTES, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateMutexW( LPSECURITY_ATTRIBUTES, BOOL, LPCWSTR );
WINBASEAPI HANDLE   WINAPI CreateNamedPipeA( LPCSTR, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, LPSECURITY_ATTRIBUTES );
WINBASEAPI HANDLE   WINAPI CreateNamedPipeW( LPCWSTR, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, LPSECURITY_ATTRIBUTES );
WINBASEAPI BOOL     WINAPI CreatePipe( PHANDLE, PHANDLE, LPSECURITY_ATTRIBUTES, DWORD );
WINBASEAPI BOOL     WINAPI CreateProcessA( LPCSTR, LPSTR, LPSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES, BOOL, DWORD, LPVOID, LPCSTR, LPSTARTUPINFOA, LPPROCESS_INFORMATION );
WINBASEAPI BOOL     WINAPI CreateProcessW( LPCWSTR, LPWSTR, LPSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES, BOOL, DWORD, LPVOID, LPCWSTR, LPSTARTUPINFOW, LPPROCESS_INFORMATION );
WINBASEAPI HANDLE   WINAPI CreateRemoteThread( HANDLE, LPSECURITY_ATTRIBUTES, SIZE_T, LPTHREAD_START_ROUTINE, LPVOID, DWORD, LPDWORD );
WINBASEAPI HANDLE   WINAPI CreateRemoteThreadEx( HANDLE, LPSECURITY_ATTRIBUTES, SIZE_T, LPTHREAD_START_ROUTINE, LPVOID, DWORD, LPPROC_THREAD_ATTRIBUTE_LIST, LPDWORD );
WINBASEAPI HANDLE   WINAPI CreateSemaphoreA( LPSECURITY_ATTRIBUTES, LONG, LONG, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateSemaphoreW( LPSECURITY_ATTRIBUTES, LONG, LONG, LPCWSTR );
WINBASEAPI DWORD    WINAPI CreateTapePartition( HANDLE, DWORD, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateThread( LPSECURITY_ATTRIBUTES, SIZE_T, LPTHREAD_START_ROUTINE, LPVOID, DWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI DebugActiveProcess( DWORD );
WINBASEAPI BOOL     WINAPI DebugActiveProcessStop( DWORD );
WINBASEAPI VOID     WINAPI DebugBreak( VOID );
WINBASEAPI BOOL     WINAPI DebugBreakProcess( HANDLE );
WINBASEAPI BOOL     WINAPI DebugSetProcessKillOnExit( BOOL );
WINBASEAPI PVOID    WINAPI DecodePointer( PVOID );
WINBASEAPI PVOID    WINAPI DecodeSystemPointer( PVOID );
WINBASEAPI BOOL     WINAPI DefineDosDeviceA( DWORD, LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI DefineDosDeviceW( DWORD, LPCWSTR, LPCWSTR );
WINBASEAPI ATOM     WINAPI DeleteAtom( ATOM );
WINBASEAPI VOID     WINAPI DeleteCriticalSection( LPCRITICAL_SECTION );
WINBASEAPI BOOL     WINAPI DeleteFileA( LPCSTR );
WINBASEAPI BOOL     WINAPI DeleteFileW( LPCWSTR );
WINBASEAPI BOOL     WINAPI DeviceIoControl( HANDLE, DWORD, LPVOID, DWORD, LPVOID, DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI DisableThreadLibraryCalls( HMODULE );
WINBASEAPI BOOL     WINAPI DisconnectNamedPipe( HANDLE );
WINBASEAPI BOOL     WINAPI DosDateTimeToFileTime( WORD, WORD, LPFILETIME );
WINBASEAPI BOOL     WINAPI DuplicateHandle( HANDLE, HANDLE, HANDLE, LPHANDLE, DWORD, BOOL, DWORD );
WINBASEAPI PVOID    WINAPI EncodePointer( PVOID );
WINBASEAPI PVOID    WINAPI EncodeSystemPointer( PVOID );
WINBASEAPI BOOL     WINAPI EndUpdateResourceA( HANDLE, BOOL );
WINBASEAPI BOOL     WINAPI EndUpdateResourceW( HANDLE, BOOL );
WINBASEAPI VOID     WINAPI EnterCriticalSection( LPCRITICAL_SECTION );
WINBASEAPI BOOL     WINAPI EnumResourceLanguagesA( HMODULE, LPCSTR, LPCSTR, ENUMRESLANGPROCA, LONG_PTR );
WINBASEAPI BOOL     WINAPI EnumResourceLanguagesExA( HMODULE, LPCSTR, LPCSTR, ENUMRESLANGPROCA, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceLanguagesExW( HMODULE, LPCWSTR, LPCWSTR, ENUMRESLANGPROCW, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceLanguagesW( HMODULE, LPCWSTR, LPCWSTR, ENUMRESLANGPROCW, LONG_PTR );
WINBASEAPI BOOL     WINAPI EnumResourceNamesA( HMODULE, LPCSTR, ENUMRESNAMEPROCA, LONG_PTR );
WINBASEAPI BOOL     WINAPI EnumResourceNamesExA( HMODULE, LPCSTR, ENUMRESNAMEPROCA, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceNamesExW( HMODULE, LPCWSTR, ENUMRESNAMEPROCW, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceNamesW( HMODULE, LPCWSTR, ENUMRESNAMEPROCW, LONG_PTR );
WINBASEAPI BOOL     WINAPI EnumResourceTypesA( HMODULE, ENUMRESTYPEPROCA, LONG_PTR );
WINBASEAPI BOOL     WINAPI EnumResourceTypesExA( HMODULE, ENUMRESTYPEPROCA, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceTypesExW( HMODULE, ENUMRESTYPEPROCW, LONG_PTR, DWORD, LANGID );
WINBASEAPI BOOL     WINAPI EnumResourceTypesW( HMODULE, ENUMRESTYPEPROCW, LONG_PTR );
WINBASEAPI UINT     WINAPI EnumSystemFirmwareTables( DWORD, PVOID, DWORD );
WINBASEAPI DWORD    WINAPI EraseTape( HANDLE, DWORD, BOOL );
WINBASEAPI BOOL     WINAPI EscapeCommFunction( HANDLE, DWORD );
WINBASEAPI DECLSPEC_NORETURN VOID WINAPI ExitProcess( UINT );
WINBASEAPI DECLSPEC_NORETURN VOID WINAPI ExitThread( DWORD );
WINBASEAPI DWORD    WINAPI ExpandEnvironmentStringsA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI ExpandEnvironmentStringsW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI VOID     WINAPI FatalAppExitA( UINT, LPCSTR );
WINBASEAPI VOID     WINAPI FatalAppExitW( UINT, LPCWSTR );
WINBASEAPI VOID     WINAPI FatalExit( int );
WINBASEAPI BOOL     WINAPI FileTimeToDosDateTime( CONST FILETIME *, LPWORD, LPWORD );
WINBASEAPI BOOL     WINAPI FileTimeToLocalFileTime( CONST FILETIME *, LPFILETIME );
WINBASEAPI BOOL     WINAPI FileTimeToSystemTime( CONST FILETIME *, LPSYSTEMTIME );
WINBASEAPI ATOM     WINAPI FindAtomA( LPCSTR );
WINBASEAPI ATOM     WINAPI FindAtomW( LPCWSTR );
WINBASEAPI BOOL     WINAPI FindClose( HANDLE );
WINBASEAPI BOOL     WINAPI FindCloseChangeNotification( HANDLE );
WINBASEAPI HANDLE   WINAPI FindFirstChangeNotificationA( LPCSTR, BOOL, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstChangeNotificationW( LPCWSTR, BOOL, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstFileA( LPCSTR, LPWIN32_FIND_DATAA );
WINBASEAPI HANDLE   WINAPI FindFirstFileW( LPCWSTR, LPWIN32_FIND_DATAW );
WINBASEAPI BOOL     WINAPI FindNextChangeNotification( HANDLE );
WINBASEAPI BOOL     WINAPI FindNextFileA( HANDLE, LPWIN32_FIND_DATAA );
WINBASEAPI BOOL     WINAPI FindNextFileW( HANDLE, LPWIN32_FIND_DATAW );
WINBASEAPI HRSRC    WINAPI FindResourceA( HMODULE, LPCSTR, LPCSTR );
WINBASEAPI HRSRC    WINAPI FindResourceExA( HMODULE, LPCSTR, LPCSTR, WORD );
WINBASEAPI HRSRC    WINAPI FindResourceExW( HMODULE, LPCWSTR, LPCWSTR, WORD );
WINBASEAPI HRSRC    WINAPI FindResourceW( HMODULE, LPCWSTR, LPCWSTR );
WINBASEAPI DWORD    WINAPI FlsAlloc( PFLS_CALLBACK_FUNCTION );
WINBASEAPI BOOL     WINAPI FlsFree( DWORD );
WINBASEAPI PVOID    WINAPI FlsGetValue( DWORD );
WINBASEAPI BOOL     WINAPI FlsSetValue( DWORD, PVOID );
WINBASEAPI BOOL     WINAPI FlushFileBuffers( HANDLE );
WINBASEAPI BOOL     WINAPI FlushInstructionCache( HANDLE, LPCVOID, SIZE_T );
WINBASEAPI BOOL     WINAPI FlushViewOfFile( LPCVOID, SIZE_T );
WINBASEAPI DWORD    WINAPI FormatMessageA( DWORD, LPCVOID, DWORD, DWORD, LPSTR, DWORD, va_list * );
WINBASEAPI DWORD    WINAPI FormatMessageW( DWORD, LPCVOID, DWORD, DWORD, LPWSTR, DWORD, va_list * );
WINBASEAPI BOOL     WINAPI FreeEnvironmentStringsA( LPCH );
WINBASEAPI BOOL     WINAPI FreeEnvironmentStringsW( LPWCH );
WINBASEAPI BOOL     WINAPI FreeLibrary( HMODULE );
WINBASEAPI DECLSPEC_NORETURN VOID WINAPI FreeLibraryAndExitThread( HMODULE, DWORD );
WINBASEAPI BOOL     WINAPI FreeResource( HGLOBAL );
WINBASEAPI HRESULT  WINAPI GetApplicationRecoveryCallback( HANDLE, APPLICATION_RECOVERY_CALLBACK *, PVOID *, PDWORD, PDWORD );
WINBASEAPI HRESULT  WINAPI GetApplicationRestartSettings( HANDLE, PWSTR, PDWORD, PDWORD );
WINBASEAPI UINT     WINAPI GetAtomNameA( ATOM, LPSTR, int );
WINBASEAPI UINT     WINAPI GetAtomNameW( ATOM, LPWSTR, int );
WINBASEAPI BOOL     WINAPI GetBinaryTypeA( LPCSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetBinaryTypeW( LPCWSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetCommConfig( HANDLE, LPCOMMCONFIG, LPDWORD );
WINBASEAPI BOOL     WINAPI GetCommMask( HANDLE, LPDWORD );
WINBASEAPI BOOL     WINAPI GetCommModemStatus( HANDLE, LPDWORD );
WINBASEAPI BOOL     WINAPI GetCommProperties( HANDLE, LPCOMMPROP );
WINBASEAPI BOOL     WINAPI GetCommState( HANDLE, LPDCB );
WINBASEAPI BOOL     WINAPI GetCommTimeouts( HANDLE, LPCOMMTIMEOUTS );
WINBASEAPI LPSTR    WINAPI GetCommandLineA( VOID );
WINBASEAPI LPWSTR   WINAPI GetCommandLineW( VOID );
WINBASEAPI DWORD    WINAPI GetCompressedFileSizeA( LPCSTR, LPDWORD );
WINBASEAPI DWORD    WINAPI GetCompressedFileSizeW( LPCWSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetComputerNameA( LPSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetComputerNameW( LPWSTR, LPDWORD );
WINBASEAPI DWORD    WINAPI GetCurrentDirectoryA( DWORD, LPSTR );
WINBASEAPI DWORD    WINAPI GetCurrentDirectoryW( DWORD, LPWSTR );
WINBASEAPI HANDLE   WINAPI GetCurrentProcess( VOID );
WINBASEAPI DWORD    WINAPI GetCurrentProcessId( VOID );
WINBASEAPI DWORD    WINAPI GetCurrentProcessorNumber( VOID );
WINBASEAPI HANDLE   WINAPI GetCurrentThread( VOID );
WINBASEAPI DWORD    WINAPI GetCurrentThreadId( VOID );
WINBASEAPI BOOL     WINAPI GetDefaultCommConfigA( LPCSTR, LPCOMMCONFIG, LPDWORD );
WINBASEAPI BOOL     WINAPI GetDefaultCommConfigW( LPCWSTR, LPCOMMCONFIG, LPDWORD );
WINBASEAPI BOOL     WINAPI GetDevicePowerState( HANDLE, BOOL * );
WINBASEAPI BOOL     WINAPI GetDiskFreeSpaceA( LPCSTR, LPDWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI GetDiskFreeSpaceExA( LPCSTR, PULARGE_INTEGER, PULARGE_INTEGER, PULARGE_INTEGER );
WINBASEAPI BOOL     WINAPI GetDiskFreeSpaceExW( LPCWSTR, PULARGE_INTEGER, PULARGE_INTEGER, PULARGE_INTEGER );
WINBASEAPI BOOL     WINAPI GetDiskFreeSpaceW( LPCWSTR, LPDWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI UINT     WINAPI GetDriveTypeA( LPCSTR );
WINBASEAPI UINT     WINAPI GetDriveTypeW( LPCWSTR );
WINBASEAPI DWORD    WINAPI GetDynamicTimeZoneInformation( PDYNAMIC_TIME_ZONE_INFORMATION );
WINBASEAPI LPCH     WINAPI GetEnvironmentStringsA( VOID );
WINBASEAPI LPWCH    WINAPI GetEnvironmentStringsW( VOID );
WINBASEAPI DWORD    WINAPI GetEnvironmentVariableA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetEnvironmentVariableW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI UINT     WINAPI GetErrorMode( VOID );
WINBASEAPI BOOL     WINAPI GetExitCodeProcess( HANDLE, LPDWORD );
WINBASEAPI BOOL     WINAPI GetExitCodeThread( HANDLE, LPDWORD );
WINBASEAPI DWORD    WINAPI GetFileAttributesA( LPCSTR );
WINBASEAPI BOOL     WINAPI GetFileAttributesExA( LPCSTR, GET_FILEEX_INFO_LEVELS, LPVOID );
WINBASEAPI BOOL     WINAPI GetFileAttributesExW( LPCWSTR, GET_FILEEX_INFO_LEVELS, LPVOID );
WINBASEAPI DWORD    WINAPI GetFileAttributesW( LPCWSTR );
WINBASEAPI BOOL     WINAPI GetFileBandwidthReservation( HANDLE, LPDWORD, LPDWORD, LPBOOL, LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI GetFileInformationByHandle( HANDLE, LPBY_HANDLE_FILE_INFORMATION );
WINBASEAPI DWORD    WINAPI GetFileSize( HANDLE, LPDWORD );
WINBASEAPI BOOL     WINAPI GetFileSizeEx( HANDLE, PLARGE_INTEGER );
WINBASEAPI BOOL     WINAPI GetFileTime( HANDLE, LPFILETIME, LPFILETIME, LPFILETIME );
WINBASEAPI DWORD    WINAPI GetFileType( HANDLE );
WINBASEAPI DWORD    WINAPI GetFirmwareEnvironmentVariableA( LPCSTR, LPCSTR, PVOID, DWORD );
WINBASEAPI DWORD    WINAPI GetFirmwareEnvironmentVariableW( LPCWSTR, LPCWSTR, PVOID, DWORD );
WINBASEAPI DWORD    WINAPI GetFullPathNameA( LPCSTR, DWORD, LPSTR, LPSTR * );
WINBASEAPI DWORD    WINAPI GetFullPathNameW( LPCWSTR, DWORD, LPWSTR, LPWSTR * );
WINBASEAPI BOOL     WINAPI GetHandleInformation( HANDLE, LPDWORD );
WINBASEAPI DWORD    WINAPI GetLastError( VOID );
WINBASEAPI SIZE_T   WINAPI GetLargePageMinimum( VOID );
WINBASEAPI VOID     WINAPI GetLocalTime( LPSYSTEMTIME );
WINBASEAPI DWORD    WINAPI GetLogicalDriveStringsA( DWORD, LPSTR );
WINBASEAPI DWORD    WINAPI GetLogicalDriveStringsW( DWORD, LPWSTR );
WINBASEAPI DWORD    WINAPI GetLogicalDrives( VOID );
WINBASEAPI BOOL     WINAPI GetLogicalProcessorInformation( PSYSTEM_LOGICAL_PROCESSOR_INFORMATION, PDWORD );
WINBASEAPI DWORD    WINAPI GetLongPathNameA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetLongPathNameW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetMailslotInfo( HANDLE, LPDWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI DWORD    WINAPI GetModuleFileNameA( HMODULE, LPCH, DWORD );
WINBASEAPI DWORD    WINAPI GetModuleFileNameW( HMODULE, LPWCH, DWORD );
WINBASEAPI HMODULE  WINAPI GetModuleHandleA( LPCSTR );
WINBASEAPI HMODULE  WINAPI GetModuleHandleW( LPCWSTR );
WINBASEAPI BOOL     WINAPI GetNamedPipeAttribute( HANDLE, PIPE_ATTRIBUTE_TYPE, PSTR, PVOID, PSIZE_T );
WINBASEAPI BOOL     WINAPI GetNamedPipeClientComputerNameA( HANDLE, LPSTR, ULONG );
WINBASEAPI BOOL     WINAPI GetNamedPipeClientComputerNameW( HANDLE, LPWSTR, ULONG );
WINBASEAPI BOOL     WINAPI GetNamedPipeClientProcessId( HANDLE, PULONG );
WINBASEAPI BOOL     WINAPI GetNamedPipeClientSessionId( HANDLE, PULONG );
WINBASEAPI BOOL     WINAPI GetNamedPipeHandleStateA( HANDLE, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetNamedPipeHandleStateW( HANDLE, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetNamedPipeInfo( HANDLE, LPDWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI GetNamedPipeServerProcessId( HANDLE, PULONG );
WINBASEAPI BOOL     WINAPI GetNamedPipeServerSessionId( HANDLE, PULONG );
WINBASEAPI BOOL     WINAPI GetNumaAvailableMemoryNode( UCHAR, PULONGLONG );
WINBASEAPI BOOL     WINAPI GetNumaHighestNodeNumber( PULONG );
WINBASEAPI BOOL     WINAPI GetNumaNodeProcessorMask( UCHAR, PULONGLONG );
WINBASEAPI BOOL     WINAPI GetNumaProcessorNode( UCHAR, PUCHAR );
WINBASEAPI BOOL     WINAPI GetOverlappedResult( HANDLE, LPOVERLAPPED, LPDWORD, BOOL );
WINBASEAPI BOOL     WINAPI GetPhysicallyInstalledSystemMemory( PULONGLONG );
WINBASEAPI DWORD    WINAPI GetPriorityClass( HANDLE );
WINBASEAPI UINT     WINAPI GetPrivateProfileIntA( LPCSTR, LPCSTR, INT, LPCSTR );
WINBASEAPI UINT     WINAPI GetPrivateProfileIntW( LPCWSTR, LPCWSTR, INT, LPCWSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileSectionA( LPCSTR, LPSTR, DWORD, LPCSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileSectionNamesA( LPSTR, DWORD, LPCSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileSectionNamesW( LPWSTR, DWORD, LPCWSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileSectionW( LPCWSTR, LPWSTR, DWORD, LPCWSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileStringA( LPCSTR, LPCSTR, LPCSTR, LPSTR, DWORD, LPCSTR );
WINBASEAPI DWORD    WINAPI GetPrivateProfileStringW( LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, DWORD, LPCWSTR );
WINBASEAPI BOOL     WINAPI GetPrivateProfileStructA( LPCSTR, LPCSTR, LPVOID, UINT, LPCSTR );
WINBASEAPI BOOL     WINAPI GetPrivateProfileStructW( LPCWSTR, LPCWSTR, LPVOID, UINT, LPCWSTR );
WINBASEAPI FARPROC  WINAPI GetProcAddress( HMODULE, LPCSTR );
WINBASEAPI BOOL     WINAPI GetProcessAffinityMask( HANDLE, PDWORD_PTR, PDWORD_PTR );
WINBASEAPI HANDLE   WINAPI GetProcessHeap( VOID );
WINBASEAPI DWORD    WINAPI GetProcessHeaps( DWORD, PHANDLE );
WINBASEAPI DWORD    WINAPI GetProcessId( HANDLE );
WINBASEAPI DWORD    WINAPI GetProcessIdOfThread( HANDLE );
WINBASEAPI BOOL     WINAPI GetProcessIoCounters( HANDLE, PIO_COUNTERS );
WINBASEAPI BOOL     WINAPI GetProcessPriorityBoost( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI GetProcessShutdownParameters( LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI GetProcessTimes( HANDLE, LPFILETIME, LPFILETIME, LPFILETIME, LPFILETIME );
WINBASEAPI DWORD    WINAPI GetProcessVersion( DWORD );
WINBASEAPI BOOL     WINAPI GetProcessWorkingSetSize( HANDLE, PSIZE_T, PSIZE_T );
WINBASEAPI BOOL     WINAPI GetProcessWorkingSetSizeEx( HANDLE, PSIZE_T, PSIZE_T, PDWORD );
WINBASEAPI UINT     WINAPI GetProfileIntA( LPCSTR, LPCSTR, INT );
WINBASEAPI UINT     WINAPI GetProfileIntW( LPCWSTR, LPCWSTR, INT );
WINBASEAPI DWORD    WINAPI GetProfileSectionA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetProfileSectionW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetProfileStringA( LPCSTR, LPCSTR, LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetProfileStringW( LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetQueuedCompletionStatus( HANDLE, LPDWORD, PULONG_PTR, LPOVERLAPPED *, DWORD );
WINBASEAPI DWORD    WINAPI GetShortPathNameA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI GetShortPathNameW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI VOID     WINAPI GetStartupInfoA( LPSTARTUPINFOA );
WINBASEAPI VOID     WINAPI GetStartupInfoW( LPSTARTUPINFOW );
WINBASEAPI HANDLE   WINAPI GetStdHandle( DWORD );
WINBASEAPI DEP_SYSTEM_POLICY_TYPE WINAPI GetSystemDEPPolicy( VOID );
WINBASEAPI UINT     WINAPI GetSystemDirectoryA( LPSTR, UINT );
WINBASEAPI UINT     WINAPI GetSystemDirectoryW( LPWSTR, UINT );
WINBASEAPI UINT     WINAPI GetSystemFirmwareTable( DWORD, DWORD, PVOID, DWORD );
WINBASEAPI VOID     WINAPI GetSystemInfo( LPSYSTEM_INFO );
WINBASEAPI VOID     WINAPI GetSystemTime( LPSYSTEMTIME );
WINBASEAPI BOOL     WINAPI GetSystemTimeAdjustment( PDWORD, PDWORD, PBOOL );
WINBASEAPI VOID     WINAPI GetSystemTimeAsFileTime( LPFILETIME );
WINBASEAPI UINT     WINAPI GetSystemWindowsDirectoryA( LPSTR, UINT );
WINBASEAPI UINT     WINAPI GetSystemWindowsDirectoryW( LPWSTR, UINT );
WINBASEAPI DWORD    WINAPI GetTapeParameters( HANDLE, DWORD, LPDWORD, LPVOID );
WINBASEAPI DWORD    WINAPI GetTapePosition( HANDLE, DWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI DWORD    WINAPI GetTapeStatus( HANDLE );
WINBASEAPI UINT     WINAPI GetTempFileNameA( LPCSTR, LPCSTR, UINT, LPSTR );
WINBASEAPI UINT     WINAPI GetTempFileNameW( LPCWSTR, LPCWSTR, UINT, LPWSTR );
WINBASEAPI DWORD    WINAPI GetTempPathA( DWORD, LPSTR );
WINBASEAPI DWORD    WINAPI GetTempPathW( DWORD, LPWSTR );
WINBASEAPI BOOL     WINAPI GetThreadContext( HANDLE, LPCONTEXT );
WINBASEAPI DWORD    WINAPI GetThreadErrorMode( VOID );
WINBASEAPI int      WINAPI GetThreadPriority( HANDLE );
WINBASEAPI BOOL     WINAPI GetThreadPriorityBoost( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI GetThreadSelectorEntry( HANDLE, DWORD, LPLDT_ENTRY );
WINBASEAPI BOOL     WINAPI GetThreadTimes( HANDLE, LPFILETIME, LPFILETIME, LPFILETIME, LPFILETIME );
WINBASEAPI DWORD    WINAPI GetTickCount( VOID );
WINBASEAPI DWORD    WINAPI GetTimeZoneInformation( LPTIME_ZONE_INFORMATION );
WINBASEAPI BOOL     WINAPI GetTimeZoneInformationForYear( USHORT, PDYNAMIC_TIME_ZONE_INFORMATION, LPTIME_ZONE_INFORMATION );
WINBASEAPI DWORD    WINAPI GetVersion( VOID );
WINBASEAPI BOOL     WINAPI GetVersionExA( LPOSVERSIONINFOA );
WINBASEAPI BOOL     WINAPI GetVersionExW( LPOSVERSIONINFOW );
WINBASEAPI BOOL     WINAPI GetVolumeInformationA( LPCSTR, LPSTR, DWORD, LPDWORD, LPDWORD, LPDWORD, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetVolumeInformationW( LPCWSTR, LPWSTR, DWORD, LPDWORD, LPDWORD, LPDWORD, LPWSTR, DWORD );
WINBASEAPI UINT     WINAPI GetWindowsDirectoryA( LPSTR, UINT );
WINBASEAPI UINT     WINAPI GetWindowsDirectoryW( LPWSTR, UINT );
WINBASEAPI UINT     WINAPI GetWriteWatch( DWORD, PVOID, SIZE_T, PVOID *, ULONG_PTR *, PULONG );
WINBASEAPI ATOM     WINAPI GlobalAddAtomA( LPCSTR );
WINBASEAPI ATOM     WINAPI GlobalAddAtomW( LPCWSTR );
WINBASEAPI HGLOBAL  WINAPI GlobalAlloc( UINT, SIZE_T );
WINBASEAPI SIZE_T   WINAPI GlobalCompact( DWORD );
WINBASEAPI ATOM     WINAPI GlobalDeleteAtom( ATOM );
WINBASEAPI ATOM     WINAPI GlobalFindAtomA( LPCSTR );
WINBASEAPI ATOM     WINAPI GlobalFindAtomW( LPCWSTR );
WINBASEAPI VOID     WINAPI GlobalFix( HGLOBAL );
WINBASEAPI UINT     WINAPI GlobalFlags( HGLOBAL );
WINBASEAPI HGLOBAL  WINAPI GlobalFree( HGLOBAL );
WINBASEAPI UINT     WINAPI GlobalGetAtomNameA( ATOM, LPSTR, int );
WINBASEAPI UINT     WINAPI GlobalGetAtomNameW( ATOM, LPWSTR, int );
WINBASEAPI HGLOBAL  WINAPI GlobalHandle( LPCVOID );
WINBASEAPI LPVOID   WINAPI GlobalLock( LPVOID );
WINBASEAPI VOID     WINAPI GlobalMemoryStatus( LPMEMORYSTATUS );
WINBASEAPI BOOL     WINAPI GlobalMemoryStatusEx( LPMEMORYSTATUSEX );
WINBASEAPI HGLOBAL  WINAPI GlobalReAlloc( HGLOBAL, SIZE_T, UINT );
WINBASEAPI SIZE_T   WINAPI GlobalSize( HGLOBAL );
WINBASEAPI BOOL     WINAPI GlobalUnWire( HGLOBAL );
WINBASEAPI VOID     WINAPI GlobalUnfix( HGLOBAL );
WINBASEAPI BOOL     WINAPI GlobalUnlock( HGLOBAL );
WINBASEAPI LPVOID   WINAPI GlobalWire( HGLOBAL );
WINBASEAPI LPVOID   WINAPI HeapAlloc( HANDLE, DWORD, SIZE_T );
WINBASEAPI SIZE_T   WINAPI HeapCompact( HANDLE, DWORD );
WINBASEAPI HANDLE   WINAPI HeapCreate( DWORD, SIZE_T, SIZE_T );
WINBASEAPI BOOL     WINAPI HeapDestroy( HANDLE );
WINBASEAPI BOOL     WINAPI HeapFree( HANDLE, DWORD, LPVOID );
WINBASEAPI BOOL     WINAPI HeapLock( HANDLE );
WINBASEAPI BOOL     WINAPI HeapQueryInformation( HANDLE, HEAP_INFORMATION_CLASS, PVOID, SIZE_T, PSIZE_T );
WINBASEAPI LPVOID   WINAPI HeapReAlloc( HANDLE, DWORD, LPVOID, SIZE_T );
WINBASEAPI BOOL     WINAPI HeapSetInformation( HANDLE, HEAP_INFORMATION_CLASS, PVOID, SIZE_T );
WINBASEAPI SIZE_T   WINAPI HeapSize( HANDLE, DWORD, LPCVOID );
WINBASEAPI BOOL     WINAPI HeapUnlock( HANDLE );
WINBASEAPI BOOL     WINAPI HeapValidate( HANDLE, DWORD, LPCVOID );
WINBASEAPI BOOL     WINAPI HeapWalk( HANDLE, LPPROCESS_HEAP_ENTRY );
WINBASEAPI BOOL     WINAPI InitAtomTable( DWORD );
WINBASEAPI VOID     WINAPI InitializeConditionVariable( PCONDITION_VARIABLE );
WINBASEAPI VOID     WINAPI InitializeCriticalSection( LPCRITICAL_SECTION );
WINBASEAPI VOID     WINAPI InitializeSListHead( PSLIST_HEADER );
WINBASEAPI VOID     WINAPI InitializeSRWLock( PSRWLOCK );
WINBASEAPI LONG     WINAPI InterlockedCompareExchange( LONG volatile *, LONG, LONG );
WINBASEAPI LONG     WINAPI InterlockedDecrement( LONG volatile * );
WINBASEAPI LONG     WINAPI InterlockedExchange( LONG volatile *, LONG );
WINBASEAPI LONG     WINAPI InterlockedExchangeAdd( LONG volatile *, LONG );
WINBASEAPI PSLIST_ENTRY WINAPI InterlockedFlushSList( PSLIST_HEADER );
WINBASEAPI LONG     WINAPI InterlockedIncrement( LONG volatile * );
WINBASEAPI PSLIST_ENTRY WINAPI InterlockedPopEntrySList( PSLIST_HEADER );
WINBASEAPI PSLIST_ENTRY WINAPI InterlockedPushEntrySList( PSLIST_HEADER, PSLIST_ENTRY );
WINBASEAPI BOOL     WINAPI IsBadCodePtr( FARPROC );
WINBASEAPI BOOL     WINAPI IsBadHugeReadPtr( CONST VOID*, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsBadHugeWritePtr( LPVOID, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsBadReadPtr( CONST VOID *, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsBadStringPtrA( LPCSTR, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsBadStringPtrW( LPCWSTR, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsBadWritePtr( LPVOID, UINT_PTR );
WINBASEAPI BOOL     WINAPI IsProcessorFeaturePresent( DWORD );
WINBASEAPI BOOL     WINAPI IsSystemResumeAutomatic( VOID );
WINBASEAPI VOID     WINAPI LeaveCriticalSection( LPCRITICAL_SECTION );
WINBASEAPI HMODULE  WINAPI LoadLibraryA( LPCSTR );
WINBASEAPI HMODULE  WINAPI LoadLibraryExA( LPCSTR, HANDLE, DWORD );
WINBASEAPI HMODULE  WINAPI LoadLibraryExW( LPCWSTR, HANDLE, DWORD );
WINBASEAPI HMODULE  WINAPI LoadLibraryW( LPCWSTR );
WINBASEAPI DWORD    WINAPI LoadModule( LPCSTR, LPVOID );
WINBASEAPI HGLOBAL  WINAPI LoadResource( HMODULE, HRSRC );
WINBASEAPI HLOCAL   WINAPI LocalAlloc( UINT, SIZE_T );
WINBASEAPI SIZE_T   WINAPI LocalCompact( UINT );
WINBASEAPI BOOL     WINAPI LocalFileTimeToFileTime( CONST FILETIME *, LPFILETIME );
WINBASEAPI UINT     WINAPI LocalFlags( HLOCAL );
WINBASEAPI HLOCAL   WINAPI LocalFree( HLOCAL );
WINBASEAPI HLOCAL   WINAPI LocalHandle( LPCVOID );
WINBASEAPI LPVOID   WINAPI LocalLock( HLOCAL );
WINBASEAPI HLOCAL   WINAPI LocalReAlloc( HLOCAL, SIZE_T, UINT );
WINBASEAPI SIZE_T   WINAPI LocalShrink( HLOCAL, UINT );
WINBASEAPI SIZE_T   WINAPI LocalSize( HLOCAL );
WINBASEAPI BOOL     WINAPI LocalUnlock( HLOCAL );
WINBASEAPI BOOL     WINAPI LockFile( HANDLE, DWORD, DWORD, DWORD, DWORD );
WINBASEAPI BOOL     WINAPI LockFileEx( HANDLE, DWORD, DWORD, DWORD, DWORD, LPOVERLAPPED );
WINBASEAPI LPVOID   WINAPI LockResource( HGLOBAL );
WINBASEAPI LPVOID   WINAPI MapViewOfFile( HANDLE, DWORD, DWORD, DWORD, SIZE_T );
WINBASEAPI LPVOID   WINAPI MapViewOfFileEx( HANDLE, DWORD, DWORD, DWORD, SIZE_T, LPVOID );
WINBASEAPI BOOL     WINAPI MoveFileA( LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI MoveFileExA( LPCSTR, LPCSTR, DWORD );
WINBASEAPI BOOL     WINAPI MoveFileExW( LPCWSTR, LPCWSTR, DWORD );
WINBASEAPI BOOL     WINAPI MoveFileW( LPCWSTR, LPCWSTR );
WINBASEAPI int      WINAPI MulDiv( int, int, int );
WINBASEAPI HANDLE   WINAPI OpenEventA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenEventW( DWORD, BOOL, LPCWSTR );
WINBASEAPI HFILE    WINAPI OpenFile( LPCSTR, LPOFSTRUCT, UINT );
WINBASEAPI HANDLE   WINAPI OpenFileMappingA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenFileMappingW( DWORD, BOOL, LPCWSTR );
WINBASEAPI HANDLE   WINAPI OpenMutexA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenMutexW( DWORD, BOOL, LPCWSTR );
WINBASEAPI HANDLE   WINAPI OpenProcess( DWORD, BOOL, DWORD );
WINBASEAPI HANDLE   WINAPI OpenSemaphoreA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenSemaphoreW( DWORD, BOOL, LPCWSTR );
WINBASEAPI HANDLE   WINAPI OpenThread( DWORD, BOOL, DWORD );
WINBASEAPI VOID     WINAPI OutputDebugStringA( LPCSTR );
WINBASEAPI VOID     WINAPI OutputDebugStringW( LPCWSTR );
WINBASEAPI BOOL     WINAPI PeekNamedPipe( HANDLE, LPVOID, DWORD, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI PostQueuedCompletionStatus( HANDLE, DWORD, ULONG_PTR, LPOVERLAPPED );
WINBASEAPI DWORD    WINAPI PrepareTape( HANDLE, DWORD, BOOL );
WINBASEAPI BOOL     WINAPI ProcessIdToSessionId( DWORD, DWORD * );
WINBASEAPI BOOL     WINAPI PulseEvent( HANDLE );
WINBASEAPI BOOL     WINAPI PurgeComm( HANDLE, DWORD );
WINBASEAPI USHORT   WINAPI QueryDepthSList( PSLIST_HEADER );
WINBASEAPI DWORD    WINAPI QueryDosDeviceA( LPCSTR, LPSTR, DWORD );
WINBASEAPI DWORD    WINAPI QueryDosDeviceW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI QueryPerformanceCounter( LARGE_INTEGER * );
WINBASEAPI BOOL     WINAPI QueryPerformanceFrequency( LARGE_INTEGER * );
WINBASEAPI VOID     WINAPI RaiseException( DWORD, DWORD, DWORD, CONST ULONG_PTR * );
WINBASEAPI VOID     WINAPI RaiseFailFastException( PEXCEPTION_RECORD, PCONTEXT, DWORD );
WINBASEAPI BOOL     WINAPI ReadFile( HANDLE, LPVOID, DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI ReadFileEx( HANDLE, LPVOID, DWORD, LPOVERLAPPED, LPOVERLAPPED_COMPLETION_ROUTINE );
WINBASEAPI BOOL     WINAPI ReadFileScatter( HANDLE, FILE_SEGMENT_ELEMENT [], DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI ReadProcessMemory( HANDLE, LPCVOID, LPVOID, SIZE_T, SIZE_T * );
WINBASEAPI HRESULT  WINAPI RegisterApplicationRecoveryCallback( APPLICATION_RECOVERY_CALLBACK, PVOID, DWORD, DWORD );
WINBASEAPI HRESULT  WINAPI RegisterApplicationRestart( PCWSTR, DWORD );
WINBASEAPI BOOL     WINAPI ReleaseMutex( HANDLE );
WINBASEAPI VOID     WINAPI ReleaseSRWLockExclusive( PSRWLOCK );
WINBASEAPI VOID     WINAPI ReleaseSRWLockShared( PSRWLOCK );
WINBASEAPI BOOL     WINAPI ReleaseSemaphore( HANDLE, LONG, LPLONG );
WINBASEAPI BOOL     WINAPI RemoveDirectoryA( LPCSTR );
WINBASEAPI BOOL     WINAPI RemoveDirectoryW( LPCWSTR );
WINBASEAPI BOOL     WINAPI RequestDeviceWakeup( HANDLE );
WINBASEAPI BOOL     WINAPI RequestWakeupLatency( LATENCY_TIME );
WINBASEAPI BOOL     WINAPI ResetEvent( HANDLE );
WINBASEAPI UINT     WINAPI ResetWriteWatch( LPVOID, SIZE_T );
WINBASEAPI VOID     WINAPI RestoreLastError( DWORD );
WINBASEAPI DWORD    WINAPI ResumeThread( HANDLE );
WINBASEAPI DWORD    WINAPI SearchPathA( LPCSTR, LPCSTR, LPCSTR, DWORD, LPSTR, LPSTR * );
WINBASEAPI DWORD    WINAPI SearchPathW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, LPWSTR, LPWSTR * );
WINBASEAPI BOOL     WINAPI SetCommBreak( HANDLE );
WINBASEAPI BOOL     WINAPI SetCommConfig( HANDLE, LPCOMMCONFIG, DWORD );
WINBASEAPI BOOL     WINAPI SetCommMask( HANDLE, DWORD );
WINBASEAPI BOOL     WINAPI SetCommState( HANDLE, LPDCB );
WINBASEAPI BOOL     WINAPI SetCommTimeouts( HANDLE, LPCOMMTIMEOUTS );
WINBASEAPI BOOL     WINAPI SetComputerNameA( LPCSTR );
WINBASEAPI BOOL     WINAPI SetComputerNameW( LPCWSTR );
WINBASEAPI BOOL     WINAPI SetCurrentDirectoryA( LPCSTR );
WINBASEAPI BOOL     WINAPI SetCurrentDirectoryW( LPCWSTR );
WINBASEAPI BOOL     WINAPI SetDefaultCommConfigA( LPCSTR, LPCOMMCONFIG, DWORD );
WINBASEAPI BOOL     WINAPI SetDefaultCommConfigW( LPCWSTR, LPCOMMCONFIG, DWORD );
WINBASEAPI BOOL     WINAPI SetDynamicTimeZoneInformation( CONST DYNAMIC_TIME_ZONE_INFORMATION * );
WINBASEAPI BOOL     WINAPI SetEndOfFile( HANDLE );
WINBASEAPI BOOL     WINAPI SetEnvironmentStringsA( LPCH );
WINBASEAPI BOOL     WINAPI SetEnvironmentStringsW( LPWCH );
WINBASEAPI BOOL     WINAPI SetEnvironmentVariableA( LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI SetEnvironmentVariableW( LPCWSTR, LPCWSTR );
WINBASEAPI UINT     WINAPI SetErrorMode( UINT );
WINBASEAPI BOOL     WINAPI SetEvent( HANDLE );
WINBASEAPI VOID     WINAPI SetFileApisToANSI( VOID );
WINBASEAPI VOID     WINAPI SetFileApisToOEM( VOID );
WINBASEAPI BOOL     WINAPI SetFileAttributesA( LPCSTR, DWORD );
WINBASEAPI BOOL     WINAPI SetFileAttributesW( LPCWSTR, DWORD );
WINBASEAPI BOOL     WINAPI SetFileBandwidthReservation( HANDLE, DWORD, DWORD, BOOL, LPDWORD, LPDWORD );
WINBASEAPI DWORD    WINAPI SetFilePointer( HANDLE, LONG, PLONG, DWORD );
WINBASEAPI BOOL     WINAPI SetFilePointerEx( HANDLE, LARGE_INTEGER, PLARGE_INTEGER, DWORD );
WINBASEAPI BOOL     WINAPI SetFileShortNameA( HANDLE, LPCSTR );
WINBASEAPI BOOL     WINAPI SetFileShortNameW( HANDLE, LPCWSTR );
WINBASEAPI BOOL     WINAPI SetFileTime( HANDLE, CONST FILETIME *, CONST FILETIME *, CONST FILETIME * );
WINBASEAPI BOOL     WINAPI SetFirmwareEnvironmentVariableA( LPCSTR, LPCSTR, PVOID, DWORD );
WINBASEAPI BOOL     WINAPI SetFirmwareEnvironmentVariableW( LPCWSTR, LPCWSTR, PVOID, DWORD );
WINBASEAPI UINT     WINAPI SetHandleCount( UINT );
WINBASEAPI BOOL     WINAPI SetHandleInformation( HANDLE, DWORD, DWORD );
WINBASEAPI VOID     WINAPI SetLastError( DWORD );
WINBASEAPI BOOL     WINAPI SetLocalTime( CONST SYSTEMTIME * );
WINBASEAPI BOOL     WINAPI SetMailslotInfo( HANDLE, DWORD );
WINBASEAPI BOOL     WINAPI SetMessageWaitingIndicator( HANDLE, ULONG );
WINBASEAPI BOOL     WINAPI SetNamedPipeAttribute( HANDLE, PIPE_ATTRIBUTE_TYPE, PSTR, PVOID, SIZE_T );
WINBASEAPI BOOL     WINAPI SetNamedPipeHandleState( HANDLE, LPDWORD, LPDWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI SetPriorityClass( HANDLE, DWORD );
WINBASEAPI BOOL     WINAPI SetProcessAffinityMask( HANDLE, DWORD_PTR );
WINBASEAPI BOOL     WINAPI SetProcessPriorityBoost( HANDLE, BOOL );
WINBASEAPI BOOL     WINAPI SetProcessShutdownParameters( DWORD, DWORD );
WINBASEAPI BOOL     WINAPI SetProcessWorkingSetSize( HANDLE, SIZE_T, SIZE_T );
WINBASEAPI BOOL     WINAPI SetProcessWorkingSetSizeEx( HANDLE, SIZE_T, SIZE_T, DWORD );
WINBASEAPI BOOL     WINAPI SetSearchPathMode( DWORD );
WINBASEAPI BOOL     WINAPI SetStdHandle( DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI SetSystemTime( CONST SYSTEMTIME * );
WINBASEAPI BOOL     WINAPI SetSystemTimeAdjustment( DWORD, BOOL );
WINBASEAPI DWORD    WINAPI SetTapeParameters( HANDLE, DWORD, LPVOID );
WINBASEAPI DWORD    WINAPI SetTapePosition( HANDLE, DWORD, DWORD, DWORD, DWORD, BOOL );
WINBASEAPI DWORD_PTR WINAPI SetThreadAffinityMask( HANDLE, DWORD_PTR );
WINBASEAPI BOOL     WINAPI SetThreadContext( HANDLE, CONST CONTEXT * );
WINBASEAPI BOOL     WINAPI SetThreadErrorMode( DWORD, LPDWORD );
WINBASEAPI EXECUTION_STATE WINAPI SetThreadExecutionState( EXECUTION_STATE );
WINBASEAPI BOOL     WINAPI SetThreadPriority( HANDLE, int );
WINBASEAPI BOOL     WINAPI SetThreadPriorityBoost( HANDLE, BOOL );
WINBASEAPI BOOL     WINAPI SetThreadStackGuarantee( PULONG );
WINBASEAPI BOOL     WINAPI SetTimeZoneInformation( CONST TIME_ZONE_INFORMATION * );
WINBASEAPI LPTOP_LEVEL_EXCEPTION_FILTER WINAPI SetUnhandledExceptionFilter( LPTOP_LEVEL_EXCEPTION_FILTER );
WINBASEAPI BOOL     WINAPI SetVolumeLabelA( LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI SetVolumeLabelW( LPCWSTR, LPCWSTR );
WINBASEAPI BOOL     WINAPI SetupComm( HANDLE, DWORD, DWORD );
WINBASEAPI DWORD    WINAPI SizeofResource( HMODULE, HRSRC );
WINBASEAPI VOID     WINAPI Sleep( DWORD );
WINBASEAPI BOOL     WINAPI SleepConditionVariableCS( PCONDITION_VARIABLE, PCRITICAL_SECTION, DWORD );
WINBASEAPI BOOL     WINAPI SleepConditionVariableSRW( PCONDITION_VARIABLE, PSRWLOCK, DWORD, ULONG );
WINBASEAPI DWORD    WINAPI SleepEx( DWORD, BOOL );
WINBASEAPI DWORD    WINAPI SuspendThread( HANDLE );
WINBASEAPI BOOL     WINAPI SystemTimeToFileTime( CONST SYSTEMTIME *, LPFILETIME );
WINBASEAPI BOOL     WINAPI SystemTimeToTzSpecificLocalTime( LPTIME_ZONE_INFORMATION, LPSYSTEMTIME, LPSYSTEMTIME );
WINBASEAPI BOOL     WINAPI TerminateProcess( HANDLE, UINT );
WINBASEAPI BOOL     WINAPI TerminateThread( HANDLE, DWORD );
WINBASEAPI DWORD    WINAPI TlsAlloc( VOID );
WINBASEAPI BOOL     WINAPI TlsFree( DWORD );
WINBASEAPI LPVOID   WINAPI TlsGetValue( DWORD );
WINBASEAPI BOOL     WINAPI TlsSetValue( DWORD, LPVOID );
WINBASEAPI BOOL     WINAPI TransactNamedPipe( HANDLE, LPVOID, DWORD, LPVOID, DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI TransmitCommChar( HANDLE, char );
WINBASEAPI BOOLEAN  WINAPI TryAcquireSRWLockExclusive( PSRWLOCK );
WINBASEAPI BOOLEAN  WINAPI TryAcquireSRWLockShared( PSRWLOCK );
WINBASEAPI BOOL     WINAPI TzSpecificLocalTimeToSystemTime( CONST TIME_ZONE_INFORMATION *, LPSYSTEMTIME, LPSYSTEMTIME );
WINBASEAPI LONG     WINAPI UnhandledExceptionFilter( struct _EXCEPTION_POINTERS * );
WINBASEAPI BOOL     WINAPI UnlockFile( HANDLE, DWORD, DWORD, DWORD, DWORD );
WINBASEAPI BOOL     WINAPI UnlockFileEx( HANDLE, DWORD, DWORD, DWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI UnmapViewOfFile( LPCVOID );
WINBASEAPI HRESULT  WINAPI UnregisterApplicationRecoveryCallback( void );
WINBASEAPI HRESULT  WINAPI UnregisterApplicationRestart( void );
WINBASEAPI BOOL     WINAPI UpdateResourceA( HANDLE, LPCSTR, LPCSTR, WORD, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI UpdateResourceW( HANDLE, LPCWSTR, LPCWSTR, WORD, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI VerifyVersionInfoA( LPOSVERSIONINFOEXA, DWORD, DWORDLONG );
WINBASEAPI BOOL     WINAPI VerifyVersionInfoW( LPOSVERSIONINFOEXW, DWORD, DWORDLONG );
WINBASEAPI LPVOID   WINAPI VirtualAlloc( LPVOID, SIZE_T, DWORD, DWORD );
WINBASEAPI LPVOID   WINAPI VirtualAllocEx( HANDLE, LPVOID, SIZE_T, DWORD, DWORD );
WINBASEAPI BOOL     WINAPI VirtualFree( LPVOID, SIZE_T, DWORD );
WINBASEAPI BOOL     WINAPI VirtualFreeEx( HANDLE, LPVOID, SIZE_T, DWORD );
WINBASEAPI BOOL     WINAPI VirtualLock( LPVOID, SIZE_T );
WINBASEAPI BOOL     WINAPI VirtualProtect( LPVOID, SIZE_T, DWORD, PDWORD );
WINBASEAPI BOOL     WINAPI VirtualProtectEx( HANDLE, LPVOID, SIZE_T, DWORD, PDWORD );
WINBASEAPI SIZE_T   WINAPI VirtualQuery( LPCVOID, PMEMORY_BASIC_INFORMATION, SIZE_T );
WINBASEAPI SIZE_T   WINAPI VirtualQueryEx( HANDLE, LPCVOID, PMEMORY_BASIC_INFORMATION, SIZE_T );
WINBASEAPI BOOL     WINAPI VirtualUnlock( LPVOID, SIZE_T );
WINBASEAPI BOOL     WINAPI WaitCommEvent( HANDLE, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI WaitForDebugEvent( LPDEBUG_EVENT, DWORD );
WINBASEAPI DWORD    WINAPI WaitForMultipleObjects( DWORD, CONST HANDLE *, BOOL, DWORD );
WINBASEAPI DWORD    WINAPI WaitForMultipleObjectsEx( DWORD, CONST HANDLE *, BOOL, DWORD, BOOL );
WINBASEAPI DWORD    WINAPI WaitForSingleObject( HANDLE, DWORD );
WINBASEAPI DWORD    WINAPI WaitForSingleObjectEx( HANDLE, DWORD, BOOL );
WINBASEAPI BOOL     WINAPI WaitNamedPipeA( LPCSTR, DWORD );
WINBASEAPI BOOL     WINAPI WaitNamedPipeW( LPCWSTR, DWORD );
WINBASEAPI VOID     WINAPI WakeAllConditionVariable( PCONDITION_VARIABLE );
WINBASEAPI VOID     WINAPI WakeConditionVariable( PCONDITION_VARIABLE );
WINBASEAPI UINT     WINAPI WinExec( LPCSTR, UINT );
WINBASEAPI BOOL     WINAPI Wow64GetThreadContext( HANDLE, PWOW64_CONTEXT );
WINBASEAPI BOOL     WINAPI Wow64SetThreadContext( HANDLE, CONST WOW64_CONTEXT * );
WINBASEAPI DWORD    WINAPI Wow64SuspendThread( HANDLE );
WINBASEAPI BOOL     WINAPI WriteFile( HANDLE, LPCVOID, DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI WriteFileEx( HANDLE, LPCVOID, DWORD, LPOVERLAPPED, LPOVERLAPPED_COMPLETION_ROUTINE );
WINBASEAPI BOOL     WINAPI WriteFileGather( HANDLE, FILE_SEGMENT_ELEMENT [], DWORD, LPDWORD, LPOVERLAPPED );
WINBASEAPI BOOL     WINAPI WritePrivateProfileSectionA( LPCSTR, LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI WritePrivateProfileSectionW( LPCWSTR, LPCWSTR, LPCWSTR );
WINBASEAPI BOOL     WINAPI WritePrivateProfileStringA( LPCSTR, LPCSTR, LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI WritePrivateProfileStringW( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR );
WINBASEAPI BOOL     WINAPI WritePrivateProfileStructA( LPCSTR, LPCSTR, LPVOID, UINT, LPCSTR );
WINBASEAPI BOOL     WINAPI WritePrivateProfileStructW( LPCWSTR, LPCWSTR, LPVOID, UINT, LPCWSTR );
WINBASEAPI BOOL     WINAPI WriteProcessMemory( HANDLE, LPVOID, LPCVOID, SIZE_T, SIZE_T * );
WINBASEAPI BOOL     WINAPI WriteProfileSectionA( LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI WriteProfileSectionW( LPCWSTR, LPCWSTR );
WINBASEAPI BOOL     WINAPI WriteProfileStringA( LPCSTR, LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI WriteProfileStringW( LPCWSTR, LPCWSTR, LPCWSTR );
WINBASEAPI DWORD    WINAPI WriteTapemark( HANDLE, DWORD, DWORD, BOOL );
WINBASEAPI long     WINAPI _hread( HFILE, LPVOID, long );
WINBASEAPI long     WINAPI _hwrite( HFILE, LPCCH, long );
WINBASEAPI HFILE    WINAPI _lclose( HFILE );
WINBASEAPI HFILE    WINAPI _lcreat( LPCSTR, int );
WINBASEAPI LONG     WINAPI _llseek( HFILE, LONG, int );
WINBASEAPI HFILE    WINAPI _lopen( LPCSTR, int );
WINBASEAPI UINT     WINAPI _lread( HFILE, LPVOID, UINT );
WINBASEAPI UINT     WINAPI _lwrite( HFILE, LPCCH, UINT );
WINBASEAPI LPSTR    WINAPI lstrcatA( LPSTR, LPCSTR );
WINBASEAPI LPWSTR   WINAPI lstrcatW( LPWSTR, LPCWSTR );
WINBASEAPI int      WINAPI lstrcmpA( LPCSTR, LPCSTR );
WINBASEAPI int      WINAPI lstrcmpW( LPCWSTR, LPCWSTR );
WINBASEAPI int      WINAPI lstrcmpiA( LPCSTR, LPCSTR );
WINBASEAPI int      WINAPI lstrcmpiW( LPCWSTR, LPCWSTR );
WINBASEAPI LPSTR    WINAPI lstrcpyA( LPSTR, LPCSTR );
WINBASEAPI LPWSTR   WINAPI lstrcpyW( LPWSTR, LPCWSTR );
WINBASEAPI LPSTR    WINAPI lstrcpynA( LPSTR, LPCSTR, int );
WINBASEAPI LPWSTR   WINAPI lstrcpynW( LPWSTR, LPCWSTR, int );
WINBASEAPI int      WINAPI lstrlenA( LPCSTR );
WINBASEAPI int      WINAPI lstrlenW( LPCWSTR );
#if (WINVER >= 0x0400)
WINBASEAPI BOOL     WINAPI GetSystemPowerStatus( LPSYSTEM_POWER_STATUS );
WINBASEAPI BOOL     WINAPI SetSystemPowerState( BOOL, BOOL );
#endif
#if (_WIN32_WINNT >= 0x0400)
WINBASEAPI LPVOID   WINAPI ConvertThreadToFiber( LPVOID );
WINBASEAPI LPVOID   WINAPI ConvertThreadToFiberEx( LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI CopyFileExA( LPCSTR, LPCSTR, LPPROGRESS_ROUTINE, LPVOID, LPBOOL, DWORD );
WINBASEAPI BOOL     WINAPI CopyFileExW( LPCWSTR, LPCWSTR, LPPROGRESS_ROUTINE, LPVOID, LPBOOL, DWORD );
WINBASEAPI LPVOID   WINAPI CreateFiber( SIZE_T, LPFIBER_START_ROUTINE, LPVOID );
WINBASEAPI LPVOID   WINAPI CreateFiberEx( SIZE_T, SIZE_T, DWORD, LPFIBER_START_ROUTINE, LPVOID );
WINBASEAPI VOID     WINAPI DeleteFiber( LPVOID );
WINBASEAPI HANDLE   WINAPI FindFirstFileExA( LPCSTR, FINDEX_INFO_LEVELS, LPVOID, FINDEX_SEARCH_OPS, LPVOID, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstFileExW( LPCWSTR, FINDEX_INFO_LEVELS, LPVOID, FINDEX_SEARCH_OPS, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI ReadDirectoryChangesW( HANDLE, LPVOID, DWORD, BOOL, DWORD, LPDWORD, LPOVERLAPPED, LPOVERLAPPED_COMPLETION_ROUTINE );
WINBASEAPI DWORD    WINAPI SetThreadIdealProcessor( HANDLE, DWORD );
WINBASEAPI DWORD    WINAPI SignalObjectAndWait( HANDLE, HANDLE, DWORD, BOOL );
WINBASEAPI VOID     WINAPI SwitchToFiber( LPVOID );
WINBASEAPI BOOL     WINAPI SwitchToThread( VOID );
WINBASEAPI BOOL     WINAPI TryEnterCriticalSection( LPCRITICAL_SECTION );
#endif
#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
WINBASEAPI BOOL     WINAPI CancelWaitableTimer( HANDLE );
WINBASEAPI HANDLE   WINAPI CreateWaitableTimerA( LPSECURITY_ATTRIBUTES, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateWaitableTimerW( LPSECURITY_ATTRIBUTES, BOOL, LPCWSTR );
WINBASEAPI BOOL     WINAPI IsDebuggerPresent( VOID );
WINBASEAPI HANDLE   WINAPI OpenWaitableTimerA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenWaitableTimerW( DWORD, BOOL, LPCWSTR );
WINBASEAPI DWORD    WINAPI QueueUserAPC( PAPCFUNC, HANDLE, ULONG_PTR );
WINBASEAPI BOOL     WINAPI SetWaitableTimer( HANDLE, const LARGE_INTEGER *, LONG, PTIMERAPCROUTINE, LPVOID, BOOL );
#endif
#if (_WIN32_WINNT >= 0x0403)
WINBASEAPI BOOL     WINAPI InitializeCriticalSectionAndSpinCount( LPCRITICAL_SECTION, DWORD );
WINBASEAPI BOOL     WINAPI InitializeCriticalSectionEx( LPCRITICAL_SECTION, DWORD, DWORD );
WINBASEAPI DWORD    WINAPI SetCriticalSectionSpinCount( LPCRITICAL_SECTION, DWORD );
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL     WINAPI ActivateActCtx( HANDLE, ULONG_PTR * );
WINBASEAPI VOID     WINAPI AddRefActCtx( HANDLE );
WINBASEAPI PVOID    WINAPI AddVectoredContinueHandler( ULONG, PVECTORED_EXCEPTION_HANDLER );
WINBASEAPI PVOID    WINAPI AddVectoredExceptionHandler( ULONG, PVECTORED_EXCEPTION_HANDLER );
WINBASEAPI BOOL     WINAPI AllocateUserPhysicalPages( HANDLE, PULONG_PTR, PULONG_PTR );
WINBASEAPI BOOL     WINAPI AssignProcessToJobObject( HANDLE, HANDLE );
WINBASEAPI BOOL     WINAPI BindIoCompletionCallback( HANDLE, LPOVERLAPPED_COMPLETION_ROUTINE, ULONG );
WINBASEAPI BOOL     WINAPI CancelTimerQueueTimer( HANDLE, HANDLE );
WINBASEAPI BOOL     WINAPI ChangeTimerQueueTimer( HANDLE, HANDLE, ULONG, ULONG );
WINBASEAPI HANDLE   WINAPI CreateActCtxA( PCACTCTXA );
WINBASEAPI HANDLE   WINAPI CreateActCtxW( PCACTCTXW );
WINBASEAPI BOOL     WINAPI CreateHardLinkA( LPCSTR, LPCSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI BOOL     WINAPI CreateHardLinkW( LPCWSTR, LPCWSTR, LPSECURITY_ATTRIBUTES );
WINBASEAPI HANDLE   WINAPI CreateJobObjectA( LPSECURITY_ATTRIBUTES, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreateJobObjectW( LPSECURITY_ATTRIBUTES, LPCWSTR );
WINBASEAPI BOOL     WINAPI CreateJobSet( ULONG, PJOB_SET_ARRAY, ULONG );
WINBASEAPI HANDLE   WINAPI CreateTimerQueue( VOID );
WINBASEAPI BOOL     WINAPI CreateTimerQueueTimer( PHANDLE, HANDLE, WAITORTIMERCALLBACK, PVOID, DWORD, DWORD, ULONG );
WINBASEAPI BOOL     WINAPI DeactivateActCtx( DWORD, ULONG_PTR );
WINBASEAPI BOOL     WINAPI DeleteTimerQueue( HANDLE );
WINBASEAPI BOOL     WINAPI DeleteTimerQueueEx( HANDLE, HANDLE );
WINBASEAPI BOOL     WINAPI DeleteTimerQueueTimer( HANDLE, HANDLE, HANDLE );
WINBASEAPI BOOL     WINAPI DeleteVolumeMountPointA( LPCSTR );
WINBASEAPI BOOL     WINAPI DeleteVolumeMountPointW( LPCWSTR );
WINBASEAPI BOOL     WINAPI DnsHostnameToComputerNameA( LPCSTR, LPSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI DnsHostnameToComputerNameW( LPCWSTR, LPWSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI FindActCtxSectionGuid( DWORD, const GUID *, ULONG, const GUID *, PACTCTX_SECTION_KEYED_DATA );
WINBASEAPI BOOL     WINAPI FindActCtxSectionStringA( DWORD, const GUID *, ULONG, LPCSTR, PACTCTX_SECTION_KEYED_DATA );
WINBASEAPI BOOL     WINAPI FindActCtxSectionStringW( DWORD, const GUID *, ULONG, LPCWSTR, PACTCTX_SECTION_KEYED_DATA );
WINBASEAPI HANDLE   WINAPI FindFirstVolumeA( LPSTR, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstVolumeMountPointA( LPCSTR, LPSTR, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstVolumeMountPointW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI HANDLE   WINAPI FindFirstVolumeW( LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI FindNextVolumeA( HANDLE, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI FindNextVolumeMountPointA( HANDLE, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI FindNextVolumeMountPointW( HANDLE, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI FindNextVolumeW( HANDLE, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI FindVolumeClose( HANDLE );
WINBASEAPI BOOL     WINAPI FindVolumeMountPointClose( HANDLE );
WINBASEAPI BOOL     WINAPI FreeUserPhysicalPages( HANDLE, PULONG_PTR, PULONG_PTR );
WINBASEAPI BOOL     WINAPI GetComputerNameExA( COMPUTER_NAME_FORMAT, LPSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetComputerNameExW( COMPUTER_NAME_FORMAT, LPWSTR, LPDWORD );
WINBASEAPI BOOL     WINAPI GetCurrentActCtx( HANDLE * );
WINBASEAPI BOOL     WINAPI GetVolumeNameForVolumeMountPointA( LPCSTR, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetVolumeNameForVolumeMountPointW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetVolumePathNameA( LPCSTR, LPSTR, DWORD );
WINBASEAPI BOOL     WINAPI GetVolumePathNameW( LPCWSTR, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI MapUserPhysicalPages( PVOID, ULONG_PTR, PULONG_PTR );
WINBASEAPI BOOL     WINAPI MapUserPhysicalPagesScatter( PVOID *, ULONG_PTR, PULONG_PTR );
WINBASEAPI BOOL     WINAPI MoveFileWithProgressA( LPCSTR, LPCSTR, LPPROGRESS_ROUTINE, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI MoveFileWithProgressW( LPCWSTR, LPCWSTR, LPPROGRESS_ROUTINE, LPVOID, DWORD );
WINBASEAPI HANDLE   WINAPI OpenJobObjectA( DWORD, BOOL, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenJobObjectW( DWORD, BOOL, LPCWSTR );
WINBASEAPI BOOL     WINAPI QueryActCtxW( DWORD, HANDLE, PVOID, ULONG, PVOID, SIZE_T, SIZE_T * );
WINBASEAPI BOOL     WINAPI QueryInformationJobObject( HANDLE, JOBOBJECTINFOCLASS, LPVOID, DWORD, LPDWORD );
WINBASEAPI BOOL     WINAPI QueueUserWorkItem( LPTHREAD_START_ROUTINE, PVOID, ULONG );
WINBASEAPI BOOL     WINAPI RegisterWaitForSingleObject( PHANDLE, HANDLE, WAITORTIMERCALLBACK, PVOID, ULONG, ULONG );
WINBASEAPI HANDLE   WINAPI RegisterWaitForSingleObjectEx( HANDLE, WAITORTIMERCALLBACK, PVOID, ULONG, ULONG );
WINBASEAPI VOID     WINAPI ReleaseActCtx( HANDLE );
WINBASEAPI ULONG    WINAPI RemoveVectoredContinueHandler( PVOID );
WINBASEAPI ULONG    WINAPI RemoveVectoredExceptionHandler( PVOID );
WINBASEAPI BOOL     WINAPI ReplaceFileA( LPCSTR, LPCSTR, LPCSTR, DWORD, LPVOID, LPVOID );
WINBASEAPI BOOL     WINAPI ReplaceFileW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, LPVOID, LPVOID );
WINBASEAPI BOOL     WINAPI SetComputerNameExA( COMPUTER_NAME_FORMAT, LPCSTR );
WINBASEAPI BOOL     WINAPI SetComputerNameExW( COMPUTER_NAME_FORMAT, LPCWSTR );
WINBASEAPI BOOL     WINAPI SetInformationJobObject( HANDLE, JOBOBJECTINFOCLASS, LPVOID, DWORD );
WINBASEAPI HANDLE   WINAPI SetTimerQueueTimer( HANDLE, WAITORTIMERCALLBACK, PVOID, DWORD, DWORD, BOOL );
WINBASEAPI BOOL     WINAPI SetVolumeMountPointA( LPCSTR, LPCSTR );
WINBASEAPI BOOL     WINAPI SetVolumeMountPointW( LPCWSTR, LPCWSTR );
WINBASEAPI BOOL     WINAPI TerminateJobObject( HANDLE, UINT );
WINBASEAPI BOOL     WINAPI UnregisterWait( HANDLE );
WINBASEAPI BOOL     WINAPI UnregisterWaitEx( HANDLE, HANDLE );
WINBASEAPI BOOL     WINAPI ZombifyActCtx( HANDLE );
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL     WINAPI CheckNameLegalDOS8Dot3A( LPCSTR, LPSTR, DWORD, PBOOL, PBOOL );
WINBASEAPI BOOL     WINAPI CheckNameLegalDOS8Dot3W( LPCWSTR, LPSTR, DWORD, PBOOL, PBOOL );
WINBASEAPI BOOL     WINAPI CheckRemoteDebuggerPresent( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI ConvertFiberToThread( VOID );
WINBASEAPI HANDLE   WINAPI CreateMemoryResourceNotification( MEMORY_RESOURCE_NOTIFICATION_TYPE );
WINBASEAPI HANDLE   WINAPI FindFirstStreamW( LPCWSTR, STREAM_INFO_LEVELS, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI FindNextStreamW( HANDLE, LPVOID );
WINBASEAPI BOOL     WINAPI GetModuleHandleExA( DWORD, LPCSTR, HMODULE * );
WINBASEAPI BOOL     WINAPI GetModuleHandleExW( DWORD, LPCWSTR, HMODULE * );
WINBASEAPI VOID     WINAPI GetNativeSystemInfo( LPSYSTEM_INFO );
WINBASEAPI BOOL     WINAPI GetProcessHandleCount( HANDLE, PDWORD );
WINBASEAPI BOOL     WINAPI GetSystemRegistryQuota( PDWORD, PDWORD );
WINBASEAPI BOOL     WINAPI GetSystemTimes( LPFILETIME, LPFILETIME, LPFILETIME );
WINBASEAPI UINT     WINAPI GetSystemWow64DirectoryA( LPSTR, UINT );
WINBASEAPI UINT     WINAPI GetSystemWow64DirectoryW( LPWSTR, UINT );
WINBASEAPI BOOL     WINAPI GetThreadIOPendingFlag( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI GetVolumePathNamesForVolumeNameA( LPCSTR, LPCH, DWORD, PDWORD );
WINBASEAPI BOOL     WINAPI GetVolumePathNamesForVolumeNameW( LPCWSTR, LPWCH, DWORD, PDWORD );
WINBASEAPI BOOL     WINAPI IsProcessInJob( HANDLE, HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI IsWow64Process( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI QueryMemoryResourceNotification( HANDLE, PBOOL );
WINBASEAPI BOOL     WINAPI SetFileValidData( HANDLE, LONGLONG );
WINBASEAPI DWORD    WINAPI WTSGetActiveConsoleSessionId( VOID );
WINBASEAPI BOOL     WINAPI Wow64DisableWow64FsRedirection( PVOID * );
WINBASEAPI BOOLEAN  WINAPI Wow64EnableWow64FsRedirection( BOOLEAN );
WINBASEAPI BOOL     WINAPI Wow64RevertWow64FsRedirection( PVOID );
#endif
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI DWORD    WINAPI GetDllDirectoryA( DWORD, LPSTR );
WINBASEAPI DWORD    WINAPI GetDllDirectoryW( DWORD, LPWSTR );
WINBASEAPI BOOL     WINAPI GetSystemFileCacheSize( PSIZE_T, PSIZE_T, PDWORD );
WINBASEAPI DWORD    WINAPI GetThreadId( HANDLE );
WINBASEAPI LONGLONG WINAPI InterlockedCompareExchange64( LONGLONG volatile *, LONGLONG, LONGLONG );
WINBASEAPI BOOL     WINAPI NeedCurrentDirectoryForExePathA( LPCSTR );
WINBASEAPI BOOL     WINAPI NeedCurrentDirectoryForExePathW( LPCWSTR );
WINBASEAPI HANDLE   WINAPI ReOpenFile( HANDLE, DWORD, DWORD, DWORD );
WINBASEAPI BOOL     WINAPI SetDllDirectoryA( LPCSTR );
WINBASEAPI BOOL     WINAPI SetDllDirectoryW( LPCWSTR );
WINBASEAPI BOOL     WINAPI SetSystemFileCacheSize( SIZE_T, SIZE_T, DWORD );
#endif
#if (_WIN32_WINNT >= 0x0600)
WINBASEAPI BOOL     WINAPI AddIntegrityLabelToBoundaryDescriptor( HANDLE *, PSID );
WINBASEAPI BOOL     WINAPI AddSIDToBoundaryDescriptor( HANDLE *, PSID );
WINBASEAPI BOOL     WINAPI AddSecureMemoryCacheCallback( PSECURE_MEMORY_CACHE_CALLBACK );
WINBASEAPI BOOL     WINAPI AllocateUserPhysicalPagesNuma( HANDLE, PULONG_PTR, PULONG_PTR, DWORD );
WINBASEAPI BOOL     WINAPI CallbackMayRunLong( PTP_CALLBACK_INSTANCE );
WINBASEAPI VOID     WINAPI CancelThreadpoolIo( PTP_IO );
WINBASEAPI BOOLEAN  WINAPI ClosePrivateNamespace( HANDLE, ULONG );
WINBASEAPI VOID     WINAPI CloseThreadpool( PTP_POOL );
WINBASEAPI VOID     WINAPI CloseThreadpoolCleanupGroup( PTP_CLEANUP_GROUP );
WINBASEAPI VOID     WINAPI CloseThreadpoolCleanupGroupMembers( PTP_CLEANUP_GROUP, BOOL, PVOID );
WINBASEAPI VOID     WINAPI CloseThreadpoolIo( PTP_IO );
WINBASEAPI VOID     WINAPI CloseThreadpoolTimer( PTP_TIMER );
WINBASEAPI VOID     WINAPI CloseThreadpoolWait( PTP_WAIT );
WINBASEAPI VOID     WINAPI CloseThreadpoolWork( PTP_WORK );
WINBASEAPI BOOL     WINAPI CopyFileTransactedA( LPCSTR, LPCSTR, LPPROGRESS_ROUTINE, LPVOID, LPBOOL, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI CopyFileTransactedW( LPCWSTR, LPCWSTR, LPPROGRESS_ROUTINE, LPVOID, LPBOOL, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI CreateBoundaryDescriptorA( LPCSTR, ULONG );
WINBASEAPI HANDLE   WINAPI CreateBoundaryDescriptorW( LPCWSTR, ULONG );
WINBASEAPI BOOL     WINAPI CreateDirectoryTransactedA( LPCSTR, LPCSTR, LPSECURITY_ATTRIBUTES, HANDLE );
WINBASEAPI BOOL     WINAPI CreateDirectoryTransactedW( LPCWSTR, LPCWSTR, LPSECURITY_ATTRIBUTES, HANDLE );
WINBASEAPI HANDLE   WINAPI CreateEventExA( LPSECURITY_ATTRIBUTES, LPCSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateEventExW( LPSECURITY_ATTRIBUTES, LPCWSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateFileMappingNumaA( HANDLE, LPSECURITY_ATTRIBUTES, DWORD, DWORD, DWORD, LPCSTR, DWORD );
WINBASEAPI HANDLE   WINAPI CreateFileMappingNumaW( HANDLE, LPSECURITY_ATTRIBUTES, DWORD, DWORD, DWORD, LPCWSTR, DWORD );
WINBASEAPI HANDLE   WINAPI CreateFileTransactedA( LPCSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES, DWORD, DWORD, HANDLE, HANDLE, PUSHORT, PVOID );
WINBASEAPI HANDLE   WINAPI CreateFileTransactedW( LPCWSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES, DWORD, DWORD, HANDLE, HANDLE, PUSHORT, PVOID );
WINBASEAPI BOOL     WINAPI CreateHardLinkTransactedA( LPCSTR, LPCSTR, LPSECURITY_ATTRIBUTES, HANDLE );
WINBASEAPI BOOL     WINAPI CreateHardLinkTransactedW( LPCWSTR, LPCWSTR, LPSECURITY_ATTRIBUTES, HANDLE );
WINBASEAPI HANDLE   WINAPI CreateMutexExA( LPSECURITY_ATTRIBUTES, LPCSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateMutexExW( LPSECURITY_ATTRIBUTES, LPCWSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreatePrivateNamespaceA( LPSECURITY_ATTRIBUTES, LPVOID, LPCSTR );
WINBASEAPI HANDLE   WINAPI CreatePrivateNamespaceW( LPSECURITY_ATTRIBUTES, LPVOID, LPCWSTR );
WINBASEAPI HANDLE   WINAPI CreateSemaphoreExA( LPSECURITY_ATTRIBUTES, LONG, LONG, LPCSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateSemaphoreExW( LPSECURITY_ATTRIBUTES, LONG, LONG, LPCWSTR, DWORD, DWORD );
WINBASEAPI BOOLEAN  WINAPI CreateSymbolicLinkA( LPCSTR, LPCSTR, DWORD );
WINBASEAPI BOOLEAN  WINAPI CreateSymbolicLinkTransactedA( LPCSTR, LPCSTR, DWORD, HANDLE );
WINBASEAPI BOOLEAN  WINAPI CreateSymbolicLinkTransactedW( LPCWSTR, LPCWSTR, DWORD, HANDLE );
WINBASEAPI BOOLEAN  WINAPI CreateSymbolicLinkW( LPCWSTR, LPCWSTR, DWORD );
WINBASEAPI PTP_POOL WINAPI CreateThreadpool( PVOID );
WINBASEAPI PTP_CLEANUP_GROUP WINAPI CreateThreadpoolCleanupGroup( VOID );
WINBASEAPI PTP_IO   WINAPI CreateThreadpoolIo( HANDLE, PTP_WIN32_IO_CALLBACK, PVOID, PTP_CALLBACK_ENVIRON );
WINBASEAPI PTP_TIMER WINAPI CreateThreadpoolTimer( PTP_TIMER_CALLBACK, PVOID, PTP_CALLBACK_ENVIRON );
WINBASEAPI PTP_WAIT WINAPI CreateThreadpoolWait( PTP_WAIT_CALLBACK, PVOID, PTP_CALLBACK_ENVIRON );
WINBASEAPI PTP_WORK WINAPI CreateThreadpoolWork( PTP_WORK_CALLBACK, PVOID, PTP_CALLBACK_ENVIRON );
WINBASEAPI HANDLE   WINAPI CreateWaitableTimerExA( LPSECURITY_ATTRIBUTES, LPCSTR, DWORD, DWORD );
WINBASEAPI HANDLE   WINAPI CreateWaitableTimerExW( LPSECURITY_ATTRIBUTES, LPCWSTR, DWORD, DWORD );
WINBASEAPI VOID     WINAPI DeleteBoundaryDescriptor( HANDLE );
WINBASEAPI BOOL     WINAPI DeleteFileTransactedA( LPCSTR, HANDLE );
WINBASEAPI BOOL     WINAPI DeleteFileTransactedW( LPCWSTR, HANDLE );
WINBASEAPI VOID     WINAPI DeleteProcThreadAttributeList( LPPROC_THREAD_ATTRIBUTE_LIST );
WINBASEAPI VOID     WINAPI DisassociateCurrentThreadFromCallback( PTP_CALLBACK_INSTANCE );
WINBASEAPI HANDLE   WINAPI FindFirstFileNameTransactedW( LPCWSTR, DWORD, LPDWORD, PWCHAR, HANDLE );
WINBASEAPI HANDLE   WINAPI FindFirstFileNameW( LPCWSTR, DWORD, LPDWORD, PWCHAR );
WINBASEAPI HANDLE   WINAPI FindFirstFileTransactedA( LPCSTR, FINDEX_INFO_LEVELS, LPVOID, FINDEX_SEARCH_OPS, LPVOID, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI FindFirstFileTransactedW( LPCWSTR, FINDEX_INFO_LEVELS, LPVOID, FINDEX_SEARCH_OPS, LPVOID, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI FindFirstStreamTransactedW( LPCWSTR, STREAM_INFO_LEVELS, LPVOID, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI FindNextFileNameW( HANDLE, LPDWORD, PWCHAR );
WINBASEAPI VOID     WINAPI FlushProcessWriteBuffers( VOID );
WINBASEAPI VOID     WINAPI FreeLibraryWhenCallbackReturns( PTP_CALLBACK_INSTANCE, HMODULE );
WINBASEAPI DWORD    WINAPI GetCompressedFileSizeTransactedA( LPCSTR, LPDWORD, HANDLE );
WINBASEAPI DWORD    WINAPI GetCompressedFileSizeTransactedW( LPCWSTR, LPDWORD, HANDLE );
WINBASEAPI BOOL     WINAPI GetFileAttributesTransactedA( LPCSTR, GET_FILEEX_INFO_LEVELS, LPVOID, HANDLE );
WINBASEAPI BOOL     WINAPI GetFileAttributesTransactedW( LPCWSTR, GET_FILEEX_INFO_LEVELS, LPVOID, HANDLE );
WINBASEAPI BOOL     WINAPI GetFileInformationByHandleEx( HANDLE, FILE_INFO_BY_HANDLE_CLASS, LPVOID, DWORD );
WINBASEAPI DWORD    WINAPI GetFinalPathNameByHandleA( HANDLE, LPSTR, DWORD, DWORD );
WINBASEAPI DWORD    WINAPI GetFinalPathNameByHandleW( HANDLE, LPWSTR, DWORD, DWORD );
WINBASEAPI DWORD    WINAPI GetFullPathNameTransactedA( LPCSTR, DWORD, LPSTR, LPSTR *, HANDLE );
WINBASEAPI DWORD    WINAPI GetFullPathNameTransactedW( LPCWSTR, DWORD, LPWSTR, LPWSTR *, HANDLE );
WINBASEAPI DWORD    WINAPI GetLongPathNameTransactedA( LPCSTR, LPSTR, DWORD, HANDLE );
WINBASEAPI DWORD    WINAPI GetLongPathNameTransactedW( LPCWSTR, LPWSTR, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI GetNumaProximityNode( ULONG, PUCHAR );
WINBASEAPI BOOL     WINAPI GetProcessDEPPolicy( HANDLE, LPDWORD, PBOOL );
WINBASEAPI BOOL     WINAPI GetProductInfo( DWORD, DWORD, DWORD, DWORD, PDWORD );
WINBASEAPI BOOL     WINAPI GetQueuedCompletionStatusEx( HANDLE, LPOVERLAPPED_ENTRY, ULONG, PULONG, DWORD, BOOL );
WINBASEAPI ULONGLONG WINAPI GetTickCount64( VOID );
WINBASEAPI BOOL     WINAPI GetVolumeInformationByHandleW( HANDLE, LPWSTR, DWORD, LPDWORD, LPDWORD, LPDWORD, LPWSTR, DWORD );
WINBASEAPI BOOL     WINAPI InitOnceBeginInitialize( LPINIT_ONCE, DWORD, PBOOL, LPVOID * );
WINBASEAPI BOOL     WINAPI InitOnceComplete( LPINIT_ONCE, DWORD, LPVOID );
WINBASEAPI BOOL     WINAPI InitOnceExecuteOnce( PINIT_ONCE, PINIT_ONCE_FN, PVOID, LPVOID * );
WINBASEAPI VOID     WINAPI InitOnceInitialize( PINIT_ONCE );
WINBASEAPI BOOL     WINAPI InitializeProcThreadAttributeList( LPPROC_THREAD_ATTRIBUTE_LIST, DWORD, DWORD, PSIZE_T );
WINBASEAPI BOOL     WINAPI IsThreadAFiber( VOID );
WINBASEAPI BOOL     WINAPI IsThreadpoolTimerSet( PTP_TIMER );
WINBASEAPI VOID     WINAPI LeaveCriticalSectionWhenCallbackReturns( PTP_CALLBACK_INSTANCE, PCRITICAL_SECTION );
WINBASEAPI LPVOID   WINAPI MapViewOfFileExNuma( HANDLE, DWORD, DWORD, DWORD, SIZE_T, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI MoveFileTransactedA( LPCSTR, LPCSTR, LPPROGRESS_ROUTINE, LPVOID, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI MoveFileTransactedW( LPCWSTR, LPCWSTR, LPPROGRESS_ROUTINE, LPVOID, DWORD, HANDLE );
WINBASEAPI HANDLE   WINAPI OpenFileById( HANDLE, LPFILE_ID_DESCRIPTOR, DWORD, DWORD, LPSECURITY_ATTRIBUTES, DWORD );
WINBASEAPI HANDLE   WINAPI OpenPrivateNamespaceA( LPVOID, LPCSTR );
WINBASEAPI HANDLE   WINAPI OpenPrivateNamespaceW( LPVOID, LPCWSTR );
WINBASEAPI BOOL     WINAPI QueryActCtxSettingsW( DWORD, HANDLE, PCWSTR, PCWSTR, PWSTR, SIZE_T, SIZE_T * );
WINBASEAPI BOOL     WINAPI QueryFullProcessImageNameA( HANDLE, DWORD, LPSTR, PDWORD );
WINBASEAPI BOOL     WINAPI QueryFullProcessImageNameW( HANDLE, DWORD, LPWSTR, PDWORD );
WINBASEAPI BOOL     WINAPI QueryIdleProcessorCycleTime( PULONG, PULONG64 );
WINBASEAPI BOOL     WINAPI QueryProcessAffinityUpdateMode( HANDLE, LPDWORD );
WINBASEAPI BOOL     WINAPI QueryProcessCycleTime( HANDLE, PULONG64 );
WINBASEAPI BOOL     WINAPI QueryThreadCycleTime( HANDLE, PULONG64 );
WINBASEAPI BOOL     WINAPI QueryThreadpoolStackInformation( PTP_POOL, PTP_POOL_STACK_INFORMATION );
WINBASEAPI VOID     WINAPI ReleaseMutexWhenCallbackReturns( PTP_CALLBACK_INSTANCE, HANDLE );
WINBASEAPI VOID     WINAPI ReleaseSemaphoreWhenCallbackReturns( PTP_CALLBACK_INSTANCE, HANDLE, DWORD );
WINBASEAPI BOOL     WINAPI RemoveDirectoryTransactedA( LPCSTR, HANDLE );
WINBASEAPI BOOL     WINAPI RemoveDirectoryTransactedW( LPCWSTR, HANDLE );
WINBASEAPI BOOL     WINAPI RemoveSecureMemoryCacheCallback( PSECURE_MEMORY_CACHE_CALLBACK );
WINBASEAPI BOOL     WINAPI ReplacePartitionUnit( PWSTR, PWSTR, ULONG );
WINBASEAPI VOID     WINAPI SetEventWhenCallbackReturns( PTP_CALLBACK_INSTANCE, HANDLE );
WINBASEAPI BOOL     WINAPI SetFileAttributesTransactedA( LPCSTR, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI SetFileAttributesTransactedW( LPCWSTR, DWORD, HANDLE );
WINBASEAPI BOOL     WINAPI SetFileCompletionNotificationModes( HANDLE, UCHAR );
WINBASEAPI BOOL     WINAPI SetFileInformationByHandle( HANDLE, FILE_INFO_BY_HANDLE_CLASS, LPVOID, DWORD );
WINBASEAPI BOOL     WINAPI SetFileIoOverlappedRange( HANDLE, PUCHAR, ULONG );
WINBASEAPI BOOL     WINAPI SetProcessAffinityUpdateMode( HANDLE, DWORD );
WINBASEAPI BOOL     WINAPI SetProcessDEPPolicy( DWORD );
WINBASEAPI BOOL     WINAPI SetStdHandleEx( DWORD, HANDLE, PHANDLE );
WINBASEAPI BOOL     WINAPI SetThreadpoolStackInformation( PTP_POOL, PTP_POOL_STACK_INFORMATION );
WINBASEAPI VOID     WINAPI SetThreadpoolThreadMaximum( PTP_POOL, DWORD );
WINBASEAPI VOID     WINAPI SetThreadpoolTimer( PTP_TIMER, PFILETIME, DWORD, DWORD );
WINBASEAPI VOID     WINAPI SetThreadpoolWait( PTP_WAIT, HANDLE, PFILETIME );
WINBASEAPI VOID     WINAPI StartThreadpoolIo( PTP_IO );
WINBASEAPI VOID     WINAPI SubmitThreadpoolWork( PTP_WORK );
WINBASEAPI BOOL     WINAPI TrySubmitThreadpoolCallback( PTP_SIMPLE_CALLBACK, PVOID, PTP_CALLBACK_ENVIRON );
WINBASEAPI BOOL     WINAPI UpdateProcThreadAttribute( LPPROC_THREAD_ATTRIBUTE_LIST, DWORD, DWORD_PTR, PVOID, SIZE_T, PVOID, PSIZE_T );
WINBASEAPI LPVOID   WINAPI VirtualAllocExNuma( HANDLE, LPVOID, SIZE_T, DWORD, DWORD, DWORD );
WINBASEAPI VOID     WINAPI WaitForThreadpoolIoCallbacks( PTP_IO, BOOL );
WINBASEAPI VOID     WINAPI WaitForThreadpoolTimerCallbacks( PTP_TIMER, BOOL );
WINBASEAPI VOID     WINAPI WaitForThreadpoolWaitCallbacks( PTP_WAIT, BOOL );
WINBASEAPI VOID     WINAPI WaitForThreadpoolWorkCallbacks( PTP_WORK, BOOL );
#endif
#if (_WIN32_WINNT >= 0x0601)
WINBASEAPI BOOL     WINAPI CopyExtendedContext( PCONTEXT_EX, DWORD, PCONTEXT_EX );
WINBASEAPI DWORD    WINAPI DisableThreadProfiling( HANDLE );
WINBASEAPI DWORD    WINAPI EnableThreadProfiling( HANDLE, DWORD, DWORD64, HANDLE * );
WINBASEAPI DWORD    WINAPI GetActiveProcessorCount( WORD );
WINBASEAPI WORD     WINAPI GetActiveProcessorGroupCount( VOID );
WINBASEAPI VOID     WINAPI GetCurrentProcessorNumberEx( PPROCESSOR_NUMBER );
WINBASEAPI DWORD64  WINAPI GetEnabledExtendedFeatures( DWORD64 );
WINBASEAPI BOOL     WINAPI GetExtendedContextLength( DWORD, PDWORD );
WINBASEAPI DWORD64  WINAPI GetExtendedFeaturesMask( PCONTEXT_EX );
WINBASEAPI BOOL     WINAPI GetLogicalProcessorInformationEx( LOGICAL_PROCESSOR_RELATIONSHIP, PSYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX, PDWORD );
WINBASEAPI DWORD    WINAPI GetMaximumProcessorCount( WORD );
WINBASEAPI WORD     WINAPI GetMaximumProcessorGroupCount( VOID );
WINBASEAPI BOOL     WINAPI GetNumaAvailableMemoryNodeEx( USHORT, PULONGLONG );
WINBASEAPI BOOL     WINAPI GetNumaNodeNumberFromHandle( HANDLE, PUSHORT );
WINBASEAPI BOOL     WINAPI GetNumaNodeProcessorMaskEx( USHORT, PGROUP_AFFINITY );
WINBASEAPI BOOL     WINAPI GetNumaProcessorNodeEx( PPROCESSOR_NUMBER, PUSHORT );
WINBASEAPI BOOL     WINAPI GetNumaProximityNodeEx( ULONG, PUSHORT );
WINBASEAPI BOOL     WINAPI GetProcessGroupAffinity( HANDLE, PUSHORT, PUSHORT );
WINBASEAPI BOOL     WINAPI GetProcessorSystemCycleTime( USHORT, PSYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION, PDWORD );
WINBASEAPI BOOL     WINAPI GetThreadGroupAffinity( HANDLE, PGROUP_AFFINITY );
WINBASEAPI BOOL     WINAPI GetThreadIdealProcessorEx( HANDLE, PPROCESSOR_NUMBER );
WINBASEAPI BOOL     WINAPI InitializeExtendedContext( PVOID, DWORD, PCONTEXT_EX * );
WINBASEAPI PVOID    WINAPI LocateExtendedFeature( PCONTEXT_EX, DWORD, PDWORD );
WINBASEAPI PCONTEXT WINAPI LocateLegacyContext( PCONTEXT_EX, PDWORD );
WINBASEAPI BOOL     WINAPI PowerClearRequest( HANDLE, POWER_REQUEST_TYPE );
WINBASEAPI HANDLE   WINAPI PowerCreateRequest( PREASON_CONTEXT );
WINBASEAPI BOOL     WINAPI PowerSetRequest( HANDLE, POWER_REQUEST_TYPE );
WINBASEAPI BOOL     WINAPI QueryIdleProcessorCycleTimeEx( USHORT, PULONG, PULONG64 );
WINBASEAPI DWORD    WINAPI QueryThreadProfiling( HANDLE, PBOOLEAN );
WINBASEAPI BOOL     WINAPI QueryUnbiasedInterruptTime( PULONGLONG );
WINBASEAPI DWORD    WINAPI ReadThreadProfilingData( HANDLE, DWORD, PPERFORMANCE_DATA );
WINBASEAPI VOID     WINAPI SetExtendedFeaturesMask( PCONTEXT_EX, DWORD64 );
WINBASEAPI BOOL     WINAPI SetThreadGroupAffinity( HANDLE, CONST GROUP_AFFINITY *, PGROUP_AFFINITY );
WINBASEAPI BOOL     WINAPI SetThreadIdealProcessorEx( HANDLE, PPROCESSOR_NUMBER, PPROCESSOR_NUMBER );
WINBASEAPI BOOL     WINAPI SetWaitableTimerEx( HANDLE, const LARGE_INTEGER *, LONG, PTIMERAPCROUTINE, LPVOID, PREASON_CONTEXT, ULONG );
WINBASEAPI BOOL     WINAPI Wow64GetThreadSelectorEntry( HANDLE, DWORD, PWOW64_LDT_ENTRY );
#endif

/* Functions in ADVAPI32.DLL */
WINADVAPI BOOL      WINAPI AccessCheck( PSECURITY_DESCRIPTOR, HANDLE, DWORD, PGENERIC_MAPPING, PPRIVILEGE_SET, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckAndAuditAlarmA( LPCSTR, LPVOID, LPSTR, LPSTR, PSECURITY_DESCRIPTOR, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPBOOL, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckAndAuditAlarmW( LPCWSTR, LPVOID, LPWSTR, LPWSTR, PSECURITY_DESCRIPTOR, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPBOOL, LPBOOL );
WINADVAPI BOOL      WINAPI AddAccessAllowedAce( PACL, DWORD, DWORD, PSID );
WINADVAPI BOOL      WINAPI AddAccessDeniedAce( PACL, DWORD, DWORD, PSID );
WINADVAPI BOOL      WINAPI AddAce( PACL, DWORD, DWORD, LPVOID, DWORD );
WINADVAPI BOOL      WINAPI AddAuditAccessAce( PACL, DWORD, DWORD, PSID, BOOL, BOOL );
WINADVAPI BOOL      WINAPI AdjustTokenGroups( HANDLE, BOOL, PTOKEN_GROUPS, DWORD, PTOKEN_GROUPS, PDWORD );
WINADVAPI BOOL      WINAPI AdjustTokenPrivileges( HANDLE, BOOL, PTOKEN_PRIVILEGES, DWORD, PTOKEN_PRIVILEGES, PDWORD );
WINADVAPI BOOL      WINAPI AllocateAndInitializeSid( PSID_IDENTIFIER_AUTHORITY, BYTE, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, DWORD, PSID * );
WINADVAPI BOOL      WINAPI AllocateLocallyUniqueId( PLUID );
WINADVAPI BOOL      WINAPI AreAllAccessesGranted( DWORD, DWORD );
WINADVAPI BOOL      WINAPI AreAnyAccessesGranted( DWORD, DWORD );
WINADVAPI BOOL      WINAPI BackupEventLogA( HANDLE, LPCSTR );
WINADVAPI BOOL      WINAPI BackupEventLogW( HANDLE, LPCWSTR );
WINADVAPI BOOL      WINAPI CheckTokenMembership( HANDLE, PSID, PBOOL );
WINADVAPI BOOL      WINAPI ClearEventLogA( HANDLE, LPCSTR );
WINADVAPI BOOL      WINAPI ClearEventLogW( HANDLE, LPCWSTR );
WINADVAPI VOID      WINAPI CloseEncryptedFileRaw( PVOID );
WINADVAPI BOOL      WINAPI CloseEventLog( HANDLE );
WINADVAPI BOOL      WINAPI CopySid( DWORD, PSID, PSID );
WINADVAPI BOOL      WINAPI CreatePrivateObjectSecurity( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, BOOL, HANDLE, PGENERIC_MAPPING );
WINADVAPI BOOL      WINAPI CreateProcessAsUserA( HANDLE, LPCSTR, LPSTR, LPSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES, BOOL, DWORD, LPVOID, LPCSTR, LPSTARTUPINFOA, LPPROCESS_INFORMATION );
WINADVAPI BOOL      WINAPI CreateProcessAsUserW( HANDLE, LPCWSTR, LPWSTR, LPSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES, BOOL, DWORD, LPVOID, LPCWSTR, LPSTARTUPINFOW, LPPROCESS_INFORMATION );
WINADVAPI BOOL      WINAPI CreateRestrictedToken( HANDLE, DWORD, DWORD, PSID_AND_ATTRIBUTES, DWORD, PLUID_AND_ATTRIBUTES, DWORD, PSID_AND_ATTRIBUTES, PHANDLE );
WINADVAPI BOOL      WINAPI DecryptFileA( LPCSTR, DWORD );
WINADVAPI BOOL      WINAPI DecryptFileW( LPCWSTR, DWORD );
WINADVAPI BOOL      WINAPI DeleteAce( PACL, DWORD );
WINADVAPI BOOL      WINAPI DeregisterEventSource( HANDLE );
WINADVAPI BOOL      WINAPI DestroyPrivateObjectSecurity( PSECURITY_DESCRIPTOR * );
WINADVAPI BOOL      WINAPI DuplicateToken( HANDLE, SECURITY_IMPERSONATION_LEVEL, PHANDLE );
WINADVAPI BOOL      WINAPI DuplicateTokenEx( HANDLE, DWORD, LPSECURITY_ATTRIBUTES, SECURITY_IMPERSONATION_LEVEL, TOKEN_TYPE, PHANDLE );
WINADVAPI BOOL      WINAPI EncryptFileA( LPCSTR );
WINADVAPI BOOL      WINAPI EncryptFileW( LPCWSTR );
WINADVAPI BOOL      WINAPI EqualPrefixSid( PSID, PSID );
WINADVAPI BOOL      WINAPI EqualSid( PSID, PSID );
WINADVAPI BOOL      WINAPI FileEncryptionStatusA( LPCSTR, LPDWORD );
WINADVAPI BOOL      WINAPI FileEncryptionStatusW( LPCWSTR, LPDWORD );
WINADVAPI BOOL      WINAPI FindFirstFreeAce( PACL, LPVOID * );
WINADVAPI PVOID     WINAPI FreeSid( PSID );
WINADVAPI BOOL      WINAPI GetAce( PACL, DWORD, LPVOID * );
WINADVAPI BOOL      WINAPI GetAclInformation( PACL, LPVOID, DWORD, ACL_INFORMATION_CLASS );
WINADVAPI BOOL      WINAPI GetEventLogInformation( HANDLE, DWORD, LPVOID, DWORD, LPDWORD );
WINADVAPI BOOL      WINAPI GetFileSecurityA( LPCSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, LPDWORD );
WINADVAPI BOOL      WINAPI GetFileSecurityW( LPCWSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, LPDWORD );
WINADVAPI BOOL      WINAPI GetKernelObjectSecurity( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, LPDWORD );
WINADVAPI DWORD     WINAPI GetLengthSid( PSID );
WINADVAPI BOOL      WINAPI GetNumberOfEventLogRecords( HANDLE, PDWORD );
WINADVAPI BOOL      WINAPI GetOldestEventLogRecord( HANDLE, PDWORD );
WINADVAPI BOOL      WINAPI GetPrivateObjectSecurity( PSECURITY_DESCRIPTOR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, PDWORD );
WINADVAPI BOOL      WINAPI GetSecurityDescriptorControl( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR_CONTROL, LPDWORD );
WINADVAPI BOOL      WINAPI GetSecurityDescriptorDacl( PSECURITY_DESCRIPTOR, LPBOOL, PACL *, LPBOOL );
WINADVAPI BOOL      WINAPI GetSecurityDescriptorGroup( PSECURITY_DESCRIPTOR, PSID *, LPBOOL );
WINADVAPI DWORD     WINAPI GetSecurityDescriptorLength( PSECURITY_DESCRIPTOR );
WINADVAPI BOOL      WINAPI GetSecurityDescriptorOwner( PSECURITY_DESCRIPTOR, PSID *, LPBOOL );
WINADVAPI DWORD     WINAPI GetSecurityDescriptorRMControl( PSECURITY_DESCRIPTOR, PUCHAR );
WINADVAPI BOOL      WINAPI GetSecurityDescriptorSacl( PSECURITY_DESCRIPTOR, LPBOOL, PACL *, LPBOOL );
WINADVAPI PSID_IDENTIFIER_AUTHORITY WINAPI GetSidIdentifierAuthority( PSID );
WINADVAPI DWORD     WINAPI GetSidLengthRequired( UCHAR );
WINADVAPI PDWORD    WINAPI GetSidSubAuthority( PSID, DWORD );
WINADVAPI PUCHAR    WINAPI GetSidSubAuthorityCount( PSID );
WINADVAPI BOOL      WINAPI GetTokenInformation( HANDLE, TOKEN_INFORMATION_CLASS, LPVOID, DWORD, PDWORD );
WINADVAPI BOOL      WINAPI GetUserNameA( LPSTR, LPDWORD );
WINADVAPI BOOL      WINAPI GetUserNameW( LPWSTR, LPDWORD );
WINADVAPI BOOL      WINAPI ImpersonateAnonymousToken( HANDLE );
WINADVAPI BOOL      WINAPI ImpersonateLoggedOnUser( HANDLE );
WINADVAPI BOOL      WINAPI ImpersonateNamedPipeClient( HANDLE );
WINADVAPI BOOL      WINAPI ImpersonateSelf( SECURITY_IMPERSONATION_LEVEL );
WINADVAPI BOOL      WINAPI InitializeAcl( PACL, DWORD, DWORD );
WINADVAPI BOOL      WINAPI InitializeSecurityDescriptor( PSECURITY_DESCRIPTOR, DWORD );
WINADVAPI BOOL      WINAPI InitializeSid( PSID, PSID_IDENTIFIER_AUTHORITY, BYTE );
WINADVAPI BOOL      WINAPI IsTextUnicode( CONST VOID *, int, LPINT );
WINADVAPI BOOL      WINAPI IsTokenRestricted( HANDLE );
WINADVAPI BOOL      WINAPI IsTokenUntrusted( HANDLE );
WINADVAPI BOOL      WINAPI IsValidAcl( PACL );
WINADVAPI BOOL      WINAPI IsValidRelativeSecurityDescriptor( PSECURITY_DESCRIPTOR, ULONG, SECURITY_INFORMATION );
WINADVAPI BOOL      WINAPI IsValidSecurityDescriptor( PSECURITY_DESCRIPTOR );
WINADVAPI BOOL      WINAPI IsValidSid( PSID );
WINADVAPI BOOL      WINAPI LogonUserA( LPCSTR, LPCSTR, LPCSTR, DWORD, DWORD, PHANDLE );
WINADVAPI BOOL      WINAPI LogonUserExA( LPCSTR, LPCSTR, LPCSTR, DWORD, DWORD, PHANDLE, PSID *, PVOID *, LPDWORD, PQUOTA_LIMITS );
WINADVAPI BOOL      WINAPI LogonUserExW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, DWORD, PHANDLE, PSID *, PVOID *, LPDWORD, PQUOTA_LIMITS );
WINADVAPI BOOL      WINAPI LogonUserW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, DWORD, PHANDLE );
WINADVAPI BOOL      WINAPI LookupAccountNameA( LPCSTR, LPCSTR, PSID, LPDWORD, LPSTR, LPDWORD, PSID_NAME_USE );
WINADVAPI BOOL      WINAPI LookupAccountNameW( LPCWSTR, LPCWSTR, PSID, LPDWORD, LPWSTR, LPDWORD, PSID_NAME_USE );
WINADVAPI BOOL      WINAPI LookupAccountSidA( LPCSTR, PSID, LPSTR, LPDWORD, LPSTR, LPDWORD, PSID_NAME_USE );
WINADVAPI BOOL      WINAPI LookupAccountSidW( LPCWSTR, PSID, LPWSTR, LPDWORD, LPWSTR, LPDWORD, PSID_NAME_USE );
WINADVAPI BOOL      WINAPI LookupPrivilegeDisplayNameA( LPCSTR, LPCSTR, LPSTR, LPDWORD, LPDWORD );
WINADVAPI BOOL      WINAPI LookupPrivilegeDisplayNameW( LPCWSTR, LPCWSTR, LPWSTR, LPDWORD, LPDWORD );
WINADVAPI BOOL      WINAPI LookupPrivilegeNameA( LPCSTR, PLUID, LPSTR, LPDWORD );
WINADVAPI BOOL      WINAPI LookupPrivilegeNameW( LPCWSTR, PLUID, LPWSTR, LPDWORD );
WINADVAPI BOOL      WINAPI LookupPrivilegeValueA( LPCSTR, LPCSTR, PLUID );
WINADVAPI BOOL      WINAPI LookupPrivilegeValueW( LPCWSTR, LPCWSTR, PLUID );
WINADVAPI BOOL      WINAPI MakeAbsoluteSD( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, LPDWORD, PACL, LPDWORD, PACL, LPDWORD, PSID, LPDWORD, PSID, LPDWORD );
WINADVAPI BOOL      WINAPI MakeAbsoluteSD2( PSECURITY_DESCRIPTOR, LPDWORD );
WINADVAPI BOOL      WINAPI MakeSelfRelativeSD( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, LPDWORD );
WINADVAPI VOID      WINAPI MapGenericMask( PDWORD, PGENERIC_MAPPING );
WINADVAPI BOOL      WINAPI NotifyChangeEventLog( HANDLE, HANDLE );
WINADVAPI BOOL      WINAPI ObjectCloseAuditAlarmA( LPCSTR, LPVOID, BOOL );
WINADVAPI BOOL      WINAPI ObjectCloseAuditAlarmW( LPCWSTR, LPVOID, BOOL );
WINADVAPI BOOL      WINAPI ObjectDeleteAuditAlarmA( LPCSTR, LPVOID, BOOL );
WINADVAPI BOOL      WINAPI ObjectDeleteAuditAlarmW( LPCWSTR, LPVOID, BOOL );
WINADVAPI BOOL      WINAPI ObjectOpenAuditAlarmA( LPCSTR, LPVOID, LPSTR, LPSTR, PSECURITY_DESCRIPTOR, HANDLE, DWORD, DWORD, PPRIVILEGE_SET, BOOL, BOOL, LPBOOL );
WINADVAPI BOOL      WINAPI ObjectOpenAuditAlarmW( LPCWSTR, LPVOID, LPWSTR, LPWSTR, PSECURITY_DESCRIPTOR, HANDLE, DWORD, DWORD, PPRIVILEGE_SET, BOOL, BOOL, LPBOOL );
WINADVAPI BOOL      WINAPI ObjectPrivilegeAuditAlarmA( LPCSTR, LPVOID, HANDLE, DWORD, PPRIVILEGE_SET, BOOL );
WINADVAPI BOOL      WINAPI ObjectPrivilegeAuditAlarmW( LPCWSTR, LPVOID, HANDLE, DWORD, PPRIVILEGE_SET, BOOL );
WINADVAPI HANDLE    WINAPI OpenBackupEventLogA( LPCSTR, LPCSTR );
WINADVAPI HANDLE    WINAPI OpenBackupEventLogW( LPCWSTR, LPCWSTR );
WINADVAPI DWORD     WINAPI OpenEncryptedFileRawA( LPCSTR, ULONG, PVOID * );
WINADVAPI DWORD     WINAPI OpenEncryptedFileRawW( LPCWSTR, ULONG, PVOID * );
WINADVAPI HANDLE    WINAPI OpenEventLogA( LPCSTR, LPCSTR );
WINADVAPI HANDLE    WINAPI OpenEventLogW( LPCWSTR, LPCWSTR );
WINADVAPI BOOL      WINAPI OpenProcessToken( HANDLE, DWORD, PHANDLE );
WINADVAPI BOOL      WINAPI OpenThreadToken( HANDLE, DWORD, BOOL, PHANDLE );
WINADVAPI BOOL      WINAPI PrivilegeCheck( HANDLE, PPRIVILEGE_SET, LPBOOL );
WINADVAPI BOOL      WINAPI PrivilegedServiceAuditAlarmA( LPCSTR, LPCSTR, HANDLE, PPRIVILEGE_SET, BOOL );
WINADVAPI BOOL      WINAPI PrivilegedServiceAuditAlarmW( LPCWSTR, LPCWSTR, HANDLE, PPRIVILEGE_SET, BOOL );
WINADVAPI VOID      WINAPI QuerySecurityAccessMask( SECURITY_INFORMATION, LPDWORD );
WINADVAPI DWORD     WINAPI ReadEncryptedFileRaw( PFE_EXPORT_FUNC, PVOID, PVOID );
WINADVAPI BOOL      WINAPI ReadEventLogA( HANDLE, DWORD, DWORD, LPVOID, DWORD, DWORD *, DWORD * );
WINADVAPI BOOL      WINAPI ReadEventLogW( HANDLE, DWORD, DWORD, LPVOID, DWORD, DWORD *, DWORD * );
WINADVAPI HANDLE    WINAPI RegisterEventSourceA( LPCSTR, LPCSTR );
WINADVAPI HANDLE    WINAPI RegisterEventSourceW( LPCWSTR, LPCWSTR );
WINADVAPI BOOL      WINAPI ReportEventA( HANDLE, WORD, WORD, DWORD, PSID, WORD, DWORD, LPCSTR *, LPVOID );
WINADVAPI BOOL      WINAPI ReportEventW( HANDLE, WORD, WORD, DWORD, PSID, WORD, DWORD, LPCWSTR *, LPVOID );
WINADVAPI BOOL      WINAPI RevertToSelf( VOID );
WINADVAPI BOOL      WINAPI SetAclInformation( PACL, LPVOID, DWORD, ACL_INFORMATION_CLASS );
WINADVAPI BOOL      WINAPI SetFileSecurityA( LPCSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
WINADVAPI BOOL      WINAPI SetFileSecurityW( LPCWSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
WINADVAPI BOOL      WINAPI SetKernelObjectSecurity( HANDLE, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
WINADVAPI BOOL      WINAPI SetPrivateObjectSecurity( SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, PGENERIC_MAPPING, HANDLE );
WINADVAPI VOID      WINAPI SetSecurityAccessMask( SECURITY_INFORMATION, LPDWORD );
WINADVAPI BOOL      WINAPI SetSecurityDescriptorDacl( PSECURITY_DESCRIPTOR, BOOL, PACL, BOOL );
WINADVAPI BOOL      WINAPI SetSecurityDescriptorGroup( PSECURITY_DESCRIPTOR, PSID, BOOL );
WINADVAPI BOOL      WINAPI SetSecurityDescriptorOwner( PSECURITY_DESCRIPTOR, PSID, BOOL );
WINADVAPI DWORD     WINAPI SetSecurityDescriptorRMControl( PSECURITY_DESCRIPTOR, PUCHAR );
WINADVAPI BOOL      WINAPI SetSecurityDescriptorSacl( PSECURITY_DESCRIPTOR, BOOL, PACL, BOOL );
WINADVAPI BOOL      WINAPI SetThreadToken( PHANDLE, HANDLE );
WINADVAPI BOOL      WINAPI SetTokenInformation( HANDLE, TOKEN_INFORMATION_CLASS, LPVOID, DWORD );
WINADVAPI DWORD     WINAPI WriteEncryptedFileRaw( PFE_IMPORT_FUNC, PVOID, PVOID );
#if (_WIN32_WINNT >= 0x0400)
WINADVAPI BOOL      WINAPI GetCurrentHwProfileA( LPHW_PROFILE_INFOA );
WINADVAPI BOOL      WINAPI GetCurrentHwProfileW( LPHW_PROFILE_INFOW );
#endif
#if (_WIN32_WINNT >= 0x0500)
WINADVAPI BOOL      WINAPI AccessCheckByType( PSECURITY_DESCRIPTOR, PSID, HANDLE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, PPRIVILEGE_SET, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeAndAuditAlarmA( LPCSTR, LPVOID, LPCSTR, LPCSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPBOOL, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeAndAuditAlarmW( LPCWSTR, LPVOID, LPCWSTR, LPCWSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPBOOL, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeResultList( PSECURITY_DESCRIPTOR, PSID, HANDLE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, PPRIVILEGE_SET, LPDWORD, LPDWORD, LPDWORD );
WINADVAPI BOOL      WINAPI AccessCheckByTypeResultListAndAuditAlarmA( LPCSTR, LPVOID, LPCSTR, LPCSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeResultListAndAuditAlarmByHandleA( LPCSTR, LPVOID, HANDLE, LPCSTR, LPCSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeResultListAndAuditAlarmByHandleW( LPCWSTR, LPVOID, HANDLE, LPCWSTR, LPCWSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AccessCheckByTypeResultListAndAuditAlarmW( LPCWSTR, LPVOID, LPCWSTR, LPCWSTR, PSECURITY_DESCRIPTOR, PSID, DWORD, AUDIT_EVENT_TYPE, DWORD, POBJECT_TYPE_LIST, DWORD, PGENERIC_MAPPING, BOOL, LPDWORD, LPDWORD, LPBOOL );
WINADVAPI BOOL      WINAPI AddAccessAllowedAceEx( PACL, DWORD, DWORD, DWORD, PSID );
WINADVAPI BOOL      WINAPI AddAccessAllowedObjectAce( PACL, DWORD, DWORD, DWORD, GUID *, GUID *, PSID );
WINADVAPI BOOL      WINAPI AddAccessDeniedAceEx( PACL, DWORD, DWORD, DWORD, PSID );
WINADVAPI BOOL      WINAPI AddAccessDeniedObjectAce( PACL, DWORD, DWORD, DWORD, GUID *, GUID *, PSID );
WINADVAPI BOOL      WINAPI AddAuditAccessAceEx( PACL, DWORD, DWORD, DWORD, PSID, BOOL, BOOL );
WINADVAPI BOOL      WINAPI AddAuditAccessObjectAce( PACL, DWORD, DWORD, DWORD, GUID *, GUID *, PSID, BOOL, BOOL );
WINADVAPI BOOL      WINAPI ConvertToAutoInheritPrivateObjectSecurity( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, GUID *, BOOLEAN, PGENERIC_MAPPING );
WINADVAPI BOOL      WINAPI CreatePrivateObjectSecurityEx( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, GUID *, BOOL, ULONG, HANDLE, PGENERIC_MAPPING );
WINADVAPI BOOL      WINAPI CreatePrivateObjectSecurityWithMultipleInheritance( PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, GUID **, ULONG, BOOL, ULONG, HANDLE, PGENERIC_MAPPING );
WINADVAPI BOOL      WINAPI CreateProcessWithLogonW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, LPCWSTR, LPWSTR, DWORD, LPVOID, LPCWSTR, LPSTARTUPINFOW, LPPROCESS_INFORMATION );
WINADVAPI BOOL      WINAPI CreateProcessWithTokenW( HANDLE, DWORD, LPCWSTR, LPWSTR, DWORD, LPVOID, LPCWSTR, LPSTARTUPINFOW, LPPROCESS_INFORMATION );
WINADVAPI BOOL      WINAPI SetPrivateObjectSecurityEx( SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, PSECURITY_DESCRIPTOR *, ULONG, PGENERIC_MAPPING, HANDLE );
WINADVAPI BOOL      WINAPI SetSecurityDescriptorControl( PSECURITY_DESCRIPTOR, SECURITY_DESCRIPTOR_CONTROL, SECURITY_DESCRIPTOR_CONTROL );
#endif
#if (_WIN32_WINNT >= 0x0501)
WINADVAPI BOOL      WINAPI CreateWellKnownSid( WELL_KNOWN_SID_TYPE, PSID, PSID, DWORD * );
WINADVAPI BOOL      WINAPI EqualDomainSid( PSID, PSID, BOOL * );
WINADVAPI BOOL      WINAPI GetWindowsAccountDomainSid( PSID, PSID, DWORD * );
WINADVAPI BOOL      WINAPI IsWellKnownSid( PSID, WELL_KNOWN_SID_TYPE );
#endif
#if (_WIN32_WINNT >= 0x0600)
WINADVAPI BOOL      WINAPI AddMandatoryAce( PACL, DWORD, DWORD, DWORD, PSID );
#endif
#if (_WIN32_WINNT >= 0x0601)
WINADVAPI BOOL      WINAPI AddConditionalAce( PACL, DWORD, DWORD, UCHAR, DWORD, PSID, PWCHAR, DWORD * );
#endif

/* Functions implemented as macros */
#define DefineHandleTable( x )          ((x), TRUE)
#define LimitEmsPages( x )
#define SetSwapAreaSize( x )            (x)
#define LockSegment( x )                GlobalFix( (HANDLE)(x) )
#define UnlockSegment( x )              GlobalUnfix( (HANDLE)(x) )
#define GetCurrentTime()                GetTickCount()
#define Yield()
#define FreeModule( x )                 FreeLibrary( x )
#define MakeProcInstance( p1, p2 )      (p1)
#define FreeProcInstance( x )           (x)
#define GlobalLRUNewest( x )            ((HANDLE)(x))
#define GlobalLRUOldest( x )            ((HANDLE)(x))
#define GlobalDiscard( x )              GlobalReAlloc( (x), 0, GMEM_MOVEABLE )
#define LocalDiscard( x )               LocalDiscard( (x), 0, LMEM_MOVEABLE )
#define GetFreeSpace( x )               0x00100000L
#define InterlockedExchangePointer( p1, p2 )    (PVOID)InterlockedExchange( (PLONG)(p1), (LONG)(p2) )
#define InterlockedCompareExchangePointer( p1, p2, p3)  (PVOID)(LONG_PTR)InterlockedCompareExchange( (LONG volatile *)(p1), (LONG)(LONG_PTR)(p2), (LONG)(LONG_PTR)(p3) )
#define UnlockResource( x )             ((void)(x), 0)
#define HasOverlappedIoCompleted( x )   (((DWORD)(x)->Internal) != STATUS_PENDING)
#if (_WIN32_WINNT >= 0x0600)
    #define ProcThreadAttributeValue( p1, p2, p3, p4 ) \
        (((p1) & PROC_THREAD_ATTRIBUTE_NUMBER) | \
        ((p2 != FALSE) ? PROC_THREAD_ATTRIBUTE_THREAD : 0) | \
        ((p3 != FALSE) ? PROC_THREAD_ATTRIBUTE_INPUT : 0) | \
        ((p4 != FALSE) ? PROC_THREAD_ATTRIBUTE_ADDITIVE : 0))
#endif

/* Predefined process and thread attribute values */
#if (_WIN32_WINNT >= 0x0600)
    #define PROC_THREAD_ATTRIBUTE_PARENT_PROCESS \
        ProcThreadAttributeValue( ProcThreadAttributeParentProcess, FALSE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_EXTENDED_FLAGS \
        ProcThreadAttributeValue( ProcThreadAttributeExtendedFlags, FALSE, TRUE, TRUE )
    #define PROC_THREAD_ATTRIBUTE_HANDLE_LIST \
        ProcThreadAttributeValue( ProcThreadAttributeHandleList, FALSE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_GROUP_AFFINITY \
        ProcThreadAttributeValue( ProcThreadAttributeGroupAffinity, TRUE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_PREFERRED_NODE \
        ProcThreadAttributeValue( ProcThreadAttributePreferredNode, FALSE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_IDEAL_PROCESSOR \
        ProcThreadAttributeValue( ProcThreadAttributeIdealProcessor, TRUE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_UMS_THREAD \
        ProcThreadAttributeValue( ProcThreadAttributeUmsThread, TRUE, TRUE, FALSE )
    #define PROC_THREAD_ATTRIBUTE_MITIGATION_POLICY \
        ProcThreadAttributeValue( ProcThreadAttributeMitigationPolicy, FALSE, TRUE, FALSE )
#endif

/* Aliases for macros defined in winnt.h */
#define MoveMemory                          RtlMoveMemory
#define CopyMemory                          RtlCopyMemory
#define FillMemory                          RtlFillMemory
#define ZeroMemory                          RtlZeroMemory
#define CaptureStackBackTrace               RtlCaptureStackBackTrace
#define InitializeThreadpoolEnvironment     TpInitializeCallbackEnviron
#define SetThreadpoolCallbackPool           TpSetCallbackThreadpool
#define SetThreadpoolCallbackCleanupGroup   TpSetCallbackCleanupGroup
#define SetThreadpoolCallbackRunsLong       TpSetCallbackLongFunction
#define SetThreadpoolCallbackLibrary        TpSetCallbackRaceWithDll
#define SetThreadpoolCallbackPersistent     TpSetCallbackPersistent
#define DestroyThreadpoolEnvironment        TpDestroyCallbackEnviron
#if (_WIN32_WINNT >= 0x0601)
    #define SetThreadpoolCallbackPriority   TpSetCallbackPriority
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define AccessCheckAndAuditAlarm        AccessCheckAndAuditAlarmW
    #define AddAtom                         AddAtomW
    #define BackupEventLog                  BackupEventLogW
    #define BeginUpdateResource             BeginUpdateResourceW
    #define BuildCommDCB                    BuildCommDCBW
    #define BuildCommDCBAndTimeouts         BuildCommDCBAndTimeoutsW
    #define CallNamedPipe                   CallNamedPipeW
    #define CommConfigDialog                CommConfigDialogW
    #define CopyFile                        CopyFileW
    #define ClearEventLog                   ClearEventLogW
    #define CreateDirectory                 CreateDirectoryW
    #define CreateDirectoryEx               CreateDirectoryExW
    #define CreateEvent                     CreateEventW
    #define CreateFile                      CreateFileW
    #define CreateFileMapping               CreateFileMappingW
    #define CreateMailslot                  CreateMailslotW
    #define CreateMutex                     CreateMutexW
    #define CreateNamedPipe                 CreateNamedPipeW
    #define CreateProcess                   CreateProcessW
    #define CreateProcessAsUser             CreateProcessAsUserW
    #define CreateSemaphore                 CreateSemaphoreW
    #define DecryptFile                     DecryptFileW
    #define DefineDosDevice                 DefineDosDeviceW
    #define DeleteFile                      DeleteFileW
    #define EncryptFile                     EncryptFileW
    #define EndUpdateResource               EndUpdateResourceW
    #define EnumResourceLanguages           EnumResourceLanguagesW
    #define EnumResourceLanguagesEx         EnumResourceLanguagesExW
    #define EnumResourceNames               EnumResourceNamesW
    #define EnumResourceNamesEx             EnumResourceNamesExW
    #define EnumResourceTypes               EnumResourceTypesW
    #define EnumResourceTypesEx             EnumResourceTypesExW
    #define ExpandEnvironmentStrings        ExpandEnvironmentStringsW
    #define FatalAppExit                    FatalAppExitW
    #define FileEncryptionStatus            FileEncryptionStatusW
    #define FindAtom                        FindAtomW
    #define FindFirstChangeNotification     FindFirstChangeNotificationW
    #define FindFirstFile                   FindFirstFileW
    #define FindNextFile                    FindNextFileW
    #define FindResource                    FindResourceW
    #define FindResourceEx                  FindResourceExW
    #define FormatMessage                   FormatMessageW
    #define FreeEnvironmentStrings          FreeEnvironmentStringsW
    #define GetAtomName                     GetAtomNameW
    #define GetBinaryType                   GetBinaryTypeW
    #define GetCommandLine                  GetCommandLineW
    #define GetCompressedFileSize           GetCompressedFileSizeW
    #define GetComputerName                 GetComputerNameW
    #define GetCurrentDirectory             GetCurrentDirectoryW
    #define GetDefaultCommConfig            GetDefaultCommConfigW
    #define GetDiskFreeSpace                GetDiskFreeSpaceW
    #define GetDiskFreeSpaceEx              GetDiskFreeSpaceExW
    #define GetDriveType                    GetDriveTypeW
    #define GetEnvironmentStrings           GetEnvironmentStringsW
    #define GetEnvironmentVariable          GetEnvironmentVariableW
    #define GetFileAttributes               GetFileAttributesW
    #define GetFileAttributesEx             GetFileAttributesExW
    #define GetFileSecurity                 GetFileSecurityW
    #define GetFirmwareEnvironmentVariable  GetFirmwareEnvironmentVariableW
    #define GetFullPathName                 GetFullPathNameW
    #define GetLogicalDriveStrings          GetLogicalDriveStringsW
    #define GetLongPathName                 GetLongPathNameW
    #define GetModuleFileName               GetModuleFileNameW
    #define GetModuleHandle                 GetModuleHandleW
    #define GetNamedPipeClientComputerName  GetNamedPipeClientComputerNameW
    #define GetNamedPipeHandleState         GetNamedPipeHandleStateW
    #define GetPrivateProfileInt            GetPrivateProfileIntW
    #define GetPrivateProfileSection        GetPrivateProfileSectionW
    #define GetPrivateProfileSectionNames   GetPrivateProfileSectionNamesW
    #define GetPrivateProfileString         GetPrivateProfileStringW
    #define GetPrivateProfileStruct         GetPrivateProfileStructW
    #define GetProfileInt                   GetProfileIntW
    #define GetProfileSection               GetProfileSectionW
    #define GetProfileString                GetProfileStringW
    #define GetShortPathName                GetShortPathNameW
    #define GetStartupInfo                  GetStartupInfoW
    #define GetSystemDirectory              GetSystemDirectoryW
    #define GetSystemWindowsDirectory       GetSystemWindowsDirectoryW
    #define GetTempFileName                 GetTempFileNameW
    #define GetTempPath                     GetTempPathW
    #define GetUserName                     GetUserNameW
    #define GetVersionEx                    GetVersionExW
    #define GetVolumeInformation            GetVolumeInformationW
    #define GetWindowsDirectory             GetWindowsDirectoryW
    #define GlobalAddAtom                   GlobalAddAtomW
    #define GlobalFindAtom                  GlobalFindAtomW
    #define GlobalGetAtomName               GlobalGetAtomNameW
    #define IsBadStringPtr                  IsBadStringPtrW
    #define LoadLibrary                     LoadLibraryW
    #define LoadLibraryEx                   LoadLibraryExW
    #define LogonUser                       LogonUserW
    #define LogonUserEx                     LogonUserExW
    #define LookupAccountName               LookupAccountNameW
    #define LookupAccountSid                LookupAccountSidW
    #define LookupPrivilegeDisplayName      LookupPrivilegeDisplayNameW
    #define LookupPrivilegeName             LookupPrivilegeNameW
    #define LookupPrivilegeValue            LookupPrivilegeValueW
    #define MoveFile                        MoveFileW
    #define MoveFileEx                      MoveFileExW
    #define ObjectCloseAuditAlarm           ObjectCloseAuditAlarmW
    #define ObjectDeleteAuditAlarm          ObjectDeleteAuditAlarmW
    #define ObjectOpenAuditAlarm            ObjectOpenAuditAlarmW
    #define ObjectPrivilegeAuditAlarm       ObjectPrivilegeAuditAlarmW
    #define OpenBackupEventLog              OpenBackupEventLogW
    #define OpenEncryptedFileRaw            OpenEncryptedFileRawW
    #define OpenEvent                       OpenEventW
    #define OpenEventLog                    OpenEventLogW
    #define OpenFileMapping                 OpenFileMappingW
    #define OpenMutex                       OpenMutexW
    #define OpenSemaphore                   OpenSemaphoreW
    #define OutputDebugString               OutputDebugStringW
    #define PrivilegedServiceAuditAlarm     PrivilegedServiceAuditAlarmW
    #define QueryDosDevice                  QueryDosDeviceW
    #define ReadEventLog                    ReadEventLogW
    #define RegisterEventSource             RegisterEventSourceW
    #define RemoveDirectory                 RemoveDirectoryW
    #define ReportEvent                     ReportEventW
    #define SearchPath                      SearchPathW
    #define SetComputerName                 SetComputerNameW
    #define SetCurrentDirectory             SetCurrentDirectoryW
    #define SetDefaultCommConfig            SetDefaultCommConfigW
    #define SetEnvironmentStrings           SetEnvironmentStringsW
    #define SetEnvironmentVariable          SetEnvironmentVariableW
    #define SetFileAttributes               SetFileAttributesW
    #define SetFileSecurity                 SetFileSecurityW
    #define SetFileShortName                SetFileShortNameW
    #define SetFirmwareEnvironmentVariable  SetFirmwareEnvironmentVariableW
    #define SetVolumeLabel                  SetVolumeLabelW
    #define UpdateResource                  UpdateResourceW
    #define VerifyVersionInfo               VerifyVersionInfoW
    #define WaitNamedPipe                   WaitNamedPipeW
    #define WritePrivateProfileSection      WritePrivateProfileSectionW
    #define WritePrivateProfileString       WritePrivateProfileStringW
    #define WritePrivateProfileStruct       WritePrivateProfileStructW
    #define WriteProfileSection             WriteProfileSectionW
    #define WriteProfileString              WriteProfileStringW
    #define lstrcat                         lstrcatW
    #define lstrcmp                         lstrcmpW
    #define lstrcmpi                        lstrcmpiW
    #define lstrcpy                         lstrcpyW
    #define lstrcpyn                        lstrcpynW
    #define lstrlen                         lstrlenW
    #if (_WIN32_WINNT >= 0x0400)
        #define CopyFileEx                  CopyFileExW
        #define FindFirstFileEx             FindFirstFileExW
    #endif
    #if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
        #define CreateWaitableTimer         CreateWaitableTimerW
        #define OpenWaitableTimer           OpenWaitableTimerW
    #endif
    #if (_WIN32_WINNT >= 0x0500)
        #define AccessCheckByTypeAndAuditAlarm  AccessCheckByTypeAndAuditAlarmW
        #define AccessCheckByTypeResultListAndAuditAlarm    AccessCheckByTypeResultListAndAuditAlarmW
        #define AccessCheckByTypeResultListAndAuditAlarmByHandle    AccessCheckByTypeResultListAndAuditAlarmByHandleW
        #define CreateActCtx                CreateActCtxW
        #define CreateHardLink              CreateHardLinkW
        #define CreateJobObject             CreateJobObjectW
        #define DeleteVolumeMountPoint      DeleteVolumeMountPointW
        #define DnsHostnameToComputerName   DnsHostnameToComputerNameW
        #define FindActCtxSectionString     FindActCtxSectionStringW
        #define FindFirstVolume             FindFirstVolumeW
        #define FindFirstVolumeMountPoint   FindFirstVolumeMountPointW
        #define FindNextVolume              FindNextVolumeW
        #define FindNextVolumeMountPoint    FindNextVolumeMountPointW
        #define GetComputerNameEx           GetComputerNameExW
        #define GetVolumeNameForVolumeMountPoint    GetVolumeNameForVolumeMountPointW
        #define GetVolumePathName           GetVolumePathNameW
        #define MoveFileWithProgress        MoveFileWithProgressW
        #define OpenJobObject               OpenJobObjectW
        #define ReplaceFile                 ReplaceFileW
        #define SetComputerNameEx           SetComputerNameExW
        #define SetVolumeMountPoint         SetVolumeMountPointW
    #endif
    #if (_WIN32_WINNT >= 0x0501)
        #define CheckNameLegalDOS8Dot3      CheckNameLegalDOS8Dot3W
        #define GetModuleHandleEx           GetModuleHandleExW
        #define GetSystemWow64Directory     GetSystemWow64DirectoryW
        #define GetVolumePathNamesForVolumeName GetVolumePathNamesForVolumeNameW
    #endif
    #if (_WIN32_WINNT >= 0x0502)
        #define GetDllDirectory             GetDllDirectoryW
        #define NeedCurrentDirectoryForExePath  NeedCurrentDirectoryForExePathW
        #define SetDllDirectory             SetDllDirectoryW
    #endif
    #if (_WIN32_WINNT >= 0x0600)
        #define CopyFileTransacted          CopyFileTransactedW
        #define CreateBoundaryDescriptor    CreateBoundaryDescriptorW
        #define CreateDirectoryTransacted   CreateDirectoryTransactedW
        #define CreateEventEx               CreateEventExW
        #define CreateFileMappingNuma       CreateFileMappingNumaW
        #define CreateFileTransacted        CreateFileTransactedW
        #define CreateHardLinkTransacted    CreateHardLinkTransactedW
        #define CreateMutexEx               CreateMutexExW
        #define CreatePrivateNamespace      CreatePrivateNamespaceW
        #define CreateSemaphoreEx           CreateSemaphoreExW
        #define CreateSymbolicLink          CreateSymbolicLinkW
        #define CreateSymbolicLinkTransacted    CreateSymbolicLinkTransactedW
        #define CreateWaitableTimerEx       CreateWaitableTimerExW
        #define DeleteFileTransacted        DeleteFileTransactedW
        #define FindFirstFileTransacted     FindFirstFileTransactedW
        #define GetCompressedFileSizeTransacted GetCompressedFileSizeTransactedW
        #define GetFileAttributesTransacted GetFileAttributesTransactedW
        #define GetFinalPathNameByHandle    GetFinalPathNameByHandleW
        #define GetFullPathNameTransacted   GetFullPathNameTransactedW
        #define GetLongPathNameTransacted   GetLongPathNameTransactedW
        #define MoveFileTransacted          MoveFileTransactedW
        #define OpenPrivateNamespace        OpenPrivateNamespaceW
        #define QueryFullProcessImageName   QueryFullProcessImageNameW
        #define RemoveDirectoryTransacted   RemoveDirectoryTransactedW
        #define SetFileAttributesTransacted SetFileAttributesTransactedW
    #endif
#else
    #define AcesssCheckAndAuditAlarm        AccessCheckAndAuditAlarmA
    #define AddAtom                         AddAtomA
    #define BackupEventLog                  BackupEventLogA
    #define BeginUpdateResource             BeginUpdateResourceA
    #define BuildCommDCB                    BuildCommDCBA
    #define BuildCommDCBAndTimeouts         BuildCommDCBAndTimeoutsA
    #define CallNamedPipe                   CallNamedPipeA
    #define ClearEventLog                   ClearEventLogA
    #define CommConfigDialog                CommConfigDialogA
    #define CopyFile                        CopyFileA
    #define CreateBoundaryDescriptor        CreateBoundaryDescriptorA
    #define CreateDirectory                 CreateDirectoryA
    #define CreateDirectoryEx               CreateDirectoryExA
    #define CreateEvent                     CreateEventA
    #define CreateFile                      CreateFileA
    #define CreateFileMapping               CreateFileMappingA
    #define CreateMailslot                  CreateMailslotA
    #define CreateMutex                     CreateMutexA
    #define CreateNamedPipe                 CreateNamedPipeA
    #define CreateProcess                   CreateProcessA
    #define CreateProcessAsUser             CreateProcessAsUserA
    #define CreateSemaphore                 CreateSemaphoreA
    #define DecryptFile                     DecryptFileA
    #define DefineDosDevice                 DefineDosDeviceA
    #define DeleteFile                      DeleteFileA
    #define EncryptFile                     EncryptFileA
    #define EndUpdateResource               EndUpdateResourceA
    #define EnumResourceLanguages           EnumResourceLanguagesA
    #define EnumResourceLanguagesEx         EnumResourceLanguagesExA
    #define EnumResourceNames               EnumResourceNamesA
    #define EnumResourceNamesEx             EnumResourceNamesExA
    #define EnumResourceTypes               EnumResourceTypesA
    #define EnumResourceTypesEx             EnumResourceTypesExA
    #define ExpandEnvironmentStrings        ExpandEnvironmentStringsA
    #define FatalAppExit                    FatalAppExitA
    #define FileEncryptionStatus            FileEncryptionStatusA
    #define FindAtom                        FindAtomA
    #define FindFirstChangeNotification     FindFirstChangeNotificationA
    #define FindFirstFile                   FindFirstFileA
    #define FindNextFile                    FindNextFileA
    #define FindResource                    FindResourceA
    #define FindResourceEx                  FindResourceExA
    #define FormatMessage                   FormatMessageA
    #define FreeEnvironmentStrings          FreeEnvironmentStringsA
    #define GetAtomName                     GetAtomNameA
    #define GetBinaryType                   GetBinaryTypeA
    #define GetCommandLine                  GetCommandLineA
    #define GetCompressedFileSize           GetCompressedFileSizeA
    #define GetComputerName                 GetComputerNameA
    #define GetCurrentDirectory             GetCurrentDirectoryA
    #define GetDefaultCommConfig            GetDefaultCommConfigA
    #define GetDiskFreeSpace                GetDiskFreeSpaceA
    #define GetDiskFreeSpaceEx              GetDiskFreeSpaceExA
    #define GetDriveType                    GetDriveTypeA
    #define GetEnvironmentStrings           GetEnvironmentStringsA
    #define GetEnvironmentVariable          GetEnvironmentVariableA
    #define GetFileAttributes               GetFileAttributesA
    #define GetFileAttributesEx             GetFileAttributesExA
    #define GetFileSecurity                 GetFileSecurityA
    #define GetFirmwareEnvironmentVariable  GetFirmwareEnvironmentVariableA
    #define GetFullPathName                 GetFullPathNameA
    #define GetLogicalDriveStrings          GetLogicalDriveStringsA
    #define GetLongPathName                 GetLongPathNameA
    #define GetModuleFileName               GetModuleFileNameA
    #define GetModuleHandle                 GetModuleHandleA
    #define GetNamedPipeClientComputerName  GetNamedPipeClientComputerNameA
    #define GetNamedPipeHandleState         GetNamedPipeHandleStateA
    #define GetPrivateProfileInt            GetPrivateProfileIntA
    #define GetPrivateProfileSection        GetPrivateProfileSectionA
    #define GetPrivateProfileSectionNames   GetPrivateProfileSectionNamesA
    #define GetPrivateProfileString         GetPrivateProfileStringA
    #define GetPrivateProfileStruct         GetPrivateProfileStructA
    #define GetProfileInt                   GetProfileIntA
    #define GetProfileSection               GetProfileSectionA
    #define GetProfileString                GetProfileStringA
    #define GetShortPathName                GetShortPathNameA
    #define GetStartupInfo                  GetStartupInfoA
    #define GetSystemDirectory              GetSystemDirectoryA
    #define GetSystemWindowsDirectory       GetSystemWindowsDirectoryA
    #define GetTempFileName                 GetTempFileNameA
    #define GetTempPath                     GetTempPathA
    #define GetUserName                     GetUserNameA
    #define GetVersionEx                    GetVersionExA
    #define GetVolumeInformation            GetVolumeInformationA
    #define GetWindowsDirectory             GetWindowsDirectoryA
    #define GlobalAddAtom                   GlobalAddAtomA
    #define GlobalFindAtom                  GlobalFindAtomA
    #define GlobalGetAtomName               GlobalGetAtomNameA
    #define IsBadStringPtr                  IsBadStringPtrA
    #define LoadLibrary                     LoadLibraryA
    #define LoadLibraryEx                   LoadLibraryExA
    #define LogonUser                       LogonUserA
    #define LogonUserEx                     LogonUserExA
    #define LookupAccountName               LookupAccountNameA
    #define LookupAccountSid                LookupAccountSidA
    #define LookupPrivilegeDisplayName      LookupPrivilegeDisplayNameA
    #define LookupPrivilegeName             LookupPrivilegeNameA
    #define LookupPrivilegeValue            LookupPrivilegeValueA
    #define MoveFile                        MoveFileA
    #define MoveFileEx                      MoveFileExA
    #define ObjectCloseAuditAlarm           ObjectCloseAuditAlarmA
    #define ObjectDeleteAuditAlarm          ObjectDeleteAuditAlarmA
    #define ObjectOpenAuditAlarm            ObjectOpenAuditAlarmA
    #define ObjectPrivilegeAuditAlarm       ObjectPrivilegeAuditAlarmA
    #define OpenBackupEventLog              OpenBackupEventLogA
    #define OpenEncryptedFileRaw            OpenEncryptedFileRawA
    #define OpenEvent                       OpenEventA
    #define OpenEventLog                    OpenEventLogA
    #define OpenFileMapping                 OpenFileMappingA
    #define OpenMutex                       OpenMutexA
    #define OpenSemaphore                   OpenSemaphoreA
    #define OutputDebugString               OutputDebugStringA
    #define PrivilegedServiceAuditAlarm     PrivilegedServiceAuditAlarmA
    #define QueryDosDevice                  QueryDosDeviceA
    #define ReadEventLog                    ReadEventLogA
    #define RegisterEventSource             RegisterEventSourceA
    #define RemoveDirectory                 RemoveDirectoryA
    #define ReportEvent                     ReportEventA
    #define SearchPath                      SearchPathA
    #define SetComputerName                 SetComputerNameA
    #define SetCurrentDirectory             SetCurrentDirectoryA
    #define SetDefaultCommConfig            SetDefaultCommConfigA
    #define SetEnvironmentStrings           SetEnvironmentStringsA
    #define SetEnvironmentVariable          SetEnvironmentVariableA
    #define SetFileAttributes               SetFileAttributesA
    #define SetFileSecurity                 SetFileSecurityA
    #define SetFileShortName                SetFileShortNameA
    #define SetFirmwareEnvironmentVariable  SetFirmwareEnvironmentVariableA
    #define SetVolumeLabel                  SetVolumeLabelA
    #define UpdateResource                  UpdateResourceA
    #define VerifyVersionInfo               VerifyVersionInfoA
    #define WaitNamedPipe                   WaitNamedPipeA
    #define WritePrivateProfileSection      WritePrivateProfileSectionA
    #define WritePrivateProfileString       WritePrivateProfileStringA
    #define WritePrivateProfileStruct       WritePrivateProfileStructA
    #define WriteProfileSection             WriteProfileSectionA
    #define WriteProfileString              WriteProfileStringA
    #define lstrcat                         lstrcatA
    #define lstrcmp                         lstrcmpA
    #define lstrcmpi                        lstrcmpiA
    #define lstrcpy                         lstrcpyA
    #define lstrcpyn                        lstrcpynA
    #define lstrlen                         lstrlenA
    #if (_WIN32_WINNT >= 0x0400)
        #define CopyFileEx                  CopyFileExA
        #define FindFirstFileEx             FindFirstFileExA
    #endif
    #if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
        #define CreateWaitableTimer         CreateWaitableTimerA
        #define OpenWaitableTimer           OpenWaitableTimerA
    #endif
    #if (_WIN32_WINNT >= 0x0500)
        #define AccessCheckByTypeAndAuditAlarm  AccessCheckByTypeAndAuditAlarmA
        #define AccessCheckByTypeResultListAndAuditAlarm    AccessCheckByTypeResultListAndAuditAlarmA
        #define AccessCheckByTypeResultListAndAuditAlarmByHandle    AccessCheckByTypeResultListAndAuditAlarmByHandleA
        #define CreateActCtx                CreateActCtxA
        #define CreateHardLink              CreateHardLinkA
        #define CreateJobObject             CreateJobObjectA
        #define DeleteVolumeMountPoint      DeleteVolumeMountPointA
        #define DnsHostnameToComputerName   DnsHostnameToComputerNameA
        #define FindActCtxSectionString     FindActCtxSectionStringA
        #define FindFirstVolume             FindFirstVolumeA
        #define FindFirstVolumeMountPoint   FindFirstVolumeMountPointA
        #define FindNextVolume              FindNextVolumeA
        #define FindNextVolumeMountPoint    FindNextVolumeMountPointA
        #define GetComputerNameEx           GetComputerNameExA
        #define GetVolumeNameForVolumeMountPoint    GetVolumeNameForVolumeMountPointA
        #define GetVolumePathName           GetVolumePathNameA
        #define MoveFileWithProgress        MoveFileWithProgressA
        #define OpenJobObject               OpenJobObjectA
        #define ReplaceFile                 ReplaceFileA
        #define SetComputerNameEx           SetComputerNameExA
        #define SetVolumeMountPoint         SetVolumeMountPointA
    #endif
    #if (_WIN32_WINNT >= 0x0501)
        #define CheckNameLegalDOS8Dot3      CheckNameLegalDOS8Dot3A
        #define GetModuleHandleEx           GetModuleHandleExA
        #define GetSystemWow64Directory     GetSystemWow64DirectoryA
        #define GetVolumePathNamesForVolumeName GetVolumePathNamesForVolumeNameA
    #endif
    #if (_WIN32_WINNT >= 0x0502)
        #define GetDllDirectory             GetDllDirectoryA
        #define NeedCurrentDirectoryForExePath  NeedCurrentDirectoryForExePathA
        #define SetDllDirectory             SetDllDirectoryA
    #endif
    #if (_WIN32_WINNT >= 0x0600)
        #define CopyFileTransacted          CopyFileTransactedA
        #define CreateDirectoryTransacted   CreateDirectoryTransactedA
        #define CreateEventEx               CreateEventExA
        #define CreateFileMappingNuma       CreateFileMappingNumaA
        #define CreateFileTransacted        CreateFileTransactedA
        #define CreateHardLinkTransacted    CreateHardLinkTransactedA
        #define CreateMutexEx               CreateMutexExA
        #define CreatePrivateNamespace      CreatePrivateNamespaceA
        #define CreateSemaphoreEx           CreateSemaphoreExA
        #define CreateSymbolicLink          CreateSymbolicLinkA
        #define CreateSymbolicLinkTransacted    CreateSymbolicLinkTransactedA
        #define CreateWaitableTimerEx       CreateWaitableTimerExA
        #define DeleteFileTransacted        DeleteFileTransactedA
        #define FindFirstFileTransacted     FindFirstFileTransactedA
        #define GetCompressedFileSizeTransacted GetCompressedFileSizeTransactedA
        #define GetFileAttributesTransacted GetFileAttributesTransactedA
        #define GetFinalPathNameByHandle    GetFinalPathNameByHandleA
        #define GetFullPathNameTransacted   GetFullPathNameTransactedA
        #define GetLongPathNameTransacted   GetLongPathNameTransactedA
        #define MoveFileTransacted          MoveFileTransactedA
        #define OpenPrivateNamespace        OpenPrivateNamespaceA
        #define QueryFullProcessImageName   QueryFullProcessImageNameA
        #define RemoveDirectoryTransacted   RemoveDirectoryTransactedA
        #define SetFileAttributesTransacted SetFileAttributesTransactedA
    #endif
#endif

/* If the original Windows NT 3.1, a single function GetEnvironmentStrings()
 * without an A/W suffix was defined.  It did not support Unicode.  To enable
 * support for Windows NT 3.1 in code that calls GetEnvironmentStrings(),
 * define _OLD_WINNT_COMPATIBILE.  This will disable support for the Unicode
 * version of the function.
 */
#ifdef _OLD_WINNT_COMPATIBLE
#undef GetEnvironmentStrings
WINBASEAPI LPCH     WINAPI GetEnvironmentStrings( VOID );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINBASE_ */
