/*
 *  winnetwk.h  Win32 networking functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINNETWK_
#define _WINNETWK_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <wnnc.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Network resource scopes */
#define RESOURCE_CONNECTED      0x00000001L
#define RESOURCE_GLOBALNET      0x00000002L
#define RESOURCE_REMEMBERED     0x00000003L
#if (WINVER >= 0x0400)
    #define RESOURCE_RECENT     0x00000004L
    #define RESOURCE_CONTEXT    0x00000005L
#endif

/* Network resource types */
#define RESOURCETYPE_ANY            0x00000000L
#define RESOURCETYPE_DISK           0x00000001L
#define RESOURCETYPE_PRINT          0x00000002L
#if (WINVER >= 0x0400)
    #define RESOURCETYPE_RESERVED   0x00000008L
#endif
#define RESOURCETYPE_UNKNOWN        0xFFFFFFFFL

/* Network resource usage flags */
#define RESOURCEUSAGE_CONNECTABLE       0x00000001L
#define RESOURCEUSAGE_CONTAINER         0x00000002L
#if (WINVER >= 0x0400)
    #define RESOURCEUSAGE_NOLOCALDEVICE 0x00000004L
    #define RESOURCEUSAGE_SIBLING       0x00000008L
    #define RESOURCEUSAGE_ATTACHED      0x00000010L
    #define RESOURCEUSAGE_ALL \
        (RESOURCEUSAGE_CONNECTABLE | RESOURCEUSAGE_CONTAINER | RESOURCEUSAGE_ATTACHED)
#endif
#define RESOURCEUSAGE_RESERVED          0x80000000L

/* Network resource display types */
#define RESOURCEDISPLAYTYPE_GENERIC             0x00000000L
#define RESOURCEDISPLAYTYPE_DOMAIN              0x00000001L
#define RESOURCEDISPLAYTYPE_SERVER              0x00000002L
#define RESOURCEDISPLAYTYPE_SHARE               0x00000003L
#define RESOURCEDISPLAYTYPE_FILE                0x00000004L
#define RESOURCEDISPLAYTYPE_GROUP               0x00000005L
#if (WINVER >= 0x0400)
    #define RESOURCEDISPLAYTYPE_NETWORK         0x00000006L
    #define RESOURCEDISPLAYTYPE_ROOT            0x00000007L
    #define RESOURCEDISPLAYTYPE_SHAREADMIN      0x00000008L
    #define RESOURCEDISPLAYTYPE_DIRECTORY       0x00000009L
#endif
#define RESOURCEDISPLAYTYPE_TREE                0x0000000AL
#if (WINVER >= 0x0400)
    #define RESOURCEDISPLAYTYPE_NDSCONTAINER    0x0000000BL
#endif

/* Network connection flags */
#define CONNECT_UPDATE_PROFILE      0x00000001L
#define CONNECT_UPDATE_RECENT       0x00000002L
#define CONNECT_TEMPORARY           0x00000004L
#define CONNECT_INTERACTIVE         0x00000008L
#define CONNECT_PROMPT              0x00000010L
#define CONNECT_NEED_DRIVE          0x00000020L
#if (WINVER >= 0x0400)
    #define CONNECT_REFCOUNT        0x00000040L
    #define CONNECT_REDIRECT        0x00000080L
    #define CONNECT_LOCALDRIVE      0x00000100L
    #define CONNECT_CURRENT_MEDIA   0x00000200L
    #define CONNECT_DEFERRED        0x00000400L
    #define CONNECT_RESERVED        0xFF000000L
#endif
#if (WINVER >= 0x0500)
    #define CONNECT_COMMANDLINE     0x00000800L
    #define CONNECT_CMD_SAVECRED    0x00001000L
#endif
#if (WINVER >= 0x0600)
    #define CONNECT_CRED_RESET      0x00002000L
#endif

/* Network connection dialog flags */
#if (WINVER >= 0x0400)
    #define CONNDLG_RO_PATH     0x00000001L
    #define CONNDLG_CONN_POINT  0x00000002L
    #define CONNDLG_USE_MRU     0x00000004L
    #define CONNDLG_HIDE_BOX    0x00000008L
    #define CONNDLG_PERSIST     0x00000010L
    #define CONNDLG_NOT_PERSIST 0x00000020L
#endif

/* Network disconnect dialog flags */
#if (WINVER >= 0x0400)
    #define DISC_UPDATE_PROFILE 0x00000001L
    #define DISC_NO_FORCE       0x00000040L
#endif

/* Network name information levels */
#define UNIVERSAL_NAME_INFO_LEVEL   0x00000001L
#define REMOTE_NAME_INFO_LEVEL      0x00000002L

/* Network name formatting flags */
#if (WINVER >= 0x0400)
    #define WNFMT_MULTILINE     0x00000001L
    #define WNFMT_ABBREVIATED   0x00000002L
    #define WNFMT_INENUM        0x00000010L
    #define WNFMT_CONNECTION    0x00000020L
#endif

/* Network information characteristics */
#if (WINVER >= 0x0400)
    #define NETINFO_DLL16       0x00000001L
    #define NETINFO_DISKRED     0x00000004L
    #define NETINFO_PRINTERRED  0x00000008L
#endif

/* Network connection information flags */
#if (WINVER >= 0x0400)
    #define WNCON_FORNETCARD    0x00000001L
    #define WNCON_NOTROUTED     0x00000002L
    #define WNCON_SHOWLINK      0x00000004L
    #define WNCON_DYNAMIC       0x00000008L
#endif

/* Networking error codes */
#define WN_SUCCESS                              NO_ERROR
#define WN_NO_ERROR                             NO_ERROR
#define WN_NOT_SUPPORTED                        ERROR_NOT_SUPPORTED
#define WN_CANCEL                               ERROR_CANCELLED
#define WN_RETRY                                ERROR_RETRY
#define WN_NET_ERROR                            ERROR_UNEXP_NET_ERR
#define WN_MORE_DATA                            ERROR_MORE_DATA
#define WN_BAD_POINTER                          ERROR_INVALID_ADDRESS
#define WN_BAD_VALUE                            ERROR_INVALID_PARAMETER
#define WN_BAD_USER                             ERROR_BAD_USERNAME
#define WN_BAD_PASSWORD                         ERROR_INVALID_PASSWORD
#define WN_ACCESS_DENIED                        ERROR_ACCESS_DENIED
#define WN_FUNCTION_BUSY                        ERROR_BUSY
#define WN_WINDOWS_ERROR                        ERROR_UNEXP_NET_ERR
#define WN_OUT_OF_MEMORY                        ERROR_NOT_ENOUGH_MEMORY
#define WN_NO_NETWORK                           ERROR_NO_NETWORK
#define WN_EXTENDED_ERROR                       ERROR_EXTENDED_ERROR
#define WN_BAD_LEVEL                            ERROR_INVALID_LEVEL
#define WN_BAD_HANDLE                           ERROR_INVALID_HANDLE
#if (WINVER >= 0x0400)
    #define WN_NOT_INITIALIZING                 ERROR_ALREADY_INITIALIZED
    #define WN_NO_MORE_DEVICES                  ERROR_NO_MORE_DEVICES
#endif
#define WN_NOT_CONNECTED                        ERROR_NOT_CONNECTED
#define WN_OPEN_FILES                           ERROR_OPEN_FILES
#define WN_DEVICE_IN_USE                        ERROR_DEVICE_IN_USE
#define WN_BAD_NETNAME                          ERROR_BAD_NET_NAME
#define WN_BAD_LOCALNAME                        ERROR_BAD_DEVICE
#define WN_ALREADY_CONNECTED                    ERROR_ALREADY_ASSIGNED
#define WN_DEVICE_ERROR                         ERROR_GEN_FAILURE
#define WN_CONNECTION_CLOSED                    ERROR_CONNECTION_UNAVAIL
#define WN_NO_NET_OR_BAD_PATH                   ERROR_NO_NET_OR_BAD_PATH
#define WN_BAD_PROVIDER                         ERROR_BAD_PROVIDER
#define WN_CANNOT_OPEN_PROFILE                  ERROR_CANNOT_OPEN_PROFILE
#define WN_BAD_PROFILE                          ERROR_BAD_PROFILE
#define WN_BAD_DEV_TYPE                         ERROR_BAD_DEV_TYPE
#define WN_DEVICE_ALREADY_REMEMBERED            ERROR_DEVICE_ALREADY_REMEMBERED
#define WN_CONNECTED_OTHER_PASSWORD             ERROR_CONNECTED_OTHER_PASSWORD
#if (WINVER >= 0x0501)
    #define WN_CONNECTED_OTHER_PASSWORD_DEFAULT ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT
#endif
#define WN_NO_MORE_ENTRIES                      ERROR_NO_MORE_ITEMS
#define WN_NOT_CONTAINER                        ERROR_NOT_CONTAINER
#if (WINVER >= 0x0400)
    #define WN_NOT_AUTHENTICATED                ERROR_NOT_AUTHENTICATED
    #define WN_NOT_LOGGED_ON                    ERROR_NOT_LOGGED_ON
    #define WN_NOT_VALIDATED                    ERROR_NO_LOGON_SERVERS
#endif

/* Network resource information */
typedef struct _NETRESOURCEA {
    DWORD   dwScope;
    DWORD   dwType;
    DWORD   dwDisplayType;
    DWORD   dwUsage;
    LPSTR   lpLocalName;
    LPSTR   lpRemoteName;
    LPSTR   lpComment;
    LPSTR   lpProvider;
} NETRESOURCEA;
typedef NETRESOURCEA    *LPNETRESOURCEA;
typedef struct _NETRESOURCEW {
    DWORD   dwScope;
    DWORD   dwType;
    DWORD   dwDisplayType;
    DWORD   dwUsage;
    LPWSTR  lpLocalName;
    LPWSTR  lpRemoteName;
    LPWSTR  lpComment;
    LPWSTR  lpProvider;
} NETRESOURCEW;
typedef NETRESOURCEW    *LPNETRESOURCEW;
#ifdef UNICODE
typedef NETRESOURCEW    NETRESOURCE;
typedef LPNETRESOURCEW  LPNETRESOURCE;
#else
typedef NETRESOURCEA    NETRESOURCE;
typedef LPNETRESOURCEA  LPNETRESOURCE;
#endif

/* WNetConnectionDialog1() parameters */
#if (WINVER >= 0x0400)
typedef struct _CONNECTDLGSTRUCTA {
    DWORD           cbStructure;
    HWND            hwndOwner;
    LPNETRESOURCEA  lpConnRes;
    DWORD           dwFlags;
    DWORD           dwDevNum;
} CONNECTDLGSTRUCTA;
typedef CONNECTDLGSTRUCTA   *LPCONNECTDLGSTRUCTA;
typedef struct _CONNECTDLGSTRUCTW {
    DWORD           cbStruct;
    HWND            hwndOwner;
    LPNETRESOURCEW  lpConnRes;
    DWORD           dwFlags;
    DWORD           dwDevNum;
} CONNECTDLGSTRUCTW;
typedef CONNECTDLGSTRUCTW   *LPCONNECTDLGSTRUCTW;
#ifdef UNICODE
typedef CONNECTDLGSTRUCTW   CONNECTDLGSTRUCT;
typedef LPCONNECTDLGSTRUCTW LPCONNECTDLGSTRUCT;
#else
typedef CONNECTDLGSTRUCTA   CONNECTDLGSTRUCT;
typedef LPCONNECTDLGSTRUCTA LPCONNECTDLGSTRUCT;
#endif
#endif

/* WNetDisconnectDialog1() parameters */
#if (WINVER >= 0x0400)
typedef struct _DISCDLGSTRUCTA {
    DWORD   cbStructure;
    HWND    hwndOwner;
    LPSTR   lpLocalName;
    LPSTR   lpRemoteName;
    DWORD   dwFlags;
} DISCDLGSTRUCTA;
typedef DISCDLGSTRUCTA      *LPDISCDLGSTRUCTA;
typedef struct _DISCDLGSTRUCTW {
    DWORD   cbStructure;
    HWND    hwndOwner;
    LPWSTR  lpLocalName;
    LPWSTR  lpRemoteName;
    DWORD   dwFlags;
} DISCDLGSTRUCTW;
typedef DISCDLGSTRUCTW      *LPDISCDLGSTRUCTW;
#ifdef UNICODE
typedef DISCDLGSTRUCTW      DISCDLGSTRUCT;
typedef LPDISCDLGSTRUCTW    LPDISCDLGSTRUCT;
#else
typedef DISCDLGSTRUCTA      DISCDLGSTRUCT;
typedef LPDISCDLGSTRUCTA    LPDISCDLGSTRUCT;
#endif
#endif

/* Universal name information */
typedef struct _UNIVERSAL_NAME_INFOA {
    LPSTR   lpUniversalName;
} UNIVERSAL_NAME_INFOA;
typedef UNIVERSAL_NAME_INFOA    *LPUNIVERSAL_NAME_INFOA;
typedef struct _UNIVERSAL_NAME_INFOW {
    LPWSTR  lpUniversalName;
} UNIVERSAL_NAME_INFOW;
typedef UNIVERSAL_NAME_INFOW    *LPUNIVERSAL_NAME_INFOW;
#ifdef UNICODE
typedef UNIVERSAL_NAME_INFOW    UNIVERSAL_NAME_INFO;
typedef LPUNIVERSAL_NAME_INFOW  LPUNIVERSAL_NAME_INFO;
#else
typedef UNIVERSAL_NAME_INFOA    UNIVERSAL_NAME_INFO;
typedef LPUNIVERSAL_NAME_INFOA  LPUNIVERSAL_NAME_INFO;
#endif

/* Remote name information */
typedef struct _REMOTE_NAME_INFOA {
    LPSTR   lpUniversalName;
    LPSTR   lpConnectionName;
    LPSTR   lpRemainingPath;
} REMOTE_NAME_INFOA;
typedef REMOTE_NAME_INFOA   *LPREMOTE_NAME_INFOA;
typedef struct _REMOTE_NAME_INFOW {
    LPWSTR  lpUniversalName;
    LPWSTR  lpConnectionName;
    LPWSTR  lpRemainingPath;
} REMOTE_NAME_INFOW;
typedef REMOTE_NAME_INFOW   *LPREMOTE_NAME_INFOW;
#ifdef UNICODE
typedef REMOTE_NAME_INFOW   REMOTE_NAME_INFO;
typedef LPREMOTE_NAME_INFOW LPREMOTE_NAME_INFO;
#else
typedef REMOTE_NAME_INFOA   REMOTE_NAME_INFO;
typedef LPREMOTE_NAME_INFOA LPREMOTE_NAME_INFO;
#endif

/* Network information */
typedef struct _NETINFOSTRUCT {
    DWORD       cbStructure;
    DWORD       dwProviderVersion;
    DWORD       dwStatus;
    DWORD       dwCharacteristics;
    ULONG_PTR   dwHandle;
    WORD        wNetType;
    DWORD       dwPrinters;
    DWORD       dwDrives;
} NETINFOSTRUCT;
typedef NETINFOSTRUCT   *LPNETINFOSTRUCT;

/* Network connection information */
#if (WINVER >= 0x0400)
typedef struct _NETCONNECTINFOSTRUCT {
    DWORD   cbStructure;
    DWORD   dwFlags;
    DWORD   dwSpeed;
    DWORD   dwDelay;
    DWORD   dwOptDataSize;
} NETCONNECTINFOSTRUCT;
typedef NETCONNECTINFOSTRUCT    *LPNETCONNECTINFOSTRUCT;
#endif

/* Functions in MPR.DLL */
DWORD APIENTRY  WNetAddConnection2A( LPNETRESOURCEA, LPCSTR, LPCSTR, DWORD );
DWORD APIENTRY  WNetAddConnection2W( LPNETRESOURCEW, LPCWSTR, LPCWSTR, DWORD );
DWORD APIENTRY  WNetAddConnection3A( HWND, LPNETRESOURCEA, LPCSTR, LPCSTR, DWORD );
DWORD APIENTRY  WNetAddConnection3W( HWND, LPNETRESOURCEW, LPCWSTR, LPCWSTR, DWORD );
DWORD APIENTRY  WNetAddConnectionA( LPCSTR, LPCSTR, LPCSTR );
DWORD APIENTRY  WNetAddConnectionW( LPCWSTR, LPCWSTR, LPCWSTR );
DWORD APIENTRY  WNetCancelConnection2A( LPCSTR, DWORD, BOOL );
DWORD APIENTRY  WNetCancelConnection2W( LPCWSTR, DWORD, BOOL );
DWORD APIENTRY  WNetCancelConnectionA( LPCSTR, BOOL );
DWORD APIENTRY  WNetCancelConnectionW( LPCWSTR, BOOL );
DWORD APIENTRY  WNetCloseEnum( HANDLE );
DWORD APIENTRY  WNetConnectionDialog( HWND, DWORD );
DWORD APIENTRY  WNetDisconnectDialog( HWND, DWORD );
DWORD APIENTRY  WNetEnumResourceA( HANDLE, LPDWORD, LPVOID, LPDWORD );
DWORD APIENTRY  WNetEnumResourceW( HANDLE, LPDWORD, LPVOID, LPDWORD );
DWORD APIENTRY  WNetGetConnectionA( LPCSTR, LPSTR, LPDWORD );
DWORD APIENTRY  WNetGetConnectionW( LPCWSTR, LPWSTR, LPDWORD );
DWORD APIENTRY  WNetGetLastErrorA( LPDWORD, LPSTR, DWORD, LPSTR, DWORD );
DWORD APIENTRY  WNetGetLastErrorW( LPDWORD, LPWSTR, DWORD, LPWSTR, DWORD );
DWORD APIENTRY  WNetGetUniversalNameA( LPCSTR, DWORD, LPVOID, LPDWORD );
DWORD APIENTRY  WNetGetUniversalNameW( LPCWSTR, DWORD, LPVOID, LPDWORD );
DWORD APIENTRY  WNetGetUserA( LPCSTR, LPSTR, LPDWORD );
DWORD APIENTRY  WNetGetUserW( LPCWSTR, LPWSTR, LPDWORD );
DWORD APIENTRY  WNetOpenEnumA( DWORD, DWORD, DWORD, LPNETRESOURCEA, LPHANDLE );
DWORD APIENTRY  WNetOpenEnumW( DWORD, DWORD, DWORD, LPNETRESOURCEW, LPHANDLE );
#if (WINVER >= 0x0400)
DWORD APIENTRY  MultinetGetConnectionPerformanceA( LPNETRESOURCEA, LPNETCONNECTINFOSTRUCT );
DWORD APIENTRY  MultinetGetConnectionPerformanceW( LPNETRESOURCEW, LPNETCONNECTINFOSTRUCT );
DWORD APIENTRY  WNetConnectionDialog1A( LPCONNECTDLGSTRUCTA );
DWORD APIENTRY  WNetConnectionDialog1W( LPCONNECTDLGSTRUCTW );
DWORD APIENTRY  WNetDisconnectDialog1A( LPDISCDLGSTRUCTA );
DWORD APIENTRY  WNetDisconnectDialog1W( LPDISCDLGSTRUCTW );
DWORD APIENTRY  WNetGetNetworkInformationA( LPCSTR, LPNETINFOSTRUCT );
DWORD APIENTRY  WNetGetNetworkInformationW( LPCWSTR, LPNETINFOSTRUCT );
DWORD APIENTRY  WNetGetProviderNameA( DWORD, LPSTR, LPDWORD );
DWORD APIENTRY  WNetGetProviderNameW( DWORD, LPWSTR, LPDWORD );
DWORD APIENTRY  WNetGetResourceInformationA( LPNETRESOURCEA, LPVOID, LPDWORD, LPSTR * );
DWORD APIENTRY  WNetGetResourceInformationW( LPNETRESOURCEW, LPVOID, LPDWORD, LPWSTR * );
DWORD APIENTRY  WNetGetResourceParentA( LPNETRESOURCEA, LPVOID, LPDWORD );
DWORD APIENTRY  WNetGetResourceParentW( LPNETRESOURCEW, LPVOID, LPDWORD );
DWORD APIENTRY  WNetUseConnectionA( HWND, LPNETRESOURCEA, LPCSTR, LPCSTR, DWORD, LPSTR, LPDWORD, LPDWORD );
DWORD APIENTRY  WNetUseConnectionW( HWND, LPNETRESOURCEW, LPCWSTR, LPCWSTR, DWORD, LPWSTR, LPDWORD, LPDWORD );
#endif
#if (_WIN32_WINNT < 0x0600)
DWORD APIENTRY  WNetRestoreConnectionW( HWND, LPCWSTR );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define WNetAddConnection2                      WNetAddConnection2W
    #define WNetAddConnection3                      WNetAddConnection3W
    #define WNetAddConnection                       WNetAddConnectionW
    #define WNetCancelConnection                    WNetCancelConnectionW
    #define WNetCancelConnection2                   WNetCancelConnection2W
    #define WNetEnumResource                        WNetEnumResourceW
    #define WNetGetConnection                       WNetGetConnectionW
    #define WNetGetLastError                        WNetGetLastErrorW
    #define WNetGetUniversalName                    WNetGetUniversalNameW
    #define WNetGetUser                             WNetGetUserW
    #define WNetOpenEnum                            WNetOpenEnumW
    #if (WINVER >= 0x0400)
        #define MultinetGetConnectionPerformance    MultinetGetConnectionPerformanceW
        #define WNetConnectionDialog1               WNetConnectionDialog1W
        #define WNetDisconnectDialog1               WNetDisconnectDialog1W
        #define WNetGetNetworkInformation           WNetGetNetworkInformationW
        #define WNetGetProviderName                 WNetGetProviderNameW
        #define WNetGetResourceInformation          WNetGetResourceInformationW
        #define WNetGetResourceParent               WNetGetResourceParentW
        #define WNetUseConnection                   WNetUseConnectionW
    #endif
#else
    #define WNetAddConnection2                      WNetAddConnection2A
    #define WNetAddConnection3                      WNetAddConnection3A
    #define WNetAddConnection                       WNetAddConnectionA
    #define WNetCancelConnection                    WNetCancelConnectionA
    #define WNetCancelConnection2                   WNetCancelConnection2A
    #define WNetEnumResource                        WNetEnumResourceA
    #define WNetGetConnection                       WNetGetConnectionA
    #define WNetGetLastError                        WNetGetLastErrorA
    #define WNetGetUniversalName                    WNetGetUniversalNameA
    #define WNetGetUser                             WNetGetUserA
    #define WNetOpenEnum                            WNetOpenEnumA
    #if (WINVER >= 0x0400)
        #define MultinetGetConnectionPerformance    MultinetGetConnectionPerformanceA
        #define WNetConnectionDialog1               WNetConnectionDialog1A
        #define WNetDisconnectDialog1               WNetDisconnectDialog1A
        #define WNetGetNetworkInformation           WNetGetNetworkInformationA
        #define WNetGetProviderName                 WNetGetProviderNameA
        #define WNetGetResourceInformation          WNetGetResourceInformationA
        #define WNetGetResourceParent               WNetGetResourceParentA
        #define WNetUseConnection                   WNetUseConnectionA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINNETWK_ */
