/*
 *  winperf.h   Format of HKEY_PERFORMANCE_DATA
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINPERF_
#define _WINPERF_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 8 )

/* Performance data version numbers */
#define PERF_DATA_VERSION   1
#define PERF_DATA_REVISION  1

/* Number of instances special value */
#define PERF_NO_INSTANCES   (-1)

/* Performance counter type flags */
#define PERF_SIZE_DWORD             0x00000000L
#define PERF_SIZE_LARGE             0x00000100L
#define PERF_SIZE_ZERO              0x00000200L
#define PERF_SIZE_VARIABLE_LEN      0x00000300L
#define PERF_TYPE_NUMBER            0x00000000L
#define PERF_TYPE_COUNTER           0x00000400L
#define PERF_TYPE_TEXT              0x00000800L
#define PERF_TYPE_ZERO              0x00000C00L
#define PERF_NUMBER_HEX             0x00000000L
#define PERF_NUMBER_DECIMAL         0x00010000L
#define PERF_NUMBER_DEC_1000        0x00020000L
#define PERF_COUNTER_VALUE          0x00000000L
#define PERF_COUNTER_RATE           0x00010000L
#define PERF_COUNTER_FRACTION       0x00020000L
#define PERF_COUNTER_BASE           0x00030000L
#define PERF_COUNTER_ELAPSED        0x00040000L
#define PERF_COUNTER_QUEUELEN       0x00050000L
#define PERF_COUNTER_HISTOGRAM      0x00060000L
#define PERF_COUNTER_PRECISION      0x00070000L
#define PERF_TEXT_UNICODE           0x00000000L
#define PERF_TEXT_ASCII             0x00010000L
#define PERF_TIMER_TICK             0x00000000L
#define PERF_TIMER_100NS            0x00100000L
#define PERF_OBJECT_TIMER           0x00200000L
#define PERF_DELTA_COUNTER          0x00400000L
#define PERF_DELTA_BASE             0x00800000L
#define PERF_INVERSE_COUNTER        0x01000000L
#define PERF_MULTI_COUNTER          0x02000000L
#define PERF_DISPLAY_NO_SUFFIX      0x00000000L
#define PERF_DISPLAY_PER_SEC        0x10000000L
#define PERF_DISPLAY_PERCENT        0x20000000L
#define PERF_DISPLAY_SECONDS        0x30000000L
#define PERF_DISPLAY_NOSHOW         0x40000000L
#define PERF_COUNTER_HISTOGRAM_TYPE 0x80000000L

/* Predefined performance counter types */
#define PERF_COUNTER_COUNTER \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PER_SEC)
#define PERF_COUNTER_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_QUEUELEN_TYPE \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_QUEUELEN | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_QUEUELEN_TYPE \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_QUEUELEN | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_100NS_QUEUELEN_TYPE \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_QUEUELEN | PERF_TIMER_100NS | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_OBJ_TIME_QUEUELEN_TYPE \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_QUEUELEN | PERF_OBJECT_TIMER | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_BULK_COUNT \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PER_SEC)
#define PERF_COUNTER_TEXT \
    (PERF_SIZE_VARIABLE_LEN | PERF_TYPE_TEXT | PERF_TEXT_UNICODE | \
    PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_RAWCOUNT \
    (PERF_SIZE_DWORD | PERF_TYPE_NUMBER | PERF_NUMBER_DECIMAL | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_RAWCOUNT \
    (PERF_SIZE_LARGE | PERF_TYPE_NUMBER | PERF_NUMBER_DECIMAL | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_RAWCOUNT_HEX \
    (PERF_SIZE_DWORD | PERF_TYPE_NUMBER | PERF_NUMBER_HEX | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_RAWCOUNT_HEX \
    (PERF_SIZE_LARGE | PERF_TYPE_NUMBER | PERF_NUMBER_HEX | PERF_DISPLAY_NO_SUFFIX)
#define PERF_SAMPLE_FRACTION \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_FRACTION | PERF_DELTA_COUNTER | \
    PERF_DELTA_BASE | PERF_DISPLAY_PERCENT)
#define PERF_SAMPLE_COUNTER \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_NODATA \
    (PERF_SIZE_ZERO | PERF_DISPLAY_NOSHOW)
#define PERF_COUNTER_TIMER_INV \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_INVERSE_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_SAMPLE_BASE \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_BASE | PERF_DISPLAY_NOSHOW | \
    0x00000001L)
#define PERF_AVERAGE_TIMER \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_FRACTION | PERF_DISPLAY_SECONDS)
#define PERF_AVERAGE_BASE \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_BASE | PERF_DISPLAY_NOSHOW | \
    0x00000002L)
#define PERF_AVERAGE_BULK \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_FRACTION | PERF_DISPLAY_NOSHOW)
#define PERF_OBJ_TIME_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_OBJECT_TIMER | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_100NSEC_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_100NS | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_100NSEC_TIMER_INV \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_TIMER_100NS | \
    PERF_DELTA_COUNTER | PERF_INVERSE_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_DELTA_COUNTER | \
    PERF_TIMER_TICK | PERF_MULTI_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_TIMER_INV \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_RATE | PERF_DELTA_COUNTER | \
    PERF_MULTI_COUNTER | PERF_TIMER_TICK | PERF_INVERSE_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_BASE \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_BASE | PERF_MULTI_COUNTER | \
    PERF_DISPLAY_NOSHOW)
#define PERF_100NSEC_MULTI_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_DELTA_COUNTER | PERF_COUNTER_RATE | \
    PERF_TIMER_100NS | PERF_MULTI_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_100NSEC_MULTI_TIMER_INV \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_DELTA_COUNTER | PERF_COUNTER_RATE | \
    PERF_TIMER_100NS | PERF_MULTI_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_RAW_FRACTION \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_FRACTION | PERF_DISPLAY_PERCENT)
#define PERF_LARGE_RAW_FRACTION \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_FRACTION | PERF_DISPLAY_PERCENT)
#define PERF_RAW_BASE \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_BASE | PERF_DISPLAY_NOSHOW | \
    0x00000003L)
#define PERF_LARGE_RAW_BASE \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_BASE | PERF_DISPLAY_NOSHOW)
#define PERF_ELAPSED_TIME \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_ELAPSED | PERF_OBJECT_TIMER | \
    PERF_DISPLAY_SECONDS)
#define PERF_COUNTER_DELTA \
    (PERF_SIZE_DWORD | PERF_TYPE_COUNTER | PERF_COUNTER_VALUE | PERF_DELTA_COUNTER | \
    PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_DELTA \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_VALUE | PERF_DELTA_COUNTER | \
    PERF_DISPLAY_NO_SUFFIX)
#define PERF_PRECISION_SYSTEM_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_PRECISION | PERF_TIMER_TICK | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_PRECISION_100NS_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_PRECISION | PERF_TIMER_100NS | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_PRECISION_OBJECT_TIMER \
    (PERF_SIZE_LARGE | PERF_TYPE_COUNTER | PERF_COUNTER_PRECISION | PERF_OBJECT_TIMER | \
    PERF_DELTA_COUNTER | PERF_DISPLAY_PERCENT)
#define PERF_PRECISION_TIMESTAMP    PERF_LARGE_RAW_BASE

/* Performance detail levels */
#define PERF_DETAIL_NOVICE      100L
#define PERF_DETAIL_ADVANCED    200L
#define PERF_DETAIL_EXPERT      300L
#define PERF_DETAIL_WIZARD      400L

/* Number of instances special value */
#define PERF_NO_UNIQUE_ID   (-1)

/* Performance query types */
#define PERF_QUERY_OBJECTS  0x80000000L
#define PERF_QUERY_GLOBALS  0x80000001L
#define PERF_QUERY_COSTLY   0x80000002L

/* Maximum performance objects in query function */
#if (_WIN32_WINDOWS >= 0x0501) || (_WIN32_WINNT >= 0x0501) || (NTDDI_VERSION >= 0x05010000)
    #define MAX_PERF_OBJECTS_IN_QUERY_FUNCTION  64L
#else
    #define MAX_PERF_OBJECTS_IN_QUERY_FUNCTION  8L
#endif

/* Event log levels */
#if (_WIN32_WINDOWS >= 0x0501) || (_WIN32_WINNT >= 0x0501) || (NTDDI_VERSION >= 0x05010000)
    #define WINPERF_LOG_NONE    0
    #define WINPERF_LOG_USER    1
    #define WINPERF_LOG_DEBUG   2
    #define WINPERF_LOG_VERBOSE 3
#endif

/* Performance data block */
typedef struct _PERF_DATA_BLOCK {
    WCHAR           Signature[4];
    DWORD           LittleEndian;
    DWORD           Version;
    DWORD           Revision;
    DWORD           TotalByteLength;
    DWORD           HeaderLength;
    DWORD           NumObjectTypes;
    LONG            DefaultObject;
    SYSTEMTIME      SystemTime;
    LARGE_INTEGER   PerfTime;
    LARGE_INTEGER   PerfFreq;
    LARGE_INTEGER   PerfTime100nSec;
    DWORD           SystemNameLegnth;
    DWORD           SystemNameOffset;
} PERF_DATA_BLOCK;
typedef PERF_DATA_BLOCK *PPERF_DATA_BLOCK;

/* Performance object type */
typedef struct _PERF_OBJECT_TYPE {
    DWORD           TotalByteLength;
    DWORD           DefinitionLength;
    DWORD           HeaderLength;
    DWORD           ObjectNameTitleIndex;
    LPWSTR          ObjectNameTitle;
    DWORD           ObjectHelpTitleIndex;
    LPWSTR          ObjectHelpTitle;
    DWORD           DetailLevel;
    DWORD           NumCounters;
    LONG            DefaultCounter;
    LONG            NumInstances;
    DWORD           CodePage;
    LARGE_INTEGER   PerfTime;
    LARGE_INTEGER   PerfFreq;
} PERF_OBJECT_TYPE;
typedef PERF_OBJECT_TYPE    *PPERF_OBJECT_TYPE;

/* Performance counter definition */
typedef struct _PERF_COUNTER_DEFINITION {
    DWORD   ByteLength;
    DWORD   CounterNameTitleIndex;
    LPWSTR  CounterNameTitle;
    DWORD   CounterHelpTitleIndex;
    LPWSTR  CounterHelpTitle;
    LONG    DefaultScale;
    DWORD   DetailLevel;
    DWORD   CounterType;
    DWORD   CounterSize;
    DWORD   CounterOffset;
} PERF_COUNTER_DEFINITION;
typedef PERF_COUNTER_DEFINITION *PPERF_COUNTER_DEFINITION;

/* Performance instance definition */
typedef struct _PERF_INSTANCE_DEFINITION {
    DWORD   ByteLength;
    DWORD   ParentObjectTitleIndex;
    DWORD   ParentObjectInstance;
    LONG    UniqueID;
    DWORD   NameOffset;
    DWORD   NameLength;
} PERF_INSTANCE_DEFINITION;
typedef PERF_INSTANCE_DEFINITION    *PPERF_INSTANCE_DEFINITION;

/* Performance counter block */
typedef struct _PERF_COUNTER_BLOCK {
    DWORD   ByteLength;
} PERF_COUNTER_BLOCK;
typedef PERF_COUNTER_BLOCK  *PPERF_COUNTER_BLOCK;

/* Extensible counter function pointers */
typedef DWORD (APIENTRY PM_OPEN_PROC)( LPWSTR );
typedef DWORD (APIENTRY PM_COLLECT_PROC)( LPWSTR, LPVOID *, LPDWORD, LPDWORD );
typedef DWORD (APIENTRY PM_CLOSE_PROC)( void );
typedef DWORD (APIENTRY PM_QUERY_PROC)( LPDWORD, LPVOID *, LPDWORD, LPDWORD );

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINPERF_ */
