/*
 *  wtsapi32.h  Windows Terminal Server (WTS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_WTSAPI
#define _INC_WTSAPI

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Special values */
#define WTS_CURRENT_SERVER          NULL
#define WTS_CURRENT_SERVER_HANDLE   NULL
#define WTS_CURRENT_SERVER_NAME     NULL
#define WTS_CURRENT_SESSION         0xFFFFFFFFL
#define WTS_ANY_SESSION             0xFFFFFFFEL

/* WTS shutdown flags */
#define WTS_WSD_LOGOFF      0x00000001L
#define WTS_WSD_SHUTDOWN    0x00000002L
#define WTS_WSD_REBOOT      0x00000004L
#define WTS_WSD_POWEROFF    0x00000008L
#define WTS_WSD_FASTREBOOT  0x00000010L

/* Maximum string lengths */
#ifndef __HYDRIX_H__
    #define USERNAME_LENGTH                     20
    #define CLIENTNAME_LENGTH                   20
    #define CLIENTADDRESS_LENGTH                30
#endif
#define MAX_ELAPSED_TIME_LENGTH                 15
#define MAX_DATE_TIME_LENGTH                    56
#define WINSTATIONNAME_LENGTH                   32
#define DOMAIN_LENGTH                           17
#define WTS_DRIVE_LENGTH                        3
#define WTS_LISTENER_NAME_LENGTH                32
#define WTS_COMMENT_LENGTH                      60
#define PRODUCTINFO_COMPANYNAME_LENGTH          256
#define PRODUCTINFO_PRODUCTID_LENGTH            4
#define VALIDATIONINFORMATION_LICENSE_LENGTH    16384
#define VALIDATIONINFORMATION_HARDWAREID_LENGTH 20

/* WTSCreateListener() flags */
#define WTS_LISTENER_CREATE 0x00000001L
#define WTS_LISTENER_UPDATE 0x00000002L

/* WTS access rights */
#define WTS_SECURITY_QUERY_INFORMATION  0x0001L
#define WTS_SECURITY_SET_INFORMATION    0x0002L
#define WTS_SECURITY_RESET              0x0004L
#define WTS_SECURITY_VIRTUAL_CHANNELS   0x0008L
#define WTS_SECURITY_REMOTE_CONTROL     0x0010L
#define WTS_SECURITY_LOGON              0x0020L
#define WTS_SECURITY_LOGOFF             0x0040L
#define WTS_SECURITY_MESSAGE            0x0080L
#define WTS_SECURITY_CONNECT            0x0100L
#define WTS_SECURITY_DISCONNECT         0x0200L
#define WTS_SECURITY_GUEST_ACCESS       WTS_SECURITY_LOGON
#define WTS_SECURITY_CURRENT_GUEST_ACCESS \
    (WTS_SECURITY_VIRTUAL_CHANNELS | WTS_SECURITY_LOGOFF)
#define WTS_SECURITY_USER_ACCESS \
    (WTS_SECURITY_CURRENT_GUEST_ACCESS | WTS_SECURITY_QUERY_INFORMATION | \
    WTS_SECURITY_CONNECT)
#define WTS_SECURITY_CURRENT_USER_ACCESS \
    (WTS_SECURITY_SET_INFORMATION | WTS_SECURITY_RESET | \
    WTS_SECURITY_VIRTUAL_CHANNELS | WTS_SECURITY_LOGOFF | WTS_SECURITY_DISCONNECT)
#define WTS_SECURITY_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | WTS_SECURITY_QUERY_INFORMATION | \
    WTS_SECURITY_SET_INFORMATION | WTS_SECURITY_RESET | WTS_SECURITY_VIRTUAL_CHANNELS | \
    WTS_SECURITY_REMOTE_CONTROL | WTS_SECURITY_LOGON | WTS_SECURITY_MESSAGE | \
    WTS_SECURITY_CONNECT | WTS_SECURITY_DISCONNECT)

/* WTS protocol types */
#define WTS_PROTOCOL_TYPE_CONSOLE   0
#define WTS_PROTOCOL_TYPE_ICA       1
#define WTS_PROTOCOL_TYPE_RDP       2

/* WTS session state flags */
#define WTS_SESSIONSTATE_UNKNOWN    0xFFFFFFFFL
#define WTS_SESSIONSTATE_LOCK       0x00000000L
#define WTS_SESSIONSTATE_UNLOCK     0x00000001L

/* WTS event flags */
#define WTS_EVENT_NONE          0x00000000L
#define WTS_EVENT_CREATE        0x00000001L
#define WTS_EVENT_DELETE        0x00000002L
#define WTS_EVENT_RENAME        0x00000004L
#define WTS_EVENT_CONNECT       0x00000008L
#define WTS_EVENT_DISCONNECT    0x00000010L
#define WTS_EVENT_LOGON         0x00000020L
#define WTS_EVENT_LOGOFF        0x00000040L
#define WTS_EVENT_STATECHANGE   0x00000080L
#define WTS_EVENT_LICENSE       0x00000100L
#define WTS_EVENT_ALL           0x7FFFFFFFL
#define WTS_EVENT_FLUSH         0x80000000L

/* WTSStartRemoteControlSession() hotkey modifiers */
#define REMOTECONTROL_KBDSHIFT_HOTKEY   0x0001
#define REMOTECONTROL_KBDCTRL_HOTKEY    0x0002
#define REMOTECONTROL_KBDALT_HOTKEY     0x0004

/* WTSVirtualChannelOpenEx() flags */
#define WTS_CHANNEL_OPTION_DYNAMIC              0x00000001L
#define WTS_CHANNEL_OPTION_DYNAMIC_PRI_LOW      0x00000000L
#define WTS_CHANNEL_OPTION_DYNAMIC_PRI_MED      0x00000002L
#define WTS_CHANNEL_OPTION_DYNAMIC_PRI_HIGH     0x00000004L
#define WTS_CHANNEL_OPTION_DYNAMIC_PRI_REAL     0x00000006L
#define WTS_CHANNEL_OPTION_DYNAMIC_NO_COMPRESS  0x00000008L

/* Console notification flags */
#define NOTIFY_FOR_THIS_SESSION 0
#define NOTIFY_FOR_ALL_SESSIONS 1

/* WTS process information levels */
#define WTS_PROCESS_INFO_LEVEL_0    0L
#define WTS_PROCESS_INFO_LEVEL_1    1L

/* WTS connect state classes */
typedef enum _WTS_CONNECTSTATE_CLASS {
    WTSActive       = 0,
    WTSConnected    = 1,
    WTSConnectQuery = 2,
    WTSShadow       = 3,
    WTSDisconnected = 4,
    WTSIdle         = 5,
    WTSListen       = 6,
    WTSReset        = 7,
    WTSDown         = 8,
    WTSInit         = 9
} WTS_CONNECTSTATE_CLASS;

/* WTS server information */
typedef struct _WTS_SERVER_INFOA {
    LPSTR   pServerName;
} WTS_SERVER_INFOA;
typedef WTS_SERVER_INFOA    *PWTS_SERVER_INFOA;
typedef struct _WTS_SERVER_INFOW {
    LPWSTR  pServerName;
} WTS_SERVER_INFOW;
typedef WTS_SERVER_INFOW    *PWTS_SERVER_INFOW;
#ifdef UNICODE
typedef WTS_SERVER_INFOW    WTS_SERVER_INFO;
typedef PWTS_SERVER_INFOW   PWTS_SERVER_INFO;
#else
typedef WTS_SERVER_INFOA    WTS_SERVER_INFO;
typedef PWTS_SERVER_INFOA   PWTS_SERVER_INFO;
#endif

/* WTS session information */
typedef struct _WTS_SESSION_INFOA {
    DWORD                   SessionId;
    LPSTR                   pWinStationName;
    WTS_CONNECTSTATE_CLASS  State;
} WTS_SESSION_INFOA;
typedef WTS_SESSION_INFOA   *PWTS_SESSION_INFOA;
typedef struct _WTS_SESSION_INFOW {
    DWORD                   SessionId;
    LPWSTR                  pWinStationName;
    WTS_CONNECTSTATE_CLASS  State;
} WTS_SESSION_INFOW;
typedef WTS_SESSION_INFOW   *PWTS_SESSION_INFOW;
#ifdef UNICODE
typedef WTS_SESSION_INFOW   WTS_SESSION_INFO;
typedef PWTS_SESSION_INFOW  PWTS_SESSION_INFO;
#else
typedef WTS_SESSION_INFOA   WTS_SESSION_INFO;
typedef PWTS_SESSION_INFOA  PWTS_SESSION_INFO;
#endif

/* WTS session information (level 1) */
typedef struct _WTS_SESSION_INFO_1A {
    DWORD                   ExecEnvId;
    WTS_CONNECTSTATE_CLASS  State;
    DWORD                   SessionId;
    LPSTR                   pSessionName;
    LPSTR                   pHostName;
    LPSTR                   pUserName;
    LPSTR                   pDomainName;
    LPSTR                   pFarmName;
} WTS_SESSION_INFO_1A;
typedef WTS_SESSION_INFO_1A     *PWTS_SESSION_INFO_1A;
typedef struct _WTS_SESSION_INFO_1W {
    DWORD                   ExecEnvId;
    WTS_CONNECTSTATE_CLASS  State;
    DWORD                   SessionId;
    LPWSTR                  pSessionName;
    LPWSTR                  pHostName;
    LPWSTR                  pUserName;
    LPWSTR                  pDomainName;
    LPWSTR                  pFarmName;
} WTS_SESSION_INFO_1W;
typedef WTS_SESSION_INFO_1W     *PWTS_SESSION_INFO_1W;
#ifdef UNICODE
typedef WTS_SESSION_INFO_1W     WTS_SESSION_INFO_1;
typedef PWTS_SESSION_INFO_1W    PWTS_SESSION_INFO_1;
#else
typedef WTS_SESSION_INFO_1A     WTS_SESSION_INFO_1;
typedef PWTS_SESSION_INFO_1A    PWTS_SESSION_INFO_1;
#endif

/* WTS process information */
typedef struct _WTS_PROCESS_INFOA {
    DWORD   SessionId;
    DWORD   ProcessId;
    LPSTR   pProcessName;
    PSID    pUserSid;
} WTS_PROCESS_INFOA;
typedef WTS_PROCESS_INFOA   *PWTS_PROCESS_INFOA;
typedef struct _WTS_PROCESS_INFOW {
    DWORD   SessionId;
    DWORD   ProcessId;
    LPWSTR  pProcessName;
    PSID    pUserSid;
} WTS_PROCESS_INFOW;
typedef WTS_PROCESS_INFOW   *PWTS_PROCESS_INFOW;
#ifdef UNICODE
typedef WTS_PROCESS_INFOW   WTS_PROCESS_INFO;
typedef PWTS_PROCESS_INFOW  PWTS_PROCESS_INFO;
#else
typedef WTS_PROCESS_INFOA   WTS_PROCESS_INFO;
typedef PWTS_PROCESS_INFOA  PWTS_PROCESS_INFO;
#endif

/* WTS information classes */
typedef enum _WTS_INFO_CLASS {
    WTSInitialProgram       = 0,
    WTSApplicationName      = 1,
    WTSWorkingDirectory     = 2,
    WTSOEMId                = 3,
    WTSSessionId            = 4,
    WTSUserName             = 5,
    WTSWinStationName       = 6,
    WTSDomainName           = 7,
    WTSConnectState         = 8,
    WTSClientBuildNumber    = 9,
    WTSClientName           = 10,
    WTSClientDirectory      = 11,
    WTSClientProductId      = 12,
    WTSClientHardwareId     = 13,
    WTSClientAddress        = 14,
    WTSClientDisplay        = 15,
    WTSClientProtocolType   = 16,
    WTSIdleTime             = 17,
    WTSLogonTime            = 18,
    WTSIncomingBytes        = 19,
    WTSOutgoingBytes        = 20,
    WTSIncomingFrames       = 21,
    WTSOutgoingFrames       = 22,
    WTSClientInfo           = 23,
    WTSSessionInfo          = 24,
    WTSSessionInfoEx        = 25,
    WTSConfigInfo           = 26,
    WTSValidationInfo       = 27,
    WTSSessionAddressV4     = 28,
    WTSIsRemoteSession      = 29
} WTS_INFO_CLASS;

/* WTS configuration information */
typedef struct _WTSCONFIGINFOA {
    ULONG   version;
    ULONG   fConnectClientDrivesAtLogon;
    ULONG   fConnectPrinterAtLogon;
    ULONG   fDisablePrinterRedirection;
    ULONG   fDisableDefaultMainClientPrinter;
    ULONG   ShadowSettings;
    CHAR    LogonUserName[USERNAME_LENGTH + 1];
    CHAR    LogonDomain[DOMAIN_LENGTH + 1];
    CHAR    WorkDirectory[MAX_PATH + 1];
    CHAR    InitialProgram[MAX_PATH + 1];
    CHAR    ApplicationName[MAX_PATH + 1];
} WTSCONFIGINFOA;
typedef WTSCONFIGINFOA  *PWTSCONFIGINFOA;
typedef struct _WTSCONFIGINFOW {
    ULONG   version;
    ULONG   fConnectClientDrivesAtLogon;
    ULONG   fConnectPrinterAtLogon;
    ULONG   fDisablePrinterRedirection;
    ULONG   fDisableDefaultMainClientPrinter;
    ULONG   ShadowSettings;
    WCHAR   LogonUserName[USERNAME_LENGTH + 1];
    WCHAR   LogonDomain[DOMAIN_LENGTH + 1];
    WCHAR   WorkDirectory[MAX_PATH + 1];
    WCHAR   InitialProgram[MAX_PATH + 1];
    WCHAR   ApplicationName[MAX_PATH + 1];
} WTSCONFIGINFOW;
typedef WTSCONFIGINFOW  *PWTSCONFIGINFOW;
#ifdef UNICODE
typedef WTSCONFIGINFOW  WTSCONFIGINFO;
typedef PWTSCONFIGINFOW PWTSCONFIGINFO;
#else
typedef WTSCONFIGINFOA  WTSCONFIGINFO;
typedef PWTSCONFIGINFOA PWTSCONFIGINFO;
#endif

/* WTS information */
typedef struct _WTSINFOA {
    WTS_CONNECTSTATE_CLASS  State;
    DWORD                   SessionId;
    DWORD                   IncomingBytes;
    DWORD                   OutgoingBytes;
    DWORD                   IncomingFrames;
    DWORD                   OutgoingFrames;
    DWORD                   IncomingCompressedBytes;
    DWORD                   OutgoingCompressedBytes;
    CHAR                    WinStationName[WINSTATIONNAME_LENGTH];
    CHAR                    Domain[DOMAIN_LENGTH];
    CHAR                    UserName[USERNAME_LENGTH + 1];
    LARGE_INTEGER           ConnectTime;
    LARGE_INTEGER           DisconnectTime;
    LARGE_INTEGER           LastInputTime;
    LARGE_INTEGER           LogonTime;
    LARGE_INTEGER           CurrentTime;
} WTSINFOA;
typedef WTSINFOA    *PWTSINFOA;
typedef struct _WTSINFOW {
    WTS_CONNECTSTATE_CLASS  State;
    DWORD                   SessionId;
    DWORD                   IncomingBytes;
    DWORD                   OutgoingBytes;
    DWORD                   IncomingFrames;
    DWORD                   OutgoingFrames;
    DWORD                   IncomingCompressedBytes;
    DWORD                   OutgoingCompressedBytes;
    WCHAR                   WinStationName[WINSTATIONNAME_LENGTH];
    WCHAR                   Domain[DOMAIN_LENGTH];
    WCHAR                   UserName[USERNAME_LENGTH + 1];
    LARGE_INTEGER           ConnectTime;
    LARGE_INTEGER           DisconnectTime;
    LARGE_INTEGER           LastInputTime;
    LARGE_INTEGER           LogonTime;
    LARGE_INTEGER           CurrentTime;
} WTSINFOW;
typedef WTSINFOW    *PWTSINFOW;
#ifdef UNICODE
typedef WTSINFOW    WTSINFO;
typedef PWTSINFOW   PWTSINFO;
#else
typedef WTSINFOA    WTSINFO;
typedef PWTSINFOA   PWTSINFO;
#endif

/* WTS information (extended version) (level 1) */
typedef struct _WTSINFOEX_LEVEL1_A {
    ULONG                   SessionId;
    WTS_CONNECTSTATE_CLASS  SessionState;
    LONG                    SessionFlags;
    CHAR                    WinStationName[WINSTATIONNAME_LENGTH + 1];
    CHAR                    UserName[USERNAME_LENGTH + 1];
    CHAR                    DomainName[DOMAIN_LENGTH + 1];
    LARGE_INTEGER           LogonTime;
    LARGE_INTEGER           ConnectTime;
    LARGE_INTEGER           DisconnectTime;
    LARGE_INTEGER           LastInputTime;
    LARGE_INTEGER           CurrentTime;
    DWORD                   IncomingBytes;
    DWORD                   OutgoingBytes;
    DWORD                   IncomingFrames;
    DWORD                   OutgoingFrames;
    DWORD                   IncomingCompressedBytes;
    DWORD                   OutgoingCompressedBytes;
} WTSINFOEX_LEVEL1_A;
typedef WTSINFOEX_LEVEL1_A  *PWTSINFOEX_LEVEL1_A;
typedef struct _WTSINFOEX_LEVEL1_W {
    ULONG                   SessionId;
    WTS_CONNECTSTATE_CLASS  SessionState;
    LONG                    SessionFlags;
    WCHAR                   WinStationName[WINSTATIONNAME_LENGTH + 1];
    WCHAR                   UserName[USERNAME_LENGTH + 1];
    WCHAR                   DomainName[DOMAIN_LENGTH + 1];
    LARGE_INTEGER           LogonTime;
    LARGE_INTEGER           ConnectTime;
    LARGE_INTEGER           DisconnectTime;
    LARGE_INTEGER           LastInputTime;
    LARGE_INTEGER           CurrentTime;
    DWORD                   IncomingBytes;
    DWORD                   OutgoingBytes;
    DWORD                   IncomingFrames;
    DWORD                   OutgoingFrames;
    DWORD                   IncomingCompressedBytes;
    DWORD                   OutgoingCompressedBytes;
} WTSINFOEX_LEVEL1_W;
typedef WTSINFOEX_LEVEL1_W  *PWTSINFOEX_LEVEL1_W;
#ifdef UNICODE
typedef WTSINFOEX_LEVEL1_W  WTSINFOEX_LEVEL1;
typedef PWTSINFOEX_LEVEL1_W PWTSINFOEX_LEVEL1;
#else
typedef WTSINFOEX_LEVEL1_A  WTSINFOEX_LEVEL1;
typedef PWTSINFOEX_LEVEL1_A PWTSINFOEX_LEVEL1;
#endif

/* WTS information (extended version) (all levels) */
typedef union _WTSINFOEX_LEVEL_A {
    WTSINFOEX_LEVEL1_A  WTSInfoExLevel1;
} WTSINFOEX_LEVEL_A;
typedef WTSINFOEX_LEVEL_A   *PWTSINFOEX_LEVEL_A;
typedef union _WTSINFOEX_LEVEL_W {
    WTSINFOEX_LEVEL1_W  WTSInfoExLevel1;
} WTSINFOEX_LEVEL_W;
typedef WTSINFOEX_LEVEL_W   *PWTSINFOEX_LEVEL_W;
#ifdef UNICODE
typedef WTSINFOEX_LEVEL_W   WTSINFOEX_LEVEL;
typedef PWTSINFOEX_LEVEL_W  PWTSINFOEX_LEVEL;
#else
typedef WTSINFOEX_LEVEL_A   WTSINFOEX_LEVEL;
typedef PWTSINFOEX_LEVEL_A  PWTSINFOEX_LEVEL;
#endif

/* WTS information (extended version) */
typedef struct _WTSINFOEXA {
    DWORD               Level;
    WTSINFOEX_LEVEL_A   Data;
} WTSINFOEXA;
typedef WTSINFOEXA  *PWTSINFOEXA;
typedef struct _WTSINFOEXW {
    DWORD               Level;
    WTSINFOEX_LEVEL_W   Data;
} WTSINFOEXW;
typedef WTSINFOEXW  *PWTSINFOEXW;
#ifdef UNICODE
typedef WTSINFOEXW  WTSINFOEX;
typedef PWTSINFOEXW PWTSINFOEX;
#else
typedef WTSINFOEXA  WTSINFOEX;
typedef PWTSINFOEXA PWTSINFOEX;
#endif

/* WTS client information */
typedef struct _WTSCLIENTA {
    CHAR    ClientName[CLIENTNAME_LENGTH + 1];
    CHAR    Domain[DOMAIN_LENGTH + 1];
    CHAR    UserName[USERNAME_LENGTH + 1];
    CHAR    WorkDirectory[MAX_PATH + 1];
    CHAR    InitialProgram[MAX_PATH + 1];
    BYTE    EncryptionLevel;
    ULONG   ClientAddressFamily;
    USHORT  ClientAddress[CLIENTADDRESS_LENGTH + 1];
    USHORT  HRes;
    USHORT  VRes;
    USHORT  ColorDepth;
    CHAR    ClientDirectory[MAX_PATH + 1];
    ULONG   ClientBuildNumber;
    ULONG   ClientHardwareId;
    USHORT  ClientProductId;
    USHORT  OutBufCountHost;
    USHORT  OutBufCountClient;
    USHORT  OutBufLength;
    CHAR    DeviceId[MAX_PATH + 1];
} WTSCLIENTA;
typedef WTSCLIENTA  *PWTSCLIENTA;
typedef struct _WTSCLIENTW {
    WCHAR   ClientName[CLIENTNAME_LENGTH + 1];
    WCHAR   Domain[DOMAIN_LENGTH + 1];
    WCHAR   UserName[USERNAME_LENGTH + 1];
    WCHAR   WorkDirectory[MAX_PATH + 1];
    WCHAR   InitialProgram[MAX_PATH + 1];
    BYTE    EncryptionLevel;
    ULONG   ClientAddressFamily;
    USHORT  ClientAddress[CLIENTADDRESS_LENGTH + 1];
    USHORT  HRes;
    USHORT  VRes;
    USHORT  ColorDepth;
    WCHAR   ClientDirectory[MAX_PATH + 1];
    ULONG   ClientBuildNumber;
    ULONG   ClientHardwareId;
    USHORT  ClientProductId;
    USHORT  OutBufCountHost;
    USHORT  OutBufCountClient;
    USHORT  OutBufLength;
    WCHAR   DeviceId[MAX_PATH + 1];
} WTSCLIENTW;
typedef WTSCLIENTW  *PWTSCLIENTW;
#ifdef UNICODE
typedef WTSCLIENTW  WTSCLIENT;
typedef PWTSCLIENTW PWTSCLIENT;
#else
typedef WTSCLIENTA  WTSCLIENT;
typedef PWTSCLIENTA PWTSCLIENT;
#endif

/* WTS product information */
typedef struct _WTS_PRODUCT_INFOA {
    CHAR    CompanyName[PRODUCTINFO_COMPANYNAME_LENGTH];
    CHAR    ProductID[PRODUCTINFO_PRODUCTID_LENGTH];
} PRODUCT_INFOA;
typedef struct _WTS_PRODUCT_INFOW {
    WCHAR   CompanyName[PRODUCTINFO_COMPANYNAME_LENGTH];
    WCHAR   ProductID[PRODUCTINFO_PRODUCTID_LENGTH];
} PRODUCT_INFOW;
#ifdef UNICODE
typedef PRODUCT_INFOW   PRODUCT_INFO;
#else
typedef PRODUCT_INFOA   PRODUCT_INFO;
#endif

/* WTS validation information */
typedef struct _WTS_VALIDATION_INFORMATIONA {
    PRODUCT_INFOA   ProductInfo;
    BYTE            License[VALIDATIONINFORMATION_LICENSE_LENGTH];
    DWORD           LicenseLength;
    BYTE            HardwareID[VALIDATIONINFORMATION_HARDWAREID_LENGTH];
    DWORD           HardwareIDLength;
} WTS_VALIDATION_INFORMATIONA;
typedef WTS_VALIDATION_INFORMATIONA     *PWTS_VALIDATION_INFORMATIONA;
typedef struct _WTS_VALIDATION_INFORMATIONW {
    PRODUCT_INFOW   ProductInfo;
    BYTE            License[VALIDATIONINFORMATION_LICENSE_LENGTH];
    DWORD           LicenseLength;
    BYTE            HardwareID[VALIDATIONINFORMATION_HARDWAREID_LENGTH];
    DWORD           HardwareIDLength;
} WTS_VALIDATION_INFORMATIONW;
typedef WTS_VALIDATION_INFORMATIONW     *PWTS_VALIDATION_INFORMATIONW;
#ifdef UNICODE
typedef WTS_VALIDATION_INFORMATIONW     WTS_VALIDATION_INFORMATION;
typedef PWTS_VALIDATION_INFORMATIONW    PWTS_VALIDATION_INFORMATION;
#else
typedef WTS_VALIDATION_INFORMATIONA     WTS_VALIDATION_INFORMATION;
typedef PWTS_VALIDATION_INFORMATIONA    PWTS_VALIDATION_INFORMATION;
#endif

/* WTS client address information */
typedef struct _WTS_CLIENT_ADDRESS {
    DWORD   AddressFamily;
    BYTE    Address[20];
} WTS_CLIENT_ADDRESS;
typedef WTS_CLIENT_ADDRESS  *PWTS_CLIENT_ADDRESS;

/* WTS client display information */
typedef struct _WTS_CLIENT_DISPLAY {
    DWORD   HorizontalResolution;
    DWORD   VerticalResolution;
    DWORD   ColorDepth;
} WTS_CLIENT_DISPLAY;
typedef WTS_CLIENT_DISPLAY  *PWTS_CLIENT_DISPLAY;

/* WTS configuration classes */
typedef enum _WTS_CONFIG_CLASS {
    WTSUserConfigInitialProgram                 = 0,
    WTSUserConfigWorkingDirectory               = 1,
    WTSUserConfigfInheritInitialProgram         = 2,
    WTSUserConfigfAllowLogonTerminalServer      = 3,
    WTSUserConfigTimeoutSettingsConnections     = 4,
    WTSUserConfigTimeoutSettingsDisconnections  = 5,
    WTSUserConfigTimeoutSettingsIdle            = 6,
    WTSUserConfigfDeviceClientDrives            = 7,
    WTSUserConfigfDeviceClientPrinters          = 8,
    WTSUserConfigfDeviceClientDefaultPrinter    = 9,
    WTSUserConfigBrokenTimeoutSettings          = 10,
    WTSUserConfigReconnectSettings              = 11,
    WTSUserConfigModemCallbackSettings          = 12,
    WTSUserConfigModemCallbackPhoneNumber       = 13,
    WTSUserConfigShadowingSettings              = 14,
    WTSUserConfigTerminalServerProfilePath      = 15,
    WTSUserConfigTerminalServerHomeDir          = 16,
    WTSUserConfigTerminalServerHomeDirDrive     = 17,
    WTSUserConfigfTerminalServerRemoteHomeDir   = 18,
    WTSUserConfigUser                           = 19
} WTS_CONFIG_CLASS;

/* WTS configuration sources */
typedef enum _WTS_CONFIG_SOURCE {
    WTSUserConfigSourceSAM  = 0
} WTS_CONFIG_SOURCE;

/* WTS user configuration */
typedef struct _WTSUSERCONFIGA {
    DWORD   Source;
    DWORD   InheritInitialProgram;
    DWORD   AllowLogonTerminalServer;
    DWORD   TimeoutSettingsConnections;
    DWORD   TimeoutSettingsDisconnections;
    DWORD   TimeoutSettingsIdle;
    DWORD   DeviceClientDrives;
    DWORD   DeviceClientPrinters;
    DWORD   ClientDefaultPrinter;
    DWORD   BrokenTimeoutSettings;
    DWORD   ReconnectSettings;
    DWORD   ShadowingSettings;
    DWORD   TerminalServerRemoteHomeDir;
    CHAR    InitialProgram[MAX_PATH + 1];
    CHAR    WorkDirectory[MAX_PATH + 1];
    CHAR    TerminalServerProfilePath[MAX_PATH + 1];
    CHAR    TerminalServerHomeDir[MAX_PATH + 1];
    CHAR    TerminalServerHomeDirDrive[WTS_DRIVE_LENGTH + 1];
} WTSUSERCONFIGA;
typedef WTSUSERCONFIGA  *PWTSUSERCONFIGA;
typedef struct _WTSUSERCONFIGW {
    DWORD   Source;
    DWORD   InheritInitialProgram;
    DWORD   AllowLogonTerminalServer;
    DWORD   TimeoutSettingsConnections;
    DWORD   TimeoutSettingsDisconnections;
    DWORD   TimeoutSettingsIdle;
    DWORD   DeviceClientDrives;
    DWORD   DeviceClientPrinters;
    DWORD   ClientDefaultPrinter;
    DWORD   BrokenTimeoutSettings;
    DWORD   ReconnectSettings;
    DWORD   ShadowingSettings;
    DWORD   TerminalServerRemoteHomeDir;
    WCHAR   InitialProgram[MAX_PATH + 1];
    WCHAR   WorkDirectory[MAX_PATH + 1];
    WCHAR   TerminalServerProfilePath[MAX_PATH + 1];
    WCHAR   TerminalServerHomeDir[MAX_PATH + 1];
    WCHAR   TerminalServerHomeDirDrive[WTS_DRIVE_LENGTH + 1];
} WTSUSERCONFIGW;
typedef WTSUSERCONFIGW  *PWTSUSERCONFIGW;
#ifdef UNICODE
typedef WTSUSERCONFIGW  WTSUSERCONFIG;
typedef PWTSUSERCONFIGW PWTSUSERCONFIG;
#else
typedef WTSUSERCONFIGA  WTSUSERCONFIG;
typedef PWTSUSERCONFIGA PWTSUSERCONFIG;
#endif

/* WTS virtual classes */
typedef enum _WTS_VIRTUAL_CLASS {
    WTSVirtualClientData    = 0,
    WTSVirtualFileHandle    = 1
} WTS_VIRTUAL_CLASS;

/* WTS session address */
typedef struct _WTS_SESSION_ADDRESS {
    DWORD   AddressFamily;
    BYTE    Address[20];
} WTS_SESSION_ADDRESS;
typedef WTS_SESSION_ADDRESS *PWTS_SESSION_ADDRESS;

/* WTS process information (extended version) */
typedef struct _WTS_PROCESS_INFO_EXA {
    DWORD           SessionId;
    DWORD           ProcessId;
    LPSTR           pProcessName;
    PSID            pUserSid;
    DWORD           NumberOfThreads;
    DWORD           HandleCount;
    DWORD           PagefileUsage;
    DWORD           PeakPagefileUsage;
    DWORD           WorkingSetSize;
    DWORD           PeakWorkingSetSize;
    LARGE_INTEGER   UserTime;
    LARGE_INTEGER   KernelTime;
} WTS_PROCESS_INFO_EXA;
typedef WTS_PROCESS_INFO_EXA    *PWTS_PROCESS_INFO_EXA;
typedef struct _WTS_PROCESS_INFO_EXW {
    DWORD           SessionId;
    DWORD           ProcessId;
    LPWSTR          pProcessName;
    PSID            pUserSid;
    DWORD           NumberOfThreads;
    DWORD           HandleCount;
    DWORD           PagefileUsage;
    DWORD           PeakPagefileUsage;
    DWORD           WorkingSetSize;
    DWORD           PeakWorkingSetSize;
    LARGE_INTEGER   UserTime;
    LARGE_INTEGER   KernelTime;
} WTS_PROCESS_INFO_EXW;
typedef WTS_PROCESS_INFO_EXW    *PWTS_PROCESS_INFO_EXW;
#ifdef UNICODE
typedef WTS_PROCESS_INFO_EXW    WTS_PROCESS_INFO_EX;
typedef PWTS_PROCESS_INFO_EXW   PWTS_PROCESS_INFO_EX;
#else
typedef WTS_PROCESS_INFO_EXA    WTS_PROCESS_INFO_EX;
typedef PWTS_PROCESS_INFO_EXA   PWTS_PROCESS_INFO_EX;
#endif

/* WTS type classes */
typedef enum _WTS_TYPE_CLASS {
    WTSTypeProcessInfoLevel0    = 0,
    WTSTypeProcessInfoLevel1    = 1,
    WTSTypeSessionInfoLevel1    = 2
} WTS_TYPE_CLASS;

/* WTS listener name */
typedef CHAR                WTSLISTENERNAMEA[WTS_LISTENER_NAME_LENGTH + 1];
typedef WTSLISTENERNAMEA    *PWTSLISTENERNAMEA;
typedef WCHAR               WTSLISTENERNAMEW[WTS_LISTENER_NAME_LENGTH + 1];
typedef WTSLISTENERNAMEW    *PWTSLISTENERNAMEW;
#ifdef UNICODE
typedef WTSLISTENERNAMEW    WTSLISTENERNAME;
typedef PWTSLISTENERNAMEW   PWTSLISTENERNAME;
#else
typedef WTSLISTENERNAMEA    WTSLISTENERNAME;
typedef PWTSLISTENERNAMEA   PWTSLISTENERNAME;
#endif

/* WTS listener configuration */
typedef struct _WTSLISTENERCONFIGA {
    ULONG   version;
    ULONG   fEnableListener;
    ULONG   MaxConnectionCount;
    ULONG   fPromptForPassword;
    ULONG   fInheritColorDepth;
    ULONG   ColorDepth;
    ULONG   fInheritBrokenTimeoutSettings;
    ULONG   BrokenTimeoutSettings;
    ULONG   fDisablePrinterRedirection;
    ULONG   fDisableDriveRedirection;
    ULONG   fDisableComPortRedirection;
    ULONG   fDisableLPTPortRedirection;
    ULONG   fDisableClipboardRedirection;
    ULONG   fDisableAudioRedirection;
    ULONG   fDisablePNPRedirection;
    ULONG   fDisableDefaultMainClientPrinter;
    ULONG   LanAdapter;
    ULONG   PortNumber;
    ULONG   fInheritShadowSettings;
    ULONG   ShadowSettings;
    ULONG   TimeoutSettingsConnection;
    ULONG   TimeoutSettingsDisconnection;
    ULONG   TimeoutSettingsIdle;
    ULONG   SecurityLayer;
    ULONG   MinEncryptionLevel;
    ULONG   UserAuthentication;
    CHAR    Comment[WTS_COMMENT_LENGTH + 1];
    CHAR    LogonUserName[USERNAME_LENGTH + 1];
    CHAR    LogonDomain[DOMAIN_LENGTH + 1];
    CHAR    WorkDirectory[MAX_PATH + 1];
    CHAR    InitialProgram[MAX_PATH + 1];
} WTSLISTENERCONFIGA;
typedef WTSLISTENERCONFIGA  *PWTSLISTENERCONFIGA;
typedef struct _WTSLISTENERCONFIGW {
    ULONG   version;
    ULONG   fEnableListener;
    ULONG   MaxConnectionCount;
    ULONG   fPromptForPassword;
    ULONG   fInheritColorDepth;
    ULONG   ColorDepth;
    ULONG   fInheritBrokenTimeoutSettings;
    ULONG   BrokenTimeoutSettings;
    ULONG   fDisablePrinterRedirection;
    ULONG   fDisableDriveRedirection;
    ULONG   fDisableComPortRedirection;
    ULONG   fDisableLPTPortRedirection;
    ULONG   fDisableClipboardRedirection;
    ULONG   fDisableAudioRedirection;
    ULONG   fDisablePNPRedirection;
    ULONG   fDisableDefaultMainClientPrinter;
    ULONG   LanAdapter;
    ULONG   PortNumber;
    ULONG   fInheritShadowSettings;
    ULONG   ShadowSettings;
    ULONG   TimeoutSettingsConnection;
    ULONG   TimeoutSettingsDisconnection;
    ULONG   TimeoutSettingsIdle;
    ULONG   SecurityLayer;
    ULONG   MinEncryptionLevel;
    ULONG   UserAuthentication;
    WCHAR   Comment[WTS_COMMENT_LENGTH + 1];
    WCHAR   LogonUserName[USERNAME_LENGTH + 1];
    WCHAR   LogonDomain[DOMAIN_LENGTH + 1];
    WCHAR   WorkDirectory[MAX_PATH + 1];
    WCHAR   InitialProgram[MAX_PATH + 1];
} WTSLISTENERCONFIGW;
typedef WTSLISTENERCONFIGW  *PWTSLISTENERCONFIGW;
#ifdef UNICODE
typedef WTSLISTENERCONFIGW  WTSLISTENERCONFIG;
typedef PWTSLISTENERCONFIGW PWTSLISTENERCONFIG;
#else
typedef WTSLISTENERCONFIGA  WTSLISTENERCONFIG;
typedef PWTSLISTENERCONFIGA PWTSLISTENERCONFIG;
#endif

/* Functions in WTSAPI32.DLL */
VOID WINAPI     WTSCloseServer( HANDLE );
BOOL WINAPI     WTSConnectSessionA( ULONG, ULONG, PSTR, BOOL );
BOOL WINAPI     WTSConnectSessionW( ULONG, ULONG, PWSTR, BOOL );
BOOL WINAPI     WTSCreateListenerA( HANDLE, PVOID, DWORD, LPSTR, PWTSLISTENERCONFIGA, DWORD );
BOOL WINAPI     WTSCreateListenerW( HANDLE, PVOID, DWORD, LPWSTR, PWTSLISTENERCONFIGW, DWORD );
BOOL WINAPI     WTSDisconnectSession( HANDLE, DWORD, BOOL );
BOOL WINAPI     WTSEnumerateListenersA( HANDLE, PVOID, DWORD, PWTSLISTENERNAMEA, DWORD * );
BOOL WINAPI     WTSEnumerateListenersW( HANDLE, PVOID, DWORD, PWTSLISTENERNAMEW, DWORD * );
BOOL WINAPI     WTSEnumerateProcessesA( HANDLE, DWORD, DWORD, PWTS_PROCESS_INFOA *, DWORD * );
BOOL WINAPI     WTSEnumerateProcessesExA( HANDLE, DWORD *, DWORD, LPSTR *, DWORD * );
BOOL WINAPI     WTSEnumerateProcessesExW( HANDLE, DWORD *, DWORD, LPWSTR *, DWORD * );
BOOL WINAPI     WTSEnumerateProcessesW( HANDLE, DWORD, DWORD, PWTS_PROCESS_INFOW *, DWORD * );
BOOL WINAPI     WTSEnumerateServersA( LPSTR, DWORD, DWORD, PWTS_SERVER_INFOA *, DWORD * );
BOOL WINAPI     WTSEnumerateServersW( LPWSTR, DWORD, DWORD, PWTS_SERVER_INFOW *, DWORD * );
BOOL WINAPI     WTSEnumerateSessionsA( HANDLE, DWORD, DWORD, PWTS_SESSION_INFOA *, DWORD * );
BOOL WINAPI     WTSEnumerateSessionsExA( HANDLE, DWORD *, DWORD, PWTS_SESSION_INFO_1A *, DWORD * );
BOOL WINAPI     WTSEnumerateSessionsExW( HANDLE, DWORD *, DWORD, PWTS_SESSION_INFO_1W *, DWORD * );
BOOL WINAPI     WTSEnumerateSessionsW( HANDLE, DWORD, DWORD, PWTS_SESSION_INFOW *, DWORD * );
VOID WINAPI     WTSFreeMemory( PVOID );
BOOL WINAPI     WTSFreeMemoryExA( WTS_TYPE_CLASS, PVOID, ULONG );
BOOL WINAPI     WTSFreeMemoryExW( WTS_TYPE_CLASS, PVOID, ULONG );
BOOL WINAPI     WTSGetListenerSecurityA( HANDLE, PVOID, DWORD, LPSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, LPDWORD );
BOOL WINAPI     WTSGetListenerSecurityW( HANDLE, PVOID, DWORD, LPWSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, LPDWORD );
BOOL WINAPI     WTSLogoffSession( HANDLE, DWORD, BOOL );
HANDLE WINAPI   WTSOpenServerA( LPSTR );
HANDLE WINAPI   WTSOpenServerExA( LPSTR );
HANDLE WINAPI   WTSOpenServerExW( LPWSTR );
HANDLE WINAPI   WTSOpenServerW( LPWSTR );
BOOL WINAPI     WTSQueryListenerConfigA( HANDLE, PVOID, DWORD, LPSTR, PWTSLISTENERCONFIGA );
BOOL WINAPI     WTSQueryListenerConfigW( HANDLE, PVOID, DWORD, LPWSTR, PWTSLISTENERCONFIGW );
BOOL WINAPI     WTSQuerySessionInformationA( HANDLE, DWORD, WTS_INFO_CLASS, LPSTR *, DWORD * );
BOOL WINAPI     WTSQuerySessionInformationW( HANDLE, DWORD, WTS_INFO_CLASS, LPWSTR *, DWORD * );
BOOL WINAPI     WTSQueryUserConfigA( LPSTR, LPSTR, WTS_CONFIG_CLASS, LPSTR *, DWORD * );
BOOL WINAPI     WTSQueryUserConfigW( LPWSTR, LPWSTR, WTS_CONFIG_CLASS, LPWSTR *, DWORD * );
BOOL WINAPI     WTSQueryUserToken( ULONG, PHANDLE );
BOOL WINAPI     WTSRegisterSessionNotification( HWND, DWORD );
BOOL WINAPI     WTSRegisterSessionNotificationEx( HANDLE, HWND, DWORD );
BOOL WINAPI     WTSSendMessageA( HANDLE, DWORD, LPSTR, DWORD, LPSTR, DWORD, DWORD, DWORD, DWORD *, BOOL );
BOOL WINAPI     WTSSendMessageW( HANDLE, DWORD, LPWSTR, DWORD, LPWSTR, DWORD, DWORD, DWORD, DWORD *, BOOL );
BOOL WINAPI     WTSSetListenerSecurityA( HANDLE, PVOID, DWORD, LPSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
BOOL WINAPI     WTSSetListenerSecurityW( HANDLE, PVOID, DWORD, LPWSTR, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
BOOL WINAPI     WTSSetUserConfigA( LPSTR, LPSTR, WTS_CONFIG_CLASS, LPSTR, DWORD );
BOOL WINAPI     WTSSetUserConfigW( LPWSTR, LPWSTR, WTS_CONFIG_CLASS, LPWSTR, DWORD );
BOOL WINAPI     WTSShutdownSystem( HANDLE, DWORD );
BOOL WINAPI     WTSStartRemoteControlSessionA( LPSTR, ULONG, BYTE, USHORT );
BOOL WINAPI     WTSStartRemoteControlSessionW( LPWSTR, ULONG, BYTE, USHORT );
BOOL WINAPI     WTSStopRemoteControlSession( ULONG );
BOOL WINAPI     WTSTerminateProcess( HANDLE, DWORD, DWORD );
BOOL WINAPI     WTSUnRegisterSessionNotification( HWND );
BOOL WINAPI     WTSUnRegisterSessionNotificationEx( HANDLE, HWND );
BOOL WINAPI     WTSVirtualChannelClose( HANDLE );
HANDLE WINAPI   WTSVirtualChannelOpen( HANDLE, DWORD, LPSTR );
HANDLE WINAPI   WTSVirtualChannelOpenEx( DWORD, LPSTR, DWORD );
BOOL WINAPI     WTSVirtualChannelPurgeInput( HANDLE );
BOOL WINAPI     WTSVirtualChannelPurgeOutput( HANDLE );
BOOL WINAPI     WTSVirtualChannelQuery( HANDLE, WTS_VIRTUAL_CLASS, PVOID *, DWORD * );
BOOL WINAPI     WTSVirtualChannelRead( HANDLE, ULONG, PCHAR, ULONG, PULONG );
BOOL WINAPI     WTSVirtualChannelWrite( HANDLE, PCHAR, ULONG, PULONG );
BOOL WINAPI     WTSWaitSystemEvent( HANDLE, DWORD, DWORD * );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define WTSConnectServer                WTSConnectServerW
    #define WTSCreateListener               WTSCreateListenerW
    #define WTSEnumerateListeners           WTSEnumerateListenersW
    #define WTSEnumerateProcesses           WTSEnumerateProcessesW
    #define WTSEnumerateProcessesEx         WTSEnumerateProcessesExW
    #define WTSEnumerateServers             WTSEnumerateServersW
    #define WTSEnumerateSessions            WTSEnumerateSessionsW
    #define WTSEnumerateSessionsEx          WTSEnumerateSessionsExW
    #define WTSFreeMemoryEx                 WTSFreeMemoryExW
    #define WTSGetListenerSecurity          WTSGetListenerSecurityW
    #define WTSOpenServer                   WTSOpenServerW
    #define WTSOpenServerEx                 WTSOpenServerExW
    #define WTSQueryListenerConfig          WTSQueryListenerConfigW
    #define WTSQuerySessionInformation      WTSQuerySessionInformationW
    #define WTSQueryUserConfig              WTSQueryUserConfigW
    #define WTSSendMessage                  WTSSendMessageW
    #define WTSSetListenerSecurity          WTSSetListenerSecurityW
    #define WTSSetUserConfig                WTSSetUserConfigW
    #define WTSStartRemoteControlSession    WTSStartRemoteControlSessionW
#else
    #define WTSConnectServer                WTSConnectServerA
    #define WTSCreateListener               WTSCreateListenerA
    #define WTSEnumerateListeners           WTSEnumerateListenersA
    #define WTSEnumerateProcesses           WTSEnumerateProcessesA
    #define WTSEnumerateProcessesEx         WTSEnumerateProcessesExA
    #define WTSEnumerateServers             WTSEnumerateServersA
    #define WTSEnumerateSessions            WTSEnumerateSessionsA
    #define WTSEnumerateSessionsEx          WTSEnumerateSessionsExA
    #define WTSFreeMemoryEx                 WTSFreeMemoryExA
    #define WTSGetListenerSecurity          WTSGetListenerSecurityA
    #define WTSOpenServer                   WTSOpenServerA
    #define WTSOpenServerEx                 WTSOpenServerExA
    #define WTSQueryListenerConfig          WTSQueryListenerConfigA
    #define WTSQuerySessionInformation      WTSQuerySessionInformationA
    #define WTSQueryUserConfig              WTSQueryUserConfigA
    #define WTSSendMessage                  WTSSendMessageA
    #define WTSSetListenerSecurity          WTSSetListenerSecurityA
    #define WTSSetUserConfig                WTSSetUserConfigA
    #define WTSStartRemoteControlSession    WTSStartRemoteControlSessionA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_WTSAPI */
