/*
 *  custcntl.h  Custom control definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_CUSTCNTL
#define _INC_CUSTCNTL

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef _INC_WINDOWS
    #include <windows.h>
#endif

#pragma pack( __push, 1 )

#ifdef __cplusplus
extern "C" {
#endif

#define CCINFOORD       2
#define CCSTYLEORD      3
#define CCFLAGSORD      4
#define CTLTYPES        12
#define CTLDESCR        22
#define CTLCLASS        20
#define CTLTITLE        94

/* Custom control style */
typedef struct tagCTLSTYLE {
    UINT    wX;
    UINT    wY;
    UINT    wCx;
    UINT    wCy;
    UINT    wId;
    DWORD   dwStyle;
    char    szClass[CTLCLASS];
    char    szTitle[CTLTITLE];
} CTLSTYLE;
typedef CTLSTYLE        *PCTLSTYLE;
typedef CTLSTYLE FAR    *LPCTLSTYLE;

/* Custom control type */
typedef struct tagCTLTYPE {
    UINT    wType;
    UINT    wWidth;
    UINT    wHeight;
    DWORD   dwStyle;
    char    szDescr[CTLDESCR];
} CTLTYPE;

/* Custom control information */
typedef struct tagCTLINFO {
    UINT    wVersion;
    UINT    wCtlTypes;
    char    szClass[CTLCLASS];
    char    szTitle[CTLTITLE];
    char    szReserved[10];
    CTLTYPE Type[CTLTYPES];
} CTLINFO;
typedef CTLINFO     *PCTLINFO;
typedef CTLINFO FAR *LPCTLINFO;

/* Custom control callbacks */
#ifdef STRICT
typedef DWORD   (CALLBACK *LPFNSTRTOID)( LPCSTR );
#else
typedef DWORD   (CALLBACK *LPFNSTRTOID)( LPSTR );
#endif
typedef UINT    (CALLBACK *LPFNIDTOSTR)( UINT, LPSTR, UINT );

#ifdef __cplusplus
} /* extern "C" */
#endif

#pragma pack( __pop )

#endif /* _INC_CUSTCNTL */
