/*
 *  shellapi.h  Shell functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_SHELLAPI
#define _INC_SHELLAPI

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef _INC_WINDOWS
    #include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 1 )

/* Drop handle data type */
DECLARE_HANDLE(HDROP);

/* Key handle data types */
#ifndef RC_INVOKED
typedef DWORD       HKEY;
typedef HKEY FAR    *PHKEY;
#endif

/* Registry error codes */
#define ERROR_SUCCESS           0L
#define ERROR_BADDB             1L
#define ERROR_BADKEY            2L
#define ERROR_CANTOPEN          3L
#define ERROR_CANTREAD          4L
#define ERROR_CANTWRITE         5L
#define ERROR_OUTOFMEMORY       6L
#define ERROR_INVALID_PARAMETER 7L
#define ERROR_ACCESS_DENIED     8L

/* Registry value types */
#define REG_SZ  1

/* Special key handles */
#define HKEY_CLASSES_ROOT   1

/* ShellExecute() error codes */
#define SE_ERR_SHARE            26
#define SE_ERR_ASSOCINCOMPLETE  27
#define SE_ERR_DDETIMEOUT       28
#define SE_ERR_DDEFAIL          29
#define SE_ERR_DDEBUSY          30
#define SE_ERR_NOASSOC          31

#ifndef RC_INVOKED

/* Functions in SHELL.DLL */
void WINAPI         DragAcceptFiles( HWND, BOOL );
void WINAPI         DragFinish( HDROP );
UINT WINAPI         DragQueryFile( HDROP, UINT, LPSTR, UINT );
BOOL WINAPI         DragQueryPoint( HDROP, POINT FAR * );
HICON WINAPI        ExtractIcon( HINSTANCE, LPCSTR, UINT );
HINSTANCE WINAPI    FindExecutable( LPCSTR, LPCSTR, LPSTR );
LONG WINAPI         RegCloseKey( HKEY );
LONG WINAPI         RegCreateKey( HKEY, LPCSTR, PHKEY );
LONG WINAPI         RegDeleteKey( HKEY, LPCSTR );
LONG WINAPI         RegEnumKey( HKEY, DWORD, LPSTR, DWORD );
LONG WINAPI         RegOpenKey( HKEY, LPCSTR, PHKEY );
LONG WINAPI         RegQueryValue( HKEY, LPCSTR, LPSTR, LPLONG );
LONG WINAPI         RegSetValue( HKEY, LPCSTR, DWORD, LPCSTR, DWORD );
HINSTANCE WINAPI    ShellExecute( HWND, LPCSTR, LPCSTR, LPCSTR, LPCSTR, int );

#endif /* RC_INVOKED */

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_SHELLAPI */
