/*
 *  arch/i386/sys/stat.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

/* 
 *  POSIX 1003.1 types
 */
#ifndef _DEV_T_DEFINED_
 #define _DEV_T_DEFINED_
 typedef unsigned long  dev_t;  /* Combination of node and device   */
#endif
#ifndef _INO_T_DEFINED_
 #define _INO_T_DEFINED_
 typedef unsigned long  ino_t;  /* Used for file serial numbers     */
#endif
#ifndef _MODE_T_DEFINED_
 #define _MODE_T_DEFINED_
 typedef unsigned short mode_t; /* Used for some file attributes    */
#endif
#ifndef _NLINK_T_DEFINED_
 #define _NLINK_T_DEFINED_
 typedef unsigned short nlink_t;/* Used for link counts             */
#endif
#ifndef _UID_T_DEFINED_
 #define _UID_T_DEFINED_
 typedef unsigned short uid_t;  /* Used for user IDs                */
#endif
#ifndef _GID_T_DEFINED_
 #define _GID_T_DEFINED_
 typedef unsigned short gid_t;  /* Used for group IDs               */
#endif
#ifndef _BLKSIZE_T_DEFINED_
 #define _BLKSIZE_T_DEFINED_
 typedef unsigned long  blksize_t;
#endif
#ifndef _BLKCNT_T_DEFINED_
 #define _BLKCNT_T_DEFINED_
 typedef unsigned long  blkcnt_t;
#endif

struct stat {
    dev_t          st_dev;
    ino_t          st_ino;
    mode_t         st_mode;
    nlink_t        st_nlink;
    uid_t          st_uid;
    gid_t          st_gid;
    dev_t          st_rdev;
    off_t          st_size;
    blksize_t      st_blksize;
    blkcnt_t       st_blocks;
    time_t         st_atime;
    unsigned long  st_atime_nsec;
    time_t         st_mtime;
    unsigned long  st_mtime_nsec;
    time_t         st_ctime;
    unsigned long  st_ctime_nsec;
    unsigned long  __unused4;
    unsigned long  __unused5;
};

/* This matches struct stat64 in glibc2.1, hence the absolutely
 * insane amounts of padding around dev_t's.
 */
struct stat64 {
    unsigned long long      st_dev;
    unsigned char           __pad0[4];
#define STAT64_HAS_BROKEN_ST_INO        1
    ino_t                   __st_ino;
    unsigned int            st_mode;
    unsigned int            st_nlink;
    unsigned long           st_uid;
    unsigned long           st_gid;
    unsigned long long      st_rdev;
    unsigned char           __pad3[4];
    long long               st_size;
    unsigned long           st_blksize;
    unsigned long           st_blocks;  /* Number 512-byte blocks allocated. */
    unsigned long           __pad4;     /* future possible st_blocks high bits */
    time_t                  st_atime;
    unsigned long           st_atime_nsec;
    time_t                  st_mtime;
    unsigned int            st_mtime_nsec;
    time_t                  st_ctime;
    unsigned long           st_ctime_nsec;
    unsigned long long      st_ino;
};

/* Tell code we have these members.  */
#define _STATBUF_ST_BLKSIZE
#define _STATBUF_ST_RDEV

#define STAT_HAVE_NSEC 1
